/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Binder;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.app.IUsageStats;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.PkgUsageStats;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UsageStatsService
extends IUsageStats.Stub {
    public static final String SERVICE_NAME = "usagestats";
    private static final boolean localLOGV = false;
    private static final boolean REPORT_UNEXPECTED = false;
    private static final String TAG = "UsageStats";
    private static final int VERSION = 1007;
    private static final int CHECKIN_VERSION = 4;
    private static final String FILE_PREFIX = "usage-";
    private static final String FILE_HISTORY = "usage-history.xml";
    private static final int FILE_WRITE_INTERVAL = 1800000;
    private static final int MAX_NUM_FILES = 5;
    private static final int NUM_LAUNCH_TIME_BINS = 10;
    private static final int[] LAUNCH_TIME_BINS = new int[]{250, 500, 750, 1000, 1500, 2000, 3000, 4000, 5000};
    static IUsageStats sService;
    private Context mContext;
    private final Map<String, PkgUsageStatsExtended> mStats;
    private final Map<String, Map<String, Long>> mLastResumeTimes;
    private PackageMonitor mPackageMonitor;
    final Object mStatsLock;
    final Object mFileLock;
    private String mLastResumedPkg;
    private String mLastResumedComp;
    private boolean mIsResumed;
    private File mFile;
    private AtomicFile mHistoryFile;
    private String mFileLeaf;
    private File mDir;
    private Calendar mCal;
    private final AtomicInteger mLastWriteDay = new AtomicInteger(-1);
    private final AtomicLong mLastWriteElapsedTime = new AtomicLong(0L);
    private final AtomicBoolean mUnforcedDiskWriteRunning = new AtomicBoolean(false);

    UsageStatsService(String dir) {
        this.mStats = new HashMap<String, PkgUsageStatsExtended>();
        this.mLastResumeTimes = new HashMap<String, Map<String, Long>>();
        this.mStatsLock = new Object();
        this.mFileLock = new Object();
        this.mDir = new File(dir);
        this.mCal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        this.mDir.mkdir();
        File parentDir = this.mDir.getParentFile();
        String[] fList = parentDir.list();
        if (fList != null) {
            String prefix = this.mDir.getName() + ".";
            int i = fList.length;
            while (i > 0) {
                if (!fList[--i].startsWith(prefix)) continue;
                Slog.i((String)TAG, (String)("Deleting old usage file: " + fList[i]));
                new File(parentDir, fList[i]).delete();
            }
        }
        this.mFileLeaf = this.getCurrentDateStr(FILE_PREFIX);
        this.mFile = new File(this.mDir, this.mFileLeaf);
        this.mHistoryFile = new AtomicFile(new File(this.mDir, FILE_HISTORY));
        this.readStatsFromFile();
        this.readHistoryStatsFromFile();
        this.mLastWriteElapsedTime.set(SystemClock.elapsedRealtime());
        this.mLastWriteDay.set(this.mCal.get(6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentDateStr(String prefix) {
        StringBuilder sb = new StringBuilder();
        Calendar calendar = this.mCal;
        synchronized (calendar) {
            this.mCal.setTimeInMillis(System.currentTimeMillis());
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(this.mCal.get(1));
            int mm = this.mCal.get(2) - 0 + 1;
            if (mm < 10) {
                sb.append("0");
            }
            sb.append(mm);
            int dd = this.mCal.get(5);
            if (dd < 10) {
                sb.append("0");
            }
            sb.append(dd);
        }
        return sb.toString();
    }

    private Parcel getParcelForFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        byte[] raw = UsageStatsService.readFully(stream);
        Parcel in = Parcel.obtain();
        in.unmarshall(raw, 0, raw.length);
        in.setDataPosition(0);
        stream.close();
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStatsFromFile() {
        File newFile = this.mFile;
        Object object = this.mFileLock;
        synchronized (object) {
            try {
                if (newFile.exists()) {
                    this.readStatsFLOCK(newFile);
                } else {
                    this.checkFileLimitFLOCK();
                    newFile.createNewFile();
                }
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("Error : " + e + " reading data from file:" + newFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStatsFLOCK(File file) throws IOException {
        Parcel in = this.getParcelForFile(file);
        int vers = in.readInt();
        if (vers != 1007) {
            Slog.w((String)TAG, (String)"Usage stats version changed; dropping");
            return;
        }
        for (int N = in.readInt(); N > 0; --N) {
            String pkgName = in.readString();
            if (pkgName == null) break;
            PkgUsageStatsExtended pus = new PkgUsageStatsExtended(in);
            Object object = this.mStatsLock;
            synchronized (object) {
                this.mStats.put(pkgName, pus);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoryStatsFromFile() {
        Object object = this.mFileLock;
        synchronized (object) {
            if (this.mHistoryFile.getBaseFile().exists()) {
                this.readHistoryStatsFLOCK(this.mHistoryFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoryStatsFLOCK(AtomicFile file) {
        block26: {
            FileInputStream fis = null;
            try {
                fis = this.mHistoryFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"usage-history".equals(tagName)) break block26;
                String pkg = null;
                do {
                    if ((eventType = parser.next()) == 2) {
                        tagName = parser.getName();
                        int depth = parser.getDepth();
                        if ("pkg".equals(tagName) && depth == 2) {
                            pkg = parser.getAttributeValue(null, "name");
                            continue;
                        }
                        if (!"comp".equals(tagName) || depth != 3 || pkg == null) continue;
                        String comp = parser.getAttributeValue(null, "name");
                        String lastResumeTimeStr = parser.getAttributeValue(null, "lrt");
                        if (comp == null || lastResumeTimeStr == null) continue;
                        try {
                            long lastResumeTime = Long.parseLong(lastResumeTimeStr);
                            Object object = this.mStatsLock;
                            synchronized (object) {
                                Map<String, Long> lrt = this.mLastResumeTimes.get(pkg);
                                if (lrt == null) {
                                    lrt = new HashMap<String, Long>();
                                    this.mLastResumeTimes.put(pkg, lrt);
                                }
                                lrt.put(comp, lastResumeTime);
                            }
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (eventType != 3 || !"pkg".equals(parser.getName())) continue;
                    pkg = null;
                } while (eventType != 1);
            }
            catch (XmlPullParserException e) {
                Slog.w((String)TAG, (String)("Error reading history stats: " + (Object)((Object)e)));
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("Error reading history stats: " + e));
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private ArrayList<String> getUsageStatsFileListFLOCK() {
        String[] fList = this.mDir.list();
        if (fList == null) {
            return null;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        for (String file : fList) {
            if (!file.startsWith(FILE_PREFIX)) continue;
            if (file.endsWith(".bak")) {
                new File(this.mDir, file).delete();
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    private void checkFileLimitFLOCK() {
        ArrayList<String> fileList = this.getUsageStatsFileListFLOCK();
        if (fileList == null) {
            return;
        }
        int count = fileList.size();
        if (count <= 5) {
            return;
        }
        Collections.sort(fileList);
        count -= 5;
        for (int i = 0; i < count; ++i) {
            String fileName = fileList.get(i);
            File file = new File(this.mDir, fileName);
            Slog.i((String)TAG, (String)("Deleting usage file : " + fileName));
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsToFile(boolean force, boolean forceWriteHistoryStats) {
        int curDay;
        Calendar calendar = this.mCal;
        synchronized (calendar) {
            this.mCal.setTimeInMillis(System.currentTimeMillis());
            curDay = this.mCal.get(6);
        }
        boolean dayChanged = curDay != this.mLastWriteDay.get();
        long currElapsedTime = SystemClock.elapsedRealtime();
        if (!force) {
            if (!dayChanged && currElapsedTime - this.mLastWriteElapsedTime.get() < 1800000L) {
                return;
            }
            if (this.mUnforcedDiskWriteRunning.compareAndSet(false, true)) {
                new Thread("UsageStatsService_DiskWriter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            UsageStatsService.this.writeStatsToFile(true, false);
                        }
                        finally {
                            UsageStatsService.this.mUnforcedDiskWriteRunning.set(false);
                        }
                    }
                }.start();
            }
            return;
        }
        Object object = this.mFileLock;
        synchronized (object) {
            block21: {
                this.mFileLeaf = this.getCurrentDateStr(FILE_PREFIX);
                File backupFile = null;
                if (this.mFile != null && this.mFile.exists()) {
                    backupFile = new File(this.mFile.getPath() + ".bak");
                    if (!backupFile.exists()) {
                        if (!this.mFile.renameTo(backupFile)) {
                            Slog.w((String)TAG, (String)"Failed to persist new stats");
                            return;
                        }
                    } else {
                        this.mFile.delete();
                    }
                }
                try {
                    this.writeStatsFLOCK(this.mFile);
                    this.mLastWriteElapsedTime.set(currElapsedTime);
                    if (dayChanged) {
                        this.mLastWriteDay.set(curDay);
                        Map<String, PkgUsageStatsExtended> map = this.mStats;
                        synchronized (map) {
                            this.mStats.clear();
                        }
                        this.mFile = new File(this.mDir, this.mFileLeaf);
                        this.checkFileLimitFLOCK();
                    }
                    if (dayChanged || forceWriteHistoryStats) {
                        this.writeHistoryStatsFLOCK(this.mHistoryFile);
                    }
                    if (backupFile != null) {
                        backupFile.delete();
                    }
                }
                catch (IOException e) {
                    Slog.w((String)TAG, (String)("Failed writing stats to file:" + this.mFile));
                    if (backupFile == null) break block21;
                    this.mFile.delete();
                    backupFile.renameTo(this.mFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsFLOCK(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Parcel out = Parcel.obtain();
            this.writeStatsToParcelFLOCK(out);
            stream.write(out.marshall());
            out.recycle();
            stream.flush();
        }
        finally {
            FileUtils.sync((FileOutputStream)stream);
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsToParcelFLOCK(Parcel out) {
        Object object = this.mStatsLock;
        synchronized (object) {
            out.writeInt(1007);
            Set<String> keys = this.mStats.keySet();
            out.writeInt(keys.size());
            for (String key : keys) {
                PkgUsageStatsExtended pus = this.mStats.get(key);
                out.writeString(key);
                pus.writeToParcel(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterHistoryStats() {
        Object object = this.mStatsLock;
        synchronized (object) {
            HashMap<String, Map<String, Long>> tmpLastResumeTimes = new HashMap<String, Map<String, Long>>(this.mLastResumeTimes);
            this.mLastResumeTimes.clear();
            for (PackageInfo info : this.mContext.getPackageManager().getInstalledPackages(0)) {
                if (!tmpLastResumeTimes.containsKey(info.packageName)) continue;
                this.mLastResumeTimes.put(info.packageName, (Map<String, Long>)tmpLastResumeTimes.get(info.packageName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistoryStatsFLOCK(AtomicFile historyFile) {
        block7: {
            FileOutputStream fos = null;
            try {
                fos = historyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput((OutputStream)fos, "utf-8");
                out.startDocument(null, Boolean.valueOf(true));
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "usage-history");
                Object object = this.mStatsLock;
                synchronized (object) {
                    for (Map.Entry<String, Map<String, Long>> pkgEntry : this.mLastResumeTimes.entrySet()) {
                        out.startTag(null, "pkg");
                        out.attribute(null, "name", pkgEntry.getKey());
                        for (Map.Entry<String, Long> compEntry : pkgEntry.getValue().entrySet()) {
                            out.startTag(null, "comp");
                            out.attribute(null, "name", compEntry.getKey());
                            out.attribute(null, "lrt", compEntry.getValue().toString());
                            out.endTag(null, "comp");
                        }
                        out.endTag(null, "pkg");
                    }
                }
                out.endTag(null, "usage-history");
                out.endDocument();
                historyFile.finishWrite(fos);
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("Error writing history stats" + e));
                if (fos == null) break block7;
                historyFile.failWrite(fos);
            }
        }
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService((String)SERVICE_NAME, (IBinder)this.asBinder());
    }

    public void monitorPackages() {
        this.mPackageMonitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPackageRemoved(String packageName, int uid) {
                Object object = UsageStatsService.this.mStatsLock;
                synchronized (object) {
                    UsageStatsService.this.mLastResumeTimes.remove(packageName);
                }
            }
        };
        this.mPackageMonitor.register(this.mContext, true);
        this.filterHistoryStats();
    }

    public void shutdown() {
        if (this.mPackageMonitor != null) {
            this.mPackageMonitor.unregister();
        }
        Slog.i((String)TAG, (String)"Writing usage stats before shutdown...");
        this.writeStatsToFile(true, true);
    }

    public static IUsageStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService((String)SERVICE_NAME);
        sService = UsageStatsService.asInterface((IBinder)b);
        return sService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteResumeComponent(ComponentName componentName) {
        this.enforceCallingPermission();
        Object object = this.mStatsLock;
        synchronized (object) {
            Map<String, Long> componentResumeTimes;
            PkgUsageStatsExtended pus;
            String pkgName;
            if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
                return;
            }
            boolean samePackage = pkgName.equals(this.mLastResumedPkg);
            if (this.mIsResumed && this.mLastResumedPkg != null && (pus = this.mStats.get(this.mLastResumedPkg)) != null) {
                pus.updatePause();
            }
            boolean sameComp = samePackage && componentName.getClassName().equals(this.mLastResumedComp);
            this.mIsResumed = true;
            this.mLastResumedPkg = pkgName;
            this.mLastResumedComp = componentName.getClassName();
            PkgUsageStatsExtended pus2 = this.mStats.get(pkgName);
            if (pus2 == null) {
                pus2 = new PkgUsageStatsExtended();
                this.mStats.put(pkgName, pus2);
            }
            pus2.updateResume(this.mLastResumedComp, !samePackage);
            if (!sameComp) {
                pus2.addLaunchCount(this.mLastResumedComp);
            }
            if ((componentResumeTimes = this.mLastResumeTimes.get(pkgName)) == null) {
                componentResumeTimes = new HashMap<String, Long>();
                this.mLastResumeTimes.put(pkgName, componentResumeTimes);
            }
            componentResumeTimes.put(this.mLastResumedComp, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePauseComponent(ComponentName componentName) {
        this.enforceCallingPermission();
        Object object = this.mStatsLock;
        synchronized (object) {
            String pkgName;
            if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
                return;
            }
            if (!this.mIsResumed) {
                return;
            }
            this.mIsResumed = false;
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            if (pus == null) {
                Slog.i((String)TAG, (String)("No package stats for pkg:" + pkgName));
                return;
            }
            pus.updatePause();
        }
        this.writeStatsToFile(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteLaunchTime(ComponentName componentName, int millis) {
        String pkgName;
        this.enforceCallingPermission();
        if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
            return;
        }
        this.writeStatsToFile(false, false);
        Object object = this.mStatsLock;
        synchronized (object) {
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            if (pus != null) {
                pus.addLaunchTime(componentName.getClassName(), millis);
            }
        }
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PkgUsageStats getPkgUsageStats(ComponentName componentName) {
        String pkgName;
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
            return null;
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            Map<String, Long> lastResumeTimes = this.mLastResumeTimes.get(pkgName);
            if (pus == null && lastResumeTimes == null) {
                return null;
            }
            int launchCount = pus != null ? pus.mLaunchCount : 0;
            long usageTime = pus != null ? pus.mUsageTime : 0L;
            return new PkgUsageStats(pkgName, launchCount, usageTime, lastResumeTimes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PkgUsageStats[] getAllPkgUsageStats() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        Object object = this.mStatsLock;
        synchronized (object) {
            int size = this.mLastResumeTimes.size();
            if (size <= 0) {
                return null;
            }
            PkgUsageStats[] retArr = new PkgUsageStats[size];
            int i = 0;
            for (Map.Entry<String, Map<String, Long>> entry : this.mLastResumeTimes.entrySet()) {
                String pkg = entry.getKey();
                long usageTime = 0L;
                int launchCount = 0;
                PkgUsageStatsExtended pus = this.mStats.get(pkg);
                if (pus != null) {
                    usageTime = pus.mUsageTime;
                    launchCount = pus.mLaunchCount;
                }
                retArr[i] = new PkgUsageStats(pkg, launchCount, usageTime, entry.getValue());
                ++i;
            }
            return retArr;
        }
    }

    static byte[] readFully(FileInputStream stream) throws IOException {
        int pos = 0;
        int avail = stream.available();
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy(data, 0, newData, 0, pos);
            data = newData;
        }
        return data;
    }

    private void collectDumpInfoFLOCK(PrintWriter pw, boolean isCompactOutput, boolean deleteAfterPrint, HashSet<String> packages) {
        ArrayList<String> fileList = this.getUsageStatsFileListFLOCK();
        if (fileList == null) {
            return;
        }
        Collections.sort(fileList);
        for (String file : fileList) {
            if (deleteAfterPrint && file.equalsIgnoreCase(this.mFileLeaf)) continue;
            File dFile = new File(this.mDir, file);
            String dateStr = file.substring(FILE_PREFIX.length());
            try {
                Parcel in = this.getParcelForFile(dFile);
                this.collectDumpInfoFromParcelFLOCK(in, pw, dateStr, isCompactOutput, packages);
                if (!deleteAfterPrint) continue;
                dFile.delete();
            }
            catch (FileNotFoundException e) {
                Slog.w((String)TAG, (String)("Failed with " + e + " when collecting dump info from file : " + file));
                return;
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("Failed with " + e + " when collecting dump info from file : " + file));
            }
        }
    }

    private void collectDumpInfoFromParcelFLOCK(Parcel in, PrintWriter pw, String date, boolean isCompactOutput, HashSet<String> packages) {
        StringBuilder sb = new StringBuilder(512);
        if (isCompactOutput) {
            sb.append("D:");
            sb.append(4);
            sb.append(',');
        } else {
            sb.append("Date: ");
        }
        sb.append(date);
        int vers = in.readInt();
        if (vers != 1007) {
            sb.append(" (old data version)");
            pw.println(sb.toString());
            return;
        }
        pw.println(sb.toString());
        int N = in.readInt();
        while (N > 0) {
            --N;
            String pkgName = in.readString();
            if (pkgName == null) break;
            sb.setLength(0);
            PkgUsageStatsExtended pus = new PkgUsageStatsExtended(in);
            if (packages == null || packages.contains(pkgName)) {
                int i;
                int NC;
                if (isCompactOutput) {
                    sb.append("P:");
                    sb.append(pkgName);
                    sb.append(',');
                    sb.append(pus.mLaunchCount);
                    sb.append(',');
                    sb.append(pus.mUsageTime);
                    sb.append('\n');
                    NC = pus.mLaunchTimes.size();
                    if (NC > 0) {
                        for (Map.Entry<String, TimeStats> ent : pus.mLaunchTimes.entrySet()) {
                            sb.append("A:");
                            String activity = ent.getKey();
                            if (activity.startsWith(pkgName)) {
                                sb.append('*');
                                sb.append(activity.substring(pkgName.length(), activity.length()));
                            } else {
                                sb.append(activity);
                            }
                            TimeStats times = ent.getValue();
                            sb.append(',');
                            sb.append(times.count);
                            for (i = 0; i < 10; ++i) {
                                sb.append(",");
                                sb.append(times.times[i]);
                            }
                            sb.append('\n');
                        }
                    }
                } else {
                    sb.append("  ");
                    sb.append(pkgName);
                    sb.append(": ");
                    sb.append(pus.mLaunchCount);
                    sb.append(" times, ");
                    sb.append(pus.mUsageTime);
                    sb.append(" ms");
                    sb.append('\n');
                    NC = pus.mLaunchTimes.size();
                    if (NC > 0) {
                        for (Map.Entry<String, TimeStats> ent : pus.mLaunchTimes.entrySet()) {
                            sb.append("    ");
                            sb.append(ent.getKey());
                            TimeStats times = ent.getValue();
                            sb.append(": ");
                            sb.append(times.count);
                            sb.append(" starts");
                            int lastBin = 0;
                            for (i = 0; i < 9; ++i) {
                                if (times.times[i] != 0) {
                                    sb.append(", ");
                                    sb.append(lastBin);
                                    sb.append('-');
                                    sb.append(LAUNCH_TIME_BINS[i]);
                                    sb.append("ms=");
                                    sb.append(times.times[i]);
                                }
                                lastBin = LAUNCH_TIME_BINS[i];
                            }
                            if (times.times[9] != 0) {
                                sb.append(", ");
                                sb.append(">=");
                                sb.append(lastBin);
                                sb.append("ms=");
                                sb.append(times.times[9]);
                            }
                            sb.append('\n');
                        }
                    }
                }
            }
            pw.write(sb.toString());
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    private static String scanArgsData(String[] args, String value) {
        if (args != null) {
            int N = args.length;
            for (int i = 0; i < N; ++i) {
                if (!value.equals(args[i])) continue;
                return ++i < N ? args[i] : null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UsageStats from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean isCheckinRequest = UsageStatsService.scanArgs(args, "--checkin");
        boolean isCompactOutput = isCheckinRequest || UsageStatsService.scanArgs(args, "-c");
        boolean deleteAfterPrint = isCheckinRequest || UsageStatsService.scanArgs(args, "-d");
        String rawPackages = UsageStatsService.scanArgsData(args, "--packages");
        if (!deleteAfterPrint) {
            this.writeStatsToFile(true, false);
        }
        HashSet<String> packages = null;
        if (rawPackages != null) {
            if (!"*".equals(rawPackages)) {
                String[] names;
                for (String n : names = rawPackages.split(",")) {
                    if (packages == null) {
                        packages = new HashSet<String>();
                    }
                    packages.add(n);
                }
            }
        } else if (isCheckinRequest) {
            Slog.w((String)TAG, (String)"Checkin without packages");
            return;
        }
        Object object = this.mFileLock;
        synchronized (object) {
            this.collectDumpInfoFLOCK(pw, isCompactOutput, deleteAfterPrint, packages);
        }
    }

    private class PkgUsageStatsExtended {
        final HashMap<String, TimeStats> mLaunchTimes = new HashMap();
        int mLaunchCount;
        long mUsageTime;
        long mPausedTime;
        long mResumedTime;

        PkgUsageStatsExtended() {
            this.mLaunchCount = 0;
            this.mUsageTime = 0L;
        }

        PkgUsageStatsExtended(Parcel in) {
            this.mLaunchCount = in.readInt();
            this.mUsageTime = in.readLong();
            int numTimeStats = in.readInt();
            for (int i = 0; i < numTimeStats; ++i) {
                String comp = in.readString();
                TimeStats times = new TimeStats(in);
                this.mLaunchTimes.put(comp, times);
            }
        }

        void updateResume(String comp, boolean launched) {
            if (launched) {
                ++this.mLaunchCount;
            }
            this.mResumedTime = SystemClock.elapsedRealtime();
        }

        void updatePause() {
            this.mPausedTime = SystemClock.elapsedRealtime();
            this.mUsageTime += this.mPausedTime - this.mResumedTime;
        }

        void addLaunchCount(String comp) {
            TimeStats times = this.mLaunchTimes.get(comp);
            if (times == null) {
                times = new TimeStats();
                this.mLaunchTimes.put(comp, times);
            }
            times.incCount();
        }

        void addLaunchTime(String comp, int millis) {
            TimeStats times = this.mLaunchTimes.get(comp);
            if (times == null) {
                times = new TimeStats();
                this.mLaunchTimes.put(comp, times);
            }
            times.add(millis);
        }

        void writeToParcel(Parcel out) {
            out.writeInt(this.mLaunchCount);
            out.writeLong(this.mUsageTime);
            int numTimeStats = this.mLaunchTimes.size();
            out.writeInt(numTimeStats);
            if (numTimeStats > 0) {
                for (Map.Entry<String, TimeStats> ent : this.mLaunchTimes.entrySet()) {
                    out.writeString(ent.getKey());
                    TimeStats times = ent.getValue();
                    times.writeToParcel(out);
                }
            }
        }

        void clear() {
            this.mLaunchTimes.clear();
            this.mLaunchCount = 0;
            this.mUsageTime = 0L;
        }
    }

    static class TimeStats {
        int count;
        int[] times = new int[10];

        TimeStats() {
        }

        void incCount() {
            ++this.count;
        }

        void add(int val) {
            int[] bins = LAUNCH_TIME_BINS;
            for (int i = 0; i < 9; ++i) {
                if (val >= bins[i]) continue;
                int n = i;
                this.times[n] = this.times[n] + 1;
                return;
            }
            this.times[9] = this.times[9] + 1;
        }

        TimeStats(Parcel in) {
            this.count = in.readInt();
            int[] localTimes = this.times;
            for (int i = 0; i < 10; ++i) {
                localTimes[i] = in.readInt();
            }
        }

        void writeToParcel(Parcel out) {
            out.writeInt(this.count);
            int[] localTimes = this.times;
            for (int i = 0; i < 10; ++i) {
                out.writeInt(localTimes[i]);
            }
        }
    }
}

