/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.hardware.usb.UsbManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkStatsService;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Binder;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.android.collect.Lists;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Tethering
extends INetworkManagementEventObserver.Stub {
    private Context mContext;
    private static final String TAG = "Tethering";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private String[] mTetherableUsbRegexs;
    private String[] mTetherableWifiRegexs;
    private String[] mTetherableBluetoothRegexs;
    private Collection<Integer> mUpstreamIfaceTypes;
    private Object mPublicSync;
    private static final Integer MOBILE_TYPE = new Integer(0);
    private static final Integer HIPRI_TYPE = new Integer(5);
    private static final Integer DUN_TYPE = new Integer(4);
    private int mPreferredUpstreamMobileApn = -1;
    private final INetworkManagementService mNMService;
    private final INetworkStatsService mStatsService;
    private final IConnectivityManager mConnService;
    private Looper mLooper;
    private HandlerThread mThread;
    private HashMap<String, TetherInterfaceSM> mIfaces;
    private BroadcastReceiver mStateReceiver;
    private static final String USB_NEAR_IFACE_ADDR = "192.168.42.129";
    private static final int USB_PREFIX_LENGTH = 24;
    private String[] mDhcpRange;
    private static final String[] DHCP_DEFAULT_RANGE = new String[]{"192.168.42.2", "192.168.42.254", "192.168.43.2", "192.168.43.254", "192.168.44.2", "192.168.44.254", "192.168.45.2", "192.168.45.254", "192.168.46.2", "192.168.46.254", "192.168.47.2", "192.168.47.254", "192.168.48.2", "192.168.48.254"};
    private String[] mDnsServers;
    private static final String DNS_DEFAULT_SERVER1 = "8.8.8.8";
    private static final String DNS_DEFAULT_SERVER2 = "8.8.4.4";
    private StateMachine mTetherMasterSM;
    private Notification mTetheredNotification;
    private boolean mRndisEnabled;
    private boolean mUsbTetherRequested;

    public Tethering(Context context, INetworkManagementService nmService, INetworkStatsService statsService, IConnectivityManager connService, Looper looper) {
        this.mContext = context;
        this.mNMService = nmService;
        this.mStatsService = statsService;
        this.mConnService = connService;
        this.mLooper = looper;
        this.mPublicSync = new Object();
        this.mIfaces = new HashMap();
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mLooper = this.mThread.getLooper();
        this.mTetherMasterSM = new TetherMasterSM("TetherMaster", this.mLooper);
        this.mTetherMasterSM.start();
        this.mStateReceiver = new StateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_STATE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mStateReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addAction("android.intent.action.MEDIA_UNSHARED");
        filter.addDataScheme("file");
        this.mContext.registerReceiver(this.mStateReceiver, filter);
        this.mDhcpRange = context.getResources().getStringArray(17235995);
        if (this.mDhcpRange.length == 0 || this.mDhcpRange.length % 2 == 1) {
            this.mDhcpRange = DHCP_DEFAULT_RANGE;
        }
        this.updateConfiguration();
        this.mDnsServers = new String[2];
        this.mDnsServers[0] = DNS_DEFAULT_SERVER1;
        this.mDnsServers[1] = DNS_DEFAULT_SERVER2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration() {
        String[] tetherableUsbRegexs = this.mContext.getResources().getStringArray(0x1070017);
        String[] tetherableWifiRegexs = this.mContext.getResources().getStringArray(17235992);
        String[] tetherableBluetoothRegexs = this.mContext.getResources().getStringArray(17235994);
        int[] ifaceTypes = this.mContext.getResources().getIntArray(17235997);
        ArrayList<Integer> upstreamIfaceTypes = new ArrayList<Integer>();
        for (int i : ifaceTypes) {
            upstreamIfaceTypes.add(new Integer(i));
        }
        Object object = this.mPublicSync;
        synchronized (object) {
            this.mTetherableUsbRegexs = tetherableUsbRegexs;
            this.mTetherableWifiRegexs = tetherableWifiRegexs;
            this.mTetherableBluetoothRegexs = tetherableBluetoothRegexs;
            this.mUpstreamIfaceTypes = upstreamIfaceTypes;
        }
        this.checkDunRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interfaceStatusChanged(String iface, boolean up) {
        boolean found = false;
        boolean usb = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            if (this.isWifi(iface)) {
                found = true;
            } else if (this.isUsb(iface)) {
                found = true;
                usb = true;
            } else if (this.isBluetooth(iface)) {
                found = true;
            }
            if (!found) {
                return;
            }
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (up) {
                if (sm == null) {
                    sm = new TetherInterfaceSM(iface, this.mLooper, usb);
                    this.mIfaces.put(iface, sm);
                    sm.start();
                }
            } else if (!this.isUsb(iface) && sm != null) {
                sm.sendMessage(4);
                this.mIfaces.remove(iface);
            }
        }
    }

    public void interfaceLinkStateChanged(String iface, boolean up) {
        this.interfaceStatusChanged(iface, up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsb(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableUsbRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWifi(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableWifiRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBluetooth(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableBluetoothRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interfaceAdded(String iface) {
        boolean found = false;
        boolean usb = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            if (this.isWifi(iface)) {
                found = true;
            }
            if (this.isUsb(iface)) {
                found = true;
                usb = true;
            }
            if (this.isBluetooth(iface)) {
                found = true;
            }
            if (!found) {
                return;
            }
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (sm != null) {
                return;
            }
            sm = new TetherInterfaceSM(iface, this.mLooper, usb);
            this.mIfaces.put(iface, sm);
            sm.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interfaceRemoved(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (sm == null) {
                return;
            }
            sm.sendMessage(4);
            this.mIfaces.remove(iface);
        }
    }

    public void limitReached(String limitName, String iface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tether(String iface) {
        Log.d((String)TAG, (String)("Tethering " + iface));
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
        }
        if (sm == null) {
            Log.e((String)TAG, (String)("Tried to Tether an unknown iface :" + iface + ", ignoring"));
            return 1;
        }
        if (!sm.isAvailable() && !sm.isErrored()) {
            Log.e((String)TAG, (String)("Tried to Tether an unavailable iface :" + iface + ", ignoring"));
            return 4;
        }
        sm.sendMessage(2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int untether(String iface) {
        Log.d((String)TAG, (String)("Untethering " + iface));
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
        }
        if (sm == null) {
            Log.e((String)TAG, (String)("Tried to Untether an unknown iface :" + iface + ", ignoring"));
            return 1;
        }
        if (sm.isErrored()) {
            Log.e((String)TAG, (String)("Tried to Untethered an errored iface :" + iface + ", ignoring"));
            return 4;
        }
        sm.sendMessage(3);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastTetherError(String iface) {
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
            if (sm == null) {
                Log.e((String)TAG, (String)("Tried to getLastTetherError on an unknown iface :" + iface + ", ignoring"));
                return 1;
            }
            return sm.getLastError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTetherStateChangedBroadcast() {
        try {
            if (!this.mConnService.isTetheringSupported()) {
                return;
            }
        }
        catch (RemoteException e) {
            return;
        }
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> activeList = new ArrayList<String>();
        ArrayList<String> erroredList = new ArrayList<String>();
        boolean wifiTethered = false;
        boolean usbTethered = false;
        boolean bluetoothTethered = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> ifaces = this.mIfaces.keySet();
            for (String iface : ifaces) {
                TetherInterfaceSM sm = this.mIfaces.get(iface);
                if (sm == null) continue;
                if (sm.isErrored()) {
                    erroredList.add(iface);
                    continue;
                }
                if (sm.isAvailable()) {
                    availableList.add(iface);
                    continue;
                }
                if (!sm.isTethered()) continue;
                if (this.isUsb(iface)) {
                    usbTethered = true;
                } else if (this.isWifi(iface)) {
                    wifiTethered = true;
                } else if (this.isBluetooth(iface)) {
                    bluetoothTethered = true;
                }
                activeList.add(iface);
            }
        }
        Intent broadcast = new Intent("android.net.conn.TETHER_STATE_CHANGED");
        broadcast.addFlags(0x30000000);
        broadcast.putStringArrayListExtra("availableArray", availableList);
        broadcast.putStringArrayListExtra("activeArray", activeList);
        broadcast.putStringArrayListExtra("erroredArray", erroredList);
        this.mContext.sendStickyBroadcast(broadcast);
        Log.d((String)TAG, (String)("sendTetherStateChangedBroadcast " + availableList.size() + ", " + activeList.size() + ", " + erroredList.size()));
        if (usbTethered) {
            if (wifiTethered || bluetoothTethered) {
                this.showTetheredNotification(17302836);
            } else {
                this.showTetheredNotification(17302837);
            }
        } else if (wifiTethered) {
            if (bluetoothTethered) {
                this.showTetheredNotification(17302836);
            } else {
                this.showTetheredNotification(17302838);
            }
        } else if (bluetoothTethered) {
            this.showTetheredNotification(17302835);
        } else {
            this.clearTetheredNotification();
        }
    }

    private void showTetheredNotification(int icon) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        if (this.mTetheredNotification != null) {
            if (this.mTetheredNotification.icon == icon) {
                return;
            }
            notificationManager.cancel(this.mTetheredNotification.icon);
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.TetherSettings");
        intent.setFlags(0x40000000);
        PendingIntent pi = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        Resources r = Resources.getSystem();
        CharSequence title = r.getText(17040461);
        CharSequence message = r.getText(17040462);
        if (this.mTetheredNotification == null) {
            this.mTetheredNotification = new Notification();
            this.mTetheredNotification.when = 0L;
        }
        this.mTetheredNotification.icon = icon;
        this.mTetheredNotification.defaults &= 0xFFFFFFFE;
        this.mTetheredNotification.flags = 2;
        this.mTetheredNotification.tickerText = title;
        this.mTetheredNotification.setLatestEventInfo(this.mContext, title, message, pi);
        notificationManager.notify(this.mTetheredNotification.icon, this.mTetheredNotification);
    }

    private void clearTetheredNotification() {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager != null && this.mTetheredNotification != null) {
            notificationManager.cancel(this.mTetheredNotification.icon);
            this.mTetheredNotification = null;
        }
    }

    private void tetherUsb(boolean enable) {
        String[] ifaces = new String[]{};
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error listing Interfaces", (Throwable)e);
            return;
        }
        for (String iface : ifaces) {
            int result;
            if (!this.isUsb(iface)) continue;
            int n = result = enable ? this.tether(iface) : this.untether(iface);
            if (result != 0) continue;
            return;
        }
        Log.e((String)TAG, (String)"unable start or stop USB tethering");
    }

    private boolean configureUsbIface(boolean enabled) {
        String[] ifaces = new String[]{};
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error listing Interfaces", (Throwable)e);
            return false;
        }
        for (String iface : ifaces) {
            if (!this.isUsb(iface)) continue;
            InterfaceConfiguration ifcg = null;
            try {
                ifcg = this.mNMService.getInterfaceConfig(iface);
                if (ifcg == null) continue;
                InetAddress addr = NetworkUtils.numericToInetAddress((String)USB_NEAR_IFACE_ADDR);
                ifcg.addr = new LinkAddress(addr, 24);
                ifcg.interfaceFlags = enabled ? ifcg.interfaceFlags.replace("down", "up") : ifcg.interfaceFlags.replace("up", "down");
                ifcg.interfaceFlags = ifcg.interfaceFlags.replace("running", "");
                ifcg.interfaceFlags = ifcg.interfaceFlags.replace("  ", " ");
                this.mNMService.setInterfaceConfig(iface, ifcg);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error configuring interface " + iface), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String[] getTetherableUsbRegexs() {
        return this.mTetherableUsbRegexs;
    }

    public String[] getTetherableWifiRegexs() {
        return this.mTetherableWifiRegexs;
    }

    public String[] getTetherableBluetoothRegexs() {
        return this.mTetherableBluetoothRegexs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setUsbTethering(boolean enable) {
        UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
        Object object = this.mPublicSync;
        synchronized (object) {
            if (enable) {
                if (this.mRndisEnabled) {
                    this.tetherUsb(true);
                } else {
                    this.mUsbTetherRequested = true;
                    usbManager.setCurrentFunction("rndis", false);
                }
            } else {
                this.tetherUsb(false);
                if (this.mRndisEnabled) {
                    usbManager.setCurrentFunction(null, false);
                }
                this.mUsbTetherRequested = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUpstreamIfaceTypes() {
        int[] values;
        Object object = this.mPublicSync;
        synchronized (object) {
            this.updateConfiguration();
            values = new int[this.mUpstreamIfaceTypes.size()];
            Iterator<Integer> iterator = this.mUpstreamIfaceTypes.iterator();
            for (int i = 0; i < this.mUpstreamIfaceTypes.size(); ++i) {
                values[i] = iterator.next();
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDunRequired() {
        int secureSetting = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"tether_dun_required", (int)2);
        Object object = this.mPublicSync;
        synchronized (object) {
            if (secureSetting != 2) {
                int requiredApn;
                int n = requiredApn = secureSetting == 1 ? 4 : 5;
                if (requiredApn == 4) {
                    while (this.mUpstreamIfaceTypes.contains(MOBILE_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(MOBILE_TYPE);
                    }
                    while (this.mUpstreamIfaceTypes.contains(HIPRI_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(HIPRI_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(DUN_TYPE)) {
                        this.mUpstreamIfaceTypes.add(DUN_TYPE);
                    }
                } else {
                    while (this.mUpstreamIfaceTypes.contains(DUN_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(DUN_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(MOBILE_TYPE)) {
                        this.mUpstreamIfaceTypes.add(MOBILE_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(HIPRI_TYPE)) {
                        this.mUpstreamIfaceTypes.add(HIPRI_TYPE);
                    }
                }
            }
            this.mPreferredUpstreamMobileApn = this.mUpstreamIfaceTypes.contains(DUN_TYPE) ? 4 : 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetheredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isTethered()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetheredIfacePairs() {
        ArrayList list = Lists.newArrayList();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (TetherInterfaceSM sm : this.mIfaces.values()) {
                if (!sm.isTethered()) continue;
                list.add(sm.mMyUpstreamIfaceName);
                list.add(sm.mIfaceName);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetherableIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isAvailable()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getErroredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isErrored()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    public void handleTetherIfaceChange() {
        this.mTetherMasterSM.sendMessage(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService.Tether from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mPublicSync;
        synchronized (object) {
            pw.println("mUpstreamIfaceTypes: ");
            for (Integer netType : this.mUpstreamIfaceTypes) {
                pw.println(" " + netType);
            }
            pw.println();
            pw.println("Tether state:");
            for (TetherInterfaceSM o : this.mIfaces.values()) {
                pw.println(" " + ((Object)((Object)o)).toString());
            }
        }
        pw.println();
    }

    class TetherMasterSM
    extends StateMachine {
        static final int CMD_TETHER_MODE_REQUESTED = 1;
        static final int CMD_TETHER_MODE_UNREQUESTED = 2;
        static final int CMD_UPSTREAM_CHANGED = 3;
        static final int CMD_CELL_CONNECTION_RENEW = 4;
        static final int CMD_RETRY_UPSTREAM = 5;
        private int mSequenceNumber;
        private State mInitialState;
        private State mTetherModeAliveState;
        private State mSetIpForwardingEnabledErrorState;
        private State mSetIpForwardingDisabledErrorState;
        private State mStartTetheringErrorState;
        private State mStopTetheringErrorState;
        private State mSetDnsForwardersErrorState;
        private ArrayList mNotifyList;
        private int mCurrentConnectionSequence;
        private int mMobileApnReserved;
        private String mUpstreamIfaceName;
        private static final int UPSTREAM_SETTLE_TIME_MS = 10000;
        private static final int CELL_CONNECTION_RENEW_MS = 40000;

        TetherMasterSM(String name, Looper looper) {
            super(name, looper);
            this.mMobileApnReserved = -1;
            this.mUpstreamIfaceName = null;
            this.mInitialState = new InitialState();
            this.addState(this.mInitialState);
            this.mTetherModeAliveState = new TetherModeAliveState();
            this.addState(this.mTetherModeAliveState);
            this.mSetIpForwardingEnabledErrorState = new SetIpForwardingEnabledErrorState();
            this.addState(this.mSetIpForwardingEnabledErrorState);
            this.mSetIpForwardingDisabledErrorState = new SetIpForwardingDisabledErrorState();
            this.addState(this.mSetIpForwardingDisabledErrorState);
            this.mStartTetheringErrorState = new StartTetheringErrorState();
            this.addState(this.mStartTetheringErrorState);
            this.mStopTetheringErrorState = new StopTetheringErrorState();
            this.addState(this.mStopTetheringErrorState);
            this.mSetDnsForwardersErrorState = new SetDnsForwardersErrorState();
            this.addState(this.mSetDnsForwardersErrorState);
            this.mNotifyList = new ArrayList();
            this.setInitialState(this.mInitialState);
        }

        class SetDnsForwardersErrorState
        extends ErrorState {
            SetDnsForwardersErrorState() {
            }

            public void enter() {
                Log.e((String)Tethering.TAG, (String)"Error in setDnsForwarders");
                this.notify(11);
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StopTetheringErrorState
        extends ErrorState {
            StopTetheringErrorState() {
            }

            public void enter() {
                Log.e((String)Tethering.TAG, (String)"Error in stopTethering");
                this.notify(10);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StartTetheringErrorState
        extends ErrorState {
            StartTetheringErrorState() {
            }

            public void enter() {
                Log.e((String)Tethering.TAG, (String)"Error in startTethering");
                this.notify(9);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class SetIpForwardingDisabledErrorState
        extends ErrorState {
            SetIpForwardingDisabledErrorState() {
            }

            public void enter() {
                Log.e((String)Tethering.TAG, (String)"Error in setIpForwardingDisabled");
                this.notify(8);
            }
        }

        class SetIpForwardingEnabledErrorState
        extends ErrorState {
            SetIpForwardingEnabledErrorState() {
            }

            public void enter() {
                Log.e((String)Tethering.TAG, (String)"Error in setIpForwardingEnabled");
                this.notify(7);
            }
        }

        class ErrorState
        extends State {
            int mErrorNotification;

            ErrorState() {
            }

            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 1: {
                        TetherInterfaceSM who = (TetherInterfaceSM)((Object)message.obj);
                        who.sendMessage(this.mErrorNotification);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }

            void notify(int msgType) {
                this.mErrorNotification = msgType;
                for (Object o : TetherMasterSM.this.mNotifyList) {
                    TetherInterfaceSM sm = (TetherInterfaceSM)((Object)o);
                    sm.sendMessage(msgType);
                }
            }
        }

        class TetherModeAliveState
        extends TetherMasterUtilState {
            boolean mTryCell;

            TetherModeAliveState() {
                this.mTryCell = true;
            }

            public void enter() {
                this.mTryCell = true;
                this.chooseUpstreamType(this.mTryCell);
                this.mTryCell = !this.mTryCell;
                this.turnOnMasterTetherSettings();
            }

            public void exit() {
                this.turnOffUpstreamMobileConnection();
                this.notifyTetheredOfNewUpstreamIface(null);
            }

            public boolean processMessage(Message message) {
                Log.d((String)Tethering.TAG, (String)("TetherModeAliveState.processMessage what=" + message.what));
                boolean retValue = true;
                switch (message.what) {
                    case 1: {
                        TetherInterfaceSM who = (TetherInterfaceSM)((Object)message.obj);
                        TetherMasterSM.this.mNotifyList.add(who);
                        who.sendMessage(12, TetherMasterSM.this.mUpstreamIfaceName);
                        break;
                    }
                    case 2: {
                        TetherInterfaceSM who = (TetherInterfaceSM)((Object)message.obj);
                        int index = TetherMasterSM.this.mNotifyList.indexOf((Object)who);
                        if (index == -1) break;
                        TetherMasterSM.this.mNotifyList.remove(index);
                        if (!TetherMasterSM.this.mNotifyList.isEmpty()) break;
                        this.turnOffMasterTetherSettings();
                        break;
                    }
                    case 3: {
                        this.mTryCell = true;
                        this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    case 4: {
                        if (TetherMasterSM.this.mCurrentConnectionSequence != message.arg1) break;
                        this.turnOnUpstreamMobileConnection(TetherMasterSM.this.mMobileApnReserved);
                        break;
                    }
                    case 5: {
                        this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends TetherMasterUtilState {
            InitialState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                Log.d((String)Tethering.TAG, (String)("MasterInitialState.processMessage what=" + message.what));
                boolean retValue = true;
                switch (message.what) {
                    case 1: {
                        TetherInterfaceSM who = (TetherInterfaceSM)((Object)message.obj);
                        TetherMasterSM.this.mNotifyList.add(who);
                        TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mTetherModeAliveState);
                        break;
                    }
                    case 2: {
                        TetherInterfaceSM who = (TetherInterfaceSM)((Object)message.obj);
                        int index = TetherMasterSM.this.mNotifyList.indexOf((Object)who);
                        if (index == -1) break;
                        TetherMasterSM.this.mNotifyList.remove((Object)who);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class TetherMasterUtilState
        extends State {
            protected static final boolean TRY_TO_SETUP_MOBILE_CONNECTION = true;
            protected static final boolean WAIT_FOR_NETWORK_TO_SETTLE = false;

            TetherMasterUtilState() {
            }

            public boolean processMessage(Message m) {
                return false;
            }

            protected String enableString(int apnType) {
                switch (apnType) {
                    case 4: {
                        return "enableDUNAlways";
                    }
                    case 0: 
                    case 5: {
                        return "enableHIPRI";
                    }
                }
                return null;
            }

            protected boolean turnOnUpstreamMobileConnection(int apnType) {
                boolean retValue = true;
                if (apnType == -1) {
                    return false;
                }
                if (apnType != TetherMasterSM.this.mMobileApnReserved) {
                    this.turnOffUpstreamMobileConnection();
                }
                int result = 3;
                String enableString = this.enableString(apnType);
                if (enableString == null) {
                    return false;
                }
                try {
                    result = Tethering.this.mConnService.startUsingNetworkFeature(0, enableString, (IBinder)new Binder());
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (result) {
                    case 0: 
                    case 1: {
                        TetherMasterSM.this.mMobileApnReserved = apnType;
                        Message m = TetherMasterSM.this.obtainMessage(4);
                        m.arg1 = ++TetherMasterSM.this.mCurrentConnectionSequence;
                        TetherMasterSM.this.sendMessageDelayed(m, 40000L);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }

            protected boolean turnOffUpstreamMobileConnection() {
                if (TetherMasterSM.this.mMobileApnReserved != -1) {
                    try {
                        Tethering.this.mConnService.stopUsingNetworkFeature(0, this.enableString(TetherMasterSM.this.mMobileApnReserved));
                    }
                    catch (Exception e) {
                        return false;
                    }
                    TetherMasterSM.this.mMobileApnReserved = -1;
                }
                return true;
            }

            protected boolean turnOnMasterTetherSettings() {
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(true);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mSetIpForwardingEnabledErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.startTethering(Tethering.this.mDhcpRange);
                }
                catch (Exception e) {
                    try {
                        Tethering.this.mNMService.stopTethering();
                        Tethering.this.mNMService.startTethering(Tethering.this.mDhcpRange);
                    }
                    catch (Exception ee) {
                        TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mStartTetheringErrorState);
                        return false;
                    }
                }
                try {
                    Tethering.this.mNMService.setDnsForwarders(Tethering.this.mDnsServers);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mSetDnsForwardersErrorState);
                    return false;
                }
                return true;
            }

            protected boolean turnOffMasterTetherSettings() {
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mStopTetheringErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mSetIpForwardingDisabledErrorState);
                    return false;
                }
                TetherMasterSM.this.transitionTo((IState)TetherMasterSM.this.mInitialState);
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void chooseUpstreamType(boolean tryCell) {
                int upType = -1;
                String iface = null;
                Tethering.this.updateConfiguration();
                Object object = Tethering.this.mPublicSync;
                synchronized (object) {
                    for (Integer netType : Tethering.this.mUpstreamIfaceTypes) {
                        NetworkInfo info = null;
                        try {
                            info = Tethering.this.mConnService.getNetworkInfo(netType.intValue());
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (info == null || !info.isConnected()) continue;
                        upType = netType;
                        break;
                    }
                }
                Log.d((String)Tethering.TAG, (String)("chooseUpstreamType(" + tryCell + "), preferredApn =" + Tethering.this.mPreferredUpstreamMobileApn + ", got type=" + upType));
                if (upType == 4 || upType == 5) {
                    this.turnOnUpstreamMobileConnection(upType);
                }
                if (upType == -1) {
                    boolean tryAgainLater = true;
                    if (tryCell && this.turnOnUpstreamMobileConnection(Tethering.this.mPreferredUpstreamMobileApn)) {
                        tryAgainLater = false;
                    }
                    if (tryAgainLater) {
                        TetherMasterSM.this.sendMessageDelayed(5, 10000L);
                    }
                } else {
                    LinkProperties linkProperties = null;
                    try {
                        linkProperties = Tethering.this.mConnService.getLinkProperties(upType);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (linkProperties != null) {
                        iface = linkProperties.getInterfaceName();
                    }
                }
                this.notifyTetheredOfNewUpstreamIface(iface);
            }

            protected void notifyTetheredOfNewUpstreamIface(String ifaceName) {
                Log.d((String)Tethering.TAG, (String)("notifying tethered with iface =" + ifaceName));
                TetherMasterSM.this.mUpstreamIfaceName = ifaceName;
                for (Object o : TetherMasterSM.this.mNotifyList) {
                    TetherInterfaceSM sm = (TetherInterfaceSM)((Object)o);
                    sm.sendMessage(12, ifaceName);
                }
            }
        }
    }

    class TetherInterfaceSM
    extends StateMachine {
        static final int CMD_TETHER_MODE_DEAD = 1;
        static final int CMD_TETHER_REQUESTED = 2;
        static final int CMD_TETHER_UNREQUESTED = 3;
        static final int CMD_INTERFACE_DOWN = 4;
        static final int CMD_INTERFACE_UP = 5;
        static final int CMD_CELL_DUN_ERROR = 6;
        static final int CMD_IP_FORWARDING_ENABLE_ERROR = 7;
        static final int CMD_IP_FORWARDING_DISABLE_ERROR = 8;
        static final int CMD_START_TETHERING_ERROR = 9;
        static final int CMD_STOP_TETHERING_ERROR = 10;
        static final int CMD_SET_DNS_FORWARDERS_ERROR = 11;
        static final int CMD_TETHER_CONNECTION_CHANGED = 12;
        private State mDefaultState;
        private State mInitialState;
        private State mStartingState;
        private State mTetheredState;
        private State mUnavailableState;
        private boolean mAvailable;
        private boolean mTethered;
        int mLastError;
        String mIfaceName;
        String mMyUpstreamIfaceName;
        boolean mUsb;

        TetherInterfaceSM(String name, Looper looper, boolean usb) {
            super(name, looper);
            this.mIfaceName = name;
            this.mUsb = usb;
            this.setLastError(0);
            this.mInitialState = new InitialState();
            this.addState(this.mInitialState);
            this.mStartingState = new StartingState();
            this.addState(this.mStartingState);
            this.mTetheredState = new TetheredState();
            this.addState(this.mTetheredState);
            this.mUnavailableState = new UnavailableState();
            this.addState(this.mUnavailableState);
            this.setInitialState(this.mInitialState);
        }

        public String toString() {
            String res = new String();
            res = res + this.mIfaceName + " - ";
            IState current = this.getCurrentState();
            if (current == this.mInitialState) {
                res = res + "InitialState";
            }
            if (current == this.mStartingState) {
                res = res + "StartingState";
            }
            if (current == this.mTetheredState) {
                res = res + "TetheredState";
            }
            if (current == this.mUnavailableState) {
                res = res + "UnavailableState";
            }
            if (this.mAvailable) {
                res = res + " - Available";
            }
            if (this.mTethered) {
                res = res + " - Tethered";
            }
            res = res + " - lastError =" + this.mLastError;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLastError() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mLastError;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setLastError(int error) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mLastError = error;
                if (this.isErrored() && this.mUsb) {
                    Tethering.this.configureUsbIface(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAvailable() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mAvailable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setAvailable(boolean available) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mAvailable = available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isTethered() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mTethered;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTethered(boolean tethered) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mTethered = tethered;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isErrored() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mLastError != 0;
            }
        }

        void setLastErrorAndTransitionToInitialState(int error) {
            this.setLastError(error);
            this.transitionTo((IState)this.mInitialState);
        }

        class UnavailableState
        extends State {
            UnavailableState() {
            }

            public void enter() {
                TetherInterfaceSM.this.setAvailable(false);
                TetherInterfaceSM.this.setLastError(0);
                TetherInterfaceSM.this.setTethered(false);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 5: {
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class TetheredState
        extends State {
            TetheredState() {
            }

            public void enter() {
                try {
                    Tethering.this.mNMService.tetherInterface(TetherInterfaceSM.this.mIfaceName);
                }
                catch (Exception e) {
                    Log.e((String)Tethering.TAG, (String)("Error Tethering: " + e.toString()));
                    TetherInterfaceSM.this.setLastError(6);
                    TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                    return;
                }
                Log.d((String)Tethering.TAG, (String)("Tethered " + TetherInterfaceSM.this.mIfaceName));
                TetherInterfaceSM.this.setAvailable(false);
                TetherInterfaceSM.this.setTethered(true);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            private void cleanupUpstream() {
                if (TetherInterfaceSM.this.mMyUpstreamIfaceName != null) {
                    try {
                        Tethering.this.mStatsService.forceUpdate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Tethering.this.mNMService.disableNat(TetherInterfaceSM.this.mIfaceName, TetherInterfaceSM.this.mMyUpstreamIfaceName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TetherInterfaceSM.this.mMyUpstreamIfaceName = null;
                }
            }

            public boolean processMessage(Message message) {
                Log.d((String)Tethering.TAG, (String)("TetheredState.processMessage what=" + message.what));
                boolean retValue = true;
                boolean error = false;
                switch (message.what) {
                    case 3: 
                    case 4: {
                        this.cleanupUpstream();
                        try {
                            Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                        }
                        catch (Exception e) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(7);
                            break;
                        }
                        Tethering.this.mTetherMasterSM.sendMessage(2, (Object)TetherInterfaceSM.this);
                        if (message.what == 3) {
                            if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                                TetherInterfaceSM.this.setLastError(10);
                            }
                            TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                        } else if (message.what == 4) {
                            TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mUnavailableState);
                        }
                        Log.d((String)Tethering.TAG, (String)("Untethered " + TetherInterfaceSM.this.mIfaceName));
                        break;
                    }
                    case 12: {
                        String newUpstreamIfaceName = (String)message.obj;
                        if (TetherInterfaceSM.this.mMyUpstreamIfaceName == null && newUpstreamIfaceName == null || TetherInterfaceSM.this.mMyUpstreamIfaceName != null && TetherInterfaceSM.this.mMyUpstreamIfaceName.equals(newUpstreamIfaceName)) break;
                        this.cleanupUpstream();
                        if (newUpstreamIfaceName != null) {
                            try {
                                Tethering.this.mNMService.enableNat(TetherInterfaceSM.this.mIfaceName, newUpstreamIfaceName);
                            }
                            catch (Exception e) {
                                Log.e((String)Tethering.TAG, (String)("Exception enabling Nat: " + e.toString()));
                                try {
                                    Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                                }
                                catch (Exception ee) {
                                    // empty catch block
                                }
                                TetherInterfaceSM.this.setLastError(8);
                                TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                                return true;
                            }
                        }
                        TetherInterfaceSM.this.mMyUpstreamIfaceName = newUpstreamIfaceName;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        error = true;
                    }
                    case 1: {
                        this.cleanupUpstream();
                        try {
                            Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                        }
                        catch (Exception e) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(7);
                            break;
                        }
                        if (error) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(5);
                            break;
                        }
                        Log.d((String)Tethering.TAG, (String)("Tether lost upstream connection " + TetherInterfaceSM.this.mIfaceName));
                        Tethering.this.sendTetherStateChangedBroadcast();
                        if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                            TetherInterfaceSM.this.setLastError(10);
                        }
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class StartingState
        extends State {
            StartingState() {
            }

            public void enter() {
                TetherInterfaceSM.this.setAvailable(false);
                if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(true)) {
                    Tethering.this.mTetherMasterSM.sendMessage(2, (Object)TetherInterfaceSM.this);
                    TetherInterfaceSM.this.setLastError(10);
                    TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                    return;
                }
                Tethering.this.sendTetherStateChangedBroadcast();
                TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mTetheredState);
            }

            public boolean processMessage(Message message) {
                Log.d((String)Tethering.TAG, (String)("StartingState.processMessage what=" + message.what));
                boolean retValue = true;
                switch (message.what) {
                    case 3: {
                        Tethering.this.mTetherMasterSM.sendMessage(2, (Object)TetherInterfaceSM.this);
                        if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(10);
                            break;
                        }
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(5);
                        break;
                    }
                    case 4: {
                        Tethering.this.mTetherMasterSM.sendMessage(2, (Object)TetherInterfaceSM.this);
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mUnavailableState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends State {
            InitialState() {
            }

            public void enter() {
                TetherInterfaceSM.this.setAvailable(true);
                TetherInterfaceSM.this.setTethered(false);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            public boolean processMessage(Message message) {
                Log.d((String)Tethering.TAG, (String)("InitialState.processMessage what=" + message.what));
                boolean retValue = true;
                switch (message.what) {
                    case 2: {
                        TetherInterfaceSM.this.setLastError(0);
                        Tethering.this.mTetherMasterSM.sendMessage(1, (Object)TetherInterfaceSM.this);
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mStartingState);
                        break;
                    }
                    case 4: {
                        TetherInterfaceSM.this.transitionTo((IState)TetherInterfaceSM.this.mUnavailableState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }
    }

    private class StateReceiver
    extends BroadcastReceiver {
        private StateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context content, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.hardware.usb.action.USB_STATE")) {
                Object object = Tethering.this.mPublicSync;
                synchronized (object) {
                    boolean usbConnected = intent.getBooleanExtra("connected", false);
                    Tethering.this.mRndisEnabled = intent.getBooleanExtra("rndis", false);
                    if (usbConnected && Tethering.this.mRndisEnabled && Tethering.this.mUsbTetherRequested) {
                        Tethering.this.tetherUsb(true);
                    }
                    Tethering.this.mUsbTetherRequested = false;
                }
            } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                Tethering.this.mTetherMasterSM.sendMessage(3);
            }
        }
    }
}

