/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.INetworkManagementEventObserver;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.server.ConnectivityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charsets;
import java.util.Arrays;

public class Vpn
extends INetworkManagementEventObserver.Stub {
    private static final String TAG = "Vpn";
    private static final String BIND_VPN_SERVICE = "android.permission.BIND_VPN_SERVICE";
    private final Context mContext;
    private final ConnectivityService.VpnCallback mCallback;
    private String mPackage = "[Legacy VPN]";
    private String mInterface;
    private Connection mConnection;
    private LegacyVpnRunner mLegacyVpnRunner;

    public Vpn(Context context, ConnectivityService.VpnCallback callback) {
        this.mContext = context;
        this.mCallback = callback;
    }

    public synchronized boolean prepare(String oldPackage, String newPackage) {
        if (oldPackage != null && !oldPackage.equals(this.mPackage)) {
            return false;
        }
        if (newPackage == null || newPackage.equals(this.mPackage) && !newPackage.equals("[Legacy VPN]")) {
            return true;
        }
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Unauthorized Caller");
        }
        if (this.mInterface != null) {
            this.jniReset(this.mInterface);
            this.mCallback.restore();
            this.hideNotification();
            this.mInterface = null;
        }
        if (this.mConnection != null) {
            try {
                this.mConnection.mService.transact(0xFFFFFF, Parcel.obtain(), null, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mContext.unbindService((ServiceConnection)this.mConnection);
            this.mConnection = null;
        } else if (this.mLegacyVpnRunner != null) {
            this.mLegacyVpnRunner.exit();
            this.mLegacyVpnRunner = null;
        }
        Log.i((String)TAG, (String)("Switched from " + this.mPackage + " to " + newPackage));
        this.mPackage = newPackage;
        return true;
    }

    public void protect(ParcelFileDescriptor socket, String interfaze) throws Exception {
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo app = pm.getApplicationInfo(this.mPackage, 0);
        if (Binder.getCallingUid() != app.uid) {
            throw new SecurityException("Unauthorized Caller");
        }
        this.jniProtect(socket.getFd(), interfaze);
    }

    public synchronized ParcelFileDescriptor establish(VpnConfig config) {
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo app = null;
        try {
            app = pm.getApplicationInfo(this.mPackage, 0);
        }
        catch (Exception e) {
            return null;
        }
        if (Binder.getCallingUid() != app.uid) {
            return null;
        }
        Intent intent = new Intent("android.net.VpnService");
        intent.setClassName(this.mPackage, config.user);
        ResolveInfo info = pm.resolveService(intent, 0);
        if (info == null) {
            throw new SecurityException("Cannot find " + config.user);
        }
        if (!BIND_VPN_SERVICE.equals(info.serviceInfo.permission)) {
            throw new SecurityException(config.user + " does not require " + BIND_VPN_SERVICE);
        }
        String label = ((Object)app.loadLabel(pm)).toString();
        Drawable icon = app.loadIcon(pm);
        Bitmap bitmap = null;
        if (icon.getIntrinsicWidth() > 0 && icon.getIntrinsicHeight() > 0) {
            int width = this.mContext.getResources().getDimensionPixelSize(0x1050005);
            int height = this.mContext.getResources().getDimensionPixelSize(17104902);
            icon.setBounds(0, 0, width, height);
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(bitmap);
            icon.draw(c);
            c.setBitmap(null);
        }
        ParcelFileDescriptor tun = ParcelFileDescriptor.adoptFd((int)this.jniCreate(config.mtu));
        try {
            Connection connection;
            String interfaze = this.jniGetName(tun.getFd());
            if (this.jniSetAddresses(interfaze, config.addresses) < 1) {
                throw new IllegalArgumentException("At least one address must be specified");
            }
            if (config.routes != null) {
                this.jniSetRoutes(interfaze, config.routes);
            }
            if (!this.mContext.bindService(intent, (ServiceConnection)(connection = new Connection()), 1)) {
                throw new IllegalStateException("Cannot bind " + config.user);
            }
            if (this.mConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mConnection);
            }
            if (this.mInterface != null && !this.mInterface.equals(interfaze)) {
                this.jniReset(this.mInterface);
            }
            this.mConnection = connection;
            this.mInterface = interfaze;
        }
        catch (RuntimeException e) {
            try {
                tun.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
        Log.i((String)TAG, (String)("Established by " + config.user + " on " + this.mInterface));
        config.user = this.mPackage;
        config.interfaze = this.mInterface;
        long identity = Binder.clearCallingIdentity();
        this.mCallback.override(config.dnsServers, config.searchDomains);
        this.showNotification(config, label, bitmap);
        Binder.restoreCallingIdentity((long)identity);
        return tun;
    }

    public void interfaceAdded(String interfaze) {
    }

    public synchronized void interfaceStatusChanged(String interfaze, boolean up) {
        if (!up && this.mLegacyVpnRunner != null) {
            this.mLegacyVpnRunner.check(interfaze);
        }
    }

    public void interfaceLinkStateChanged(String interfaze, boolean up) {
    }

    public synchronized void interfaceRemoved(String interfaze) {
        if (interfaze.equals(this.mInterface) && this.jniCheck(interfaze) == 0) {
            long identity = Binder.clearCallingIdentity();
            this.mCallback.restore();
            this.hideNotification();
            Binder.restoreCallingIdentity((long)identity);
            this.mInterface = null;
            if (this.mConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mConnection);
                this.mConnection = null;
            } else if (this.mLegacyVpnRunner != null) {
                this.mLegacyVpnRunner.exit();
                this.mLegacyVpnRunner = null;
            }
        }
    }

    public void limitReached(String limit, String interfaze) {
    }

    private void showNotification(VpnConfig config, String label, Bitmap icon) {
        NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
        if (nm != null) {
            String title = label == null ? this.mContext.getString(17040451) : this.mContext.getString(0x1040444, new Object[]{label});
            String text = config.session == null ? this.mContext.getString(17040453) : this.mContext.getString(17040454, new Object[]{config.session});
            config.startTime = SystemClock.elapsedRealtime();
            Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17303001).setLargeIcon(icon).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setContentIntent(VpnConfig.getIntentForStatusPanel((Context)this.mContext, (VpnConfig)config)).setDefaults(-1).setOngoing(true).getNotification();
            nm.notify(17303001, notification);
        }
    }

    private void hideNotification() {
        NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
        if (nm != null) {
            nm.cancel(17303001);
        }
    }

    private native int jniCreate(int var1);

    private native String jniGetName(int var1);

    private native int jniSetAddresses(String var1, String var2);

    private native int jniSetRoutes(String var1, String var2);

    private native void jniReset(String var1);

    private native int jniCheck(String var1);

    private native void jniProtect(int var1, String var2);

    public synchronized void startLegacyVpn(VpnConfig config, String[] racoon, String[] mtpd) {
        this.prepare(null, "[Legacy VPN]");
        this.mLegacyVpnRunner = new LegacyVpnRunner(config, racoon, mtpd);
        this.mLegacyVpnRunner.start();
    }

    public synchronized LegacyVpnInfo getLegacyVpnInfo() {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Unauthorized Caller");
        }
        return this.mLegacyVpnRunner == null ? null : this.mLegacyVpnRunner.getInfo();
    }

    private class LegacyVpnRunner
    extends Thread {
        private static final String TAG = "LegacyVpnRunner";
        private final VpnConfig mConfig;
        private final String[] mDaemons;
        private final String[][] mArguments;
        private final LocalSocket[] mSockets;
        private final String mOuterInterface;
        private final LegacyVpnInfo mInfo;
        private long mTimer;

        public LegacyVpnRunner(VpnConfig config, String[] racoon, String[] mtpd) {
            super(TAG);
            this.mTimer = -1L;
            this.mConfig = config;
            this.mDaemons = new String[]{"racoon", "mtpd"};
            this.mArguments = new String[][]{racoon, mtpd};
            this.mSockets = new LocalSocket[this.mDaemons.length];
            this.mInfo = new LegacyVpnInfo();
            this.mOuterInterface = this.mConfig.interfaze;
            this.mInfo.key = this.mConfig.user;
            this.mConfig.user = "[Legacy VPN]";
        }

        public void check(String interfaze) {
            if (interfaze.equals(this.mOuterInterface)) {
                Log.i((String)TAG, (String)("Legacy VPN is going down with " + interfaze));
                this.exit();
            }
        }

        public void exit() {
            this.interrupt();
            for (LocalSocket socket : this.mSockets) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public LegacyVpnInfo getInfo() {
            if (this.mInfo.state == 3 && Vpn.this.mInterface == null) {
                this.mInfo.state = 0;
                this.mInfo.intent = null;
            }
            return this.mInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.v((String)TAG, (String)"Waiting");
            String string = TAG;
            synchronized (TAG) {
                Log.v((String)TAG, (String)"Executing");
                this.execute();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void checkpoint(boolean yield) throws InterruptedException {
            long now = SystemClock.elapsedRealtime();
            if (this.mTimer == -1L) {
                this.mTimer = now;
                Thread.sleep(1L);
            } else if (now - this.mTimer <= 60000L) {
                Thread.sleep(yield ? 200L : 1L);
            } else {
                this.mInfo.state = 4;
                throw new IllegalStateException("Time is up");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void execute() {
            int i;
            File state;
            try {
                try {
                    this.checkpoint(false);
                    this.mInfo.state = 1;
                    for (String daemon : this.mDaemons) {
                        String key = "init.svc." + daemon;
                        while (!"stopped".equals(SystemProperties.get((String)key, (String)"stopped"))) {
                            this.checkpoint(true);
                        }
                    }
                    state = new File("/data/misc/vpn/state");
                    state.delete();
                    if (state.exists()) {
                        throw new IllegalStateException("Cannot delete the state");
                    }
                    new File("/data/misc/vpn/abort").delete();
                    boolean restart = false;
                    for (String[] arguments : this.mArguments) {
                        restart = restart || arguments != null;
                    }
                    if (!restart) {
                        this.mInfo.state = 0;
                        Object var16_20 = null;
                        if (this.mInfo.state == 1) {
                            for (String daemon : this.mDaemons) {
                                SystemProperties.set((String)"ctl.stop", (String)daemon);
                            }
                        }
                        if (this.mInfo.state != 1) {
                            if (this.mInfo.state != 2) return;
                        }
                        this.mInfo.state = 5;
                        return;
                    }
                    this.mInfo.state = 2;
                    block14: for (i = 0; i < this.mDaemons.length; ++i) {
                        String[] arguments = this.mArguments[i];
                        if (arguments == null) continue;
                        String daemon = this.mDaemons[i];
                        SystemProperties.set((String)"ctl.start", (String)daemon);
                        String key = "init.svc." + daemon;
                        while (!"running".equals(SystemProperties.get((String)key))) {
                            this.checkpoint(true);
                        }
                        this.mSockets[i] = new LocalSocket();
                        LocalSocketAddress address = new LocalSocketAddress(daemon, LocalSocketAddress.Namespace.RESERVED);
                        while (true) {
                            try {
                                this.mSockets[i].connect(address);
                            }
                            catch (Exception e) {
                                this.checkpoint(true);
                                continue;
                            }
                            break;
                        }
                        this.mSockets[i].setSoTimeout(500);
                        OutputStream out = this.mSockets[i].getOutputStream();
                        for (String argument : arguments) {
                            byte[] bytes = argument.getBytes(Charsets.UTF_8);
                            if (bytes.length >= 65535) {
                                throw new IllegalArgumentException("Argument is too large");
                            }
                            out.write(bytes.length >> 8);
                            out.write(bytes.length);
                            out.write(bytes);
                            this.checkpoint(false);
                        }
                        out.write(255);
                        out.write(255);
                        out.flush();
                        InputStream in = this.mSockets[i].getInputStream();
                        while (true) {
                            try {
                                if (in.read() == -1) {
                                    continue block14;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.checkpoint(true);
                        }
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)"Aborting", (Throwable)e);
                    this.exit();
                    Object var16_22 = null;
                    if (this.mInfo.state == 1) {
                        for (String daemon : this.mDaemons) {
                            SystemProperties.set((String)"ctl.stop", (String)daemon);
                        }
                    }
                    if (this.mInfo.state != 1) {
                        if (this.mInfo.state != 2) return;
                    }
                    this.mInfo.state = 5;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                if (this.mInfo.state == 1) {
                    for (String daemon : this.mDaemons) {
                        SystemProperties.set((String)"ctl.stop", (String)daemon);
                    }
                }
                if (this.mInfo.state != 1) {
                    if (this.mInfo.state != 2) throw throwable;
                }
                this.mInfo.state = 5;
                throw throwable;
            }
            while (true) {
                if (!state.exists()) {
                } else {
                    String searchDomains;
                    String dnsServers;
                    byte[] buffer = new byte[(int)state.length()];
                    if (new FileInputStream(state).read(buffer) != buffer.length) {
                        throw new IllegalStateException("Cannot read the state");
                    }
                    String[] parameters = new String(buffer, Charsets.UTF_8).split("\n", -1);
                    if (parameters.length != 6) {
                        throw new IllegalStateException("Cannot parse the state");
                    }
                    this.mConfig.interfaze = parameters[0].trim();
                    this.mConfig.addresses = parameters[1].trim();
                    if (this.mConfig.routes == null || this.mConfig.routes.isEmpty()) {
                        this.mConfig.routes = parameters[2].trim();
                    }
                    if (!(this.mConfig.dnsServers != null && this.mConfig.dnsServers.size() != 0 || (dnsServers = parameters[3].trim()).isEmpty())) {
                        this.mConfig.dnsServers = Arrays.asList(dnsServers.split(" "));
                    }
                    if (!(this.mConfig.searchDomains != null && this.mConfig.searchDomains.size() != 0 || (searchDomains = parameters[4].trim()).isEmpty())) {
                        this.mConfig.searchDomains = Arrays.asList(searchDomains.split(" "));
                    }
                    Vpn.this.jniSetRoutes(this.mConfig.interfaze, this.mConfig.routes);
                    Vpn vpn = Vpn.this;
                    synchronized (vpn) {
                        this.checkpoint(false);
                        if (Vpn.this.jniCheck(this.mConfig.interfaze) == 0) {
                            throw new IllegalStateException(this.mConfig.interfaze + " is gone");
                        }
                        Vpn.this.mInterface = this.mConfig.interfaze;
                        Vpn.this.mCallback.override(this.mConfig.dnsServers, this.mConfig.searchDomains);
                        Vpn.this.showNotification(this.mConfig, null, null);
                        Log.i((String)TAG, (String)"Connected!");
                        this.mInfo.state = 3;
                        this.mInfo.intent = VpnConfig.getIntentForStatusPanel((Context)Vpn.this.mContext, null);
                    }
                    Object var16_21 = null;
                    if (this.mInfo.state == 1) {
                        for (String daemon : this.mDaemons) {
                            SystemProperties.set((String)"ctl.stop", (String)daemon);
                        }
                    }
                    if (this.mInfo.state != 1) {
                        if (this.mInfo.state != 2) return;
                    }
                    this.mInfo.state = 5;
                    return;
                }
                for (i = 0; i < this.mDaemons.length; ++i) {
                    String daemon = this.mDaemons[i];
                    if (this.mArguments[i] == null || "running".equals(SystemProperties.get((String)("init.svc." + daemon)))) continue;
                    throw new IllegalStateException(daemon + " is dead");
                }
                this.checkpoint(true);
            }
        }
    }

    private class Connection
    implements ServiceConnection {
        private IBinder mService;

        private Connection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mService = service;
        }

        public void onServiceDisconnected(ComponentName name) {
            this.mService = null;
        }
    }
}

