/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.ContentResolver;
import android.content.Context;
import android.location.Country;
import android.location.CountryListener;
import android.location.Geocoder;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.server.location.CountryDetectorBase;
import com.android.server.location.LocationBasedCountryDetector;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class ComprehensiveCountryDetector
extends CountryDetectorBase {
    private static final String TAG = "ComprehensiveCountryDetector";
    static final boolean DEBUG = false;
    private static final long LOCATION_REFRESH_INTERVAL = 86400000L;
    protected CountryDetectorBase mLocationBasedCountryDetector;
    protected Timer mLocationRefreshTimer;
    private final int mPhoneType;
    private Country mCountry;
    private TelephonyManager mTelephonyManager;
    private Country mCountryFromLocation;
    private boolean mStopped = false;
    private ServiceState mLastState;
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onServiceStateChanged(ServiceState serviceState) {
            Slog.d((String)ComprehensiveCountryDetector.TAG, (String)"onServiceStateChanged");
            if (ComprehensiveCountryDetector.this.mLastState == null || ComprehensiveCountryDetector.this.mLastState.getState() != serviceState.getState()) {
                ComprehensiveCountryDetector.this.detectCountry(true, true);
                ComprehensiveCountryDetector.this.mLastState = new ServiceState(serviceState);
            }
        }
    };
    private CountryListener mLocationBasedCountryDetectionListener = new CountryListener(){

        public void onCountryDetected(Country country) {
            ComprehensiveCountryDetector.this.mCountryFromLocation = country;
            ComprehensiveCountryDetector.this.detectCountry(true, false);
            ComprehensiveCountryDetector.this.stopLocationBasedDetector();
        }
    };

    public ComprehensiveCountryDetector(Context context) {
        super(context);
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPhoneType = this.mTelephonyManager.getPhoneType();
    }

    public Country detectCountry() {
        return this.detectCountry(false, !this.mStopped);
    }

    public void stop() {
        Slog.i((String)TAG, (String)"Stop the detector.");
        this.cancelLocationRefresh();
        this.removePhoneStateListener();
        this.stopLocationBasedDetector();
        this.mListener = null;
        this.mStopped = true;
    }

    private Country getCountry() {
        Country result = null;
        result = this.getNetworkBasedCountry();
        if (result == null) {
            result = this.getLastKnownLocationBasedCountry();
        }
        if (result == null) {
            result = this.getSimBasedCountry();
        }
        if (result == null) {
            result = this.getLocaleCountry();
        }
        return result;
    }

    protected Country getNetworkBasedCountry() {
        String countryIso = null;
        if (this.mPhoneType == 1 && !TextUtils.isEmpty((CharSequence)(countryIso = this.mTelephonyManager.getNetworkCountryIso()))) {
            return new Country(countryIso, 0);
        }
        return null;
    }

    protected Country getLastKnownLocationBasedCountry() {
        return this.mCountryFromLocation;
    }

    protected Country getSimBasedCountry() {
        String countryIso = null;
        countryIso = this.mTelephonyManager.getSimCountryIso();
        if (!TextUtils.isEmpty((CharSequence)countryIso)) {
            return new Country(countryIso, 2);
        }
        return null;
    }

    protected Country getLocaleCountry() {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != null) {
            return new Country(defaultLocale.getCountry(), 3);
        }
        return null;
    }

    private Country detectCountry(boolean notifyChange, boolean startLocationBasedDetection) {
        Country country = this.getCountry();
        this.runAfterDetectionAsync(this.mCountry != null ? new Country(this.mCountry) : this.mCountry, country, notifyChange, startLocationBasedDetection);
        this.mCountry = country;
        return this.mCountry;
    }

    protected void runAfterDetectionAsync(final Country country, final Country detectedCountry, final boolean notifyChange, final boolean startLocationBasedDetection) {
        this.mHandler.post(new Runnable(){

            public void run() {
                ComprehensiveCountryDetector.this.runAfterDetection(country, detectedCountry, notifyChange, startLocationBasedDetection);
            }
        });
    }

    public void setCountryListener(CountryListener listener) {
        CountryListener prevListener = this.mListener;
        this.mListener = listener;
        if (this.mListener == null) {
            this.removePhoneStateListener();
            this.stopLocationBasedDetector();
            this.cancelLocationRefresh();
        } else if (prevListener == null) {
            this.addPhoneStateListener();
            this.detectCountry(false, true);
        }
    }

    void runAfterDetection(Country country, Country detectedCountry, boolean notifyChange, boolean startLocationBasedDetection) {
        if (notifyChange) {
            this.notifyIfCountryChanged(country, detectedCountry);
        }
        if (startLocationBasedDetection && (detectedCountry == null || detectedCountry.getSource() > 1) && this.isAirplaneModeOff() && this.mListener != null && this.isGeoCoderImplemented()) {
            this.startLocationBasedDetector(this.mLocationBasedCountryDetectionListener);
        }
        if (detectedCountry == null || detectedCountry.getSource() >= 1) {
            this.scheduleLocationRefresh();
        } else {
            this.cancelLocationRefresh();
            this.stopLocationBasedDetector();
        }
    }

    private synchronized void startLocationBasedDetector(CountryListener listener) {
        if (this.mLocationBasedCountryDetector != null) {
            return;
        }
        this.mLocationBasedCountryDetector = this.createLocationBasedCountryDetector();
        this.mLocationBasedCountryDetector.setCountryListener(listener);
        this.mLocationBasedCountryDetector.detectCountry();
    }

    private synchronized void stopLocationBasedDetector() {
        if (this.mLocationBasedCountryDetector != null) {
            this.mLocationBasedCountryDetector.stop();
            this.mLocationBasedCountryDetector = null;
        }
    }

    protected CountryDetectorBase createLocationBasedCountryDetector() {
        return new LocationBasedCountryDetector(this.mContext);
    }

    protected boolean isAirplaneModeOff() {
        return Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)0) == 0;
    }

    private void notifyIfCountryChanged(Country country, Country detectedCountry) {
        if (!(detectedCountry == null || this.mListener == null || country != null && country.equals((Object)detectedCountry))) {
            Slog.d((String)TAG, (String)("The country was changed from " + country != null ? country.getCountryIso() : country + " to " + detectedCountry.getCountryIso()));
            this.notifyListener(detectedCountry);
        }
    }

    private synchronized void scheduleLocationRefresh() {
        if (this.mLocationRefreshTimer != null) {
            return;
        }
        this.mLocationRefreshTimer = new Timer();
        this.mLocationRefreshTimer.schedule(new TimerTask(){

            public void run() {
                ComprehensiveCountryDetector.this.mLocationRefreshTimer = null;
                ComprehensiveCountryDetector.this.detectCountry(false, true);
            }
        }, 86400000L);
    }

    private synchronized void cancelLocationRefresh() {
        if (this.mLocationRefreshTimer != null) {
            this.mLocationRefreshTimer.cancel();
            this.mLocationRefreshTimer = null;
        }
    }

    protected synchronized void addPhoneStateListener() {
        if (this.mPhoneStateListener == null && this.mPhoneType == 1) {
            this.mLastState = null;
            this.mPhoneStateListener = new PhoneStateListener(){

                public void onServiceStateChanged(ServiceState serviceState) {
                    Slog.d((String)ComprehensiveCountryDetector.TAG, (String)"onServiceStateChanged");
                    if (ComprehensiveCountryDetector.this.mLastState == null || ComprehensiveCountryDetector.this.mLastState.getState() != serviceState.getState()) {
                        ComprehensiveCountryDetector.this.detectCountry(true, true);
                        ComprehensiveCountryDetector.this.mLastState = new ServiceState(serviceState);
                    }
                }
            };
            this.mTelephonyManager.listen(this.mPhoneStateListener, 1);
        }
    }

    protected synchronized void removePhoneStateListener() {
        if (this.mPhoneStateListener != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
    }

    protected boolean isGeoCoderImplemented() {
        return Geocoder.isPresent();
    }
}

