/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Address;
import android.location.GeocoderParams;
import android.location.IGeocodeProvider;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeocoderProxy {
    private static final String TAG = "GeocoderProxy";
    private final Context mContext;
    private final Intent mIntent;
    private final Object mMutex = new Object();
    private Connection mServiceConnection = new Connection();

    public GeocoderProxy(Context context, String serviceName) {
        this.mContext = context;
        this.mIntent = new Intent(serviceName);
        this.mContext.bindService(this.mIntent, (ServiceConnection)this.mServiceConnection, 21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            this.mServiceConnection = new Connection();
            this.mContext.bindService(this.mIntent, (ServiceConnection)this.mServiceConnection, 21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        IGeocodeProvider provider;
        Object object = this.mMutex;
        synchronized (object) {
            provider = this.mServiceConnection.getProvider();
        }
        if (provider != null) {
            try {
                return provider.getFromLocation(latitude, longitude, maxResults, params, addrs);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"getFromLocation failed", (Throwable)e);
            }
        }
        return "Service not Available";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        IGeocodeProvider provider;
        Object object = this.mMutex;
        synchronized (object) {
            provider = this.mServiceConnection.getProvider();
        }
        if (provider != null) {
            try {
                return provider.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, addrs);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"getFromLocationName failed", (Throwable)e);
            }
        }
        return "Service not Available";
    }

    private class Connection
    implements ServiceConnection {
        private IGeocodeProvider mProvider;

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Connection connection = this;
            synchronized (connection) {
                this.mProvider = IGeocodeProvider.Stub.asInterface((IBinder)service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Connection connection = this;
            synchronized (connection) {
                this.mProvider = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IGeocodeProvider getProvider() {
            Connection connection = this;
            synchronized (connection) {
                return this.mProvider;
            }
        }
    }
}

