/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.location.Criteria;
import android.location.IGpsStatusListener;
import android.location.IGpsStatusProvider;
import android.location.ILocationManager;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.WorkSource;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.SparseIntArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.location.GpsNetInitiatedHandler;
import com.android.server.location.GpsXtraDownloader;
import com.android.server.location.LocationProviderInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class GpsLocationProvider
implements LocationProviderInterface {
    private static final String TAG = "GpsLocationProvider";
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private static final int GPS_POSITION_MODE_STANDALONE = 0;
    private static final int GPS_POSITION_MODE_MS_BASED = 1;
    private static final int GPS_POSITION_MODE_MS_ASSISTED = 2;
    private static final int GPS_POSITION_RECURRENCE_PERIODIC = 0;
    private static final int GPS_POSITION_RECURRENCE_SINGLE = 1;
    private static final int GPS_STATUS_NONE = 0;
    private static final int GPS_STATUS_SESSION_BEGIN = 1;
    private static final int GPS_STATUS_SESSION_END = 2;
    private static final int GPS_STATUS_ENGINE_ON = 3;
    private static final int GPS_STATUS_ENGINE_OFF = 4;
    private static final int GPS_REQUEST_AGPS_DATA_CONN = 1;
    private static final int GPS_RELEASE_AGPS_DATA_CONN = 2;
    private static final int GPS_AGPS_DATA_CONNECTED = 3;
    private static final int GPS_AGPS_DATA_CONN_DONE = 4;
    private static final int GPS_AGPS_DATA_CONN_FAILED = 5;
    private static final int LOCATION_INVALID = 0;
    private static final int LOCATION_HAS_LAT_LONG = 1;
    private static final int LOCATION_HAS_ALTITUDE = 2;
    private static final int LOCATION_HAS_SPEED = 4;
    private static final int LOCATION_HAS_BEARING = 8;
    private static final int LOCATION_HAS_ACCURACY = 16;
    private static final int GPS_DELETE_EPHEMERIS = 1;
    private static final int GPS_DELETE_ALMANAC = 2;
    private static final int GPS_DELETE_POSITION = 4;
    private static final int GPS_DELETE_TIME = 8;
    private static final int GPS_DELETE_IONO = 16;
    private static final int GPS_DELETE_UTC = 32;
    private static final int GPS_DELETE_HEALTH = 64;
    private static final int GPS_DELETE_SVDIR = 128;
    private static final int GPS_DELETE_SVSTEER = 256;
    private static final int GPS_DELETE_SADATA = 512;
    private static final int GPS_DELETE_RTI = 1024;
    private static final int GPS_DELETE_CELLDB_INFO = 32768;
    private static final int GPS_DELETE_ALL = 65535;
    private static final int GPS_CAPABILITY_SCHEDULING = 1;
    private static final int GPS_CAPABILITY_MSB = 2;
    private static final int GPS_CAPABILITY_MSA = 4;
    private static final int GPS_CAPABILITY_SINGLE_SHOT = 8;
    private static final int GPS_CAPABILITY_ON_DEMAND_TIME = 16;
    private static final int AGPS_TYPE_SUPL = 1;
    private static final int AGPS_TYPE_C2K = 2;
    private static final int AGPS_DATA_CONNECTION_CLOSED = 0;
    private static final int AGPS_DATA_CONNECTION_OPENING = 1;
    private static final int AGPS_DATA_CONNECTION_OPEN = 2;
    private static final int CHECK_LOCATION = 1;
    private static final int ENABLE = 2;
    private static final int ENABLE_TRACKING = 3;
    private static final int UPDATE_NETWORK_STATE = 4;
    private static final int INJECT_NTP_TIME = 5;
    private static final int DOWNLOAD_XTRA_DATA = 6;
    private static final int UPDATE_LOCATION = 7;
    private static final int ADD_LISTENER = 8;
    private static final int REMOVE_LISTENER = 9;
    private static final int REQUEST_SINGLE_SHOT = 10;
    private static final int AGPS_RIL_REQUEST_SETID_IMSI = 1;
    private static final int AGPS_RIL_REQUEST_SETID_MSISDN = 2;
    private static final int AGPS_RIL_REQUEST_REFLOC_CELLID = 1;
    private static final int AGPS_RIL_REQUEST_REFLOC_MAC = 2;
    private static final int AGPS_REF_LOCATION_TYPE_GSM_CELLID = 1;
    private static final int AGPS_REF_LOCATION_TYPE_UMTS_CELLID = 2;
    private static final int AGPS_REG_LOCATION_TYPE_MAC = 3;
    private static final int AGPS_SETID_TYPE_NONE = 0;
    private static final int AGPS_SETID_TYPE_IMSI = 1;
    private static final int AGPS_SETID_TYPE_MSISDN = 2;
    private static final String PROPERTIES_FILE = "/etc/gps.conf";
    private int mLocationFlags = 0;
    private int mStatus = 1;
    private long mStatusUpdateTime = SystemClock.elapsedRealtime();
    private static final long RECENT_FIX_TIMEOUT = 10000L;
    private static final int NO_FIX_TIMEOUT = 60000;
    private volatile boolean mEnabled;
    private boolean mNetworkAvailable;
    private boolean mInjectNtpTimePending = true;
    private boolean mDownloadXtraDataPending = true;
    private boolean mPeriodicTimeInjection;
    private boolean mNavigating;
    private boolean mEngineOn;
    private int mFixInterval = 1000;
    private boolean mStarted;
    private boolean mSingleShot;
    private int mEngineCapabilities;
    private boolean mSupportsXtra;
    private long mFixRequestTime = 0L;
    private int mTTFF = 0;
    private long mLastFixTime;
    private int mPositionMode;
    private Properties mProperties;
    private String mSuplServerHost;
    private int mSuplServerPort;
    private String mC2KServerHost;
    private int mC2KServerPort;
    private final Context mContext;
    private final NtpTrustedTime mNtpTime;
    private final ILocationManager mLocationManager;
    private Location mLocation = new Location("gps");
    private Bundle mLocationExtras = new Bundle();
    private ArrayList<Listener> mListeners = new ArrayList();
    private final Thread mThread;
    private Handler mHandler;
    private final CountDownLatch mInitializedLatch = new CountDownLatch(1);
    private String mAGpsApn;
    private int mAGpsDataConnectionState;
    private int mAGpsDataConnectionIpAddr;
    private final ConnectivityManager mConnMgr;
    private final GpsNetInitiatedHandler mNIHandler;
    private static final String WAKELOCK_KEY = "GpsLocationProvider";
    private final PowerManager.WakeLock mWakeLock;
    private int mPendingMessageBits;
    private int mPendingListenerMessages;
    private static final String ALARM_WAKEUP = "com.android.internal.location.ALARM_WAKEUP";
    private static final String ALARM_TIMEOUT = "com.android.internal.location.ALARM_TIMEOUT";
    private final AlarmManager mAlarmManager;
    private final PendingIntent mWakeupIntent;
    private final PendingIntent mTimeoutIntent;
    private final IBatteryStats mBatteryStats;
    private final SparseIntArray mClientUids = new SparseIntArray();
    private static final long NTP_INTERVAL = 86400000L;
    private static final long RETRY_INTERVAL = 300000L;
    private final IGpsStatusProvider mGpsStatusProvider = new IGpsStatusProvider.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addGpsStatusListener(IGpsStatusListener listener) throws RemoteException {
            if (listener == null) {
                throw new NullPointerException("listener is null in addGpsStatusListener");
            }
            ArrayList arrayList = GpsLocationProvider.this.mListeners;
            synchronized (arrayList) {
                IBinder binder = listener.asBinder();
                int size = GpsLocationProvider.this.mListeners.size();
                for (int i = 0; i < size; ++i) {
                    Listener test = (Listener)GpsLocationProvider.this.mListeners.get(i);
                    if (!binder.equals(test.mListener.asBinder())) continue;
                    return;
                }
                Listener l = new Listener(listener);
                binder.linkToDeath((IBinder.DeathRecipient)l, 0);
                GpsLocationProvider.this.mListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeGpsStatusListener(IGpsStatusListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is null in addGpsStatusListener");
            }
            ArrayList arrayList = GpsLocationProvider.this.mListeners;
            synchronized (arrayList) {
                IBinder binder = listener.asBinder();
                Listener l = null;
                int size = GpsLocationProvider.this.mListeners.size();
                for (int i = 0; i < size && l == null; ++i) {
                    Listener test = (Listener)GpsLocationProvider.this.mListeners.get(i);
                    if (!binder.equals(test.mListener.asBinder())) continue;
                    l = test;
                }
                if (l != null) {
                    GpsLocationProvider.this.mListeners.remove(l);
                    binder.unlinkToDeath(l, 0);
                }
            }
        }
    };
    private final BroadcastReceiver mBroadcastReciever = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(GpsLocationProvider.ALARM_WAKEUP)) {
                GpsLocationProvider.this.startNavigating(false);
            } else if (action.equals(GpsLocationProvider.ALARM_TIMEOUT)) {
                GpsLocationProvider.this.hibernate();
            } else if (action.equals("android.intent.action.DATA_SMS_RECEIVED")) {
                GpsLocationProvider.this.checkSmsSuplInit(intent);
            } else if (action.equals("android.provider.Telephony.WAP_PUSH_RECEIVED")) {
                GpsLocationProvider.this.checkWapSuplInit(intent);
            }
        }
    };
    private final INetInitiatedListener mNetInitiatedListener = new INetInitiatedListener.Stub(){

        public boolean sendNiResponse(int notificationId, int userResponse) {
            StringBuilder extrasBuf = new StringBuilder();
            GpsLocationProvider.this.native_send_ni_response(notificationId, userResponse);
            return true;
        }
    };
    private static final int MAX_SVS = 32;
    private static final int EPHEMERIS_MASK = 0;
    private static final int ALMANAC_MASK = 1;
    private static final int USED_FOR_FIX_MASK = 2;
    private int[] mSvs = new int[32];
    private float[] mSnrs = new float[32];
    private float[] mSvElevations = new float[32];
    private float[] mSvAzimuths = new float[32];
    private int[] mSvMasks = new int[3];
    private int mSvCount;
    private byte[] mNmeaBuffer = new byte[120];

    public IGpsStatusProvider getGpsStatusProvider() {
        return this.mGpsStatusProvider;
    }

    private void checkSmsSuplInit(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent((Intent)intent);
        for (int i = 0; i < messages.length; ++i) {
            byte[] supl_init = messages[i].getUserData();
            this.native_agps_ni_message(supl_init, supl_init.length);
        }
    }

    private void checkWapSuplInit(Intent intent) {
        byte[] supl_init = (byte[])intent.getExtra("data");
        this.native_agps_ni_message(supl_init, supl_init.length);
    }

    public static boolean isSupported() {
        return GpsLocationProvider.native_is_supported();
    }

    public GpsLocationProvider(Context context, ILocationManager locationManager) {
        this.mContext = context;
        this.mNtpTime = NtpTrustedTime.getInstance((Context)context);
        this.mLocationManager = locationManager;
        this.mNIHandler = new GpsNetInitiatedHandler(context);
        this.mLocation.setExtras(this.mLocationExtras);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "GpsLocationProvider");
        this.mWakeLock.setReferenceCounted(false);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mWakeupIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ALARM_WAKEUP), (int)0);
        this.mTimeoutIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ALARM_TIMEOUT), (int)0);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DATA_SMS_RECEIVED");
        intentFilter.addDataScheme("sms");
        intentFilter.addDataAuthority("localhost", "7275");
        context.registerReceiver(this.mBroadcastReciever, intentFilter);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
        try {
            intentFilter.addDataType("application/vnd.omaloc-supl-init");
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            Log.w((String)"GpsLocationProvider", (String)"Malformed SUPL init mime type");
        }
        context.registerReceiver(this.mBroadcastReciever, intentFilter);
        this.mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        this.mBatteryStats = IBatteryStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"batteryinfo"));
        this.mProperties = new Properties();
        try {
            File file = new File(PROPERTIES_FILE);
            FileInputStream stream = new FileInputStream(file);
            this.mProperties.load(stream);
            stream.close();
            this.mSuplServerHost = this.mProperties.getProperty("SUPL_HOST");
            String portString = this.mProperties.getProperty("SUPL_PORT");
            if (this.mSuplServerHost != null && portString != null) {
                try {
                    this.mSuplServerPort = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    Log.e((String)"GpsLocationProvider", (String)("unable to parse SUPL_PORT: " + portString));
                }
            }
            this.mC2KServerHost = this.mProperties.getProperty("C2K_HOST");
            portString = this.mProperties.getProperty("C2K_PORT");
            if (this.mC2KServerHost != null && portString != null) {
                try {
                    this.mC2KServerPort = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    Log.e((String)"GpsLocationProvider", (String)("unable to parse C2K_PORT: " + portString));
                }
            }
        }
        catch (IOException e) {
            Log.w((String)"GpsLocationProvider", (String)"Could not open GPS configuration file /etc/gps.conf");
        }
        this.mThread = new GpsLocationProviderThread();
        this.mThread.start();
        while (true) {
            try {
                this.mInitializedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void initialize() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ALARM_WAKEUP);
        intentFilter.addAction(ALARM_TIMEOUT);
        this.mContext.registerReceiver(this.mBroadcastReciever, intentFilter);
    }

    public String getName() {
        return "gps";
    }

    public boolean requiresNetwork() {
        return true;
    }

    public void updateNetworkState(int state, NetworkInfo info) {
        this.sendMessage(4, state, info);
    }

    private void handleUpdateNetworkState(int state, NetworkInfo info) {
        boolean bl = this.mNetworkAvailable = state == 2;
        if (info != null) {
            boolean dataEnabled = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"mobile_data", (int)1) == 1;
            boolean networkAvailable = info.isAvailable() && dataEnabled;
            String defaultApn = this.getSelectedApn();
            if (defaultApn == null) {
                defaultApn = "dummy-apn";
            }
            this.native_update_network_state(info.isConnected(), info.getType(), info.isRoaming(), networkAvailable, info.getExtraInfo(), defaultApn);
        }
        if (info != null && info.getType() == 3 && this.mAGpsDataConnectionState == 1) {
            String apnName = info.getExtraInfo();
            if (this.mNetworkAvailable) {
                boolean route_result;
                if (apnName == null) {
                    apnName = "dummy-apn";
                }
                this.mAGpsApn = apnName;
                if (this.mAGpsDataConnectionIpAddr != -1 && !(route_result = this.mConnMgr.requestRouteToHost(3, this.mAGpsDataConnectionIpAddr))) {
                    Log.d((String)"GpsLocationProvider", (String)"call requestRouteToHost failed");
                }
                this.native_agps_data_conn_open(apnName);
                this.mAGpsDataConnectionState = 2;
            } else {
                this.mAGpsApn = null;
                this.mAGpsDataConnectionState = 0;
                this.native_agps_data_conn_failed();
            }
        }
        if (this.mNetworkAvailable) {
            if (this.mInjectNtpTimePending) {
                this.sendMessage(5, 0, null);
            }
            if (this.mDownloadXtraDataPending) {
                this.sendMessage(6, 0, null);
            }
        }
    }

    private void handleInjectNtpTime() {
        long delay;
        if (!this.mNetworkAvailable) {
            this.mInjectNtpTimePending = true;
            return;
        }
        this.mInjectNtpTimePending = false;
        if (this.mNtpTime.forceRefresh()) {
            long time = this.mNtpTime.getCachedNtpTime();
            long timeReference = this.mNtpTime.getCachedNtpTimeReference();
            long certainty = this.mNtpTime.getCacheCertainty();
            long now = System.currentTimeMillis();
            Log.d((String)"GpsLocationProvider", (String)("NTP server returned: " + time + " (" + new Date(time) + ") reference: " + timeReference + " certainty: " + certainty + " system time offset: " + (time - now)));
            this.native_inject_time(time, timeReference, (int)certainty);
            delay = 86400000L;
        } else {
            delay = 300000L;
        }
        if (this.mPeriodicTimeInjection) {
            this.mHandler.removeMessages(5);
            this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)5), delay);
        }
    }

    private void handleDownloadXtraData() {
        if (!this.mNetworkAvailable) {
            this.mDownloadXtraDataPending = true;
            return;
        }
        this.mDownloadXtraDataPending = false;
        GpsXtraDownloader xtraDownloader = new GpsXtraDownloader(this.mContext, this.mProperties);
        byte[] data = xtraDownloader.downloadXtraData();
        if (data != null) {
            this.native_inject_xtra_data(data, data.length);
        } else {
            this.mHandler.removeMessages(6);
            this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)6), 300000L);
        }
    }

    public void updateLocation(Location location) {
        this.sendMessage(7, 0, location);
    }

    private void handleUpdateLocation(Location location) {
        if (location.hasAccuracy()) {
            this.native_inject_location(location.getLatitude(), location.getLongitude(), location.getAccuracy());
        }
    }

    public boolean requiresSatellite() {
        return true;
    }

    public boolean requiresCell() {
        return false;
    }

    public boolean hasMonetaryCost() {
        return false;
    }

    public boolean supportsAltitude() {
        return true;
    }

    public boolean supportsSpeed() {
        return true;
    }

    public boolean supportsBearing() {
        return true;
    }

    public int getPowerRequirement() {
        return 3;
    }

    public boolean meetsCriteria(Criteria criteria) {
        return criteria.getPowerRequirement() != 1;
    }

    public int getAccuracy() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            this.sendMessage(2, 1, null);
        }
    }

    private void handleEnable() {
        if (this.mEnabled) {
            return;
        }
        this.mEnabled = this.native_init();
        if (this.mEnabled) {
            this.mSupportsXtra = this.native_supports_xtra();
            if (this.mSuplServerHost != null) {
                this.native_set_agps_server(1, this.mSuplServerHost, this.mSuplServerPort);
            }
            if (this.mC2KServerHost != null) {
                this.native_set_agps_server(2, this.mC2KServerHost, this.mC2KServerPort);
            }
        } else {
            Log.w((String)"GpsLocationProvider", (String)"Failed to enable location provider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            this.sendMessage(2, 0, null);
        }
    }

    private void handleDisable() {
        if (!this.mEnabled) {
            return;
        }
        this.mEnabled = false;
        this.stopNavigating();
        this.native_cleanup();
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public int getStatus(Bundle extras) {
        if (extras != null) {
            extras.putInt("satellites", this.mSvCount);
        }
        return this.mStatus;
    }

    private void updateStatus(int status, int svCount) {
        if (status != this.mStatus || svCount != this.mSvCount) {
            this.mStatus = status;
            this.mSvCount = svCount;
            this.mLocationExtras.putInt("satellites", svCount);
            this.mStatusUpdateTime = SystemClock.elapsedRealtime();
        }
    }

    public long getStatusUpdateTime() {
        return this.mStatusUpdateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLocationTracking(boolean enable) {
        Handler handler = this.mHandler;
        synchronized (handler) {
            this.sendMessage(3, enable ? 1 : 0, null);
        }
    }

    private void handleEnableLocationTracking(boolean enable) {
        if (enable) {
            this.mTTFF = 0;
            this.mLastFixTime = 0L;
            this.startNavigating(false);
        } else {
            if (!this.hasCapability(1)) {
                this.mAlarmManager.cancel(this.mWakeupIntent);
                this.mAlarmManager.cancel(this.mTimeoutIntent);
            }
            this.stopNavigating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestSingleShotFix() {
        if (this.mStarted) {
            return false;
        }
        Handler handler = this.mHandler;
        synchronized (handler) {
            this.mHandler.removeMessages(10);
            Message m = Message.obtain((Handler)this.mHandler, (int)10);
            this.mHandler.sendMessage(m);
        }
        return true;
    }

    private void handleRequestSingleShot() {
        this.mTTFF = 0;
        this.mLastFixTime = 0L;
        this.startNavigating(true);
    }

    public void setMinTime(long minTime, WorkSource ws) {
        if (minTime >= 0L) {
            this.mFixInterval = (int)minTime;
            if (this.mStarted && this.hasCapability(1) && !this.native_set_position_mode(this.mPositionMode, 0, this.mFixInterval, 0, 0)) {
                Log.e((String)"GpsLocationProvider", (String)"set_position_mode failed in setMinTime()");
            }
        }
    }

    public String getInternalState() {
        return this.native_get_internal_state();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(int uid) {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            ++this.mPendingListenerMessages;
            this.mWakeLock.acquire();
            Message m = Message.obtain((Handler)this.mHandler, (int)8);
            m.arg1 = uid;
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddListener(int uid) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mClientUids.indexOfKey(uid) >= 0) {
                Log.w((String)"GpsLocationProvider", (String)("Duplicate add listener for uid " + uid));
                return;
            }
            this.mClientUids.put(uid, 0);
            if (this.mNavigating) {
                try {
                    this.mBatteryStats.noteStartGps(uid);
                }
                catch (RemoteException e) {
                    Log.w((String)"GpsLocationProvider", (String)"RemoteException in addListener");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(int uid) {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            ++this.mPendingListenerMessages;
            this.mWakeLock.acquire();
            Message m = Message.obtain((Handler)this.mHandler, (int)9);
            m.arg1 = uid;
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveListener(int uid) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mClientUids.indexOfKey(uid) < 0) {
                Log.w((String)"GpsLocationProvider", (String)("Unneeded remove listener for uid " + uid));
                return;
            }
            this.mClientUids.delete(uid);
            if (this.mNavigating) {
                try {
                    this.mBatteryStats.noteStopGps(uid);
                }
                catch (RemoteException e) {
                    Log.w((String)"GpsLocationProvider", (String)"RemoteException in removeListener");
                }
            }
        }
    }

    public boolean sendExtraCommand(String command, Bundle extras) {
        long identity = Binder.clearCallingIdentity();
        boolean result = false;
        if ("delete_aiding_data".equals(command)) {
            result = this.deleteAidingData(extras);
        } else if ("force_time_injection".equals(command)) {
            this.sendMessage(5, 0, null);
            result = true;
        } else if ("force_xtra_injection".equals(command)) {
            if (this.mSupportsXtra) {
                this.xtraDownloadRequest();
                result = true;
            }
        } else {
            Log.w((String)"GpsLocationProvider", (String)("sendExtraCommand: unknown command " + command));
        }
        Binder.restoreCallingIdentity((long)identity);
        return result;
    }

    private boolean deleteAidingData(Bundle extras) {
        int flags;
        if (extras == null) {
            flags = 65535;
        } else {
            flags = 0;
            if (extras.getBoolean("ephemeris")) {
                flags |= 1;
            }
            if (extras.getBoolean("almanac")) {
                flags |= 2;
            }
            if (extras.getBoolean("position")) {
                flags |= 4;
            }
            if (extras.getBoolean("time")) {
                flags |= 8;
            }
            if (extras.getBoolean("iono")) {
                flags |= 0x10;
            }
            if (extras.getBoolean("utc")) {
                flags |= 0x20;
            }
            if (extras.getBoolean("health")) {
                flags |= 0x40;
            }
            if (extras.getBoolean("svdir")) {
                flags |= 0x80;
            }
            if (extras.getBoolean("svsteer")) {
                flags |= 0x100;
            }
            if (extras.getBoolean("sadata")) {
                flags |= 0x200;
            }
            if (extras.getBoolean("rti")) {
                flags |= 0x400;
            }
            if (extras.getBoolean("celldb-info")) {
                flags |= 0x8000;
            }
            if (extras.getBoolean("all")) {
                flags |= 0xFFFF;
            }
        }
        if (flags != 0) {
            this.native_delete_aiding_data(flags);
            return true;
        }
        return false;
    }

    private void startNavigating(boolean singleShot) {
        if (!this.mStarted) {
            int interval;
            this.mStarted = true;
            this.mSingleShot = singleShot;
            this.mPositionMode = 0;
            if (Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"assisted_gps_enabled", (int)1) != 0) {
                if (singleShot && this.hasCapability(4)) {
                    this.mPositionMode = 2;
                } else if (this.hasCapability(2)) {
                    this.mPositionMode = 1;
                }
            }
            int n = interval = this.hasCapability(1) ? this.mFixInterval : 1000;
            if (!this.native_set_position_mode(this.mPositionMode, 0, interval, 0, 0)) {
                this.mStarted = false;
                Log.e((String)"GpsLocationProvider", (String)"set_position_mode failed in startNavigating()");
                return;
            }
            if (!this.native_start()) {
                this.mStarted = false;
                Log.e((String)"GpsLocationProvider", (String)"native_start failed in startNavigating()");
                return;
            }
            this.updateStatus(1, 0);
            this.mFixRequestTime = System.currentTimeMillis();
            if (!this.hasCapability(1) && this.mFixInterval >= 60000) {
                this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 60000L, this.mTimeoutIntent);
            }
        }
    }

    private void stopNavigating() {
        if (this.mStarted) {
            this.mStarted = false;
            this.mSingleShot = false;
            this.native_stop();
            this.mTTFF = 0;
            this.mLastFixTime = 0L;
            this.mLocationFlags = 0;
            this.updateStatus(1, 0);
        }
    }

    private void hibernate() {
        this.stopNavigating();
        this.mAlarmManager.cancel(this.mTimeoutIntent);
        this.mAlarmManager.cancel(this.mWakeupIntent);
        long now = SystemClock.elapsedRealtime();
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)this.mFixInterval, this.mWakeupIntent);
    }

    private boolean hasCapability(int capability) {
        return (this.mEngineCapabilities & capability) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLocation(int flags, double latitude, double longitude, double altitude, float speed, float bearing, float accuracy, long timestamp) {
        Object object = this.mLocation;
        synchronized (object) {
            this.mLocationFlags = flags;
            if ((flags & 1) == 1) {
                this.mLocation.setLatitude(latitude);
                this.mLocation.setLongitude(longitude);
                this.mLocation.setTime(timestamp);
            }
            if ((flags & 2) == 2) {
                this.mLocation.setAltitude(altitude);
            } else {
                this.mLocation.removeAltitude();
            }
            if ((flags & 4) == 4) {
                this.mLocation.setSpeed(speed);
            } else {
                this.mLocation.removeSpeed();
            }
            if ((flags & 8) == 8) {
                this.mLocation.setBearing(bearing);
            } else {
                this.mLocation.removeBearing();
            }
            if ((flags & 0x10) == 16) {
                this.mLocation.setAccuracy(accuracy);
            } else {
                this.mLocation.removeAccuracy();
            }
            try {
                this.mLocationManager.reportLocation(this.mLocation, false);
            }
            catch (RemoteException e) {
                Log.e((String)"GpsLocationProvider", (String)"RemoteException calling reportLocation");
            }
        }
        this.mLastFixTime = System.currentTimeMillis();
        if (this.mTTFF == 0 && (flags & 1) == 1) {
            this.mTTFF = (int)(this.mLastFixTime - this.mFixRequestTime);
            object = this.mListeners;
            synchronized (object) {
                int size = this.mListeners.size();
                for (int i = 0; i < size; ++i) {
                    Listener listener = this.mListeners.get(i);
                    try {
                        listener.mListener.onFirstFix(this.mTTFF);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.w((String)"GpsLocationProvider", (String)"RemoteException in stopNavigating");
                        this.mListeners.remove(listener);
                        --size;
                    }
                }
            }
        }
        if (this.mSingleShot) {
            this.stopNavigating();
        }
        if (this.mStarted && this.mStatus != 2) {
            if (!this.hasCapability(1) && this.mFixInterval < 60000) {
                this.mAlarmManager.cancel(this.mTimeoutIntent);
            }
            Intent intent = new Intent("android.location.GPS_FIX_CHANGE");
            intent.putExtra("enabled", true);
            this.mContext.sendBroadcast(intent);
            this.updateStatus(2, this.mSvCount);
        }
        if (!this.hasCapability(1) && this.mStarted && this.mFixInterval > 1000) {
            this.hibernate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportStatus(int status) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            boolean wasNavigating = this.mNavigating;
            switch (status) {
                case 1: {
                    this.mNavigating = true;
                    this.mEngineOn = true;
                    break;
                }
                case 2: {
                    this.mNavigating = false;
                    break;
                }
                case 3: {
                    this.mEngineOn = true;
                    break;
                }
                case 4: {
                    this.mEngineOn = false;
                    this.mNavigating = false;
                }
            }
            if (wasNavigating != this.mNavigating) {
                int i;
                int size = this.mListeners.size();
                for (i = 0; i < size; ++i) {
                    Listener listener = this.mListeners.get(i);
                    try {
                        if (this.mNavigating) {
                            listener.mListener.onGpsStarted();
                            continue;
                        }
                        listener.mListener.onGpsStopped();
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.w((String)"GpsLocationProvider", (String)"RemoteException in reportStatus");
                        this.mListeners.remove(listener);
                        --size;
                    }
                }
                try {
                    for (i = this.mClientUids.size() - 1; i >= 0; --i) {
                        int uid = this.mClientUids.keyAt(i);
                        if (this.mNavigating) {
                            this.mBatteryStats.noteStartGps(uid);
                            continue;
                        }
                        this.mBatteryStats.noteStopGps(uid);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)"GpsLocationProvider", (String)"RemoteException in reportStatus");
                }
                Intent intent = new Intent("android.location.GPS_ENABLED_CHANGE");
                intent.putExtra("enabled", this.mNavigating);
                this.mContext.sendBroadcast(intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportSvStatus() {
        int svCount = this.native_read_sv_status(this.mSvs, this.mSnrs, this.mSvElevations, this.mSvAzimuths, this.mSvMasks);
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                Listener listener = this.mListeners.get(i);
                try {
                    listener.mListener.onSvStatusChanged(svCount, this.mSvs, this.mSnrs, this.mSvElevations, this.mSvAzimuths, this.mSvMasks[0], this.mSvMasks[1], this.mSvMasks[2]);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w((String)"GpsLocationProvider", (String)"RemoteException in reportSvInfo");
                    this.mListeners.remove(listener);
                    --size;
                }
            }
        }
        this.updateStatus(this.mStatus, Integer.bitCount(this.mSvMasks[2]));
        if (this.mNavigating && this.mStatus == 2 && this.mLastFixTime > 0L && System.currentTimeMillis() - this.mLastFixTime > 10000L) {
            Intent intent = new Intent("android.location.GPS_FIX_CHANGE");
            intent.putExtra("enabled", false);
            this.mContext.sendBroadcast(intent);
            this.updateStatus(1, this.mSvCount);
        }
    }

    private void reportAGpsStatus(int type, int status, int ipaddr) {
        switch (status) {
            case 1: {
                this.mAGpsDataConnectionState = 1;
                int result = this.mConnMgr.startUsingNetworkFeature(0, "enableSUPL");
                this.mAGpsDataConnectionIpAddr = ipaddr;
                if (result == 0) {
                    if (this.mAGpsApn != null) {
                        boolean route_result;
                        Log.d((String)"GpsLocationProvider", (String)("mAGpsDataConnectionIpAddr " + this.mAGpsDataConnectionIpAddr));
                        if (this.mAGpsDataConnectionIpAddr != -1 && !(route_result = this.mConnMgr.requestRouteToHost(3, this.mAGpsDataConnectionIpAddr))) {
                            Log.d((String)"GpsLocationProvider", (String)"call requestRouteToHost failed");
                        }
                        this.native_agps_data_conn_open(this.mAGpsApn);
                        this.mAGpsDataConnectionState = 2;
                        break;
                    }
                    Log.e((String)"GpsLocationProvider", (String)"mAGpsApn not set when receiving Phone.APN_ALREADY_ACTIVE");
                    this.mAGpsDataConnectionState = 0;
                    this.native_agps_data_conn_failed();
                    break;
                }
                if (result == 1) break;
                this.mAGpsDataConnectionState = 0;
                this.native_agps_data_conn_failed();
                break;
            }
            case 2: {
                if (this.mAGpsDataConnectionState == 0) break;
                this.mConnMgr.stopUsingNetworkFeature(0, "enableSUPL");
                this.native_agps_data_conn_closed();
                this.mAGpsDataConnectionState = 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportNmea(long timestamp) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            int size = this.mListeners.size();
            if (size > 0) {
                int length = this.native_read_nmea(this.mNmeaBuffer, this.mNmeaBuffer.length);
                String nmea = new String(this.mNmeaBuffer, 0, length);
                for (int i = 0; i < size; ++i) {
                    Listener listener = this.mListeners.get(i);
                    try {
                        listener.mListener.onNmeaReceived(timestamp, nmea);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.w((String)"GpsLocationProvider", (String)"RemoteException in reportNmea");
                        this.mListeners.remove(listener);
                        --size;
                    }
                }
            }
        }
    }

    private void setEngineCapabilities(int capabilities) {
        this.mEngineCapabilities = capabilities;
        if (!this.hasCapability(16) && !this.mPeriodicTimeInjection) {
            this.mPeriodicTimeInjection = true;
            this.requestUtcTime();
        }
    }

    private void xtraDownloadRequest() {
        this.sendMessage(6, 0, null);
    }

    public INetInitiatedListener getNetInitiatedListener() {
        return this.mNetInitiatedListener;
    }

    public void reportNiNotification(int notificationId, int niType, int notifyFlags, int timeout, int defaultResponse, String requestorId, String text, int requestorIdEncoding, int textEncoding, String extras) {
        Log.i((String)"GpsLocationProvider", (String)"reportNiNotification: entered");
        Log.i((String)"GpsLocationProvider", (String)("notificationId: " + notificationId + ", niType: " + niType + ", notifyFlags: " + notifyFlags + ", timeout: " + timeout + ", defaultResponse: " + defaultResponse));
        Log.i((String)"GpsLocationProvider", (String)("requestorId: " + requestorId + ", text: " + text + ", requestorIdEncoding: " + requestorIdEncoding + ", textEncoding: " + textEncoding));
        GpsNetInitiatedHandler.GpsNiNotification notification = new GpsNetInitiatedHandler.GpsNiNotification();
        notification.notificationId = notificationId;
        notification.niType = niType;
        notification.needNotify = (notifyFlags & 1) != 0;
        notification.needVerify = (notifyFlags & 2) != 0;
        notification.privacyOverride = (notifyFlags & 4) != 0;
        notification.timeout = timeout;
        notification.defaultResponse = defaultResponse;
        notification.requestorId = requestorId;
        notification.text = text;
        notification.requestorIdEncoding = requestorIdEncoding;
        notification.textEncoding = textEncoding;
        Bundle bundle = new Bundle();
        if (extras == null) {
            extras = "";
        }
        Properties extraProp = new Properties();
        try {
            extraProp.load(new StringReader(extras));
        }
        catch (IOException e) {
            Log.e((String)"GpsLocationProvider", (String)("reportNiNotification cannot parse extras data: " + extras));
        }
        for (Map.Entry<Object, Object> ent : extraProp.entrySet()) {
            bundle.putString((String)ent.getKey(), (String)ent.getValue());
        }
        notification.extras = bundle;
        this.mNIHandler.handleNiNotification(notification);
    }

    private void requestSetID(int flags) {
        String data_temp;
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        int type = 0;
        String data = "";
        if ((flags & 1) == 1) {
            String data_temp2 = phone.getSubscriberId();
            if (data_temp2 != null) {
                data = data_temp2;
                type = 1;
            }
        } else if ((flags & 2) == 2 && (data_temp = phone.getLine1Number()) != null) {
            data = data_temp;
            type = 2;
        }
        this.native_agps_set_id(type, data);
    }

    private void requestUtcTime() {
        this.sendMessage(5, 0, null);
    }

    private void requestRefLocation(int flags) {
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        if (phone.getPhoneType() == 1) {
            GsmCellLocation gsm_cell = (GsmCellLocation)phone.getCellLocation();
            if (gsm_cell != null && phone.getPhoneType() == 1 && phone.getNetworkOperator() != null && phone.getNetworkOperator().length() > 3) {
                int mcc = Integer.parseInt(phone.getNetworkOperator().substring(0, 3));
                int mnc = Integer.parseInt(phone.getNetworkOperator().substring(3));
                int networkType = phone.getNetworkType();
                int type = networkType == 3 || networkType == 8 || networkType == 9 || networkType == 10 ? 2 : 1;
                this.native_agps_set_ref_location_cellid(type, mcc, mnc, gsm_cell.getLac(), gsm_cell.getCid());
            } else {
                Log.e((String)"GpsLocationProvider", (String)"Error getting cell location info.");
            }
        } else {
            Log.e((String)"GpsLocationProvider", (String)"CDMA not supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(int message, int arg, Object obj) {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            this.mPendingMessageBits |= 1 << message;
            this.mWakeLock.acquire();
            this.mHandler.removeMessages(message);
            Message m = Message.obtain((Handler)this.mHandler, (int)message);
            m.arg1 = arg;
            m.obj = obj;
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectedApn() {
        Uri uri = Uri.parse((String)"content://telephony/carriers/preferapn");
        String apn = null;
        Cursor cursor = this.mContext.getContentResolver().query(uri, new String[]{"apn"}, null, null, "name ASC");
        if (null != cursor) {
            try {
                if (cursor.moveToFirst()) {
                    apn = cursor.getString(0);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                cursor.close();
                throw throwable;
            }
            cursor.close();
            {
            }
        }
        return apn;
    }

    private static native void class_init_native();

    private static native boolean native_is_supported();

    private native boolean native_init();

    private native void native_cleanup();

    private native boolean native_set_position_mode(int var1, int var2, int var3, int var4, int var5);

    private native boolean native_start();

    private native boolean native_stop();

    private native void native_delete_aiding_data(int var1);

    private native int native_read_sv_status(int[] var1, float[] var2, float[] var3, float[] var4, int[] var5);

    private native int native_read_nmea(byte[] var1, int var2);

    private native void native_inject_location(double var1, double var3, float var5);

    private native void native_inject_time(long var1, long var3, int var5);

    private native boolean native_supports_xtra();

    private native void native_inject_xtra_data(byte[] var1, int var2);

    private native String native_get_internal_state();

    private native void native_agps_data_conn_open(String var1);

    private native void native_agps_data_conn_closed();

    private native void native_agps_data_conn_failed();

    private native void native_agps_ni_message(byte[] var1, int var2);

    private native void native_set_agps_server(int var1, String var2, int var3);

    private native void native_send_ni_response(int var1, int var2);

    private native void native_agps_set_ref_location_cellid(int var1, int var2, int var3, int var4, int var5);

    private native void native_agps_set_id(int var1, String var2);

    private native void native_update_network_state(boolean var1, int var2, boolean var3, boolean var4, String var5, String var6);

    static {
        GpsLocationProvider.class_init_native();
    }

    private final class GpsLocationProviderThread
    extends Thread {
        public GpsLocationProviderThread() {
            super("GpsLocationProvider");
        }

        public void run() {
            Process.setThreadPriority((int)10);
            GpsLocationProvider.this.initialize();
            Looper.prepare();
            GpsLocationProvider.this.mHandler = new ProviderHandler();
            GpsLocationProvider.this.mInitializedLatch.countDown();
            Looper.loop();
        }
    }

    private final class ProviderHandler
    extends Handler {
        private ProviderHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            int message = msg.what;
            switch (message) {
                case 2: {
                    if (msg.arg1 == 1) {
                        GpsLocationProvider.this.handleEnable();
                        break;
                    }
                    GpsLocationProvider.this.handleDisable();
                    break;
                }
                case 3: {
                    GpsLocationProvider.this.handleEnableLocationTracking(msg.arg1 == 1);
                    break;
                }
                case 10: {
                    GpsLocationProvider.this.handleRequestSingleShot();
                    break;
                }
                case 4: {
                    GpsLocationProvider.this.handleUpdateNetworkState(msg.arg1, (NetworkInfo)msg.obj);
                    break;
                }
                case 5: {
                    GpsLocationProvider.this.handleInjectNtpTime();
                    break;
                }
                case 6: {
                    if (!GpsLocationProvider.this.mSupportsXtra) break;
                    GpsLocationProvider.this.handleDownloadXtraData();
                    break;
                }
                case 7: {
                    GpsLocationProvider.this.handleUpdateLocation((Location)msg.obj);
                    break;
                }
                case 8: {
                    GpsLocationProvider.this.handleAddListener(msg.arg1);
                    break;
                }
                case 9: {
                    GpsLocationProvider.this.handleRemoveListener(msg.arg1);
                }
            }
            PowerManager.WakeLock wakeLock = GpsLocationProvider.this.mWakeLock;
            synchronized (wakeLock) {
                GpsLocationProvider.this.mPendingMessageBits &= ~(1 << message);
                if (message == 8 || message == 9) {
                    GpsLocationProvider.this.mPendingListenerMessages--;
                }
                if (GpsLocationProvider.this.mPendingMessageBits == 0 && GpsLocationProvider.this.mPendingListenerMessages == 0) {
                    GpsLocationProvider.this.mWakeLock.release();
                }
            }
        }
    }

    private final class Listener
    implements IBinder.DeathRecipient {
        final IGpsStatusListener mListener;
        int mSensors = 0;

        Listener(IGpsStatusListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = GpsLocationProvider.this.mListeners;
            synchronized (arrayList) {
                GpsLocationProvider.this.mListeners.remove(this);
            }
            if (this.mListener != null) {
                this.mListener.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    }
}

