/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.Address;
import android.location.Country;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Slog;
import com.android.server.location.CountryDetectorBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationBasedCountryDetector
extends CountryDetectorBase {
    private static final String TAG = "LocationBasedCountryDetector";
    private static final long QUERY_LOCATION_TIMEOUT = 300000L;
    protected Timer mTimer;
    protected Thread mQueryThread;
    protected List<LocationListener> mLocationListeners;
    private LocationManager mLocationManager;
    private List<String> mEnabledProviders;

    public LocationBasedCountryDetector(Context ctx) {
        super(ctx);
        this.mLocationManager = (LocationManager)ctx.getSystemService("location");
    }

    protected String getCountryFromLocation(Location location) {
        String country = null;
        Geocoder geoCoder = new Geocoder(this.mContext);
        try {
            List addresses = geoCoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            if (addresses != null && addresses.size() > 0) {
                country = ((Address)addresses.get(0)).getCountryCode();
            }
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)"Exception occurs when getting country from location");
        }
        return country;
    }

    protected boolean isAcceptableProvider(String provider) {
        return "passive".equals(provider);
    }

    protected void registerListener(String provider, LocationListener listener) {
        this.mLocationManager.requestLocationUpdates(provider, 0L, 0.0f, listener);
    }

    protected void unregisterListener(LocationListener listener) {
        this.mLocationManager.removeUpdates(listener);
    }

    protected Location getLastKnownLocation() {
        List providers = this.mLocationManager.getAllProviders();
        Location bestLocation = null;
        for (String provider : providers) {
            Location lastKnownLocation = this.mLocationManager.getLastKnownLocation(provider);
            if (lastKnownLocation == null || bestLocation != null && bestLocation.getTime() >= lastKnownLocation.getTime()) continue;
            bestLocation = lastKnownLocation;
        }
        return bestLocation;
    }

    protected long getQueryLocationTimeout() {
        return 300000L;
    }

    protected List<String> getEnabledProviders() {
        if (this.mEnabledProviders == null) {
            this.mEnabledProviders = this.mLocationManager.getProviders(true);
        }
        return this.mEnabledProviders;
    }

    @Override
    public synchronized Country detectCountry() {
        if (this.mLocationListeners != null) {
            throw new IllegalStateException();
        }
        List<String> enabledProviders = this.getEnabledProviders();
        int totalProviders = enabledProviders.size();
        if (totalProviders > 0) {
            this.mLocationListeners = new ArrayList<LocationListener>(totalProviders);
            for (int i = 0; i < totalProviders; ++i) {
                String provider = enabledProviders.get(i);
                if (!this.isAcceptableProvider(provider)) continue;
                LocationListener listener = new LocationListener(){

                    public void onLocationChanged(Location location) {
                        if (location != null) {
                            LocationBasedCountryDetector.this.stop();
                            LocationBasedCountryDetector.this.queryCountryCode(location);
                        }
                    }

                    public void onProviderDisabled(String provider) {
                    }

                    public void onProviderEnabled(String provider) {
                    }

                    public void onStatusChanged(String provider, int status, Bundle extras) {
                    }
                };
                this.mLocationListeners.add(listener);
                this.registerListener(provider, listener);
            }
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                public void run() {
                    LocationBasedCountryDetector.this.mTimer = null;
                    LocationBasedCountryDetector.this.stop();
                    LocationBasedCountryDetector.this.queryCountryCode(LocationBasedCountryDetector.this.getLastKnownLocation());
                }
            }, this.getQueryLocationTimeout());
        } else {
            this.queryCountryCode(this.getLastKnownLocation());
        }
        return this.mDetectedCountry;
    }

    @Override
    public synchronized void stop() {
        if (this.mLocationListeners != null) {
            for (LocationListener listener : this.mLocationListeners) {
                this.unregisterListener(listener);
            }
            this.mLocationListeners = null;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private synchronized void queryCountryCode(final Location location) {
        if (location == null) {
            this.notifyListener(null);
            return;
        }
        if (this.mQueryThread != null) {
            return;
        }
        this.mQueryThread = new Thread(new Runnable(){

            public void run() {
                String countryIso = null;
                if (location != null) {
                    countryIso = LocationBasedCountryDetector.this.getCountryFromLocation(location);
                }
                LocationBasedCountryDetector.this.mDetectedCountry = countryIso != null ? new Country(countryIso, 1) : null;
                LocationBasedCountryDetector.this.notifyListener(LocationBasedCountryDetector.this.mDetectedCountry);
                LocationBasedCountryDetector.this.mQueryThread = null;
            }
        });
        this.mQueryThread.start();
    }
}

