/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Criteria;
import android.location.ILocationProvider;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.internal.location.DummyLocationProvider;
import com.android.server.location.LocationProviderInterface;

public class LocationProviderProxy
implements LocationProviderInterface {
    private static final String TAG = "LocationProviderProxy";
    private final Context mContext;
    private final String mName;
    private final Intent mIntent;
    private final Handler mHandler;
    private final Object mMutex = new Object();
    private Connection mServiceConnection = new Connection();
    private boolean mLocationTracking = false;
    private boolean mEnabled = false;
    private long mMinTime = -1L;
    private WorkSource mMinTimeSource = new WorkSource();
    private int mNetworkState;
    private NetworkInfo mNetworkInfo;

    public LocationProviderProxy(Context context, String name, String serviceName, Handler handler) {
        this.mContext = context;
        this.mName = name;
        this.mIntent = new Intent(serviceName);
        this.mHandler = handler;
        this.mContext.bindService(this.mIntent, (ServiceConnection)this.mServiceConnection, 21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            this.mServiceConnection = new Connection();
            this.mContext.bindService(this.mIntent, (ServiceConnection)this.mServiceConnection, 21);
        }
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DummyLocationProvider getCachedAttributes() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mServiceConnection.getCachedAttributes();
        }
    }

    public boolean requiresNetwork() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.requiresNetwork();
        }
        return false;
    }

    public boolean requiresSatellite() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.requiresSatellite();
        }
        return false;
    }

    public boolean requiresCell() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.requiresCell();
        }
        return false;
    }

    public boolean hasMonetaryCost() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.hasMonetaryCost();
        }
        return false;
    }

    public boolean supportsAltitude() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.supportsAltitude();
        }
        return false;
    }

    public boolean supportsSpeed() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.supportsSpeed();
        }
        return false;
    }

    public boolean supportsBearing() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.supportsBearing();
        }
        return false;
    }

    public int getPowerRequirement() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.getPowerRequirement();
        }
        return -1;
    }

    public int getAccuracy() {
        DummyLocationProvider cachedAttributes = this.getCachedAttributes();
        if (cachedAttributes != null) {
            return cachedAttributes.getAccuracy();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean meetsCriteria(Criteria criteria) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    return provider.meetsCriteria(criteria);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < this.getAccuracy()) {
            return false;
        }
        int criteriaPower = criteria.getPowerRequirement();
        if (criteriaPower != 0 && criteriaPower < this.getPowerRequirement()) {
            return false;
        }
        if (criteria.isAltitudeRequired() && !this.supportsAltitude()) {
            return false;
        }
        if (criteria.isSpeedRequired() && !this.supportsSpeed()) {
            return false;
        }
        return !criteria.isBearingRequired() || this.supportsBearing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mEnabled = true;
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.enable();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mEnabled = false;
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.disable();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(Bundle extras) {
        ILocationProvider provider;
        Object object = this.mMutex;
        synchronized (object) {
            provider = this.mServiceConnection.getProvider();
        }
        if (provider != null) {
            try {
                return provider.getStatus(extras);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStatusUpdateTime() {
        ILocationProvider provider;
        Object object = this.mMutex;
        synchronized (object) {
            provider = this.mServiceConnection.getProvider();
        }
        if (provider != null) {
            try {
                return provider.getStatusUpdateTime();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInternalState() {
        ILocationProvider provider;
        Object object = this.mMutex;
        synchronized (object) {
            provider = this.mServiceConnection.getProvider();
        }
        if (provider != null) {
            try {
                return provider.getInternalState();
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"getInternalState failed", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocationTracking() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mLocationTracking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLocationTracking(boolean enable) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider;
            this.mLocationTracking = enable;
            if (!enable) {
                this.mMinTime = -1L;
                this.mMinTimeSource.clear();
            }
            if ((provider = this.mServiceConnection.getProvider()) != null) {
                try {
                    provider.enableLocationTracking(enable);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean requestSingleShotFix() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinTime() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mMinTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinTime(long minTime, WorkSource ws) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mMinTime = minTime;
            this.mMinTimeSource.set(ws);
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.setMinTime(minTime, ws);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNetworkState(int state, NetworkInfo info) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mNetworkState = state;
            this.mNetworkInfo = info;
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.updateNetworkState(state, info);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(Location location) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.updateLocation(location);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendExtraCommand(String command, Bundle extras) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    return provider.sendExtraCommand(command, extras);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(int uid) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.addListener(uid);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(int uid) {
        Object object = this.mMutex;
        synchronized (object) {
            ILocationProvider provider = this.mServiceConnection.getProvider();
            if (provider != null) {
                try {
                    provider.removeListener(uid);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    private class Connection
    implements ServiceConnection,
    Runnable {
        private ILocationProvider mProvider;
        private DummyLocationProvider mCachedAttributes;

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Connection connection = this;
            synchronized (connection) {
                this.mProvider = ILocationProvider.Stub.asInterface((IBinder)service);
                if (this.mProvider != null) {
                    LocationProviderProxy.this.mHandler.post((Runnable)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Connection connection = this;
            synchronized (connection) {
                this.mProvider = null;
            }
        }

        public synchronized ILocationProvider getProvider() {
            return this.mProvider;
        }

        public synchronized DummyLocationProvider getCachedAttributes() {
            return this.mCachedAttributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = LocationProviderProxy.this.mMutex;
            synchronized (object) {
                if (LocationProviderProxy.this.mServiceConnection != this) {
                    return;
                }
                ILocationProvider provider = this.getProvider();
                if (provider == null) {
                    return;
                }
                try {
                    if (LocationProviderProxy.this.mEnabled) {
                        provider.enable();
                    }
                    if (LocationProviderProxy.this.mLocationTracking) {
                        provider.enableLocationTracking(true);
                    }
                    if (LocationProviderProxy.this.mMinTime >= 0L) {
                        provider.setMinTime(LocationProviderProxy.this.mMinTime, LocationProviderProxy.this.mMinTimeSource);
                    }
                    if (LocationProviderProxy.this.mNetworkInfo != null) {
                        provider.updateNetworkState(LocationProviderProxy.this.mNetworkState, LocationProviderProxy.this.mNetworkInfo);
                    }
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (this.mCachedAttributes == null) {
                    try {
                        this.mCachedAttributes = new DummyLocationProvider(LocationProviderProxy.this.mName, null);
                        this.mCachedAttributes.setRequiresNetwork(provider.requiresNetwork());
                        this.mCachedAttributes.setRequiresSatellite(provider.requiresSatellite());
                        this.mCachedAttributes.setRequiresCell(provider.requiresCell());
                        this.mCachedAttributes.setHasMonetaryCost(provider.hasMonetaryCost());
                        this.mCachedAttributes.setSupportsAltitude(provider.supportsAltitude());
                        this.mCachedAttributes.setSupportsSpeed(provider.supportsSpeed());
                        this.mCachedAttributes.setSupportsBearing(provider.supportsBearing());
                        this.mCachedAttributes.setPowerRequirement(provider.getPowerRequirement());
                        this.mCachedAttributes.setAccuracy(provider.getAccuracy());
                    }
                    catch (RemoteException e) {
                        this.mCachedAttributes = null;
                    }
                }
            }
        }
    }
}

