/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.Criteria;
import android.location.ILocationManager;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import com.android.server.location.LocationProviderInterface;
import java.io.PrintWriter;

public class MockProvider
implements LocationProviderInterface {
    private final String mName;
    private final ILocationManager mLocationManager;
    private final boolean mRequiresNetwork;
    private final boolean mRequiresSatellite;
    private final boolean mRequiresCell;
    private final boolean mHasMonetaryCost;
    private final boolean mSupportsAltitude;
    private final boolean mSupportsSpeed;
    private final boolean mSupportsBearing;
    private final int mPowerRequirement;
    private final int mAccuracy;
    private final Location mLocation;
    private int mStatus;
    private long mStatusUpdateTime;
    private final Bundle mExtras = new Bundle();
    private boolean mHasLocation;
    private boolean mHasStatus;
    private boolean mEnabled;
    private static final String TAG = "MockProvider";

    public MockProvider(String name, ILocationManager locationManager, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        this.mName = name;
        this.mLocationManager = locationManager;
        this.mRequiresNetwork = requiresNetwork;
        this.mRequiresSatellite = requiresSatellite;
        this.mRequiresCell = requiresCell;
        this.mHasMonetaryCost = hasMonetaryCost;
        this.mSupportsAltitude = supportsAltitude;
        this.mSupportsBearing = supportsBearing;
        this.mSupportsSpeed = supportsSpeed;
        this.mPowerRequirement = powerRequirement;
        this.mAccuracy = accuracy;
        this.mLocation = new Location(name);
    }

    public String getName() {
        return this.mName;
    }

    public void disable() {
        this.mEnabled = false;
    }

    public void enable() {
        this.mEnabled = true;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public int getStatus(Bundle extras) {
        if (this.mHasStatus) {
            extras.clear();
            extras.putAll(this.mExtras);
            return this.mStatus;
        }
        return 2;
    }

    public long getStatusUpdateTime() {
        return this.mStatusUpdateTime;
    }

    public int getAccuracy() {
        return this.mAccuracy;
    }

    public int getPowerRequirement() {
        return this.mPowerRequirement;
    }

    public boolean hasMonetaryCost() {
        return this.mHasMonetaryCost;
    }

    public boolean requiresCell() {
        return this.mRequiresCell;
    }

    public boolean requiresNetwork() {
        return this.mRequiresNetwork;
    }

    public boolean requiresSatellite() {
        return this.mRequiresSatellite;
    }

    public boolean supportsAltitude() {
        return this.mSupportsAltitude;
    }

    public boolean supportsBearing() {
        return this.mSupportsBearing;
    }

    public boolean supportsSpeed() {
        return this.mSupportsSpeed;
    }

    public boolean meetsCriteria(Criteria criteria) {
        if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < this.mAccuracy) {
            return false;
        }
        int criteriaPower = criteria.getPowerRequirement();
        if (criteriaPower != 0 && criteriaPower < this.mPowerRequirement) {
            return false;
        }
        if (criteria.isAltitudeRequired() && !this.mSupportsAltitude) {
            return false;
        }
        if (criteria.isSpeedRequired() && !this.mSupportsSpeed) {
            return false;
        }
        return !criteria.isBearingRequired() || this.mSupportsBearing;
    }

    public void setLocation(Location l) {
        this.mLocation.set(l);
        this.mHasLocation = true;
        try {
            this.mLocationManager.reportLocation(this.mLocation, false);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException calling reportLocation");
        }
    }

    public void clearLocation() {
        this.mHasLocation = false;
    }

    public void setStatus(int status, Bundle extras, long updateTime) {
        this.mStatus = status;
        this.mStatusUpdateTime = updateTime;
        this.mExtras.clear();
        if (extras != null) {
            this.mExtras.putAll(extras);
        }
        this.mHasStatus = true;
    }

    public void clearStatus() {
        this.mHasStatus = false;
        this.mStatusUpdateTime = 0L;
    }

    public String getInternalState() {
        return null;
    }

    public void enableLocationTracking(boolean enable) {
    }

    public boolean requestSingleShotFix() {
        return false;
    }

    public void setMinTime(long minTime, WorkSource ws) {
    }

    public void updateNetworkState(int state, NetworkInfo info) {
    }

    public void updateLocation(Location location) {
    }

    public boolean sendExtraCommand(String command, Bundle extras) {
        return false;
    }

    public void addListener(int uid) {
    }

    public void removeListener(int uid) {
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + this.mName);
        pw.println(prefix + "mHasLocation=" + this.mHasLocation);
        pw.println(prefix + "mLocation:");
        this.mLocation.dump((Printer)new PrintWriterPrinter(pw), prefix + "  ");
        pw.println(prefix + "mHasStatus=" + this.mHasStatus);
        pw.println(prefix + "mStatus=" + this.mStatus);
        pw.println(prefix + "mStatusUpdateTime=" + this.mStatusUpdateTime);
        pw.println(prefix + "mExtras=" + this.mExtras);
    }
}

