/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.Criteria;
import android.location.ILocationManager;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.server.location.LocationProviderInterface;

public class PassiveProvider
implements LocationProviderInterface {
    private static final String TAG = "PassiveProvider";
    private final ILocationManager mLocationManager;
    private boolean mTracking;

    public PassiveProvider(ILocationManager locationManager) {
        this.mLocationManager = locationManager;
    }

    public String getName() {
        return "passive";
    }

    public boolean requiresNetwork() {
        return false;
    }

    public boolean requiresSatellite() {
        return false;
    }

    public boolean requiresCell() {
        return false;
    }

    public boolean hasMonetaryCost() {
        return false;
    }

    public boolean supportsAltitude() {
        return false;
    }

    public boolean supportsSpeed() {
        return false;
    }

    public boolean supportsBearing() {
        return false;
    }

    public int getPowerRequirement() {
        return -1;
    }

    public boolean meetsCriteria(Criteria criteria) {
        return false;
    }

    public int getAccuracy() {
        return -1;
    }

    public boolean isEnabled() {
        return true;
    }

    public void enable() {
    }

    public void disable() {
    }

    public int getStatus(Bundle extras) {
        if (this.mTracking) {
            return 2;
        }
        return 1;
    }

    public long getStatusUpdateTime() {
        return -1L;
    }

    public String getInternalState() {
        return null;
    }

    public void enableLocationTracking(boolean enable) {
        this.mTracking = enable;
    }

    public boolean requestSingleShotFix() {
        return false;
    }

    public void setMinTime(long minTime, WorkSource ws) {
    }

    public void updateNetworkState(int state, NetworkInfo info) {
    }

    public void updateLocation(Location location) {
        if (this.mTracking) {
            try {
                this.mLocationManager.reportLocation(location, true);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"RemoteException calling reportLocation");
            }
        }
    }

    public boolean sendExtraCommand(String command, Bundle extras) {
        return false;
    }

    public void addListener(int uid) {
    }

    public void removeListener(int uid) {
    }
}

