/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.NetworkIdentity;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkIdentitySet
extends HashSet<NetworkIdentity> {
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADD_ROAMING = 2;

    public NetworkIdentitySet() {
    }

    public NetworkIdentitySet(DataInputStream in) throws IOException {
        int version = in.readInt();
        switch (version) {
            case 1: {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    int ignoredVersion = in.readInt();
                    int type = in.readInt();
                    int subType = in.readInt();
                    String subscriberId = NetworkIdentitySet.readOptionalString(in);
                    this.add(new NetworkIdentity(type, subType, subscriberId, false));
                }
                break;
            }
            case 2: {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    int type = in.readInt();
                    int subType = in.readInt();
                    String subscriberId = NetworkIdentitySet.readOptionalString(in);
                    boolean roaming = in.readBoolean();
                    this.add(new NetworkIdentity(type, subType, subscriberId, roaming));
                }
                break;
            }
            default: {
                throw new ProtocolException("unexpected version: " + version);
            }
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.size());
        for (NetworkIdentity ident : this) {
            out.writeInt(ident.getType());
            out.writeInt(ident.getSubType());
            NetworkIdentitySet.writeOptionalString(out, ident.getSubscriberId());
            out.writeBoolean(ident.getRoaming());
        }
    }

    private static void writeOptionalString(DataOutputStream out, String value) throws IOException {
        if (value != null) {
            out.writeByte(1);
            out.writeUTF(value);
        } else {
            out.writeByte(0);
        }
    }

    private static String readOptionalString(DataInputStream in) throws IOException {
        if (in.readByte() != 0) {
            return in.readUTF();
        }
        return null;
    }
}

