/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkPolicy;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IInterface;
import android.os.INetworkManagementService;
import android.os.IPowerManager;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.text.format.Time;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import android.util.Xml;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Objects;
import com.android.internal.util.Preconditions;
import com.android.server.net.NetworkAlertObserver;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class NetworkPolicyManagerService
extends INetworkPolicyManager.Stub {
    private static final String TAG = "NetworkPolicy";
    private static final boolean LOGD = true;
    private static final boolean LOGV = false;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADDED_SNOOZE = 2;
    private static final int VERSION_ADDED_RESTRICT_BACKGROUND = 3;
    private static final long KB_IN_BYTES = 1024L;
    private static final long MB_IN_BYTES = 0x100000L;
    private static final long GB_IN_BYTES = 0x40000000L;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_LIMIT = 2;
    public static final int TYPE_LIMIT_SNOOZED = 3;
    private static final String TAG_POLICY_LIST = "policy-list";
    private static final String TAG_NETWORK_POLICY = "network-policy";
    private static final String TAG_UID_POLICY = "uid-policy";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_RESTRICT_BACKGROUND = "restrictBackground";
    private static final String ATTR_NETWORK_TEMPLATE = "networkTemplate";
    private static final String ATTR_SUBSCRIBER_ID = "subscriberId";
    private static final String ATTR_CYCLE_DAY = "cycleDay";
    private static final String ATTR_WARNING_BYTES = "warningBytes";
    private static final String ATTR_LIMIT_BYTES = "limitBytes";
    private static final String ATTR_LAST_SNOOZE = "lastSnooze";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_POLICY = "policy";
    private static final String TAG_ALLOW_BACKGROUND = "NetworkPolicy:allowBackground";
    public static final String ACTION_ALLOW_BACKGROUND = "com.android.server.action.ACTION_ALLOW_BACKGROUND";
    private static final long TIME_CACHE_MAX_AGE = 86400000L;
    private static final int MSG_RULES_CHANGED = 1;
    private static final int MSG_METERED_IFACES_CHANGED = 2;
    private static final int MSG_FOREGROUND_ACTIVITIES_CHANGED = 3;
    private static final int MSG_PROCESS_DIED = 4;
    private static final int MSG_LIMIT_REACHED = 5;
    private final Context mContext;
    private final IActivityManager mActivityManager;
    private final IPowerManager mPowerManager;
    private final INetworkStatsService mNetworkStats;
    private final INetworkManagementService mNetworkManager;
    private final TrustedTime mTime;
    private IConnectivityManager mConnManager;
    private INotificationManager mNotifManager;
    private final Object mRulesLock = new Object();
    private volatile boolean mScreenOn;
    private volatile boolean mRestrictBackground;
    private final boolean mSuppressDefaultPolicy;
    private HashMap<NetworkTemplate, NetworkPolicy> mNetworkPolicy = Maps.newHashMap();
    private HashMap<NetworkPolicy, String[]> mNetworkRules = Maps.newHashMap();
    private SparseIntArray mUidPolicy = new SparseIntArray();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private HashSet<NetworkTemplate> mOverLimitNotified = Sets.newHashSet();
    private HashSet<String> mActiveNotifs = Sets.newHashSet();
    private SparseBooleanArray mUidForeground = new SparseBooleanArray();
    private SparseArray<SparseBooleanArray> mUidPidForeground = new SparseArray();
    private final RemoteCallbackList<INetworkPolicyListener> mListeners = new RemoteCallbackList();
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final AtomicFile mPolicyFile;
    private IProcessObserver mProcessObserver = new IProcessObserver.Stub(){

        public void onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(3, pid, uid, (Object)foregroundActivities).sendToTarget();
        }

        public void onProcessDied(int pid, int uid) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(4, pid, uid).sendToTarget();
        }
    };
    private BroadcastReceiver mScreenReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateScreenOn();
            }
        }
    };
    private BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                } else if ("android.intent.action.UID_REMOVED".equals(action)) {
                    NetworkPolicyManagerService.this.mUidPolicy.delete(uid);
                    NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                    NetworkPolicyManagerService.this.writePolicyLocked();
                }
            }
        }
    };
    private BroadcastReceiver mStatsReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private BroadcastReceiver mAllowReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.setRestrictBackground(false);
        }
    };
    private INetworkManagementEventObserver mAlertObserver = new NetworkAlertObserver(){

        public void limitReached(String limitName, String iface) {
            NetworkPolicyManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkPolicyManagerService.TAG);
            if (!"globalAlert".equals(limitName)) {
                NetworkPolicyManagerService.this.mHandler.obtainMessage(5, (Object)iface).sendToTarget();
            }
        }
    };
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.ensureActiveMobilePolicyLocked();
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNetworkRulesLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    int uidRules = msg.arg2;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onUidRulesChanged(uid, uidRules);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 2: {
                    String[] meteredIfaces = (String[])msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onMeteredIfacesChanged(meteredIfaces);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 3: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    boolean foregroundActivities = (Boolean)msg.obj;
                    Object listener = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (listener) {
                        SparseBooleanArray pidForeground = (SparseBooleanArray)NetworkPolicyManagerService.this.mUidPidForeground.get(uid);
                        if (pidForeground == null) {
                            pidForeground = new SparseBooleanArray(2);
                            NetworkPolicyManagerService.this.mUidPidForeground.put(uid, (Object)pidForeground);
                        }
                        pidForeground.put(pid, foregroundActivities);
                        NetworkPolicyManagerService.this.computeUidForegroundLocked(uid);
                    }
                    return true;
                }
                case 4: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    Object foregroundActivities = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (foregroundActivities) {
                        SparseBooleanArray pidForeground = (SparseBooleanArray)NetworkPolicyManagerService.this.mUidPidForeground.get(uid);
                        if (pidForeground != null) {
                            pidForeground.delete(pid);
                            NetworkPolicyManagerService.this.computeUidForegroundLocked(uid);
                        }
                    }
                    return true;
                }
                case 5: {
                    String iface = (String)msg.obj;
                    NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
                    Object object = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (object) {
                        if (NetworkPolicyManagerService.this.mMeteredIfaces.contains(iface)) {
                            try {
                                NetworkPolicyManagerService.this.mNetworkStats.forceUpdate();
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                            NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                            NetworkPolicyManagerService.this.updateNotificationsLocked();
                        }
                    }
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement) {
        this(context, activityManager, powerManager, networkStats, networkManagement, (TrustedTime)NtpTrustedTime.getInstance((Context)context), NetworkPolicyManagerService.getSystemDir(), false);
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement, TrustedTime time, File systemDir, boolean suppressDefaultPolicy) {
        this.mContext = (Context)Preconditions.checkNotNull((Object)context, (Object)"missing context");
        this.mActivityManager = (IActivityManager)Preconditions.checkNotNull((Object)activityManager, (Object)"missing activityManager");
        this.mPowerManager = (IPowerManager)Preconditions.checkNotNull((Object)powerManager, (Object)"missing powerManager");
        this.mNetworkStats = (INetworkStatsService)Preconditions.checkNotNull((Object)networkStats, (Object)"missing networkStats");
        this.mNetworkManager = (INetworkManagementService)Preconditions.checkNotNull((Object)networkManagement, (Object)"missing networkManagement");
        this.mTime = (TrustedTime)Preconditions.checkNotNull((Object)time, (Object)"missing TrustedTime");
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), this.mHandlerCallback);
        this.mSuppressDefaultPolicy = suppressDefaultPolicy;
        this.mPolicyFile = new AtomicFile(new File(systemDir, "netpolicy.xml"));
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = (IConnectivityManager)Preconditions.checkNotNull((Object)connManager, (Object)"missing IConnectivityManager");
    }

    public void bindNotificationManager(INotificationManager notifManager) {
        this.mNotifManager = (INotificationManager)Preconditions.checkNotNull((Object)notifManager, (Object)"missing INotificationManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mRulesLock;
        synchronized (object) {
            this.readPolicyLocked();
            if (this.mRestrictBackground) {
                this.updateRulesForRestrictBackgroundLocked();
                this.updateNotificationsLocked();
            }
        }
        this.updateScreenOn();
        try {
            this.mActivityManager.registerProcessObserver(this.mProcessObserver);
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        IntentFilter screenFilter = new IntentFilter();
        screenFilter.addAction("android.intent.action.SCREEN_ON");
        screenFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver(this.mScreenReceiver, screenFilter, null, this.mHandler);
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.UID_REMOVED");
        this.mContext.registerReceiver(this.mPackageReceiver, packageFilter, null, this.mHandler);
        IntentFilter statsFilter = new IntentFilter("com.android.server.action.NETWORK_STATS_UPDATED");
        this.mContext.registerReceiver(this.mStatsReceiver, statsFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter allowFilter = new IntentFilter(ACTION_ALLOW_BACKGROUND);
        this.mContext.registerReceiver(this.mAllowReceiver, allowFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
    }

    private void updateNotificationsLocked() {
        HashSet beforeNotifs = Sets.newHashSet();
        beforeNotifs.addAll(this.mActiveNotifs);
        this.mActiveNotifs.clear();
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            long end;
            if (!this.isTemplateRelevant(policy.template)) continue;
            long start = NetworkPolicyManager.computeLastCycleBoundary((long)currentTime, (NetworkPolicy)policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            if (policy.isOverLimit(totalBytes)) {
                if (policy.lastSnooze >= start) {
                    this.enqueueNotification(policy, 3, totalBytes);
                    continue;
                }
                this.enqueueNotification(policy, 2, totalBytes);
                this.notifyOverLimitLocked(policy.template);
                continue;
            }
            this.notifyUnderLimitLocked(policy.template);
            if (policy.warningBytes == -1L || totalBytes < policy.warningBytes) continue;
            this.enqueueNotification(policy, 1, totalBytes);
        }
        if (this.mRestrictBackground) {
            this.enqueueRestrictedNotification(TAG_ALLOW_BACKGROUND);
        }
        for (String tag : beforeNotifs) {
            if (this.mActiveNotifs.contains(tag)) continue;
            this.cancelNotification(tag);
        }
    }

    private boolean isTemplateRelevant(NetworkTemplate template) {
        switch (template.getMatchRule()) {
            case 1: 
            case 2: 
            case 3: {
                return Objects.equal((Object)this.getActiveSubscriberId(), (Object)template.getSubscriberId());
            }
        }
        return true;
    }

    private void notifyOverLimitLocked(NetworkTemplate template) {
        if (!this.mOverLimitNotified.contains(template)) {
            this.mContext.startActivity(NetworkPolicyManagerService.buildNetworkOverLimitIntent(template));
            this.mOverLimitNotified.add(template);
        }
    }

    private void notifyUnderLimitLocked(NetworkTemplate template) {
        this.mOverLimitNotified.remove(template);
    }

    private String buildNotificationTag(NetworkPolicy policy, int type) {
        return "NetworkPolicy:" + policy.template.hashCode() + ":" + type;
    }

    private void enqueueNotification(NetworkPolicy policy, int type, long totalBytes) {
        String tag = this.buildNotificationTag(policy, type);
        Notification.Builder builder = new Notification.Builder(this.mContext);
        builder.setOnlyAlertOnce(true);
        builder.setOngoing(true);
        Resources res = this.mContext.getResources();
        switch (type) {
            case 1: {
                CharSequence title = res.getText(17040551);
                String body = res.getString(17040552);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText((CharSequence)body);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000));
                break;
            }
            case 2: {
                CharSequence title;
                CharSequence body = res.getText(17040557);
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040553);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040554);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040555);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040556);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setSmallIcon(17302765);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildNetworkOverLimitIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000));
                break;
            }
            case 3: {
                CharSequence title;
                long overBytes = totalBytes - policy.limitBytes;
                String body = res.getString(17040562, new Object[]{Formatter.formatFileSize((Context)this.mContext, (long)overBytes)});
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040558);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040559);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040560);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040561);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText((CharSequence)body);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000));
                break;
            }
        }
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, tag, 0, builder.getNotification(), idReceived);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void enqueueRestrictedNotification(String tag) {
        Resources res = this.mContext.getResources();
        Notification.Builder builder = new Notification.Builder(this.mContext);
        CharSequence title = res.getText(17040563);
        String body = res.getString(17040564);
        builder.setOnlyAlertOnce(true);
        builder.setOngoing(true);
        builder.setSmallIcon(17301624);
        builder.setTicker(title);
        builder.setContentTitle(title);
        builder.setContentText((CharSequence)body);
        Intent intent = NetworkPolicyManagerService.buildAllowBackgroundDataIntent();
        builder.setContentIntent(PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000));
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, tag, 0, builder.getNotification(), idReceived);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void cancelNotification(String tag) {
        try {
            String packageName = this.mContext.getPackageName();
            this.mNotifManager.cancelNotificationWithTag(packageName, tag, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateNetworkEnabledLocked() {
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            long end;
            if (policy.limitBytes == -1L) {
                this.setNetworkTemplateEnabled(policy.template, true);
                continue;
            }
            long start = NetworkPolicyManager.computeLastCycleBoundary((long)currentTime, (NetworkPolicy)policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            boolean overLimit = policy.isOverLimit(totalBytes) && policy.lastSnooze < start;
            boolean enabled = !overLimit;
            this.setNetworkTemplateEnabled(policy.template, enabled);
        }
    }

    private void setNetworkTemplateEnabled(NetworkTemplate template, boolean enabled) {
        switch (template.getMatchRule()) {
            case 1: 
            case 2: 
            case 3: {
                if (!Objects.equal((Object)this.getActiveSubscriberId(), (Object)template.getSubscriberId())) break;
                this.setPolicyDataEnable(0, enabled);
                this.setPolicyDataEnable(6, enabled);
                break;
            }
            case 4: {
                this.setPolicyDataEnable(1, enabled);
                break;
            }
            case 5: {
                this.setPolicyDataEnable(9, enabled);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected template");
            }
        }
    }

    private void updateNetworkRulesLocked() {
        NetworkIdentity ident;
        NetworkState[] states;
        try {
            states = this.mConnManager.getAllNetworkState();
        }
        catch (RemoteException e) {
            return;
        }
        HashMap networks = Maps.newHashMap();
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            String iface = state.linkProperties.getInterfaceName();
            ident = NetworkIdentity.buildNetworkIdentity((Context)this.mContext, (NetworkState)state);
            networks.put(ident, iface);
        }
        this.mNetworkRules.clear();
        ArrayList ifaceList = Lists.newArrayList();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            ifaceList.clear();
            for (Map.Entry entry : networks.entrySet()) {
                ident = (NetworkIdentity)entry.getKey();
                if (!policy.template.matches(ident)) continue;
                String iface = (String)entry.getValue();
                ifaceList.add(iface);
            }
            if (ifaceList.size() <= 0) continue;
            String[] ifaces = ifaceList.toArray(new String[ifaceList.size()]);
            this.mNetworkRules.put(policy, ifaces);
        }
        HashSet newMeteredIfaces = Sets.newHashSet();
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkRules.keySet()) {
            Object[] ifaces = this.mNetworkRules.get(policy);
            long start = NetworkPolicyManager.computeLastCycleBoundary((long)currentTime, (NetworkPolicy)policy);
            long end = currentTime;
            long totalBytes = this.getTotalBytes(policy.template, start, end);
            Slog.d((String)TAG, (String)("applying policy " + policy.toString() + " to ifaces " + Arrays.toString(ifaces)));
            boolean hasLimit = policy.limitBytes != -1L;
            if (!hasLimit) continue;
            long quotaBytes = policy.lastSnooze >= start ? Long.MAX_VALUE : Math.max(1L, policy.limitBytes - totalBytes);
            if (ifaces.length > 1) {
                Slog.w((String)TAG, (String)"shared quota unsupported; generating rule for each iface");
            }
            for (Object iface : ifaces) {
                this.removeInterfaceQuota((String)iface);
                this.setInterfaceQuota((String)iface, quotaBytes);
                newMeteredIfaces.add(iface);
            }
        }
        for (String iface : this.mMeteredIfaces) {
            if (newMeteredIfaces.contains(iface)) continue;
            this.removeInterfaceQuota(iface);
        }
        this.mMeteredIfaces = newMeteredIfaces;
        String[] meteredIfaces = this.mMeteredIfaces.toArray(new String[this.mMeteredIfaces.size()]);
        this.mHandler.obtainMessage(2, (Object)meteredIfaces).sendToTarget();
    }

    private void ensureActiveMobilePolicyLocked() {
        if (this.mSuppressDefaultPolicy) {
            return;
        }
        String subscriberId = this.getActiveSubscriberId();
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, false);
        boolean mobileDefined = false;
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            if (!policy.template.matches(probeIdent)) continue;
            mobileDefined = true;
        }
        if (!mobileDefined) {
            Slog.i((String)TAG, (String)"no policy for active mobile network; generating default policy");
            long warningBytes = (long)this.mContext.getResources().getInteger(17694763) * 0x100000L;
            Time time = new Time("UTC");
            time.setToNow();
            int cycleDay = time.monthDay;
            NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll((String)subscriberId);
            this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleDay, warningBytes, -1L, -1L));
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPolicyLocked() {
        this.mNetworkPolicy.clear();
        this.mUidPolicy.clear();
        FileInputStream fis = null;
        try {
            try {
                int type;
                fis = this.mPolicyFile.openRead();
                XmlPullParser in = Xml.newPullParser();
                in.setInput((InputStream)fis, null);
                int version = 1;
                while ((type = in.next()) != 1) {
                    String tag = in.getName();
                    if (type != 2) continue;
                    if (TAG_POLICY_LIST.equals(tag)) {
                        version = XmlUtils.readIntAttribute(in, ATTR_VERSION);
                        if (version >= 3) {
                            this.mRestrictBackground = XmlUtils.readBooleanAttribute(in, ATTR_RESTRICT_BACKGROUND);
                            continue;
                        }
                        this.mRestrictBackground = false;
                        continue;
                    }
                    if (TAG_NETWORK_POLICY.equals(tag)) {
                        int networkTemplate = XmlUtils.readIntAttribute(in, ATTR_NETWORK_TEMPLATE);
                        String subscriberId = in.getAttributeValue(null, ATTR_SUBSCRIBER_ID);
                        int cycleDay = XmlUtils.readIntAttribute(in, ATTR_CYCLE_DAY);
                        long warningBytes = XmlUtils.readLongAttribute(in, ATTR_WARNING_BYTES);
                        long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES);
                        long lastSnooze = version >= 2 ? XmlUtils.readLongAttribute(in, ATTR_LAST_SNOOZE) : -1L;
                        NetworkTemplate template = new NetworkTemplate(networkTemplate, subscriberId);
                        this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleDay, warningBytes, limitBytes, lastSnooze));
                        continue;
                    }
                    if (!TAG_UID_POLICY.equals(tag)) continue;
                    int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                    int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                    if (NetworkPolicyManager.isUidValidForPolicy((Context)this.mContext, (int)uid)) {
                        this.setUidPolicyUnchecked(uid, policy, false);
                        continue;
                    }
                    Slog.w((String)TAG, (String)("unable to apply policy to UID " + uid + "; ignoring"));
                }
                Object var17_17 = null;
            }
            catch (FileNotFoundException e) {
                this.upgradeLegacyBackgroundData();
                Object var17_18 = null;
                IoUtils.closeQuietly((AutoCloseable)fis);
                return;
            }
            catch (IOException e) {
                Log.wtf((String)TAG, (String)"problem reading network policy", (Throwable)e);
                Object var17_19 = null;
                IoUtils.closeQuietly((AutoCloseable)fis);
                return;
            }
            catch (XmlPullParserException e) {
                Log.wtf((String)TAG, (String)"problem reading network policy", (Throwable)e);
                Object var17_20 = null;
                IoUtils.closeQuietly((AutoCloseable)fis);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            IoUtils.closeQuietly((AutoCloseable)fis);
            throw throwable;
        }
        IoUtils.closeQuietly((AutoCloseable)fis);
    }

    private void upgradeLegacyBackgroundData() {
        boolean bl = this.mRestrictBackground = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"background_data", (int)1) != 1;
        if (this.mRestrictBackground) {
            Intent broadcast = new Intent("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
            this.mContext.sendBroadcast(broadcast);
        }
    }

    private void writePolicyLocked() {
        block5: {
            FileOutputStream fos = null;
            try {
                fos = this.mPolicyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput((OutputStream)fos, "utf-8");
                out.startDocument(null, Boolean.valueOf(true));
                out.startTag(null, TAG_POLICY_LIST);
                XmlUtils.writeIntAttribute((XmlSerializer)out, ATTR_VERSION, 3);
                XmlUtils.writeBooleanAttribute((XmlSerializer)out, ATTR_RESTRICT_BACKGROUND, this.mRestrictBackground);
                for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                    NetworkTemplate template = policy.template;
                    out.startTag(null, TAG_NETWORK_POLICY);
                    XmlUtils.writeIntAttribute((XmlSerializer)out, ATTR_NETWORK_TEMPLATE, template.getMatchRule());
                    String subscriberId = template.getSubscriberId();
                    if (subscriberId != null) {
                        out.attribute(null, ATTR_SUBSCRIBER_ID, subscriberId);
                    }
                    XmlUtils.writeIntAttribute((XmlSerializer)out, ATTR_CYCLE_DAY, policy.cycleDay);
                    XmlUtils.writeLongAttribute((XmlSerializer)out, ATTR_WARNING_BYTES, policy.warningBytes);
                    XmlUtils.writeLongAttribute((XmlSerializer)out, ATTR_LIMIT_BYTES, policy.limitBytes);
                    XmlUtils.writeLongAttribute((XmlSerializer)out, ATTR_LAST_SNOOZE, policy.lastSnooze);
                    out.endTag(null, TAG_NETWORK_POLICY);
                }
                for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                    int uid = this.mUidPolicy.keyAt(i);
                    int policy = this.mUidPolicy.valueAt(i);
                    if (policy == 0) continue;
                    out.startTag(null, TAG_UID_POLICY);
                    XmlUtils.writeIntAttribute((XmlSerializer)out, ATTR_UID, uid);
                    XmlUtils.writeIntAttribute((XmlSerializer)out, ATTR_POLICY, policy);
                    out.endTag(null, TAG_UID_POLICY);
                }
                out.endTag(null, TAG_POLICY_LIST);
                out.endDocument();
                this.mPolicyFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block5;
                this.mPolicyFile.failWrite(fos);
            }
        }
    }

    public void setUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!NetworkPolicyManager.isUidValidForPolicy((Context)this.mContext, (int)uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        this.setUidPolicyUnchecked(uid, policy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidPolicyUnchecked(int uid, int policy, boolean persist) {
        Object object = this.mRulesLock;
        synchronized (object) {
            int oldPolicy = this.getUidPolicy(uid);
            this.mUidPolicy.put(uid, policy);
            this.updateRulesForUidLocked(uid);
            if (persist) {
                this.writePolicyLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUidPolicy(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mUidPolicy.get(uid, 0);
        }
    }

    public void registerListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.register((IInterface)listener);
    }

    public void unregisterListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.unregister((IInterface)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkPolicies(NetworkPolicy[] policies) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mNetworkPolicy.clear();
            for (NetworkPolicy policy : policies) {
                this.mNetworkPolicy.put(policy.template, policy);
            }
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkPolicy[] getNetworkPolicies() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mNetworkPolicy.values().toArray(new NetworkPolicy[this.mNetworkPolicy.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snoozePolicy(NetworkTemplate template) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        long currentTime = this.currentTimeMillis();
        Object object = this.mRulesLock;
        synchronized (object) {
            NetworkPolicy policy = this.mNetworkPolicy.get(template);
            if (policy == null) {
                throw new IllegalArgumentException("unable to find policy for " + template);
            }
            policy.lastSnooze = currentTime;
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictBackground(boolean restrictBackground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mRestrictBackground = restrictBackground;
            this.updateRulesForRestrictBackgroundLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRestrictBackground() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mRestrictBackground;
        }
    }

    private NetworkPolicy findPolicyForNetworkLocked(NetworkIdentity ident) {
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            if (!policy.template.matches(ident)) continue;
            return policy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkQuotaInfo getNetworkQuotaInfo(NetworkState state) {
        NetworkQuotaInfo networkQuotaInfo;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            networkQuotaInfo = this.getNetworkQuotaInfoUnchecked(state);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity((long)token);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)token);
        return networkQuotaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkQuotaInfo getNetworkQuotaInfoUnchecked(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity((Context)this.mContext, (NetworkState)state);
        Object object = this.mRulesLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkLocked(ident);
        }
        if (policy == null) {
            return null;
        }
        long currentTime = this.currentTimeMillis();
        long start = NetworkPolicyManager.computeLastCycleBoundary((long)currentTime, (NetworkPolicy)policy);
        long end = currentTime;
        long totalBytes = this.getTotalBytes(policy.template, start, end);
        long softLimitBytes = policy.warningBytes != -1L ? policy.warningBytes : -1L;
        long hardLimitBytes = policy.limitBytes != -1L ? policy.limitBytes : -1L;
        return new NetworkQuotaInfo(totalBytes, softLimitBytes, hardLimitBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        HashSet<String> argSet = new HashSet<String>();
        for (String arg : args) {
            argSet.add(arg);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            if (argSet.contains("unsnooze")) {
                for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                    policy.lastSnooze = -1L;
                }
                this.writePolicyLocked();
                fout.println("Wiped snooze timestamps");
                return;
            }
            fout.print("Restrict background: ");
            fout.println(this.mRestrictBackground);
            fout.println("Network policies:");
            for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                fout.print("  ");
                fout.println(policy.toString());
            }
            fout.println("Policy status for known UIDs:");
            SparseBooleanArray knownUids = new SparseBooleanArray();
            NetworkPolicyManagerService.collectKeys(this.mUidPolicy, knownUids);
            NetworkPolicyManagerService.collectKeys(this.mUidForeground, knownUids);
            NetworkPolicyManagerService.collectKeys(this.mUidRules, knownUids);
            int size = knownUids.size();
            for (int i = 0; i < size; ++i) {
                int uid = knownUids.keyAt(i);
                fout.print("  UID=");
                fout.print(uid);
                fout.print(" policy=");
                int policyIndex = this.mUidPolicy.indexOfKey(uid);
                if (policyIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManager.dumpPolicy((PrintWriter)fout, (int)this.mUidPolicy.valueAt(policyIndex));
                }
                fout.print(" foreground=");
                int foregroundIndex = this.mUidPidForeground.indexOfKey(uid);
                if (foregroundIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManagerService.dumpSparseBooleanArray(fout, (SparseBooleanArray)this.mUidPidForeground.valueAt(foregroundIndex));
                }
                fout.print(" rules=");
                int rulesIndex = this.mUidRules.indexOfKey(uid);
                if (rulesIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManager.dumpRules((PrintWriter)fout, (int)this.mUidRules.valueAt(rulesIndex));
                }
                fout.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidForeground(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mUidForeground.get(uid, false) && this.mScreenOn;
        }
    }

    private void computeUidForegroundLocked(int uid) {
        boolean oldUidForeground;
        SparseBooleanArray pidForeground = (SparseBooleanArray)this.mUidPidForeground.get(uid);
        boolean uidForeground = false;
        int size = pidForeground.size();
        for (int i = 0; i < size; ++i) {
            if (!pidForeground.valueAt(i)) continue;
            uidForeground = true;
            break;
        }
        if ((oldUidForeground = this.mUidForeground.get(uid, false)) != uidForeground) {
            this.mUidForeground.put(uid, uidForeground);
            this.updateRulesForUidLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreenOn() {
        Object object = this.mRulesLock;
        synchronized (object) {
            try {
                this.mScreenOn = this.mPowerManager.isScreenOn();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.updateRulesForScreenLocked();
        }
    }

    private void updateRulesForScreenLocked() {
        int size = this.mUidForeground.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mUidForeground.valueAt(i)) continue;
            int uid = this.mUidForeground.keyAt(i);
            this.updateRulesForUidLocked(uid);
        }
    }

    private void updateRulesForRestrictBackgroundLocked() {
        int uid;
        PackageManager pm = this.mContext.getPackageManager();
        List apps = pm.getInstalledApplications(0);
        for (ApplicationInfo app : apps) {
            this.updateRulesForUidLocked(app.uid);
        }
        for (uid = 1000; uid <= 1025; ++uid) {
            this.updateRulesForUidLocked(uid);
        }
        for (uid = 2000; uid <= 2002; ++uid) {
            this.updateRulesForUidLocked(uid);
        }
        for (uid = 3000; uid <= 3007; ++uid) {
            this.updateRulesForUidLocked(uid);
        }
        for (uid = 9998; uid <= 9999; ++uid) {
            this.updateRulesForUidLocked(uid);
        }
    }

    private void updateRulesForUidLocked(int uid) {
        int uidPolicy = this.getUidPolicy(uid);
        boolean uidForeground = this.isUidForeground(uid);
        int uidRules = 0;
        if (!uidForeground && (uidPolicy & 1) != 0) {
            uidRules = 1;
        }
        if (!uidForeground && this.mRestrictBackground) {
            uidRules = 1;
        }
        if (uidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, uidRules);
        }
        boolean rejectMetered = (uidRules & 1) != 0;
        this.setUidNetworkRules(uid, rejectMetered);
        this.mHandler.obtainMessage(1, uid, uidRules).sendToTarget();
        try {
            this.mNetworkStats.setUidForeground(uid, uidForeground);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void setInterfaceQuota(String iface, long quotaBytes) {
        try {
            this.mNetworkManager.setInterfaceQuota(iface, quotaBytes);
        }
        catch (IllegalStateException e) {
            Log.wtf((String)TAG, (String)"problem setting interface quota", (Throwable)e);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void removeInterfaceQuota(String iface) {
        try {
            this.mNetworkManager.removeInterfaceQuota(iface);
        }
        catch (IllegalStateException e) {
            Log.wtf((String)TAG, (String)"problem removing interface quota", (Throwable)e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidNetworkRules(int uid, boolean rejectOnQuotaInterfaces) {
        try {
            this.mNetworkManager.setUidNetworkRules(uid, rejectOnQuotaInterfaces);
        }
        catch (IllegalStateException e) {
            Log.wtf((String)TAG, (String)"problem setting uid rules", (Throwable)e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setPolicyDataEnable(int networkType, boolean enabled) {
        try {
            this.mConnManager.setPolicyDataEnable(networkType, enabled);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private String getActiveSubscriberId() {
        TelephonyManager telephony = (TelephonyManager)this.mContext.getSystemService("phone");
        return telephony.getSubscriberId();
    }

    private long getTotalBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getSummaryForNetwork(template, start, end).getTotalBytes();
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    private void maybeRefreshTrustedTime() {
        if (this.mTime.getCacheAge() > 86400000L) {
            this.mTime.forceRefresh();
        }
    }

    private long currentTimeMillis() {
        return this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
    }

    private static Intent buildAllowBackgroundDataIntent() {
        return new Intent(ACTION_ALLOW_BACKGROUND);
    }

    private static Intent buildNetworkOverLimitIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.net.NetworkOverLimitActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", (Parcelable)template);
        return intent;
    }

    private static Intent buildViewDataUsageIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.settings", "com.android.settings.Settings$DataUsageSummaryActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", (Parcelable)template);
        return intent;
    }

    public void addIdleHandler(MessageQueue.IdleHandler handler) {
        this.mHandler.getLooper().getQueue().addIdleHandler(handler);
    }

    private static void collectKeys(SparseIntArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    private static void collectKeys(SparseBooleanArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    private static void dumpSparseBooleanArray(PrintWriter fout, SparseBooleanArray value) {
        fout.print("[");
        int size = value.size();
        for (int i = 0; i < size; ++i) {
            fout.print(value.keyAt(i) + "=" + value.valueAt(i));
            if (i >= size - 1) continue;
            fout.print(",");
        }
        fout.print("]");
    }

    public static class XmlUtils {
        public static int readIntAttribute(XmlPullParser in, String name) throws IOException {
            String value = in.getAttributeValue(null, name);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("problem parsing " + name + "=" + value + " as int");
            }
        }

        public static void writeIntAttribute(XmlSerializer out, String name, int value) throws IOException {
            out.attribute(null, name, Integer.toString(value));
        }

        public static long readLongAttribute(XmlPullParser in, String name) throws IOException {
            String value = in.getAttributeValue(null, name);
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
            }
        }

        public static void writeLongAttribute(XmlSerializer out, String name, long value) throws IOException {
            out.attribute(null, name, Long.toString(value));
        }

        public static boolean readBooleanAttribute(XmlPullParser in, String name) {
            String value = in.getAttributeValue(null, name);
            return Boolean.parseBoolean(value);
        }

        public static void writeBooleanAttribute(XmlSerializer out, String name, boolean value) throws IOException {
            out.attribute(null, name, Boolean.toString(value));
        }
    }
}

