/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkState;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.Objects;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.NetworkManagementSocketTagger;
import com.android.server.net.NetworkAlertObserver;
import com.android.server.net.NetworkIdentitySet;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkStatsService
extends INetworkStatsService.Stub {
    private static final String TAG = "NetworkStats";
    private static final boolean LOGD = false;
    private static final boolean LOGV = false;
    private static final int FILE_MAGIC = 1095648596;
    private static final int VERSION_NETWORK_INIT = 1;
    private static final int VERSION_UID_INIT = 1;
    private static final int VERSION_UID_WITH_IDENT = 2;
    private static final int VERSION_UID_WITH_TAG = 3;
    private static final int VERSION_UID_WITH_SET = 4;
    private static final int MSG_PERFORM_POLL = 1;
    private static final int MSG_UPDATE_IFACES = 2;
    private static final int FLAG_PERSIST_NETWORK = 1;
    private static final int FLAG_PERSIST_UID = 2;
    private static final int FLAG_PERSIST_ALL = 3;
    private static final int FLAG_PERSIST_FORCE = 256;
    private static final boolean ENABLE_SAMPLE_AFTER_POLL = true;
    private static final String TAG_NETSTATS_ERROR = "netstats_error";
    private final Context mContext;
    private final INetworkManagementService mNetworkManager;
    private final IAlarmManager mAlarmManager;
    private final TrustedTime mTime;
    private final TelephonyManager mTeleManager;
    private final NetworkStatsSettings mSettings;
    private final PowerManager.WakeLock mWakeLock;
    private IConnectivityManager mConnManager;
    private DropBoxManager mDropBox;
    public static final String ACTION_NETWORK_STATS_POLL = "com.android.server.action.NETWORK_STATS_POLL";
    public static final String ACTION_NETWORK_STATS_UPDATED = "com.android.server.action.NETWORK_STATS_UPDATED";
    private PendingIntent mPollIntent;
    private static final long KB_IN_BYTES = 1024L;
    private static final long MB_IN_BYTES = 0x100000L;
    private static final long GB_IN_BYTES = 0x40000000L;
    private final Object mStatsLock = new Object();
    private HashMap<String, NetworkIdentitySet> mActiveIfaces = Maps.newHashMap();
    private HashMap<NetworkIdentitySet, NetworkStatsHistory> mNetworkDevStats = Maps.newHashMap();
    private HashMap<NetworkIdentitySet, NetworkStatsHistory> mNetworkXtStats = Maps.newHashMap();
    private HashMap<UidStatsKey, NetworkStatsHistory> mUidStats = Maps.newHashMap();
    private boolean mNetworkStatsLoaded = false;
    private boolean mUidStatsLoaded = false;
    private NetworkStats mLastPollNetworkDevSnapshot;
    private NetworkStats mLastPollNetworkXtSnapshot;
    private NetworkStats mLastPollUidSnapshot;
    private NetworkStats mLastPollOperationsSnapshot;
    private NetworkStats mLastPersistNetworkDevSnapshot;
    private NetworkStats mLastPersistNetworkXtSnapshot;
    private NetworkStats mLastPersistUidSnapshot;
    private SparseIntArray mActiveUidCounterSet = new SparseIntArray();
    private NetworkStats mOperations = new NetworkStats(0L, 10);
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final AtomicFile mNetworkDevFile;
    private final AtomicFile mNetworkXtFile;
    private final AtomicFile mUidFile;
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.updateIfaces();
        }
    };
    private BroadcastReceiver mTetherReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(1);
        }
    };
    private BroadcastReceiver mPollReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(3);
            NetworkStatsService.this.registerGlobalAlert();
        }
    };
    private BroadcastReceiver mRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.mWakeLock.acquire();
                try {
                    NetworkStatsService.this.removeUidLocked(uid);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    NetworkStatsService.this.mWakeLock.release();
                    throw throwable;
                }
                NetworkStatsService.this.mWakeLock.release();
            }
        }
    };
    private BroadcastReceiver mShutdownReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.shutdownLocked();
            }
        }
    };
    private INetworkManagementEventObserver mAlertObserver = new NetworkAlertObserver(){

        public void limitReached(String limitName, String iface) {
            NetworkStatsService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkStatsService.TAG);
            if ("globalAlert".equals(limitName)) {
                boolean flags = true;
                NetworkStatsService.this.mHandler.obtainMessage(1, 1, 0).sendToTarget();
                NetworkStatsService.this.registerGlobalAlert();
            }
        }
    };
    private int mLastPhoneState = -1;
    private int mLastPhoneNetworkType = 0;
    private PhoneStateListener mPhoneListener = new PhoneStateListener(){

        public void onDataConnectionStateChanged(int state, int networkType) {
            boolean networkTypeChanged;
            boolean stateChanged = state != NetworkStatsService.this.mLastPhoneState;
            boolean bl = networkTypeChanged = networkType != NetworkStatsService.this.mLastPhoneNetworkType;
            if (networkTypeChanged && !stateChanged) {
                NetworkStatsService.this.mHandler.sendMessageDelayed(NetworkStatsService.this.mHandler.obtainMessage(2), 1000L);
            }
            NetworkStatsService.this.mLastPhoneState = state;
            NetworkStatsService.this.mLastPhoneNetworkType = networkType;
        }
    };
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int flags = msg.arg1;
                    NetworkStatsService.this.performPoll(flags);
                    return true;
                }
                case 2: {
                    NetworkStatsService.this.updateIfaces();
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkStatsService(Context context, INetworkManagementService networkManager, IAlarmManager alarmManager) {
        this(context, networkManager, alarmManager, (TrustedTime)NtpTrustedTime.getInstance((Context)context), NetworkStatsService.getSystemDir(), new DefaultNetworkStatsSettings(context));
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkStatsService(Context context, INetworkManagementService networkManager, IAlarmManager alarmManager, TrustedTime time, File systemDir, NetworkStatsSettings settings) {
        this.mContext = (Context)Preconditions.checkNotNull((Object)context, (Object)"missing Context");
        this.mNetworkManager = (INetworkManagementService)Preconditions.checkNotNull((Object)networkManager, (Object)"missing INetworkManagementService");
        this.mAlarmManager = (IAlarmManager)Preconditions.checkNotNull((Object)alarmManager, (Object)"missing IAlarmManager");
        this.mTime = (TrustedTime)Preconditions.checkNotNull((Object)time, (Object)"missing TrustedTime");
        this.mTeleManager = (TelephonyManager)Preconditions.checkNotNull((Object)TelephonyManager.getDefault(), (Object)"missing TelephonyManager");
        this.mSettings = (NetworkStatsSettings)Preconditions.checkNotNull((Object)settings, (Object)"missing NetworkStatsSettings");
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, TAG);
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), this.mHandlerCallback);
        this.mNetworkDevFile = new AtomicFile(new File(systemDir, "netstats.bin"));
        this.mNetworkXtFile = new AtomicFile(new File(systemDir, "netstats_xt.bin"));
        this.mUidFile = new AtomicFile(new File(systemDir, "netstats_uid.bin"));
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = (IConnectivityManager)Preconditions.checkNotNull((Object)connManager, (Object)"missing IConnectivityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.readNetworkDevStatsLocked();
            this.readNetworkXtStatsLocked();
            this.mNetworkStatsLoaded = true;
        }
        this.bootstrapStats();
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter tetherFilter = new IntentFilter("android.net.conn.TETHER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mTetherReceiver, tetherFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter pollFilter = new IntentFilter(ACTION_NETWORK_STATS_POLL);
        this.mContext.registerReceiver(this.mPollReceiver, pollFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter removedFilter = new IntentFilter("android.intent.action.UID_REMOVED");
        this.mContext.registerReceiver(this.mRemovedReceiver, removedFilter, null, this.mHandler);
        IntentFilter shutdownFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        this.mContext.registerReceiver(this.mShutdownReceiver, shutdownFilter);
        try {
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.mTeleManager.listen(this.mPhoneListener, 64);
        this.registerPollAlarmLocked();
        this.registerGlobalAlert();
        this.mDropBox = (DropBoxManager)this.mContext.getSystemService("dropbox");
    }

    private void shutdownLocked() {
        this.mContext.unregisterReceiver(this.mConnReceiver);
        this.mContext.unregisterReceiver(this.mTetherReceiver);
        this.mContext.unregisterReceiver(this.mPollReceiver);
        this.mContext.unregisterReceiver(this.mRemovedReceiver);
        this.mContext.unregisterReceiver(this.mShutdownReceiver);
        this.mTeleManager.listen(this.mPhoneListener, 0);
        if (this.mNetworkStatsLoaded) {
            this.writeNetworkDevStatsLocked();
            this.writeNetworkXtStatsLocked();
        }
        if (this.mUidStatsLoaded) {
            this.writeUidStatsLocked();
        }
        this.mNetworkDevStats.clear();
        this.mNetworkXtStats.clear();
        this.mUidStats.clear();
        this.mNetworkStatsLoaded = false;
        this.mUidStatsLoaded = false;
    }

    private void registerPollAlarmLocked() {
        try {
            if (this.mPollIntent != null) {
                this.mAlarmManager.remove(this.mPollIntent);
            }
            this.mPollIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_NETWORK_STATS_POLL), (int)0);
            long currentRealtime = SystemClock.elapsedRealtime();
            this.mAlarmManager.setInexactRepeating(3, currentRealtime, this.mSettings.getPollInterval(), this.mPollIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void registerGlobalAlert() {
        try {
            long alertBytes = this.mSettings.getPersistThreshold();
            this.mNetworkManager.setGlobalAlert(alertBytes);
        }
        catch (IllegalStateException e) {
            Slog.w((String)TAG, (String)("problem registering for global alert: " + e));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        return this.getHistoryForNetworkDev(template, fields);
    }

    private NetworkStatsHistory getHistoryForNetworkDev(NetworkTemplate template, int fields) {
        return this.getHistoryForNetwork(template, fields, this.mNetworkDevStats);
    }

    private NetworkStatsHistory getHistoryForNetworkXt(NetworkTemplate template, int fields) {
        return this.getHistoryForNetwork(template, fields, this.mNetworkXtStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields, HashMap<NetworkIdentitySet, NetworkStatsHistory> source) {
        Object object = this.mStatsLock;
        synchronized (object) {
            NetworkStatsHistory combined = new NetworkStatsHistory(this.mSettings.getNetworkBucketDuration(), this.estimateNetworkBuckets(), fields);
            for (NetworkIdentitySet ident : source.keySet()) {
                NetworkStatsHistory history;
                if (!NetworkStatsService.templateMatches(template, ident) || (history = source.get(ident)) == null) continue;
                combined.recordEntireHistory(history);
            }
            return combined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStatsHistory getHistoryForUid(NetworkTemplate template, int uid, int set, int tag, int fields) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        Object object = this.mStatsLock;
        synchronized (object) {
            this.ensureUidStatsLoadedLocked();
            NetworkStatsHistory combined = new NetworkStatsHistory(this.mSettings.getUidBucketDuration(), this.estimateUidBuckets(), fields);
            for (UidStatsKey key : this.mUidStats.keySet()) {
                boolean setMatches;
                boolean bl = setMatches = set == -1 || key.set == set;
                if (!NetworkStatsService.templateMatches(template, key.ident) || key.uid != uid || !setMatches || key.tag != tag) continue;
                NetworkStatsHistory history = this.mUidStats.get(key);
                combined.recordEntireHistory(history);
            }
            return combined;
        }
    }

    public NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        return this.getSummaryForNetworkDev(template, start, end);
    }

    private NetworkStats getSummaryForNetworkDev(NetworkTemplate template, long start, long end) {
        return this.getSummaryForNetwork(template, start, end, this.mNetworkDevStats);
    }

    private NetworkStats getSummaryForNetworkXt(NetworkTemplate template, long start, long end) {
        return this.getSummaryForNetwork(template, start, end, this.mNetworkXtStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end, HashMap<NetworkIdentitySet, NetworkStatsHistory> source) {
        Object object = this.mStatsLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            NetworkStats stats = new NetworkStats(end - start, 1);
            NetworkStats.Entry entry = new NetworkStats.Entry();
            NetworkStatsHistory.Entry historyEntry = null;
            for (NetworkIdentitySet ident : source.keySet()) {
                if (!NetworkStatsService.templateMatches(template, ident)) continue;
                NetworkStatsHistory history = source.get(ident);
                historyEntry = history.getValues(start, end, now, historyEntry);
                entry.iface = NetworkStats.IFACE_ALL;
                entry.uid = -1;
                entry.tag = 0;
                entry.rxBytes = historyEntry.rxBytes;
                entry.rxPackets = historyEntry.rxPackets;
                entry.txBytes = historyEntry.txBytes;
                entry.txPackets = historyEntry.txPackets;
                stats.combineValues(entry);
            }
            return stats;
        }
    }

    private long getHistoryStartLocked(NetworkTemplate template, HashMap<NetworkIdentitySet, NetworkStatsHistory> source) {
        long start = Long.MAX_VALUE;
        for (NetworkIdentitySet ident : source.keySet()) {
            if (!NetworkStatsService.templateMatches(template, ident)) continue;
            NetworkStatsHistory history = source.get(ident);
            start = Math.min(start, history.getStart());
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStats getSummaryForAllUid(NetworkTemplate template, long start, long end, boolean includeTags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        Object object = this.mStatsLock;
        synchronized (object) {
            this.ensureUidStatsLoadedLocked();
            long now = System.currentTimeMillis();
            NetworkStats stats = new NetworkStats(end - start, 24);
            NetworkStats.Entry entry = new NetworkStats.Entry();
            NetworkStatsHistory.Entry historyEntry = null;
            for (UidStatsKey key : this.mUidStats.keySet()) {
                if (!NetworkStatsService.templateMatches(template, key.ident) || key.tag != 0 && !includeTags) continue;
                NetworkStatsHistory history = this.mUidStats.get(key);
                historyEntry = history.getValues(start, end, now, historyEntry);
                entry.iface = NetworkStats.IFACE_ALL;
                entry.uid = key.uid;
                entry.set = key.set;
                entry.tag = key.tag;
                entry.rxBytes = historyEntry.rxBytes;
                entry.rxPackets = historyEntry.rxPackets;
                entry.txBytes = historyEntry.txBytes;
                entry.txPackets = historyEntry.txPackets;
                entry.operations = historyEntry.operations;
                if (entry.rxBytes <= 0L && entry.rxPackets <= 0L && entry.txBytes <= 0L && entry.txPackets <= 0L && entry.operations <= 0L) continue;
                stats.combineValues(entry);
            }
            return stats;
        }
    }

    public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        }
        NetworkStats networkLayer = this.mNetworkManager.getNetworkStatsUidDetail(uid);
        NetworkStats dataLayer = new NetworkStats(networkLayer.getElapsedRealtime(), networkLayer.size());
        NetworkStats.Entry entry = null;
        for (int i = 0; i < networkLayer.size(); ++i) {
            entry = networkLayer.getValues(i, entry);
            entry.iface = NetworkStats.IFACE_ALL;
            dataLayer.combineValues(entry);
        }
        dataLayer.spliceOperationsFrom(this.mOperations);
        return dataLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementOperationCount(int uid, int tag, int operationCount) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_NETWORK_ACCOUNTING", TAG);
        }
        if (operationCount < 0) {
            throw new IllegalArgumentException("operation count can only be incremented");
        }
        if (tag == 0) {
            throw new IllegalArgumentException("operation count must have specific tag");
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = this.mActiveUidCounterSet.get(uid, 0);
            this.mOperations.combineValues(NetworkStats.IFACE_ALL, uid, set, tag, 0L, 0L, 0L, 0L, (long)operationCount);
            this.mOperations.combineValues(NetworkStats.IFACE_ALL, uid, set, 0, 0L, 0L, 0L, 0L, (long)operationCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUidForeground(int uid, boolean uidForeground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_NETWORK_ACCOUNTING", TAG);
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = uidForeground ? 1 : 0;
            int oldSet = this.mActiveUidCounterSet.get(uid, 0);
            if (oldSet != set) {
                this.mActiveUidCounterSet.put(uid, set);
                NetworkManagementSocketTagger.setKernelCounterSet((int)uid, (int)set);
            }
        }
    }

    public void forceUpdate() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        this.performPoll(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfaces() {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            try {
                this.updateIfacesLocked();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.mWakeLock.release();
                throw throwable;
            }
            this.mWakeLock.release();
        }
    }

    private void updateIfacesLocked() {
        NetworkState[] states;
        this.performPollLocked(1);
        try {
            states = this.mConnManager.getAllNetworkState();
        }
        catch (RemoteException e) {
            return;
        }
        this.mActiveIfaces.clear();
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            String iface = state.linkProperties.getInterfaceName();
            NetworkIdentitySet ident = this.mActiveIfaces.get(iface);
            if (ident == null) {
                ident = new NetworkIdentitySet();
                this.mActiveIfaces.put(iface, ident);
            }
            ident.add(NetworkIdentity.buildNetworkIdentity((Context)this.mContext, (NetworkState)state));
        }
    }

    private void bootstrapStats() {
        try {
            this.mLastPollUidSnapshot = this.mNetworkManager.getNetworkStatsUidDetail(-1);
            this.mLastPollNetworkDevSnapshot = this.mNetworkManager.getNetworkStatsSummary();
            this.mLastPollNetworkXtSnapshot = NetworkStatsService.computeNetworkXtSnapshotFromUid(this.mLastPollUidSnapshot);
            this.mLastPollOperationsSnapshot = new NetworkStats(0L, 0);
        }
        catch (IllegalStateException e) {
            Slog.w((String)TAG, (String)("problem reading network stats: " + e));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPoll(int flags) {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            if (this.mTime.getCacheAge() > this.mSettings.getTimeCacheMaxAge()) {
                this.mTime.forceRefresh();
            }
            try {
                this.performPollLocked(flags);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.mWakeLock.release();
                throw throwable;
            }
            this.mWakeLock.release();
        }
    }

    private void performPollLocked(int flags) {
        boolean networkOverThreshold;
        NetworkStats networkXtSnapshot;
        NetworkStats networkDevSnapshot;
        NetworkStats uidSnapshot;
        long startRealtime = SystemClock.elapsedRealtime();
        boolean persistNetwork = (flags & 1) != 0;
        boolean persistUid = (flags & 2) != 0;
        boolean persistForce = (flags & 0x100) != 0;
        long currentTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        long threshold = this.mSettings.getPersistThreshold();
        try {
            NetworkStats tetherSnapshot = this.getNetworkStatsTethering();
            uidSnapshot = this.mNetworkManager.getNetworkStatsUidDetail(-1);
            uidSnapshot.combineAllValues(tetherSnapshot);
            this.performUidPollLocked(uidSnapshot, currentTime);
            networkDevSnapshot = this.mNetworkManager.getNetworkStatsSummary();
            this.performNetworkDevPollLocked(networkDevSnapshot, currentTime);
            networkXtSnapshot = NetworkStatsService.computeNetworkXtSnapshotFromUid(uidSnapshot);
            this.performNetworkXtPollLocked(networkXtSnapshot, currentTime);
        }
        catch (IllegalStateException e) {
            Log.wtf((String)TAG, (String)"problem reading network stats", (Throwable)e);
            return;
        }
        catch (RemoteException e) {
            return;
        }
        long persistNetworkDevDelta = this.computeStatsDelta(this.mLastPersistNetworkDevSnapshot, networkDevSnapshot, true, "devp").getTotalBytes();
        long persistNetworkXtDelta = this.computeStatsDelta(this.mLastPersistNetworkXtSnapshot, networkXtSnapshot, true, "xtp").getTotalBytes();
        boolean bl = networkOverThreshold = persistNetworkDevDelta > threshold || persistNetworkXtDelta > threshold;
        if (persistForce || persistNetwork && networkOverThreshold) {
            this.writeNetworkDevStatsLocked();
            this.writeNetworkXtStatsLocked();
            this.mLastPersistNetworkDevSnapshot = networkDevSnapshot;
            this.mLastPersistNetworkXtSnapshot = networkXtSnapshot;
        }
        long persistUidDelta = this.computeStatsDelta(this.mLastPersistUidSnapshot, uidSnapshot, true, "uidp").getTotalBytes();
        if (persistForce || persistUid && persistUidDelta > threshold) {
            this.writeUidStatsLocked();
            this.mLastPersistUidSnapshot = uidSnapshot;
        }
        this.performSample();
        Intent updatedIntent = new Intent(ACTION_NETWORK_STATS_UPDATED);
        updatedIntent.setFlags(0x40000000);
        this.mContext.sendBroadcast(updatedIntent, "android.permission.READ_NETWORK_USAGE_HISTORY");
    }

    private void performNetworkDevPollLocked(NetworkStats networkDevSnapshot, long currentTime) {
        HashSet unknownIface = Sets.newHashSet();
        NetworkStats delta = this.computeStatsDelta(this.mLastPollNetworkDevSnapshot, networkDevSnapshot, false, "dev");
        long timeStart = currentTime - delta.getElapsedRealtime();
        NetworkStats.Entry entry = null;
        for (int i = 0; i < delta.size(); ++i) {
            entry = delta.getValues(i, entry);
            NetworkIdentitySet ident = this.mActiveIfaces.get(entry.iface);
            if (ident == null) {
                unknownIface.add(entry.iface);
                continue;
            }
            NetworkStatsHistory history = this.findOrCreateNetworkDevStatsLocked(ident);
            history.recordData(timeStart, currentTime, entry);
        }
        this.mLastPollNetworkDevSnapshot = networkDevSnapshot;
    }

    private void performNetworkXtPollLocked(NetworkStats networkXtSnapshot, long currentTime) {
        HashSet unknownIface = Sets.newHashSet();
        NetworkStats delta = this.computeStatsDelta(this.mLastPollNetworkXtSnapshot, networkXtSnapshot, false, "xt");
        long timeStart = currentTime - delta.getElapsedRealtime();
        NetworkStats.Entry entry = null;
        for (int i = 0; i < delta.size(); ++i) {
            entry = delta.getValues(i, entry);
            NetworkIdentitySet ident = this.mActiveIfaces.get(entry.iface);
            if (ident == null) {
                unknownIface.add(entry.iface);
                continue;
            }
            NetworkStatsHistory history = this.findOrCreateNetworkXtStatsLocked(ident);
            history.recordData(timeStart, currentTime, entry);
        }
        this.mLastPollNetworkXtSnapshot = networkXtSnapshot;
    }

    private void performUidPollLocked(NetworkStats uidSnapshot, long currentTime) {
        this.ensureUidStatsLoadedLocked();
        NetworkStats delta = this.computeStatsDelta(this.mLastPollUidSnapshot, uidSnapshot, false, "uid");
        NetworkStats operationsDelta = this.computeStatsDelta(this.mLastPollOperationsSnapshot, this.mOperations, false, "uidop");
        long timeStart = currentTime - delta.getElapsedRealtime();
        NetworkStats.Entry entry = null;
        NetworkStats.Entry operationsEntry = null;
        for (int i = 0; i < delta.size(); ++i) {
            entry = delta.getValues(i, entry);
            NetworkIdentitySet ident = this.mActiveIfaces.get(entry.iface);
            if (ident == null) {
                if (entry.rxBytes <= 0L && entry.rxPackets <= 0L && entry.txBytes <= 0L && entry.txPackets <= 0L) continue;
                Log.w((String)TAG, (String)("dropping UID delta from unknown iface: " + entry));
                continue;
            }
            int j = operationsDelta.findIndex(NetworkStats.IFACE_ALL, entry.uid, entry.set, entry.tag);
            if (j != -1) {
                operationsEntry = operationsDelta.getValues(j, operationsEntry);
                entry.operations = operationsEntry.operations;
            }
            NetworkStatsHistory history = this.findOrCreateUidStatsLocked(ident, entry.uid, entry.set, entry.tag);
            history.recordData(timeStart, currentTime, entry);
        }
        this.mLastPollUidSnapshot = uidSnapshot;
        this.mLastPollOperationsSnapshot = this.mOperations.clone();
    }

    private void performSample() {
        long largestBucketSize = Math.max(this.mSettings.getNetworkBucketDuration(), this.mSettings.getUidBucketDuration());
        long now = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        long end = now - now % largestBucketSize + largestBucketSize;
        long start = end - largestBucketSize;
        long trustedTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : -1L;
        long devHistoryStart = Long.MAX_VALUE;
        NetworkTemplate template = null;
        NetworkStats.Entry devTotal = null;
        NetworkStats.Entry xtTotal = null;
        NetworkStats.Entry uidTotal = null;
        template = NetworkTemplate.buildTemplateMobileAll((String)NetworkStatsService.getActiveSubscriberId(this.mContext));
        devTotal = this.getSummaryForNetworkDev(template, start, end).getTotal(devTotal);
        devHistoryStart = this.getHistoryStartLocked(template, this.mNetworkDevStats);
        xtTotal = this.getSummaryForNetworkXt(template, start, end).getTotal(xtTotal);
        uidTotal = this.getSummaryForAllUid(template, start, end, false).getTotal(uidTotal);
        EventLogTags.writeNetstatsMobileSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, trustedTime, devHistoryStart);
        template = NetworkTemplate.buildTemplateWifi();
        devTotal = this.getSummaryForNetworkDev(template, start, end).getTotal(devTotal);
        devHistoryStart = this.getHistoryStartLocked(template, this.mNetworkDevStats);
        xtTotal = this.getSummaryForNetworkXt(template, start, end).getTotal(xtTotal);
        uidTotal = this.getSummaryForAllUid(template, start, end, false).getTotal(uidTotal);
        EventLogTags.writeNetstatsWifiSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, trustedTime, devHistoryStart);
    }

    private void removeUidLocked(int uid) {
        this.ensureUidStatsLoadedLocked();
        this.performPollLocked(3);
        ArrayList knownKeys = Lists.newArrayList();
        knownKeys.addAll(this.mUidStats.keySet());
        for (UidStatsKey key : knownKeys) {
            if (key.uid != uid) continue;
            if (key.tag == 0) {
                NetworkStatsHistory uidHistory = this.mUidStats.get(key);
                NetworkStatsHistory removedHistory = this.findOrCreateUidStatsLocked(key.ident, -4, 0, 0);
                removedHistory.recordEntireHistory(uidHistory);
            }
            this.mUidStats.remove(key);
        }
        if (this.mLastPollUidSnapshot != null) {
            this.mLastPollUidSnapshot = this.mLastPollUidSnapshot.withoutUid(uid);
            this.mLastPollNetworkXtSnapshot = NetworkStatsService.computeNetworkXtSnapshotFromUid(this.mLastPollUidSnapshot);
        }
        NetworkManagementSocketTagger.resetKernelUidStats((int)uid);
        this.writeUidStatsLocked();
    }

    private NetworkStatsHistory findOrCreateNetworkXtStatsLocked(NetworkIdentitySet ident) {
        return this.findOrCreateNetworkStatsLocked(ident, this.mNetworkXtStats);
    }

    private NetworkStatsHistory findOrCreateNetworkDevStatsLocked(NetworkIdentitySet ident) {
        return this.findOrCreateNetworkStatsLocked(ident, this.mNetworkDevStats);
    }

    private NetworkStatsHistory findOrCreateNetworkStatsLocked(NetworkIdentitySet ident, HashMap<NetworkIdentitySet, NetworkStatsHistory> source) {
        NetworkStatsHistory existing = source.get(ident);
        long bucketDuration = this.mSettings.getNetworkBucketDuration();
        NetworkStatsHistory updated = null;
        if (existing == null) {
            updated = new NetworkStatsHistory(bucketDuration, 10);
        } else if (existing.getBucketDuration() != bucketDuration) {
            updated = new NetworkStatsHistory(bucketDuration, NetworkStatsService.estimateResizeBuckets(existing, bucketDuration));
            updated.recordEntireHistory(existing);
        }
        if (updated != null) {
            source.put(ident, updated);
            return updated;
        }
        return existing;
    }

    private NetworkStatsHistory findOrCreateUidStatsLocked(NetworkIdentitySet ident, int uid, int set, int tag) {
        this.ensureUidStatsLoadedLocked();
        UidStatsKey key = new UidStatsKey(ident, uid, set, tag);
        NetworkStatsHistory existing = this.mUidStats.get(key);
        long bucketDuration = this.mSettings.getUidBucketDuration();
        NetworkStatsHistory updated = null;
        if (existing == null) {
            updated = new NetworkStatsHistory(bucketDuration, 10);
        } else if (existing.getBucketDuration() != bucketDuration) {
            updated = new NetworkStatsHistory(bucketDuration, NetworkStatsService.estimateResizeBuckets(existing, bucketDuration));
            updated.recordEntireHistory(existing);
        }
        if (updated != null) {
            this.mUidStats.put(key, updated);
            return updated;
        }
        return existing;
    }

    private void readNetworkDevStatsLocked() {
        NetworkStatsService.readNetworkStats(this.mNetworkDevFile, this.mNetworkDevStats);
    }

    private void readNetworkXtStatsLocked() {
        NetworkStatsService.readNetworkStats(this.mNetworkXtFile, this.mNetworkXtStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readNetworkStats(AtomicFile inputFile, HashMap<NetworkIdentitySet, NetworkStatsHistory> output) {
        output.clear();
        DataInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(inputFile.openRead()));
                int magic = in.readInt();
                if (magic != 1095648596) {
                    throw new ProtocolException("unexpected magic: " + magic);
                }
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        int size = in.readInt();
                        for (int i = 0; i < size; ++i) {
                            NetworkIdentitySet ident = new NetworkIdentitySet(in);
                            NetworkStatsHistory history = new NetworkStatsHistory(in);
                            output.put(ident, history);
                        }
                        break;
                    }
                    default: {
                        throw new ProtocolException("unexpected version: " + version);
                    }
                }
                Object var10_11 = null;
            }
            catch (FileNotFoundException e) {
                Object var10_12 = null;
                IoUtils.closeQuietly(in);
                return;
            }
            catch (IOException e) {
                Log.wtf((String)TAG, (String)"problem reading network stats", (Throwable)e);
                Object var10_13 = null;
                IoUtils.closeQuietly((AutoCloseable)in);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly((AutoCloseable)in);
    }

    private void ensureUidStatsLoadedLocked() {
        if (!this.mUidStatsLoaded) {
            this.readUidStatsLocked();
            this.mUidStatsLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readUidStatsLocked() {
        this.mUidStats.clear();
        DataInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(this.mUidFile.openRead()));
                int magic = in.readInt();
                if (magic != 1095648596) {
                    throw new ProtocolException("unexpected magic: " + magic);
                }
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        int identSize = in.readInt();
                        for (int i = 0; i < identSize; ++i) {
                            NetworkIdentitySet ident = new NetworkIdentitySet(in);
                            int size = in.readInt();
                            for (int j = 0; j < size; ++j) {
                                int uid = in.readInt();
                                int set = version >= 4 ? in.readInt() : 0;
                                int tag = in.readInt();
                                UidStatsKey key = new UidStatsKey(ident, uid, set, tag);
                                NetworkStatsHistory history = new NetworkStatsHistory(in);
                                this.mUidStats.put(key, history);
                            }
                        }
                        break;
                    }
                    default: {
                        throw new ProtocolException("unexpected version: " + version);
                    }
                }
            }
            catch (FileNotFoundException e) {
                Object var15_17 = null;
                IoUtils.closeQuietly(in);
                return;
            }
            catch (IOException e) {
                Log.wtf((String)TAG, (String)"problem reading uid stats", (Throwable)e);
                Object var15_18 = null;
                IoUtils.closeQuietly((AutoCloseable)in);
                return;
            }
            Object var15_16 = null;
            IoUtils.closeQuietly((AutoCloseable)in);
            return;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            IoUtils.closeQuietly(in);
            throw throwable;
        }
    }

    private void writeNetworkDevStatsLocked() {
        this.writeNetworkStats(this.mNetworkDevStats, this.mNetworkDevFile);
    }

    private void writeNetworkXtStatsLocked() {
        this.writeNetworkStats(this.mNetworkXtStats, this.mNetworkXtFile);
    }

    private void writeNetworkStats(HashMap<NetworkIdentitySet, NetworkStatsHistory> input, AtomicFile outputFile) {
        block5: {
            if (this.mTime.hasCache()) {
                long systemCurrentTime = System.currentTimeMillis();
                long trustedCurrentTime = this.mTime.currentTimeMillis();
                long currentTime = Math.min(systemCurrentTime, trustedCurrentTime);
                long maxHistory = this.mSettings.getNetworkMaxHistory();
                for (NetworkStatsHistory history : input.values()) {
                    int beforeSize = history.size();
                    history.removeBucketsBefore(currentTime - maxHistory);
                    int afterSize = history.size();
                    if (beforeSize <= 24 || afterSize >= beforeSize / 2) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("yikes, dropping more than half of history").append('\n');
                    builder.append("systemCurrentTime=").append(systemCurrentTime).append('\n');
                    builder.append("trustedCurrentTime=").append(trustedCurrentTime).append('\n');
                    builder.append("maxHistory=").append(maxHistory).append('\n');
                    builder.append("beforeSize=").append(beforeSize).append('\n');
                    builder.append("afterSize=").append(afterSize).append('\n');
                    this.mDropBox.addText(TAG_NETSTATS_ERROR, builder.toString());
                }
            }
            FileOutputStream fos = null;
            try {
                fos = outputFile.startWrite();
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
                out.writeInt(1095648596);
                out.writeInt(1);
                out.writeInt(input.size());
                for (NetworkIdentitySet ident : input.keySet()) {
                    NetworkStatsHistory history = input.get(ident);
                    ident.writeToStream(out);
                    history.writeToStream(out);
                }
                out.flush();
                outputFile.finishWrite(fos);
            }
            catch (IOException e) {
                Log.wtf((String)TAG, (String)"problem writing stats", (Throwable)e);
                if (fos == null) break block5;
                outputFile.failWrite(fos);
            }
        }
    }

    private void writeUidStatsLocked() {
        block10: {
            NetworkStatsHistory history;
            if (!this.mUidStatsLoaded) {
                Slog.w((String)TAG, (String)"asked to write UID stats when not loaded; skipping");
                return;
            }
            if (this.mTime.hasCache()) {
                long currentTime = Math.min(System.currentTimeMillis(), this.mTime.currentTimeMillis());
                long maxUidHistory = this.mSettings.getUidMaxHistory();
                long maxTagHistory = this.mSettings.getTagMaxHistory();
                for (UidStatsKey key : this.mUidStats.keySet()) {
                    history = this.mUidStats.get(key);
                    if (key.tag == 0) {
                        history.removeBucketsBefore(currentTime - maxUidHistory);
                        continue;
                    }
                    history.removeBucketsBefore(currentTime - maxTagHistory);
                }
            }
            HashMap keysByIdent = Maps.newHashMap();
            for (UidStatsKey key : this.mUidStats.keySet()) {
                ArrayList keys = (ArrayList)keysByIdent.get(key.ident);
                if (keys == null) {
                    keys = Lists.newArrayList();
                    keysByIdent.put(key.ident, keys);
                }
                keys.add(key);
            }
            FileOutputStream fos = null;
            try {
                fos = this.mUidFile.startWrite();
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
                out.writeInt(1095648596);
                out.writeInt(4);
                out.writeInt(keysByIdent.size());
                for (NetworkIdentitySet ident : keysByIdent.keySet()) {
                    ArrayList keys = (ArrayList)keysByIdent.get(ident);
                    ident.writeToStream(out);
                    out.writeInt(keys.size());
                    for (UidStatsKey key : keys) {
                        history = this.mUidStats.get(key);
                        out.writeInt(key.uid);
                        out.writeInt(key.set);
                        out.writeInt(key.tag);
                        history.writeToStream(out);
                    }
                }
                out.flush();
                this.mUidFile.finishWrite(fos);
            }
            catch (IOException e) {
                Log.wtf((String)TAG, (String)"problem writing stats", (Throwable)e);
                if (fos == null) break block10;
                this.mUidFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        HashSet<String> argSet = new HashSet<String>();
        for (String arg : args) {
            argSet.add(arg);
        }
        boolean fullHistory = argSet.contains("full");
        Object object = this.mStatsLock;
        synchronized (object) {
            NetworkStatsHistory history;
            if (argSet.contains("generate")) {
                this.generateRandomLocked(args);
                pw.println("Generated stub stats");
                return;
            }
            if (argSet.contains("poll")) {
                this.performPollLocked(259);
                pw.println("Forced poll");
                return;
            }
            pw.println("Active interfaces:");
            for (String iface : this.mActiveIfaces.keySet()) {
                NetworkIdentitySet ident = this.mActiveIfaces.get(iface);
                pw.print("  iface=");
                pw.print(iface);
                pw.print(" ident=");
                pw.println(ident.toString());
            }
            pw.println("Known historical dev stats:");
            for (NetworkIdentitySet ident : this.mNetworkDevStats.keySet()) {
                history = this.mNetworkDevStats.get(ident);
                pw.print("  ident=");
                pw.println(ident.toString());
                history.dump("  ", pw, fullHistory);
            }
            pw.println("Known historical xt stats:");
            for (NetworkIdentitySet ident : this.mNetworkXtStats.keySet()) {
                history = this.mNetworkXtStats.get(ident);
                pw.print("  ident=");
                pw.println(ident.toString());
                history.dump("  ", pw, fullHistory);
            }
            if (argSet.contains("detail")) {
                this.ensureUidStatsLoadedLocked();
                ArrayList keys = Lists.newArrayList();
                keys.addAll(this.mUidStats.keySet());
                Collections.sort(keys);
                pw.println("Detailed UID stats:");
                for (UidStatsKey key : keys) {
                    pw.print("  ident=");
                    pw.print(key.ident.toString());
                    pw.print(" uid=");
                    pw.print(key.uid);
                    pw.print(" set=");
                    pw.print(NetworkStats.setToString((int)key.set));
                    pw.print(" tag=");
                    pw.println(NetworkStats.tagToString((int)key.tag));
                    NetworkStatsHistory history2 = this.mUidStats.get(key);
                    history2.dump("    ", pw, fullHistory);
                }
            }
        }
    }

    @Deprecated
    private void generateRandomLocked(String[] args) {
        long totalBytes = Long.parseLong(args[1]);
        long totalTime = Long.parseLong(args[2]);
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList specialUidList = Lists.newArrayList();
        for (int i = 3; i < args.length; ++i) {
            try {
                specialUidList.add(pm.getApplicationInfo((String)args[i], (int)0).uid);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        HashSet otherUidSet = Sets.newHashSet();
        for (ApplicationInfo info : pm.getInstalledApplications(0)) {
            if (pm.checkPermission("android.permission.INTERNET", info.packageName) != 0 || specialUidList.contains(info.uid)) continue;
            otherUidSet.add(info.uid);
        }
        ArrayList otherUidList = new ArrayList(otherUidSet);
        long end = System.currentTimeMillis();
        long start = end - totalTime;
        this.mNetworkDevStats.clear();
        this.mNetworkXtStats.clear();
        this.mUidStats.clear();
        Random r = new Random();
        for (NetworkIdentitySet ident : this.mActiveIfaces.values()) {
            NetworkStatsHistory devHistory = this.findOrCreateNetworkDevStatsLocked(ident);
            NetworkStatsHistory xtHistory = this.findOrCreateNetworkXtStatsLocked(ident);
            ArrayList uidList = new ArrayList();
            uidList.addAll(specialUidList);
            if (uidList.size() == 0) {
                Collections.shuffle(otherUidList);
                uidList.addAll(otherUidList);
            }
            boolean first = true;
            long remainingBytes = totalBytes;
            Iterator i$ = uidList.iterator();
            while (i$.hasNext()) {
                int uid = (Integer)i$.next();
                NetworkStatsHistory defaultHistory = this.findOrCreateUidStatsLocked(ident, uid, 0, 0);
                NetworkStatsHistory foregroundHistory = this.findOrCreateUidStatsLocked(ident, uid, 1, 0);
                long uidBytes = totalBytes / (long)uidList.size();
                float fractionDefault = r.nextFloat();
                long defaultBytes = (long)((float)uidBytes * fractionDefault);
                long foregroundBytes = (long)((float)uidBytes * (1.0f - fractionDefault));
                defaultHistory.generateRandom(start, end, defaultBytes);
                foregroundHistory.generateRandom(start, end, foregroundBytes);
                if (first) {
                    long bumpTime = (start + end) / 2L;
                    defaultHistory.recordData(bumpTime, bumpTime + 86400000L, 0xC800000L, 0L);
                    first = false;
                }
                devHistory.recordEntireHistory(defaultHistory);
                devHistory.recordEntireHistory(foregroundHistory);
                xtHistory.recordEntireHistory(defaultHistory);
                xtHistory.recordEntireHistory(foregroundHistory);
            }
        }
    }

    private NetworkStats computeStatsDelta(NetworkStats before, NetworkStats current, boolean collectStale, String type) {
        if (before != null) {
            try {
                return current.subtract(before, false);
            }
            catch (NetworkStats.NonMonotonicException e) {
                Log.w((String)TAG, (String)"found non-monotonic values; saving to dropbox");
                StringBuilder builder = new StringBuilder();
                builder.append("found non-monotonic " + type + " values at left[" + e.leftIndex + "] - right[" + e.rightIndex + "]\n");
                builder.append("left=").append(e.left).append('\n');
                builder.append("right=").append(e.right).append('\n');
                this.mDropBox.addText(TAG_NETSTATS_ERROR, builder.toString());
                try {
                    return current.subtract(before, true);
                }
                catch (NetworkStats.NonMonotonicException e1) {
                    Log.wtf((String)TAG, (String)"found non-monotonic values; returning empty delta", (Throwable)e1);
                    return new NetworkStats(0L, 10);
                }
            }
        }
        if (collectStale) {
            return current;
        }
        return new NetworkStats(0L, 10);
    }

    private NetworkStats getNetworkStatsTethering() throws RemoteException {
        try {
            String[] tetheredIfacePairs = this.mConnManager.getTetheredIfacePairs();
            return this.mNetworkManager.getNetworkStatsTethering(tetheredIfacePairs);
        }
        catch (IllegalStateException e) {
            Log.wtf((String)TAG, (String)"problem reading network stats", (Throwable)e);
            return new NetworkStats(0L, 10);
        }
    }

    private static NetworkStats computeNetworkXtSnapshotFromUid(NetworkStats uidSnapshot) {
        return uidSnapshot.groupedByIface();
    }

    private int estimateNetworkBuckets() {
        return (int)(this.mSettings.getNetworkMaxHistory() / this.mSettings.getNetworkBucketDuration());
    }

    private int estimateUidBuckets() {
        return (int)(this.mSettings.getUidMaxHistory() / this.mSettings.getUidBucketDuration());
    }

    private static int estimateResizeBuckets(NetworkStatsHistory existing, long newBucketDuration) {
        return (int)((long)existing.size() * existing.getBucketDuration() / newBucketDuration);
    }

    private static boolean templateMatches(NetworkTemplate template, NetworkIdentitySet identSet) {
        for (NetworkIdentity ident : identSet) {
            if (!template.matches(ident)) continue;
            return true;
        }
        return false;
    }

    private static String getActiveSubscriberId(Context context) {
        TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
        return telephony.getSubscriberId();
    }

    private static class DefaultNetworkStatsSettings
    implements NetworkStatsSettings {
        private final ContentResolver mResolver;

        public DefaultNetworkStatsSettings(Context context) {
            this.mResolver = (ContentResolver)Preconditions.checkNotNull((Object)context.getContentResolver());
        }

        private long getSecureLong(String name, long def) {
            return Settings.Secure.getLong((ContentResolver)this.mResolver, (String)name, (long)def);
        }

        private boolean getSecureBoolean(String name, boolean def) {
            int defInt = def ? 1 : 0;
            return Settings.Secure.getInt((ContentResolver)this.mResolver, (String)name, (int)defInt) != 0;
        }

        public long getPollInterval() {
            return this.getSecureLong("netstats_poll_interval", 1800000L);
        }

        public long getPersistThreshold() {
            return this.getSecureLong("netstats_persist_threshold", 0x200000L);
        }

        public long getNetworkBucketDuration() {
            return this.getSecureLong("netstats_network_bucket_duration", 3600000L);
        }

        public long getNetworkMaxHistory() {
            return this.getSecureLong("netstats_network_max_history", 7776000000L);
        }

        public long getUidBucketDuration() {
            return this.getSecureLong("netstats_uid_bucket_duration", 0x6DDD00L);
        }

        public long getUidMaxHistory() {
            return this.getSecureLong("netstats_uid_max_history", 7776000000L);
        }

        public long getTagMaxHistory() {
            return this.getSecureLong("netstats_tag_max_history", 2592000000L);
        }

        public long getTimeCacheMaxAge() {
            return 86400000L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UidStatsKey
    implements Comparable<UidStatsKey> {
        public final NetworkIdentitySet ident;
        public final int uid;
        public final int set;
        public final int tag;

        public UidStatsKey(NetworkIdentitySet ident, int uid, int set, int tag) {
            this.ident = ident;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ident, this.uid, this.set, this.tag});
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidStatsKey) {
                UidStatsKey key = (UidStatsKey)obj;
                return Objects.equal((Object)this.ident, (Object)key.ident) && this.uid == key.uid && this.set == key.set && this.tag == key.tag;
            }
            return false;
        }

        @Override
        public int compareTo(UidStatsKey another) {
            return Integer.compare(this.uid, another.uid);
        }
    }

    public static interface NetworkStatsSettings {
        public long getPollInterval();

        public long getPersistThreshold();

        public long getNetworkBucketDuration();

        public long getNetworkMaxHistory();

        public long getUidBucketDuration();

        public long getUidMaxHistory();

        public long getTagMaxHistory();

        public long getTimeCacheMaxAge();
    }
}

