/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.admin.IDevicePolicyManager;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.security.SystemKeyStore;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.LogPrinter;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.Display;
import android.view.WindowManager;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.util.XmlUtils;
import com.android.server.DeviceStorageMonitorService;
import com.android.server.IntentResolver;
import com.android.server.pm.BasePermission;
import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.Installer;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManager;
import dalvik.system.DexFile;
import dalvik.system.StaleDexCacheError;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerService
extends IPackageManager.Stub {
    static final String TAG = "PackageManager";
    static final boolean DEBUG_SETTINGS = false;
    private static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    private static final boolean DEBUG_INSTALL = false;
    private static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    private static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_APP_DIR_OBSERVER = false;
    private static final boolean DEBUG_VERIFY = false;
    static final boolean MULTIPLE_APPLICATION_UIDS = true;
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    static final int FIRST_APPLICATION_UID = 10000;
    static final int MAX_APPLICATION_UIDS = 1000;
    private static final boolean GET_CERTIFICATES = true;
    private static final int REMOVE_EVENTS = 584;
    private static final int ADD_EVENTS = 136;
    private static final int OBSERVER_EVENTS = 712;
    private static final String INSTALL_PACKAGE_SUFFIX = "-";
    static final int SCAN_MONITOR = 1;
    static final int SCAN_NO_DEX = 2;
    static final int SCAN_FORCE_DEX = 4;
    static final int SCAN_UPDATE_SIGNATURE = 8;
    static final int SCAN_NEW_INSTALL = 16;
    static final int SCAN_NO_PATHS = 32;
    static final int SCAN_UPDATE_TIME = 64;
    static final int SCAN_DEFER_DEX = 128;
    static final int REMOVE_CHATTY = 65536;
    private static final boolean DEFAULT_VERIFY_ENABLE = false;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 60000L;
    static final String DEFAULT_CONTAINER_PACKAGE = "com.android.defcontainer";
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String LIB_DIR_NAME = "lib";
    static final String mTempContainerPrefix = "smdl2tmp";
    final HandlerThread mHandlerThread = new HandlerThread("PackageManager", 10);
    final PackageHandler mHandler;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final String mSdkCodename = "REL".equals(Build.VERSION.CODENAME) ? null : Build.VERSION.CODENAME;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final boolean mNoDexOpt;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final File mAppDataDir;
    final File mUserAppDataDir;
    final FileObserver mFrameworkInstallObserver;
    final FileObserver mSystemInstallObserver;
    final FileObserver mVendorInstallObserver;
    final FileObserver mAppInstallObserver;
    final FileObserver mDrmAppInstallObserver;
    final Installer mInstaller;
    final File mFrameworkDir;
    final File mSystemAppDir;
    final File mVendorAppDir;
    final File mAppInstallDir;
    final File mDalvikCacheDir;
    final File mDrmAppPrivateInstallDir;
    final Object mInstallLock = new Object();
    final HashMap<String, PackageParser.Package> mAppDirs = new HashMap();
    File mScanningPath;
    int mLastScanError;
    final int[] mOutPermissions = new int[3];
    final HashMap<String, PackageParser.Package> mPackages = new HashMap();
    final Settings mSettings;
    boolean mRestoredSettings;
    int[] mGlobalGids;
    final SparseArray<HashSet<String>> mSystemPermissions = new SparseArray();
    final HashMap<String, String> mSharedLibraries = new HashMap();
    String[] mTmpSharedLibraries = null;
    final HashMap<String, FeatureInfo> mAvailableFeatures = new HashMap();
    final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    final ServiceIntentResolver mServices = new ServiceIntentResolver();
    final HashMap<ComponentName, PackageParser.Provider> mProvidersByComponent = new HashMap();
    final HashMap<String, PackageParser.Provider> mProviders = new HashMap();
    final HashMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new HashMap();
    final HashMap<String, PackageParser.PermissionGroup> mPermissionGroups = new HashMap();
    final HashSet<String> mTransferedPackages = new HashSet();
    final HashSet<String> mProtectedBroadcasts = new HashSet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    final ArrayList<PackageParser.Package> mDeferredDexOpt = new ArrayList();
    private int mPendingVerificationToken = 0;
    boolean mSystemReady;
    boolean mSafeMode;
    boolean mHasSystemUidErrors;
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    final HashMap<String, ArrayList<String>> mPendingBroadcasts = new HashMap();
    private IMediaContainerService mContainerService = null;
    static final int SEND_PENDING_BROADCAST = 1;
    static final int MCS_BOUND = 3;
    static final int END_COPY = 4;
    static final int INIT_COPY = 5;
    static final int MCS_UNBIND = 6;
    static final int START_CLEANING_PACKAGE = 7;
    static final int FIND_INSTALL_LOC = 8;
    static final int POST_INSTALL = 9;
    static final int MCS_RECONNECT = 10;
    static final int MCS_GIVE_UP = 11;
    static final int UPDATED_MEDIA_STATUS = 12;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_STOPPED_PACKAGES = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int WRITE_SETTINGS_DELAY = 10000;
    static final int BROADCAST_DELAY = 10000;
    final UserManager mUserManager;
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private final String mRequiredVerifierPackage;
    static final int DEX_OPT_SKIPPED = 0;
    static final int DEX_OPT_PERFORMED = 1;
    static final int DEX_OPT_DEFERRED = 2;
    static final int DEX_OPT_FAILED = -1;
    private static final Comparator<ResolveInfo> mResolvePrioritySorter = new Comparator<ResolveInfo>(){

        @Override
        public int compare(ResolveInfo r1, ResolveInfo r2) {
            int v1 = r1.priority;
            int v2 = r2.priority;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            v1 = r1.preferredOrder;
            v2 = r2.preferredOrder;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            if (r1.isDefault != r2.isDefault) {
                return r1.isDefault ? -1 : 1;
            }
            v1 = r1.match;
            v2 = r2.match;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            if (r1.system != r2.system) {
                return r1.system ? -1 : 1;
            }
            return 0;
        }
    };
    private static final Comparator<ProviderInfo> mProviderInitOrderSorter = new Comparator<ProviderInfo>(){

        @Override
        public int compare(ProviderInfo p1, ProviderInfo p2) {
            int v1 = p1.initOrder;
            int v2 = p2.initOrder;
            return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
        }
    };
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWriteStoppedPackagesLocked() {
        if (!this.mHandler.hasMessages(14)) {
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    static boolean installOnSd(int flags) {
        if ((flags & 1) != 0 || (flags & 0x10) != 0) {
            return false;
        }
        return (flags & 8) != 0;
    }

    public static final IPackageManager main(Context context, boolean factoryTest, boolean onlyCore) {
        PackageManagerService m = new PackageManagerService(context, factoryTest, onlyCore);
        ServiceManager.addService((String)"package", (IBinder)m);
        return m;
    }

    static String[] splitString(String str, char sep) {
        int count = 1;
        int i = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            ++count;
            ++i;
        }
        String[] res = new String[count];
        i = 0;
        count = 0;
        int lastI = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            res[count] = str.substring(lastI, i);
            ++count;
            lastI = ++i;
        }
        res[count] = str.substring(lastI, str.length());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManagerService(Context context, boolean factoryTest, boolean onlyCore) {
        EventLog.writeEvent((int)3060, (long)SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w((String)TAG, (String)"**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mNoDexOpt = "eng".equals(SystemProperties.get((String)"ro.build.type"));
        this.mMetrics = new DisplayMetrics();
        this.mSettings = new Settings();
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 1);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 1);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 1);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 1);
        String separateProcesses = SystemProperties.get((String)"debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 8;
                this.mSeparateProcesses = null;
                Slog.w((String)TAG, (String)"Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w((String)TAG, (String)("Running with debug.separate_processes: " + separateProcesses));
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mInstaller = new Installer();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        d.getMetrics(this.mMetrics);
        Object object = this.mInstallLock;
        synchronized (object) {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                boolean regrantPermissions;
                String[] files;
                int i;
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                File dataDir = Environment.getDataDirectory();
                this.mAppDataDir = new File(dataDir, "data");
                this.mUserAppDataDir = new File(dataDir, "user");
                this.mDrmAppPrivateInstallDir = new File(dataDir, "app-private");
                this.mUserManager = new UserManager(this.mInstaller, this.mUserAppDataDir);
                this.readPermissions();
                this.mRestoredSettings = this.mSettings.readLPw();
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent((int)3070, (long)startTime);
                int scanMode = 161;
                if (this.mNoDexOpt) {
                    Slog.w((String)TAG, (String)"Running ENG build: no pre-dexopt!");
                    scanMode |= 2;
                }
                HashSet<String> libFiles = new HashSet<String>();
                this.mFrameworkDir = new File(Environment.getRootDirectory(), "framework");
                this.mDalvikCacheDir = new File(dataDir, "dalvik-cache");
                boolean didDexOpt = false;
                String bootClassPath = System.getProperty("java.boot.class.path");
                if (bootClassPath != null) {
                    String[] paths = PackageManagerService.splitString(bootClassPath, ':');
                    for (i = 0; i < paths.length; ++i) {
                        try {
                            if (!DexFile.isDexOptNeeded((String)paths[i])) continue;
                            libFiles.add(paths[i]);
                            this.mInstaller.dexopt(paths[i], 1000, true);
                            didDexOpt = true;
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            Slog.w((String)TAG, (String)("Boot class path not found: " + paths[i]));
                            continue;
                        }
                        catch (IOException e) {
                            Slog.w((String)TAG, (String)("Cannot dexopt " + paths[i] + "; is it an APK or JAR? " + e.getMessage()));
                        }
                    }
                } else {
                    Slog.w((String)TAG, (String)"No BOOTCLASSPATH found!");
                }
                if (this.mSharedLibraries.size() > 0) {
                    for (String lib : this.mSharedLibraries.values()) {
                        try {
                            if (!DexFile.isDexOptNeeded((String)lib)) continue;
                            libFiles.add(lib);
                            this.mInstaller.dexopt(lib, 1000, true);
                            didDexOpt = true;
                        }
                        catch (FileNotFoundException e) {
                            Slog.w((String)TAG, (String)("Library not found: " + lib));
                        }
                        catch (IOException e) {
                            Slog.w((String)TAG, (String)("Cannot dexopt " + lib + "; is it an APK or JAR? " + e.getMessage()));
                        }
                    }
                }
                libFiles.add(this.mFrameworkDir.getPath() + "/framework-res.apk");
                String[] frameworkFiles = this.mFrameworkDir.list();
                if (frameworkFiles != null) {
                    for (i = 0; i < frameworkFiles.length; ++i) {
                        File libPath = new File(this.mFrameworkDir, frameworkFiles[i]);
                        String path = libPath.getPath();
                        if (libFiles.contains(path) || !path.endsWith(".apk") && !path.endsWith(".jar")) continue;
                        try {
                            if (!DexFile.isDexOptNeeded((String)path)) continue;
                            this.mInstaller.dexopt(path, 1000, true);
                            didDexOpt = true;
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            Slog.w((String)TAG, (String)("Jar not found: " + path));
                            continue;
                        }
                        catch (IOException e) {
                            Slog.w((String)TAG, (String)("Exception reading jar: " + path), (Throwable)e);
                        }
                    }
                }
                if (didDexOpt && (files = this.mDalvikCacheDir.list()) != null) {
                    for (int i2 = 0; i2 < files.length; ++i2) {
                        String fn = files[i2];
                        if (!fn.startsWith("data@app@") && !fn.startsWith("data@app-private@")) continue;
                        Slog.i((String)TAG, (String)("Pruning dalvik file: " + fn));
                        new File(this.mDalvikCacheDir, fn).delete();
                    }
                }
                this.mFrameworkInstallObserver = new AppDirObserver(this.mFrameworkDir.getPath(), 712, true);
                this.mFrameworkInstallObserver.startWatching();
                this.scanDirLI(this.mFrameworkDir, 65, scanMode | 2, 0L);
                this.mSystemAppDir = new File(Environment.getRootDirectory(), "app");
                this.mSystemInstallObserver = new AppDirObserver(this.mSystemAppDir.getPath(), 712, true);
                this.mSystemInstallObserver.startWatching();
                this.scanDirLI(this.mSystemAppDir, 65, scanMode, 0L);
                this.mVendorAppDir = new File("/vendor/app");
                this.mVendorInstallObserver = new AppDirObserver(this.mVendorAppDir.getPath(), 712, true);
                this.mVendorInstallObserver.startWatching();
                this.scanDirLI(this.mVendorAppDir, 65, scanMode, 0L);
                this.mInstaller.moveFiles();
                if (!this.mOnlyCore) {
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0 || this.mPackages.containsKey(ps.name) || this.mSettings.mDisabledSysPackages.containsKey(ps.name)) continue;
                        psit.remove();
                        String msg = "System package " + ps.name + " no longer exists; wiping its data";
                        PackageManagerService.reportSettingsProblem(5, msg);
                        this.mInstaller.remove(ps.name, 0);
                        this.mUserManager.removePackageForAllUsers(ps.name);
                    }
                }
                this.mAppInstallDir = new File(dataDir, "app");
                ArrayList<PackageSetting> deletePkgsList = this.mSettings.getListOfIncompleteInstallPackagesLPr();
                for (int i3 = 0; i3 < deletePkgsList.size(); ++i3) {
                    this.cleanupInstallFailedPackage(deletePkgsList.get(i3));
                }
                this.deleteTempPackageFiles();
                if (!this.mOnlyCore) {
                    EventLog.writeEvent((int)3080, (long)SystemClock.uptimeMillis());
                    this.mAppInstallObserver = new AppDirObserver(this.mAppInstallDir.getPath(), 712, false);
                    this.mAppInstallObserver.startWatching();
                    this.scanDirLI(this.mAppInstallDir, 0, scanMode, 0L);
                    this.mDrmAppInstallObserver = new AppDirObserver(this.mDrmAppPrivateInstallDir.getPath(), 712, false);
                    this.mDrmAppInstallObserver.startWatching();
                    this.scanDirLI(this.mDrmAppPrivateInstallDir, 16, scanMode, 0L);
                } else {
                    this.mAppInstallObserver = null;
                    this.mDrmAppInstallObserver = null;
                }
                EventLog.writeEvent((int)3090, (long)SystemClock.uptimeMillis());
                Slog.i((String)TAG, (String)("Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds"));
                boolean bl = regrantPermissions = this.mSettings.mInternalSdkPlatform != this.mSdkVersion;
                if (regrantPermissions) {
                    Slog.i((String)TAG, (String)("Platform changed from " + this.mSettings.mInternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for internal storage"));
                }
                this.mSettings.mInternalSdkPlatform = this.mSdkVersion;
                this.updatePermissionsLPw(null, null, true, regrantPermissions, regrantPermissions);
                this.mSettings.writeLPr();
                EventLog.writeEvent((int)3100, (long)SystemClock.uptimeMillis());
                Runtime.getRuntime().gc();
                this.mRequiredVerifierPackage = this.getRequiredVerifierLPr();
            }
        }
    }

    public boolean isFirstBoot() {
        return !this.mRestoredSettings;
    }

    private String getRequiredVerifierLPr() {
        Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> receivers = this.queryIntentReceivers(verification, PACKAGE_MIME_TYPE, 512);
        String requiredVerifier = null;
        int N = receivers.size();
        for (int i = 0; i < N; ++i) {
            String packageName;
            PackageSetting ps;
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || (ps = this.mSettings.mPackages.get(packageName = info.activityInfo.packageName)) == null || !ps.grantedPermissions.contains("android.permission.PACKAGE_VERIFICATION_AGENT")) continue;
            if (requiredVerifier != null) {
                throw new RuntimeException("There can be only one required verifier");
            }
            requiredVerifier = packageName;
        }
        return requiredVerifier;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.e((String)TAG, (String)"Package Manager Crash", (Throwable)e);
            }
            throw e;
        }
    }

    void cleanupInstallFailedPackage(PackageSetting ps) {
        Slog.i((String)TAG, (String)("Cleaning up incompletely installed app: " + ps.name));
        int retCode = this.mInstaller.remove(ps.name, 0);
        if (retCode < 0) {
            Slog.w((String)TAG, (String)("Couldn't remove app data directory for package: " + ps.name + ", retcode=" + retCode));
        } else {
            this.mUserManager.removePackageForAllUsers(ps.name);
        }
        if (ps.codePath != null && !ps.codePath.delete()) {
            Slog.w((String)TAG, (String)("Unable to remove old code file: " + ps.codePath));
        }
        if (ps.resourcePath != null && !ps.resourcePath.delete() && !ps.resourcePath.equals(ps.codePath)) {
            Slog.w((String)TAG, (String)("Unable to remove old code file: " + ps.resourcePath));
        }
        this.mSettings.removePackageLPw(ps.name);
    }

    void readPermissions() {
        File libraryDir = new File(Environment.getRootDirectory(), "etc/permissions");
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            Slog.w((String)TAG, (String)("No directory " + libraryDir + ", skipping"));
            return;
        }
        if (!libraryDir.canRead()) {
            Slog.w((String)TAG, (String)("Directory " + libraryDir + " cannot be read"));
            return;
        }
        for (File f : libraryDir.listFiles()) {
            if (f.getPath().endsWith("etc/permissions/platform.xml")) continue;
            if (!f.getPath().endsWith(".xml")) {
                Slog.i((String)TAG, (String)("Non-xml file " + f + " in " + libraryDir + " directory, ignoring"));
                continue;
            }
            if (!f.canRead()) {
                Slog.w((String)TAG, (String)("Permissions library file " + f + " cannot be read"));
                continue;
            }
            this.readPermissionsFromXml(f);
        }
        File permFile = new File(Environment.getRootDirectory(), "etc/permissions/platform.xml");
        this.readPermissionsFromXml(permFile);
    }

    private void readPermissionsFromXml(File permFile) {
        FileReader permReader = null;
        try {
            permReader = new FileReader(permFile);
        }
        catch (FileNotFoundException e) {
            Slog.w((String)TAG, (String)("Couldn't find or open permissions file " + permFile));
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)permReader);
            XmlUtils.beginDocument((XmlPullParser)parser, (String)"permissions");
            while (true) {
                String perm;
                XmlUtils.nextElement((XmlPullParser)parser);
                if (parser.getEventType() == 1) break;
                String name = parser.getName();
                if ("group".equals(name)) {
                    String gidStr = parser.getAttributeValue(null, "gid");
                    if (gidStr != null) {
                        int gid = Integer.parseInt(gidStr);
                        this.mGlobalGids = PackageManagerService.appendInt(this.mGlobalGids, gid);
                    } else {
                        Slog.w((String)TAG, (String)("<group> without gid at " + parser.getPositionDescription()));
                    }
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                if ("permission".equals(name)) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w((String)TAG, (String)("<permission> without name at " + parser.getPositionDescription()));
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                        continue;
                    }
                    perm = perm.intern();
                    this.readPermission(parser, perm);
                    continue;
                }
                if ("assign-permission".equals(name)) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w((String)TAG, (String)("<assign-permission> without name at " + parser.getPositionDescription()));
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                        continue;
                    }
                    String uidStr = parser.getAttributeValue(null, "uid");
                    if (uidStr == null) {
                        Slog.w((String)TAG, (String)("<assign-permission> without uid at " + parser.getPositionDescription()));
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                        continue;
                    }
                    int uid = Process.getUidForName((String)uidStr);
                    if (uid < 0) {
                        Slog.w((String)TAG, (String)("<assign-permission> with unknown uid \"" + uidStr + "\" at " + parser.getPositionDescription()));
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                        continue;
                    }
                    perm = perm.intern();
                    HashSet<String> perms = (HashSet<String>)this.mSystemPermissions.get(uid);
                    if (perms == null) {
                        perms = new HashSet<String>();
                        this.mSystemPermissions.put(uid, perms);
                    }
                    perms.add(perm);
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                if ("library".equals(name)) {
                    String lname = parser.getAttributeValue(null, "name");
                    String lfile = parser.getAttributeValue(null, "file");
                    if (lname == null) {
                        Slog.w((String)TAG, (String)("<library> without name at " + parser.getPositionDescription()));
                    } else if (lfile == null) {
                        Slog.w((String)TAG, (String)("<library> without file at " + parser.getPositionDescription()));
                    } else {
                        this.mSharedLibraries.put(lname, lfile);
                    }
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                if ("feature".equals(name)) {
                    String fname = parser.getAttributeValue(null, "name");
                    if (fname == null) {
                        Slog.w((String)TAG, (String)("<feature> without name at " + parser.getPositionDescription()));
                    } else {
                        FeatureInfo fi = new FeatureInfo();
                        fi.name = fname;
                        this.mAvailableFeatures.put(fname, fi);
                    }
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
            permReader.close();
        }
        catch (XmlPullParserException e) {
            Slog.w((String)TAG, (String)"Got execption parsing permissions.", (Throwable)e);
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)"Got execption parsing permissions.", (Throwable)e);
        }
    }

    void readPermission(XmlPullParser parser, String name) throws IOException, XmlPullParserException {
        int type;
        BasePermission bp = this.mSettings.mPermissions.get(name = name.intern());
        if (bp == null) {
            bp = new BasePermission(name, null, 1);
            this.mSettings.mPermissions.put(name, bp);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("group".equals(tagName)) {
                String gidStr = parser.getAttributeValue(null, "gid");
                if (gidStr != null) {
                    int gid = Process.getGidForName((String)gidStr);
                    bp.gids = PackageManagerService.appendInt(bp.gids, gid);
                } else {
                    Slog.w((String)TAG, (String)("<group> without gid at " + parser.getPositionDescription()));
                }
            }
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    static int[] appendInt(int[] cur, int val) {
        if (cur == null) {
            return new int[]{val};
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            return cur;
        }
        int[] ret = new int[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    static int[] appendInts(int[] cur, int[] add) {
        if (add == null) {
            return cur;
        }
        if (cur == null) {
            return add;
        }
        int N = add.length;
        for (int i = 0; i < N; ++i) {
            cur = PackageManagerService.appendInt(cur, add[i]);
        }
        return cur;
    }

    static int[] removeInt(int[] cur, int val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            int[] ret = new int[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    static int[] removeInts(int[] cur, int[] rem) {
        if (rem == null) {
            return cur;
        }
        if (cur == null) {
            return cur;
        }
        int N = rem.length;
        for (int i = 0; i < N; ++i) {
            cur = PackageManagerService.removeInt(cur, rem[i]);
        }
        return cur;
    }

    PackageInfo generatePackageInfo(PackageParser.Package p, int flags) {
        if ((flags & 0x2000) != 0) {
            return PackageParser.generatePackageInfo((PackageParser.Package)p, null, (int)flags, (long)0L, (long)0L);
        }
        PackageSetting ps = (PackageSetting)p.mExtras;
        if (ps == null) {
            return null;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        return PackageParser.generatePackageInfo((PackageParser.Package)p, (int[])gp.gids, (int)flags, (long)ps.firstInstallTime, (long)ps.lastUpdateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInfo getPackageInfo(String packageName, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return this.generatePackageInfo(p, flags);
            }
            if ((flags & 0x2000) != 0) {
                return this.generatePackageInfoFromSettingsLPw(packageName, flags);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                out[i] = ps != null && ps.realName != null ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.mRenamedPackages.get(names[i]);
                out[i] = cur != null ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPackageUid(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return p.applicationInfo.uid;
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || ps.pkg == null || ps.pkg.applicationInfo == null) {
                return -1;
            }
            p = ps.pkg;
            int n = p != null ? p.applicationInfo.uid : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getPackageGids(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                SharedUserSetting suid = ps.sharedUser;
                int[] nArray = suid != null ? suid.gids : ps.gids;
                return nArray;
            }
        }
        return new int[0];
    }

    static final PermissionInfo generatePermissionInfo(BasePermission bp, int flags) {
        if (bp.perm != null) {
            return PackageParser.generatePermissionInfo((PackageParser.Permission)bp.perm, (int)flags);
        }
        PermissionInfo pi = new PermissionInfo();
        pi.name = bp.name;
        pi.packageName = bp.sourcePackage;
        pi.nonLocalizedLabel = bp.name;
        pi.protectionLevel = bp.protectionLevel;
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo getPermissionInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            BasePermission p = this.mSettings.mPermissions.get(name);
            if (p != null) {
                return PackageManagerService.generatePermissionInfo(p, flags);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission p : this.mSettings.mPermissions.values()) {
                if (group == null) {
                    if (p.perm != null && p.perm.info.group != null) continue;
                    out.add(PackageManagerService.generatePermissionInfo(p, flags));
                    continue;
                }
                if (p.perm == null || !group.equals(p.perm.info.group)) continue;
                out.add(PackageParser.generatePermissionInfo((PackageParser.Permission)p.perm, (int)flags));
            }
            if (out.size() > 0) {
                return out;
            }
            return this.mPermissionGroups.containsKey(group) ? out : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)this.mPermissionGroups.get(name), (int)flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int N = this.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)pg, (int)flags));
            }
            return out;
        }
    }

    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags) {
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfoFromSettingsLPw(packageName, flags);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            return PackageParser.generateApplicationInfo((PackageParser.Package)ps.pkg, (int)flags);
        }
        return null;
    }

    private PackageInfo generatePackageInfoFromSettingsLPw(String packageName, int flags) {
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (ps.pkg == null) {
                ps.pkg = new PackageParser.Package(packageName);
                ps.pkg.applicationInfo.packageName = packageName;
                ps.pkg.applicationInfo.flags = ps.pkgFlags;
                ps.pkg.applicationInfo.publicSourceDir = ps.resourcePathString;
                ps.pkg.applicationInfo.sourceDir = ps.codePathString;
                ps.pkg.applicationInfo.dataDir = this.getDataPathForPackage(ps.pkg.packageName, 0).getPath();
                ps.pkg.applicationInfo.nativeLibraryDir = ps.nativeLibraryPathString;
                ps.pkg.mSetEnabled = ps.enabled;
                ps.pkg.mSetStopped = ps.stopped;
            }
            return this.generatePackageInfo(ps.pkg, flags);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo getApplicationInfo(String packageName, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return PackageParser.generateApplicationInfo((PackageParser.Package)p, (int)flags);
            }
            if ("android".equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x2000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags);
            }
        }
        return null;
    }

    public void freeStorageAndNotify(final long freeStorageSize, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                if (retCode < 0) {
                    Slog.w((String)PackageManagerService.TAG, (String)"Couldn't clear application caches");
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(null, retCode >= 0);
                    }
                    catch (RemoteException e) {
                        Slog.w((String)PackageManagerService.TAG, (String)"RemoveException when invoking call back");
                    }
                }
            }
        });
    }

    public void freeStorage(final long freeStorageSize, final IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                if (retCode < 0) {
                    Slog.w((String)PackageManagerService.TAG, (String)"Couldn't clear application caches");
                }
                if (pi != null) {
                    try {
                        int code = retCode >= 0 ? 1 : 0;
                        pi.sendIntent(null, code, null, null, null);
                    }
                    catch (IntentSender.SendIntentException e1) {
                        Slog.i((String)PackageManagerService.TAG, (String)"Failed to send pending intent");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityInfo getActivityInfo(ComponentName component, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr((ComponentInfo)a.info, flags)) {
                return PackageParser.generateActivityInfo((PackageParser.Activity)a, (int)flags);
            }
            if (this.mResolveComponentName.equals((Object)component)) {
                return this.mResolveActivity;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityInfo getReceiverInfo(ComponentName component, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr((ComponentInfo)a.info, flags)) {
                return PackageParser.generateActivityInfo((PackageParser.Activity)a, (int)flags);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(ComponentName component, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Service s = (PackageParser.Service)this.mServices.mServices.get(component);
            if (s != null && this.mSettings.isEnabledLPr((ComponentInfo)s.info, flags)) {
                return PackageParser.generateServiceInfo((PackageParser.Service)s, (int)flags);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderInfo getProviderInfo(ComponentName component, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider p = this.mProvidersByComponent.get(component);
            if (p != null && this.mSettings.isEnabledLPr((ComponentInfo)p.info, flags)) {
                return PackageParser.generateProviderInfo((PackageParser.Provider)p, (int)flags);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemSharedLibraryNames() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Set<String> libSet = this.mSharedLibraries.keySet();
            int size = libSet.size();
            if (size > 0) {
                String[] libs = new String[size];
                libSet.toArray(libs);
                return libs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureInfo[] getSystemAvailableFeatures() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Collection<FeatureInfo> featSet = this.mAvailableFeatures.values();
            int size = featSet.size();
            if (size > 0) {
                FeatureInfo[] features = new FeatureInfo[size + 1];
                featSet.toArray(features);
                FeatureInfo fi = new FeatureInfo();
                fi.reqGlEsVersion = SystemProperties.getInt((String)"ro.opengles.version", (int)0);
                features[size] = fi;
                return features;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSystemFeature(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mAvailableFeatures.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkPermission(String permName, String pkgName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(pkgName);
            if (p != null && p.mExtras != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (ps.sharedUser != null) {
                    if (ps.sharedUser.grantedPermissions.contains(permName)) {
                        return 0;
                    }
                } else if (ps.grantedPermissions.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkUidPermission(String permName, int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj != null) {
                GrantedPermissions gp = (GrantedPermissions)obj;
                if (gp.grantedPermissions.contains(permName)) {
                    return 0;
                }
            } else {
                HashSet perms = (HashSet)this.mSystemPermissions.get(uid);
                if (perms != null && perms.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    private BasePermission findPermissionTreeLP(String permName) {
        for (BasePermission bp : this.mSettings.mPermissionTrees.values()) {
            if (!permName.startsWith(bp.name) || permName.length() <= bp.name.length() || permName.charAt(bp.name.length()) != '.') continue;
            return bp;
        }
        return null;
    }

    private BasePermission checkPermissionTreeLP(String permName) {
        BasePermission bp;
        if (permName != null && (bp = this.findPermissionTreeLP(permName)) != null) {
            if (bp.uid == Binder.getCallingUid()) {
                return bp;
            }
            throw new SecurityException("Calling uid " + Binder.getCallingUid() + " is not allowed to add to permission tree " + bp.name + " owned by uid " + bp.uid);
        }
        throw new SecurityException("No permission tree found for " + permName);
    }

    static boolean compareStrings(CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.getClass() != s2.getClass()) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean comparePermissionInfos(PermissionInfo pi1, PermissionInfo pi2) {
        if (pi1.icon != pi2.icon) {
            return false;
        }
        if (pi1.logo != pi2.logo) {
            return false;
        }
        if (pi1.protectionLevel != pi2.protectionLevel) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.name, pi2.name)) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.nonLocalizedLabel, pi2.nonLocalizedLabel)) {
            return false;
        }
        return PackageManagerService.compareStrings(pi1.packageName, pi2.packageName);
    }

    boolean addPermissionLocked(PermissionInfo info, boolean async) {
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.checkPermissionTreeLP(info.name);
        BasePermission bp = this.mSettings.mPermissions.get(info.name);
        boolean added = bp == null;
        boolean changed = true;
        if (added) {
            bp = new BasePermission(info.name, tree.sourcePackage, 2);
        } else {
            if (bp.type != 2) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            if (bp.protectionLevel == info.protectionLevel && bp.perm.owner.equals(tree.perm.owner) && bp.uid == tree.uid && PackageManagerService.comparePermissionInfos(bp.perm.info, info)) {
                changed = false;
            }
        }
        bp.protectionLevel = info.protectionLevel;
        bp.perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(info));
        bp.perm.info.packageName = tree.perm.info.packageName;
        bp.uid = tree.uid;
        if (added) {
            this.mSettings.mPermissions.put(info.name, bp);
        }
        if (changed) {
            if (!async) {
                this.mSettings.writeLPr();
            } else {
                this.scheduleWriteSettingsLocked();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPermission(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPermissionAsync(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePermission(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.checkPermissionTreeLP(name);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null) {
                if (bp.type != 2) {
                    throw new SecurityException("Not allowed to modify non-dynamic permission " + name);
                }
                this.mSettings.mPermissions.remove(name);
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtectedBroadcast(String actionName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mProtectedBroadcasts.contains(actionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkSignatures(String pkg1, String pkg2) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            return PackageManagerService.compareSignatures(p1.mSignatures, p2.mSignatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkUidSignatures(int uid1, int uid2) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Signature[] s2;
            Signature[] s1;
            Object obj = this.mSettings.getUserIdLPr(uid1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s1 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s1 = ((PackageSetting)obj).signatures.mSignatures;
            }
            obj = this.mSettings.getUserIdLPr(uid2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s2 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s2 = ((PackageSetting)obj).signatures.mSignatures;
            }
            return PackageManagerService.compareSignatures(s1, s2);
        }
    }

    static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        HashSet<Signature> set1 = new HashSet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        HashSet<Signature> set2 = new HashSet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPackagesForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    res[i++] = it.next().name;
                }
                return res;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return new String[]{ps.name};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUidForSharedUser(String sharedUserName) {
        if (sharedUserName == null) {
            return -1;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, false);
            if (suid == null) {
                return -1;
            }
            return suid.userId;
        }
    }

    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags) {
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags);
        return this.chooseBestActivity(intent, resolvedType, flags, query);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivity(intent, resolvedType, flags, query, r0.priority);
                if (ri != null) {
                    return ri;
                }
                return this.mResolveInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolveInfo findPreferredActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            List<PreferredActivity> prefs;
            if (intent.getSelector() != null) {
                intent = intent.getSelector();
            }
            if ((prefs = this.mSettings.mPreferredActivities.queryIntent(intent, resolvedType, (flags & 0x10000) != 0)) != null && prefs.size() > 0) {
                int match = 0;
                int N = query.size();
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (ri.match <= match) continue;
                    match = ri.match;
                }
                match &= 0xFFF0000;
                int M = prefs.size();
                for (int i = 0; i < M; ++i) {
                    ActivityInfo ai;
                    PreferredActivity pa = prefs.get(i);
                    if (pa.mPref.mMatch != match || (ai = this.getActivityInfo(pa.mPref.mComponent, flags)) == null) continue;
                    for (int j = 0; j < N; ++j) {
                        ResolveInfo ri = query.get(j);
                        if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                        if (!pa.mPref.sameSet(query, priority)) {
                            Slog.i((String)TAG, (String)("Result set changed, dropping preferred activity for " + intent + " type " + resolvedType));
                            this.mSettings.mPreferredActivities.removeFilter(pa);
                            return null;
                        }
                        return ri;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags) {
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mActivities.queryIntent(intent, resolvedType, flags);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mActivities.queryIntentForPackage(intent, resolvedType, flags, pkg.activities);
            }
            return new ArrayList<ResolveInfo>();
        }
    }

    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags) {
        int N;
        int i;
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivities(intent, resolvedType, flags | 0x40);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = (String)it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags) {
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mReceivers.queryIntent(intent, resolvedType, flags);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, pkg.receivers);
            }
            return null;
        }
    }

    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags) {
        List<ResolveInfo> query = this.queryIntentServices(intent, resolvedType, flags);
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags) {
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags);
            if (si != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.serviceInfo = si;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mServices.queryIntent(intent, resolvedType, flags);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mServices.queryIntentForPackage(intent, resolvedType, flags, pkg.services);
            }
            return null;
        }
    }

    private static final int getContinuationPoint(String[] keys, String key) {
        int insertPoint;
        int index = key == null ? 0 : ((insertPoint = Arrays.binarySearch(keys, key)) < 0 ? -insertPoint : insertPoint + 1);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, String lastRead) {
        ParceledListSlice list = new ParceledListSlice();
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object[] keys = listUninstalled ? this.mSettings.mPackages.keySet().toArray(new String[this.mSettings.mPackages.size()]) : this.mPackages.keySet().toArray(new String[this.mPackages.size()]);
            Arrays.sort(keys);
            int i = PackageManagerService.getContinuationPoint((String[])keys, lastRead);
            int N = keys.length;
            while (i < N) {
                Object packageName = keys[i++];
                PackageInfo pi = null;
                if (listUninstalled) {
                    PackageSetting ps = this.mSettings.mPackages.get(packageName);
                    if (ps != null) {
                        pi = this.generatePackageInfoFromSettingsLPw(ps.name, flags);
                    }
                } else {
                    PackageParser.Package p = this.mPackages.get(packageName);
                    if (p != null) {
                        pi = this.generatePackageInfo(p, flags);
                    }
                }
                if (pi == null || list.append((Parcelable)pi)) continue;
                break;
            }
            if (i == N) {
                list.setLastSlice(true);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, String lastRead) {
        ParceledListSlice list = new ParceledListSlice();
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object[] keys = listUninstalled ? this.mSettings.mPackages.keySet().toArray(new String[this.mSettings.mPackages.size()]) : this.mPackages.keySet().toArray(new String[this.mPackages.size()]);
            Arrays.sort(keys);
            int i = PackageManagerService.getContinuationPoint((String[])keys, lastRead);
            int N = keys.length;
            while (i < N) {
                Object packageName = keys[i++];
                ApplicationInfo ai = null;
                if (listUninstalled) {
                    PackageSetting ps = this.mSettings.mPackages.get(packageName);
                    if (ps != null) {
                        ai = this.generateApplicationInfoFromSettingsLPw(ps.name, flags);
                    }
                } else {
                    PackageParser.Package p = this.mPackages.get(packageName);
                    if (p != null) {
                        ai = PackageParser.generateApplicationInfo((PackageParser.Package)p, (int)flags);
                    }
                }
                if (ai == null || list.append((Parcelable)ai)) continue;
                break;
            }
            if (i == N) {
                list.setLastSlice(true);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationInfo> getPersistentApplications(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Package p : this.mPackages.values()) {
                if (p.applicationInfo == null || (p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p)) continue;
                finalList.add(PackageParser.generateApplicationInfo((PackageParser.Package)p, (int)flags));
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderInfo resolveContentProvider(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider provider = this.mProviders.get(name);
            return provider != null && this.mSettings.isEnabledLPr((ComponentInfo)provider.info, flags) && (!this.mSafeMode || (provider.info.applicationInfo.flags & 1) != 0) ? PackageParser.generateProviderInfo((PackageParser.Provider)provider, (int)flags) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (Map.Entry<String, PackageParser.Provider> entry : this.mProviders.entrySet()) {
                PackageParser.Provider p = entry.getValue();
                if (!p.syncable || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0) continue;
                outNames.add(entry.getKey());
                outInfo.add(PackageParser.generateProviderInfo((PackageParser.Provider)p, (int)0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        ArrayList<ProviderInfo> finalList = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Provider p : this.mProvidersByComponent.values()) {
                if (p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || p.info.applicationInfo.uid != uid) || !this.mSettings.isEnabledLPr((ComponentInfo)p.info, flags) || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(3);
                }
                finalList.add(PackageParser.generateProviderInfo((PackageParser.Provider)p, (int)flags));
            }
        }
        if (finalList != null) {
            Collections.sort(finalList, mProviderInitOrderSorter);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentationInfo getInstrumentationInfo(ComponentName name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Instrumentation i = this.mInstrumentation.get(name);
            return PackageParser.generateInstrumentationInfo((PackageParser.Instrumentation)i, (int)flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage)) continue;
                finalList.add(PackageParser.generateInstrumentationInfo((PackageParser.Instrumentation)p, (int)flags));
            }
        }
        return finalList;
    }

    private void scanDirLI(File dir, int flags, int scanMode, long currentTime) {
        String[] files = dir.list();
        if (files == null) {
            Log.d((String)TAG, (String)("No files in app dir " + dir));
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            PackageParser.Package pkg;
            File file = new File(dir, files[i]);
            if (!PackageManagerService.isPackageFilename(files[i]) || (pkg = this.scanPackageLI(file, flags | 4, scanMode, currentTime)) != null || (flags & 1) != 0 || this.mLastScanError != -2) continue;
            Slog.w((String)TAG, (String)("Cleaning up failed install of " + file));
            file.delete();
        }
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    static void reportSettingsProblem(int priority, String msg) {
        try {
            File fname = PackageManagerService.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            PrintWriter pw = new PrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            pw.close();
            FileUtils.setPermissions((String)fname.toString(), (int)508, (int)-1, (int)-1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Slog.println((int)priority, (String)TAG, (String)msg);
    }

    private boolean collectCertificatesLI(PackageParser pp, PackageSetting ps, PackageParser.Package pkg, File srcFile, int parseFlags) {
        if (ps != null && ps.codePath.equals(srcFile) && ps.timeStamp == srcFile.lastModified()) {
            if (ps.signatures.mSignatures != null && ps.signatures.mSignatures.length != 0) {
                pkg.mSignatures = ps.signatures.mSignatures;
                return true;
            }
            Slog.w((String)TAG, (String)("PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them."));
        } else {
            Log.i((String)TAG, (String)(srcFile.toString() + " changed; collecting certs"));
        }
        if (!pp.collectCertificates(pkg, parseFlags)) {
            this.mLastScanError = pp.getParseError();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanMode, long currentTime) {
        PackageSetting updatedPkg;
        this.mLastScanError = 1;
        String scanPath = scanFile.getPath();
        PackageParser pp = new PackageParser(scanPath);
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        PackageParser.Package pkg = pp.parsePackage(scanFile, scanPath, this.mMetrics, parseFlags |= this.mDefParseFlags);
        if (pkg == null) {
            this.mLastScanError = pp.getParseError();
            return null;
        }
        PackageSetting ps = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String oldName = this.mSettings.mRenamedPackages.get(pkg.packageName);
            if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName)) {
                ps = this.mSettings.peekPackageLPr(oldName);
            }
            if (ps == null) {
                ps = this.mSettings.peekPackageLPr(pkg.packageName);
            }
            updatedPkg = this.mSettings.mDisabledSysPackages.get(ps != null ? ps.name : pkg.packageName);
        }
        if (updatedPkg != null && (parseFlags & 1) != 0 && ps != null && !ps.codePath.equals(scanFile)) {
            if (pkg.mVersionCode < ps.versionCode) {
                Log.i((String)TAG, (String)("Package " + ps.name + " at " + scanFile + " ignored: updated version " + ps.versionCode + " better than this " + pkg.mVersionCode));
                this.mLastScanError = -5;
                return null;
            }
            hashMap = this.mPackages;
            synchronized (hashMap) {
                this.mPackages.remove(ps.name);
            }
            Slog.w((String)TAG, (String)("Package " + ps.name + " at " + scanFile + "reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode));
            FileInstallArgs args = new FileInstallArgs(ps.codePathString, ps.resourcePathString, ps.nativeLibraryPathString);
            ((InstallArgs)args).cleanUpResourcesLI();
            this.mSettings.enableSystemPackageLPw(ps.name);
        }
        if (updatedPkg != null) {
            parseFlags |= 1;
        }
        if (!this.collectCertificatesLI(pp, ps, pkg, scanFile, parseFlags)) {
            Slog.w((String)TAG, (String)("Failed verifying certificates for package:" + pkg.packageName));
            return null;
        }
        if (ps != null && !ps.codePath.equals(ps.resourcePath)) {
            parseFlags |= 0x10;
        }
        String codePath = null;
        String resPath = null;
        if ((parseFlags & 0x10) != 0) {
            if (ps != null && ps.resourcePathString != null) {
                resPath = ps.resourcePathString;
            } else {
                Slog.e((String)TAG, (String)("Resource path not set for pkg : " + pkg.packageName));
            }
        } else {
            resPath = pkg.mScanPath;
        }
        codePath = pkg.mScanPath;
        PackageManagerService.setApplicationInfoPaths(pkg, codePath, resPath);
        return this.scanPackageLI(pkg, parseFlags, scanMode | 8, currentTime);
    }

    private static void setApplicationInfoPaths(PackageParser.Package pkg, String destCodePath, String destResPath) {
        pkg.mPath = pkg.mScanPath = destCodePath;
        pkg.applicationInfo.sourceDir = destCodePath;
        pkg.applicationInfo.publicSourceDir = destResPath;
    }

    private static String fixProcessName(String defProcessName, String processName, int uid) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private boolean verifySignaturesLP(PackageSetting pkgSetting, PackageParser.Package pkg) {
        if (pkgSetting.signatures.mSignatures != null && PackageManagerService.compareSignatures(pkgSetting.signatures.mSignatures, pkg.mSignatures) != 0) {
            Slog.e((String)TAG, (String)("Package " + pkg.packageName + " signatures do not match the previously installed version; ignoring!"));
            this.mLastScanError = -7;
            return false;
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSignatures != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
            Slog.e((String)TAG, (String)("Package " + pkg.packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!"));
            this.mLastScanError = -8;
            return false;
        }
        return true;
    }

    private static final void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootDexOpt() {
        ArrayList<PackageParser.Package> pkgs = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mDeferredDexOpt.size() > 0) {
                pkgs = new ArrayList<PackageParser.Package>(this.mDeferredDexOpt);
                this.mDeferredDexOpt.clear();
            }
        }
        if (pkgs != null) {
            for (int i = 0; i < pkgs.size(); ++i) {
                if (!this.isFirstBoot()) {
                    try {
                        ActivityManagerNative.getDefault().showBootMessage((CharSequence)this.mContext.getResources().getString(17040313, new Object[]{i + 1, pkgs.size()}), true);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                PackageParser.Package p = pkgs.get(i);
                Object object = this.mInstallLock;
                synchronized (object) {
                    if (!p.mDidDexOpt) {
                        this.performDexOptLI(p, false, false);
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performDexOpt(String packageName) {
        PackageParser.Package p;
        PackageManagerService.enforceSystemOrRoot("Only the system can request dexopt be performed");
        if (!this.mNoDexOpt) {
            return false;
        }
        Object object = this.mPackages;
        synchronized (object) {
            p = this.mPackages.get(packageName);
            if (p == null || p.mDidDexOpt) {
                return false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            return this.performDexOptLI(p, false, false) == 1;
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, boolean forceDex, boolean defer) {
        boolean performed = false;
        if ((pkg.applicationInfo.flags & 4) != 0) {
            String path = pkg.mScanPath;
            int ret = 0;
            try {
                if (forceDex || DexFile.isDexOptNeeded((String)path)) {
                    if (!forceDex && defer) {
                        this.mDeferredDexOpt.add(pkg);
                        return 2;
                    }
                    Log.i((String)TAG, (String)("Running dexopt on: " + pkg.applicationInfo.packageName));
                    ret = this.mInstaller.dexopt(path, pkg.applicationInfo.uid, !PackageManagerService.isForwardLocked(pkg));
                    pkg.mDidDexOpt = true;
                    performed = true;
                }
            }
            catch (FileNotFoundException e) {
                Slog.w((String)TAG, (String)("Apk not found for dexopt: " + path));
                ret = -1;
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("IOException reading apk: " + path), (Throwable)e);
                ret = -1;
            }
            catch (StaleDexCacheError e) {
                Slog.w((String)TAG, (String)("StaleDexCacheError when reading apk: " + path), (Throwable)e);
                ret = -1;
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception when doing dexopt : ", (Throwable)e);
                ret = -1;
            }
            if (ret < 0) {
                return -1;
            }
        }
        return performed ? 1 : 0;
    }

    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w((String)TAG, (String)("Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition"));
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w((String)TAG, (String)("Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists"));
            return false;
        }
        return true;
    }

    File getDataPathForUser(int userId) {
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId);
    }

    private File getDataPathForPackage(String packageName, int userId) {
        if (userId == 0) {
            return new File(this.mAppDataDir, packageName);
        }
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId + File.separator + packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, long currentTime) {
        String path;
        boolean forceDex;
        long scanFileTime;
        String pkgName;
        PackageSetting pkgSetting;
        block133: {
            File dataPath;
            File scanFile = new File(pkg.mScanPath);
            if (scanFile == null || pkg.applicationInfo.sourceDir == null || pkg.applicationInfo.publicSourceDir == null) {
                Slog.w((String)TAG, (String)" Code and resource paths haven't been set correctly");
                this.mLastScanError = -2;
                return null;
            }
            this.mScanningPath = scanFile;
            if ((parseFlags & 1) != 0) {
                pkg.applicationInfo.flags |= 1;
            }
            if (pkg.packageName.equals("android")) {
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    if (this.mAndroidApplication != null) {
                        Slog.w((String)TAG, (String)"*************************************************");
                        Slog.w((String)TAG, (String)"Core android package being redefined.  Skipping.");
                        Slog.w((String)TAG, (String)(" file=" + this.mScanningPath));
                        Slog.w((String)TAG, (String)"*************************************************");
                        this.mLastScanError = -5;
                        return null;
                    }
                    this.mPlatformPackage = pkg;
                    pkg.mVersionCode = this.mSdkVersion;
                    this.mResolveActivity.applicationInfo = this.mAndroidApplication = pkg.applicationInfo;
                    this.mResolveActivity.name = ResolverActivity.class.getName();
                    this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                    this.mResolveActivity.processName = this.mAndroidApplication.processName;
                    this.mResolveActivity.launchMode = 0;
                    this.mResolveActivity.flags = 32;
                    this.mResolveActivity.theme = 16974588;
                    this.mResolveActivity.exported = true;
                    this.mResolveActivity.enabled = true;
                    this.mResolveInfo.activityInfo = this.mResolveActivity;
                    this.mResolveInfo.priority = 0;
                    this.mResolveInfo.preferredOrder = 0;
                    this.mResolveInfo.match = 0;
                    this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                }
            }
            if (this.mPackages.containsKey(pkg.packageName) || this.mSharedLibraries.containsKey(pkg.packageName)) {
                Slog.w((String)TAG, (String)("Application package " + pkg.packageName + " already installed.  Skipping duplicate."));
                this.mLastScanError = -5;
                return null;
            }
            File destCodeFile = new File(pkg.applicationInfo.sourceDir);
            File destResourceFile = new File(pkg.applicationInfo.publicSourceDir);
            SharedUserSetting suid = null;
            pkgSetting = null;
            if (!PackageManagerService.isSystemApp(pkg)) {
                pkg.mOriginalPackages = null;
                pkg.mRealPackage = null;
                pkg.mAdoptPermissions = null;
            }
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                if (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null) {
                    String file;
                    int i;
                    if (this.mTmpSharedLibraries == null || this.mTmpSharedLibraries.length < this.mSharedLibraries.size()) {
                        this.mTmpSharedLibraries = new String[this.mSharedLibraries.size()];
                    }
                    int num = 0;
                    int N = pkg.usesLibraries != null ? pkg.usesLibraries.size() : 0;
                    for (i = 0; i < N; ++i) {
                        file = this.mSharedLibraries.get(pkg.usesLibraries.get(i));
                        if (file == null) {
                            Slog.e((String)TAG, (String)("Package " + pkg.packageName + " requires unavailable shared library " + (String)pkg.usesLibraries.get(i) + "; failing!"));
                            this.mLastScanError = -9;
                            return null;
                        }
                        this.mTmpSharedLibraries[num] = file;
                        ++num;
                    }
                    N = pkg.usesOptionalLibraries != null ? pkg.usesOptionalLibraries.size() : 0;
                    for (i = 0; i < N; ++i) {
                        file = this.mSharedLibraries.get(pkg.usesOptionalLibraries.get(i));
                        if (file == null) {
                            Slog.w((String)TAG, (String)("Package " + pkg.packageName + " desires unavailable shared library " + (String)pkg.usesOptionalLibraries.get(i) + "; ignoring!"));
                            continue;
                        }
                        this.mTmpSharedLibraries[num] = file;
                        ++num;
                    }
                    if (num > 0) {
                        pkg.usesLibraryFiles = new String[num];
                        System.arraycopy(this.mTmpSharedLibraries, 0, pkg.usesLibraryFiles, 0, num);
                    }
                }
                if (pkg.mSharedUserId != null && (suid = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, pkg.applicationInfo.flags, true)) == null) {
                    Slog.w((String)TAG, (String)("Creating application package " + pkg.packageName + " for shared user failed"));
                    this.mLastScanError = -4;
                    return null;
                }
                PackageSetting origPackage = null;
                String realName = null;
                if (pkg.mOriginalPackages != null) {
                    String renamed = this.mSettings.mRenamedPackages.get(pkg.mRealPackage);
                    if (pkg.mOriginalPackages.contains(renamed)) {
                        realName = pkg.mRealPackage;
                        if (!pkg.packageName.equals(renamed)) {
                            pkg.setPackageName(renamed);
                        }
                    } else {
                        for (int i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
                            origPackage = this.mSettings.peekPackageLPr((String)pkg.mOriginalPackages.get(i));
                            if (origPackage == null) continue;
                            if (!this.verifyPackageUpdateLPr(origPackage, pkg)) {
                                origPackage = null;
                                continue;
                            }
                            if (origPackage.sharedUser == null || origPackage.sharedUser.name.equals(pkg.mSharedUserId)) break;
                            Slog.w((String)TAG, (String)("Unable to migrate data from " + origPackage.name + " to " + pkg.packageName + ": old uid " + origPackage.sharedUser.name + " differs from " + pkg.mSharedUserId));
                            origPackage = null;
                        }
                    }
                }
                if (this.mTransferedPackages.contains(pkg.packageName)) {
                    Slog.w((String)TAG, (String)("Package " + pkg.packageName + " was transferred to another, but its .apk remains"));
                }
                if ((pkgSetting = this.mSettings.getPackageLPw(pkg, origPackage, realName, suid, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryDir, pkg.applicationInfo.flags, true, false)) == null) {
                    Slog.w((String)TAG, (String)("Creating application package " + pkg.packageName + " failed"));
                    this.mLastScanError = -4;
                    return null;
                }
                if (pkgSetting.origPackage != null) {
                    pkg.setPackageName(origPackage.name);
                    String msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
                    PackageManagerService.reportSettingsProblem(5, msg);
                    this.mTransferedPackages.add(origPackage.name);
                    pkgSetting.origPackage = null;
                }
                if (realName != null) {
                    this.mTransferedPackages.add(pkg.packageName);
                }
                if (this.mSettings.mDisabledSysPackages.get(pkg.packageName) != null) {
                    pkg.applicationInfo.flags |= 0x80;
                }
                pkg.applicationInfo.uid = pkgSetting.userId;
                pkg.mExtras = pkgSetting;
                if (!this.verifySignaturesLP(pkgSetting, pkg)) {
                    if ((parseFlags & 0x40) == 0) {
                        return null;
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    if (pkgSetting.sharedUser != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
                        Log.w((String)TAG, (String)("Signature mismatch for shared user : " + pkgSetting.sharedUser));
                        this.mLastScanError = -104;
                        return null;
                    }
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
                if ((scanMode & 0x10) != 0) {
                    int N = pkg.providers.size();
                    for (int i = 0; i < N; ++i) {
                        PackageParser.Provider p = (PackageParser.Provider)pkg.providers.get(i);
                        if (p.info.authority == null) continue;
                        String[] names = p.info.authority.split(";");
                        for (int j = 0; j < names.length; ++j) {
                            if (!this.mProviders.containsKey(names[j])) continue;
                            PackageParser.Provider other = this.mProviders.get(names[j]);
                            Slog.w((String)TAG, (String)("Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?")));
                            this.mLastScanError = -13;
                            return null;
                        }
                    }
                }
                if (pkg.mAdoptPermissions != null) {
                    for (int i = pkg.mAdoptPermissions.size() - 1; i >= 0; --i) {
                        String origName = (String)pkg.mAdoptPermissions.get(i);
                        PackageSetting orig = this.mSettings.peekPackageLPr(origName);
                        if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                        Slog.i((String)TAG, (String)("Adopting permissions from " + origName + " to " + pkg.packageName));
                        this.mSettings.transferPermissionsLPw(origName, pkg.packageName);
                    }
                }
            }
            pkgName = pkg.packageName;
            scanFileTime = scanFile.lastModified();
            forceDex = (scanMode & 4) != 0;
            pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName, pkg.applicationInfo.uid);
            if (this.mPlatformPackage == pkg) {
                dataPath = new File(Environment.getDataDirectory(), "system");
                pkg.applicationInfo.dataDir = dataPath.getPath();
            } else {
                dataPath = this.getDataPathForPackage(pkg.packageName, 0);
                boolean uidError = false;
                if (dataPath.exists()) {
                    this.mOutPermissions[1] = 0;
                    FileUtils.getPermissions((String)dataPath.getPath(), (int[])this.mOutPermissions);
                    if (this.mOutPermissions[1] != pkg.applicationInfo.uid) {
                        Object msg;
                        boolean recovered = false;
                        if ((parseFlags & 1) != 0) {
                            int ret = this.mInstaller.remove(pkgName, 0);
                            if (ret >= 0) {
                                this.mUserManager.removePackageForAllUsers(pkgName);
                                msg = "System package " + pkg.packageName + " has changed from uid: " + this.mOutPermissions[1] + " to " + pkg.applicationInfo.uid + "; old data erased";
                                PackageManagerService.reportSettingsProblem(5, (String)msg);
                                recovered = true;
                                ret = this.mInstaller.install(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.uid);
                                if (ret == -1) {
                                    msg = "System package " + pkg.packageName + " could not have data directory re-created after delete.";
                                    PackageManagerService.reportSettingsProblem(5, (String)msg);
                                    this.mLastScanError = -4;
                                    return null;
                                }
                                this.mUserManager.installPackageForAllUsers(pkgName, pkg.applicationInfo.uid);
                            }
                            if (!recovered) {
                                this.mHasSystemUidErrors = true;
                            }
                        }
                        if (!recovered) {
                            pkg.applicationInfo.nativeLibraryDir = pkg.applicationInfo.dataDir = "/mismatched_uid/settings_" + pkg.applicationInfo.uid + "/fs_" + this.mOutPermissions[1];
                            String msg2 = "Package " + pkg.packageName + " has mismatched uid: " + this.mOutPermissions[1] + " on disk, " + pkg.applicationInfo.uid + " in settings";
                            msg = this.mPackages;
                            synchronized (msg) {
                                this.mSettings.mReadMessages.append(msg2);
                                this.mSettings.mReadMessages.append('\n');
                                uidError = true;
                                if (!pkgSetting.uidError) {
                                    PackageManagerService.reportSettingsProblem(6, msg2);
                                }
                            }
                        }
                    }
                    pkg.applicationInfo.dataDir = dataPath.getPath();
                } else {
                    int ret = this.mInstaller.install(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.uid);
                    if (ret < 0) {
                        this.mLastScanError = -4;
                        return null;
                    }
                    this.mUserManager.installPackageForAllUsers(pkgName, pkg.applicationInfo.uid);
                    if (dataPath.exists()) {
                        pkg.applicationInfo.dataDir = dataPath.getPath();
                    } else {
                        Slog.w((String)TAG, (String)("Unable to create data directory: " + dataPath));
                        pkg.applicationInfo.dataDir = null;
                    }
                }
                if (pkg.applicationInfo.nativeLibraryDir == null && pkg.applicationInfo.dataDir != null) {
                    if (pkgSetting.nativeLibraryPathString == null) {
                        String nativeLibraryPath;
                        pkg.applicationInfo.nativeLibraryDir = nativeLibraryPath = new File(dataPath, LIB_DIR_NAME).getPath();
                        pkgSetting.nativeLibraryPathString = nativeLibraryPath;
                    } else {
                        pkg.applicationInfo.nativeLibraryDir = pkgSetting.nativeLibraryPathString;
                    }
                }
                pkgSetting.uidError = uidError;
            }
            path = scanFile.getPath();
            if (pkg.applicationInfo.nativeLibraryDir != null) {
                try {
                    File nativeLibraryDir = new File(pkg.applicationInfo.nativeLibraryDir);
                    String dataPathString = dataPath.getCanonicalPath();
                    if (PackageManagerService.isSystemApp(pkg) && !PackageManagerService.isUpdatedSystemApp(pkg)) {
                        if (NativeLibraryHelper.removeNativeBinariesFromDirLI((File)nativeLibraryDir)) {
                            Log.i((String)TAG, (String)("removed obsolete native libraries for system package " + path));
                        }
                        break block133;
                    }
                    if (nativeLibraryDir.getParentFile().getCanonicalPath().equals(dataPathString)) {
                        boolean isSymLink;
                        try {
                            isSymLink = OsConstants.S_ISLNK((int)Libcore.os.lstat((String)nativeLibraryDir.getPath()).st_mode);
                        }
                        catch (ErrnoException e) {
                            isSymLink = true;
                        }
                        if (isSymLink) {
                            this.mInstaller.unlinkNativeLibraryDirectory(dataPathString);
                        }
                        NativeLibraryHelper.copyNativeBinariesIfNeededLI((File)scanFile, (File)nativeLibraryDir);
                        break block133;
                    }
                    Slog.i((String)TAG, (String)("Linking native library dir for " + path));
                    this.mInstaller.linkNativeLibraryDirectory(dataPathString, pkg.applicationInfo.nativeLibraryDir);
                }
                catch (IOException ioe) {
                    Log.e((String)TAG, (String)("Unable to get canonical file " + ioe.toString()));
                }
            }
        }
        pkg.mScanPath = path;
        if ((scanMode & 2) == 0 && this.performDexOptLI(pkg, forceDex, (scanMode & 0x80) != 0) == -1) {
            this.mLastScanError = -11;
            return null;
        }
        if (this.mFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        if ((parseFlags & 2) != 0) {
            this.killApplication(pkg.applicationInfo.packageName, pkg.applicationInfo.uid);
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a;
            PackageParser.Provider p;
            int i;
            if ((scanMode & 1) != 0) {
                this.mAppDirs.put(pkg.mPath, pkg);
            }
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            this.mSettings.mPackagesToBeCleaned.remove(pkgName);
            if (currentTime != 0L) {
                if (pkgSetting.firstInstallTime == 0L) {
                    pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
                } else if ((scanMode & 0x40) != 0) {
                    pkgSetting.lastUpdateTime = currentTime;
                }
            } else if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
            } else if ((parseFlags & 0x40) != 0 && scanFileTime != pkgSetting.timeStamp) {
                pkgSetting.lastUpdateTime = scanFileTime;
            }
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                p = (PackageParser.Provider)pkg.providers.get(i);
                p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName, pkg.applicationInfo.uid);
                this.mProvidersByComponent.put(new ComponentName(p.info.packageName, p.info.name), p);
                p.syncable = p.info.isSyncable;
                if (p.info.authority != null) {
                    String[] names = p.info.authority.split(";");
                    p.info.authority = null;
                    for (int j = 0; j < names.length; ++j) {
                        if (j == 1 && p.syncable) {
                            p = new PackageParser.Provider(p);
                            p.syncable = false;
                        }
                        if (!this.mProviders.containsKey(names[j])) {
                            this.mProviders.put(names[j], p);
                            if (p.info.authority == null) {
                                p.info.authority = names[j];
                                continue;
                            }
                            p.info.authority = p.info.authority + ";" + names[j];
                            continue;
                        }
                        PackageParser.Provider other = this.mProviders.get(names[j]);
                        Slog.w((String)TAG, (String)("Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?")));
                    }
                }
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = (PackageParser.Service)pkg.services.get(i);
                s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName, pkg.applicationInfo.uid);
                this.mServices.addService(s);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Activity)pkg.receivers.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName, pkg.applicationInfo.uid);
                this.mReceivers.addActivity(a, "receiver");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Activity)pkg.activities.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName, pkg.applicationInfo.uid);
                this.mActivities.addActivity(a, "activity");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissionGroups.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.PermissionGroup pg = (PackageParser.PermissionGroup)pkg.permissionGroups.get(i);
                PackageParser.PermissionGroup cur = this.mPermissionGroups.get(pg.info.name);
                if (cur == null) {
                    this.mPermissionGroups.put(pg.info.name, pg);
                    if ((parseFlags & 2) == 0) continue;
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append(pg.info.name);
                    continue;
                }
                Slog.w((String)TAG, (String)("Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName));
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append("DUP:");
                r.append(pg.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                p = (PackageParser.Permission)pkg.permissions.get(i);
                HashMap<String, BasePermission> permissionMap = p.tree ? this.mSettings.mPermissionTrees : this.mSettings.mPermissions;
                p.group = this.mPermissionGroups.get(p.info.group);
                if (p.info.group == null || p.group != null) {
                    BasePermission bp = permissionMap.get(p.info.name);
                    if (bp == null) {
                        bp = new BasePermission(p.info.name, p.info.packageName, 0);
                        permissionMap.put(p.info.name, bp);
                    }
                    if (bp.perm == null) {
                        if (bp.sourcePackage == null || bp.sourcePackage.equals(p.info.packageName)) {
                            BasePermission tree = this.findPermissionTreeLP(p.info.name);
                            if (tree == null || tree.sourcePackage.equals(p.info.packageName)) {
                                bp.packageSetting = pkgSetting;
                                bp.perm = p;
                                bp.uid = pkg.applicationInfo.uid;
                                if ((parseFlags & 2) != 0) {
                                    if (r == null) {
                                        r = new StringBuilder(256);
                                    } else {
                                        r.append(' ');
                                    }
                                    r.append(p.info.name);
                                }
                            } else {
                                Slog.w((String)TAG, (String)("Permission " + p.info.name + " from package " + p.info.packageName + " ignored: base tree " + tree.name + " is from package " + tree.sourcePackage));
                            }
                        } else {
                            Slog.w((String)TAG, (String)("Permission " + p.info.name + " from package " + p.info.packageName + " ignored: original from " + bp.sourcePackage));
                        }
                    } else if ((parseFlags & 2) != 0) {
                        if (r == null) {
                            r = new StringBuilder(256);
                        } else {
                            r.append(' ');
                        }
                        r.append("DUP:");
                        r.append(p.info.name);
                    }
                    if (bp.perm != p) continue;
                    bp.protectionLevel = p.info.protectionLevel;
                    continue;
                }
                Slog.w((String)TAG, (String)("Permission " + p.info.name + " from package " + p.info.packageName + " ignored: no group " + p.group));
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Instrumentation)pkg.instrumentation.get(i);
                a.info.packageName = pkg.applicationInfo.packageName;
                a.info.sourceDir = pkg.applicationInfo.sourceDir;
                a.info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                a.info.dataDir = pkg.applicationInfo.dataDir;
                a.info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                this.mInstrumentation.put(a.getComponentName(), (PackageParser.Instrumentation)a);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                N = pkg.protectedBroadcasts.size();
                for (i = 0; i < N; ++i) {
                    this.mProtectedBroadcasts.add((String)pkg.protectedBroadcasts.get(i));
                }
            }
            pkgSetting.setTimeStamp(scanFileTime);
        }
        return pkg;
    }

    private void killApplication(String pkgName, int uid) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.killApplicationWithUid(pkgName, uid);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(PackageParser.Package pkg, boolean chatty) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a;
            PackageParser.Provider p;
            int i;
            this.clearPackagePreferredActivitiesLPw(pkg.packageName);
            this.mPackages.remove(pkg.applicationInfo.packageName);
            if (pkg.mPath != null) {
                this.mAppDirs.remove(pkg.mPath);
            }
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                p = (PackageParser.Provider)pkg.providers.get(i);
                this.mProvidersByComponent.remove(new ComponentName(p.info.packageName, p.info.name));
                if (p.info.authority == null) continue;
                String[] names = p.info.authority.split(";");
                for (int j = 0; j < names.length; ++j) {
                    if (this.mProviders.get(names[j]) != p) continue;
                    this.mProviders.remove(names[j]);
                }
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = (PackageParser.Service)pkg.services.get(i);
                this.mServices.removeService(s);
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Activity)pkg.receivers.get(i);
                this.mReceivers.removeActivity(a, "receiver");
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Activity)pkg.activities.get(i);
                this.mActivities.removeActivity(a, "activity");
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                p = (PackageParser.Permission)pkg.permissions.get(i);
                BasePermission bp = this.mSettings.mPermissions.get(p.info.name);
                if (bp == null) {
                    bp = this.mSettings.mPermissionTrees.get(p.info.name);
                }
                if (bp == null || bp.perm != p) continue;
                bp.perm = null;
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = (PackageParser.Instrumentation)pkg.instrumentation.get(i);
                this.mInstrumentation.remove(a.getComponentName());
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
        }
    }

    private static final boolean isPackageFilename(String name) {
        return name != null && name.endsWith(".apk");
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String perm) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!((PackageParser.Permission)pkgInfo.permissions.get((int)i)).info.name.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, boolean grantPermissions, boolean replace, boolean replaceAll) {
        BasePermission bp;
        Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
        while (it.hasNext()) {
            bp = it.next();
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w((String)TAG, (String)("Removing dangling permission tree: " + bp.name + " from package " + bp.sourcePackage));
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i((String)TAG, (String)("Removing old permission tree: " + bp.name + " from package " + bp.sourcePackage));
            grantPermissions = true;
            it.remove();
        }
        it = this.mSettings.mPermissions.values().iterator();
        while (it.hasNext()) {
            BasePermission tree;
            bp = it.next();
            if (bp.type == 2 && bp.packageSetting == null && bp.pendingInfo != null && (tree = this.findPermissionTreeLP(bp.name)) != null && tree.perm != null) {
                bp.packageSetting = tree.packageSetting;
                bp.perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(bp.pendingInfo));
                bp.perm.info.packageName = tree.perm.info.packageName;
                bp.perm.info.name = bp.name;
                bp.uid = tree.uid;
            }
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w((String)TAG, (String)("Removing dangling permission: " + bp.name + " from package " + bp.sourcePackage));
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i((String)TAG, (String)("Removing old permission: " + bp.name + " from package " + bp.sourcePackage));
            grantPermissions = true;
            it.remove();
        }
        if (grantPermissions) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                if (pkg == pkgInfo) continue;
                this.grantPermissionsLPw(pkg, replaceAll);
            }
        }
        if (pkgInfo != null) {
            this.grantPermissionsLPw(pkgInfo, replace);
        }
    }

    private void grantPermissionsLPw(PackageParser.Package pkg, boolean replace) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        boolean changedPermission = false;
        if (replace) {
            ps.permissionsFixed = false;
            if (gp == ps) {
                gp.grantedPermissions.clear();
                gp.gids = this.mGlobalGids;
            }
        }
        if (gp.gids == null) {
            gp.gids = this.mGlobalGids;
        }
        int N = pkg.requestedPermissions.size();
        for (int i = 0; i < N; ++i) {
            String name = (String)pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null && bp.packageSetting != null) {
                boolean allowed;
                String perm = bp.name;
                boolean allowedSig = false;
                if (bp.protectionLevel == 0 || bp.protectionLevel == 1) {
                    allowed = true;
                } else if (bp.packageSetting == null) {
                    allowed = false;
                } else if (bp.protectionLevel == 2 || bp.protectionLevel == 3) {
                    boolean bl = allowed = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 || PackageManagerService.compareSignatures(this.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
                    if (!allowed && bp.protectionLevel == 3 && PackageManagerService.isSystemApp(pkg)) {
                        if (PackageManagerService.isUpdatedSystemApp(pkg)) {
                            GrantedPermissions origGp;
                            PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                            GrantedPermissions grantedPermissions = origGp = sysPs.sharedUser != null ? sysPs.sharedUser : sysPs;
                            allowed = origGp.grantedPermissions.contains(perm);
                        } else {
                            allowed = true;
                        }
                    }
                    if (allowed) {
                        allowedSig = true;
                    }
                } else {
                    allowed = false;
                }
                if (allowed) {
                    if ((ps.pkgFlags & 1) == 0 && ps.permissionsFixed && !allowedSig && !gp.grantedPermissions.contains(perm)) {
                        allowed = false;
                        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
                            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
                            allowed = true;
                            Log.i((String)TAG, (String)("Auto-granting " + perm + " to old pkg " + pkg.packageName));
                            break;
                        }
                    }
                    if (allowed) {
                        if (!gp.grantedPermissions.contains(perm)) {
                            changedPermission = true;
                            gp.grantedPermissions.add(perm);
                            gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                            continue;
                        }
                        if (ps.haveGids) continue;
                        gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                        continue;
                    }
                    Slog.w((String)TAG, (String)("Not granting permission " + perm + " to package " + pkg.packageName + " because it was previously installed without"));
                    continue;
                }
                if (gp.grantedPermissions.remove(perm)) {
                    changedPermission = true;
                    gp.gids = PackageManagerService.removeInts(gp.gids, bp.gids);
                    Slog.i((String)TAG, (String)("Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")"));
                    continue;
                }
                Slog.w((String)TAG, (String)("Not granting permission " + perm + " to package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")"));
                continue;
            }
            Slog.w((String)TAG, (String)("Unknown permission " + name + " in package " + pkg.packageName));
        }
        if ((changedPermission || replace) && !ps.permissionsFixed && (ps.pkgFlags & 1) == 0 || (ps.pkgFlags & 0x80) != 0) {
            ps.permissionsFixed = true;
        }
        ps.haveGids = true;
    }

    static final void sendPackageBroadcast(String action, String pkg, Bundle extras, String targetPkg, IIntentReceiver finishedReceiver) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                Intent intent = new Intent(action, pkg != null ? Uri.fromParts((String)"package", (String)pkg, null) : null);
                if (extras != null) {
                    intent.putExtras(extras);
                }
                if (targetPkg != null) {
                    intent.setPackage(targetPkg);
                }
                intent.addFlags(0x10000000);
                am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, null, finishedReceiver != null, false);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextPackageToClean(String lastPackage) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return null;
            }
            if (lastPackage != null) {
                this.mSettings.mPackagesToBeCleaned.remove(lastPackage);
            }
            return this.mSettings.mPackagesToBeCleaned.size() > 0 ? this.mSettings.mPackagesToBeCleaned.get(0) : null;
        }
    }

    void schedulePackageCleaning(String packageName) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, packageName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaningPackages() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return;
            }
            if (this.mSettings.mPackagesToBeCleaned.size() <= 0) {
                return;
            }
        }
        Intent intent = new Intent("android.content.pm.CLEAN_EXTERNAL_STORAGE");
        intent.setComponent(DEFAULT_CONTAINER_COMPONENT);
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.startService(null, intent, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags) {
        this.installPackage(packageURI, observer, flags, null);
    }

    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName) {
        this.installPackageWithVerification(packageURI, observer, flags, installerPackageName, null, null);
    }

    public void installPackageWithVerification(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, Uri verificationURI, ManifestDigest manifestDigest) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int uid = Binder.getCallingUid();
        int filteredFlags = uid == 2000 || uid == 0 ? flags | 0x20 : flags & 0xFFFFFFDF;
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(packageURI, observer, filteredFlags, installerPackageName, verificationURI, manifestDigest);
        this.mHandler.sendMessage(msg);
    }

    public void verifyPendingInstall(int id, int verificationCode) throws RemoteException {
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSignatures.length != 1) {
                Slog.i((String)TAG, (String)("Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring"));
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSignatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i((String)TAG, (String)("Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring"));
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    public void finishPackageInstall(int token) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Message msg = this.mHandler.obtainMessage(9, token, 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Secure.getLong((ContentResolver)this.mContext.getContentResolver(), (String)"verifier_timeout", (long)60000L);
    }

    private boolean isVerificationEnabled() {
        return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"verifier_enable", (int)0) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            Object obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getUserIdLPr(uid)) == null) throw new SecurityException("Unknown calling uid " + uid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + uid);
                callerSignature = ((PackageSetting)obj).signatures.mSignatures;
            }
            if (installerPackageSetting != null && PackageManagerService.compareSignatures(callerSignature, installerPackageSetting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerService.compareSignatures(callerSignature, setting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    private void processPendingInstall(final InstallArgs args, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean doRestore;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageInstalledInfo res = new PackageInstalledInfo();
                res.returnCode = currentStatus;
                res.uid = -1;
                res.pkg = null;
                res.removedInfo = new PackageRemovedInfo();
                if (res.returnCode == 1) {
                    args.doPreInstall(res.returnCode);
                    Object object = PackageManagerService.this.mInstallLock;
                    synchronized (object) {
                        PackageManagerService.this.installPackageLI(args, true, res);
                    }
                    args.doPostInstall(res.returnCode);
                }
                boolean update = res.removedInfo.removedPackage != null;
                boolean bl = doRestore = !update && res.pkg != null && res.pkg.applicationInfo.backupAgentName != null;
                if (PackageManagerService.this.mNextInstallToken < 0) {
                    PackageManagerService.this.mNextInstallToken = 1;
                }
                int token = PackageManagerService.this.mNextInstallToken++;
                PostInstallData data = new PostInstallData(args, res);
                PackageManagerService.this.mRunningInstalls.put(token, (Object)data);
                if (res.returnCode == 1 && doRestore) {
                    IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
                    if (bm != null) {
                        try {
                            bm.restoreAtInstall(res.pkg.applicationInfo.packageName, token);
                        }
                        catch (RemoteException e) {
                        }
                        catch (Exception e) {
                            Slog.e((String)PackageManagerService.TAG, (String)"Exception trying to enqueue restore", (Throwable)e);
                            doRestore = false;
                        }
                    } else {
                        Slog.e((String)PackageManagerService.TAG, (String)"Backup Manager not found!");
                        doRestore = false;
                    }
                }
                if (!doRestore) {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(9, token, 0);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (PackageManagerService.installOnSd(params.flags)) {
            return new SdInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgs(int flags, String fullCodePath, String fullResourcePath, String nativeLibraryPath) {
        if (PackageManagerService.installOnSd(flags)) {
            return new SdInstallArgs(fullCodePath, fullResourcePath, nativeLibraryPath);
        }
        return new FileInstallArgs(fullCodePath, fullResourcePath, nativeLibraryPath);
    }

    private InstallArgs createInstallArgs(Uri packageURI, int flags, String pkgName, String dataDir) {
        if (PackageManagerService.installOnSd(flags)) {
            String cid = PackageManagerService.getNextCodePath(null, pkgName, "/pkg.apk");
            return new SdInstallArgs(packageURI, cid);
        }
        return new FileInstallArgs(packageURI, pkgName, dataDir);
    }

    static String cidFromCodePath(String fullCodePath) {
        int eidx = fullCodePath.lastIndexOf("/");
        String subStr1 = fullCodePath.substring(0, eidx);
        int sidx = subStr1.lastIndexOf("/");
        return subStr1.substring(sidx + 1, eidx);
    }

    private static String getNextCodePath(String oldCodePath, String prefix, String suffix) {
        String idxStr = "";
        int idx = 1;
        if (oldCodePath != null) {
            int sidx;
            String subStr = oldCodePath;
            if (subStr.endsWith(suffix)) {
                subStr = subStr.substring(0, subStr.length() - suffix.length());
            }
            if ((sidx = subStr.lastIndexOf(prefix)) != -1 && (subStr = subStr.substring(sidx + prefix.length())) != null) {
                if (subStr.startsWith(INSTALL_PACKAGE_SUFFIX)) {
                    subStr = subStr.substring(INSTALL_PACKAGE_SUFFIX.length());
                }
                try {
                    idx = Integer.parseInt(subStr);
                    idx = idx <= 1 ? ++idx : --idx;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        idxStr = INSTALL_PACKAGE_SUFFIX + Integer.toString(idx);
        return prefix + idxStr;
    }

    private static boolean ignoreCodePath(String fullPathStr) {
        String apkName = PackageManagerService.getApkName(fullPathStr);
        int idx = apkName.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx != -1 && idx + 1 < apkName.length()) {
            String version = apkName.substring(idx + 1);
            try {
                Integer.parseInt(version);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    static String getApkName(String codePath) {
        if (codePath == null) {
            return null;
        }
        int sidx = codePath.lastIndexOf("/");
        int eidx = codePath.lastIndexOf(".");
        if (eidx == -1) {
            eidx = codePath.length();
        } else if (eidx == 0) {
            Slog.w((String)TAG, (String)(" Invalid code path, " + codePath + " Not a valid apk name"));
            return null;
        }
        return codePath.substring(sidx + 1, eidx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNewPackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, String installerPackageName, PackageInstalledInfo res) {
        String pkgName = pkg.packageName;
        boolean dataDirExists = this.getDataPathForPackage(pkg.packageName, 0).exists();
        res.name = pkgName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.mRenamedPackages.containsKey(pkgName)) {
                Slog.w((String)TAG, (String)("Attempt to re-install " + pkgName + " without first uninstalling package running as " + this.mSettings.mRenamedPackages.get(pkgName)));
                res.returnCode = -1;
                return;
            }
            if (this.mPackages.containsKey(pkgName) || this.mAppDirs.containsKey(pkg.mPath)) {
                Slog.w((String)TAG, (String)("Attempt to re-install " + pkgName + " without first uninstalling."));
                res.returnCode = -1;
                return;
            }
        }
        this.mLastScanError = 1;
        PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanMode, System.currentTimeMillis());
        if (newPackage == null) {
            Slog.w((String)TAG, (String)("Package couldn't be installed in " + pkg.mPath));
            res.returnCode = this.mLastScanError;
            if (res.returnCode == 1) {
                res.returnCode = -2;
            }
        } else {
            this.updateSettingsLI(newPackage, installerPackageName, res);
            if (res.returnCode != 1) {
                this.deletePackageLI(pkgName, false, dataDirExists ? 1 : 0, res.removedInfo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replacePackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, String installerPackageName, PackageInstalledInfo res) {
        PackageParser.Package oldPackage;
        String pkgName = pkg.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPackage = this.mPackages.get(pkgName);
            if (PackageManagerService.compareSignatures(oldPackage.mSignatures, pkg.mSignatures) != 0) {
                res.returnCode = -104;
                return;
            }
        }
        boolean sysPkg = PackageManagerService.isSystemApp(oldPackage);
        if (sysPkg) {
            this.replaceSystemPackageLI(oldPackage, pkg, parseFlags, scanMode, installerPackageName, res);
        } else {
            this.replaceNonSystemPackageLI(oldPackage, pkg, parseFlags, scanMode, installerPackageName, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNonSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanMode, String installerPackageName, PackageInstalledInfo res) {
        PackageParser.Package newPackage = null;
        String pkgName = deletedPackage.packageName;
        boolean deletedPkg = true;
        boolean updatedSettings = false;
        long origUpdateTime = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
        if (!this.deletePackageLI(pkgName, true, 1, res.removedInfo, true)) {
            res.returnCode = -10;
            deletedPkg = false;
        } else {
            this.mLastScanError = 1;
            newPackage = this.scanPackageLI(pkg, parseFlags, scanMode | 0x40, System.currentTimeMillis());
            if (newPackage == null) {
                Slog.w((String)TAG, (String)("Package couldn't be installed in " + pkg.mPath));
                res.returnCode = this.mLastScanError;
                if (res.returnCode == 1) {
                    res.returnCode = -2;
                }
            } else {
                this.updateSettingsLI(newPackage, installerPackageName, res);
                updatedSettings = true;
            }
        }
        if (res.returnCode != 1) {
            if (updatedSettings) {
                this.deletePackageLI(pkgName, true, 1, res.removedInfo, true);
            }
            if (deletedPkg) {
                int oldScanMode;
                File restoreFile = new File(deletedPackage.mPath);
                if (restoreFile == null) {
                    Slog.e((String)TAG, (String)("Failed allocating storage when restoring pkg : " + pkgName));
                    return;
                }
                boolean oldOnSd = PackageManagerService.isExternal(deletedPackage);
                int oldParseFlags = this.mDefParseFlags | 2 | (PackageManagerService.isForwardLocked(deletedPackage) ? 16 : 0) | (oldOnSd ? 32 : 0);
                if (this.scanPackageLI(restoreFile, oldParseFlags, oldScanMode = (oldOnSd ? 0 : 1) | 8 | 0x40, origUpdateTime) == null) {
                    Slog.e((String)TAG, (String)("Failed to restore package : " + pkgName + " after failed upgrade"));
                    return;
                }
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    this.updatePermissionsLPw(deletedPackage.packageName, deletedPackage, true, false, false);
                    this.mSettings.writeLPr();
                }
                Slog.i((String)TAG, (String)("Successfully restored package : " + pkgName + " after failed upgrade"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanMode, String installerPackageName, PackageInstalledInfo res) {
        PackageSetting oldPkgSetting;
        PackageParser.Package oldPkg;
        PackageParser.Package newPackage = null;
        boolean updatedSettings = false;
        parseFlags |= 3;
        String packageName = deletedPackage.packageName;
        res.returnCode = -10;
        if (packageName == null) {
            Slog.w((String)TAG, (String)"Attempt to delete null packageName.");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPkg = this.mPackages.get(packageName);
            oldPkgSetting = this.mSettings.mPackages.get(packageName);
            if (oldPkg == null || oldPkg.applicationInfo == null || oldPkgSetting == null) {
                Slog.w((String)TAG, (String)("Couldn't find package:" + packageName + " information"));
                return;
            }
        }
        this.killApplication(packageName, oldPkg.applicationInfo.uid);
        res.removedInfo.uid = oldPkg.applicationInfo.uid;
        res.removedInfo.removedPackage = packageName;
        this.removePackageLI(oldPkg, true);
        hashMap = this.mPackages;
        synchronized (hashMap) {
            res.removedInfo.args = !this.mSettings.disableSystemPackageLPw(packageName) && deletedPackage != null ? this.createInstallArgs(PackageManagerService.isExternal(pkg) ? 8 : 16, deletedPackage.applicationInfo.sourceDir, deletedPackage.applicationInfo.publicSourceDir, deletedPackage.applicationInfo.nativeLibraryDir) : null;
        }
        this.mLastScanError = 1;
        pkg.applicationInfo.flags |= 0x80;
        newPackage = this.scanPackageLI(pkg, parseFlags, scanMode, 0L);
        if (newPackage == null) {
            Slog.w((String)TAG, (String)("Package couldn't be installed in " + pkg.mPath));
            res.returnCode = this.mLastScanError;
            if (res.returnCode == 1) {
                res.returnCode = -2;
            }
        } else {
            if (newPackage.mExtras != null) {
                PackageSetting newPkgSetting = (PackageSetting)newPackage.mExtras;
                newPkgSetting.firstInstallTime = oldPkgSetting.firstInstallTime;
                newPkgSetting.lastUpdateTime = System.currentTimeMillis();
            }
            this.updateSettingsLI(newPackage, installerPackageName, res);
            updatedSettings = true;
        }
        if (res.returnCode != 1) {
            if (newPackage != null) {
                this.removePackageLI(newPackage, true);
            }
            this.scanPackageLI(oldPkg, parseFlags, 9, 0L);
            hashMap = this.mPackages;
            synchronized (hashMap) {
                if (updatedSettings) {
                    this.mSettings.enableSystemPackageLPw(packageName);
                    this.mSettings.setInstallerPackageName(packageName, oldPkgSetting.installerPackageName);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    private int moveDexFilesLI(PackageParser.Package newPackage) {
        int retCode;
        if ((newPackage.applicationInfo.flags & 4) != 0 && (retCode = this.mInstaller.movedex(newPackage.mScanPath, newPackage.mPath)) != 0) {
            if (this.mNoDexOpt) {
                Slog.i((String)TAG, (String)("dex file doesn't exist, skipping move: " + newPackage.mPath));
            } else {
                Slog.e((String)TAG, (String)("Couldn't rename dex file: " + newPackage.mPath));
                return -4;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, PackageInstalledInfo res) {
        String pkgName = newPackage.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mSettings.setInstallStatus(pkgName, 0);
            this.mSettings.writeLPr();
        }
        res.returnCode = this.moveDexFilesLI(newPackage);
        if (res.returnCode != 1) {
            return;
        }
        res.returnCode = this.setPermissionsLI(newPackage);
        if (res.returnCode != 1) {
            this.mInstaller.rmdex(newPackage.mScanPath);
            return;
        }
        Log.d((String)TAG, (String)("New package installed in " + newPackage.mPath));
        hashMap = this.mPackages;
        synchronized (hashMap) {
            this.updatePermissionsLPw(newPackage.packageName, newPackage, newPackage.permissions.size() > 0, true, false);
            res.name = pkgName;
            res.uid = newPackage.applicationInfo.uid;
            res.pkg = newPackage;
            this.mSettings.setInstallStatus(pkgName, 1);
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.returnCode = 1;
            this.mSettings.writeLPr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPackageLI(InstallArgs args, boolean newInstall, PackageInstalledInfo res) {
        int pFlags = args.flags;
        String installerPackageName = args.installerPackageName;
        File tmpPackageFile = new File(args.getCodePath());
        boolean forwardLocked = (pFlags & 1) != 0;
        boolean onSd = (pFlags & 8) != 0;
        boolean replace = false;
        int scanMode = (onSd ? 0 : 1) | 4 | 8 | (newInstall ? 16 : 0);
        res.returnCode = 1;
        int parseFlags = 2 | (forwardLocked ? 16 : 0) | (onSd ? 32 : 0);
        PackageParser pp = new PackageParser(tmpPackageFile.getPath());
        pp.setSeparateProcesses(this.mSeparateProcesses);
        PackageParser.Package pkg = pp.parsePackage(tmpPackageFile, null, this.mMetrics, parseFlags |= this.mDefParseFlags);
        if (pkg == null) {
            res.returnCode = pp.getParseError();
            return;
        }
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (pFlags & 4) == 0) {
            res.returnCode = -15;
            return;
        }
        if (!pp.collectCertificates(pkg, parseFlags)) {
            res.returnCode = pp.getParseError();
            return;
        }
        if (args.manifestDigest != null && !args.manifestDigest.equals((Object)pkg.manifestDigest)) {
            res.returnCode = -23;
            return;
        }
        pp = null;
        String oldCodePath = null;
        boolean systemApp = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps;
            if ((pFlags & 2) != 0) {
                String oldName = this.mSettings.mRenamedPackages.get(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                oldCodePath = this.mSettings.mPackages.get((Object)pkgName).codePathString;
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
            }
        }
        if (systemApp && onSd) {
            Slog.w((String)TAG, (String)"Cannot install updates to system apps on sdcard");
            res.returnCode = -19;
            return;
        }
        if (!args.doRename(res.returnCode, pkgName, oldCodePath)) {
            res.returnCode = -4;
            return;
        }
        PackageManagerService.setApplicationInfoPaths(pkg, args.getCodePath(), args.getResourcePath());
        pkg.applicationInfo.nativeLibraryDir = args.getNativeLibraryPath();
        if (replace) {
            this.replacePackageLI(pkg, parseFlags, scanMode, installerPackageName, res);
        } else {
            this.installNewPackageLI(pkg, parseFlags, scanMode, installerPackageName, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setPermissionsLI(PackageParser.Package newPackage) {
        int retCode = 0;
        if (PackageManagerService.isForwardLocked(newPackage)) {
            File destResourceFile = new File(newPackage.applicationInfo.publicSourceDir);
            try {
                try {
                    this.extractPublicFiles(newPackage, destResourceFile);
                }
                catch (IOException e) {
                    Slog.e((String)TAG, (String)"Couldn't create a new zip file for the public parts of a forward-locked app.");
                    int n = -4;
                    Object var7_5 = null;
                    return n;
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                throw throwable;
            }
            retCode = this.mInstaller.setForwardLockPerm(PackageManagerService.getApkName(newPackage.mPath), newPackage.applicationInfo.uid);
        }
        if (retCode != 0) {
            Slog.e((String)TAG, (String)("Couldn't set new package file permissions for " + newPackage.mPath + ". The return code was: " + retCode));
            return -4;
        }
        return 1;
    }

    private static boolean isForwardLocked(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x20000000) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isSystemApp(ApplicationInfo info) {
        return (info.flags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x80) != 0;
    }

    private void extractPublicFiles(PackageParser.Package newPackage, File publicZipFile) throws IOException {
        FileOutputStream fstr = new FileOutputStream(publicZipFile);
        ZipOutputStream publicZipOutStream = new ZipOutputStream(fstr);
        ZipFile privateZip = new ZipFile(newPackage.mPath);
        Enumeration<? extends ZipEntry> privateZipEntries = privateZip.entries();
        while (privateZipEntries.hasMoreElements()) {
            ZipEntry zipEntry = privateZipEntries.nextElement();
            String zipEntryName = zipEntry.getName();
            if (!"AndroidManifest.xml".equals(zipEntryName) && !"resources.arsc".equals(zipEntryName) && !zipEntryName.startsWith("res/")) continue;
            try {
                PackageManagerService.copyZipEntry(zipEntry, privateZip, publicZipOutStream);
            }
            catch (IOException e) {
                try {
                    publicZipOutStream.close();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    publicZipFile.delete();
                    throw throwable;
                }
            }
        }
        publicZipOutStream.finish();
        publicZipOutStream.flush();
        FileUtils.sync((FileOutputStream)fstr);
        publicZipOutStream.close();
        FileUtils.setPermissions((String)publicZipFile.getAbsolutePath(), (int)420, (int)-1, (int)-1);
    }

    private static void copyZipEntry(ZipEntry zipEntry, ZipFile inZipFile, ZipOutputStream outZipStream) throws IOException {
        int num;
        byte[] buffer = new byte[4096];
        ZipEntry newEntry = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        outZipStream.putNextEntry(newEntry);
        InputStream data = inZipFile.getInputStream(zipEntry);
        while ((num = data.read(buffer)) > 0) {
            outZipStream.write(buffer, 0, num);
        }
        outZipStream.flush();
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("vmdl") && name.endsWith(".tmp");
            }
        };
        String[] tmpFilesList = this.mAppInstallDir.list(filter);
        if (tmpFilesList == null) {
            return;
        }
        for (int i = 0; i < tmpFilesList.length; ++i) {
            File tmpFile = new File(this.mAppInstallDir, tmpFilesList[i]);
            tmpFile.delete();
        }
    }

    private File createTempPackageFile(File installDir) {
        File tmpPackageFile;
        try {
            tmpPackageFile = File.createTempFile("vmdl", ".tmp", installDir);
        }
        catch (IOException e) {
            Slog.e((String)TAG, (String)"Couldn't create temp file for downloaded package file.");
            return null;
        }
        try {
            FileUtils.setPermissions((String)tmpPackageFile.getCanonicalPath(), (int)384, (int)-1, (int)-1);
        }
        catch (IOException e) {
            Slog.e((String)TAG, (String)"Trouble getting the canoncical path for a temp file.");
            return null;
        }
        return tmpPackageFile;
    }

    public void deletePackage(final String packageName, final IPackageDeleteObserver observer, final int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = PackageManagerService.this.deletePackageX(packageName, true, true, flags);
                if (observer != null) {
                    try {
                        observer.packageDeleted(packageName, returnCode);
                    }
                    catch (RemoteException e) {
                        Log.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deletePackageX(String packageName, boolean sendBroadCast, boolean deleteCodeAndResources, int flags) {
        boolean res;
        PackageRemovedInfo info = new PackageRemovedInfo();
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"device_policy"));
        try {
            if (dpm != null && dpm.packageHasActiveAdmins(packageName)) {
                Slog.w((String)TAG, (String)("Not removing package " + packageName + ": has active device admin"));
                return -2;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        Object e = this.mInstallLock;
        synchronized (e) {
            res = this.deletePackageLI(packageName, deleteCodeAndResources, flags | 0x10000, info, true);
        }
        if (res && sendBroadCast) {
            boolean systemUpdate = info.isRemovedPackageSystemUpdate;
            info.sendBroadcast(deleteCodeAndResources, systemUpdate);
            if (systemUpdate) {
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", info.removedUid >= 0 ? info.removedUid : info.uid);
                extras.putBoolean("android.intent.extra.REPLACING", true);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, packageName, null);
            }
        }
        Runtime.getRuntime().gc();
        if (info.args != null) {
            Object object = this.mInstallLock;
            synchronized (object) {
                info.args.doPostDeleteLI(deleteCodeAndResources);
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLI(PackageParser.Package p, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        PackageSetting deletedPs;
        String packageName = p.packageName;
        if (outInfo != null) {
            outInfo.removedPackage = packageName;
        }
        this.removePackageLI(p, (flags & 0x10000) != 0);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            deletedPs = this.mSettings.mPackages.get(packageName);
        }
        if ((flags & 1) == 0) {
            int retCode = this.mInstaller.remove(packageName, 0);
            if (retCode < 0) {
                Slog.w((String)TAG, (String)("Couldn't remove app data or cache directory for package: " + packageName + ", retcode=" + retCode));
            } else {
                this.mUserManager.removePackageForAllUsers(packageName);
            }
            this.schedulePackageCleaning(packageName);
        }
        HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            if (deletedPs != null) {
                if ((flags & 1) == 0) {
                    if (outInfo != null) {
                        outInfo.removedUid = this.mSettings.removePackageLPw(packageName);
                    }
                    if (deletedPs != null) {
                        this.updatePermissionsLPw(deletedPs.name, null, false, false, false);
                        if (deletedPs.sharedUser != null) {
                            this.mSettings.updateSharedUserPermsLPw(deletedPs, this.mGlobalGids);
                        }
                    }
                }
                ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
                for (PreferredActivity pa : this.mSettings.mPreferredActivities.filterSet()) {
                    if (!pa.mPref.mComponent.getPackageName().equals(deletedPs.name)) continue;
                    removed.add(pa);
                }
                for (PreferredActivity pa : removed) {
                    this.mSettings.mPreferredActivities.removeFilter(pa);
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSystemPackageLI(PackageParser.Package p, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w((String)TAG, (String)("Package " + p.packageName + " has no applicationInfo."));
            return false;
        }
        PackageSetting ps = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ps = this.mSettings.getDisabledSystemPkgLPr(p.packageName);
        }
        if (ps == null) {
            Slog.w((String)TAG, (String)("Attempt to delete unknown system package " + p.packageName));
            return false;
        }
        Log.i((String)TAG, (String)"Deleting system pkg from data partition");
        outInfo.isRemovedPackageSystemUpdate = true;
        flags = ps.versionCode < p.mVersionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        boolean ret = this.deleteInstalledPackageLI(p, true, flags, outInfo, writeSettings);
        if (!ret) {
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            this.mSettings.enableSystemPackageLPw(p.packageName);
            NativeLibraryHelper.removeNativeBinariesLI((String)p.applicationInfo.nativeLibraryDir);
        }
        PackageParser.Package newPkg = this.scanPackageLI(ps.codePath, 5, 33, 0L);
        if (newPkg == null) {
            Slog.w((String)TAG, (String)("Failed to restore system package:" + p.packageName + " with error:" + this.mLastScanError));
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap3 = this.mPackages;
        synchronized (hashMap3) {
            this.updatePermissionsLPw(newPkg.packageName, newPkg, true, true, false);
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return true;
    }

    private boolean deleteInstalledPackageLI(PackageParser.Package p, boolean deleteCodeAndResources, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w((String)TAG, (String)("Package " + p.packageName + " has no applicationInfo."));
            return false;
        }
        if (outInfo != null) {
            outInfo.uid = applicationInfo.uid;
        }
        this.removePackageDataLI(p, outInfo, flags, writeSettings);
        if (deleteCodeAndResources) {
            int installFlags = PackageManagerService.isExternal(p) ? 8 : 0;
            outInfo.args = this.createInstallArgs(installFlags |= PackageManagerService.isForwardLocked(p) ? 1 : 0, applicationInfo.sourceDir, applicationInfo.publicSourceDir, applicationInfo.nativeLibraryDir);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLI(String packageName, boolean deleteCodeAndResources, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w((String)TAG, (String)"Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            p = this.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
                    return false;
                }
                p = ps.pkg;
            }
        }
        if (p == null) {
            Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
            return false;
        }
        if (dataOnly) {
            this.removePackageDataLI(p, outInfo, flags, writeSettings);
            return true;
        }
        if (p.applicationInfo == null) {
            Slog.w((String)TAG, (String)("Package " + p.packageName + " has no applicationInfo."));
            return false;
        }
        boolean ret = false;
        if (PackageManagerService.isSystemApp(p)) {
            Log.i((String)TAG, (String)("Removing system package:" + p.packageName));
            ret = this.deleteSystemPackageLI(p, flags, outInfo, writeSettings);
        } else {
            Log.i((String)TAG, (String)("Removing non-system package:" + p.packageName));
            this.killApplication(packageName, p.applicationInfo.uid);
            ret = this.deleteInstalledPackageLI(p, deleteCodeAndResources, flags, outInfo, writeSettings);
        }
        return ret;
    }

    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DeviceStorageMonitorService dsm;
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeeded = PackageManagerService.this.clearApplicationUserDataLI(packageName);
                }
                if (succeeded && (dsm = (DeviceStorageMonitorService)ServiceManager.getService((String)"devicestoragemonitor")) != null) {
                    dsm.updateMemory();
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLI(String packageName) {
        int retCode;
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w((String)TAG, (String)"Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            p = this.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null || ps.pkg == null) {
                    Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
                    return false;
                }
                p = ps.pkg;
            }
        }
        if (!dataOnly) {
            if (p == null) {
                Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
                return false;
            }
            ApplicationInfo applicationInfo = p.applicationInfo;
            if (applicationInfo == null) {
                Slog.w((String)TAG, (String)("Package " + packageName + " has no applicationInfo."));
                return false;
            }
        }
        if ((retCode = this.mInstaller.clearUserData(packageName, 0)) < 0) {
            Slog.w((String)TAG, (String)("Couldn't remove cache files for package: " + packageName));
            return false;
        }
        return true;
    }

    public void deleteApplicationCacheFiles(final String packageName, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean succeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeded = PackageManagerService.this.deleteApplicationCacheFilesLI(packageName);
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeded);
                    }
                    catch (RemoteException e) {
                        Log.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteApplicationCacheFilesLI(String packageName) {
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w((String)TAG, (String)"Attempt to delete null packageName.");
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            p = this.mPackages.get(packageName);
        }
        if (p == null) {
            Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
            return false;
        }
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w((String)TAG, (String)("Package " + packageName + " has no applicationInfo."));
            return false;
        }
        int retCode = this.mInstaller.deleteCacheFiles(packageName);
        if (retCode < 0) {
            Slog.w((String)TAG, (String)("Couldn't remove cache files for package: " + packageName));
            return false;
        }
        return true;
    }

    public void getPackageSizeInfo(final String packageName, final IPackageStatsObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GET_PACKAGE_SIZE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean success;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageStats stats = new PackageStats(packageName);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    success = PackageManagerService.this.getPackageSizeInfoLI(packageName, stats);
                }
                Message msg = PackageManagerService.this.mHandler.obtainMessage(5);
                msg.obj = new MeasureParams(stats, success, observer);
                PackageManagerService.this.mHandler.sendMessage(msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPackageSizeInfoLI(String packageName, PackageStats pStats) {
        int res;
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w((String)TAG, (String)"Attempt to get size of null packageName.");
            return false;
        }
        boolean dataOnly = false;
        String asecPath = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String secureContainerId;
            p = this.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null || ps.pkg == null) {
                    Slog.w((String)TAG, (String)("Package named '" + packageName + "' doesn't exist."));
                    return false;
                }
                p = ps.pkg;
            }
            if (p != null && PackageManagerService.isExternal(p) && (secureContainerId = PackageManagerService.cidFromCodePath(p.applicationInfo.sourceDir)) != null) {
                asecPath = PackageHelper.getSdFilesystem((String)secureContainerId);
            }
        }
        String publicSrcDir = null;
        if (!dataOnly) {
            ApplicationInfo applicationInfo = p.applicationInfo;
            if (applicationInfo == null) {
                Slog.w((String)TAG, (String)("Package " + packageName + " has no applicationInfo."));
                return false;
            }
            if (PackageManagerService.isForwardLocked(p)) {
                publicSrcDir = applicationInfo.publicSourceDir;
            }
        }
        return (res = this.mInstaller.getSizeInfo(packageName, p.mPath, publicSrcDir, asecPath, pStats)) >= 0;
    }

    public void addPackageToPreferred(String packageName) {
        Slog.w((String)TAG, (String)"addPackageToPreferred: this is now a no-op");
    }

    public void removePackageFromPreferred(String packageName) {
        Slog.w((String)TAG, (String)"removePackageFromPreferred: this is now a no-op");
    }

    public List<PackageInfo> getPreferredPackages(int flags) {
        return new ArrayList<PackageInfo>();
    }

    private int getUidTargetSdkVersionLockedLPr(int uid) {
        Object obj = this.mSettings.getUserIdLPr(uid);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w((String)TAG, (String)("Ignoring addPreferredActivity() from uid " + Binder.getCallingUid()));
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            Slog.i((String)TAG, (String)("Adding preferred activity " + activity + ":"));
            filter.dump((Printer)new LogPrinter(4, TAG), "  ");
            this.mSettings.mPreferredActivities.addFilter(new PreferredActivity(filter, match, set, activity));
            this.scheduleWriteSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countCategories() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 category.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() != 0 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, schemes or types.");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w((String)TAG, (String)("Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid()));
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            Iterator<PreferredActivity> it = this.mSettings.mPreferredActivities.filterIterator();
            String action = filter.getAction(0);
            String category = filter.getCategory(0);
            while (it.hasNext()) {
                PreferredActivity pa = it.next();
                if (!pa.getAction(0).equals(action) || !pa.getCategory(0).equals(category)) continue;
                it.remove();
                Log.i((String)TAG, (String)("Removed preferred activity " + pa.mPref.mComponent + ":"));
                filter.dump((Printer)new LogPrinter(4, TAG), "  ");
            }
            this.addPreferredActivity(filter, match, set, activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPackagePreferredActivities(String packageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if ((pkg == null || pkg.applicationInfo.uid != uid) && this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w((String)TAG, (String)("Ignoring clearPackagePreferredActivities() from uid " + Binder.getCallingUid()));
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if (this.clearPackagePreferredActivitiesLPw(packageName)) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    boolean clearPackagePreferredActivitiesLPw(String packageName) {
        boolean changed = false;
        Iterator<PreferredActivity> it = this.mSettings.mPreferredActivities.filterIterator();
        while (it.hasNext()) {
            PreferredActivity pa = it.next();
            if (!pa.mPref.mComponent.getPackageName().equals(packageName)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        int num = 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Iterator<PreferredActivity> it = this.mSettings.mPreferredActivities.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = it.next();
                if (packageName != null && !pa.mPref.mComponent.getPackageName().equals(packageName)) continue;
                if (outFilters != null) {
                    outFilters.add(new IntentFilter((IntentFilter)pa));
                }
                if (outActivities == null) continue;
                outActivities.add(pa.mPref.mComponent);
            }
        }
        return num;
    }

    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags) {
        this.setEnabledSetting(appPackageName, null, newState, flags);
    }

    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags) {
        ArrayList<String> components;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int uid = Binder.getCallingUid();
        int permission = this.mContext.checkCallingPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        String componentName = isApp ? packageName : className;
        int packageUid = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            boolean newPackage;
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (className == null) {
                    throw new IllegalArgumentException("Unknown package: " + packageName);
                }
                throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
            }
            if (!allowedByPermission && uid != pkgSetting.userId) {
                throw new SecurityException("Permission Denial: attempt to change component state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.userId);
            }
            if (className == null) {
                if (pkgSetting.enabled == newState) {
                    return;
                }
                pkgSetting.enabled = newState;
                pkgSetting.pkg.mSetEnabled = newState;
            } else {
                switch (newState) {
                    case 1: {
                        if (pkgSetting.enableComponentLPw(className)) break;
                        return;
                    }
                    case 2: {
                        if (pkgSetting.disableComponentLPw(className)) break;
                        return;
                    }
                    case 0: {
                        if (pkgSetting.restoreComponentLPw(className)) break;
                        return;
                    }
                    default: {
                        Slog.e((String)TAG, (String)("Invalid new component state: " + newState));
                        return;
                    }
                }
            }
            this.mSettings.writeLPr();
            packageUid = pkgSetting.userId;
            components = this.mPendingBroadcasts.get(packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            Binder.restoreCallingIdentity((long)callingId);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)callingId);
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageStoppedState(String packageName, boolean stopped) {
        int uid = Binder.getCallingUid();
        int permission = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission == 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.setPackageStoppedStateLPw(packageName, stopped, allowedByPermission, uid)) {
                this.scheduleWriteStoppedPackagesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstallerPackageName(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApplicationEnabledSetting(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getApplicationEnabledSettingLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getComponentEnabledSetting(ComponentName componentName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getComponentEnabledSettingLPr(componentName);
        }
    }

    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    public void systemReady() {
        this.mSystemReady = true;
        boolean compatibilityModeEnabled = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"compatibility_mode", (int)1) == 1;
        PackageParser.setCompatibilityModeEnabled((boolean)compatibilityModeEnabled);
    }

    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(array[i]);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        DumpState dumpState = new DumpState();
        String packageName = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [cmd] ...");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("  cmd may be one of:");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[ibraries]: list device features");
                pw.println("    r[esolvers]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    <package.name>: info about given package");
                return;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("android".equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
            } else if ("l".equals(cmd) || "libraries".equals(cmd)) {
                dumpState.setDump(1);
            } else if ("f".equals(cmd) || "features".equals(cmd)) {
                dumpState.setDump(2);
            } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                dumpState.setDump(4);
            } else if ("perm".equals(cmd) || "permissions".equals(cmd)) {
                dumpState.setDump(8);
            } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                dumpState.setDump(16);
            } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                dumpState.setDump(32);
            } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                dumpState.setDump(128);
            } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                dumpState.setDump(64);
            } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                dumpState.setDump(256);
            }
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            block64: {
                if (dumpState.isDumping(256) && packageName == null) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println(" ");
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage));
                    pw.println(")");
                }
                if (dumpState.isDumping(1) && packageName == null) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println(" ");
                    }
                    pw.println("Libraries:");
                    for (String name : this.mSharedLibraries.keySet()) {
                        pw.print("  ");
                        pw.print(name);
                        pw.print(" -> ");
                        pw.println(this.mSharedLibraries.get(name));
                    }
                }
                if (dumpState.isDumping(2) && packageName == null) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println(" ");
                    }
                    pw.println("Features:");
                    for (String name : this.mAvailableFeatures.keySet()) {
                        pw.print("  ");
                        pw.println(name);
                    }
                }
                if (dumpState.isDumping(4)) {
                    if (this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mSettings.mPreferredActivities.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities:" : "Preferred Activities:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                }
                if (dumpState.isDumping(8)) {
                    this.mSettings.dumpPermissionsLPr(pw, packageName, dumpState);
                }
                if (dumpState.isDumping(128)) {
                    boolean printedSomething = false;
                    for (PackageParser.Provider provider : this.mProvidersByComponent.values()) {
                        if (packageName != null && !packageName.equals(provider.info.packageName)) continue;
                        if (!printedSomething) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println(" ");
                            }
                            pw.println("Registered ContentProviders:");
                            printedSomething = true;
                        }
                        pw.print("  ");
                        pw.print(provider.getComponentShortName());
                        pw.println(":");
                        pw.print("    ");
                        pw.println(provider.toString());
                    }
                    printedSomething = false;
                    for (Map.Entry entry : this.mProviders.entrySet()) {
                        PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
                        if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                        if (!printedSomething) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println(" ");
                            }
                            pw.println("ContentProvider Authorities:");
                            printedSomething = true;
                        }
                        pw.print("  [");
                        pw.print((String)entry.getKey());
                        pw.println("]:");
                        pw.print("    ");
                        pw.println(p.toString());
                    }
                }
                if (dumpState.isDumping(16)) {
                    this.mSettings.dumpPackagesLPr(pw, packageName, dumpState);
                }
                if (dumpState.isDumping(32)) {
                    this.mSettings.dumpSharedUsersLPr(pw, packageName, dumpState);
                }
                if (!dumpState.isDumping(64) || packageName != null) return;
                if (dumpState.onTitlePrinted()) {
                    pw.println(" ");
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println(" ");
                pw.println("Package warning messages:");
                File fname = PackageManagerService.getSettingsProblemFile();
                FileInputStream in = null;
                in = new FileInputStream(fname);
                int n = in.available();
                byte[] data = new byte[n];
                in.read(data);
                pw.print(new String(data));
                Object var13_19 = null;
                if (in == null) return;
                try {
                    in.close();
                }
                catch (IOException e) {}
                {
                    break block64;
                    catch (FileNotFoundException fileNotFoundException) {
                        Object var13_20 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                        break block64;
                    }
                    catch (IOException iOException) {
                        Object var13_21 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    private String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e((String)TAG, (String)"Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e((String)TAG, (String)("Failed to create encryption keys with exception: " + nsae));
            return null;
        }
        catch (IOException ioe) {
            Slog.e((String)TAG, (String)("Failed to retrieve encryption keys with exception: " + ioe));
            return null;
        }
    }

    static String getTempContainerId() {
        int tmpIdx = 1;
        String[] list = PackageHelper.getSecureContainerList();
        if (list != null) {
            for (String name : list) {
                if (name == null || !name.startsWith(mTempContainerPrefix)) continue;
                String subStr = name.substring(mTempContainerPrefix.length());
                try {
                    int cid = Integer.parseInt(subStr);
                    if (cid < tmpIdx) continue;
                    tmpIdx = cid + 1;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return mTempContainerPrefix + tmpIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExternalMediaStatus(final boolean mediaStatus, final boolean reportStatus) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Media status can only be updated by the system");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Log.i((String)TAG, (String)("Updating external media status from " + (this.mMediaMounted ? "mounted" : "unmounted") + " to " + (mediaStatus ? "mounted" : "unmounted")));
            if (mediaStatus == this.mMediaMounted) {
                Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1);
                this.mHandler.sendMessage(msg);
                return;
            }
            this.mMediaMounted = mediaStatus;
        }
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageManagerService.this.updateExternalMediaStatusInner(mediaStatus, reportStatus);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalMediaStatusInner(boolean mediaStatus, boolean reportStatus) {
        int[] uidArr = null;
        HashSet<String> removeCids = new HashSet<String>();
        HashMap<SdInstallArgs, String> processCids = new HashMap<SdInstallArgs, String>();
        String[] list = PackageHelper.getSecureContainerList();
        if (list == null || list.length == 0) {
            Log.i((String)TAG, (String)"No secure containers on sdcard");
        } else {
            int[] uidList = new int[list.length];
            int num = 0;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                for (String cid : list) {
                    SdInstallArgs args = new SdInstallArgs(cid);
                    String pkgName = args.getPackageName();
                    if (pkgName == null) {
                        removeCids.add(cid);
                        continue;
                    }
                    PackageSetting ps = this.mSettings.mPackages.get(pkgName);
                    if (ps != null && ps.codePathString != null && ps.codePathString.equals(args.getCodePath())) {
                        processCids.put(args, ps.codePathString);
                        int uid = ps.userId;
                        if (uid == -1) continue;
                        uidList[num++] = uid;
                        continue;
                    }
                    removeCids.add(cid);
                }
            }
            if (num > 0) {
                Arrays.sort(uidList, 0, num);
                uidArr = new int[num];
                uidArr[0] = uidList[0];
                int di = 0;
                for (int i = 1; i < num; ++i) {
                    if (uidList[i - 1] == uidList[i]) continue;
                    uidArr[di++] = uidList[i];
                }
            }
        }
        if (mediaStatus) {
            this.loadMediaPackages(processCids, uidArr, removeCids);
            this.startCleaningPackages();
        } else {
            this.unloadMediaPackages(processCids, uidArr, reportStatus);
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.size();
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList.toArray(new String[size]));
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            PackageManagerService.sendPackageBroadcast(action, null, extras, null, finishedReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void loadMediaPackages(HashMap<SdInstallArgs, String> processCids, int[] uidArr, HashSet<String> removeCids) {
        boolean regrantPermissions;
        ArrayList<String> pkgList = new ArrayList<String>();
        Set<SdInstallArgs> keys = processCids.keySet();
        boolean doGc = false;
        for (SdInstallArgs args : keys) {
            Object var18_17;
            String codePath = processCids.get(args);
            int retCode = -18;
            try {
                if (args.doPreInstall(1) != 1) {
                    Slog.e((String)TAG, (String)("Failed to mount cid : " + args.cid + " when installing from sdcard"));
                    var18_17 = null;
                    if (retCode == 1) continue;
                    removeCids.add(args.cid);
                    continue;
                }
                if (codePath == null || !codePath.equals(args.getCodePath())) {
                    Slog.e((String)TAG, (String)("Container " + args.cid + " cachepath " + args.getCodePath() + " does not match one in settings " + codePath));
                    var18_17 = null;
                    if (retCode == 1) continue;
                    removeCids.add(args.cid);
                    continue;
                }
                int parseFlags = 0x20 | this.mDefParseFlags;
                doGc = true;
                Object object = this.mInstallLock;
                // MONITORENTER : object
                PackageParser.Package pkg = this.scanPackageLI(new File(codePath), parseFlags, 0, 0L);
                if (pkg != null) {
                    HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                    // MONITORENTER : hashMap
                    retCode = 1;
                    pkgList.add(pkg.packageName);
                    args.doPostInstall(1);
                    // MONITOREXIT : hashMap
                } else {
                    Slog.i((String)TAG, (String)("Failed to install pkg from  " + codePath + " from sdcard"));
                }
                // MONITOREXIT : object
                var18_17 = null;
                if (retCode == 1) continue;
                removeCids.add(args.cid);
            }
            catch (Throwable throwable) {
                var18_17 = null;
                if (retCode == 1) throw throwable;
                removeCids.add(args.cid);
                throw throwable;
            }
        }
        Iterator<String> i$ = this.mPackages;
        // MONITORENTER : i$
        boolean bl = regrantPermissions = this.mSettings.mExternalSdkPlatform != this.mSdkVersion;
        if (regrantPermissions) {
            Slog.i((String)TAG, (String)("Platform changed from " + this.mSettings.mExternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for external storage"));
        }
        this.mSettings.mExternalSdkPlatform = this.mSdkVersion;
        this.updatePermissionsLPw(null, null, true, regrantPermissions, regrantPermissions);
        this.mSettings.writeLPr();
        // MONITOREXIT : i$
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(true, pkgList, uidArr, null);
        }
        if (doGc) {
            Runtime.getRuntime().gc();
        }
        if (removeCids == null) return;
        i$ = removeCids.iterator();
        while (i$.hasNext()) {
            String cid = i$.next();
            if (cid.startsWith(mTempContainerPrefix)) {
                Log.i((String)TAG, (String)("Destroying stale temporary container " + cid));
                PackageHelper.destroySdDir((String)cid);
                continue;
            }
            Log.w((String)TAG, (String)("Container " + cid + " is stale"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllContainers(Set<SdInstallArgs> cidArgs) {
        for (SdInstallArgs arg : cidArgs) {
            Object object = this.mInstallLock;
            synchronized (object) {
                arg.doPostDeleteLI(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadMediaPackages(HashMap<SdInstallArgs, String> processCids, int[] uidArr, final boolean reportStatus) {
        ArrayList<String> pkgList = new ArrayList<String>();
        ArrayList<SdInstallArgs> failedList = new ArrayList<SdInstallArgs>();
        final Set<SdInstallArgs> keys = processCids.keySet();
        for (SdInstallArgs args : keys) {
            String pkgName = args.getPackageName();
            PackageRemovedInfo outInfo = new PackageRemovedInfo();
            Object object = this.mInstallLock;
            synchronized (object) {
                boolean res = this.deletePackageLI(pkgName, false, 1, outInfo, false);
                if (res) {
                    pkgList.add(pkgName);
                } else {
                    Slog.e((String)TAG, (String)("Failed to delete pkg from sdcard : " + pkgName));
                    failedList.add(args);
                }
            }
        }
        HashMap<String, PackageParser.Package> i$ = this.mPackages;
        synchronized (i$) {
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(false, pkgList, uidArr, (IIntentReceiver)new IIntentReceiver.Stub(){

                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky) throws RemoteException {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, 1, keys);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            });
        } else {
            Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1, keys);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePackage(String packageName, IPackageMoveObserver observer, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        int returnCode = 1;
        int currFlags = 0;
        int newFlags = 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                returnCode = -2;
            } else if (pkg.applicationInfo != null && PackageManagerService.isSystemApp(pkg)) {
                Slog.w((String)TAG, (String)"Cannot move system application");
                returnCode = -3;
            } else if (pkg.applicationInfo != null && PackageManagerService.isForwardLocked(pkg)) {
                Slog.w((String)TAG, (String)"Cannot move forward locked app.");
                returnCode = -4;
            } else if (pkg.mOperationPending) {
                Slog.w((String)TAG, (String)"Attempt to move package which has pending operations");
                returnCode = -7;
            } else {
                if ((flags & 2) != 0 && (flags & 1) != 0) {
                    Slog.w((String)TAG, (String)"Ambigous flags specified for move location.");
                    returnCode = -5;
                } else {
                    newFlags = (flags & 2) != 0 ? 8 : 16;
                    int n = currFlags = PackageManagerService.isExternal(pkg) ? 8 : 16;
                    if (newFlags == currFlags) {
                        Slog.w((String)TAG, (String)"No move required. Trying to move to same location");
                        returnCode = -5;
                    }
                }
                if (returnCode == 1) {
                    pkg.mOperationPending = true;
                }
            }
            if (returnCode != 1) {
                this.processPendingMove(new MoveParams(null, observer, 0, packageName, null), returnCode);
            } else {
                Message msg = this.mHandler.obtainMessage(5);
                InstallArgs srcArgs = this.createInstallArgs(currFlags, pkg.applicationInfo.sourceDir, pkg.applicationInfo.publicSourceDir, pkg.applicationInfo.nativeLibraryDir);
                MoveParams mp = new MoveParams(srcArgs, observer, newFlags, packageName, pkg.applicationInfo.dataDir);
                msg.obj = mp;
                this.mHandler.sendMessage(msg);
            }
        }
    }

    private void processPendingMove(final MoveParams mp, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IPackageMoveObserver observer;
                Object uidArr;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = currentStatus;
                if (currentStatus == 1) {
                    uidArr = null;
                    ArrayList<String> pkgList = null;
                    Object object = PackageManagerService.this.mPackages;
                    synchronized (object) {
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                        if (pkg == null) {
                            Slog.w((String)PackageManagerService.TAG, (String)(" Package " + mp.packageName + " doesn't exist. Aborting move"));
                            returnCode = -2;
                        } else if (!mp.srcArgs.getCodePath().equals(pkg.applicationInfo.sourceDir)) {
                            Slog.w((String)PackageManagerService.TAG, (String)("Package " + mp.packageName + " code path changed from " + mp.srcArgs.getCodePath() + " to " + pkg.applicationInfo.sourceDir + " Aborting move and returning error"));
                            returnCode = -6;
                        } else {
                            uidArr = new int[]{pkg.applicationInfo.uid};
                            pkgList = new ArrayList<String>();
                            pkgList.add(mp.packageName);
                        }
                    }
                    if (returnCode == 1) {
                        PackageManagerService.this.sendResourcesChangedBroadcast(false, pkgList, (int[])uidArr, null);
                        object = PackageManagerService.this.mInstallLock;
                        synchronized (object) {
                            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                            synchronized (hashMap) {
                                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                                if (pkg == null) {
                                    Slog.w((String)PackageManagerService.TAG, (String)(" Package " + mp.packageName + " doesn't exist. Aborting move"));
                                    returnCode = -2;
                                } else if (!mp.srcArgs.getCodePath().equals(pkg.applicationInfo.sourceDir)) {
                                    Slog.w((String)PackageManagerService.TAG, (String)("Package " + mp.packageName + " code path changed from " + mp.srcArgs.getCodePath() + " to " + pkg.applicationInfo.sourceDir + " Aborting move and returning error"));
                                    returnCode = -6;
                                } else {
                                    String oldCodePath = pkg.mPath;
                                    String newCodePath = mp.targetArgs.getCodePath();
                                    String newResPath = mp.targetArgs.getResourcePath();
                                    String newNativePath = mp.targetArgs.getNativeLibraryPath();
                                    if ((mp.flags & 8) == 0) {
                                        if (PackageManagerService.this.mInstaller.unlinkNativeLibraryDirectory(pkg.applicationInfo.dataDir) < 0) {
                                            returnCode = -1;
                                        } else {
                                            NativeLibraryHelper.copyNativeBinariesIfNeededLI((File)new File(newCodePath), (File)new File(newNativePath));
                                        }
                                    } else if (PackageManagerService.this.mInstaller.linkNativeLibraryDirectory(pkg.applicationInfo.dataDir, newNativePath) < 0) {
                                        returnCode = -1;
                                    }
                                    if (returnCode == 1) {
                                        pkg.mPath = newCodePath;
                                        if (PackageManagerService.this.moveDexFilesLI(pkg) != 1) {
                                            pkg.mPath = pkg.mScanPath;
                                            returnCode = -1;
                                        }
                                    }
                                    if (returnCode == 1) {
                                        pkg.mScanPath = newCodePath;
                                        pkg.applicationInfo.sourceDir = newCodePath;
                                        pkg.applicationInfo.publicSourceDir = newResPath;
                                        pkg.applicationInfo.nativeLibraryDir = newNativePath;
                                        PackageSetting ps = (PackageSetting)pkg.mExtras;
                                        ps.codePath = new File(pkg.applicationInfo.sourceDir);
                                        ps.codePathString = ps.codePath.getPath();
                                        ps.resourcePath = new File(pkg.applicationInfo.publicSourceDir);
                                        ps.resourcePathString = ps.resourcePath.getPath();
                                        ps.nativeLibraryPathString = newNativePath;
                                        pkg.applicationInfo.flags = (mp.flags & 8) != 0 ? (pkg.applicationInfo.flags |= 0x40000) : (pkg.applicationInfo.flags &= 0xFFFBFFFF);
                                        ps.setFlags(pkg.applicationInfo.flags);
                                        PackageManagerService.this.mAppDirs.remove(oldCodePath);
                                        PackageManagerService.this.mAppDirs.put(newCodePath, pkg);
                                        PackageManagerService.this.mSettings.writeLPr();
                                    }
                                }
                            }
                        }
                        PackageManagerService.this.sendResourcesChangedBroadcast(true, pkgList, (int[])uidArr, null);
                    }
                }
                if (returnCode != 1) {
                    if (mp.targetArgs != null) {
                        mp.targetArgs.doPostInstall(-110);
                    }
                } else {
                    Runtime.getRuntime().gc();
                    uidArr = PackageManagerService.this.mInstallLock;
                    synchronized (uidArr) {
                        mp.srcArgs.doPostDeleteLI(true);
                    }
                }
                if (returnCode != -7) {
                    uidArr = PackageManagerService.this.mPackages;
                    synchronized (uidArr) {
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                        if (pkg != null) {
                            pkg.mOperationPending = false;
                        }
                    }
                }
                if ((observer = mp.observer) != null) {
                    try {
                        observer.packageMoved(mp.packageName, returnCode);
                    }
                    catch (RemoteException e) {
                        Log.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                    }
                }
            }
        });
    }

    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"default_install_location", (int)loc);
            return true;
        }
        return false;
    }

    public int getInstallLocation() {
        return Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"default_install_location", (int)0);
    }

    public UserInfo createUser(String name, int flags) {
        PackageManagerService.enforceSystemOrRoot("Only the system can create users");
        UserInfo userInfo = this.mUserManager.createUser(name, flags, new ArrayList<ApplicationInfo>());
        return userInfo;
    }

    public boolean removeUser(int userId) {
        PackageManagerService.enforceSystemOrRoot("Only the system can remove users");
        if (userId == 0) {
            return false;
        }
        this.mUserManager.removeUser(userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    static class DumpState {
        public static final int DUMP_LIBS = 1;
        public static final int DUMP_FEATURES = 2;
        public static final int DUMP_RESOLVERS = 4;
        public static final int DUMP_PERMISSIONS = 8;
        public static final int DUMP_PACKAGES = 16;
        public static final int DUMP_SHARED_USERS = 32;
        public static final int DUMP_MESSAGES = 64;
        public static final int DUMP_PROVIDERS = 128;
        public static final int DUMP_VERIFIERS = 256;
        public static final int OPTION_SHOW_FILTERS = 1;
        private int mTypes;
        private int mOptions;
        private boolean mTitlePrinted;
        private SharedUserSetting mSharedUser;

        DumpState() {
        }

        public boolean isDumping(int type) {
            if (this.mTypes == 0) {
                return true;
            }
            return (this.mTypes & type) != 0;
        }

        public void setDump(int type) {
            this.mTypes |= type;
        }

        public boolean isOptionEnabled(int option) {
            return (this.mOptions & option) != 0;
        }

        public void setOptionEnabled(int option) {
            this.mOptions |= option;
        }

        public boolean onTitlePrinted() {
            boolean printed = this.mTitlePrinted;
            this.mTitlePrinted = true;
            return printed;
        }

        public boolean getTitlePrinted() {
            return this.mTitlePrinted;
        }

        public void setTitlePrinted(boolean enabled) {
            this.mTitlePrinted = enabled;
        }

        public SharedUserSetting getSharedUser() {
            return this.mSharedUser;
        }

        public void setSharedUser(SharedUserSetting user) {
            this.mSharedUser = user;
        }
    }

    static class PackageRemovedInfo {
        String removedPackage;
        int uid = -1;
        int removedUid = -1;
        boolean isRemovedPackageSystemUpdate = false;
        InstallArgs args = null;

        PackageRemovedInfo() {
        }

        void sendBroadcast(boolean fullRemove, boolean replacing) {
            Bundle extras = new Bundle(1);
            extras.putInt("android.intent.extra.UID", this.removedUid >= 0 ? this.removedUid : this.uid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", fullRemove);
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            if (this.removedPackage != null) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, null, null);
                if (fullRemove && !replacing) {
                    PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, null, null);
                }
            }
            if (this.removedUid >= 0) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, null, null);
            }
        }
    }

    class PackageInstalledInfo {
        String name;
        int uid;
        PackageParser.Package pkg;
        int returnCode;
        PackageRemovedInfo removedInfo;

        PackageInstalledInfo() {
        }
    }

    class SdInstallArgs
    extends InstallArgs {
        static final String RES_FILE_NAME = "pkg.apk";
        String cid;
        String packagePath;
        String libraryPath;

        SdInstallArgs(InstallParams params) {
            super(params.packageURI, params.observer, params.flags, params.installerPackageName, params.manifestDigest);
        }

        SdInstallArgs(String fullCodePath, String fullResourcePath, String nativeLibraryPath) {
            super(null, null, 8, null, null);
            int eidx = fullCodePath.lastIndexOf("/");
            String subStr1 = fullCodePath.substring(0, eidx);
            int sidx = subStr1.lastIndexOf("/");
            this.cid = subStr1.substring(sidx + 1, eidx);
            this.setCachePath(subStr1);
        }

        SdInstallArgs(String cid) {
            super(null, null, 8, null, null);
            this.cid = cid;
            this.setCachePath(PackageHelper.getSdDir((String)cid));
        }

        SdInstallArgs(Uri packageURI, String cid) {
            super(packageURI, null, 8, null, null);
            this.cid = cid;
        }

        void createCopyFile() {
            this.cid = PackageManagerService.getTempContainerId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            boolean bl;
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                bl = imcs.checkExternalFreeStorage(this.packageURI);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
            PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            String newCachePath;
            if (temp) {
                this.createCopyFile();
            } else {
                PackageHelper.destroySdDir((String)this.cid);
            }
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                newCachePath = imcs.copyResourceToContainer(this.packageURI, this.cid, PackageManagerService.this.getEncryptKey(), RES_FILE_NAME);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
            PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            if (newCachePath != null) {
                this.setCachePath(newCachePath);
                return 1;
            }
            return -18;
        }

        String getCodePath() {
            return this.packagePath;
        }

        String getResourcePath() {
            return this.packagePath;
        }

        String getNativeLibraryPath() {
            return this.libraryPath;
        }

        int doPreInstall(int status) {
            if (status != 1) {
                PackageHelper.destroySdDir((String)this.cid);
            } else {
                boolean mounted = PackageHelper.isContainerMounted((String)this.cid);
                if (!mounted) {
                    String newCachePath = PackageHelper.mountSdDir((String)this.cid, (String)PackageManagerService.this.getEncryptKey(), (int)1000);
                    if (newCachePath != null) {
                        this.setCachePath(newCachePath);
                    } else {
                        return -18;
                    }
                }
            }
            return status;
        }

        boolean doRename(int status, String pkgName, String oldCodePath) {
            String newCacheId = PackageManagerService.getNextCodePath(oldCodePath, pkgName, "/pkg.apk");
            String newCachePath = null;
            if (PackageHelper.isContainerMounted((String)this.cid) && !PackageHelper.unMountSdDir((String)this.cid)) {
                Slog.i((String)PackageManagerService.TAG, (String)("Failed to unmount " + this.cid + " before renaming"));
                return false;
            }
            if (!PackageHelper.renameSdDir((String)this.cid, (String)newCacheId)) {
                Slog.e((String)PackageManagerService.TAG, (String)("Failed to rename " + this.cid + " to " + newCacheId + " which might be stale. Will try to clean up."));
                if (!PackageHelper.destroySdDir((String)newCacheId)) {
                    Slog.e((String)PackageManagerService.TAG, (String)("Very strange. Cannot clean up stale container " + newCacheId));
                    return false;
                }
                if (!PackageHelper.renameSdDir((String)this.cid, (String)newCacheId)) {
                    Slog.e((String)PackageManagerService.TAG, (String)("Failed to rename " + this.cid + " to " + newCacheId + " inspite of cleaning it up."));
                    return false;
                }
            }
            if (!PackageHelper.isContainerMounted((String)newCacheId)) {
                Slog.w((String)PackageManagerService.TAG, (String)("Mounting container " + newCacheId));
                newCachePath = PackageHelper.mountSdDir((String)newCacheId, (String)PackageManagerService.this.getEncryptKey(), (int)1000);
            } else {
                newCachePath = PackageHelper.getSdDir((String)newCacheId);
            }
            if (newCachePath == null) {
                Slog.w((String)PackageManagerService.TAG, (String)("Failed to get cache path for  " + newCacheId));
                return false;
            }
            Log.i((String)PackageManagerService.TAG, (String)("Succesfully renamed " + this.cid + " to " + newCacheId + " at new path: " + newCachePath));
            this.cid = newCacheId;
            this.setCachePath(newCachePath);
            return true;
        }

        private void setCachePath(String newCachePath) {
            File cachePath = new File(newCachePath);
            this.libraryPath = new File(cachePath, PackageManagerService.LIB_DIR_NAME).getPath();
            this.packagePath = new File(cachePath, RES_FILE_NAME).getPath();
        }

        int doPostInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            } else {
                boolean mounted = PackageHelper.isContainerMounted((String)this.cid);
                if (!mounted) {
                    PackageHelper.mountSdDir((String)this.cid, (String)PackageManagerService.this.getEncryptKey(), (int)Process.myUid());
                }
            }
            return status;
        }

        private void cleanUp() {
            PackageHelper.destroySdDir((String)this.cid);
        }

        void cleanUpResourcesLI() {
            String sourceFile = this.getCodePath();
            int retCode = PackageManagerService.this.mInstaller.rmdex(sourceFile);
            if (retCode < 0) {
                Slog.w((String)PackageManagerService.TAG, (String)("Couldn't remove dex file for package:  at location " + sourceFile.toString() + ", retcode=" + retCode));
            }
            this.cleanUp();
        }

        boolean matchContainer(String app) {
            return this.cid.startsWith(app);
        }

        String getPackageName() {
            int idx = this.cid.lastIndexOf(PackageManagerService.INSTALL_PACKAGE_SUFFIX);
            if (idx == -1) {
                return this.cid;
            }
            return this.cid.substring(0, idx);
        }

        boolean doPostDeleteLI(boolean delete) {
            boolean ret = false;
            boolean mounted = PackageHelper.isContainerMounted((String)this.cid);
            if (mounted) {
                ret = PackageHelper.unMountSdDir((String)this.cid);
            }
            if (ret && delete) {
                this.cleanUpResourcesLI();
            }
            return ret;
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        File installDir;
        String codeFileName;
        String resourceFileName;
        String libraryPath;
        boolean created;

        FileInstallArgs(InstallParams params) {
            super(params.packageURI, params.observer, params.flags, params.installerPackageName, params.manifestDigest);
            this.created = false;
        }

        FileInstallArgs(String fullCodePath, String fullResourcePath, String nativeLibraryPath) {
            super(null, null, 0, null, null);
            this.created = false;
            File codeFile = new File(fullCodePath);
            this.installDir = codeFile.getParentFile();
            this.codeFileName = fullCodePath;
            this.resourceFileName = fullResourcePath;
            this.libraryPath = nativeLibraryPath;
        }

        FileInstallArgs(Uri packageURI, String pkgName, String dataDir) {
            super(packageURI, null, 0, null, null);
            this.created = false;
            this.installDir = this.isFwdLocked() ? PackageManagerService.this.mDrmAppPrivateInstallDir : PackageManagerService.this.mAppInstallDir;
            String apkName = PackageManagerService.getNextCodePath(null, pkgName, ".apk");
            this.codeFileName = new File(this.installDir, apkName + ".apk").getPath();
            this.resourceFileName = this.getResourcePathFromCodePath();
            this.libraryPath = new File(dataDir, PackageManagerService.LIB_DIR_NAME).getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            boolean bl;
            long lowThreshold;
            DeviceStorageMonitorService dsm = (DeviceStorageMonitorService)ServiceManager.getService((String)"devicestoragemonitor");
            if (dsm == null) {
                Log.w((String)PackageManagerService.TAG, (String)"Couldn't get low memory threshold; no free limit imposed");
                lowThreshold = 0L;
            } else {
                if (dsm.isMemoryLow()) {
                    Log.w((String)PackageManagerService.TAG, (String)"Memory is reported as being too low; aborting package install");
                    return false;
                }
                lowThreshold = dsm.getMemoryLowThreshold();
            }
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                bl = imcs.checkInternalFreeStorage(this.packageURI, lowThreshold);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
            PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            return bl;
        }

        String getCodePath() {
            return this.codeFileName;
        }

        void createCopyFile() {
            this.installDir = this.isFwdLocked() ? PackageManagerService.this.mDrmAppPrivateInstallDir : PackageManagerService.this.mAppInstallDir;
            this.codeFileName = PackageManagerService.this.createTempPackageFile(this.installDir).getPath();
            this.resourceFileName = this.getResourcePathFromCodePath();
            this.created = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            int ret;
            block14: {
                if (temp) {
                    this.createCopyFile();
                }
                File codeFile = new File(this.codeFileName);
                if (!this.created) {
                    try {
                        codeFile.createNewFile();
                        if (!this.setPermissions()) {
                            return -4;
                        }
                    }
                    catch (IOException e) {
                        Slog.w((String)PackageManagerService.TAG, (String)("Failed to create file " + codeFile));
                        return -4;
                    }
                }
                ParcelFileDescriptor out = null;
                try {
                    out = ParcelFileDescriptor.open((File)codeFile, (int)0x30000000);
                }
                catch (FileNotFoundException e) {
                    Slog.e((String)PackageManagerService.TAG, (String)("Failed to create file descriptor for : " + this.codeFileName));
                    return -4;
                }
                ret = -4;
                try {
                    PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                    ret = imcs.copyResource(this.packageURI, out);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    break block14;
                }
                catch (IOException e) {
                    // empty catch block
                }
                {
                }
            }
            PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            return ret;
        }

        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        boolean doRename(int status, String pkgName, String oldCodePath) {
            String apkName;
            File desFile;
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File codeFile = new File(this.getCodePath());
            if (!codeFile.renameTo(desFile = new File(this.installDir, (apkName = PackageManagerService.getNextCodePath(oldCodePath, pkgName, ".apk")) + ".apk"))) {
                return false;
            }
            this.codeFileName = desFile.getPath();
            this.resourceFileName = this.getResourcePathFromCodePath();
            return this.setPermissions();
        }

        int doPostInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        String getResourcePath() {
            return this.resourceFileName;
        }

        String getResourcePathFromCodePath() {
            String codePath = this.getCodePath();
            if ((this.flags & 1) != 0) {
                String apkNameOnly = PackageManagerService.getApkName(codePath);
                return PackageManagerService.this.mAppInstallDir.getPath() + "/" + apkNameOnly + ".zip";
            }
            return codePath;
        }

        String getNativeLibraryPath() {
            return this.libraryPath;
        }

        private boolean cleanUp() {
            boolean ret = true;
            String sourceDir = this.getCodePath();
            String publicSourceDir = this.getResourcePath();
            if (sourceDir != null) {
                File sourceFile = new File(sourceDir);
                if (!sourceFile.exists()) {
                    Slog.w((String)PackageManagerService.TAG, (String)("Package source " + sourceDir + " does not exist."));
                    ret = false;
                }
                sourceFile.delete();
            }
            if (publicSourceDir != null && !publicSourceDir.equals(sourceDir)) {
                File publicSourceFile = new File(publicSourceDir);
                if (!publicSourceFile.exists()) {
                    Slog.w((String)PackageManagerService.TAG, (String)("Package public source " + publicSourceFile + " does not exist."));
                }
                if (publicSourceFile.exists()) {
                    publicSourceFile.delete();
                }
            }
            return ret;
        }

        void cleanUpResourcesLI() {
            int retCode;
            String sourceDir = this.getCodePath();
            if (this.cleanUp() && (retCode = PackageManagerService.this.mInstaller.rmdex(sourceDir)) < 0) {
                Slog.w((String)PackageManagerService.TAG, (String)("Couldn't remove dex file for package:  at location " + sourceDir + ", retcode=" + retCode));
            }
        }

        private boolean setPermissions() {
            if (!this.isFwdLocked()) {
                int filePermissions = 420;
                int retCode = FileUtils.setPermissions((String)this.getCodePath(), (int)420, (int)-1, (int)-1);
                if (retCode != 0) {
                    Slog.e((String)PackageManagerService.TAG, (String)("Couldn't set new package file permissions for " + this.getCodePath() + ". The return code was: " + retCode));
                    return false;
                }
                return true;
            }
            return true;
        }

        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }

        private boolean isFwdLocked() {
            return (this.flags & 1) != 0;
        }
    }

    static abstract class InstallArgs {
        final IPackageInstallObserver observer;
        final int flags;
        final Uri packageURI;
        final String installerPackageName;
        final ManifestDigest manifestDigest;

        InstallArgs(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, ManifestDigest manifestDigest) {
            this.packageURI = packageURI;
            this.flags = flags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.manifestDigest = manifestDigest;
        }

        abstract void createCopyFile();

        abstract int copyApk(IMediaContainerService var1, boolean var2) throws RemoteException;

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, String var2, String var3);

        abstract int doPostInstall(int var1);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract String getNativeLibraryPath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        abstract boolean checkFreeStorage(IMediaContainerService var1) throws RemoteException;
    }

    class MoveParams
    extends HandlerParams {
        final IPackageMoveObserver observer;
        final int flags;
        final String packageName;
        final InstallArgs srcArgs;
        final InstallArgs targetArgs;
        int mRet;

        MoveParams(InstallArgs srcArgs, IPackageMoveObserver observer, int flags, String packageName, String dataDir) {
            this.srcArgs = srcArgs;
            this.observer = observer;
            this.flags = flags;
            this.packageName = packageName;
            if (srcArgs != null) {
                Uri packageUri = Uri.fromFile((File)new File(srcArgs.getCodePath()));
                this.targetArgs = PackageManagerService.this.createInstallArgs(packageUri, flags, packageName, dataDir);
            } else {
                this.targetArgs = null;
            }
        }

        public void handleStartCopy() throws RemoteException {
            this.mRet = -4;
            if (!this.targetArgs.checkFreeStorage(PackageManagerService.this.mContainerService)) {
                Log.w((String)PackageManagerService.TAG, (String)"Insufficient storage to install");
                return;
            }
            this.mRet = this.targetArgs.copyApk(PackageManagerService.this.mContainerService, false);
            this.targetArgs.doPreInstall(this.mRet);
        }

        void handleReturnCode() {
            this.targetArgs.doPostInstall(this.mRet);
            int currentStatus = -6;
            if (this.mRet == 1) {
                currentStatus = 1;
            } else if (this.mRet == -4) {
                currentStatus = -1;
            }
            PackageManagerService.this.processPendingMove(this, currentStatus);
        }

        void handleServiceError() {
            this.mRet = -110;
        }
    }

    class InstallParams
    extends HandlerParams {
        final IPackageInstallObserver observer;
        int flags;
        final Uri packageURI;
        final String installerPackageName;
        final Uri verificationURI;
        final ManifestDigest manifestDigest;
        private InstallArgs mArgs;
        private int mRet;

        InstallParams(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, Uri verificationURI, ManifestDigest manifestDigest) {
            this.packageURI = packageURI;
            this.flags = flags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.verificationURI = verificationURI;
            this.manifestDigest = manifestDigest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite, int flags) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            boolean onSd = (flags & 8) != 0;
            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
            synchronized (hashMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg != null) {
                    if ((flags & 2) != 0) {
                        if ((pkg.applicationInfo.flags & 1) != 0) {
                            if (onSd) {
                                Slog.w((String)PackageManagerService.TAG, (String)"Cannot install update to system app on sdcard");
                                return -3;
                            }
                            return 1;
                        }
                        if (onSd) {
                            return 2;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(pkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
            }
            if (onSd) {
                return 2;
            }
            return pkgLite.recommendedInstallLocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStartCopy() throws RemoteException {
            InstallArgs args;
            int ret = 1;
            boolean fwdLocked = (this.flags & 1) != 0;
            boolean onSd = (this.flags & 8) != 0;
            boolean onInt = (this.flags & 0x10) != 0;
            PackageInfoLite pkgLite = null;
            if (onInt && onSd) {
                Slog.w((String)PackageManagerService.TAG, (String)"Conflicting flags specified for installing on both internal and external");
                ret = -19;
            } else if (fwdLocked && onSd) {
                Slog.w((String)PackageManagerService.TAG, (String)"Cannot install fwd locked apps on sdcard");
                ret = -19;
            } else {
                long lowThreshold;
                DeviceStorageMonitorService dsm = (DeviceStorageMonitorService)ServiceManager.getService((String)"devicestoragemonitor");
                if (dsm == null) {
                    Log.w((String)PackageManagerService.TAG, (String)"Couldn't get low memory threshold; no free limit imposed");
                    lowThreshold = 0L;
                } else {
                    lowThreshold = dsm.getMemoryLowThreshold();
                }
                try {
                    PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                    pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.packageURI, this.flags, lowThreshold);
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                    throw throwable;
                }
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite, this.flags);
                    if (!onSd && !onInt) {
                        if (loc == 2) {
                            this.flags |= 8;
                            this.flags &= 0xFFFFFFEF;
                        } else {
                            this.flags |= 0x10;
                            this.flags &= 0xFFFFFFF7;
                        }
                    }
                }
            }
            this.mArgs = args = PackageManagerService.this.createInstallArgs(this);
            if (ret == 1) {
                int requiredUid;
                int n = requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage);
                if (requiredUid != -1 && PackageManagerService.this.isVerificationEnabled()) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.setDataAndType(this.packageURI, PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List<ResolveInfo> receivers = PackageManagerService.this.queryIntentReceivers(verification, null, 512);
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.flags);
                    if (this.verificationURI != null) {
                        verification.putExtra("android.content.pm.extra.VERIFICATION_URI", (Parcelable)this.verificationURI);
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, args);
                    PackageManagerService.this.mPendingVerification.append(verificationId, (Object)verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i((String)PackageManagerService.TAG, (String)"Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcast(sufficientIntent);
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        verification.setComponent(requiredVerifierComponent);
                        PackageManagerService.this.mContext.sendOrderedBroadcast(verification, "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mArgs = null;
                    }
                } else {
                    ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                }
            }
            this.mRet = ret;
        }

        void handleReturnCode() {
            if (this.mArgs != null) {
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
            }
        }

        void handleServiceError() {
            this.mArgs = PackageManagerService.this.createInstallArgs(this);
            this.mRet = -110;
        }
    }

    class MeasureParams
    extends HandlerParams {
        private final PackageStats mStats;
        private boolean mSuccess;
        private final IPackageStatsObserver mObserver;

        public MeasureParams(PackageStats stats, boolean success, IPackageStatsObserver observer) {
            this.mObserver = observer;
            this.mStats = stats;
            this.mSuccess = success;
        }

        void handleStartCopy() throws RemoteException {
            boolean mounted;
            if (Environment.isExternalStorageEmulated()) {
                mounted = true;
            } else {
                String status = Environment.getExternalStorageState();
                boolean bl = mounted = status.equals("mounted") || status.equals("mounted_ro");
            }
            if (mounted) {
                long externalCacheSize;
                File externalCacheDir = Environment.getExternalStorageAppCacheDirectory((String)this.mStats.packageName);
                this.mStats.externalCacheSize = externalCacheSize = PackageManagerService.this.mContainerService.calculateDirectorySize(externalCacheDir.getPath());
                File externalDataDir = Environment.getExternalStorageAppDataDirectory((String)this.mStats.packageName);
                long externalDataSize = PackageManagerService.this.mContainerService.calculateDirectorySize(externalDataDir.getPath());
                if (externalCacheDir.getParentFile().equals(externalDataDir)) {
                    externalDataSize -= externalCacheSize;
                }
                this.mStats.externalDataSize = externalDataSize;
                File externalMediaDir = Environment.getExternalStorageAppMediaDirectory((String)this.mStats.packageName);
                this.mStats.externalMediaSize = PackageManagerService.this.mContainerService.calculateDirectorySize(externalMediaDir.getPath());
                File externalObbDir = Environment.getExternalStorageAppObbDirectory((String)this.mStats.packageName);
                this.mStats.externalObbSize = PackageManagerService.this.mContainerService.calculateDirectorySize(externalObbDir.getPath());
            }
        }

        void handleReturnCode() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onGetStatsCompleted(this.mStats, this.mSuccess);
                }
                catch (RemoteException e) {
                    Slog.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                }
            }
        }

        void handleServiceError() {
            Slog.e((String)PackageManagerService.TAG, (String)("Could not measure application " + this.mStats.packageName + " external storage"));
        }
    }

    private abstract class HandlerParams {
        private static final int MAX_RETRIES = 4;
        private int mRetries = 0;

        private HandlerParams() {
        }

        final boolean startCopy() {
            boolean res;
            try {
                if (++this.mRetries > 4) {
                    Slog.w((String)PackageManagerService.TAG, (String)"Failed to invoke remote methods on default container service. Giving up");
                    PackageManagerService.this.mHandler.sendEmptyMessage(11);
                    this.handleServiceError();
                    return false;
                }
                this.handleStartCopy();
                res = true;
            }
            catch (RemoteException e) {
                PackageManagerService.this.mHandler.sendEmptyMessage(10);
                res = false;
            }
            this.handleReturnCode();
            return res;
        }

        final void serviceError() {
            this.handleServiceError();
            this.handleReturnCode();
        }

        abstract void handleStartCopy() throws RemoteException;

        abstract void handleServiceError();

        abstract void handleReturnCode();
    }

    private final class AppDirObserver
    extends FileObserver {
        private final String mRootDir;
        private final boolean mIsRom;

        public AppDirObserver(String path, int mask, boolean isrom) {
            super(path, mask);
            this.mRootDir = path;
            this.mIsRom = isrom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(int event, String path) {
            Bundle extras;
            String removedPackage = null;
            int removedUid = -1;
            String addedPackage = null;
            int addedUid = -1;
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                String fullPathStr = null;
                File fullPath = null;
                if (path != null) {
                    fullPath = new File(this.mRootDir, path);
                    fullPathStr = fullPath.getPath();
                }
                if (!PackageManagerService.isPackageFilename(path)) {
                    return;
                }
                if (PackageManagerService.ignoreCodePath(fullPathStr)) {
                    return;
                }
                PackageParser.Package p = null;
                HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                synchronized (hashMap) {
                    p = PackageManagerService.this.mAppDirs.get(fullPathStr);
                }
                if ((event & 0x248) != 0 && p != null) {
                    PackageManagerService.this.removePackageLI(p, true);
                    removedPackage = p.applicationInfo.packageName;
                    removedUid = p.applicationInfo.uid;
                }
                if ((event & 0x88) != 0 && p == null && (p = PackageManagerService.this.scanPackageLI(fullPath, (this.mIsRom ? 65 : 0) | 2 | 4, 97, System.currentTimeMillis())) != null) {
                    hashMap = PackageManagerService.this.mPackages;
                    synchronized (hashMap) {
                        PackageManagerService.this.updatePermissionsLPw(p.packageName, p, p.permissions.size() > 0, false, false);
                    }
                    addedPackage = p.applicationInfo.packageName;
                    addedUid = p.applicationInfo.uid;
                }
                hashMap = PackageManagerService.this.mPackages;
                synchronized (hashMap) {
                    PackageManagerService.this.mSettings.writeLPr();
                }
            }
            if (removedPackage != null) {
                extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", removedUid);
                extras.putBoolean("android.intent.extra.DATA_REMOVED", false);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", removedPackage, extras, null, null);
            }
            if (addedPackage != null) {
                extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", addedUid);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", addedPackage, extras, null, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Service> mServices = new HashMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags) {
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Service> packageServices) {
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageServices.size();
            ArrayList listCut = new ArrayList(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                listCut.add(intentFilters);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut);
        }

        public final void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w((String)PackageManagerService.TAG, (String)("==> For Service " + s.info.name));
                }
                this.addFilter(intent);
            }
        }

        public final void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter) {
            PackageSetting ps;
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return ps.stopped && (ps.pkgFlags & 1) == 0;
            }
            return false;
        }

        @Override
        protected String packageForFilter(PackageParser.ServiceIntentInfo info) {
            return info.service.owner.packageName;
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match) {
            PackageParser.ServiceIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr((ComponentInfo)info.service.info, this.mFlags)) {
                return null;
            }
            PackageParser.Service service = info.service;
            if (PackageManagerService.this.mSafeMode && (service.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = PackageParser.generateServiceInfo((PackageParser.Service)service, (int)this.mFlags);
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.serviceInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            out.print(filter.service.getComponentShortName());
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Activity> mActivities = new HashMap();
        private int mFlags;

        private ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags) {
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Activity> packageActivities) {
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageActivities.size();
            ArrayList listCut = new ArrayList(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                listCut.add(intentFilters);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut);
        }

        public final void addActivity(PackageParser.Activity a, String type) {
            boolean systemApp = PackageManagerService.isSystemApp(a.info.applicationInfo);
            this.mActivities.put(a.getComponentName(), a);
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if (!systemApp && intent.getPriority() > 0 && "activity".equals(type)) {
                    intent.setPriority(0);
                    Log.w((String)PackageManagerService.TAG, (String)("Package " + a.info.applicationInfo.packageName + " has activity " + a.className + " with priority > 0, forcing to 0"));
                }
                if (!intent.debugCheck()) {
                    Log.w((String)PackageManagerService.TAG, (String)("==> For Activity " + a.info.name));
                }
                this.addFilter(intent);
            }
        }

        public final void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter) {
            PackageSetting ps;
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return ps.stopped && (ps.pkgFlags & 1) == 0;
            }
            return false;
        }

        @Override
        protected String packageForFilter(PackageParser.ActivityIntentInfo info) {
            return info.activity.owner.packageName;
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match) {
            if (!PackageManagerService.this.mSettings.isEnabledLPr((ComponentInfo)info.activity.info, this.mFlags)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            if (PackageManagerService.this.mSafeMode && (activity.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = PackageParser.generateActivityInfo((PackageParser.Activity)activity, (int)this.mFlags);
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.activityInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            out.print(filter.activity.getComponentShortName());
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    class PackageHandler
    extends Handler {
        private boolean mBound;
        final ArrayList<HandlerParams> mPendingInstalls;

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            Process.setThreadPriority((int)0);
            if (PackageManagerService.this.mContext.bindService(service, (ServiceConnection)PackageManagerService.this.mDefContainerConn, 1)) {
                Process.setThreadPriority((int)10);
                this.mBound = true;
                return true;
            }
            Process.setThreadPriority((int)10);
            return false;
        }

        private void disconnectService() {
            PackageManagerService.this.mContainerService = null;
            this.mBound = false;
            Process.setThreadPriority((int)0);
            PackageManagerService.this.mContext.unbindService((ServiceConnection)PackageManagerService.this.mDefContainerConn);
            Process.setThreadPriority((int)10);
        }

        PackageHandler(Looper looper) {
            super(looper);
            this.mBound = false;
            this.mPendingInstalls = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Process.setThreadPriority((int)10);
                throw throwable;
            }
            Process.setThreadPriority((int)10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    int idx = this.mPendingInstalls.size();
                    if (!this.mBound) {
                        if (!this.connectToService()) {
                            Slog.e((String)PackageManagerService.TAG, (String)"Failed to bind to media container service");
                            params.serviceError();
                            return;
                        }
                        this.mPendingInstalls.add(idx, params);
                        break;
                    }
                    this.mPendingInstalls.add(idx, params);
                    if (idx != 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    if (msg.obj != null) {
                        PackageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (PackageManagerService.this.mContainerService == null) {
                        Slog.e((String)PackageManagerService.TAG, (String)"Cannot bind to media container service");
                        for (HandlerParams params : this.mPendingInstalls) {
                            this.mPendingInstalls.remove(0);
                            params.serviceError();
                        }
                        this.mPendingInstalls.clear();
                        break;
                    }
                    if (this.mPendingInstalls.size() > 0) {
                        HandlerParams params = this.mPendingInstalls.get(0);
                        if (params == null || !params.startCopy()) break;
                        if (this.mPendingInstalls.size() > 0) {
                            this.mPendingInstalls.remove(0);
                        }
                        if (this.mPendingInstalls.size() == 0) {
                            if (!this.mBound) break;
                            this.removeMessages(6);
                            Message ubmsg = this.obtainMessage(6);
                            this.sendMessageDelayed(ubmsg, 10000L);
                            break;
                        }
                        PackageManagerService.this.mHandler.sendEmptyMessage(3);
                        break;
                    }
                    Slog.w((String)PackageManagerService.TAG, (String)"Empty queue");
                    break;
                }
                case 10: {
                    if (this.mPendingInstalls.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e((String)PackageManagerService.TAG, (String)"Failed to bind to media container service");
                    for (HandlerParams params : this.mPendingInstalls) {
                        this.mPendingInstalls.remove(0);
                        params.serviceError();
                    }
                    this.mPendingInstalls.clear();
                    break;
                }
                case 6: {
                    if (this.mPendingInstalls.size() == 0 && PackageManagerService.this.mPendingVerification.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    if (this.mPendingInstalls.size() <= 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 11: {
                    this.mPendingInstalls.remove(0);
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority((int)0);
                    HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                    synchronized (hashMap) {
                        int i;
                        if (PackageManagerService.this.mPendingBroadcasts == null) {
                            return;
                        }
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.entrySet().iterator();
                        for (i = 0; it.hasNext() && i < size; ++i) {
                            Map.Entry<String, ArrayList<String>> ent = it.next();
                            packages[i] = ent.getKey();
                            components[i] = ent.getValue();
                            PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                            uids[i] = ps != null ? ps.userId : -1;
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority((int)10);
                    break;
                }
                case 7: {
                    String packageName = (String)msg.obj;
                    Process.setThreadPriority((int)0);
                    HashMap<String, PackageParser.Package> components = PackageManagerService.this.mPackages;
                    synchronized (components) {
                        if (!PackageManagerService.this.mSettings.mPackagesToBeCleaned.contains(packageName)) {
                            PackageManagerService.this.mSettings.mPackagesToBeCleaned.add(packageName);
                        }
                    }
                    Process.setThreadPriority((int)10);
                    PackageManagerService.this.startCleaningPackages();
                    break;
                }
                case 9: {
                    PostInstallData data = (PostInstallData)PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    boolean deleteOld = false;
                    if (data != null) {
                        Object extras;
                        InstallArgs args = data.args;
                        PackageInstalledInfo res = data.res;
                        if (res.returnCode == 1) {
                            boolean update;
                            res.removedInfo.sendBroadcast(false, true);
                            extras = new Bundle(1);
                            extras.putInt("android.intent.extra.UID", res.uid);
                            boolean bl = update = res.removedInfo.removedPackage != null;
                            if (update) {
                                extras.putBoolean("android.intent.extra.REPLACING", true);
                            }
                            PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null);
                            if (update) {
                                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null);
                                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, res.pkg.applicationInfo.packageName, null);
                            }
                            if (res.removedInfo.args != null) {
                                deleteOld = true;
                            }
                        }
                        Runtime.getRuntime().gc();
                        if (deleteOld) {
                            extras = PackageManagerService.this.mInstallLock;
                            synchronized (extras) {
                                res.removedInfo.args.doPostDeleteLI(true);
                            }
                        }
                        if (args.observer == null) break;
                        try {
                            args.observer.packageInstalled(res.name, res.returnCode);
                        }
                        catch (RemoteException e) {
                            Slog.i((String)PackageManagerService.TAG, (String)"Observer no longer exists.");
                        }
                        break;
                    }
                    Slog.e((String)PackageManagerService.TAG, (String)("Bogus post-install token " + msg.arg1));
                    break;
                }
                case 12: {
                    boolean doGc;
                    boolean reportStatus = msg.arg1 == 1;
                    boolean bl = doGc = msg.arg2 == 1;
                    if (doGc) {
                        Runtime.getRuntime().gc();
                    }
                    if (msg.obj != null) {
                        Set args = (Set)msg.obj;
                        PackageManagerService.this.unloadAllContainers(args);
                    }
                    if (!reportStatus) break;
                    try {
                        PackageHelper.getMountService().finishMediaUpdate();
                    }
                    catch (RemoteException e) {
                        Log.e((String)PackageManagerService.TAG, (String)"MountService not running?");
                    }
                    break;
                }
                case 13: {
                    Process.setThreadPriority((int)0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                    }
                    Process.setThreadPriority((int)10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority((int)0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeStoppedLPr();
                    }
                    Process.setThreadPriority((int)10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = (PackageVerificationState)PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) break;
                    InstallArgs args = state.getInstallArgs();
                    Slog.i((String)PackageManagerService.TAG, (String)("Verification timed out for " + args.packageURI.toString()));
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    int ret = -21;
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 15: {
                    int ret;
                    int verificationId = msg.arg1;
                    PackageVerificationState state = (PackageVerificationState)PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w((String)PackageManagerService.TAG, (String)("Invalid verification token " + verificationId + " received"));
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallArgs args = state.getInstallArgs();
                    if (state.isInstallAllowed()) {
                        ret = -110;
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e((String)PackageManagerService.TAG, (String)"Could not contact the ContainerService");
                        }
                    } else {
                        ret = -22;
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
            }
        }
    }

    class PostInstallData {
        public InstallArgs args;
        public PackageInstalledInfo res;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r) {
            this.args = _a;
            this.res = _r;
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface((IBinder)service);
            PackageManagerService.this.mHandler.sendMessage(PackageManagerService.this.mHandler.obtainMessage(3, imcs));
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }
}

