/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.PackageSignatures;
import java.io.File;
import java.util.HashSet;

class PackageSettingBase
extends GrantedPermissions {
    static final int PKG_INSTALL_COMPLETE = 1;
    static final int PKG_INSTALL_INCOMPLETE = 0;
    final String name;
    final String realName;
    File codePath;
    String codePathString;
    File resourcePath;
    String resourcePathString;
    String nativeLibraryPathString;
    long timeStamp;
    long firstInstallTime;
    long lastUpdateTime;
    int versionCode;
    boolean uidError;
    PackageSignatures signatures = new PackageSignatures();
    boolean permissionsFixed;
    boolean haveGids;
    public boolean stopped;
    public boolean notLaunched;
    HashSet<String> disabledComponents = new HashSet(0);
    HashSet<String> enabledComponents = new HashSet(0);
    int enabled = 0;
    int installStatus = 1;
    PackageSettingBase origPackage;
    String installerPackageName;

    PackageSettingBase(String name, String realName, File codePath, File resourcePath, String nativeLibraryPathString, int pVersionCode, int pkgFlags) {
        super(pkgFlags);
        this.name = name;
        this.realName = realName;
        this.init(codePath, resourcePath, nativeLibraryPathString, pVersionCode);
    }

    PackageSettingBase(PackageSettingBase base) {
        super(base);
        this.name = base.name;
        this.realName = base.realName;
        this.codePath = base.codePath;
        this.codePathString = base.codePathString;
        this.resourcePath = base.resourcePath;
        this.resourcePathString = base.resourcePathString;
        this.nativeLibraryPathString = base.nativeLibraryPathString;
        this.timeStamp = base.timeStamp;
        this.firstInstallTime = base.firstInstallTime;
        this.lastUpdateTime = base.lastUpdateTime;
        this.versionCode = base.versionCode;
        this.uidError = base.uidError;
        this.signatures = new PackageSignatures(base.signatures);
        this.permissionsFixed = base.permissionsFixed;
        this.haveGids = base.haveGids;
        this.stopped = base.stopped;
        this.notLaunched = base.notLaunched;
        this.disabledComponents = (HashSet)base.disabledComponents.clone();
        this.enabledComponents = (HashSet)base.enabledComponents.clone();
        this.enabled = base.enabled;
        this.installStatus = base.installStatus;
        this.origPackage = base.origPackage;
        this.installerPackageName = base.installerPackageName;
    }

    void init(File codePath, File resourcePath, String nativeLibraryPathString, int pVersionCode) {
        this.codePath = codePath;
        this.codePathString = codePath.toString();
        this.resourcePath = resourcePath;
        this.resourcePathString = resourcePath.toString();
        this.nativeLibraryPathString = nativeLibraryPathString;
        this.versionCode = pVersionCode;
    }

    public void setInstallerPackageName(String packageName) {
        this.installerPackageName = packageName;
    }

    String getInstallerPackageName() {
        return this.installerPackageName;
    }

    public void setInstallStatus(int newStatus) {
        this.installStatus = newStatus;
    }

    public int getInstallStatus() {
        return this.installStatus;
    }

    public void setTimeStamp(long newStamp) {
        this.timeStamp = newStamp;
    }

    public void copyFrom(PackageSettingBase base) {
        this.grantedPermissions = base.grantedPermissions;
        this.gids = base.gids;
        this.timeStamp = base.timeStamp;
        this.firstInstallTime = base.firstInstallTime;
        this.lastUpdateTime = base.lastUpdateTime;
        this.signatures = base.signatures;
        this.permissionsFixed = base.permissionsFixed;
        this.haveGids = base.haveGids;
        this.stopped = base.stopped;
        this.notLaunched = base.notLaunched;
        this.disabledComponents = base.disabledComponents;
        this.enabledComponents = base.enabledComponents;
        this.enabled = base.enabled;
        this.installStatus = base.installStatus;
    }

    boolean enableComponentLPw(String componentClassName) {
        boolean changed = this.disabledComponents.remove(componentClassName);
        return changed |= this.enabledComponents.add(componentClassName);
    }

    boolean disableComponentLPw(String componentClassName) {
        boolean changed = this.enabledComponents.remove(componentClassName);
        return changed |= this.disabledComponents.add(componentClassName);
    }

    boolean restoreComponentLPw(String componentClassName) {
        boolean changed = this.enabledComponents.remove(componentClassName);
        return changed |= this.disabledComponents.remove(componentClassName);
    }

    int getCurrentEnabledStateLPr(String componentName) {
        if (this.enabledComponents.contains(componentName)) {
            return 1;
        }
        if (this.disabledComponents.contains(componentName)) {
            return 2;
        }
        return 0;
    }
}

