/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageParser;
import android.content.pm.PermissionInfo;
import android.content.pm.Signature;
import android.content.pm.VerifierDeviceIdentity;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.server.IntentResolver;
import com.android.server.pm.BasePermission;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PendingPackage;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.SharedUserSetting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Settings {
    private static final String TAG = "PackageSettings";
    private static final boolean DEBUG_STOPPED = false;
    private final File mSettingsFilename;
    private final File mBackupSettingsFilename;
    private final File mPackageListFilename;
    private final File mStoppedPackagesFilename;
    private final File mBackupStoppedPackagesFilename;
    final HashMap<String, PackageSetting> mPackages = new HashMap();
    final HashMap<String, PackageSetting> mDisabledSysPackages = new HashMap();
    int mInternalSdkPlatform;
    int mExternalSdkPlatform;
    private VerifierDeviceIdentity mVerifierDeviceIdentity;
    final IntentResolver<PreferredActivity, PreferredActivity> mPreferredActivities = new IntentResolver<PreferredActivity, PreferredActivity>(){

        @Override
        protected String packageForFilter(PreferredActivity filter) {
            return filter.mPref.mComponent.getPackageName();
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PreferredActivity filter) {
            filter.mPref.dump(out, prefix, filter);
        }
    };
    final HashMap<String, SharedUserSetting> mSharedUsers = new HashMap();
    private final ArrayList<Object> mUserIds = new ArrayList();
    private final SparseArray<Object> mOtherUserIds = new SparseArray();
    private final ArrayList<Signature> mPastSignatures = new ArrayList();
    final HashMap<String, BasePermission> mPermissions = new HashMap();
    final HashMap<String, BasePermission> mPermissionTrees = new HashMap();
    final ArrayList<String> mPackagesToBeCleaned = new ArrayList();
    final HashMap<String, String> mRenamedPackages = new HashMap();
    final StringBuilder mReadMessages = new StringBuilder();
    private final ArrayList<PendingPackage> mPendingPackages = new ArrayList();

    Settings() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        FileUtils.setPermissions((String)systemDir.toString(), (int)509, (int)-1, (int)-1);
        this.mSettingsFilename = new File(systemDir, "packages.xml");
        this.mBackupSettingsFilename = new File(systemDir, "packages-backup.xml");
        this.mPackageListFilename = new File(systemDir, "packages.list");
        this.mStoppedPackagesFilename = new File(systemDir, "packages-stopped.xml");
        this.mBackupStoppedPackagesFilename = new File(systemDir, "packages-stopped-backup.xml");
    }

    PackageSetting getPackageLPw(PackageParser.Package pkg, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String nativeLibraryPathString, int pkgFlags, boolean create, boolean add) {
        String name = pkg.packageName;
        PackageSetting p = this.getPackageLPw(name, origPackage, realName, sharedUser, codePath, resourcePath, nativeLibraryPathString, pkg.mVersionCode, pkgFlags, create, add);
        return p;
    }

    PackageSetting peekPackageLPr(String name) {
        return this.mPackages.get(name);
    }

    void setInstallStatus(String pkgName, int status) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null && p.getInstallStatus() != status) {
            p.setInstallStatus(status);
        }
    }

    void setInstallerPackageName(String pkgName, String installerPkgName) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null) {
            p.setInstallerPackageName(installerPkgName);
        }
    }

    SharedUserSetting getSharedUserLPw(String name, int pkgFlags, boolean create) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s == null) {
            if (!create) {
                return null;
            }
            s = new SharedUserSetting(name, pkgFlags);
            s.userId = this.newUserIdLPw(s);
            Log.i((String)"PackageManager", (String)("New shared user " + name + ": id=" + s.userId));
            if (s.userId >= 0) {
                this.mSharedUsers.put(name, s);
            }
        }
        return s;
    }

    boolean disableSystemPackageLPw(String name) {
        PackageSetting p = this.mPackages.get(name);
        if (p == null) {
            Log.w((String)"PackageManager", (String)("Package:" + name + " is not an installed package"));
            return false;
        }
        PackageSetting dp = this.mDisabledSysPackages.get(name);
        if (dp == null) {
            if (p.pkg != null && p.pkg.applicationInfo != null) {
                p.pkg.applicationInfo.flags |= 0x80;
            }
            this.mDisabledSysPackages.put(name, p);
            PackageSetting newp = new PackageSetting(p);
            this.replacePackageLPw(name, newp);
            return true;
        }
        return false;
    }

    PackageSetting enableSystemPackageLPw(String name) {
        PackageSetting p = this.mDisabledSysPackages.get(name);
        if (p == null) {
            Log.w((String)"PackageManager", (String)("Package:" + name + " is not disabled"));
            return null;
        }
        if (p.pkg != null && p.pkg.applicationInfo != null) {
            p.pkg.applicationInfo.flags &= 0xFFFFFF7F;
        }
        PackageSetting ret = this.addPackageLPw(name, p.realName, p.codePath, p.resourcePath, p.nativeLibraryPathString, p.userId, p.versionCode, p.pkgFlags);
        this.mDisabledSysPackages.remove(name);
        return ret;
    }

    PackageSetting addPackageLPw(String name, String realName, File codePath, File resourcePath, String nativeLibraryPathString, int uid, int vc, int pkgFlags) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.userId == uid) {
                return p;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate package, keeping first: " + name);
            return null;
        }
        p = new PackageSetting(name, realName, codePath, resourcePath, nativeLibraryPathString, vc, pkgFlags);
        p.userId = uid;
        if (this.addUserIdLPw(uid, p, name)) {
            this.mPackages.put(name, p);
            return p;
        }
        return null;
    }

    SharedUserSetting addSharedUserLPw(String name, int uid, int pkgFlags) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s != null) {
            if (s.userId == uid) {
                return s;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared user, keeping first: " + name);
            return null;
        }
        s = new SharedUserSetting(name, pkgFlags);
        s.userId = uid;
        if (this.addUserIdLPw(uid, s, name)) {
            this.mSharedUsers.put(name, s);
            return s;
        }
        return null;
    }

    void transferPermissionsLPw(String origPkg, String newPkg) {
        for (int i = 0; i < 2; ++i) {
            HashMap<String, BasePermission> permissions = i == 0 ? this.mPermissionTrees : this.mPermissions;
            for (BasePermission bp : permissions.values()) {
                if (!origPkg.equals(bp.sourcePackage)) continue;
                bp.sourcePackage = newPkg;
                bp.packageSetting = null;
                bp.perm = null;
                if (bp.pendingInfo != null) {
                    bp.pendingInfo.packageName = newPkg;
                }
                bp.uid = 0;
                bp.gids = null;
            }
        }
    }

    private PackageSetting getPackageLPw(String name, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String nativeLibraryPathString, int vc, int pkgFlags, boolean create, boolean add) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (!p.codePath.equals(codePath)) {
                if ((p.pkgFlags & 1) != 0) {
                    Slog.w((String)"PackageManager", (String)("Trying to update system app code path from " + p.codePathString + " to " + codePath.toString()));
                } else {
                    Slog.i((String)"PackageManager", (String)("Package " + name + " codePath changed from " + p.codePath + " to " + codePath + "; Retaining data and using new"));
                    p.nativeLibraryPathString = nativeLibraryPathString;
                }
            }
            if (p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " shared user changed from " + (p.sharedUser != null ? p.sharedUser.name : "<nothing>") + " to " + (sharedUser != null ? sharedUser.name : "<nothing>") + "; replacing with new");
                p = null;
            } else if ((pkgFlags & 1) != 0) {
                p.pkgFlags |= 1;
            }
        }
        if (p == null) {
            if (!create) {
                return null;
            }
            if (origPackage != null) {
                p = new PackageSetting(origPackage.name, name, codePath, resourcePath, nativeLibraryPathString, vc, pkgFlags);
                PackageSignatures s = p.signatures;
                p.copyFrom(origPackage);
                p.signatures = s;
                p.sharedUser = origPackage.sharedUser;
                p.userId = origPackage.userId;
                p.origPackage = origPackage;
                this.mRenamedPackages.put(name, origPackage.name);
                name = origPackage.name;
                p.setTimeStamp(codePath.lastModified());
            } else {
                p = new PackageSetting(name, realName, codePath, resourcePath, nativeLibraryPathString, vc, pkgFlags);
                p.setTimeStamp(codePath.lastModified());
                p.sharedUser = sharedUser;
                if ((pkgFlags & 1) == 0) {
                    p.stopped = true;
                    p.notLaunched = true;
                }
                if (sharedUser != null) {
                    p.userId = sharedUser.userId;
                } else {
                    PackageSetting dis = this.mDisabledSysPackages.get(name);
                    if (dis != null) {
                        if (dis.signatures.mSignatures != null) {
                            p.signatures.mSignatures = (Signature[])dis.signatures.mSignatures.clone();
                        }
                        p.userId = dis.userId;
                        p.grantedPermissions = new HashSet(dis.grantedPermissions);
                        p.disabledComponents = new HashSet(dis.disabledComponents);
                        p.enabledComponents = new HashSet(dis.enabledComponents);
                        this.addUserIdLPw(p.userId, p, name);
                    } else {
                        p.userId = this.newUserIdLPw(p);
                    }
                }
            }
            if (p.userId < 0) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " could not be assigned a valid uid");
                return null;
            }
            if (add) {
                this.addPackageSettingLPw(p, name, sharedUser);
            }
        }
        return p;
    }

    void insertPackageSettingLPw(PackageSetting p, PackageParser.Package pkg) {
        String nativeLibraryPath;
        p.pkg = pkg;
        pkg.mSetEnabled = p.enabled;
        pkg.mSetStopped = p.stopped;
        String codePath = pkg.applicationInfo.sourceDir;
        String resourcePath = pkg.applicationInfo.publicSourceDir;
        if (!codePath.equalsIgnoreCase(p.codePathString)) {
            Slog.w((String)"PackageManager", (String)("Code path for pkg : " + p.pkg.packageName + " changing from " + p.codePathString + " to " + codePath));
            p.codePath = new File(codePath);
            p.codePathString = codePath;
        }
        if (!resourcePath.equalsIgnoreCase(p.resourcePathString)) {
            Slog.w((String)"PackageManager", (String)("Resource path for pkg : " + p.pkg.packageName + " changing from " + p.resourcePathString + " to " + resourcePath));
            p.resourcePath = new File(resourcePath);
            p.resourcePathString = resourcePath;
        }
        if ((nativeLibraryPath = pkg.applicationInfo.nativeLibraryDir) != null && !nativeLibraryPath.equalsIgnoreCase(p.nativeLibraryPathString)) {
            p.nativeLibraryPathString = nativeLibraryPath;
        }
        if (pkg.mVersionCode != p.versionCode) {
            p.versionCode = pkg.mVersionCode;
        }
        if (p.signatures.mSignatures == null) {
            p.signatures.assignSignatures(pkg.mSignatures);
        }
        if (p.sharedUser != null && p.sharedUser.signatures.mSignatures == null) {
            p.sharedUser.signatures.assignSignatures(pkg.mSignatures);
        }
        this.addPackageSettingLPw(p, pkg.packageName, p.sharedUser);
    }

    private void addPackageSettingLPw(PackageSetting p, String name, SharedUserSetting sharedUser) {
        this.mPackages.put(name, p);
        if (sharedUser != null) {
            if (p.sharedUser != null && p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user " + p.sharedUser + " but is now " + sharedUser + "; I am not changing its files so it will probably fail!");
                p.sharedUser.packages.remove(p);
            } else if (p.userId != sharedUser.userId) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user id " + p.userId + " but is now user " + sharedUser + " with id " + sharedUser.userId + "; I am not changing its files so it will probably fail!");
            }
            sharedUser.packages.add(p);
            p.sharedUser = sharedUser;
            p.userId = sharedUser.userId;
        }
    }

    void updateSharedUserPermsLPw(PackageSetting deletedPs, int[] globalGids) {
        if (deletedPs == null || deletedPs.pkg == null) {
            Slog.i((String)"PackageManager", (String)"Trying to update info for null package. Just ignoring");
            return;
        }
        if (deletedPs.sharedUser == null) {
            return;
        }
        SharedUserSetting sus = deletedPs.sharedUser;
        for (String eachPerm : deletedPs.pkg.requestedPermissions) {
            boolean used = false;
            if (!sus.grantedPermissions.contains(eachPerm)) continue;
            for (PackageSetting pkg : sus.packages) {
                if (pkg.pkg == null || pkg.pkg.packageName.equals(deletedPs.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(eachPerm)) continue;
                used = true;
                break;
            }
            if (used) continue;
            sus.grantedPermissions.remove(eachPerm);
        }
        int[] newGids = globalGids;
        for (String eachPerm : sus.grantedPermissions) {
            BasePermission bp = this.mPermissions.get(eachPerm);
            if (bp == null) continue;
            newGids = PackageManagerService.appendInts(newGids, bp.gids);
        }
        sus.gids = newGids;
    }

    int removePackageLPw(String name) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            this.mPackages.remove(name);
            if (p.sharedUser != null) {
                p.sharedUser.packages.remove(p);
                if (p.sharedUser.packages.size() == 0) {
                    this.mSharedUsers.remove(p.sharedUser.name);
                    this.removeUserIdLPw(p.sharedUser.userId);
                    return p.sharedUser.userId;
                }
            } else {
                this.removeUserIdLPw(p.userId);
                return p.userId;
            }
        }
        return -1;
    }

    private void replacePackageLPw(String name, PackageSetting newp) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.sharedUser != null) {
                p.sharedUser.packages.remove(p);
                p.sharedUser.packages.add(newp);
            } else {
                this.replaceUserIdLPw(p.userId, newp);
            }
        }
        this.mPackages.put(name, newp);
    }

    private boolean addUserIdLPw(int uid, Object obj, Object name) {
        if (uid >= 11000) {
            return false;
        }
        if (uid >= 10000) {
            int index = uid - 10000;
            for (int N = this.mUserIds.size(); index >= N; ++N) {
                this.mUserIds.add(null);
            }
            if (this.mUserIds.get(index) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate user id: " + uid + " name=" + name);
                return false;
            }
            this.mUserIds.set(index, obj);
        } else {
            if (this.mOtherUserIds.get(uid) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared id: " + uid + " name=" + name);
                return false;
            }
            this.mOtherUserIds.put(uid, obj);
        }
        return true;
    }

    public Object getUserIdLPr(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            return index < N ? this.mUserIds.get(index) : null;
        }
        return this.mOtherUserIds.get(uid);
    }

    private void removeUserIdLPw(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, null);
            }
        } else {
            this.mOtherUserIds.remove(uid);
        }
    }

    private void replaceUserIdLPw(int uid, Object obj) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, obj);
            }
        } else {
            this.mOtherUserIds.put(uid, obj);
        }
    }

    void writeStoppedLPr() {
        if (this.mStoppedPackagesFilename.exists()) {
            if (!this.mBackupStoppedPackagesFilename.exists()) {
                if (!this.mStoppedPackagesFilename.renameTo(this.mBackupStoppedPackagesFilename)) {
                    Log.wtf((String)"PackageManager", (String)"Unable to backup package manager stopped packages, current changes will be lost at reboot");
                    return;
                }
            } else {
                this.mStoppedPackagesFilename.delete();
                Slog.w((String)"PackageManager", (String)"Preserving older stopped packages backup");
            }
        }
        try {
            FileOutputStream fstr = new FileOutputStream(this.mStoppedPackagesFilename);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput((OutputStream)str, "utf-8");
            serializer.startDocument(null, Boolean.valueOf(true));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, "stopped-packages");
            for (PackageSetting pkg : this.mPackages.values()) {
                if (!pkg.stopped) continue;
                serializer.startTag(null, "pkg");
                serializer.attribute(null, "name", pkg.name);
                if (pkg.notLaunched) {
                    serializer.attribute(null, "nl", "1");
                }
                serializer.endTag(null, "pkg");
            }
            serializer.endTag(null, "stopped-packages");
            serializer.endDocument();
            str.flush();
            FileUtils.sync((FileOutputStream)fstr);
            str.close();
            this.mBackupStoppedPackagesFilename.delete();
            FileUtils.setPermissions((String)this.mStoppedPackagesFilename.toString(), (int)436, (int)-1, (int)-1);
            return;
        }
        catch (IOException e) {
            Log.wtf((String)"PackageManager", (String)"Unable to write package manager stopped packages,  current changes will be lost at reboot", (Throwable)e);
            if (this.mStoppedPackagesFilename.exists() && !this.mStoppedPackagesFilename.delete()) {
                Log.i((String)"PackageManager", (String)("Failed to clean up mangled file: " + this.mStoppedPackagesFilename));
            }
            return;
        }
    }

    void readStoppedLPw() {
        FileInputStream str = null;
        if (this.mBackupStoppedPackagesFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupStoppedPackagesFilename);
                this.mReadMessages.append("Reading from backup stopped packages file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup stopped packages file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w((String)"PackageManager", (String)("Cleaning up stopped packages file " + this.mStoppedPackagesFilename));
                    this.mStoppedPackagesFilename.delete();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            int type;
            if (str == null) {
                if (!this.mStoppedPackagesFilename.exists()) {
                    this.mReadMessages.append("No stopped packages file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No stopped packages file file; assuming all started");
                    for (PackageSetting pkg : this.mPackages.values()) {
                        pkg.stopped = false;
                        pkg.notLaunched = false;
                    }
                    return;
                }
                str = new FileInputStream(this.mStoppedPackagesFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in stopped packages file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager stopped packages");
                return;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("pkg")) {
                    String name = parser.getAttributeValue(null, "name");
                    PackageSetting ps = this.mPackages.get(name);
                    if (ps != null) {
                        ps.stopped = true;
                        if ("1".equals(parser.getAttributeValue(null, "nl"))) {
                            ps.notLaunched = true;
                        }
                    } else {
                        Slog.w((String)"PackageManager", (String)("No package known for stopped package: " + name));
                    }
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                Slog.w((String)"PackageManager", (String)("Unknown element under <stopped-packages>: " + parser.getName()));
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading stopped packages: " + (Object)((Object)e));
            Log.wtf((String)"PackageManager", (String)"Error reading package manager stopped packages", (Throwable)e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Log.wtf((String)"PackageManager", (String)"Error reading package manager stopped packages", (Throwable)e);
        }
    }

    void writeLPr() {
        if (this.mSettingsFilename.exists()) {
            if (!this.mBackupSettingsFilename.exists()) {
                if (!this.mSettingsFilename.renameTo(this.mBackupSettingsFilename)) {
                    Log.wtf((String)"PackageManager", (String)"Unable to backup package manager settings,  current changes will be lost at reboot");
                    return;
                }
            } else {
                this.mSettingsFilename.delete();
                Slog.w((String)"PackageManager", (String)"Preserving older settings backup");
            }
        }
        this.mPastSignatures.clear();
        try {
            FileOutputStream fstr = new FileOutputStream(this.mSettingsFilename);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput((OutputStream)str, "utf-8");
            serializer.startDocument(null, Boolean.valueOf(true));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, "packages");
            serializer.startTag(null, "last-platform-version");
            serializer.attribute(null, "internal", Integer.toString(this.mInternalSdkPlatform));
            serializer.attribute(null, "external", Integer.toString(this.mExternalSdkPlatform));
            serializer.endTag(null, "last-platform-version");
            if (this.mVerifierDeviceIdentity != null) {
                serializer.startTag(null, "verifier");
                serializer.attribute(null, "device", this.mVerifierDeviceIdentity.toString());
                serializer.endTag(null, "verifier");
            }
            serializer.startTag(null, "permission-trees");
            for (BasePermission bp : this.mPermissionTrees.values()) {
                this.writePermissionLPr((XmlSerializer)serializer, bp);
            }
            serializer.endTag(null, "permission-trees");
            serializer.startTag(null, "permissions");
            for (BasePermission bp : this.mPermissions.values()) {
                this.writePermissionLPr((XmlSerializer)serializer, bp);
            }
            serializer.endTag(null, "permissions");
            for (PackageSetting pkg : this.mPackages.values()) {
                this.writePackageLPr((XmlSerializer)serializer, pkg);
            }
            for (PackageSetting pkg : this.mDisabledSysPackages.values()) {
                this.writeDisabledSysPackageLPr((XmlSerializer)serializer, pkg);
            }
            serializer.startTag(null, "preferred-activities");
            for (PreferredActivity pa : this.mPreferredActivities.filterSet()) {
                serializer.startTag(null, "item");
                pa.writeToXml((XmlSerializer)serializer);
                serializer.endTag(null, "item");
            }
            serializer.endTag(null, "preferred-activities");
            for (SharedUserSetting usr : this.mSharedUsers.values()) {
                serializer.startTag(null, "shared-user");
                serializer.attribute(null, "name", usr.name);
                serializer.attribute(null, "userId", Integer.toString(usr.userId));
                usr.signatures.writeXml((XmlSerializer)serializer, "sigs", this.mPastSignatures);
                serializer.startTag(null, "perms");
                for (String name : usr.grantedPermissions) {
                    serializer.startTag(null, "item");
                    serializer.attribute(null, "name", name);
                    serializer.endTag(null, "item");
                }
                serializer.endTag(null, "perms");
                serializer.endTag(null, "shared-user");
            }
            if (this.mPackagesToBeCleaned.size() > 0) {
                for (int i = 0; i < this.mPackagesToBeCleaned.size(); ++i) {
                    serializer.startTag(null, "cleaning-package");
                    serializer.attribute(null, "name", this.mPackagesToBeCleaned.get(i));
                    serializer.endTag(null, "cleaning-package");
                }
            }
            if (this.mRenamedPackages.size() > 0) {
                for (Map.Entry<String, String> e : this.mRenamedPackages.entrySet()) {
                    serializer.startTag(null, "renamed-package");
                    serializer.attribute(null, "new", e.getKey());
                    serializer.attribute(null, "old", e.getValue());
                    serializer.endTag(null, "renamed-package");
                }
            }
            serializer.endTag(null, "packages");
            serializer.endDocument();
            str.flush();
            FileUtils.sync((FileOutputStream)fstr);
            str.close();
            this.mBackupSettingsFilename.delete();
            FileUtils.setPermissions((String)this.mSettingsFilename.toString(), (int)436, (int)-1, (int)-1);
            File tempFile = new File(this.mPackageListFilename.toString() + ".tmp");
            JournaledFile journal = new JournaledFile(this.mPackageListFilename, tempFile);
            fstr = new FileOutputStream(journal.chooseForWrite());
            str = new BufferedOutputStream(fstr);
            try {
                StringBuilder sb = new StringBuilder();
                for (PackageSetting pkg : this.mPackages.values()) {
                    boolean isDebug;
                    ApplicationInfo ai = pkg.pkg.applicationInfo;
                    String dataPath = ai.dataDir;
                    boolean bl = isDebug = (ai.flags & 2) != 0;
                    if (dataPath.indexOf(" ") >= 0 || ai.uid <= 10000) continue;
                    sb.setLength(0);
                    sb.append(ai.packageName);
                    sb.append(" ");
                    sb.append(ai.uid);
                    sb.append(isDebug ? " 1 " : " 0 ");
                    sb.append(dataPath);
                    sb.append("\n");
                    str.write(sb.toString().getBytes());
                }
                str.flush();
                FileUtils.sync((FileOutputStream)fstr);
                str.close();
                journal.commit();
            }
            catch (Exception e) {
                IoUtils.closeQuietly((AutoCloseable)str);
                journal.rollback();
            }
            FileUtils.setPermissions((String)this.mPackageListFilename.toString(), (int)436, (int)-1, (int)-1);
            this.writeStoppedLPr();
            return;
        }
        catch (XmlPullParserException e) {
            Log.wtf((String)"PackageManager", (String)"Unable to write package manager settings, current changes will be lost at reboot", (Throwable)e);
        }
        catch (IOException e) {
            Log.wtf((String)"PackageManager", (String)"Unable to write package manager settings, current changes will be lost at reboot", (Throwable)e);
        }
        if (this.mSettingsFilename.exists() && !this.mSettingsFilename.delete()) {
            Log.wtf((String)"PackageManager", (String)("Failed to clean up mangled file: " + this.mSettingsFilename));
        }
    }

    void writeDisabledSysPackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "updated-package");
        serializer.attribute(null, "name", pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, "version", String.valueOf(pkg.versionCode));
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.nativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.nativeLibraryPathString);
        }
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.userId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.userId));
        }
        serializer.startTag(null, "perms");
        if (pkg.sharedUser == null) {
            for (String name : pkg.grantedPermissions) {
                BasePermission bp = this.mPermissions.get(name);
                if (bp == null) continue;
                serializer.startTag(null, "item");
                serializer.attribute(null, "name", name);
                serializer.endTag(null, "item");
            }
        }
        serializer.endTag(null, "perms");
        serializer.endTag(null, "updated-package");
    }

    void writePackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "package");
        serializer.attribute(null, "name", pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.nativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.nativeLibraryPathString);
        }
        serializer.attribute(null, "flags", Integer.toString(pkg.pkgFlags));
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, "version", String.valueOf(pkg.versionCode));
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.userId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.userId));
        }
        if (pkg.uidError) {
            serializer.attribute(null, "uidError", "true");
        }
        if (pkg.enabled != 0) {
            serializer.attribute(null, "enabled", Integer.toString(pkg.enabled));
        }
        if (pkg.installStatus == 0) {
            serializer.attribute(null, "installStatus", "false");
        }
        if (pkg.installerPackageName != null) {
            serializer.attribute(null, "installer", pkg.installerPackageName);
        }
        pkg.signatures.writeXml(serializer, "sigs", this.mPastSignatures);
        if ((pkg.pkgFlags & 1) == 0) {
            serializer.startTag(null, "perms");
            if (pkg.sharedUser == null) {
                for (String name : pkg.grantedPermissions) {
                    serializer.startTag(null, "item");
                    serializer.attribute(null, "name", name);
                    serializer.endTag(null, "item");
                }
            }
            serializer.endTag(null, "perms");
        }
        if (pkg.disabledComponents.size() > 0) {
            serializer.startTag(null, "disabled-components");
            for (String name : pkg.disabledComponents) {
                serializer.startTag(null, "item");
                serializer.attribute(null, "name", name);
                serializer.endTag(null, "item");
            }
            serializer.endTag(null, "disabled-components");
        }
        if (pkg.enabledComponents.size() > 0) {
            serializer.startTag(null, "enabled-components");
            for (String name : pkg.enabledComponents) {
                serializer.startTag(null, "item");
                serializer.attribute(null, "name", name);
                serializer.endTag(null, "item");
            }
            serializer.endTag(null, "enabled-components");
        }
        serializer.endTag(null, "package");
    }

    void writePermissionLPr(XmlSerializer serializer, BasePermission bp) throws XmlPullParserException, IOException {
        if (bp.type != 1 && bp.sourcePackage != null) {
            serializer.startTag(null, "item");
            serializer.attribute(null, "name", bp.name);
            serializer.attribute(null, "package", bp.sourcePackage);
            if (bp.protectionLevel != 0) {
                serializer.attribute(null, "protection", Integer.toString(bp.protectionLevel));
            }
            if (bp.type == 2) {
                PermissionInfo pi;
                PermissionInfo permissionInfo = pi = bp.perm != null ? bp.perm.info : bp.pendingInfo;
                if (pi != null) {
                    serializer.attribute(null, "type", "dynamic");
                    if (pi.icon != 0) {
                        serializer.attribute(null, "icon", Integer.toString(pi.icon));
                    }
                    if (pi.nonLocalizedLabel != null) {
                        serializer.attribute(null, "label", ((Object)pi.nonLocalizedLabel).toString());
                    }
                }
            }
            serializer.endTag(null, "item");
        }
    }

    ArrayList<PackageSetting> getListOfIncompleteInstallPackagesLPr() {
        HashSet<String> kList = new HashSet<String>(this.mPackages.keySet());
        Iterator<String> its = kList.iterator();
        ArrayList<PackageSetting> ret = new ArrayList<PackageSetting>();
        while (its.hasNext()) {
            String key = its.next();
            PackageSetting ps = this.mPackages.get(key);
            if (ps.getInstallStatus() != 0) continue;
            ret.add(ps);
        }
        return ret;
    }

    boolean readLPw() {
        FileInputStream str = null;
        if (this.mBackupSettingsFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupSettingsFilename);
                this.mReadMessages.append("Reading from backup settings file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup settings file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w((String)"PackageManager", (String)("Cleaning up settings file " + this.mSettingsFilename));
                    this.mSettingsFilename.delete();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.mPendingPackages.clear();
        this.mPastSignatures.clear();
        try {
            int type;
            if (str == null) {
                if (!this.mSettingsFilename.exists()) {
                    this.mReadMessages.append("No settings file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No settings file; creating initial state");
                    return false;
                }
                str = new FileInputStream(this.mSettingsFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in settings file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager settings");
                Log.wtf((String)"PackageManager", (String)"No start tag found in package manager settings");
                return false;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("package")) {
                    this.readPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("permissions")) {
                    this.readPermissionsLPw(this.mPermissions, parser);
                    continue;
                }
                if (tagName.equals("permission-trees")) {
                    this.readPermissionsLPw(this.mPermissionTrees, parser);
                    continue;
                }
                if (tagName.equals("shared-user")) {
                    this.readSharedUserLPw(parser);
                    continue;
                }
                if (tagName.equals("preferred-packages")) continue;
                if (tagName.equals("preferred-activities")) {
                    this.readPreferredActivitiesLPw(parser);
                    continue;
                }
                if (tagName.equals("updated-package")) {
                    this.readDisabledSysPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("cleaning-package")) {
                    String name = parser.getAttributeValue(null, "name");
                    if (name == null) continue;
                    this.mPackagesToBeCleaned.add(name);
                    continue;
                }
                if (tagName.equals("renamed-package")) {
                    String nname = parser.getAttributeValue(null, "new");
                    String oname = parser.getAttributeValue(null, "old");
                    if (nname == null || oname == null) continue;
                    this.mRenamedPackages.put(nname, oname);
                    continue;
                }
                if (tagName.equals("last-platform-version")) {
                    this.mExternalSdkPlatform = 0;
                    this.mInternalSdkPlatform = 0;
                    try {
                        String external;
                        String internal = parser.getAttributeValue(null, "internal");
                        if (internal != null) {
                            this.mInternalSdkPlatform = Integer.parseInt(internal);
                        }
                        if ((external = parser.getAttributeValue(null, "external")) == null) continue;
                        this.mExternalSdkPlatform = Integer.parseInt(external);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (tagName.equals("verifier")) {
                    String deviceIdentity = parser.getAttributeValue(null, "device");
                    try {
                        this.mVerifierDeviceIdentity = VerifierDeviceIdentity.parse((String)deviceIdentity);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w((String)"PackageManager", (String)("Discard invalid verifier device id: " + e.getMessage()));
                    }
                    continue;
                }
                Slog.w((String)"PackageManager", (String)("Unknown element under <packages>: " + parser.getName()));
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + (Object)((Object)e));
            Log.wtf((String)"PackageManager", (String)"Error reading package manager settings", (Throwable)e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Log.wtf((String)"PackageManager", (String)"Error reading package manager settings", (Throwable)e);
        }
        int N = this.mPendingPackages.size();
        for (int i = 0; i < N; ++i) {
            String msg;
            PendingPackage pp = this.mPendingPackages.get(i);
            Object idObj = this.getUserIdLPr(pp.sharedId);
            if (idObj != null && idObj instanceof SharedUserSetting) {
                PackageSetting p = this.getPackageLPw(pp.name, null, pp.realName, (SharedUserSetting)idObj, pp.codePath, pp.resourcePath, pp.nativeLibraryPathString, pp.versionCode, pp.pkgFlags, true, true);
                if (p == null) {
                    PackageManagerService.reportSettingsProblem(5, "Unable to create application package for " + pp.name);
                    continue;
                }
                p.copyFrom(pp);
                continue;
            }
            if (idObj != null) {
                msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not a shared uid\n";
                this.mReadMessages.append(msg);
                PackageManagerService.reportSettingsProblem(6, msg);
                continue;
            }
            msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not defined\n";
            this.mReadMessages.append(msg);
            PackageManagerService.reportSettingsProblem(6, msg);
        }
        this.mPendingPackages.clear();
        for (PackageSetting disabledPs : this.mDisabledSysPackages.values()) {
            Object id = this.getUserIdLPr(disabledPs.userId);
            if (id == null || !(id instanceof SharedUserSetting)) continue;
            disabledPs.sharedUser = (SharedUserSetting)id;
        }
        this.readStoppedLPw();
        this.mReadMessages.append("Read completed successfully: " + this.mPackages.size() + " packages, " + this.mSharedUsers.size() + " shared uids\n");
        return true;
    }

    private int readInt(XmlPullParser parser, String ns, String name, int defValue) {
        String v = parser.getAttributeValue(ns, name);
        try {
            if (v == null) {
                return defValue;
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: attribute " + name + " has bad integer value " + v + " at " + parser.getPositionDescription());
            return defValue;
        }
    }

    private void readPermissionsLPw(HashMap<String, BasePermission> out, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("item")) {
                String name = parser.getAttributeValue(null, "name");
                String sourcePackage = parser.getAttributeValue(null, "package");
                String ptype = parser.getAttributeValue(null, "type");
                if (name != null && sourcePackage != null) {
                    boolean dynamic = "dynamic".equals(ptype);
                    BasePermission bp = new BasePermission(name, sourcePackage, dynamic ? 2 : 0);
                    bp.protectionLevel = this.readInt(parser, null, "protection", 0);
                    if (dynamic) {
                        PermissionInfo pi = new PermissionInfo();
                        pi.packageName = sourcePackage.intern();
                        pi.name = name.intern();
                        pi.icon = this.readInt(parser, null, "icon", 0);
                        pi.nonLocalizedLabel = parser.getAttributeValue(null, "label");
                        pi.protectionLevel = bp.protectionLevel;
                        bp.pendingInfo = pi;
                    }
                    out.put(bp.name, bp);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: permissions has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element reading permissions: " + parser.getName() + " at " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readDisabledSysPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String idStr;
        String name = parser.getAttributeValue(null, "name");
        String realName = parser.getAttributeValue(null, "realName");
        String codePathStr = parser.getAttributeValue(null, "codePath");
        String resourcePathStr = parser.getAttributeValue(null, "resourcePath");
        String nativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
        if (resourcePathStr == null) {
            resourcePathStr = codePathStr;
        }
        String version = parser.getAttributeValue(null, "version");
        int versionCode = 0;
        if (version != null) {
            try {
                versionCode = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int pkgFlags = 0;
        PackageSetting ps = new PackageSetting(name, realName, new File(codePathStr), new File(resourcePathStr), nativeLibraryPathStr, versionCode, pkgFlags |= 1);
        String timeStampStr = parser.getAttributeValue(null, "ft");
        if (timeStampStr != null) {
            try {
                long timeStamp = Long.parseLong(timeStampStr, 16);
                ps.setTimeStamp(timeStamp);
            }
            catch (NumberFormatException e) {}
        } else {
            timeStampStr = parser.getAttributeValue(null, "ts");
            if (timeStampStr != null) {
                try {
                    long timeStamp = Long.parseLong(timeStampStr);
                    ps.setTimeStamp(timeStamp);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
            try {
                ps.firstInstallTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
            try {
                ps.lastUpdateTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int n = ps.userId = (idStr = parser.getAttributeValue(null, "userId")) != null ? Integer.parseInt(idStr) : 0;
        if (ps.userId <= 0) {
            String sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            ps.userId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("perms")) {
                this.readGrantedPermissionsLPw(parser, ps.grantedPermissions);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <updated-package>: " + parser.getName());
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
        this.mDisabledSysPackages.put(name, ps);
    }

    private void readPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String realName = null;
        String idStr = null;
        String sharedIdStr = null;
        String codePathStr = null;
        String resourcePathStr = null;
        String nativeLibraryPathStr = null;
        String systemStr = null;
        String installerPackageName = null;
        String uidError = null;
        int pkgFlags = 0;
        long timeStamp = 0L;
        long firstInstallTime = 0L;
        long lastUpdateTime = 0L;
        PackageSettingBase packageSetting = null;
        String version = null;
        int versionCode = 0;
        try {
            int userId;
            name = parser.getAttributeValue(null, "name");
            realName = parser.getAttributeValue(null, "realName");
            idStr = parser.getAttributeValue(null, "userId");
            uidError = parser.getAttributeValue(null, "uidError");
            sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            codePathStr = parser.getAttributeValue(null, "codePath");
            resourcePathStr = parser.getAttributeValue(null, "resourcePath");
            nativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
            version = parser.getAttributeValue(null, "version");
            if (version != null) {
                try {
                    versionCode = Integer.parseInt(version);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            installerPackageName = parser.getAttributeValue(null, "installer");
            systemStr = parser.getAttributeValue(null, "flags");
            if (systemStr != null) {
                try {
                    pkgFlags = Integer.parseInt(systemStr);
                }
                catch (NumberFormatException e) {}
            } else {
                systemStr = parser.getAttributeValue(null, "system");
                pkgFlags = systemStr != null ? (pkgFlags |= "true".equalsIgnoreCase(systemStr) ? 1 : 0) : (pkgFlags |= 1);
            }
            String timeStampStr = parser.getAttributeValue(null, "ft");
            if (timeStampStr != null) {
                try {
                    timeStamp = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException e) {}
            } else {
                timeStampStr = parser.getAttributeValue(null, "ts");
                if (timeStampStr != null) {
                    try {
                        timeStamp = Long.parseLong(timeStampStr);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
                try {
                    firstInstallTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
                try {
                    lastUpdateTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if (resourcePathStr == null) {
                resourcePathStr = codePathStr;
            }
            if (realName != null) {
                realName = realName.intern();
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no name at " + parser.getPositionDescription());
            } else if (codePathStr == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no codePath at " + parser.getPositionDescription());
            } else if (userId > 0) {
                packageSetting = this.addPackageLPw(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), nativeLibraryPathStr, userId, versionCode, pkgFlags);
                if (packageSetting == null) {
                    PackageManagerService.reportSettingsProblem(6, "Failure adding uid " + userId + " while parsing settings at " + parser.getPositionDescription());
                } else {
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                }
            } else if (sharedIdStr != null) {
                int n2 = userId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
                if (userId > 0) {
                    packageSetting = new PendingPackage(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), nativeLibraryPathStr, userId, versionCode, pkgFlags);
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                    this.mPendingPackages.add((PendingPackage)packageSetting);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad sharedId " + sharedIdStr + " at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (packageSetting != null) {
            int type;
            String installStatusStr;
            block51: {
                packageSetting.uidError = "true".equals(uidError);
                packageSetting.installerPackageName = installerPackageName;
                packageSetting.nativeLibraryPathString = nativeLibraryPathStr;
                String enabledStr = parser.getAttributeValue(null, "enabled");
                if (enabledStr != null) {
                    try {
                        packageSetting.enabled = Integer.parseInt(enabledStr);
                    }
                    catch (NumberFormatException e) {
                        if (enabledStr.equalsIgnoreCase("true")) {
                            packageSetting.enabled = 1;
                            break block51;
                        }
                        if (enabledStr.equalsIgnoreCase("false")) {
                            packageSetting.enabled = 2;
                            break block51;
                        }
                        if (enabledStr.equalsIgnoreCase("default")) {
                            packageSetting.enabled = 0;
                            break block51;
                        }
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad enabled value: " + idStr + " at " + parser.getPositionDescription());
                    }
                } else {
                    packageSetting.enabled = 0;
                }
            }
            if ((installStatusStr = parser.getAttributeValue(null, "installStatus")) != null) {
                packageSetting.installStatus = installStatusStr.equalsIgnoreCase("false") ? 0 : 1;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("disabled-components")) {
                    this.readDisabledComponentsLPw(packageSetting, parser);
                    continue;
                }
                if (tagName.equals("enabled-components")) {
                    this.readEnabledComponentsLPw(packageSetting, parser);
                    continue;
                }
                if (tagName.equals("sigs")) {
                    packageSetting.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals("perms")) {
                    this.readGrantedPermissionsLPw(parser, packageSetting.grantedPermissions);
                    packageSetting.permissionsFixed = true;
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <package>: " + parser.getName());
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        } else {
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readDisabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("item")) {
                String name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    packageSetting.disabledComponents.add(name.intern());
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <disabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <disabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readEnabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("item")) {
                String name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    packageSetting.enabledComponents.add(name.intern());
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <enabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <enabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readSharedUserLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String idStr = null;
        int pkgFlags = 0;
        SharedUserSetting su = null;
        try {
            int userId;
            name = parser.getAttributeValue(null, "name");
            idStr = parser.getAttributeValue(null, "userId");
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if ("true".equals(parser.getAttributeValue(null, "system"))) {
                pkgFlags |= 1;
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <shared-user> has no name at " + parser.getPositionDescription());
            } else if (userId == 0) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: shared-user " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            } else {
                su = this.addSharedUserLPw(name.intern(), userId, pkgFlags);
                if (su == null) {
                    PackageManagerService.reportSettingsProblem(6, "Occurred while parsing settings at " + parser.getPositionDescription());
                }
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (su != null) {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("sigs")) {
                    su.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals("perms")) {
                    this.readGrantedPermissionsLPw(parser, su.grantedPermissions);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <shared-user>: " + parser.getName());
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        } else {
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readGrantedPermissionsLPw(XmlPullParser parser, HashSet<String> outPerms) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("item")) {
                String name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    outPerms.add(name.intern());
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <perms> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <perms>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private void readPreferredActivitiesLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("item")) {
                PreferredActivity pa = new PreferredActivity(parser);
                if (pa.mPref.getParseError() == null) {
                    this.mPreferredActivities.addFilter(pa);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <preferred-activity> " + pa.mPref.getParseError() + " at " + parser.getPositionDescription());
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private int newUserIdLPw(Object obj) {
        int N = this.mUserIds.size();
        for (int i = 0; i < N; ++i) {
            if (this.mUserIds.get(i) != null) continue;
            this.mUserIds.set(i, obj);
            return 10000 + i;
        }
        if (N >= 1000) {
            return -1;
        }
        this.mUserIds.add(obj);
        return 10000 + N;
    }

    public VerifierDeviceIdentity getVerifierDeviceIdentityLPw() {
        if (this.mVerifierDeviceIdentity == null) {
            this.mVerifierDeviceIdentity = VerifierDeviceIdentity.generate();
            this.writeLPr();
        }
        return this.mVerifierDeviceIdentity;
    }

    public PackageSetting getDisabledSystemPkgLPr(String name) {
        PackageSetting ps = this.mDisabledSysPackages.get(name);
        return ps;
    }

    boolean isEnabledLPr(ComponentInfo componentInfo, int flags) {
        if ((flags & 0x200) != 0) {
            return true;
        }
        PackageSetting packageSettings = this.mPackages.get(componentInfo.packageName);
        if (packageSettings == null) {
            return false;
        }
        if (packageSettings.enabled == 2 || packageSettings.enabled == 3 || packageSettings.pkg != null && !packageSettings.pkg.applicationInfo.enabled && packageSettings.enabled == 0) {
            return false;
        }
        if (packageSettings.enabledComponents.contains(componentInfo.name)) {
            return true;
        }
        if (packageSettings.disabledComponents.contains(componentInfo.name)) {
            return false;
        }
        return componentInfo.enabled;
    }

    String getInstallerPackageNameLPr(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.installerPackageName;
    }

    int getApplicationEnabledSettingLPr(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.enabled;
    }

    int getComponentEnabledSettingLPr(ComponentName componentName) {
        String packageName = componentName.getPackageName();
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown component: " + componentName);
        }
        String classNameStr = componentName.getClassName();
        return pkg.getCurrentEnabledStateLPr(classNameStr);
    }

    boolean setPackageStoppedStateLPw(String packageName, boolean stopped, boolean allowedByPermission, int uid) {
        PackageSetting pkgSetting = this.mPackages.get(packageName);
        if (pkgSetting == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        if (!allowedByPermission && uid != pkgSetting.userId) {
            throw new SecurityException("Permission Denial: attempt to change stopped state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.userId);
        }
        if (pkgSetting.stopped != stopped) {
            pkgSetting.stopped = stopped;
            pkgSetting.pkg.mSetStopped = stopped;
            if (pkgSetting.notLaunched) {
                if (pkgSetting.installerPackageName != null) {
                    PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_FIRST_LAUNCH", pkgSetting.name, null, pkgSetting.installerPackageName, null);
                }
                pkgSetting.notLaunched = false;
            }
            return true;
        }
        return false;
    }

    void dumpPackagesLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        boolean printedSomething = false;
        for (PackageSetting packageSetting : this.mPackages.values()) {
            if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name)) continue;
            if (packageName != null) {
                dumpState.setSharedUser(packageSetting.sharedUser);
            }
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println(" ");
                }
                pw.println("Packages:");
                printedSomething = true;
            }
            pw.print("  Package [");
            pw.print(packageSetting.realName != null ? packageSetting.realName : packageSetting.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(packageSetting)));
            pw.println("):");
            if (packageSetting.realName != null) {
                pw.print("    compat name=");
                pw.println(packageSetting.name);
            }
            pw.print("    userId=");
            pw.print(packageSetting.userId);
            pw.print(" gids=");
            pw.println(PackageManagerService.arrayToString(packageSetting.gids));
            pw.print("    sharedUser=");
            pw.println(packageSetting.sharedUser);
            pw.print("    pkg=");
            pw.println(packageSetting.pkg);
            pw.print("    codePath=");
            pw.println(packageSetting.codePathString);
            pw.print("    resourcePath=");
            pw.println(packageSetting.resourcePathString);
            pw.print("    nativeLibraryPath=");
            pw.println(packageSetting.nativeLibraryPathString);
            pw.print("    versionCode=");
            pw.println(packageSetting.versionCode);
            if (packageSetting.pkg != null) {
                pw.print("    versionName=");
                pw.println(packageSetting.pkg.mVersionName);
                pw.print("    dataDir=");
                pw.println(packageSetting.pkg.applicationInfo.dataDir);
                pw.print("    targetSdk=");
                pw.println(packageSetting.pkg.applicationInfo.targetSdkVersion);
                if (packageSetting.pkg.mOperationPending) {
                    pw.println("    mOperationPending=true");
                }
                pw.print("    supportsScreens=[");
                boolean first = true;
                if ((packageSetting.pkg.applicationInfo.flags & 0x200) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("small");
                }
                if ((packageSetting.pkg.applicationInfo.flags & 0x400) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("medium");
                }
                if ((packageSetting.pkg.applicationInfo.flags & 0x800) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("large");
                }
                if ((packageSetting.pkg.applicationInfo.flags & 0x80000) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("xlarge");
                }
                if ((packageSetting.pkg.applicationInfo.flags & 0x1000) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("resizeable");
                }
                if ((packageSetting.pkg.applicationInfo.flags & 0x2000) != 0) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    pw.print("anyDensity");
                }
            }
            pw.println("]");
            pw.print("    timeStamp=");
            date.setTime(packageSetting.timeStamp);
            pw.println(sdf.format(date));
            pw.print("    firstInstallTime=");
            date.setTime(packageSetting.firstInstallTime);
            pw.println(sdf.format(date));
            pw.print("    lastUpdateTime=");
            date.setTime(packageSetting.lastUpdateTime);
            pw.println(sdf.format(date));
            if (packageSetting.installerPackageName != null) {
                pw.print("    installerPackageName=");
                pw.println(packageSetting.installerPackageName);
            }
            pw.print("    signatures=");
            pw.println(packageSetting.signatures);
            pw.print("    permissionsFixed=");
            pw.print(packageSetting.permissionsFixed);
            pw.print(" haveGids=");
            pw.println(packageSetting.haveGids);
            pw.print("    pkgFlags=0x");
            pw.print(Integer.toHexString(packageSetting.pkgFlags));
            pw.print(" installStatus=");
            pw.print(packageSetting.installStatus);
            pw.print(" stopped=");
            pw.print(packageSetting.stopped);
            pw.print(" enabled=");
            pw.println(packageSetting.enabled);
            if (packageSetting.disabledComponents.size() > 0) {
                pw.println("    disabledComponents:");
                for (String s : packageSetting.disabledComponents) {
                    pw.print("      ");
                    pw.println(s);
                }
            }
            if (packageSetting.enabledComponents.size() > 0) {
                pw.println("    enabledComponents:");
                for (String s : packageSetting.enabledComponents) {
                    pw.print("      ");
                    pw.println(s);
                }
            }
            if (packageSetting.grantedPermissions.size() <= 0) continue;
            pw.println("    grantedPermissions:");
            for (String s : packageSetting.grantedPermissions) {
                pw.print("      ");
                pw.println(s);
            }
        }
        printedSomething = false;
        if (this.mRenamedPackages.size() > 0) {
            for (Map.Entry entry : this.mRenamedPackages.entrySet()) {
                if (packageName != null && !packageName.equals(entry.getKey()) && !packageName.equals(entry.getValue())) continue;
                if (!printedSomething) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println(" ");
                    }
                    pw.println("Renamed packages:");
                    printedSomething = true;
                }
                pw.print("  ");
                pw.print((String)entry.getKey());
                pw.print(" -> ");
                pw.println((String)entry.getValue());
            }
        }
        printedSomething = false;
        if (this.mDisabledSysPackages.size() > 0) {
            for (PackageSetting packageSetting : this.mDisabledSysPackages.values()) {
                if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name)) continue;
                if (!printedSomething) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println(" ");
                    }
                    pw.println("Hidden system packages:");
                    printedSomething = true;
                }
                pw.print("  Package [");
                pw.print(packageSetting.realName != null ? packageSetting.realName : packageSetting.name);
                pw.print("] (");
                pw.print(Integer.toHexString(System.identityHashCode(packageSetting)));
                pw.println("):");
                if (packageSetting.realName != null) {
                    pw.print("    compat name=");
                    pw.println(packageSetting.name);
                }
                pw.print("    userId=");
                pw.println(packageSetting.userId);
                pw.print("    sharedUser=");
                pw.println(packageSetting.sharedUser);
                pw.print("    codePath=");
                pw.println(packageSetting.codePathString);
                pw.print("    resourcePath=");
                pw.println(packageSetting.resourcePathString);
            }
        }
    }

    void dumpPermissionsLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedSomething = false;
        for (BasePermission p : this.mPermissions.values()) {
            if (packageName != null && !packageName.equals(p.sourcePackage)) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println(" ");
                }
                pw.println("Permissions:");
                printedSomething = true;
            }
            pw.print("  Permission [");
            pw.print(p.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(p)));
            pw.println("):");
            pw.print("    sourcePackage=");
            pw.println(p.sourcePackage);
            pw.print("    uid=");
            pw.print(p.uid);
            pw.print(" gids=");
            pw.print(PackageManagerService.arrayToString(p.gids));
            pw.print(" type=");
            pw.print(p.type);
            pw.print(" prot=");
            pw.println(p.protectionLevel);
            if (p.packageSetting != null) {
                pw.print("    packageSetting=");
                pw.println(p.packageSetting);
            }
            if (p.perm == null) continue;
            pw.print("    perm=");
            pw.println(p.perm);
        }
    }

    void dumpSharedUsersLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedSomething = false;
        for (SharedUserSetting su : this.mSharedUsers.values()) {
            if (packageName != null && su != dumpState.getSharedUser()) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println(" ");
                }
                pw.println("Shared users:");
                printedSomething = true;
            }
            pw.print("  SharedUser [");
            pw.print(su.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(su)));
            pw.println("):");
            pw.print("    userId=");
            pw.print(su.userId);
            pw.print(" gids=");
            pw.println(PackageManagerService.arrayToString(su.gids));
            pw.println("    grantedPermissions:");
            for (String s : su.grantedPermissions) {
                pw.print("      ");
                pw.println(s);
            }
        }
    }

    void dumpReadMessagesLPr(PrintWriter pw, PackageManagerService.DumpState dumpState) {
        pw.println("Settings parse messages:");
        pw.print(this.mReadMessages.toString());
    }
}

