/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.Environment;
import android.os.FileUtils;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.pm.Installer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager {
    private static final String TAG_NAME = "name";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ID = "id";
    private static final String TAG_USERS = "users";
    private static final String TAG_USER = "user";
    private static final String LOG_TAG = "UserManager";
    private static final String USER_INFO_DIR = "system" + File.separator + "users";
    private static final String USER_LIST_FILENAME = "userlist.xml";
    private SparseArray<UserInfo> mUsers;
    private final File mUsersDir;
    private final File mUserListFile;
    private int[] mUserIds;
    private Installer mInstaller;
    private File mBaseUserPath;

    UserManager(File dataDir, File baseUserPath) {
        this.mUsersDir = new File(dataDir, USER_INFO_DIR);
        this.mUsersDir.mkdirs();
        this.mBaseUserPath = baseUserPath;
        FileUtils.setPermissions((String)this.mUsersDir.toString(), (int)509, (int)-1, (int)-1);
        this.mUserListFile = new File(this.mUsersDir, USER_LIST_FILENAME);
        this.readUserList();
    }

    public UserManager(Installer installer, File baseUserPath) {
        this(Environment.getDataDirectory(), baseUserPath);
        this.mInstaller = installer;
    }

    public List<UserInfo> getUsers() {
        ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
        for (int i = 0; i < this.mUsers.size(); ++i) {
            users.add((UserInfo)this.mUsers.valueAt(i));
        }
        return users;
    }

    int[] getUserIds() {
        return this.mUserIds;
    }

    private void readUserList() {
        this.mUsers = new SparseArray();
        if (!this.mUserListFile.exists()) {
            this.fallbackToSingleUser();
            return;
        }
        FileInputStream fis = null;
        try {
            int type;
            fis = new FileInputStream(this.mUserListFile);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e((String)LOG_TAG, (String)"Unable to read user list");
                this.fallbackToSingleUser();
                return;
            }
            while ((type = parser.next()) != 1) {
                String id;
                UserInfo user;
                if (type != 2 || !parser.getName().equals(TAG_USER) || (user = this.readUser(Integer.parseInt(id = parser.getAttributeValue(null, ATTR_ID)))) == null) continue;
                this.mUsers.put(user.id, (Object)user);
            }
            this.updateUserIds();
        }
        catch (IOException ioe) {
            this.fallbackToSingleUser();
        }
        catch (XmlPullParserException pe) {
            this.fallbackToSingleUser();
        }
    }

    private void fallbackToSingleUser() {
        UserInfo primary = new UserInfo(0, "Primary", 3);
        this.mUsers.put(0, (Object)primary);
        this.updateUserIds();
        this.writeUserList();
        this.writeUser(primary);
    }

    private void writeUser(UserInfo userInfo) {
        try {
            File mUserFile = new File(this.mUsersDir, userInfo.id + ".xml");
            FileOutputStream fos = new FileOutputStream(mUserFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput((OutputStream)bos, "utf-8");
            serializer.startDocument(null, Boolean.valueOf(true));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USER);
            serializer.attribute(null, ATTR_ID, Integer.toString(userInfo.id));
            serializer.attribute(null, ATTR_FLAGS, Integer.toString(userInfo.flags));
            serializer.startTag(null, TAG_NAME);
            serializer.text(userInfo.name);
            serializer.endTag(null, TAG_NAME);
            serializer.endTag(null, TAG_USER);
            serializer.endDocument();
        }
        catch (IOException ioe) {
            Slog.e((String)LOG_TAG, (String)("Error writing user info " + userInfo.id + "\n" + ioe));
        }
    }

    private void writeUserList() {
        try {
            FileOutputStream fos = new FileOutputStream(this.mUserListFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput((OutputStream)bos, "utf-8");
            serializer.startDocument(null, Boolean.valueOf(true));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USERS);
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = (UserInfo)this.mUsers.valueAt(i);
                serializer.startTag(null, TAG_USER);
                serializer.attribute(null, ATTR_ID, Integer.toString(user.id));
                serializer.endTag(null, TAG_USER);
            }
            serializer.endTag(null, TAG_USERS);
            serializer.endDocument();
        }
        catch (IOException ioe) {
            Slog.e((String)LOG_TAG, (String)"Error writing user list");
        }
    }

    private UserInfo readUser(int id) {
        int flags = 0;
        String name = null;
        FileInputStream fis = null;
        try {
            int type;
            File userFile = new File(this.mUsersDir, Integer.toString(id) + ".xml");
            fis = new FileInputStream(userFile);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e((String)LOG_TAG, (String)("Unable to read user " + id));
                return null;
            }
            if (type == 2 && parser.getName().equals(TAG_USER)) {
                String storedId = parser.getAttributeValue(null, ATTR_ID);
                if (Integer.parseInt(storedId) != id) {
                    Slog.e((String)LOG_TAG, (String)"User id does not match the file name");
                    return null;
                }
                String flagString = parser.getAttributeValue(null, ATTR_FLAGS);
                flags = Integer.parseInt(flagString);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type == 2 && parser.getName().equals(TAG_NAME) && (type = parser.next()) == 4) {
                    name = parser.getText();
                }
            }
            fis.close();
            UserInfo userInfo = new UserInfo(id, name, flags);
            return userInfo;
        }
        catch (IOException ioe) {
        }
        catch (XmlPullParserException pe) {
            // empty catch block
        }
        return null;
    }

    public UserInfo createUser(String name, int flags, List<ApplicationInfo> apps) {
        int userId = this.getNextAvailableId();
        UserInfo userInfo = new UserInfo(userId, name, flags);
        File userPath = new File(this.mBaseUserPath, Integer.toString(userId));
        if (!this.createPackageFolders(userId, userPath, apps)) {
            return null;
        }
        this.mUsers.put(userId, (Object)userInfo);
        this.writeUserList();
        this.writeUser(userInfo);
        this.updateUserIds();
        return userInfo;
    }

    public void removeUser(int id) {
        UserInfo userInfo = (UserInfo)this.mUsers.get(id);
        if (userInfo != null) {
            this.mUsers.remove(id);
            File userFile = new File(this.mUsersDir, id + ".xml");
            userFile.delete();
            this.writeUserList();
            this.removePackageFolders(id);
            this.updateUserIds();
        }
    }

    public void installPackageForAllUsers(String packageName, int uid) {
        for (int userId : this.mUserIds) {
            if (userId == 0) continue;
            this.mInstaller.createUserData(packageName, PackageManager.getUid((int)userId, (int)uid), userId);
        }
    }

    public void clearUserDataForAllUsers(String packageName) {
        for (int userId : this.mUserIds) {
            if (userId == 0) continue;
            this.mInstaller.clearUserData(packageName, userId);
        }
    }

    public void removePackageForAllUsers(String packageName) {
        for (int userId : this.mUserIds) {
            if (userId == 0) continue;
            this.mInstaller.remove(packageName, userId);
        }
    }

    private void updateUserIds() {
        if (this.mUserIds == null || this.mUserIds.length != this.mUsers.size()) {
            this.mUserIds = new int[this.mUsers.size()];
        }
        for (int i = 0; i < this.mUsers.size(); ++i) {
            this.mUserIds[i] = this.mUsers.keyAt(i);
        }
    }

    private int getNextAvailableId() {
        int i;
        for (i = 0; i < Integer.MAX_VALUE && this.mUsers.indexOfKey(i) >= 0; ++i) {
        }
        return i;
    }

    private boolean createPackageFolders(int id, File userPath, List<ApplicationInfo> apps) {
        if (this.mInstaller == null || apps == null) {
            return true;
        }
        long startTime = SystemClock.elapsedRealtime();
        userPath.mkdir();
        FileUtils.setPermissions((String)userPath.toString(), (int)505, (int)-1, (int)-1);
        for (ApplicationInfo app : apps) {
            if (app.uid <= 10000 || app.uid >= 100000) continue;
            this.mInstaller.createUserData(app.packageName, PackageManager.getUid((int)id, (int)app.uid), id);
        }
        long stopTime = SystemClock.elapsedRealtime();
        Log.i((String)LOG_TAG, (String)("Time to create " + apps.size() + " packages = " + (stopTime - startTime) + "ms"));
        return true;
    }

    private boolean removePackageFolders(int id) {
        if (this.mInstaller == null) {
            return true;
        }
        this.mInstaller.removeUserDataDirs(id);
        return true;
    }
}

