/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.usb.UsbAccessory;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.usb.UsbSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;

public class UsbDeviceManager {
    private static final String TAG = UsbDeviceManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String USB_STATE_MATCH = "DEVPATH=/devices/virtual/android_usb/android0";
    private static final String ACCESSORY_START_MATCH = "DEVPATH=/devices/virtual/misc/usb_accessory";
    private static final String FUNCTIONS_PATH = "/sys/class/android_usb/android0/functions";
    private static final String STATE_PATH = "/sys/class/android_usb/android0/state";
    private static final String MASS_STORAGE_FILE_PATH = "/sys/class/android_usb/android0/f_mass_storage/lun/file";
    private static final String RNDIS_ETH_ADDR_PATH = "/sys/class/android_usb/android0/f_rndis/ethaddr";
    private static final int MSG_UPDATE_STATE = 0;
    private static final int MSG_ENABLE_ADB = 1;
    private static final int MSG_SET_CURRENT_FUNCTION = 2;
    private static final int MSG_SYSTEM_READY = 3;
    private static final int MSG_BOOT_COMPLETED = 4;
    private static final int UPDATE_DELAY = 1000;
    private UsbHandler mHandler;
    private boolean mBootCompleted;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final UsbSettingsManager mSettingsManager;
    private NotificationManager mNotificationManager;
    private final boolean mHasUsbAccessory;
    private boolean mUseUsbNotification;
    private boolean mAdbEnabled;
    private final UEventObserver mUEventObserver = new UEventObserver(){

        public void onUEvent(UEventObserver.UEvent event) {
            String state = event.get("USB_STATE");
            String accessory = event.get("ACCESSORY");
            if (state != null) {
                UsbDeviceManager.this.mHandler.updateState(state);
            } else if ("START".equals(accessory)) {
                UsbDeviceManager.this.setCurrentFunction("accessory", false);
            }
        }
    };

    public UsbDeviceManager(Context context, UsbSettingsManager settingsManager) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mSettingsManager = settingsManager;
        PackageManager pm = this.mContext.getPackageManager();
        this.mHasUsbAccessory = pm.hasSystemFeature("android.hardware.usb.accessory");
        UsbDeviceManager.initRndisAddress();
        HandlerThread thread = new HandlerThread("UsbDeviceManager", 10);
        thread.start();
        this.mHandler = new UsbHandler(thread.getLooper());
        if (this.nativeIsStartRequested()) {
            this.setCurrentFunction("accessory", false);
        }
    }

    public void systemReady() {
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        boolean massStorageSupported = false;
        StorageManager storageManager = (StorageManager)this.mContext.getSystemService("storage");
        StorageVolume[] volumes = storageManager.getVolumeList();
        if (volumes.length > 0) {
            massStorageSupported = volumes[0].allowMassStorage();
        }
        this.mUseUsbNotification = !massStorageSupported;
        Settings.Secure.putInt((ContentResolver)this.mContentResolver, (String)"adb_enabled", (int)(this.mAdbEnabled ? 1 : 0));
        this.mHandler.sendEmptyMessage(3);
    }

    private static void initRndisAddress() {
        int ETH_ALEN = 6;
        int[] address = new int[6];
        address[0] = 2;
        String serial = SystemProperties.get((String)"ro.serialno", (String)"1234567890ABCDEF");
        int serialLength = serial.length();
        for (int i = 0; i < serialLength; ++i) {
            int n = i % 5 + 1;
            address[n] = address[n] ^ serial.charAt(i);
        }
        String addrString = String.format("%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
        try {
            FileUtils.stringToFile((String)RNDIS_ETH_ADDR_PATH, (String)addrString);
        }
        catch (IOException e) {
            Slog.e((String)TAG, (String)"failed to write to /sys/class/android_usb/android0/f_rndis/ethaddr");
        }
    }

    private static String addFunction(String functions, String function) {
        if (!UsbDeviceManager.containsFunction(functions, function)) {
            if (functions.length() > 0) {
                functions = functions + ",";
            }
            functions = functions + function;
        }
        return functions;
    }

    private static String removeFunction(String functions, String function) {
        String[] split = functions.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (!function.equals(split[i])) continue;
            split[i] = null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (s == null) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private static boolean containsFunction(String functions, String function) {
        int index = functions.indexOf(function);
        if (index < 0) {
            return false;
        }
        if (index > 0 && functions.charAt(index - 1) != ',') {
            return false;
        }
        int charAfter = index + function.length();
        return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
    }

    public UsbAccessory getCurrentAccessory() {
        return this.mHandler.getCurrentAccessory();
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        UsbAccessory currentAccessory = this.mHandler.getCurrentAccessory();
        if (currentAccessory == null) {
            throw new IllegalArgumentException("no accessory attached");
        }
        if (!currentAccessory.equals((Object)accessory)) {
            String error = accessory.toString() + " does not match current accessory " + currentAccessory;
            throw new IllegalArgumentException(error);
        }
        this.mSettingsManager.checkPermission(accessory);
        return this.nativeOpenAccessory();
    }

    public void setCurrentFunction(String function, boolean makeDefault) {
        this.mHandler.sendMessage(2, function, makeDefault);
    }

    public void setMassStorageBackingFile(String path) {
        if (path == null) {
            path = "";
        }
        try {
            FileUtils.stringToFile((String)MASS_STORAGE_FILE_PATH, (String)path);
        }
        catch (IOException e) {
            Slog.e((String)TAG, (String)"failed to write to /sys/class/android_usb/android0/f_mass_storage/lun/file");
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw) {
        if (this.mHandler != null) {
            this.mHandler.dump(fd, pw);
        }
    }

    private native String[] nativeGetAccessoryStrings();

    private native ParcelFileDescriptor nativeOpenAccessory();

    private native boolean nativeIsStartRequested();

    private final class UsbHandler
    extends Handler {
        private boolean mConnected;
        private boolean mConfigured;
        private String mCurrentFunctions;
        private String mDefaultFunctions;
        private UsbAccessory mCurrentAccessory;
        private int mUsbNotificationId;
        private boolean mAdbNotificationShown;
        private final BroadcastReceiver mBootCompletedReceiver;

        public UsbHandler(Looper looper) {
            super(looper);
            this.mBootCompletedReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    UsbDeviceManager.this.mHandler.sendEmptyMessage(4);
                }
            };
            try {
                this.mDefaultFunctions = SystemProperties.get((String)"persist.sys.usb.config", (String)"adb");
                String config = SystemProperties.get((String)"sys.usb.config", (String)"none");
                if (!config.equals(this.mDefaultFunctions)) {
                    Slog.w((String)TAG, (String)("resetting config to persistent property: " + this.mDefaultFunctions));
                    SystemProperties.set((String)"sys.usb.config", (String)this.mDefaultFunctions);
                }
                this.mCurrentFunctions = this.mDefaultFunctions;
                String state = FileUtils.readTextFile((File)new File(UsbDeviceManager.STATE_PATH), (int)0, null).trim();
                this.updateState(state);
                UsbDeviceManager.this.mAdbEnabled = UsbDeviceManager.containsFunction(this.mCurrentFunctions, "adb");
                String value = SystemProperties.get((String)"persist.service.adb.enable", (String)"");
                if (value.length() > 0) {
                    char enable = value.charAt(0);
                    if (enable == '1') {
                        this.setAdbEnabled(true);
                    } else if (enable == '0') {
                        this.setAdbEnabled(false);
                    }
                    SystemProperties.set((String)"persist.service.adb.enable", (String)"");
                }
                UsbDeviceManager.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor((String)"adb_enabled"), false, (ContentObserver)new AdbSettingsObserver());
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.USB_STATE_MATCH);
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.ACCESSORY_START_MATCH);
                UsbDeviceManager.this.mContext.registerReceiver(this.mBootCompletedReceiver, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
            }
            catch (Exception e) {
                Slog.e((String)TAG, (String)"Error initializing UsbHandler", (Throwable)e);
            }
        }

        public void sendMessage(int what, boolean arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, (int)what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, (int)what);
            m.obj = arg;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg0, boolean arg1) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, (int)what);
            m.obj = arg0;
            m.arg1 = arg1 ? 1 : 0;
            this.sendMessage(m);
        }

        public void updateState(String state) {
            int configured;
            int connected;
            if ("DISCONNECTED".equals(state)) {
                connected = 0;
                configured = 0;
            } else if ("CONNECTED".equals(state)) {
                connected = 1;
                configured = 0;
            } else if ("CONFIGURED".equals(state)) {
                connected = 1;
                configured = 1;
            } else {
                Slog.e((String)TAG, (String)("unknown state " + state));
                return;
            }
            this.removeMessages(0);
            Message msg = Message.obtain((Handler)this, (int)0);
            msg.arg1 = connected;
            msg.arg2 = configured;
            this.sendMessageDelayed(msg, connected == 0 ? 1000L : 0L);
        }

        private boolean waitForState(String state) {
            for (int i = 0; i < 20; ++i) {
                if (state.equals(SystemProperties.get((String)"sys.usb.state"))) {
                    return true;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Slog.e((String)TAG, (String)("waitForState(" + state + ") FAILED"));
            return false;
        }

        private boolean setUsbConfig(String config) {
            SystemProperties.set((String)"sys.usb.config", (String)config);
            return this.waitForState(config);
        }

        private void setAdbEnabled(boolean enable) {
            if (enable != UsbDeviceManager.this.mAdbEnabled) {
                UsbDeviceManager.this.mAdbEnabled = enable;
                this.setEnabledFunctions(this.mDefaultFunctions, true);
                this.updateAdbNotification();
            }
        }

        private void setEnabledFunctions(String functions, boolean makeDefault) {
            if (functions != null && makeDefault) {
                functions = UsbDeviceManager.this.mAdbEnabled ? UsbDeviceManager.addFunction(functions, "adb") : UsbDeviceManager.removeFunction(functions, "adb");
                if (!this.mDefaultFunctions.equals(functions)) {
                    if (!this.setUsbConfig("none")) {
                        Slog.e((String)TAG, (String)"Failed to disable USB");
                        this.setUsbConfig(this.mCurrentFunctions);
                        return;
                    }
                    SystemProperties.set((String)"persist.sys.usb.config", (String)functions);
                    if (this.waitForState(functions)) {
                        this.mCurrentFunctions = functions;
                        this.mDefaultFunctions = functions;
                    } else {
                        Slog.e((String)TAG, (String)("Failed to switch persistent USB config to " + functions));
                        SystemProperties.set((String)"persist.sys.usb.config", (String)this.mDefaultFunctions);
                    }
                }
            } else {
                if (functions == null) {
                    functions = this.mDefaultFunctions;
                }
                if (!this.mCurrentFunctions.equals(functions = UsbDeviceManager.this.mAdbEnabled ? UsbDeviceManager.addFunction(functions, "adb") : UsbDeviceManager.removeFunction(functions, "adb"))) {
                    if (!this.setUsbConfig("none")) {
                        Slog.e((String)TAG, (String)"Failed to disable USB");
                        this.setUsbConfig(this.mCurrentFunctions);
                        return;
                    }
                    if (this.setUsbConfig(functions)) {
                        this.mCurrentFunctions = functions;
                    } else {
                        Slog.e((String)TAG, (String)("Failed to switch USB config to " + functions));
                        this.setUsbConfig(this.mCurrentFunctions);
                    }
                }
            }
        }

        private void updateCurrentAccessory() {
            if (!UsbDeviceManager.this.mHasUsbAccessory) {
                return;
            }
            if (this.mConfigured) {
                String[] strings = UsbDeviceManager.this.nativeGetAccessoryStrings();
                if (strings != null) {
                    this.mCurrentAccessory = new UsbAccessory(strings);
                    Slog.d((String)TAG, (String)("entering USB accessory mode: " + this.mCurrentAccessory));
                    if (UsbDeviceManager.this.mBootCompleted) {
                        UsbDeviceManager.this.mSettingsManager.accessoryAttached(this.mCurrentAccessory);
                    }
                } else {
                    Slog.e((String)TAG, (String)"nativeGetAccessoryStrings failed");
                }
            } else if (!this.mConnected) {
                Slog.d((String)TAG, (String)"exited USB accessory mode");
                this.setEnabledFunctions(this.mDefaultFunctions, false);
                if (this.mCurrentAccessory != null) {
                    if (UsbDeviceManager.this.mBootCompleted) {
                        UsbDeviceManager.this.mSettingsManager.accessoryDetached(this.mCurrentAccessory);
                    }
                    this.mCurrentAccessory = null;
                }
            }
        }

        private void updateUsbState() {
            Intent intent = new Intent("android.hardware.usb.action.USB_STATE");
            intent.addFlags(0x20000000);
            intent.putExtra("connected", this.mConnected);
            intent.putExtra("configured", this.mConfigured);
            if (this.mCurrentFunctions != null) {
                String[] functions = this.mCurrentFunctions.split(",");
                for (int i = 0; i < functions.length; ++i) {
                    intent.putExtra(functions[i], true);
                }
            }
            UsbDeviceManager.this.mContext.sendStickyBroadcast(intent);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mConnected = msg.arg1 == 1;
                    this.mConfigured = msg.arg2 == 1;
                    this.updateUsbNotification();
                    this.updateAdbNotification();
                    if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                        this.updateCurrentAccessory();
                    }
                    if (!this.mConnected) {
                        this.setEnabledFunctions(this.mDefaultFunctions, false);
                    }
                    if (!UsbDeviceManager.this.mBootCompleted) break;
                    this.updateUsbState();
                    break;
                }
                case 1: {
                    this.setAdbEnabled(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    String function = (String)msg.obj;
                    boolean makeDefault = msg.arg1 == 1;
                    this.setEnabledFunctions(function, makeDefault);
                    break;
                }
                case 3: {
                    this.updateUsbNotification();
                    this.updateAdbNotification();
                    this.updateUsbState();
                    break;
                }
                case 4: {
                    UsbDeviceManager.this.mBootCompleted = true;
                    if (this.mCurrentAccessory == null) break;
                    UsbDeviceManager.this.mSettingsManager.accessoryAttached(this.mCurrentAccessory);
                }
            }
        }

        public UsbAccessory getCurrentAccessory() {
            return this.mCurrentAccessory;
        }

        private void updateUsbNotification() {
            if (UsbDeviceManager.this.mNotificationManager == null || !UsbDeviceManager.this.mUseUsbNotification) {
                return;
            }
            int id = 0;
            Resources r = UsbDeviceManager.this.mContext.getResources();
            if (this.mConnected) {
                if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "mtp")) {
                    id = 17040394;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "ptp")) {
                    id = 17040395;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "mass_storage")) {
                    id = 17040396;
                } else if (UsbDeviceManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                    id = 17040397;
                } else if (!UsbDeviceManager.containsFunction(this.mCurrentFunctions, "rndis")) {
                    Slog.e((String)TAG, (String)"No known USB function in updateUsbNotification");
                }
            }
            if (id != this.mUsbNotificationId) {
                if (this.mUsbNotificationId != 0) {
                    UsbDeviceManager.this.mNotificationManager.cancel(this.mUsbNotificationId);
                    this.mUsbNotificationId = 0;
                }
                if (id != 0) {
                    CharSequence message = r.getText(17040398);
                    CharSequence title = r.getText(id);
                    Notification notification = new Notification();
                    notification.icon = 17302803;
                    notification.when = 0L;
                    notification.flags = 2;
                    notification.tickerText = title;
                    notification.defaults = 0;
                    notification.sound = null;
                    notification.vibrate = null;
                    Intent intent = Intent.makeRestartActivityTask((ComponentName)new ComponentName("com.android.settings", "com.android.settings.UsbSettings"));
                    PendingIntent pi = PendingIntent.getActivity((Context)UsbDeviceManager.this.mContext, (int)0, (Intent)intent, (int)0);
                    notification.setLatestEventInfo(UsbDeviceManager.this.mContext, title, message, pi);
                    UsbDeviceManager.this.mNotificationManager.notify(id, notification);
                    this.mUsbNotificationId = id;
                }
            }
        }

        private void updateAdbNotification() {
            if (UsbDeviceManager.this.mNotificationManager == null) {
                return;
            }
            int id = 17040402;
            if (UsbDeviceManager.this.mAdbEnabled && this.mConnected) {
                if ("0".equals(SystemProperties.get((String)"persist.adb.notify"))) {
                    return;
                }
                if (!this.mAdbNotificationShown) {
                    Resources r = UsbDeviceManager.this.mContext.getResources();
                    CharSequence title = r.getText(17040402);
                    CharSequence message = r.getText(17040403);
                    Notification notification = new Notification();
                    notification.icon = 17302773;
                    notification.when = 0L;
                    notification.flags = 2;
                    notification.tickerText = title;
                    notification.defaults = 0;
                    notification.sound = null;
                    notification.vibrate = null;
                    Intent intent = Intent.makeRestartActivityTask((ComponentName)new ComponentName("com.android.settings", "com.android.settings.DevelopmentSettings"));
                    PendingIntent pi = PendingIntent.getActivity((Context)UsbDeviceManager.this.mContext, (int)0, (Intent)intent, (int)0);
                    notification.setLatestEventInfo(UsbDeviceManager.this.mContext, title, message, pi);
                    this.mAdbNotificationShown = true;
                    UsbDeviceManager.this.mNotificationManager.notify(17040402, notification);
                }
            } else if (this.mAdbNotificationShown) {
                this.mAdbNotificationShown = false;
                UsbDeviceManager.this.mNotificationManager.cancel(17040402);
            }
        }

        public void dump(FileDescriptor fd, PrintWriter pw) {
            pw.println("  USB Device State:");
            pw.println("    Current Functions: " + this.mCurrentFunctions);
            pw.println("    Default Functions: " + this.mDefaultFunctions);
            pw.println("    mConnected: " + this.mConnected);
            pw.println("    mConfigured: " + this.mConfigured);
            pw.println("    mCurrentAccessory: " + this.mCurrentAccessory);
            try {
                pw.println("    Kernel state: " + FileUtils.readTextFile((File)new File(UsbDeviceManager.STATE_PATH), (int)0, null).trim());
                pw.println("    Kernel function list: " + FileUtils.readTextFile((File)new File(UsbDeviceManager.FUNCTIONS_PATH), (int)0, null).trim());
                pw.println("    Mass storage backing file: " + FileUtils.readTextFile((File)new File(UsbDeviceManager.MASS_STORAGE_FILE_PATH), (int)0, null).trim());
            }
            catch (IOException e) {
                pw.println("IOException: " + e);
            }
        }
    }

    private class AdbSettingsObserver
    extends ContentObserver {
        public AdbSettingsObserver() {
            super(null);
        }

        public void onChange(boolean selfChange) {
            boolean enable = Settings.Secure.getInt((ContentResolver)UsbDeviceManager.this.mContentResolver, (String)"adb_enabled", (int)0) > 0;
            UsbDeviceManager.this.mHandler.sendMessage(1, enable);
        }
    }
}

