/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import com.android.server.usb.UsbDeviceManager;
import com.android.server.usb.UsbHostManager;
import com.android.server.usb.UsbSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UsbService
extends IUsbManager.Stub {
    private final Context mContext;
    private UsbDeviceManager mDeviceManager;
    private UsbHostManager mHostManager;
    private final UsbSettingsManager mSettingsManager;

    public UsbService(Context context) {
        this.mContext = context;
        this.mSettingsManager = new UsbSettingsManager(context);
        PackageManager pm = this.mContext.getPackageManager();
        if (pm.hasSystemFeature("android.hardware.usb.host")) {
            this.mHostManager = new UsbHostManager(context, this.mSettingsManager);
        }
        if (new File("/sys/class/android_usb").exists()) {
            this.mDeviceManager = new UsbDeviceManager(context, this.mSettingsManager);
        }
    }

    public void systemReady() {
        if (this.mDeviceManager != null) {
            this.mDeviceManager.systemReady();
        }
        if (this.mHostManager != null) {
            this.mHostManager.systemReady();
        }
    }

    public void getDeviceList(Bundle devices) {
        if (this.mHostManager != null) {
            this.mHostManager.getDeviceList(devices);
        }
    }

    public ParcelFileDescriptor openDevice(String deviceName) {
        if (this.mHostManager != null) {
            return this.mHostManager.openDevice(deviceName);
        }
        return null;
    }

    public UsbAccessory getCurrentAccessory() {
        if (this.mDeviceManager != null) {
            return this.mDeviceManager.getCurrentAccessory();
        }
        return null;
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        if (this.mDeviceManager != null) {
            return this.mDeviceManager.openAccessory(accessory);
        }
        return null;
    }

    public void setDevicePackage(UsbDevice device, String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mSettingsManager.setDevicePackage(device, packageName);
    }

    public void setAccessoryPackage(UsbAccessory accessory, String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mSettingsManager.setAccessoryPackage(accessory, packageName);
    }

    public boolean hasDevicePermission(UsbDevice device) {
        return this.mSettingsManager.hasPermission(device);
    }

    public boolean hasAccessoryPermission(UsbAccessory accessory) {
        return this.mSettingsManager.hasPermission(accessory);
    }

    public void requestDevicePermission(UsbDevice device, String packageName, PendingIntent pi) {
        this.mSettingsManager.requestPermission(device, packageName, pi);
    }

    public void requestAccessoryPermission(UsbAccessory accessory, String packageName, PendingIntent pi) {
        this.mSettingsManager.requestPermission(accessory, packageName, pi);
    }

    public void grantDevicePermission(UsbDevice device, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mSettingsManager.grantDevicePermission(device, uid);
    }

    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mSettingsManager.grantAccessoryPermission(accessory, uid);
    }

    public boolean hasDefaults(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        return this.mSettingsManager.hasDefaults(packageName);
    }

    public void clearDefaults(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mSettingsManager.clearDefaults(packageName);
    }

    public void setCurrentFunction(String function, boolean makeDefault) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        if (this.mDeviceManager == null) {
            throw new IllegalStateException("USB device mode not supported");
        }
        this.mDeviceManager.setCurrentFunction(function, makeDefault);
    }

    public void setMassStorageBackingFile(String path) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        if (this.mDeviceManager == null) {
            throw new IllegalStateException("USB device mode not supported");
        }
        this.mDeviceManager.setMassStorageBackingFile(path);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UsbManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("USB Manager State:");
        if (this.mDeviceManager != null) {
            this.mDeviceManager.dump(fd, pw);
        }
        if (this.mHostManager != null) {
            this.mHostManager.dump(fd, pw);
        }
        this.mSettingsManager.dump(fd, pw);
    }
}

