/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Message;
import android.os.RemoteException;
import android.view.IApplicationToken;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.server.wm.InputApplicationHandle;
import com.android.server.wm.StartingData;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

class AppWindowToken
extends WindowToken {
    final IApplicationToken appToken;
    final ArrayList<WindowState> allAppWindows = new ArrayList();
    int groupId = -1;
    boolean appFullscreen;
    int requestedOrientation = -1;
    long inputDispatchingTimeoutNanos;
    int lastTransactionSequence;
    int numInterestingWindows;
    int numDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    boolean willBeHidden;
    boolean hiddenRequested;
    boolean clientHidden;
    boolean reportedVisible;
    boolean reportedDrawn;
    boolean removed;
    boolean freezingScreen;
    boolean animating;
    Animation animation;
    boolean hasTransformation;
    final Transformation transformation = new Transformation();
    int animLayerAdjustment;
    StartingData startingData;
    WindowState startingWindow;
    View startingView;
    boolean startingDisplayed;
    boolean startingMoved;
    boolean firstWindowDrawn;
    final InputApplicationHandle mInputApplicationHandle;

    AppWindowToken(WindowManagerService _service, IApplicationToken _token) {
        super(_service, _token.asBinder(), 2, true);
        this.appWindowToken = this;
        this.appToken = _token;
        this.mInputApplicationHandle = new InputApplicationHandle(this);
        this.lastTransactionSequence = this.service.mTransactionSequence - 1;
    }

    public void setAnimation(Animation anim) {
        this.animation = anim;
        this.animating = false;
        anim.restrictDuration(10000L);
        anim.scaleCurrentDuration(this.service.mTransitionAnimationScale);
        int zorder = anim.getZAdjustment();
        int adj = 0;
        if (zorder == 1) {
            adj = 1000;
        } else if (zorder == -1) {
            adj = -1000;
        }
        if (this.animLayerAdjustment != adj) {
            this.animLayerAdjustment = adj;
            this.updateLayers();
        }
    }

    public void setDummyAnimation() {
        if (this.animation == null) {
            this.animation = WindowManagerService.sDummyAnimation;
        }
    }

    public void clearAnimation() {
        if (this.animation != null) {
            this.animation = null;
            this.animating = true;
        }
    }

    void updateLayers() {
        int N = this.allAppWindows.size();
        int adj = this.animLayerAdjustment;
        for (int i = 0; i < N; ++i) {
            WindowState w = this.allAppWindows.get(i);
            w.mAnimLayer = w.mLayer + adj;
            if (w == this.service.mInputMethodTarget && !this.service.mInputMethodTargetWaitingAnim) {
                this.service.setInputMethodAnimLayerAdjustment(adj);
            }
            if (w != this.service.mWallpaperTarget || this.service.mLowerWallpaperTarget != null) continue;
            this.service.setWallpaperAnimLayerAdjustmentLocked(adj);
        }
    }

    void sendAppVisibilityToClients() {
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = this.allAppWindows.get(i);
            if (win == this.startingWindow && this.clientHidden) continue;
            try {
                win.mClient.dispatchAppVisibility(!this.clientHidden);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    void showAllWindowsLocked() {
        int NW = this.allAppWindows.size();
        for (int i = 0; i < NW; ++i) {
            WindowState w = this.allAppWindows.get(i);
            w.performShowLocked();
        }
    }

    boolean stepAnimationLocked(long currentTime, int dw, int dh) {
        if (!this.service.mDisplayFrozen && this.service.mPolicy.isScreenOnFully()) {
            if (this.animation == WindowManagerService.sDummyAnimation) {
                return false;
            }
            if ((this.allDrawn || this.animating || this.startingDisplayed) && this.animation != null) {
                if (!this.animating) {
                    this.animation.initialize(dw, dh, dw, dh);
                    this.animation.setStartTime(currentTime);
                    this.animating = true;
                }
                this.transformation.clear();
                boolean more = this.animation.getTransformation(currentTime, this.transformation);
                if (more) {
                    this.hasTransformation = true;
                    return true;
                }
                this.animation = null;
            }
        } else if (this.animation != null) {
            this.animating = true;
            this.animation = null;
        }
        this.hasTransformation = false;
        if (!this.animating) {
            return false;
        }
        this.clearAnimation();
        this.animating = false;
        if (this.animLayerAdjustment != 0) {
            this.animLayerAdjustment = 0;
            this.updateLayers();
        }
        if (this.service.mInputMethodTarget != null && this.service.mInputMethodTarget.mAppToken == this) {
            this.service.moveInputMethodWindowsIfNeededLocked(true);
        }
        this.transformation.clear();
        int N = this.windows.size();
        for (int i = 0; i < N; ++i) {
            ((WindowState)this.windows.get(i)).finishExit();
        }
        this.updateReportedVisibilityLocked();
        return false;
    }

    void updateReportedVisibilityLocked() {
        Message m;
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int numInteresting = 0;
        int numVisible = 0;
        int numDrawn = 0;
        boolean nowGone = true;
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = this.allAppWindows.get(i);
            if (win == this.startingWindow || win.mAppFreezing || win.mViewVisibility != 0 || win.mAttrs.type == 3 || win.mDestroying) continue;
            ++numInteresting;
            if (win.isDrawnLw()) {
                ++numDrawn;
                if (!win.isAnimating()) {
                    ++numVisible;
                }
                nowGone = false;
                continue;
            }
            if (!win.isAnimating()) continue;
            nowGone = false;
        }
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting;
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        if (nowDrawn != this.reportedDrawn) {
            if (nowDrawn) {
                m = this.service.mH.obtainMessage(9, this);
                this.service.mH.sendMessage(m);
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            m = this.service.mH.obtainMessage(8, nowVisible ? 1 : 0, nowGone ? 1 : 0, this);
            this.service.mH.sendMessage(m);
        }
    }

    WindowState findMainWindow() {
        int j = this.windows.size();
        while (j > 0) {
            WindowState win = (WindowState)this.windows.get(--j);
            if (win.mAttrs.type != 1 && win.mAttrs.type != 3) continue;
            return win;
        }
        return null;
    }

    void dump(PrintWriter pw, String prefix) {
        super.dump(pw, prefix);
        if (this.appToken != null) {
            pw.print(prefix);
            pw.println("app=true");
        }
        if (this.allAppWindows.size() > 0) {
            pw.print(prefix);
            pw.print("allAppWindows=");
            pw.println(this.allAppWindows);
        }
        pw.print(prefix);
        pw.print("groupId=");
        pw.print(this.groupId);
        pw.print(" appFullscreen=");
        pw.print(this.appFullscreen);
        pw.print(" requestedOrientation=");
        pw.println(this.requestedOrientation);
        pw.print(prefix);
        pw.print("hiddenRequested=");
        pw.print(this.hiddenRequested);
        pw.print(" clientHidden=");
        pw.print(this.clientHidden);
        pw.print(" willBeHidden=");
        pw.print(this.willBeHidden);
        pw.print(" reportedDrawn=");
        pw.print(this.reportedDrawn);
        pw.print(" reportedVisible=");
        pw.println(this.reportedVisible);
        if (this.paused || this.freezingScreen) {
            pw.print(prefix);
            pw.print("paused=");
            pw.print(this.paused);
            pw.print(" freezingScreen=");
            pw.println(this.freezingScreen);
        }
        if (this.numInterestingWindows != 0 || this.numDrawnWindows != 0 || this.inPendingTransaction || this.allDrawn) {
            pw.print(prefix);
            pw.print("numInterestingWindows=");
            pw.print(this.numInterestingWindows);
            pw.print(" numDrawnWindows=");
            pw.print(this.numDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.println(this.allDrawn);
        }
        if (this.animating || this.animation != null) {
            pw.print(prefix);
            pw.print("animating=");
            pw.print(this.animating);
            pw.print(" animation=");
            pw.println(this.animation);
        }
        if (this.hasTransformation) {
            pw.print(prefix);
            pw.print("XForm: ");
            this.transformation.printShortString(pw);
            pw.println();
        }
        if (this.animLayerAdjustment != 0) {
            pw.print(prefix);
            pw.print("animLayerAdjustment=");
            pw.println(this.animLayerAdjustment);
        }
        if (this.startingData != null || this.removed || this.firstWindowDrawn) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.startingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.println(this.firstWindowDrawn);
        }
        if (this.startingWindow != null || this.startingView != null || this.startingDisplayed || this.startingMoved) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingView=");
            pw.print(this.startingView);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved");
            pw.println(this.startingMoved);
        }
    }

    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName;
    }
}

