/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.Surface;
import android.view.SurfaceSession;

public class BlackFrame {
    final Matrix mTmpMatrix = new Matrix();
    final float[] mTmpFloats = new float[9];
    final BlackSurface[] mBlackSurfaces = new BlackSurface[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlackFrame(SurfaceSession session, Rect outer, Rect inner, int layer) throws Surface.OutOfResourcesException {
        boolean success = false;
        try {
            if (outer.top < inner.top) {
                this.mBlackSurfaces[0] = new BlackSurface(session, layer, outer.left, outer.top, inner.right, inner.top);
            }
            if (outer.left < inner.left) {
                this.mBlackSurfaces[1] = new BlackSurface(session, layer, outer.left, inner.top, inner.left, outer.bottom);
            }
            if (outer.bottom > inner.bottom) {
                this.mBlackSurfaces[2] = new BlackSurface(session, layer, inner.left, inner.bottom, outer.right, outer.bottom);
            }
            if (outer.right > inner.right) {
                this.mBlackSurfaces[3] = new BlackSurface(session, layer, inner.right, outer.top, outer.right, inner.bottom);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.kill();
            }
        }
    }

    public void kill() {
        if (this.mBlackSurfaces != null) {
            for (int i = 0; i < this.mBlackSurfaces.length; ++i) {
                if (this.mBlackSurfaces[i] == null) continue;
                this.mBlackSurfaces[i].surface.destroy();
                this.mBlackSurfaces[i] = null;
            }
        }
    }

    public void hide() {
        if (this.mBlackSurfaces != null) {
            for (int i = 0; i < this.mBlackSurfaces.length; ++i) {
                if (this.mBlackSurfaces[i] == null) continue;
                this.mBlackSurfaces[i].surface.hide();
            }
        }
    }

    public void setMatrix(Matrix matrix) {
        for (int i = 0; i < this.mBlackSurfaces.length; ++i) {
            if (this.mBlackSurfaces[i] == null) continue;
            this.mBlackSurfaces[i].setMatrix(matrix);
        }
    }

    public void clearMatrix() {
        for (int i = 0; i < this.mBlackSurfaces.length; ++i) {
            if (this.mBlackSurfaces[i] == null) continue;
            this.mBlackSurfaces[i].clearMatrix();
        }
    }

    class BlackSurface {
        final int left;
        final int top;
        final Surface surface;

        BlackSurface(SurfaceSession session, int layer, int l, int t, int r, int b) throws Surface.OutOfResourcesException {
            this.left = l;
            this.top = t;
            int w = r - l;
            int h = b - t;
            this.surface = new Surface(session, 0, "BlackSurface", -1, w, h, -1, 131072);
            this.surface.setAlpha(1.0f);
            this.surface.setLayer(layer);
        }

        void setMatrix(Matrix matrix) {
            BlackFrame.this.mTmpMatrix.setTranslate((float)this.left, (float)this.top);
            BlackFrame.this.mTmpMatrix.postConcat(matrix);
            BlackFrame.this.mTmpMatrix.getValues(BlackFrame.this.mTmpFloats);
            this.surface.setPosition(BlackFrame.this.mTmpFloats[2], BlackFrame.this.mTmpFloats[5]);
            this.surface.setMatrix(BlackFrame.this.mTmpFloats[0], BlackFrame.this.mTmpFloats[3], BlackFrame.this.mTmpFloats[1], BlackFrame.this.mTmpFloats[4]);
        }

        void clearMatrix() {
            this.surface.setMatrix(1.0f, 0.0f, 0.0f, 1.0f);
        }
    }
}

