/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Resources;
import android.util.Slog;
import android.util.TypedValue;
import android.view.Surface;
import android.view.SurfaceSession;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

class DimAnimator {
    Surface mDimSurface;
    boolean mDimShown = false;
    float mDimCurrentAlpha;
    float mDimTargetAlpha;
    float mDimDeltaPerMs;
    long mLastDimAnimTime;
    int mLastDimWidth;
    int mLastDimHeight;

    DimAnimator(SurfaceSession session) {
        if (this.mDimSurface == null) {
            try {
                this.mDimSurface = new Surface(session, 0, "DimAnimator", -1, 16, 16, -1, 131072);
                this.mDimSurface.setAlpha(0.0f);
            }
            catch (Exception e) {
                Slog.e((String)"WindowManager", (String)"Exception creating Dim surface", (Throwable)e);
            }
        }
    }

    void show(int dw, int dh) {
        if (!this.mDimShown) {
            this.mDimShown = true;
            try {
                this.mLastDimWidth = dw;
                this.mLastDimHeight = dh;
                this.mDimSurface.setPosition(0, 0);
                this.mDimSurface.setSize(dw, dh);
                this.mDimSurface.show();
            }
            catch (RuntimeException e) {
                Slog.w((String)"WindowManager", (String)"Failure showing dim surface", (Throwable)e);
            }
        } else if (this.mLastDimWidth != dw || this.mLastDimHeight != dh) {
            this.mLastDimWidth = dw;
            this.mLastDimHeight = dh;
            this.mDimSurface.setSize(dw, dh);
        }
    }

    void updateParameters(Resources res, WindowState w, long currentTime) {
        float target;
        this.mDimSurface.setLayer(w.mAnimLayer - 1);
        float f = target = w.mExiting ? 0.0f : w.mAttrs.dimAmount;
        if (this.mDimTargetAlpha != target) {
            long duration;
            this.mLastDimAnimTime = currentTime;
            long l = duration = w.mAnimating && w.mAnimation != null ? w.mAnimation.computeDurationHint() : 200L;
            if (target > this.mDimTargetAlpha) {
                TypedValue tv = new TypedValue();
                res.getValue(0x1120000, tv, true);
                if (tv.type == 6) {
                    duration = (long)tv.getFraction((float)duration, (float)duration);
                } else if (tv.type >= 16 && tv.type <= 31) {
                    duration = tv.data;
                }
            }
            if (duration < 1L) {
                duration = 1L;
            }
            this.mDimTargetAlpha = target;
            this.mDimDeltaPerMs = (this.mDimTargetAlpha - this.mDimCurrentAlpha) / (float)duration;
        }
    }

    boolean updateSurface(boolean dimming, long currentTime, boolean displayFrozen) {
        if (!dimming && this.mDimTargetAlpha != 0.0f) {
            this.mLastDimAnimTime = currentTime;
            this.mDimTargetAlpha = 0.0f;
            this.mDimDeltaPerMs = -this.mDimCurrentAlpha / 200.0f;
        }
        boolean animating = false;
        if (this.mLastDimAnimTime != 0L) {
            this.mDimCurrentAlpha += this.mDimDeltaPerMs * (float)(currentTime - this.mLastDimAnimTime);
            boolean more = true;
            if (displayFrozen) {
                more = false;
            } else if (this.mDimDeltaPerMs > 0.0f) {
                if (this.mDimCurrentAlpha > this.mDimTargetAlpha) {
                    more = false;
                }
            } else if (this.mDimDeltaPerMs < 0.0f) {
                if (this.mDimCurrentAlpha < this.mDimTargetAlpha) {
                    more = false;
                }
            } else {
                more = false;
            }
            if (more) {
                this.mLastDimAnimTime = currentTime;
                this.mDimSurface.setAlpha(this.mDimCurrentAlpha);
                animating = true;
            } else {
                this.mDimCurrentAlpha = this.mDimTargetAlpha;
                this.mLastDimAnimTime = 0L;
                this.mDimSurface.setAlpha(this.mDimCurrentAlpha);
                if (!dimming) {
                    try {
                        this.mDimSurface.hide();
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)"WindowManager", (String)"Illegal argument exception hiding dim surface");
                    }
                    this.mDimShown = false;
                }
            }
        }
        return animating;
    }

    public void printTo(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mDimSurface=");
        pw.println(this.mDimSurface);
        pw.print(prefix);
        pw.print("mDimShown=");
        pw.print(this.mDimShown);
        pw.print(" current=");
        pw.print(this.mDimCurrentAlpha);
        pw.print(" target=");
        pw.print(this.mDimTargetAlpha);
        pw.print(" delta=");
        pw.print(this.mDimDeltaPerMs);
        pw.print(" lastAnimTime=");
        pw.println(this.mLastDimAnimTime);
    }
}

