/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.Slog;
import android.view.Surface;
import android.view.SurfaceSession;
import java.io.PrintWriter;

class DimSurface {
    Surface mDimSurface;
    boolean mDimShown = false;
    int mDimColor = 0;
    int mLayer = -1;
    int mLastDimWidth;
    int mLastDimHeight;

    DimSurface(SurfaceSession session) {
        if (this.mDimSurface == null) {
            try {
                this.mDimSurface = new Surface(session, 0, "DimSurface", -1, 16, 16, -1, 131072);
                this.mDimSurface.setAlpha(0.0f);
            }
            catch (Exception e) {
                Slog.e((String)"WindowManager", (String)"Exception creating Dim surface", (Throwable)e);
            }
        }
    }

    void show(int dw, int dh, int layer, int color) {
        if (!this.mDimShown) {
            this.mDimShown = true;
            try {
                this.mLastDimWidth = dw;
                this.mLastDimHeight = dh;
                this.mDimSurface.setPosition(0, 0);
                this.mDimSurface.setSize(dw, dh);
                this.mDimSurface.setLayer(layer);
                this.mDimSurface.show();
            }
            catch (RuntimeException e) {
                Slog.w((String)"WindowManager", (String)"Failure showing dim surface", (Throwable)e);
            }
        } else if (this.mLastDimWidth != dw || this.mLastDimHeight != dh || this.mDimColor != color || this.mLayer != layer) {
            this.mLastDimWidth = dw;
            this.mLastDimHeight = dh;
            this.mLayer = layer;
            this.mDimColor = color;
            this.mDimSurface.setSize(dw, dh);
            this.mDimSurface.setLayer(layer);
            this.mDimSurface.setAlpha((float)(color >> 24 & 0xFF) / 255.0f);
        }
    }

    void hide() {
        if (this.mDimShown) {
            this.mDimShown = false;
            try {
                this.mDimSurface.hide();
            }
            catch (RuntimeException e) {
                Slog.w((String)"WindowManager", (String)"Illegal argument exception hiding dim surface");
            }
        }
    }

    public void printTo(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mDimSurface=");
        pw.println(this.mDimSurface);
        pw.print(prefix);
        pw.print("mDimShown=");
        pw.print(this.mDimShown);
        pw.print(" mLayer=");
        pw.print(this.mLayer);
        pw.print(" mDimColor=0x");
        pw.println(Integer.toHexString(this.mDimColor));
        pw.print(prefix);
        pw.print("mLastDimWidth=");
        pw.print(this.mLastDimWidth);
        pw.print(" mLastDimWidth=");
        pw.println(this.mLastDimWidth);
    }
}

