/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.content.ClipDescription;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.RemoteException;
import android.util.Slog;
import android.view.DragEvent;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.Surface;
import com.android.server.wm.InputApplicationHandle;
import com.android.server.wm.InputWindowHandle;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.ArrayList;

class DragState {
    final WindowManagerService mService;
    IBinder mToken;
    Surface mSurface;
    int mFlags;
    IBinder mLocalWin;
    ClipData mData;
    ClipDescription mDataDescription;
    boolean mDragResult;
    float mCurrentX;
    float mCurrentY;
    float mThumbOffsetX;
    float mThumbOffsetY;
    InputChannel mServerChannel;
    InputChannel mClientChannel;
    InputApplicationHandle mDragApplicationHandle;
    InputWindowHandle mDragWindowHandle;
    WindowState mTargetWindow;
    ArrayList<WindowState> mNotifiedWindows;
    boolean mDragInProgress;
    private final Region mTmpRegion = new Region();

    DragState(WindowManagerService service, IBinder token, Surface surface, int flags, IBinder localWin) {
        this.mService = service;
        this.mToken = token;
        this.mSurface = surface;
        this.mFlags = flags;
        this.mLocalWin = localWin;
        this.mNotifiedWindows = new ArrayList();
    }

    void reset() {
        if (this.mSurface != null) {
            this.mSurface.destroy();
        }
        this.mSurface = null;
        this.mFlags = 0;
        this.mLocalWin = null;
        this.mToken = null;
        this.mData = null;
        this.mThumbOffsetY = 0.0f;
        this.mThumbOffsetX = 0.0f;
        this.mNotifiedWindows = null;
    }

    void register() {
        if (this.mClientChannel != null) {
            Slog.e((String)"WindowManager", (String)"Duplicate register of drag input channel");
        } else {
            InputChannel[] channels = InputChannel.openInputChannelPair((String)"drag");
            this.mServerChannel = channels[0];
            this.mClientChannel = channels[1];
            this.mService.mInputManager.registerInputChannel(this.mServerChannel, null);
            InputQueue.registerInputChannel((InputChannel)this.mClientChannel, (InputHandler)this.mService.mDragInputHandler, (MessageQueue)this.mService.mH.getLooper().getQueue());
            this.mDragApplicationHandle = new InputApplicationHandle(null);
            this.mDragApplicationHandle.name = "drag";
            this.mDragApplicationHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle = new InputWindowHandle(this.mDragApplicationHandle, null);
            this.mDragWindowHandle.name = "drag";
            this.mDragWindowHandle.inputChannel = this.mServerChannel;
            this.mDragWindowHandle.layer = this.getDragLayerLw();
            this.mDragWindowHandle.layoutParamsFlags = 0;
            this.mDragWindowHandle.layoutParamsType = 2016;
            this.mDragWindowHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle.visible = true;
            this.mDragWindowHandle.canReceiveKeys = false;
            this.mDragWindowHandle.hasFocus = true;
            this.mDragWindowHandle.hasWallpaper = false;
            this.mDragWindowHandle.paused = false;
            this.mDragWindowHandle.ownerPid = Process.myPid();
            this.mDragWindowHandle.ownerUid = Process.myUid();
            this.mDragWindowHandle.inputFeatures = 0;
            this.mDragWindowHandle.scaleFactor = 1.0f;
            this.mDragWindowHandle.touchableRegion.setEmpty();
            this.mDragWindowHandle.frameLeft = 0;
            this.mDragWindowHandle.frameTop = 0;
            this.mDragWindowHandle.frameRight = this.mService.mCurDisplayWidth;
            this.mDragWindowHandle.frameBottom = this.mService.mCurDisplayHeight;
            this.mService.pauseRotationLocked();
        }
    }

    void unregister() {
        if (this.mClientChannel == null) {
            Slog.e((String)"WindowManager", (String)"Unregister of nonexistent drag input channel");
        } else {
            this.mService.mInputManager.unregisterInputChannel(this.mServerChannel);
            InputQueue.unregisterInputChannel((InputChannel)this.mClientChannel);
            this.mClientChannel.dispose();
            this.mServerChannel.dispose();
            this.mClientChannel = null;
            this.mServerChannel = null;
            this.mDragWindowHandle = null;
            this.mDragApplicationHandle = null;
            this.mService.resumeRotationLocked();
        }
    }

    int getDragLayerLw() {
        return this.mService.mPolicy.windowTypeToLayerLw(2016) * 10000 + 1000;
    }

    void broadcastDragStartedLw(float touchX, float touchY) {
        this.mDataDescription = this.mData != null ? this.mData.getDescription() : null;
        this.mNotifiedWindows.clear();
        this.mDragInProgress = true;
        int N = this.mService.mWindows.size();
        for (int i = 0; i < N; ++i) {
            this.sendDragStartedLw(this.mService.mWindows.get(i), touchX, touchY, this.mDataDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDragStartedLw(WindowState newWin, float touchX, float touchY, ClipDescription desc) {
        IBinder winBinder;
        if ((this.mFlags & 1) == 0 && (winBinder = newWin.mClient.asBinder()) != this.mLocalWin) {
            return;
        }
        if (this.mDragInProgress && newWin.isPotentialDragTarget()) {
            DragEvent event = DragState.obtainDragEvent(newWin, 1, touchX, touchY, null, desc, null, false);
            try {
                newWin.mClient.dispatchDragEvent(event);
                this.mNotifiedWindows.add(newWin);
            }
            catch (RemoteException e) {
                Slog.w((String)"WindowManager", (String)("Unable to drag-start window " + newWin));
            }
            finally {
                if (Process.myPid() != newWin.mSession.mPid) {
                    event.recycle();
                }
            }
        }
    }

    void sendDragStartedIfNeededLw(WindowState newWin) {
        if (this.mDragInProgress) {
            for (WindowState ws : this.mNotifiedWindows) {
                if (ws != newWin) continue;
                return;
            }
            this.sendDragStartedLw(newWin, this.mCurrentX, this.mCurrentY, this.mDataDescription);
        }
    }

    void broadcastDragEndedLw() {
        DragEvent evt = DragEvent.obtain((int)4, (float)0.0f, (float)0.0f, null, null, null, (boolean)this.mDragResult);
        for (WindowState ws : this.mNotifiedWindows) {
            try {
                ws.mClient.dispatchDragEvent(evt);
            }
            catch (RemoteException e) {
                Slog.w((String)"WindowManager", (String)("Unable to drag-end window " + ws));
            }
        }
        this.mNotifiedWindows.clear();
        this.mDragInProgress = false;
        evt.recycle();
    }

    void endDragLw() {
        this.mService.mDragState.broadcastDragEndedLw();
        this.mService.mDragState.unregister();
        this.mService.mInputMonitor.updateInputWindowsLw(true);
        this.mService.mDragState.reset();
        this.mService.mDragState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyMoveLw(float x, float y) {
        IBinder touchedBinder;
        int myPid = Process.myPid();
        Surface.openTransaction();
        try {
            this.mSurface.setPosition(x - this.mThumbOffsetX, y - this.mThumbOffsetY);
        }
        finally {
            Surface.closeTransaction();
        }
        WindowState touchedWin = this.getTouchedWinAtPointLw(x, y);
        if (touchedWin == null) {
            return;
        }
        if ((this.mFlags & 1) == 0 && (touchedBinder = touchedWin.mClient.asBinder()) != this.mLocalWin) {
            touchedWin = null;
        }
        try {
            DragEvent evt;
            if (touchedWin != this.mTargetWindow && this.mTargetWindow != null) {
                evt = DragState.obtainDragEvent(this.mTargetWindow, 6, x, y, null, null, null, false);
                this.mTargetWindow.mClient.dispatchDragEvent(evt);
                if (myPid != this.mTargetWindow.mSession.mPid) {
                    evt.recycle();
                }
            }
            if (touchedWin != null) {
                evt = DragState.obtainDragEvent(touchedWin, 2, x, y, null, null, null, false);
                touchedWin.mClient.dispatchDragEvent(evt);
                if (myPid != touchedWin.mSession.mPid) {
                    evt.recycle();
                }
            }
        }
        catch (RemoteException e) {
            Slog.w((String)"WindowManager", (String)"can't send drag notification to windows");
        }
        this.mTargetWindow = touchedWin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyDropLw(float x, float y) {
        WindowState touchedWin = this.getTouchedWinAtPointLw(x, y);
        if (touchedWin == null) {
            this.mDragResult = false;
            return true;
        }
        int myPid = Process.myPid();
        IBinder token = touchedWin.mClient.asBinder();
        DragEvent evt = DragState.obtainDragEvent(touchedWin, 3, x, y, null, null, this.mData, false);
        try {
            touchedWin.mClient.dispatchDragEvent(evt);
            this.mService.mH.removeMessages(21, token);
            Message msg = this.mService.mH.obtainMessage(21, token);
            this.mService.mH.sendMessageDelayed(msg, 5000L);
        }
        catch (RemoteException e) {
            Slog.w((String)"WindowManager", (String)("can't send drop notification to win " + touchedWin));
            boolean bl = true;
            return bl;
        }
        finally {
            if (myPid != touchedWin.mSession.mPid) {
                evt.recycle();
            }
        }
        this.mToken = token;
        return false;
    }

    private WindowState getTouchedWinAtPointLw(float xf, float yf) {
        WindowState touchedWin = null;
        int x = (int)xf;
        int y = (int)yf;
        ArrayList<WindowState> windows = this.mService.mWindows;
        int N = windows.size();
        for (int i = N - 1; i >= 0; --i) {
            WindowState child = windows.get(i);
            int flags = child.mAttrs.flags;
            if (!child.isVisibleLw() || (flags & 0x10) != 0) continue;
            child.getTouchableRegion(this.mTmpRegion);
            int touchFlags = flags & 0x28;
            if (!this.mTmpRegion.contains(x, y) && touchFlags != 0) continue;
            touchedWin = child;
            break;
        }
        return touchedWin;
    }

    private static DragEvent obtainDragEvent(WindowState win, int action, float x, float y, Object localState, ClipDescription description, ClipData data, boolean result) {
        float winX = x - (float)win.mFrame.left;
        float winY = y - (float)win.mFrame.top;
        if (win.mEnforceSizeCompat) {
            winX *= win.mGlobalScale;
            winY *= win.mGlobalScale;
        }
        return DragEvent.obtain((int)action, (float)winX, (float)winY, (Object)localState, (ClipDescription)description, (ClipData)data, (boolean)result);
    }
}

