/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.os.Environment;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import android.util.Xml;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.PointerIcon;
import android.view.ViewConfiguration;
import com.android.internal.util.XmlUtils;
import com.android.server.Watchdog;
import com.android.server.wm.InputApplicationHandle;
import com.android.server.wm.InputFilter;
import com.android.server.wm.InputWindowHandle;
import com.android.server.wm.WindowManagerService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

public class InputManager
implements Watchdog.Monitor {
    static final String TAG = "InputManager";
    private static final boolean DEBUG = false;
    private final Callbacks mCallbacks;
    private final Context mContext;
    private final WindowManagerService mWindowManagerService;
    static final int INPUT_EVENT_INJECTION_SUCCEEDED = 0;
    static final int INPUT_EVENT_INJECTION_PERMISSION_DENIED = 1;
    static final int INPUT_EVENT_INJECTION_FAILED = 2;
    static final int INPUT_EVENT_INJECTION_TIMED_OUT = 3;
    static final int INPUT_EVENT_INJECTION_SYNC_NONE = 0;
    static final int INPUT_EVENT_INJECTION_SYNC_WAIT_FOR_RESULT = 1;
    static final int INPUT_EVENT_INJECTION_SYNC_WAIT_FOR_FINISH = 2;
    public static final int KEY_STATE_UNKNOWN = -1;
    public static final int KEY_STATE_UP = 0;
    public static final int KEY_STATE_DOWN = 1;
    public static final int KEY_STATE_VIRTUAL = 2;
    final Object mInputFilterLock = new Object();
    InputFilter mInputFilter;
    InputFilterHost mInputFilterHost;

    private static native void nativeInit(Context var0, Callbacks var1, MessageQueue var2);

    private static native void nativeStart();

    private static native void nativeSetDisplaySize(int var0, int var1, int var2, int var3, int var4);

    private static native void nativeSetDisplayOrientation(int var0, int var1);

    private static native int nativeGetScanCodeState(int var0, int var1, int var2);

    private static native int nativeGetKeyCodeState(int var0, int var1, int var2);

    private static native int nativeGetSwitchState(int var0, int var1, int var2);

    private static native boolean nativeHasKeys(int var0, int var1, int[] var2, boolean[] var3);

    private static native void nativeRegisterInputChannel(InputChannel var0, InputWindowHandle var1, boolean var2);

    private static native void nativeUnregisterInputChannel(InputChannel var0);

    private static native void nativeSetInputFilterEnabled(boolean var0);

    private static native int nativeInjectInputEvent(InputEvent var0, int var1, int var2, int var3, int var4, int var5);

    private static native void nativeSetInputWindows(InputWindowHandle[] var0);

    private static native void nativeSetInputDispatchMode(boolean var0, boolean var1);

    private static native void nativeSetSystemUiVisibility(int var0);

    private static native void nativeSetFocusedApplication(InputApplicationHandle var0);

    private static native InputDevice nativeGetInputDevice(int var0);

    private static native void nativeGetInputConfiguration(Configuration var0);

    private static native int[] nativeGetInputDeviceIds();

    private static native boolean nativeTransferTouchFocus(InputChannel var0, InputChannel var1);

    private static native void nativeSetPointerSpeed(int var0);

    private static native void nativeSetShowTouches(boolean var0);

    private static native String nativeDump();

    private static native void nativeMonitor();

    public InputManager(Context context, WindowManagerService windowManagerService) {
        this.mContext = context;
        this.mWindowManagerService = windowManagerService;
        this.mCallbacks = new Callbacks();
        Looper looper = windowManagerService.mH.getLooper();
        Slog.i((String)TAG, (String)"Initializing input manager");
        InputManager.nativeInit(this.mContext, this.mCallbacks, looper.getQueue());
        Watchdog.getInstance().addMonitor(this);
    }

    public void start() {
        Slog.i((String)TAG, (String)"Starting input manager");
        InputManager.nativeStart();
        this.registerPointerSpeedSettingObserver();
        this.registerShowTouchesSettingObserver();
        this.updatePointerSpeedFromSettings();
        this.updateShowTouchesFromSettings();
    }

    public void setDisplaySize(int displayId, int width, int height, int externalWidth, int externalHeight) {
        if (width <= 0 || height <= 0 || externalWidth <= 0 || externalHeight <= 0) {
            throw new IllegalArgumentException("Invalid display id or dimensions.");
        }
        InputManager.nativeSetDisplaySize(displayId, width, height, externalWidth, externalHeight);
    }

    public void setDisplayOrientation(int displayId, int rotation) {
        if (rotation < 0 || rotation > 3) {
            throw new IllegalArgumentException("Invalid rotation.");
        }
        InputManager.nativeSetDisplayOrientation(displayId, rotation);
    }

    public void getInputConfiguration(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null.");
        }
        InputManager.nativeGetInputConfiguration(config);
    }

    public int getKeyCodeState(int deviceId, int sourceMask, int keyCode) {
        return InputManager.nativeGetKeyCodeState(deviceId, sourceMask, keyCode);
    }

    public int getScanCodeState(int deviceId, int sourceMask, int scanCode) {
        return InputManager.nativeGetScanCodeState(deviceId, sourceMask, scanCode);
    }

    public int getSwitchState(int deviceId, int sourceMask, int switchCode) {
        return InputManager.nativeGetSwitchState(deviceId, sourceMask, switchCode);
    }

    public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) {
        if (keyCodes == null) {
            throw new IllegalArgumentException("keyCodes must not be null.");
        }
        if (keyExists == null || keyExists.length < keyCodes.length) {
            throw new IllegalArgumentException("keyExists must not be null and must be at least as large as keyCodes.");
        }
        return InputManager.nativeHasKeys(deviceId, sourceMask, keyCodes, keyExists);
    }

    public InputChannel monitorInput(String inputChannelName) {
        if (inputChannelName == null) {
            throw new IllegalArgumentException("inputChannelName must not be null.");
        }
        InputChannel[] inputChannels = InputChannel.openInputChannelPair((String)inputChannelName);
        InputManager.nativeRegisterInputChannel(inputChannels[0], null, true);
        inputChannels[0].dispose();
        return inputChannels[1];
    }

    public void registerInputChannel(InputChannel inputChannel, InputWindowHandle inputWindowHandle) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null.");
        }
        InputManager.nativeRegisterInputChannel(inputChannel, inputWindowHandle, false);
    }

    public void unregisterInputChannel(InputChannel inputChannel) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null.");
        }
        InputManager.nativeUnregisterInputChannel(inputChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputFilter(InputFilter filter) {
        Object object = this.mInputFilterLock;
        synchronized (object) {
            InputFilter oldFilter = this.mInputFilter;
            if (oldFilter == filter) {
                return;
            }
            if (oldFilter != null) {
                this.mInputFilter = null;
                this.mInputFilterHost.disconnectLocked();
                this.mInputFilterHost = null;
                oldFilter.uninstall();
            }
            if (filter != null) {
                this.mInputFilter = filter;
                this.mInputFilterHost = new InputFilterHost();
                filter.install(this.mInputFilterHost);
            }
            InputManager.nativeSetInputFilterEnabled(filter != null);
        }
    }

    public int injectInputEvent(InputEvent event, int injectorPid, int injectorUid, int syncMode, int timeoutMillis) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (injectorPid < 0 || injectorUid < 0) {
            throw new IllegalArgumentException("injectorPid and injectorUid must not be negative.");
        }
        if (timeoutMillis <= 0) {
            throw new IllegalArgumentException("timeoutMillis must be positive");
        }
        return InputManager.nativeInjectInputEvent(event, injectorPid, injectorUid, syncMode, timeoutMillis, 0x8000000);
    }

    public InputDevice getInputDevice(int deviceId) {
        return InputManager.nativeGetInputDevice(deviceId);
    }

    public int[] getInputDeviceIds() {
        return InputManager.nativeGetInputDeviceIds();
    }

    public void setInputWindows(InputWindowHandle[] windowHandles) {
        InputManager.nativeSetInputWindows(windowHandles);
    }

    public void setFocusedApplication(InputApplicationHandle application) {
        InputManager.nativeSetFocusedApplication(application);
    }

    public void setInputDispatchMode(boolean enabled, boolean frozen) {
        InputManager.nativeSetInputDispatchMode(enabled, frozen);
    }

    public void setSystemUiVisibility(int visibility) {
        InputManager.nativeSetSystemUiVisibility(visibility);
    }

    public boolean transferTouchFocus(InputChannel fromChannel, InputChannel toChannel) {
        if (fromChannel == null) {
            throw new IllegalArgumentException("fromChannel must not be null.");
        }
        if (toChannel == null) {
            throw new IllegalArgumentException("toChannel must not be null.");
        }
        return InputManager.nativeTransferTouchFocus(fromChannel, toChannel);
    }

    public void setPointerSpeed(int speed) {
        speed = Math.min(Math.max(speed, -7), 7);
        InputManager.nativeSetPointerSpeed(speed);
    }

    public void updatePointerSpeedFromSettings() {
        int speed = this.getPointerSpeedSetting(0);
        this.setPointerSpeed(speed);
    }

    private void registerPointerSpeedSettingObserver() {
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"pointer_speed"), true, new ContentObserver(this.mWindowManagerService.mH){

            public void onChange(boolean selfChange) {
                InputManager.this.updatePointerSpeedFromSettings();
            }
        });
    }

    private int getPointerSpeedSetting(int defaultValue) {
        int speed = defaultValue;
        try {
            speed = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"pointer_speed");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    public void updateShowTouchesFromSettings() {
        int setting = this.getShowTouchesSetting(0);
        InputManager.nativeSetShowTouches(setting != 0);
    }

    private void registerShowTouchesSettingObserver() {
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"show_touches"), true, new ContentObserver(this.mWindowManagerService.mH){

            public void onChange(boolean selfChange) {
                InputManager.this.updateShowTouchesFromSettings();
            }
        });
    }

    private int getShowTouchesSetting(int defaultValue) {
        int result = defaultValue;
        try {
            result = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"show_touches");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public void dump(PrintWriter pw) {
        String dumpStr = InputManager.nativeDump();
        if (dumpStr != null) {
            pw.println(dumpStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        Object object = this.mInputFilterLock;
        synchronized (object) {
        }
        InputManager.nativeMonitor();
    }

    private final class Callbacks {
        static final String TAG = "InputManager-Callbacks";
        private static final boolean DEBUG_VIRTUAL_KEYS = false;
        private static final String EXCLUDED_DEVICES_PATH = "etc/excluded-input-devices.xml";
        private static final String CALIBRATION_DIR_PATH = "usr/idc/";

        private Callbacks() {
        }

        public void notifyConfigurationChanged(long whenNanos) {
            ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.notifyConfigurationChanged();
        }

        public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
            ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.notifyLidSwitchChanged(whenNanos, lidOpen);
        }

        public void notifyInputChannelBroken(InputWindowHandle inputWindowHandle) {
            ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.notifyInputChannelBroken(inputWindowHandle);
        }

        public long notifyANR(InputApplicationHandle inputApplicationHandle, InputWindowHandle inputWindowHandle) {
            return ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.notifyANR(inputApplicationHandle, inputWindowHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean filterInputEvent(InputEvent event, int policyFlags) {
            Object object = InputManager.this.mInputFilterLock;
            synchronized (object) {
                if (InputManager.this.mInputFilter != null) {
                    InputManager.this.mInputFilter.filterInputEvent(event, policyFlags);
                    return false;
                }
            }
            event.recycle();
            return true;
        }

        public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags, boolean isScreenOn) {
            return ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.interceptKeyBeforeQueueing(event, policyFlags, isScreenOn);
        }

        public int interceptMotionBeforeQueueingWhenScreenOff(int policyFlags) {
            return ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.interceptMotionBeforeQueueingWhenScreenOff(policyFlags);
        }

        public long interceptKeyBeforeDispatching(InputWindowHandle focus, KeyEvent event, int policyFlags) {
            return ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.interceptKeyBeforeDispatching(focus, event, policyFlags);
        }

        public KeyEvent dispatchUnhandledKey(InputWindowHandle focus, KeyEvent event, int policyFlags) {
            return ((InputManager)InputManager.this).mWindowManagerService.mInputMonitor.dispatchUnhandledKey(focus, event, policyFlags);
        }

        public boolean checkInjectEventsPermission(int injectorPid, int injectorUid) {
            return InputManager.this.mContext.checkPermission("android.permission.INJECT_EVENTS", injectorPid, injectorUid) == 0;
        }

        public int getVirtualKeyQuietTimeMillis() {
            return InputManager.this.mContext.getResources().getInteger(17694752);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getExcludedDeviceNames() {
            ArrayList<String> names = new ArrayList<String>();
            XmlPullParser parser = null;
            File confFile = new File(Environment.getRootDirectory(), EXCLUDED_DEVICES_PATH);
            FileReader confreader = null;
            try {
                confreader = new FileReader(confFile);
                parser = Xml.newPullParser();
                parser.setInput((Reader)confreader);
                XmlUtils.beginDocument((XmlPullParser)parser, (String)"devices");
                while (true) {
                    XmlUtils.nextElement((XmlPullParser)parser);
                    if (!"device".equals(parser.getName())) {
                        break;
                    }
                    String name = parser.getAttributeValue(null, "name");
                    if (name == null) continue;
                    names.add(name);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                Slog.e((String)TAG, (String)("Exception while parsing '" + confFile.getAbsolutePath() + "'"), (Throwable)e);
            }
            finally {
                try {
                    if (confreader != null) {
                        confreader.close();
                    }
                }
                catch (IOException e) {}
            }
            return names.toArray(new String[names.size()]);
        }

        public int getKeyRepeatTimeout() {
            return ViewConfiguration.getKeyRepeatTimeout();
        }

        public int getKeyRepeatDelay() {
            return ViewConfiguration.getKeyRepeatDelay();
        }

        public int getHoverTapTimeout() {
            return ViewConfiguration.getHoverTapTimeout();
        }

        public int getHoverTapSlop() {
            return ViewConfiguration.getHoverTapSlop();
        }

        public int getDoubleTapTimeout() {
            return ViewConfiguration.getDoubleTapTimeout();
        }

        public int getLongPressTimeout() {
            return ViewConfiguration.getLongPressTimeout();
        }

        public int getMaxEventsPerSecond() {
            int result = 0;
            try {
                result = Integer.parseInt(SystemProperties.get((String)"windowsmgr.max_events_per_sec"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (result < 1) {
                result = 90;
            }
            return result;
        }

        public int getPointerLayer() {
            return ((InputManager)InputManager.this).mWindowManagerService.mPolicy.windowTypeToLayerLw(2018) * 10000 + 1000;
        }

        public PointerIcon getPointerIcon() {
            return PointerIcon.getDefaultIcon((Context)InputManager.this.mContext);
        }
    }

    private final class InputFilterHost
    implements InputFilter.Host {
        private boolean mDisconnected;

        private InputFilterHost() {
        }

        public void disconnectLocked() {
            this.mDisconnected = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendInputEvent(InputEvent event, int policyFlags) {
            if (event == null) {
                throw new IllegalArgumentException("event must not be null");
            }
            Object object = InputManager.this.mInputFilterLock;
            synchronized (object) {
                if (!this.mDisconnected) {
                    InputManager.nativeInjectInputEvent(event, 0, 0, 0, 0, policyFlags | 0x4000000);
                }
            }
        }
    }
}

