/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.InputChannel;
import android.view.KeyEvent;
import android.view.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.InputApplicationHandle;
import com.android.server.wm.InputWindowHandle;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

final class InputMonitor {
    private final WindowManagerService mService;
    private WindowState mInputFocus;
    private boolean mInputDispatchFrozen;
    private boolean mInputDispatchEnabled = true;
    private boolean mUpdateInputWindowsNeeded = true;
    private InputWindowHandle[] mInputWindowHandles;
    private int mInputWindowHandleCount;
    private final Object mInputDevicesReadyMonitor = new Object();
    private boolean mInputDevicesReady;

    public InputMonitor(WindowManagerService service) {
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInputChannelBroken(InputWindowHandle inputWindowHandle) {
        if (inputWindowHandle == null) {
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = (WindowState)inputWindowHandle.windowState;
            if (windowState != null) {
                Slog.i((String)"WindowManager", (String)("WINDOW DIED " + windowState));
                this.mService.removeWindowLocked(windowState.mSession, windowState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long notifyANR(InputApplicationHandle inputApplicationHandle, InputWindowHandle inputWindowHandle) {
        AppWindowToken appWindowToken = null;
        if (inputWindowHandle != null) {
            HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = (WindowState)inputWindowHandle.windowState;
                if (windowState != null) {
                    Slog.i((String)"WindowManager", (String)("Input event dispatching timed out sending to " + windowState.mAttrs.getTitle()));
                    appWindowToken = windowState.mAppToken;
                }
            }
        }
        if (appWindowToken == null && inputApplicationHandle != null && (appWindowToken = inputApplicationHandle.appWindowToken) != null) {
            Slog.i((String)"WindowManager", (String)("Input event dispatching timed out sending to application " + appWindowToken.stringName));
        }
        if (appWindowToken != null && appWindowToken.appToken != null) {
            try {
                boolean abort = appWindowToken.appToken.keyDispatchingTimedOut();
                if (!abort) {
                    return appWindowToken.inputDispatchingTimeoutNanos;
                }
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return 0L;
    }

    private void addInputWindowHandleLw(InputWindowHandle windowHandle) {
        if (this.mInputWindowHandles == null) {
            this.mInputWindowHandles = new InputWindowHandle[16];
        }
        if (this.mInputWindowHandleCount >= this.mInputWindowHandles.length) {
            this.mInputWindowHandles = Arrays.copyOf(this.mInputWindowHandles, this.mInputWindowHandleCount * 2);
        }
        this.mInputWindowHandles[this.mInputWindowHandleCount++] = windowHandle;
    }

    private void clearInputWindowHandlesLw() {
        while (this.mInputWindowHandleCount != 0) {
            this.mInputWindowHandles[--this.mInputWindowHandleCount] = null;
        }
    }

    public void setUpdateInputWindowsNeededLw() {
        this.mUpdateInputWindowsNeeded = true;
    }

    public void updateInputWindowsLw(boolean force) {
        boolean inDrag;
        if (!force && !this.mUpdateInputWindowsNeeded) {
            return;
        }
        this.mUpdateInputWindowsNeeded = false;
        ArrayList<WindowState> windows = this.mService.mWindows;
        boolean bl = inDrag = this.mService.mDragState != null;
        if (inDrag) {
            InputWindowHandle dragWindowHandle = this.mService.mDragState.mDragWindowHandle;
            if (dragWindowHandle != null) {
                this.addInputWindowHandleLw(dragWindowHandle);
            } else {
                Slog.w((String)"WindowManager", (String)"Drag is in progress but there is no drag window handle.");
            }
        }
        int NFW = this.mService.mFakeWindows.size();
        for (int i = 0; i < NFW; ++i) {
            this.addInputWindowHandleLw(this.mService.mFakeWindows.get((int)i).mWindowHandle);
        }
        int N = windows.size();
        for (int i = N - 1; i >= 0; --i) {
            boolean hasWallpaper;
            WindowState child = windows.get(i);
            InputChannel inputChannel = child.mInputChannel;
            InputWindowHandle inputWindowHandle = child.mInputWindowHandle;
            if (inputChannel == null || inputWindowHandle == null || child.mRemoved) continue;
            int flags = child.mAttrs.flags;
            int type = child.mAttrs.type;
            boolean hasFocus = child == this.mInputFocus;
            boolean isVisible = child.isVisibleLw();
            boolean bl2 = hasWallpaper = child == this.mService.mWallpaperTarget && type != 2004;
            if (inDrag && isVisible) {
                this.mService.mDragState.sendDragStartedIfNeededLw(child);
            }
            inputWindowHandle.name = child.toString();
            inputWindowHandle.layoutParamsFlags = flags;
            inputWindowHandle.layoutParamsType = type;
            inputWindowHandle.dispatchingTimeoutNanos = child.getInputDispatchingTimeoutNanos();
            inputWindowHandle.visible = isVisible;
            inputWindowHandle.canReceiveKeys = child.canReceiveKeys();
            inputWindowHandle.hasFocus = hasFocus;
            inputWindowHandle.hasWallpaper = hasWallpaper;
            inputWindowHandle.paused = child.mAppToken != null ? child.mAppToken.paused : false;
            inputWindowHandle.layer = child.mLayer;
            inputWindowHandle.ownerPid = child.mSession.mPid;
            inputWindowHandle.ownerUid = child.mSession.mUid;
            inputWindowHandle.inputFeatures = child.mAttrs.inputFeatures;
            Rect frame = child.mFrame;
            inputWindowHandle.frameLeft = frame.left;
            inputWindowHandle.frameTop = frame.top;
            inputWindowHandle.frameRight = frame.right;
            inputWindowHandle.frameBottom = frame.bottom;
            inputWindowHandle.scaleFactor = child.mGlobalScale != 1.0f ? 1.0f / child.mGlobalScale : 1.0f;
            child.getTouchableRegion(inputWindowHandle.touchableRegion);
            this.addInputWindowHandleLw(inputWindowHandle);
        }
        this.mService.mInputManager.setInputWindows(this.mInputWindowHandles);
        this.clearInputWindowHandlesLw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConfigurationChanged() {
        this.mService.sendNewConfiguration();
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                this.mInputDevicesReady = true;
                this.mInputDevicesReadyMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForInputDevicesReady(long timeoutMillis) {
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                try {
                    this.mInputDevicesReadyMonitor.wait(timeoutMillis);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return this.mInputDevicesReady;
        }
    }

    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        this.mService.mPolicy.notifyLidSwitchChanged(whenNanos, lidOpen);
    }

    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags, boolean isScreenOn) {
        return this.mService.mPolicy.interceptKeyBeforeQueueing(event, policyFlags, isScreenOn);
    }

    public int interceptMotionBeforeQueueingWhenScreenOff(int policyFlags) {
        return this.mService.mPolicy.interceptMotionBeforeQueueingWhenScreenOff(policyFlags);
    }

    public long interceptKeyBeforeDispatching(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.interceptKeyBeforeDispatching((WindowManagerPolicy.WindowState)windowState, event, policyFlags);
    }

    public KeyEvent dispatchUnhandledKey(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.dispatchUnhandledKey((WindowManagerPolicy.WindowState)windowState, event, policyFlags);
    }

    public void setInputFocusLw(WindowState newWindow, boolean updateInputWindows) {
        if (newWindow != this.mInputFocus) {
            if (newWindow != null && newWindow.canReceiveKeys()) {
                newWindow.mToken.paused = false;
            }
            this.mInputFocus = newWindow;
            this.setUpdateInputWindowsNeededLw();
            if (updateInputWindows) {
                this.updateInputWindowsLw(false);
            }
        }
    }

    public void setFocusedAppLw(AppWindowToken newApp) {
        if (newApp == null) {
            this.mService.mInputManager.setFocusedApplication(null);
        } else {
            InputApplicationHandle handle = newApp.mInputApplicationHandle;
            handle.name = newApp.toString();
            handle.dispatchingTimeoutNanos = newApp.inputDispatchingTimeoutNanos;
            this.mService.mInputManager.setFocusedApplication(handle);
        }
    }

    public void pauseDispatchingLw(WindowToken window) {
        if (!window.paused) {
            window.paused = true;
            this.updateInputWindowsLw(true);
        }
    }

    public void resumeDispatchingLw(WindowToken window) {
        if (window.paused) {
            window.paused = false;
            this.updateInputWindowsLw(true);
        }
    }

    public void freezeInputDispatchingLw() {
        if (!this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = true;
            this.updateInputDispatchModeLw();
        }
    }

    public void thawInputDispatchingLw() {
        if (this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = false;
            this.updateInputDispatchModeLw();
        }
    }

    public void setEventDispatchingLw(boolean enabled) {
        if (this.mInputDispatchEnabled != enabled) {
            this.mInputDispatchEnabled = enabled;
            this.updateInputDispatchModeLw();
        }
    }

    private void updateInputDispatchModeLw() {
        this.mService.mInputManager.setInputDispatchMode(this.mInputDispatchEnabled, this.mInputDispatchFrozen);
    }
}

