/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Slog;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import com.android.server.wm.BlackFrame;

class ScreenRotationAnimation {
    static final String TAG = "ScreenRotationAnimation";
    static final boolean DEBUG = false;
    static final int FREEZE_LAYER = 2000000;
    final Context mContext;
    Surface mSurface;
    BlackFrame mBlackFrame;
    int mWidth;
    int mHeight;
    int mSnapshotRotation;
    int mSnapshotDeltaRotation;
    int mOriginalRotation;
    int mOriginalWidth;
    int mOriginalHeight;
    int mCurRotation;
    Animation mExitAnimation;
    final Transformation mExitTransformation;
    Animation mEnterAnimation;
    final Transformation mEnterTransformation;
    boolean mStarted;
    final Matrix mSnapshotInitialMatrix;
    final Matrix mSnapshotFinalMatrix;
    final Matrix mTmpMatrix;
    final float[] mTmpFloats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenRotationAnimation(Context context, SurfaceSession session, boolean inTransaction, int originalWidth, int originalHeight, int originalRotation) {
        block10: {
            block11: {
                this.mExitTransformation = new Transformation();
                this.mEnterTransformation = new Transformation();
                this.mSnapshotInitialMatrix = new Matrix();
                this.mSnapshotFinalMatrix = new Matrix();
                this.mTmpMatrix = new Matrix();
                this.mTmpFloats = new float[9];
                this.mContext = context;
                this.mSnapshotRotation = 0;
                if (originalRotation == 1 || originalRotation == 3) {
                    this.mWidth = originalHeight;
                    this.mHeight = originalWidth;
                } else {
                    this.mWidth = originalWidth;
                    this.mHeight = originalHeight;
                }
                this.mOriginalRotation = originalRotation;
                this.mOriginalWidth = originalWidth;
                this.mOriginalHeight = originalHeight;
                if (!inTransaction) {
                    Surface.openTransaction();
                }
                this.mSurface = new Surface(session, 0, "FreezeSurface", -1, this.mWidth, this.mHeight, -1, 196612);
                if (this.mSurface != null && this.mSurface.isValid()) break block10;
                this.mSurface = null;
                if (inTransaction) break block11;
                Surface.closeTransaction();
            }
            return;
        }
        try {
            try {
                this.mSurface.setLayer(2000001);
                this.mSurface.show();
            }
            catch (Surface.OutOfResourcesException e) {
                Slog.w((String)TAG, (String)"Unable to allocate freeze surface", (Throwable)e);
            }
            this.setRotation(originalRotation);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!inTransaction) {
                Surface.closeTransaction();
            }
        }
    }

    boolean hasScreenshot() {
        return this.mSurface != null;
    }

    static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    void setSnapshotTransform(Matrix matrix, float alpha) {
        if (this.mSurface != null) {
            matrix.getValues(this.mTmpFloats);
            this.mSurface.setPosition(this.mTmpFloats[2], this.mTmpFloats[5]);
            this.mSurface.setMatrix(this.mTmpFloats[0], this.mTmpFloats[3], this.mTmpFloats[1], this.mTmpFloats[4]);
            this.mSurface.setAlpha(alpha);
        }
    }

    public static void createRotationMatrix(int rotation, int width, int height, Matrix outMatrix) {
        switch (rotation) {
            case 0: {
                outMatrix.reset();
                break;
            }
            case 1: {
                outMatrix.setRotate(90.0f, 0.0f, 0.0f);
                outMatrix.postTranslate((float)height, 0.0f);
                break;
            }
            case 2: {
                outMatrix.setRotate(180.0f, 0.0f, 0.0f);
                outMatrix.postTranslate((float)width, (float)height);
                break;
            }
            case 3: {
                outMatrix.setRotate(270.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(0.0f, (float)width);
            }
        }
    }

    public void setRotation(int rotation) {
        this.mCurRotation = rotation;
        int delta = ScreenRotationAnimation.deltaRotation(rotation, this.mSnapshotRotation);
        ScreenRotationAnimation.createRotationMatrix(delta, this.mWidth, this.mHeight, this.mSnapshotInitialMatrix);
        this.setSnapshotTransform(this.mSnapshotInitialMatrix, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dismiss(SurfaceSession session, long maxAnimationDuration, float animationScale, int finalWidth, int finalHeight) {
        if (this.mSurface == null) {
            return false;
        }
        int delta = ScreenRotationAnimation.deltaRotation(this.mCurRotation, this.mOriginalRotation);
        switch (delta) {
            case 0: {
                this.mExitAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432621);
                this.mEnterAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432620);
                break;
            }
            case 1: {
                this.mExitAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432627);
                this.mEnterAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432626);
                break;
            }
            case 2: {
                this.mExitAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432623);
                this.mEnterAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432622);
                break;
            }
            case 3: {
                this.mExitAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432625);
                this.mEnterAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432624);
            }
        }
        this.mEnterAnimation.initialize(finalWidth, finalHeight, this.mOriginalWidth, this.mOriginalHeight);
        this.mExitAnimation.initialize(finalWidth, finalHeight, this.mOriginalWidth, this.mOriginalHeight);
        this.mStarted = false;
        this.mExitAnimation.restrictDuration(maxAnimationDuration);
        this.mExitAnimation.scaleCurrentDuration(animationScale);
        this.mEnterAnimation.restrictDuration(maxAnimationDuration);
        this.mEnterAnimation.scaleCurrentDuration(animationScale);
        Surface.openTransaction();
        try {
            Rect outer = new Rect(-finalWidth, -finalHeight, finalWidth * 2, finalHeight * 2);
            Rect inner = new Rect(0, 0, finalWidth, finalHeight);
            this.mBlackFrame = new BlackFrame(session, outer, inner, 2000000);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.w((String)TAG, (String)"Unable to allocate black surface", (Throwable)e);
        }
        finally {
            Surface.closeTransaction();
        }
        return true;
    }

    public void kill() {
        if (this.mSurface != null) {
            this.mSurface.destroy();
            this.mSurface = null;
        }
        if (this.mBlackFrame != null) {
            this.mBlackFrame.kill();
        }
        if (this.mExitAnimation != null) {
            this.mExitAnimation.cancel();
            this.mExitAnimation = null;
        }
        if (this.mEnterAnimation != null) {
            this.mEnterAnimation.cancel();
            this.mEnterAnimation = null;
        }
    }

    public boolean isAnimating() {
        return this.mEnterAnimation != null || this.mExitAnimation != null;
    }

    public boolean stepAnimation(long now) {
        if (this.mEnterAnimation == null && this.mExitAnimation == null) {
            return false;
        }
        if (!this.mStarted) {
            if (this.mEnterAnimation != null) {
                this.mEnterAnimation.setStartTime(now);
            }
            if (this.mExitAnimation != null) {
                this.mExitAnimation.setStartTime(now);
            }
            this.mStarted = true;
        }
        this.mExitTransformation.clear();
        boolean moreExit = false;
        if (this.mExitAnimation != null && !(moreExit = this.mExitAnimation.getTransformation(now, this.mExitTransformation))) {
            this.mExitAnimation.cancel();
            this.mExitAnimation = null;
            this.mExitTransformation.clear();
            if (this.mSurface != null) {
                this.mSurface.hide();
            }
        }
        this.mEnterTransformation.clear();
        boolean moreEnter = false;
        if (this.mEnterAnimation != null) {
            moreEnter = this.mEnterAnimation.getTransformation(now, this.mEnterTransformation);
            if (!moreEnter) {
                this.mEnterAnimation.cancel();
                this.mEnterAnimation = null;
                this.mEnterTransformation.clear();
                if (this.mBlackFrame != null) {
                    this.mBlackFrame.hide();
                }
            } else if (this.mBlackFrame != null) {
                this.mBlackFrame.setMatrix(this.mEnterTransformation.getMatrix());
            }
        }
        this.mSnapshotFinalMatrix.setConcat(this.mExitTransformation.getMatrix(), this.mSnapshotInitialMatrix);
        this.setSnapshotTransform(this.mSnapshotFinalMatrix, this.mExitTransformation.getAlpha());
        return moreEnter || moreExit;
    }

    public Transformation getEnterTransformation() {
        return this.mEnterTransformation;
    }
}

