/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.HashMap;

final class Session
extends IWindowSession.Stub
implements IBinder.DeathRecipient {
    final WindowManagerService mService;
    final IInputMethodClient mClient;
    final IInputContext mInputContext;
    final int mUid;
    final int mPid;
    final String mStringName;
    SurfaceSession mSurfaceSession;
    int mNumWindow = 0;
    boolean mClientDead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session(WindowManagerService service, IInputMethodClient client, IInputContext inputContext) {
        this.mService = service;
        this.mClient = client;
        this.mInputContext = inputContext;
        this.mUid = Binder.getCallingUid();
        this.mPid = Binder.getCallingPid();
        StringBuilder sb = new StringBuilder();
        sb.append("Session{");
        sb.append(Integer.toHexString(System.identityHashCode((Object)this)));
        sb.append(" uid ");
        sb.append(this.mUid);
        sb.append("}");
        this.mStringName = sb.toString();
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mService.mInputMethodManager == null && this.mService.mHaveInputMethods) {
                IBinder b = ServiceManager.getService((String)"input_method");
                this.mService.mInputMethodManager = IInputMethodManager.Stub.asInterface((IBinder)b);
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.mService.mInputMethodManager != null) {
                this.mService.mInputMethodManager.addClient(client, inputContext, this.mUid, this.mPid);
            } else {
                client.setUsingInputMethod(false);
            }
            client.asBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
        }
        catch (RemoteException e) {
            try {
                if (this.mService.mInputMethodManager != null) {
                    this.mService.mInputMethodManager.removeClient(client);
                }
            }
            catch (RemoteException ee) {
                // empty catch block
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.e((String)"WindowManager", (String)"Window Session Crash", (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void binderDied() {
        try {
            if (this.mService.mInputMethodManager != null) {
                this.mService.mInputMethodManager.removeClient(this.mClient);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mClient.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            this.mClientDead = true;
            this.killSessionLocked();
        }
    }

    public int add(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, Rect outContentInsets, InputChannel outInputChannel) {
        return this.mService.addWindow(this, window, seq, attrs, viewVisibility, outContentInsets, outInputChannel);
    }

    public int addWithoutInputChannel(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, Rect outContentInsets) {
        return this.mService.addWindow(this, window, seq, attrs, viewVisibility, outContentInsets, null);
    }

    public void remove(IWindow window) {
        this.mService.removeWindow(this, window);
    }

    public int relayout(IWindow window, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, Rect outFrame, Rect outContentInsets, Rect outVisibleInsets, Configuration outConfig, Surface outSurface) {
        int res = this.mService.relayoutWindow(this, window, seq, attrs, requestedWidth, requestedHeight, viewFlags, flags, outFrame, outContentInsets, outVisibleInsets, outConfig, outSurface);
        return res;
    }

    public void performDeferredDestroy(IWindow window) {
        this.mService.performDeferredDestroyWindow(this, window);
    }

    public boolean outOfMemory(IWindow window) {
        return this.mService.outOfMemoryWindow(this, window);
    }

    public void setTransparentRegion(IWindow window, Region region) {
        this.mService.setTransparentRegionWindow(this, window, region);
    }

    public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableArea) {
        this.mService.setInsetsWindow(this, window, touchableInsets, contentInsets, visibleInsets, touchableArea);
    }

    public void getDisplayFrame(IWindow window, Rect outDisplayFrame) {
        this.mService.getWindowDisplayFrame(this, window, outDisplayFrame);
    }

    public void finishDrawing(IWindow window) {
        this.mService.finishDrawingWindow(this, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mService.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInTouchMode() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            return this.mService.mInTouchMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performHapticFeedback(IWindow window, int effectId, boolean always) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            boolean bl;
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.mService.mPolicy.performHapticFeedbackLw((WindowManagerPolicy.WindowState)this.mService.windowForClientLocked(this, window, true), effectId, always);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl;
        }
    }

    public IBinder prepareDrag(IWindow window, int flags, int width, int height, Surface outSurface) {
        return this.mService.prepareDragSurface(window, this.mSurfaceSession, flags, width, height, outSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performDrag(IWindow window, IBinder dragToken, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mService.mDragState == null) {
                Slog.w((String)"WindowManager", (String)"No drag prepared");
                throw new IllegalStateException("performDrag() without prepareDrag()");
            }
            if (dragToken != this.mService.mDragState.mToken) {
                Slog.w((String)"WindowManager", (String)"Performing mismatched drag");
                throw new IllegalStateException("performDrag() does not match prepareDrag()");
            }
            WindowState callingWin = this.mService.windowForClientLocked(null, window, false);
            if (callingWin == null) {
                Slog.w((String)"WindowManager", (String)("Bad requesting window " + window));
                return false;
            }
            this.mService.mH.removeMessages(20, window.asBinder());
            this.mService.mDragState.register();
            this.mService.mInputMonitor.updateInputWindowsLw(true);
            if (!this.mService.mInputManager.transferTouchFocus(callingWin.mInputChannel, this.mService.mDragState.mServerChannel)) {
                Slog.e((String)"WindowManager", (String)"Unable to transfer touch focus");
                this.mService.mDragState.unregister();
                this.mService.mDragState = null;
                this.mService.mInputMonitor.updateInputWindowsLw(true);
                return false;
            }
            this.mService.mDragState.mData = data;
            this.mService.mDragState.mCurrentX = touchX;
            this.mService.mDragState.mCurrentY = touchY;
            this.mService.mDragState.broadcastDragStartedLw(touchX, touchY);
            this.mService.mDragState.mThumbOffsetX = thumbCenterX;
            this.mService.mDragState.mThumbOffsetY = thumbCenterY;
            Surface surface = this.mService.mDragState.mSurface;
            Surface.openTransaction();
            try {
                surface.setPosition(touchX - thumbCenterX, touchY - thumbCenterY);
                surface.setAlpha(0.7071f);
                surface.setLayer(this.mService.mDragState.getDragLayerLw());
                surface.show();
            }
            finally {
                Surface.closeTransaction();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportDropResult(IWindow window, boolean consumed) {
        IBinder token = window.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mService.mDragState == null) {
                    Slog.w((String)"WindowManager", (String)"Drop result given but no drag in progress");
                    return;
                }
                if (this.mService.mDragState.mToken != token) {
                    Slog.w((String)"WindowManager", (String)("Invalid drop-result claim by " + window));
                    throw new IllegalStateException("reportDropResult() by non-recipient");
                }
                this.mService.mH.removeMessages(21, window.asBinder());
                WindowState callingWin = this.mService.windowForClientLocked(null, window, false);
                if (callingWin == null) {
                    Slog.w((String)"WindowManager", (String)("Bad result-reporting window " + window));
                    return;
                }
                this.mService.mDragState.mDragResult = consumed;
                this.mService.mDragState.endDragLw();
            }
            finally {
                Binder.restoreCallingIdentity((long)ident);
            }
            return;
        }
    }

    public void dragRecipientEntered(IWindow window) {
    }

    public void dragRecipientExited(IWindow window) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWallpaperPosition(IBinder window, float x, float y, float xStep, float yStep) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mService.setWindowWallpaperPositionLocked(this.mService.windowForClientLocked(this, window, true), x, y, xStep, yStep);
            }
            finally {
                Binder.restoreCallingIdentity((long)ident);
            }
        }
    }

    public void wallpaperOffsetsComplete(IBinder window) {
        this.mService.wallpaperOffsetsComplete(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            Bundle bundle;
            long ident = Binder.clearCallingIdentity();
            try {
                bundle = this.mService.sendWindowWallpaperCommandLocked(this.mService.windowForClientLocked(this, window, true), action, x, y, z, extras, sync);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return bundle;
        }
    }

    public void wallpaperCommandComplete(IBinder window, Bundle result) {
        this.mService.wallpaperCommandComplete(window, result);
    }

    void windowAddedLocked() {
        if (this.mSurfaceSession == null) {
            this.mSurfaceSession = new SurfaceSession();
            this.mService.mSessions.add(this);
        }
        ++this.mNumWindow;
    }

    void windowRemovedLocked() {
        --this.mNumWindow;
        this.killSessionLocked();
    }

    void killSessionLocked() {
        if (this.mNumWindow <= 0 && this.mClientDead) {
            this.mService.mSessions.remove((Object)this);
            if (this.mSurfaceSession != null) {
                try {
                    this.mSurfaceSession.kill();
                }
                catch (Exception e) {
                    Slog.w((String)"WindowManager", (String)("Exception thrown when killing surface session " + this.mSurfaceSession + " in session " + (Object)((Object)this) + ": " + e.toString()));
                }
                this.mSurfaceSession = null;
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mNumWindow=");
        pw.print(this.mNumWindow);
        pw.print(" mClientDead=");
        pw.print(this.mClientDead);
        pw.print(" mSurfaceSession=");
        pw.println(this.mSurfaceSession);
    }

    public String toString() {
        return this.mStringName;
    }
}

