/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceSession;

class StrictModeFlash {
    private static final String TAG = "StrictModeFlash";
    Surface mSurface;
    int mLastDW;
    int mLastDH;
    boolean mDrawNeeded;
    final int mThickness = 20;

    public StrictModeFlash(Display display, SurfaceSession session) {
        try {
            this.mSurface = new Surface(session, 0, TAG, -1, 1, 1, -3, 0);
        }
        catch (Surface.OutOfResourcesException e) {
            return;
        }
        this.mSurface.setLayer(1010000);
        this.mSurface.setPosition(0, 0);
        this.mDrawNeeded = true;
    }

    private void drawIfNeeded() {
        if (!this.mDrawNeeded) {
            return;
        }
        this.mDrawNeeded = false;
        int dw = this.mLastDW;
        int dh = this.mLastDH;
        Rect dirty = new Rect(0, 0, dw, dh);
        Canvas c = null;
        try {
            c = this.mSurface.lockCanvas(dirty);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Surface.OutOfResourcesException e) {
            // empty catch block
        }
        if (c == null) {
            return;
        }
        c.clipRect(new Rect(0, 0, dw, 20), Region.Op.REPLACE);
        c.drawColor(-65536);
        c.clipRect(new Rect(0, 0, 20, dh), Region.Op.REPLACE);
        c.drawColor(-65536);
        c.clipRect(new Rect(dw - 20, 0, dw, dh), Region.Op.REPLACE);
        c.drawColor(-65536);
        c.clipRect(new Rect(0, dh - 20, dw, dh), Region.Op.REPLACE);
        c.drawColor(-65536);
        this.mSurface.unlockCanvasAndPost(c);
    }

    public void setVisibility(boolean on) {
        if (this.mSurface == null) {
            return;
        }
        this.drawIfNeeded();
        if (on) {
            this.mSurface.show();
        } else {
            this.mSurface.hide();
        }
    }

    void positionSurface(int dw, int dh) {
        if (this.mLastDW == dw && this.mLastDH == dh) {
            return;
        }
        this.mLastDW = dw;
        this.mLastDH = dh;
        this.mSurface.setSize(dw, dh);
        this.mDrawNeeded = true;
    }
}

