/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.Slog;
import com.android.server.wm.WindowManagerService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ViewServer
implements Runnable {
    public static final int VIEW_SERVER_DEFAULT_PORT = 4939;
    private static final int VIEW_SERVER_MAX_CONNECTIONS = 10;
    private static final String LOG_TAG = "ViewServer";
    private static final String VALUE_PROTOCOL_VERSION = "4";
    private static final String VALUE_SERVER_VERSION = "4";
    private static final String COMMAND_PROTOCOL_VERSION = "PROTOCOL";
    private static final String COMMAND_SERVER_VERSION = "SERVER";
    private static final String COMMAND_WINDOW_MANAGER_LIST = "LIST";
    private static final String COMMAND_WINDOW_MANAGER_AUTOLIST = "AUTOLIST";
    private static final String COMMAND_WINDOW_MANAGER_GET_FOCUS = "GET_FOCUS";
    private ServerSocket mServer;
    private Thread mThread;
    private final WindowManagerService mWindowManager;
    private final int mPort;
    private ExecutorService mThreadPool;

    ViewServer(WindowManagerService windowManager, int port) {
        this.mWindowManager = windowManager;
        this.mPort = port;
    }

    boolean start() throws IOException {
        if (this.mThread != null) {
            return false;
        }
        this.mServer = new ServerSocket(this.mPort, 10, InetAddress.getLocalHost());
        this.mThread = new Thread((Runnable)this, "Remote View Server [port=" + this.mPort + "]");
        this.mThreadPool = Executors.newFixedThreadPool(10);
        this.mThread.start();
        return true;
    }

    boolean stop() {
        if (this.mThread != null) {
            this.mThread.interrupt();
            if (this.mThreadPool != null) {
                try {
                    this.mThreadPool.shutdownNow();
                }
                catch (SecurityException e) {
                    Slog.w((String)LOG_TAG, (String)"Could not stop all view server threads");
                }
            }
            this.mThreadPool = null;
            this.mThread = null;
            try {
                this.mServer.close();
                this.mServer = null;
                return true;
            }
            catch (IOException e) {
                Slog.w((String)LOG_TAG, (String)"Could not close the view server");
            }
        }
        return false;
    }

    boolean isRunning() {
        return this.mThread != null && this.mThread.isAlive();
    }

    public void run() {
        while (Thread.currentThread() == this.mThread) {
            try {
                Socket client = this.mServer.accept();
                if (this.mThreadPool != null) {
                    this.mThreadPool.submit(new ViewServerWorker(client));
                    continue;
                }
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Slog.w((String)LOG_TAG, (String)"Connection error: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeValue(Socket client, String value) {
        boolean result;
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            out.write(value);
            out.write("\n");
            out.flush();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    class ViewServerWorker
    implements Runnable,
    WindowManagerService.WindowChangeListener {
        private Socket mClient;
        private boolean mNeedWindowListUpdate;
        private boolean mNeedFocusedWindowUpdate;

        public ViewServerWorker(Socket client) {
            this.mClient = client;
            this.mNeedWindowListUpdate = false;
            this.mNeedFocusedWindowUpdate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader in = null;
            try {
                String parameters;
                String command;
                in = new BufferedReader(new InputStreamReader(this.mClient.getInputStream()), 1024);
                String request = in.readLine();
                int index = request.indexOf(32);
                if (index == -1) {
                    command = request;
                    parameters = "";
                } else {
                    command = request.substring(0, index);
                    parameters = request.substring(index + 1);
                }
                boolean result = ViewServer.COMMAND_PROTOCOL_VERSION.equalsIgnoreCase(command) ? ViewServer.writeValue(this.mClient, "4") : (ViewServer.COMMAND_SERVER_VERSION.equalsIgnoreCase(command) ? ViewServer.writeValue(this.mClient, "4") : (ViewServer.COMMAND_WINDOW_MANAGER_LIST.equalsIgnoreCase(command) ? ViewServer.this.mWindowManager.viewServerListWindows(this.mClient) : (ViewServer.COMMAND_WINDOW_MANAGER_GET_FOCUS.equalsIgnoreCase(command) ? ViewServer.this.mWindowManager.viewServerGetFocusedWindow(this.mClient) : (ViewServer.COMMAND_WINDOW_MANAGER_AUTOLIST.equalsIgnoreCase(command) ? this.windowManagerAutolistLoop() : ViewServer.this.mWindowManager.viewServerWindowCommand(this.mClient, command, parameters)))));
                if (!result) {
                    Slog.w((String)ViewServer.LOG_TAG, (String)("An error occurred with the command: " + command));
                }
            }
            catch (IOException e) {
                Slog.w((String)ViewServer.LOG_TAG, (String)"Connection error: ", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mClient != null) {
                    try {
                        this.mClient.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowsChanged() {
            ViewServerWorker viewServerWorker = this;
            synchronized (viewServerWorker) {
                this.mNeedWindowListUpdate = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusChanged() {
            ViewServerWorker viewServerWorker = this;
            synchronized (viewServerWorker) {
                this.mNeedFocusedWindowUpdate = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean windowManagerAutolistLoop() {
            ViewServer.this.mWindowManager.addWindowChangeListener(this);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter(this.mClient.getOutputStream()));
                while (!Thread.interrupted()) {
                    boolean needWindowListUpdate = false;
                    boolean needFocusedWindowUpdate = false;
                    ViewServerWorker viewServerWorker = this;
                    synchronized (viewServerWorker) {
                        while (!this.mNeedWindowListUpdate && !this.mNeedFocusedWindowUpdate) {
                            this.wait();
                        }
                        if (this.mNeedWindowListUpdate) {
                            this.mNeedWindowListUpdate = false;
                            needWindowListUpdate = true;
                        }
                        if (this.mNeedFocusedWindowUpdate) {
                            this.mNeedFocusedWindowUpdate = false;
                            needFocusedWindowUpdate = true;
                        }
                    }
                    if (needWindowListUpdate) {
                        out.write("LIST UPDATE\n");
                        out.flush();
                    }
                    if (!needFocusedWindowUpdate) continue;
                    out.write("FOCUS UPDATE\n");
                    out.flush();
                }
            }
            catch (Exception e) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                ViewServer.this.mWindowManager.removeWindowChangeListener(this);
            }
            return true;
        }
    }
}

