/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.SurfaceSession;
import com.android.server.wm.WindowManagerService;

class Watermark {
    final String[] mTokens;
    final String mText;
    final Paint mTextPaint;
    final int mTextWidth;
    final int mTextHeight;
    final int mTextAscent;
    final int mTextDescent;
    final int mDeltaX;
    final int mDeltaY;
    Surface mSurface;
    int mLastDW;
    int mLastDH;
    boolean mDrawNeeded;

    Watermark(DisplayMetrics dm, SurfaceSession session, String[] tokens) {
        this.mTokens = tokens;
        StringBuilder builder = new StringBuilder(32);
        int len = this.mTokens[0].length();
        len &= 0xFFFFFFFE;
        for (int i = 0; i < len; i += 2) {
            int c1 = this.mTokens[0].charAt(i);
            int c2 = this.mTokens[0].charAt(i + 1);
            c1 = c1 >= 97 && c1 <= 102 ? c1 - 97 + 10 : (c1 >= 65 && c1 <= 70 ? c1 - 65 + 10 : (c1 -= 48));
            c2 = c2 >= 97 && c2 <= 102 ? c2 - 97 + 10 : (c2 >= 65 && c2 <= 70 ? c2 - 65 + 10 : (c2 -= 48));
            builder.append((char)(255 - (c1 * 16 + c2)));
        }
        this.mText = builder.toString();
        int fontSize = WindowManagerService.getPropertyInt(tokens, 1, 1, 20, dm);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setTextSize((float)fontSize);
        this.mTextPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
        Paint.FontMetricsInt fm = this.mTextPaint.getFontMetricsInt();
        this.mTextWidth = (int)this.mTextPaint.measureText(this.mText);
        this.mTextAscent = fm.ascent;
        this.mTextDescent = fm.descent;
        this.mTextHeight = fm.descent - fm.ascent;
        this.mDeltaX = WindowManagerService.getPropertyInt(tokens, 2, 0, this.mTextWidth * 2, dm);
        this.mDeltaY = WindowManagerService.getPropertyInt(tokens, 3, 0, this.mTextHeight * 3, dm);
        int shadowColor = WindowManagerService.getPropertyInt(tokens, 4, 0, -1342177280, dm);
        int color = WindowManagerService.getPropertyInt(tokens, 5, 0, 0x60FFFFFF, dm);
        int shadowRadius = WindowManagerService.getPropertyInt(tokens, 6, 0, 7, dm);
        int shadowDx = WindowManagerService.getPropertyInt(tokens, 8, 0, 0, dm);
        int shadowDy = WindowManagerService.getPropertyInt(tokens, 9, 0, 0, dm);
        this.mTextPaint.setColor(color);
        this.mTextPaint.setShadowLayer((float)shadowRadius, (float)shadowDx, (float)shadowDy, shadowColor);
        try {
            this.mSurface = new Surface(session, 0, "WatermarkSurface", -1, 1, 1, -3, 0);
            this.mSurface.setLayer(1000000);
            this.mSurface.setPosition(0, 0);
            this.mSurface.show();
        }
        catch (Surface.OutOfResourcesException e) {
            // empty catch block
        }
    }

    void positionSurface(int dw, int dh) {
        if (this.mLastDW != dw || this.mLastDH != dh) {
            this.mLastDW = dw;
            this.mLastDH = dh;
            this.mSurface.setSize(dw, dh);
            this.mDrawNeeded = true;
        }
    }

    void drawIfNeeded() {
        if (this.mDrawNeeded) {
            int dw = this.mLastDW;
            int dh = this.mLastDH;
            this.mDrawNeeded = false;
            Rect dirty = new Rect(0, 0, dw, dh);
            Canvas c = null;
            try {
                c = this.mSurface.lockCanvas(dirty);
            }
            catch (IllegalArgumentException e) {
            }
            catch (Surface.OutOfResourcesException e) {
                // empty catch block
            }
            if (c != null) {
                c.drawColor(0, PorterDuff.Mode.CLEAR);
                int deltaX = this.mDeltaX;
                int deltaY = this.mDeltaY;
                int div = (dw + this.mTextWidth) / deltaX;
                int rem = dw + this.mTextWidth - div * deltaX;
                int qdelta = deltaX / 4;
                if (rem < qdelta || rem > deltaX - qdelta) {
                    deltaX += deltaX / 3;
                }
                int y = -this.mTextHeight;
                int x = -this.mTextWidth;
                while (y < dh + this.mTextHeight) {
                    c.drawText(this.mText, (float)x, (float)y, this.mTextPaint);
                    if ((x += deltaX) < dw) continue;
                    x -= dw + this.mTextWidth;
                    y += deltaY;
                }
                this.mSurface.unlockCanvasAndPost(c);
            }
        }
    }
}

