/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.LocalPowerManager;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.TokenWatcher;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.Display;
import android.view.IApplicationToken;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import com.android.internal.R;
import com.android.internal.app.IBatteryStats;
import com.android.internal.policy.PolicyManager;
import com.android.internal.view.BaseInputHandler;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.AttributeCache;
import com.android.server.PowerManagerService;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BlackFrame;
import com.android.server.wm.DimAnimator;
import com.android.server.wm.DimSurface;
import com.android.server.wm.DragState;
import com.android.server.wm.FakeWindowImpl;
import com.android.server.wm.InputFilter;
import com.android.server.wm.InputManager;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StartingData;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.ViewServer;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean DEBUG_ADD_REMOVE = false;
    static final boolean DEBUG_FOCUS = false;
    static final boolean DEBUG_ANIM = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_RESIZE = false;
    static final boolean DEBUG_LAYERS = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_INPUT_METHOD = false;
    static final boolean DEBUG_VISIBILITY = false;
    static final boolean DEBUG_WINDOW_MOVEMENT = false;
    static final boolean DEBUG_TOKEN_MOVEMENT = false;
    static final boolean DEBUG_ORIENTATION = false;
    static final boolean DEBUG_APP_ORIENTATION = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_APP_TRANSITIONS = false;
    static final boolean DEBUG_STARTING_WINDOW = false;
    static final boolean DEBUG_REORDER = false;
    static final boolean DEBUG_WALLPAPER = false;
    static final boolean DEBUG_DRAG = false;
    static final boolean DEBUG_SCREEN_ON = false;
    static final boolean DEBUG_SCREENSHOT = false;
    static final boolean DEBUG_BOOT = false;
    static final boolean SHOW_SURFACE_ALLOC = false;
    static final boolean SHOW_TRANSACTIONS = false;
    static final boolean SHOW_LIGHT_TRANSACTIONS = false;
    static final boolean HIDE_STACK_CRAWLS = true;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean BLUR = true;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_BLUR = 2;
    static final int FREEZE_LAYER = 2000001;
    static final int MASK_LAYER = 2000000;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int DEFAULT_DIM_DURATION = 200;
    static final int DEFAULT_FADE_IN_OUT_DURATION = 400;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INJECTION_TIMEOUT_MILLIS = 30000;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private boolean mKeyguardDisabled = false;
    private static final int ALLOW_DISABLE_YES = 1;
    private static final int ALLOW_DISABLE_NO = 0;
    private static final int ALLOW_DISABLE_UNKNOWN = -1;
    private int mAllowDisableKeyguard = -1;
    final TokenWatcher mKeyguardTokenWatcher = new TokenWatcher(new Handler(), "WindowManagerService.mKeyguardTokenWatcher"){

        public void acquired() {
            if (WindowManagerService.this.shouldAllowDisableKeyguard()) {
                WindowManagerService.this.mPolicy.enableKeyguard(false);
                WindowManagerService.this.mKeyguardDisabled = true;
            } else {
                Log.v((String)WindowManagerService.TAG, (String)"Not disabling keyguard since device policy is enforced");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void released() {
            WindowManagerService.this.mPolicy.enableKeyguard(true);
            TokenWatcher tokenWatcher = WindowManagerService.this.mKeyguardTokenWatcher;
            synchronized (tokenWatcher) {
                WindowManagerService.this.mKeyguardDisabled = false;
                WindowManagerService.this.mKeyguardTokenWatcher.notifyAll();
            }
        }
    };
    final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            WindowManagerService.this.mPolicy.enableKeyguard(true);
            TokenWatcher tokenWatcher = WindowManagerService.this.mKeyguardTokenWatcher;
            synchronized (tokenWatcher) {
                WindowManagerService.this.mAllowDisableKeyguard = -1;
                WindowManagerService.this.mKeyguardDisabled = false;
            }
        }
    };
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final WindowManagerPolicy mPolicy = PolicyManager.makeNewWindowManager();
    final IActivityManager mActivityManager;
    final IBatteryStats mBatteryStats;
    final HashSet<Session> mSessions = new HashSet();
    final HashMap<IBinder, WindowState> mWindowMap = new HashMap();
    final HashMap<IBinder, WindowToken> mTokenMap = new HashMap();
    final ArrayList<WindowToken> mExitingTokens = new ArrayList();
    final ArrayList<AppWindowToken> mAppTokens = new ArrayList();
    final ArrayList<AppWindowToken> mExitingAppTokens = new ArrayList();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    final ArrayList<WindowState> mWindows = new ArrayList();
    final ArrayList<FakeWindowImpl> mFakeWindows = new ArrayList();
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    ArrayList<WindowState> mForceRemoves;
    ArrayList<Pair<WindowState, IRemoteCallback>> mWaitingForDrawn = new ArrayList();
    WindowState[] mRebuildTmp = new WindowState[20];
    IInputMethodManager mInputMethodManager;
    SurfaceSession mFxSession;
    private DimAnimator mDimAnimator = null;
    Surface mBlurSurface;
    boolean mBlurShown;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    ScreenRotationAnimation mScreenRotationAnimation;
    BlackFrame mBlackFrame;
    int mTransactionSequence = 0;
    final float[] mTmpFloats = new float[9];
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    final Object mDisplaySizeLock = new Object();
    int mInitialDisplayWidth = 0;
    int mInitialDisplayHeight = 0;
    int mBaseDisplayWidth = 0;
    int mBaseDisplayHeight = 0;
    int mCurDisplayWidth = 0;
    int mCurDisplayHeight = 0;
    int mAppDisplayWidth = 0;
    int mAppDisplayHeight = 0;
    int mRotation = 0;
    int mForcedAppOrientation = -1;
    boolean mAltOrientation = false;
    ArrayList<IRotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    boolean mLayoutNeeded = true;
    boolean mAnimationPending = false;
    boolean mDisplayFrozen = false;
    boolean mWaitingForConfig = false;
    boolean mWindowsFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastWindowForcedOrientation = -1;
    int mLayoutSeq = 0;
    int mLastStatusBarVisibility = 0;
    boolean mFocusMayChange;
    Configuration mCurConfiguration = new Configuration();
    PowerManager.WakeLock mScreenFrozenLock;
    int mNextAppTransition = -1;
    String mNextAppTransitionPackage;
    int mNextAppTransitionEnter;
    int mNextAppTransitionExit;
    boolean mAppTransitionReady = false;
    boolean mAppTransitionRunning = false;
    boolean mAppTransitionTimeout = false;
    boolean mStartingIconInTransition = false;
    boolean mSkipAppTransitionAnimation = false;
    final ArrayList<AppWindowToken> mOpeningApps = new ArrayList();
    final ArrayList<AppWindowToken> mClosingApps = new ArrayList();
    final ArrayList<AppWindowToken> mToTopApps = new ArrayList();
    final ArrayList<AppWindowToken> mToBottomApps = new ArrayList();
    Display mDisplay;
    final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mRealDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mTmpDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mCompatDisplayMetrics = new DisplayMetrics();
    H mH = new H();
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    int mInputMethodAnimLayerAdjustment;
    WindowState mInputMethodWindow = null;
    final ArrayList<WindowState> mInputMethodDialogs = new ArrayList();
    boolean mHardKeyboardAvailable;
    boolean mHardKeyboardEnabled;
    OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    final ArrayList<WindowToken> mWallpaperTokens = new ArrayList();
    WindowState mWallpaperTarget = null;
    WindowState mLowerWallpaperTarget = null;
    WindowState mUpperWallpaperTarget = null;
    WindowState mWindowDetachedWallpaper = null;
    DimSurface mWindowAnimationBackgroundSurface = null;
    int mWallpaperAnimLayerAdjustment;
    float mLastWallpaperX = -1.0f;
    float mLastWallpaperY = -1.0f;
    float mLastWallpaperXStep = -1.0f;
    float mLastWallpaperYStep = -1.0f;
    WindowState mWaitingOnWallpaper;
    long mLastWallpaperTimeoutTime;
    static final long WALLPAPER_TIMEOUT = 150L;
    static final long WALLPAPER_TIMEOUT_RECOVERY = 10000L;
    AppWindowToken mFocusedApp = null;
    PowerManagerService mPowerManager;
    float mWindowAnimationScale = 1.0f;
    float mTransitionAnimationScale = 1.0f;
    final InputManager mInputManager;
    Session mHoldingScreenOn;
    PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mTurnOnScreen;
    DragState mDragState = null;
    final InputHandler mDragInputHandler = new BaseInputHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMotion(MotionEvent event, InputQueue.FinishedCallback finishedCallback) {
            block21: {
                boolean handled = false;
                try {
                    HashMap<IBinder, WindowState> hashMap;
                    if ((event.getSource() & 2) == 0 || WindowManagerService.this.mDragState == null) break block21;
                    boolean endDrag = false;
                    float newX = event.getRawX();
                    float newY = event.getRawY();
                    switch (event.getAction()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                WindowManagerService.this.mDragState.notifyMoveLw(newX, newY);
                                break;
                            }
                        }
                        case 1: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                break;
                            }
                        }
                        case 3: {
                            endDrag = true;
                        }
                    }
                    if (endDrag) {
                        hashMap = WindowManagerService.this.mWindowMap;
                        synchronized (hashMap) {
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                    }
                    handled = true;
                }
                catch (Exception e) {
                    Slog.e((String)WindowManagerService.TAG, (String)"Exception caught by drag handleMotion", (Throwable)e);
                }
                finally {
                    finishedCallback.finished(handled);
                }
            }
        }
    };
    boolean mInTouchMode = true;
    private ViewServer mViewServer;
    private ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    private boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    float mCompatibleScreenScale;
    static final int ADJUST_WALLPAPER_LAYERS_CHANGED = 2;
    static final int ADJUST_WALLPAPER_VISIBILITY_CHANGED = 4;
    final InputMonitor mInputMonitor = new InputMonitor(this);
    static final Animation sDummyAnimation = new DummyAnimation();
    private boolean mInLayout = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowManagerService main(Context context, PowerManagerService pm, boolean haveInputMethods, boolean allowBootMsgs) {
        WMThread thr = new WMThread(context, pm, haveInputMethods, allowBootMsgs);
        thr.start();
        WMThread wMThread = thr;
        synchronized (wMThread) {
            while (thr.mService == null) {
                try {
                    thr.wait();
                }
                catch (InterruptedException e) {}
            }
            return thr.mService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowManagerService(Context context, PowerManagerService pm, boolean haveInputMethods, boolean showBootMsgs) {
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(0x1110006);
        this.mPowerManager = pm;
        this.mPowerManager.setPolicy(this.mPolicy);
        PowerManager pmc = (PowerManager)context.getSystemService("power");
        this.mScreenFrozenLock = pmc.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mActivityManager = ActivityManagerNative.getDefault();
        this.mBatteryStats = BatteryStatsService.getService();
        this.mWindowAnimationScale = Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"window_animation_scale", (float)this.mWindowAnimationScale);
        this.mTransitionAnimationScale = Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"transition_animation_scale", (float)this.mTransitionAnimationScale);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mHoldingScreenWakeLock = pmc.newWakeLock(10, "KEEP_SCREEN_ON_FLAG");
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mInputManager = new InputManager(context, this);
        PolicyThread thr = new PolicyThread(this.mPolicy, this, context, pm);
        thr.start();
        PolicyThread policyThread = thr;
        synchronized (policyThread) {
            while (!thr.mRunning) {
                try {
                    thr.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.mInputManager.start();
        Watchdog.getInstance().addMonitor(this);
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Log.wtf((String)TAG, (String)"Window Manager Crash", (Throwable)e);
            }
            throw e;
        }
    }

    private void placeWindowAfter(WindowState pos, WindowState window) {
        int i = this.mWindows.indexOf(pos);
        this.mWindows.add(i + 1, window);
        this.mWindowsChanged = true;
    }

    private void placeWindowBefore(WindowState pos, WindowState window) {
        int i = this.mWindows.indexOf(pos);
        this.mWindows.add(i, window);
        this.mWindowsChanged = true;
    }

    private int findIdxBasedOnAppTokens(WindowState win) {
        ArrayList<WindowState> localmWindows = this.mWindows;
        int jmax = localmWindows.size();
        if (jmax == 0) {
            return -1;
        }
        for (int j = jmax - 1; j >= 0; --j) {
            WindowState wentry = localmWindows.get(j);
            if (wentry.mAppToken != win.mAppToken) continue;
            return j;
        }
        return -1;
    }

    private void addWindowToListInOrderLocked(WindowState win, boolean addToToken) {
        IWindow client = win.mClient;
        WindowToken token = win.mToken;
        ArrayList<WindowState> localmWindows = this.mWindows;
        int N = localmWindows.size();
        WindowState attached = win.mAttachedWindow;
        if (attached == null) {
            int tokenWindowsPos = token.windows.size();
            if (token.appWindowToken != null) {
                int index = tokenWindowsPos - 1;
                if (index >= 0) {
                    if (win.mAttrs.type == 1) {
                        this.placeWindowBefore(token.windows.get(0), win);
                        tokenWindowsPos = 0;
                    } else {
                        AppWindowToken atoken = win.mAppToken;
                        if (atoken != null && token.windows.get(index) == atoken.startingWindow) {
                            this.placeWindowBefore(token.windows.get(index), win);
                            --tokenWindowsPos;
                        } else {
                            int newIdx = this.findIdxBasedOnAppTokens(win);
                            if (newIdx != -1) {
                                localmWindows.add(newIdx + 1, win);
                                this.mWindowsChanged = true;
                            }
                        }
                    }
                } else {
                    WindowToken atoken;
                    AppWindowToken t;
                    int i;
                    int NA = this.mAppTokens.size();
                    WindowState pos = null;
                    for (i = NA - 1; i >= 0; --i) {
                        t = this.mAppTokens.get(i);
                        if (t == token) {
                            --i;
                            break;
                        }
                        if (t.sendingToBottom || t.windows.size() <= 0) continue;
                        pos = (WindowState)t.windows.get(0);
                    }
                    if (pos != null) {
                        int NC;
                        atoken = this.mTokenMap.get(pos.mClient.asBinder());
                        if (atoken != null && (NC = atoken.windows.size()) > 0) {
                            WindowState bottom = atoken.windows.get(0);
                            if (bottom.mSubLayer < 0) {
                                pos = bottom;
                            }
                        }
                        this.placeWindowBefore(pos, win);
                    } else {
                        while (i >= 0) {
                            t = this.mAppTokens.get(i);
                            int NW = t.windows.size();
                            if (NW > 0) {
                                pos = (WindowState)t.windows.get(NW - 1);
                                break;
                            }
                            --i;
                        }
                        if (pos != null) {
                            int NC;
                            atoken = this.mTokenMap.get(pos.mClient.asBinder());
                            if (atoken != null && (NC = atoken.windows.size()) > 0) {
                                WindowState top = atoken.windows.get(NC - 1);
                                if (top.mSubLayer >= 0) {
                                    pos = top;
                                }
                            }
                            this.placeWindowAfter(pos, win);
                        } else {
                            int myLayer = win.mBaseLayer;
                            for (i = 0; i < N; ++i) {
                                WindowState w = localmWindows.get(i);
                                if (w.mBaseLayer > myLayer) break;
                            }
                            localmWindows.add(i, win);
                            this.mWindowsChanged = true;
                        }
                    }
                }
            } else {
                int i;
                int myLayer = win.mBaseLayer;
                for (i = N - 1; i >= 0; --i) {
                    if (localmWindows.get((int)i).mBaseLayer > myLayer) continue;
                    ++i;
                    break;
                }
                if (i < 0) {
                    i = 0;
                }
                localmWindows.add(i, win);
                this.mWindowsChanged = true;
            }
            if (addToToken) {
                token.windows.add(tokenWindowsPos, win);
            }
        } else {
            int i;
            int NA = token.windows.size();
            int sublayer = win.mSubLayer;
            int largestSublayer = Integer.MIN_VALUE;
            WindowState windowWithLargestSublayer = null;
            for (i = 0; i < NA; ++i) {
                WindowState w = token.windows.get(i);
                int wSublayer = w.mSubLayer;
                if (wSublayer >= largestSublayer) {
                    largestSublayer = wSublayer;
                    windowWithLargestSublayer = w;
                }
                if (sublayer < 0) {
                    if (wSublayer < sublayer) continue;
                    if (addToToken) {
                        token.windows.add(i, win);
                    }
                    this.placeWindowBefore(wSublayer >= 0 ? attached : w, win);
                    break;
                }
                if (wSublayer <= sublayer) continue;
                if (addToToken) {
                    token.windows.add(i, win);
                }
                this.placeWindowBefore(w, win);
                break;
            }
            if (i >= NA) {
                if (addToToken) {
                    token.windows.add(win);
                }
                if (sublayer < 0) {
                    this.placeWindowBefore(attached, win);
                } else {
                    this.placeWindowAfter(largestSublayer >= 0 ? windowWithLargestSublayer : attached, win);
                }
            }
        }
        if (win.mAppToken != null && addToToken) {
            win.mAppToken.allAppWindows.add(win);
        }
    }

    static boolean canBeImeTarget(WindowState w) {
        int fl = w.mAttrs.flags & 0x20008;
        if (fl == 0 || fl == 131080 || w.mAttrs.type == 3) {
            return w.isVisibleOrAdding();
        }
        return false;
    }

    int findDesiredInputMethodWindowIndexLocked(boolean willMove) {
        WindowState curTarget;
        ArrayList<WindowState> localmWindows = this.mWindows;
        int N = localmWindows.size();
        WindowState w = null;
        int i = N;
        while (i > 0) {
            if (!WindowManagerService.canBeImeTarget(w = localmWindows.get(--i))) continue;
            if (willMove || w.mAttrs.type != 3 || i <= 0) break;
            WindowState wb = localmWindows.get(i - 1);
            if (wb.mAppToken != w.mAppToken || !WindowManagerService.canBeImeTarget(wb)) break;
            --i;
            w = wb;
            break;
        }
        if (this.mInputMethodTarget != null && w != null && this.mInputMethodTarget.isDisplayedLw() && this.mInputMethodTarget.mExiting && this.mInputMethodTarget.mAnimLayer > w.mAnimLayer) {
            w = this.mInputMethodTarget;
            i = localmWindows.indexOf(w);
        }
        if (willMove && w != null && (curTarget = this.mInputMethodTarget) != null && curTarget.mAppToken != null) {
            AppWindowToken token = curTarget.mAppToken;
            WindowState highestTarget = null;
            int highestPos = 0;
            if (token.animating || token.animation != null) {
                int pos = 0;
                for (pos = localmWindows.indexOf(curTarget); pos >= 0; --pos) {
                    WindowState win = localmWindows.get(pos);
                    if (win.mAppToken != token) break;
                    if (win.mRemoved || highestTarget != null && win.mAnimLayer <= highestTarget.mAnimLayer) continue;
                    highestTarget = win;
                    highestPos = pos;
                }
            }
            if (highestTarget != null) {
                if (this.mNextAppTransition != -1) {
                    this.mInputMethodTargetWaitingAnim = true;
                    this.mInputMethodTarget = highestTarget;
                    return highestPos + 1;
                }
                if (highestTarget.isAnimating() && highestTarget.mAnimLayer > w.mAnimLayer) {
                    this.mInputMethodTargetWaitingAnim = true;
                    this.mInputMethodTarget = highestTarget;
                    return highestPos + 1;
                }
            }
        }
        if (w != null) {
            if (willMove) {
                this.mInputMethodTarget = w;
                this.mInputMethodTargetWaitingAnim = false;
                if (w.mAppToken != null) {
                    this.setInputMethodAnimLayerAdjustment(w.mAppToken.animLayerAdjustment);
                } else {
                    this.setInputMethodAnimLayerAdjustment(0);
                }
            }
            return i + 1;
        }
        if (willMove) {
            this.mInputMethodTarget = null;
            this.setInputMethodAnimLayerAdjustment(0);
        }
        return -1;
    }

    void addInputMethodWindowToListLocked(WindowState win) {
        int pos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (pos >= 0) {
            win.mTargetAppToken = this.mInputMethodTarget.mAppToken;
            this.mWindows.add(pos, win);
            this.mWindowsChanged = true;
            this.moveInputMethodDialogsLocked(pos + 1);
            return;
        }
        win.mTargetAppToken = null;
        this.addWindowToListInOrderLocked(win, true);
        this.moveInputMethodDialogsLocked(pos);
    }

    void setInputMethodAnimLayerAdjustment(int adj) {
        this.mInputMethodAnimLayerAdjustment = adj;
        WindowState imw = this.mInputMethodWindow;
        if (imw != null) {
            imw.mAnimLayer = imw.mLayer + adj;
            int wi = imw.mChildWindows.size();
            while (wi > 0) {
                WindowState cw = imw.mChildWindows.get(--wi);
                cw.mAnimLayer = cw.mLayer + adj;
            }
        }
        int di = this.mInputMethodDialogs.size();
        while (di > 0) {
            imw = this.mInputMethodDialogs.get(--di);
            imw.mAnimLayer = imw.mLayer + adj;
        }
    }

    private int tmpRemoveWindowLocked(int interestingPos, WindowState win) {
        int wpos = this.mWindows.indexOf(win);
        if (wpos >= 0) {
            if (wpos < interestingPos) {
                --interestingPos;
            }
            this.mWindows.remove(wpos);
            this.mWindowsChanged = true;
            int NC = win.mChildWindows.size();
            while (NC > 0) {
                WindowState cw;
                int cpos;
                if ((cpos = this.mWindows.indexOf(cw = win.mChildWindows.get(--NC))) < 0) continue;
                if (cpos < interestingPos) {
                    --interestingPos;
                }
                this.mWindows.remove(cpos);
            }
        }
        return interestingPos;
    }

    private void reAddWindowToListInOrderLocked(WindowState win) {
        this.addWindowToListInOrderLocked(win, false);
        int wpos = this.mWindows.indexOf(win);
        if (wpos >= 0) {
            this.mWindows.remove(wpos);
            this.mWindowsChanged = true;
            this.reAddWindowLocked(wpos, win);
        }
    }

    void logWindowList(String prefix) {
        int N = this.mWindows.size();
        while (N > 0) {
            Slog.v((String)TAG, (String)(prefix + "#" + --N + ": " + this.mWindows.get(N)));
        }
    }

    void moveInputMethodDialogsLocked(int pos) {
        int i;
        ArrayList<WindowState> dialogs = this.mInputMethodDialogs;
        int N = dialogs.size();
        for (i = 0; i < N; ++i) {
            pos = this.tmpRemoveWindowLocked(pos, dialogs.get(i));
        }
        if (pos >= 0) {
            WindowState wp;
            AppWindowToken targetAppToken = this.mInputMethodTarget.mAppToken;
            if (pos < this.mWindows.size() && (wp = this.mWindows.get(pos)) == this.mInputMethodWindow) {
                ++pos;
            }
            for (int i2 = 0; i2 < N; ++i2) {
                WindowState win = dialogs.get(i2);
                win.mTargetAppToken = targetAppToken;
                pos = this.reAddWindowLocked(pos, win);
            }
            return;
        }
        for (i = 0; i < N; ++i) {
            WindowState win = dialogs.get(i);
            win.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(win);
        }
    }

    boolean moveInputMethodWindowsIfNeededLocked(boolean needAssignLayers) {
        WindowState imWin = this.mInputMethodWindow;
        int DN = this.mInputMethodDialogs.size();
        if (imWin == null && DN == 0) {
            return false;
        }
        int imPos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (imPos >= 0) {
            WindowState baseImWin;
            int N = this.mWindows.size();
            WindowState firstImWin = imPos < N ? this.mWindows.get(imPos) : null;
            WindowState windowState = baseImWin = imWin != null ? imWin : this.mInputMethodDialogs.get(0);
            if (baseImWin.mChildWindows.size() > 0) {
                WindowState cw = baseImWin.mChildWindows.get(0);
                if (cw.mSubLayer < 0) {
                    baseImWin = cw;
                }
            }
            if (firstImWin == baseImWin) {
                int pos;
                for (pos = imPos + 1; pos < N && this.mWindows.get((int)pos).mIsImWindow; ++pos) {
                }
                ++pos;
                while (pos < N && !this.mWindows.get((int)pos).mIsImWindow) {
                    ++pos;
                }
                if (pos >= N) {
                    return false;
                }
            }
            if (imWin != null) {
                imPos = this.tmpRemoveWindowLocked(imPos, imWin);
                imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                this.reAddWindowLocked(imPos, imWin);
                if (DN > 0) {
                    this.moveInputMethodDialogsLocked(imPos + 1);
                }
            } else {
                this.moveInputMethodDialogsLocked(imPos);
            }
        } else if (imWin != null) {
            this.tmpRemoveWindowLocked(0, imWin);
            imWin.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(imWin);
            if (DN > 0) {
                this.moveInputMethodDialogsLocked(-1);
            }
        } else {
            this.moveInputMethodDialogsLocked(-1);
        }
        if (needAssignLayers) {
            this.assignLayersLocked();
        }
        return true;
    }

    void adjustInputMethodDialogsLocked() {
        this.moveInputMethodDialogsLocked(this.findDesiredInputMethodWindowIndexLocked(true));
    }

    final boolean isWallpaperVisible(WindowState wallpaperTarget) {
        return wallpaperTarget != null && (!wallpaperTarget.mObscured || wallpaperTarget.mAppToken != null && wallpaperTarget.mAppToken.animation != null) || this.mUpperWallpaperTarget != null || this.mLowerWallpaperTarget != null;
    }

    int adjustWallpaperWindowsLocked() {
        boolean visible;
        int changed = 0;
        int dw = this.mAppDisplayWidth;
        int dh = this.mAppDisplayHeight;
        ArrayList<WindowState> localmWindows = this.mWindows;
        int N = localmWindows.size();
        WindowState w = null;
        WindowState foundW = null;
        int foundI = 0;
        WindowState topCurW = null;
        int topCurI = 0;
        int windowDetachedI = -1;
        int i = N;
        while (i > 0) {
            w = localmWindows.get(--i);
            if (w.mAttrs.type == 2013) {
                if (topCurW != null) continue;
                topCurW = w;
                topCurI = i;
                continue;
            }
            topCurW = null;
            if (w != this.mWindowDetachedWallpaper && w.mAppToken != null && w.mAppToken.hidden && w.mAppToken.animation == null) continue;
            if ((w.mAttrs.flags & 0x100000) != 0 && w.isReadyForDisplay() && (this.mWallpaperTarget == w || !w.mDrawPending && !w.mCommitDrawPending)) {
                foundW = w;
                foundI = i;
                if (w != this.mWallpaperTarget || (w.mAppToken == null || w.mAppToken.animation == null) && w.mAnimation == null) break;
                continue;
            }
            if (w != this.mWindowDetachedWallpaper) continue;
            windowDetachedI = i;
        }
        if (foundW == null && windowDetachedI >= 0) {
            foundW = w;
            foundI = windowDetachedI;
        }
        if (this.mNextAppTransition != -1) {
            if (this.mWallpaperTarget != null && this.mWallpaperTarget.mAppToken != null) {
                return 0;
            }
            if (foundW != null && foundW.mAppToken != null) {
                return 0;
            }
        }
        if (this.mWallpaperTarget != foundW) {
            this.mLowerWallpaperTarget = null;
            this.mUpperWallpaperTarget = null;
            WindowState oldW = this.mWallpaperTarget;
            this.mWallpaperTarget = foundW;
            if (foundW != null && oldW != null) {
                int oldI;
                boolean foundAnim;
                boolean oldAnim = oldW.mAnimation != null || oldW.mAppToken != null && oldW.mAppToken.animation != null;
                boolean bl = foundAnim = foundW.mAnimation != null || foundW.mAppToken != null && foundW.mAppToken.animation != null;
                if (foundAnim && oldAnim && (oldI = localmWindows.indexOf(oldW)) >= 0) {
                    if (foundW.mAppToken != null && foundW.mAppToken.hiddenRequested) {
                        this.mWallpaperTarget = oldW;
                    }
                    if (foundI > oldI) {
                        this.mUpperWallpaperTarget = foundW;
                        this.mLowerWallpaperTarget = oldW;
                        foundW = oldW;
                        foundI = oldI;
                    } else {
                        this.mUpperWallpaperTarget = oldW;
                        this.mLowerWallpaperTarget = foundW;
                    }
                }
            }
        } else if (this.mLowerWallpaperTarget != null) {
            boolean upperAnimating;
            boolean lowerAnimating = this.mLowerWallpaperTarget.mAnimation != null || this.mLowerWallpaperTarget.mAppToken != null && this.mLowerWallpaperTarget.mAppToken.animation != null;
            boolean bl = upperAnimating = this.mUpperWallpaperTarget.mAnimation != null || this.mUpperWallpaperTarget.mAppToken != null && this.mUpperWallpaperTarget.mAppToken.animation != null;
            if (!lowerAnimating || !upperAnimating) {
                this.mLowerWallpaperTarget = null;
                this.mUpperWallpaperTarget = null;
            }
        }
        boolean bl = visible = foundW != null;
        if (visible) {
            visible = this.isWallpaperVisible(foundW);
            this.mWallpaperAnimLayerAdjustment = this.mLowerWallpaperTarget == null && foundW.mAppToken != null ? foundW.mAppToken.animLayerAdjustment : 0;
            int maxLayer = this.mPolicy.getMaxWallpaperLayer() * 10000 + 1000;
            while (foundI > 0) {
                WindowState wb = localmWindows.get(foundI - 1);
                if (!(wb.mBaseLayer >= maxLayer || wb.mAttachedWindow == foundW || foundW.mAttachedWindow != null && wb.mAttachedWindow == foundW.mAttachedWindow || wb.mAttrs.type == 3 && foundW.mToken != null && wb.mToken == foundW.mToken)) break;
                foundW = wb;
                --foundI;
            }
        }
        if (foundW == null && topCurW != null) {
            foundW = topCurW;
            foundI = topCurI + 1;
        } else {
            WindowState windowState = foundW = foundI > 0 ? localmWindows.get(foundI - 1) : null;
        }
        if (visible) {
            if (this.mWallpaperTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = this.mWallpaperTarget.mWallpaperX;
                this.mLastWallpaperXStep = this.mWallpaperTarget.mWallpaperXStep;
            }
            if (this.mWallpaperTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = this.mWallpaperTarget.mWallpaperY;
                this.mLastWallpaperYStep = this.mWallpaperTarget.mWallpaperYStep;
            }
        }
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            if (token.hidden == visible) {
                changed |= 4;
                token.hidden = !visible;
                this.mLayoutNeeded = true;
            }
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper = token.windows.get(--curWallpaperIndex);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                if (wallpaper.mWallpaperVisible != visible) {
                    wallpaper.mWallpaperVisible = visible;
                    try {
                        wallpaper.mClient.dispatchAppVisibility(visible);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                wallpaper.mAnimLayer = wallpaper.mLayer + this.mWallpaperAnimLayerAdjustment;
                if (wallpaper == foundW) {
                    foundW = --foundI > 0 ? localmWindows.get(foundI - 1) : null;
                    continue;
                }
                int oldIndex = localmWindows.indexOf(wallpaper);
                if (oldIndex >= 0) {
                    localmWindows.remove(oldIndex);
                    this.mWindowsChanged = true;
                    if (oldIndex < foundI) {
                        --foundI;
                    }
                }
                localmWindows.add(foundI, wallpaper);
                this.mWindowsChanged = true;
                changed |= 2;
            }
        }
        return changed;
    }

    void setWallpaperAnimLayerAdjustmentLocked(int adj) {
        this.mWallpaperAnimLayerAdjustment = adj;
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper = token.windows.get(--curWallpaperIndex);
                wallpaper.mAnimLayer = wallpaper.mLayer + adj;
            }
        }
    }

    boolean updateWallpaperOffsetLocked(WindowState wallpaperWin, int dw, int dh, boolean sync) {
        boolean changed;
        block12: {
            changed = false;
            boolean rawChanged = false;
            float wpx = this.mLastWallpaperX >= 0.0f ? this.mLastWallpaperX : 0.5f;
            float wpxs = this.mLastWallpaperXStep >= 0.0f ? this.mLastWallpaperXStep : -1.0f;
            int availw = wallpaperWin.mFrame.right - wallpaperWin.mFrame.left - dw;
            int offset = availw > 0 ? -((int)((float)availw * wpx + 0.5f)) : 0;
            boolean bl = changed = wallpaperWin.mXOffset != offset;
            if (changed) {
                wallpaperWin.mXOffset = offset;
            }
            if (wallpaperWin.mWallpaperX != wpx || wallpaperWin.mWallpaperXStep != wpxs) {
                wallpaperWin.mWallpaperX = wpx;
                wallpaperWin.mWallpaperXStep = wpxs;
                rawChanged = true;
            }
            float wpy = this.mLastWallpaperY >= 0.0f ? this.mLastWallpaperY : 0.5f;
            float wpys = this.mLastWallpaperYStep >= 0.0f ? this.mLastWallpaperYStep : -1.0f;
            int availh = wallpaperWin.mFrame.bottom - wallpaperWin.mFrame.top - dh;
            int n = offset = availh > 0 ? -((int)((float)availh * wpy + 0.5f)) : 0;
            if (wallpaperWin.mYOffset != offset) {
                changed = true;
                wallpaperWin.mYOffset = offset;
            }
            if (wallpaperWin.mWallpaperY != wpy || wallpaperWin.mWallpaperYStep != wpys) {
                wallpaperWin.mWallpaperY = wpy;
                wallpaperWin.mWallpaperYStep = wpys;
                rawChanged = true;
            }
            if (rawChanged && (wallpaperWin.getAttrs().privateFlags & 4) != 0) {
                try {
                    if (sync) {
                        this.mWaitingOnWallpaper = wallpaperWin;
                    }
                    wallpaperWin.mClient.dispatchWallpaperOffsets(wallpaperWin.mWallpaperX, wallpaperWin.mWallpaperY, wallpaperWin.mWallpaperXStep, wallpaperWin.mWallpaperYStep, sync);
                    if (!sync || this.mWaitingOnWallpaper == null) break block12;
                    long start = SystemClock.uptimeMillis();
                    if (this.mLastWallpaperTimeoutTime + 10000L < start) {
                        try {
                            this.mWindowMap.wait(150L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (start + 150L < SystemClock.uptimeMillis()) {
                            Slog.i((String)TAG, (String)("Timeout waiting for wallpaper to offset: " + wallpaperWin));
                            this.mLastWallpaperTimeoutTime = start;
                        }
                    }
                    this.mWaitingOnWallpaper = null;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperOffsetsComplete(IBinder window) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    void updateWallpaperOffsetLocked(WindowState changingTarget, boolean sync) {
        int dw = this.mAppDisplayWidth;
        int dh = this.mAppDisplayHeight;
        WindowState target = this.mWallpaperTarget;
        if (target != null) {
            if (target.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = target.mWallpaperX;
            } else if (changingTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = changingTarget.mWallpaperX;
            }
            if (target.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = target.mWallpaperY;
            } else if (changingTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = changingTarget.mWallpaperY;
            }
        }
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper;
                if (!this.updateWallpaperOffsetLocked(wallpaper = token.windows.get(--curWallpaperIndex), dw, dh, sync)) continue;
                wallpaper.computeShownFrameLocked();
                if (wallpaper.mSurfaceX != wallpaper.mShownFrame.left || wallpaper.mSurfaceY != wallpaper.mShownFrame.top) {
                    Surface.openTransaction();
                    try {
                        wallpaper.mSurfaceX = wallpaper.mShownFrame.left;
                        wallpaper.mSurfaceY = wallpaper.mShownFrame.top;
                        wallpaper.mSurface.setPosition(wallpaper.mShownFrame.left, wallpaper.mShownFrame.top);
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)TAG, (String)("Error positioning surface of " + wallpaper + " pos=(" + wallpaper.mShownFrame.left + "," + wallpaper.mShownFrame.top + ")"), (Throwable)e);
                    }
                    Surface.closeTransaction();
                }
                sync = false;
            }
        }
    }

    void updateWallpaperVisibilityLocked() {
        boolean visible = this.isWallpaperVisible(this.mWallpaperTarget);
        int dw = this.mAppDisplayWidth;
        int dh = this.mAppDisplayHeight;
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            if (token.hidden == visible) {
                token.hidden = !visible;
                this.mLayoutNeeded = true;
            }
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper = token.windows.get(--curWallpaperIndex);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                if (wallpaper.mWallpaperVisible == visible) continue;
                wallpaper.mWallpaperVisible = visible;
                try {
                    wallpaper.mClient.dispatchAppVisibility(visible);
                }
                catch (RemoteException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, Rect outContentInsets, InputChannel outInputChannel) {
        long origId;
        int res = this.mPolicy.checkAddPermission(attrs);
        if (res != 0) {
            return res;
        }
        boolean reportNewConfig = false;
        WindowState attachedWindow = null;
        WindowState win = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplay == null) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            if (this.mWindowMap.containsKey(client.asBinder())) {
                Slog.w((String)TAG, (String)("Window " + client + " is already added"));
                return -5;
            }
            if (attrs.type >= 1000 && attrs.type <= 1999) {
                attachedWindow = this.windowForClientLocked(null, attrs.token, false);
                if (attachedWindow == null) {
                    Slog.w((String)TAG, (String)("Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting."));
                    return -2;
                }
                if (attachedWindow.mAttrs.type >= 1000 && attachedWindow.mAttrs.type <= 1999) {
                    Slog.w((String)TAG, (String)("Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting."));
                    return -2;
                }
            }
            boolean addToken = false;
            WindowToken token = this.mTokenMap.get(attrs.token);
            if (token == null) {
                if (attrs.type >= 1 && attrs.type <= 99) {
                    Slog.w((String)TAG, (String)("Attempted to add application window with unknown token " + attrs.token + ".  Aborting."));
                    return -1;
                }
                if (attrs.type == 2011) {
                    Slog.w((String)TAG, (String)("Attempted to add input method window with unknown token " + attrs.token + ".  Aborting."));
                    return -1;
                }
                if (attrs.type == 2013) {
                    Slog.w((String)TAG, (String)("Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting."));
                    return -1;
                }
                token = new WindowToken(this, attrs.token, -1, false);
                addToken = true;
            } else if (attrs.type >= 1 && attrs.type <= 99) {
                AppWindowToken atoken = token.appWindowToken;
                if (atoken == null) {
                    Slog.w((String)TAG, (String)("Attempted to add window with non-application token " + token + ".  Aborting."));
                    return -3;
                }
                if (atoken.removed) {
                    Slog.w((String)TAG, (String)("Attempted to add window with exiting application token " + token + ".  Aborting."));
                    return -4;
                }
                if (attrs.type == 3 && atoken.firstWindowDrawn) {
                    return -6;
                }
            } else if (attrs.type == 2011) {
                if (token.windowType != 2011) {
                    Slog.w((String)TAG, (String)("Attempted to add input method window with bad token " + attrs.token + ".  Aborting."));
                    return -1;
                }
            } else if (attrs.type == 2013 && token.windowType != 2013) {
                Slog.w((String)TAG, (String)("Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting."));
                return -1;
            }
            win = new WindowState(this, session, client, token, attachedWindow, seq, attrs, viewVisibility);
            if (win.mDeathRecipient == null) {
                Slog.w((String)TAG, (String)("Adding window client " + client.asBinder() + " that is dead, aborting."));
                return -4;
            }
            this.mPolicy.adjustWindowParamsLw(win.mAttrs);
            res = this.mPolicy.prepareAddWindowLw((WindowManagerPolicy.WindowState)win, attrs);
            if (res != 0) {
                return res;
            }
            if (outInputChannel != null && (attrs.inputFeatures & 2) == 0) {
                String name = win.makeInputChannelName();
                InputChannel[] inputChannels = InputChannel.openInputChannelPair((String)name);
                win.setInputChannel(inputChannels[0]);
                inputChannels[1].transferTo(outInputChannel);
                this.mInputManager.registerInputChannel(win.mInputChannel, win.mInputWindowHandle);
            }
            res = 0;
            origId = Binder.clearCallingIdentity();
            if (addToken) {
                this.mTokenMap.put(attrs.token, token);
            }
            win.attach();
            this.mWindowMap.put(client.asBinder(), win);
            if (attrs.type == 3 && token.appWindowToken != null) {
                token.appWindowToken.startingWindow = win;
            }
            boolean imMayMove = true;
            if (attrs.type == 2011) {
                this.mInputMethodWindow = win;
                this.addInputMethodWindowToListLocked(win);
                imMayMove = false;
            } else if (attrs.type == 2012) {
                this.mInputMethodDialogs.add(win);
                this.addWindowToListInOrderLocked(win, true);
                this.adjustInputMethodDialogsLocked();
                imMayMove = false;
            } else {
                this.addWindowToListInOrderLocked(win, true);
                if (attrs.type == 2013) {
                    this.mLastWallpaperTimeoutTime = 0L;
                    this.adjustWallpaperWindowsLocked();
                } else if ((attrs.flags & 0x100000) != 0) {
                    this.adjustWallpaperWindowsLocked();
                }
            }
            win.mEnterAnimationPending = true;
            this.mPolicy.getContentInsetHintLw(attrs, outContentInsets);
            if (this.mInTouchMode) {
                res |= 1;
            }
            if (win == null || win.mAppToken == null || !win.mAppToken.clientHidden) {
                res |= 2;
            }
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            boolean focusChanged = false;
            if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                imMayMove = false;
            }
            if (imMayMove) {
                this.moveInputMethodWindowsIfNeededLocked(false);
            }
            this.assignLayersLocked();
            if (focusChanged) {
                this.finishUpdateFocusedWindowAfterAssignLayersLocked(false);
            }
            this.mInputMonitor.updateInputWindowsLw(false);
            if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(false)) {
                reportNewConfig = true;
            }
        }
        if (reportNewConfig) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity((long)origId);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Session session, IWindow client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return;
            }
            this.removeWindowLocked(session, win);
        }
    }

    public void removeWindowLocked(Session session, WindowState win) {
        long origId = Binder.clearCallingIdentity();
        win.disposeInputChannel();
        boolean wasVisible = false;
        if (win.mSurface != null && !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully()) {
            wasVisible = win.isWinVisibleLw();
            if (wasVisible) {
                int transit = 8194;
                if (win.getAttrs().type == 3) {
                    transit = 5;
                }
                if (this.applyAnimationLocked(win, transit, false)) {
                    win.mExiting = true;
                }
            }
            if (win.mExiting || win.isAnimating()) {
                win.mExiting = true;
                win.mRemoveOnExit = true;
                this.mLayoutNeeded = true;
                this.updateFocusedWindowLocked(3, false);
                this.performLayoutAndPlaceSurfacesLocked();
                this.mInputMonitor.updateInputWindowsLw(false);
                if (win.mAppToken != null) {
                    win.mAppToken.updateReportedVisibilityLocked();
                }
                Binder.restoreCallingIdentity((long)origId);
                return;
            }
        }
        this.removeWindowInnerLocked(session, win);
        if (wasVisible && this.computeForcedAppOrientationLocked() != this.mForcedAppOrientation && this.updateOrientationFromAppTokensLocked(false)) {
            this.mH.sendEmptyMessage(18);
        }
        this.updateFocusedWindowLocked(0, true);
        Binder.restoreCallingIdentity((long)origId);
    }

    private void removeWindowInnerLocked(Session session, WindowState win) {
        if (win.mRemoved) {
            return;
        }
        for (int i = win.mChildWindows.size() - 1; i >= 0; --i) {
            WindowState cwin = win.mChildWindows.get(i);
            Slog.w((String)TAG, (String)("Force-removing child win " + cwin + " from container " + win));
            this.removeWindowInnerLocked(cwin.mSession, cwin);
        }
        win.mRemoved = true;
        if (this.mInputMethodTarget == win) {
            this.moveInputMethodWindowsIfNeededLocked(false);
        }
        this.mPolicy.removeWindowLw((WindowManagerPolicy.WindowState)win);
        win.removeLocked();
        this.mWindowMap.remove(win.mClient.asBinder());
        this.mWindows.remove(win);
        this.mPendingRemove.remove(win);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.mInputMethodWindow = null;
        } else if (win.mAttrs.type == 2012) {
            this.mInputMethodDialogs.remove(win);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        token.windows.remove(win);
        if (atoken != null) {
            atoken.allAppWindows.remove(win);
        }
        if (token.windows.size() == 0) {
            if (!token.explicit) {
                this.mTokenMap.remove(token.token);
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
            }
        }
        if (atoken != null) {
            if (atoken.startingWindow == win) {
                atoken.startingWindow = null;
            } else if (atoken.allAppWindows.size() == 0 && atoken.startingData != null) {
                atoken.startingData = null;
            } else if (atoken.allAppWindows.size() == 1 && atoken.startingView != null) {
                Message m = this.mH.obtainMessage(6, atoken);
                this.mH.sendMessage(m);
            }
        }
        if (win.mAttrs.type == 2013) {
            this.mLastWallpaperTimeoutTime = 0L;
            this.adjustWallpaperWindowsLocked();
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            this.adjustWallpaperWindowsLocked();
        }
        if (!this.mInLayout) {
            this.assignLayersLocked();
            this.mLayoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    static void logSurface(WindowState w, String msg, RuntimeException where) {
        String str = "  SURFACE " + Integer.toHexString(w.hashCode()) + ": " + msg + " / " + w.mAttrs.getTitle();
        if (where != null) {
            Slog.i((String)TAG, (String)str, (Throwable)where);
        } else {
            Slog.i((String)TAG, (String)str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null && w.mSurface != null) {
                    Surface.openTransaction();
                    try {
                        w.mSurface.setTransparentRegionHint(region);
                    }
                    finally {
                        Surface.closeTransaction();
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null) {
                    w.mGivenInsetsPending = false;
                    w.mGivenContentInsets.set(contentInsets);
                    w.mGivenVisibleInsets.set(visibleInsets);
                    w.mGivenTouchableRegion.set(touchableRegion);
                    w.mTouchableInsets = touchableInsets;
                    if (w.mGlobalScale != 1.0f) {
                        w.mGivenContentInsets.scale(w.mGlobalScale);
                        w.mGivenVisibleInsets.scale(w.mGlobalScale);
                        w.mGivenTouchableRegion.scale(w.mGlobalScale);
                    }
                    this.mLayoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                outDisplayFrame.setEmpty();
                return;
            }
            outDisplayFrame.set(win.mDisplayFrame);
        }
    }

    public void setWindowWallpaperPositionLocked(WindowState window, float x, float y, float xStep, float yStep) {
        if (window.mWallpaperX != x || window.mWallpaperY != y) {
            window.mWallpaperX = x;
            window.mWallpaperY = y;
            window.mWallpaperXStep = xStep;
            window.mWallpaperYStep = yStep;
            this.updateWallpaperOffsetLocked(window, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperCommandComplete(IBinder window, Bundle result) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    public Bundle sendWindowWallpaperCommandLocked(WindowState window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        if (window == this.mWallpaperTarget || window == this.mLowerWallpaperTarget || window == this.mUpperWallpaperTarget) {
            boolean doWait = sync;
            int curTokenIndex = this.mWallpaperTokens.size();
            while (curTokenIndex > 0) {
                WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
                int curWallpaperIndex = token.windows.size();
                while (curWallpaperIndex > 0) {
                    WindowState wallpaper = token.windows.get(--curWallpaperIndex);
                    try {
                        wallpaper.mClient.dispatchWallpaperCommand(action, x, y, z, extras, sync);
                        sync = false;
                    }
                    catch (RemoteException e) {}
                }
            }
            if (doWait) {
                // empty if block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, Rect outFrame, Rect outContentInsets, Rect outVisibleInsets, Configuration outConfig, Surface outSurface) {
        boolean inTouchMode;
        boolean configChanged;
        boolean displayed = false;
        boolean surfaceChanged = false;
        int systemUiVisibility = 0;
        if (attrs != null && ((systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility) & 0x1FF0000) != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            systemUiVisibility &= 0xFE00FFFF;
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean scaledWindow;
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return 0;
            }
            win.mRequestedWidth = requestedWidth;
            win.mRequestedHeight = requestedHeight;
            if (attrs != null && seq == win.mSeq) {
                win.mSystemUiVisibility = systemUiVisibility;
            }
            if (attrs != null) {
                this.mPolicy.adjustWindowParamsLw(attrs);
            }
            win.mSurfaceDestroyDeferred = (flags & 2) != 0;
            int attrChanges = 0;
            int flagChanges = 0;
            if (attrs != null) {
                if (win.mAttrs.type != attrs.type) {
                    throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                }
                flagChanges = win.mAttrs.flags ^= attrs.flags;
                attrChanges = win.mAttrs.copyFrom(attrs);
            }
            boolean bl = win.mEnforceSizeCompat = (win.mAttrs.flags & 0x20000000) != 0;
            if ((attrChanges & 0x80) != 0) {
                win.mAlpha = attrs.alpha;
            }
            boolean bl2 = scaledWindow = (win.mAttrs.flags & 0x4000) != 0;
            if (scaledWindow) {
                win.mHScale = attrs.width != requestedWidth ? (float)attrs.width / (float)requestedWidth : 1.0f;
                win.mVScale = attrs.height != requestedHeight ? (float)attrs.height / (float)requestedHeight : 1.0f;
            } else {
                win.mVScale = 1.0f;
                win.mHScale = 1.0f;
            }
            boolean imMayMove = (flagChanges & 0x20008) != 0;
            boolean focusMayChange = win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || !win.mRelayoutCalled;
            boolean wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
            wallpaperMayMove |= (flagChanges & 0x100000) != 0;
            win.mRelayoutCalled = true;
            int oldVisibility = win.mViewVisibility;
            win.mViewVisibility = viewVisibility;
            if (!(viewVisibility != 0 || win.mAppToken != null && win.mAppToken.clientHidden)) {
                boolean bl3 = displayed = !win.isVisibleLw();
                if (win.mExiting) {
                    win.cancelExitAnimationForNextAnimationLocked();
                }
                if (win.mDestroying) {
                    win.mDestroying = false;
                    this.mDestroySurface.remove(win);
                }
                if (oldVisibility == 8) {
                    win.mEnterAnimationPending = true;
                }
                if (displayed) {
                    if (win.mSurface != null && !win.mDrawPending && !win.mCommitDrawPending && !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully()) {
                        this.applyEnterAnimationLocked(win);
                    }
                    if ((win.mAttrs.flags & 0x200000) != 0) {
                        win.mTurnOnScreen = true;
                    }
                    int diff = 0;
                    if (win.mConfiguration != this.mCurConfiguration && (win.mConfiguration == null || (diff = this.mCurConfiguration.diff(win.mConfiguration)) != 0)) {
                        win.mConfiguration = this.mCurConfiguration;
                        outConfig.setTo(this.mCurConfiguration);
                    }
                }
                if ((attrChanges & 8) != 0) {
                    win.destroySurfaceLocked();
                    displayed = true;
                    surfaceChanged = true;
                }
                try {
                    Surface surface;
                    if (win.mSurface == null) {
                        surfaceChanged = true;
                    }
                    if ((surface = win.createSurfaceLocked()) != null) {
                        outSurface.copyFrom(surface);
                        win.mReportDestroySurface = false;
                        win.mSurfacePendingDestroy = false;
                    } else {
                        outSurface.release();
                    }
                }
                catch (Exception e) {
                    this.mInputMonitor.updateInputWindowsLw(true);
                    Slog.w((String)TAG, (String)("Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")"), (Throwable)e);
                    Binder.restoreCallingIdentity((long)origId);
                    return 0;
                }
                if (displayed) {
                    focusMayChange = true;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.mInputMethodWindow = win;
                    imMayMove = true;
                }
                if (win.mAttrs.type == 1 && win.mAppToken != null && win.mAppToken.startingWindow != null) {
                    int mask = 4718593;
                    WindowManager.LayoutParams sa = win.mAppToken.startingWindow.mAttrs;
                    sa.flags = sa.flags & 0xFFB7FFFE | win.mAttrs.flags & 0x480001;
                }
            } else {
                win.mEnterAnimationPending = false;
                if (win.mSurface != null && (!win.mExiting || win.mSurfacePendingDestroy)) {
                    surfaceChanged = true;
                    int transit = 8194;
                    if (win.getAttrs().type == 3) {
                        transit = 5;
                    }
                    if (!win.mSurfacePendingDestroy && win.isWinVisibleLw() && this.applyAnimationLocked(win, transit, false)) {
                        focusMayChange = true;
                        win.mExiting = true;
                    } else if (win.isAnimating()) {
                        win.mExiting = true;
                    } else if (win == this.mWallpaperTarget) {
                        win.mExiting = true;
                        win.mAnimating = true;
                    } else {
                        if (this.mInputMethodWindow == win) {
                            this.mInputMethodWindow = null;
                        }
                        win.destroySurfaceLocked();
                    }
                }
                if (win.mSurface == null || (win.getAttrs().flags & 0x10000000) == 0 || win.mSurfacePendingDestroy) {
                    win.mSurfacePendingDestroy = false;
                    outSurface.release();
                } else if (win.mSurface != null) {
                    win.mReportDestroySurface = true;
                    outSurface.copyFrom(win.mSurface);
                }
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            boolean assignLayers = false;
            if (imMayMove && (this.moveInputMethodWindowsIfNeededLocked(false) || displayed)) {
                assignLayers = true;
            }
            if (wallpaperMayMove && (this.adjustWallpaperWindowsLocked() & 2) != 0) {
                assignLayers = true;
            }
            this.mLayoutNeeded = true;
            boolean bl4 = win.mGivenInsetsPending = (flags & 1) != 0;
            if (assignLayers) {
                this.assignLayersLocked();
            }
            configChanged = this.updateOrientationFromAppTokensLocked(false);
            this.performLayoutAndPlaceSurfacesLocked();
            if (displayed && win.mIsWallpaper) {
                this.updateWallpaperOffsetLocked(win, this.mAppDisplayWidth, this.mAppDisplayHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            outFrame.set(win.mCompatFrame);
            outContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            inTouchMode = this.mInTouchMode;
            this.mInputMonitor.updateInputWindowsLw(true);
        }
        if (configChanged) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity((long)origId);
        return (inTouchMode ? 1 : 0) | (displayed ? 2 : 0) | (surfaceChanged ? 4 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDeferredDestroyWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block8: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null) break block8;
                    return;
                }
                win.destroyDeferredSurfaceLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        WindowState win;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                // MONITORENTER : hashMap
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block6;
                bl = false;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity((long)origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)origId);
            return bl;
        }
        boolean bl = this.reclaimSomeSurfaceMemoryLocked(win, "from-client", false);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity((long)origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win != null && win.finishDrawingLocked()) {
                if ((win.mAttrs.flags & 0x100000) != 0) {
                    this.adjustWallpaperWindowsLocked();
                }
                this.mLayoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getWindowCompatibilityScale(IBinder windowToken) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(windowToken);
            return windowState != null ? windowState.mGlobalScale : 1.0f;
        }
    }

    private AttributeCache.Entry getCachedAnimations(WindowManager.LayoutParams lp) {
        if (lp != null && lp.windowAnimations != 0) {
            String packageName = lp.packageName != null ? lp.packageName : "android";
            int resId = lp.windowAnimations;
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation);
        }
        return null;
    }

    private AttributeCache.Entry getCachedAnimations(String packageName, int resId) {
        if (packageName != null) {
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation);
        }
        return null;
    }

    void applyEnterAnimationLocked(WindowState win) {
        int transit = 4099;
        if (win.mEnterAnimationPending) {
            win.mEnterAnimationPending = false;
            transit = 4097;
        }
        this.applyAnimationLocked(win, transit, true);
    }

    boolean applyAnimationLocked(WindowState win, int transit, boolean isEntrance) {
        if (win.mLocalAnimating && win.mAnimationIsEntrance == isEntrance) {
            return true;
        }
        if (!this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully()) {
            int anim = this.mPolicy.selectAnimationLw((WindowManagerPolicy.WindowState)win, transit);
            int attr = -1;
            Animation a = null;
            if (anim != 0) {
                a = AnimationUtils.loadAnimation((Context)this.mContext, (int)anim);
            } else {
                switch (transit) {
                    case 4097: {
                        attr = 0;
                        break;
                    }
                    case 8194: {
                        attr = 1;
                        break;
                    }
                    case 4099: {
                        attr = 2;
                        break;
                    }
                    case 8196: {
                        attr = 3;
                    }
                }
                if (attr >= 0) {
                    a = this.loadAnimation(win.mAttrs, attr);
                }
            }
            if (a != null) {
                win.setAnimation(a);
                win.mAnimationIsEntrance = isEntrance;
            }
        } else {
            win.clearAnimation();
        }
        return win.mAnimation != null;
    }

    private Animation loadAnimation(WindowManager.LayoutParams lp, int animAttr) {
        AttributeCache.Entry ent;
        int anim = 0;
        Context context = this.mContext;
        if (animAttr >= 0 && (ent = this.getCachedAnimations(lp)) != null) {
            context = ent.context;
            anim = ent.array.getResourceId(animAttr, 0);
        }
        if (anim != 0) {
            return AnimationUtils.loadAnimation((Context)context, (int)anim);
        }
        return null;
    }

    private Animation loadAnimation(String packageName, int resId) {
        AttributeCache.Entry ent;
        int anim = 0;
        Context context = this.mContext;
        if (resId >= 0 && (ent = this.getCachedAnimations(packageName, resId)) != null) {
            context = ent.context;
            anim = resId;
        }
        if (anim != 0) {
            return AnimationUtils.loadAnimation((Context)context, (int)anim);
        }
        return null;
    }

    private boolean applyAnimationLocked(AppWindowToken wtoken, WindowManager.LayoutParams lp, int transit, boolean enter) {
        if (!this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully()) {
            Animation a;
            if (this.mNextAppTransitionPackage != null) {
                a = this.loadAnimation(this.mNextAppTransitionPackage, enter ? this.mNextAppTransitionEnter : this.mNextAppTransitionExit);
            } else {
                int animAttr = 0;
                switch (transit) {
                    case 4102: {
                        animAttr = enter ? 4 : 5;
                        break;
                    }
                    case 8199: {
                        animAttr = enter ? 6 : 7;
                        break;
                    }
                    case 4104: {
                        animAttr = enter ? 8 : 9;
                        break;
                    }
                    case 8201: {
                        animAttr = enter ? 10 : 11;
                        break;
                    }
                    case 4106: {
                        animAttr = enter ? 12 : 13;
                        break;
                    }
                    case 8203: {
                        animAttr = enter ? 14 : 15;
                        break;
                    }
                    case 4109: {
                        animAttr = enter ? 16 : 17;
                        break;
                    }
                    case 8204: {
                        animAttr = enter ? 18 : 19;
                        break;
                    }
                    case 4110: {
                        animAttr = enter ? 20 : 21;
                        break;
                    }
                    case 8207: {
                        animAttr = enter ? 22 : 23;
                    }
                }
                Animation animation = a = animAttr != 0 ? this.loadAnimation(lp, animAttr) : null;
            }
            if (a != null) {
                wtoken.setAnimation(a);
            }
        } else {
            wtoken.clearAnimation();
        }
        return wtoken.animation != null;
    }

    public void validateAppTokens(List<IBinder> tokens) {
        AppWindowToken wtoken;
        int v = tokens.size() - 1;
        int m = this.mAppTokens.size() - 1;
        while (v >= 0 && m >= 0) {
            wtoken = this.mAppTokens.get(m);
            if (wtoken.removed) {
                --m;
                continue;
            }
            if (tokens.get(v) != wtoken.token) {
                Slog.w((String)TAG, (String)("Tokens out of sync: external is " + tokens.get(v) + " @ " + v + ", internal is " + wtoken.token + " @ " + m));
            }
            --v;
            --m;
        }
        while (v >= 0) {
            Slog.w((String)TAG, (String)("External token not found: " + tokens.get(v) + " @ " + v));
            --v;
        }
        while (m >= 0) {
            wtoken = this.mAppTokens.get(m);
            if (!wtoken.removed) {
                Slog.w((String)TAG, (String)("Invalid internal token: " + wtoken.token + " @ " + m));
            }
            --m;
        }
    }

    boolean checkCallingPermission(String permission, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission;
        Slog.w((String)TAG, (String)msg);
        return false;
    }

    AppWindowToken findAppWindowToken(IBinder token) {
        WindowToken wtoken = this.mTokenMap.get(token);
        if (wtoken == null) {
            return null;
        }
        return wtoken.appWindowToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowToken(IBinder token, int type) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken wtoken = this.mTokenMap.get(token);
            if (wtoken != null) {
                Slog.w((String)TAG, (String)("Attempted to add existing input method token: " + token));
                return;
            }
            wtoken = new WindowToken(this, token, type, true);
            this.mTokenMap.put(token, wtoken);
            if (type == 2013) {
                this.mWallpaperTokens.add(wtoken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken wtoken = this.mTokenMap.remove(token);
            if (wtoken != null) {
                boolean delayed = false;
                if (!wtoken.hidden) {
                    wtoken.hidden = true;
                    int N = wtoken.windows.size();
                    boolean changed = false;
                    for (int i = 0; i < N; ++i) {
                        WindowState win = wtoken.windows.get(i);
                        if (win.isAnimating()) {
                            delayed = true;
                        }
                        if (!win.isVisibleNow()) continue;
                        this.applyAnimationLocked(win, 8194, false);
                        changed = true;
                    }
                    if (changed) {
                        this.mLayoutNeeded = true;
                        this.performLayoutAndPlaceSurfacesLocked();
                        this.updateFocusedWindowLocked(0, false);
                    }
                    if (delayed) {
                        this.mExitingTokens.add(wtoken);
                    } else if (wtoken.windowType == 2013) {
                        this.mWallpaperTokens.remove(wtoken);
                    }
                }
                this.mInputMonitor.updateInputWindowsLw(true);
            } else {
                Slog.w((String)TAG, (String)("Attempted to remove non-existing token: " + token));
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppToken(int addPos, IApplicationToken token, int groupId, int requestedOrientation, boolean fullscreen) {
        long inputDispatchingTimeoutNanos;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        try {
            inputDispatchingTimeoutNanos = token.getKeyDispatchingTimeout() * 1000000L;
        }
        catch (RemoteException ex) {
            Slog.w((String)TAG, (String)"Could not get dispatching timeout.", (Throwable)ex);
            inputDispatchingTimeoutNanos = 5000000000L;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken != null) {
                Slog.w((String)TAG, (String)("Attempted to add existing app token: " + token));
                return;
            }
            wtoken = new AppWindowToken(this, token);
            wtoken.inputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
            wtoken.groupId = groupId;
            wtoken.appFullscreen = fullscreen;
            wtoken.requestedOrientation = requestedOrientation;
            this.mAppTokens.add(addPos, wtoken);
            this.mTokenMap.put(token.asBinder(), wtoken);
            wtoken.hidden = true;
            wtoken.hiddenRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppGroupId(IBinder token, int groupId) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppStartingIcon()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w((String)TAG, (String)("Attempted to set group id of non-existing app token: " + token));
                return;
            }
            wtoken.groupId = groupId;
        }
    }

    public int getOrientationFromWindowsLocked() {
        if (this.mDisplayFrozen || this.mOpeningApps.size() > 0 || this.mClosingApps.size() > 0) {
            return this.mLastWindowForcedOrientation;
        }
        for (int pos = this.mWindows.size() - 1; pos >= 0; --pos) {
            WindowState wtoken = this.mWindows.get(pos);
            if (wtoken.mAppToken == null) continue;
            this.mLastWindowForcedOrientation = -1;
            return -1;
        }
        this.mLastWindowForcedOrientation = -1;
        return -1;
    }

    public int getOrientationFromAppTokensLocked() {
        int pos = this.mAppTokens.size() - 1;
        int curGroup = 0;
        int lastOrientation = -1;
        boolean findingBehind = false;
        boolean haveGroup = false;
        boolean lastFullscreen = false;
        while (pos >= 0) {
            AppWindowToken wtoken = this.mAppTokens.get(pos);
            --pos;
            if (!findingBehind && !wtoken.hidden && wtoken.hiddenRequested) continue;
            if (!haveGroup) {
                if (wtoken.hiddenRequested || wtoken.willBeHidden) continue;
                haveGroup = true;
                curGroup = wtoken.groupId;
                lastOrientation = wtoken.requestedOrientation;
            } else if (curGroup != wtoken.groupId && lastOrientation != 3 && lastFullscreen) {
                return lastOrientation;
            }
            int or = wtoken.requestedOrientation;
            lastFullscreen = wtoken.appFullscreen;
            if (lastFullscreen && or != 3) {
                return or;
            }
            if (or != -1 && or != 3) {
                return or;
            }
            findingBehind |= or == 3;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        Configuration config = null;
        long ident = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded);
        }
        Binder.restoreCallingIdentity((long)ident);
        return config;
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(false)) {
            AppWindowToken wtoken;
            if (freezeThisOneIfNeeded != null && (wtoken = this.findAppWindowToken(freezeThisOneIfNeeded)) != null) {
                this.startAppFreezingScreenLocked(wtoken, 128);
            }
            config = this.computeNewConfigurationLocked();
        } else if (currentConfig != null) {
            this.mTempConfiguration.setToDefaults();
            this.mTempConfiguration.fontScale = currentConfig.fontScale;
            if (this.computeNewConfigurationLocked(this.mTempConfiguration) && currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                this.mLayoutNeeded = true;
                this.startFreezingDisplayLocked(false);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(boolean inTransaction) {
        boolean changed = false;
        long ident = Binder.clearCallingIdentity();
        try {
            int req = this.computeForcedAppOrientationLocked();
            if (req != this.mForcedAppOrientation) {
                this.mForcedAppOrientation = req;
                this.mPolicy.setCurrentOrientationLw(req);
                if (this.updateRotationUncheckedLocked(inTransaction)) {
                    changed = true;
                }
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    int computeForcedAppOrientationLocked() {
        int req = this.getOrientationFromWindowsLocked();
        if (req == -1) {
            req = this.getOrientationFromAppTokensLocked();
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewConfiguration(Configuration config) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurConfiguration = new Configuration(config);
            this.mWaitingForConfig = false;
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppOrientation(IApplicationToken token, int requestedOrientation) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppOrientation()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken == null) {
                Slog.w((String)TAG, (String)("Attempted to set orientation of non-existing app token: " + token));
                return;
            }
            wtoken.requestedOrientation = requestedOrientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppOrientation(IApplicationToken token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken == null) {
                return -1;
            }
            return wtoken.requestedOrientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean changed = false;
            if (token == null) {
                changed = this.mFocusedApp != null;
                this.mFocusedApp = null;
                if (changed) {
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                AppWindowToken newFocus = this.findAppWindowToken(token);
                if (newFocus == null) {
                    Slog.w((String)TAG, (String)("Attempted to set focus to non-existing app token: " + token));
                    return;
                }
                changed = this.mFocusedApp != newFocus;
                this.mFocusedApp = newFocus;
                if (changed) {
                    this.mInputMonitor.setFocusedAppLw(newFocus);
                }
            }
            if (moveFocusNow && changed) {
                long origId = Binder.clearCallingIdentity();
                this.updateFocusedWindowLocked(0, true);
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully()) {
                if (this.mNextAppTransition == -1 || this.mNextAppTransition == 0) {
                    this.mNextAppTransition = transit;
                } else if (!alwaysKeepCurrent) {
                    if (transit == 4104 && this.mNextAppTransition == 8201) {
                        this.mNextAppTransition = transit;
                    } else if (transit == 4102 && this.mNextAppTransition == 8199) {
                        this.mNextAppTransition = transit;
                    }
                }
                this.mAppTransitionReady = false;
                this.mAppTransitionTimeout = false;
                this.mStartingIconInTransition = false;
                this.mSkipAppTransitionAnimation = false;
                this.mH.removeMessages(13);
                this.mH.sendMessageDelayed(this.mH.obtainMessage(13), 5000L);
            }
        }
    }

    public int getPendingAppTransition() {
        return this.mNextAppTransition;
    }

    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim) {
        if (this.mNextAppTransition != -1) {
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionEnter = enterAnim;
            this.mNextAppTransitionExit = exitAnim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mNextAppTransition != -1) {
                this.mAppTransitionReady = true;
                long origId = Binder.clearCallingIdentity();
                this.performLayoutAndPlaceSurfacesLocked();
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppStartingWindow(IBinder token, String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int windowFlags, IBinder transferFrom, boolean createIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppStartingIcon()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken ttoken;
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w((String)TAG, (String)("Attempted to set icon of non-existing app token: " + token));
                return;
            }
            if (this.mDisplayFrozen || !this.mDisplayEnabled || !this.mPolicy.isScreenOnFully()) {
                return;
            }
            if (wtoken.startingData != null) {
                return;
            }
            if (transferFrom != null && (ttoken = this.findAppWindowToken(transferFrom)) != null) {
                WindowState startingWindow = ttoken.startingWindow;
                if (startingWindow != null) {
                    if (this.mStartingIconInTransition) {
                        this.mSkipAppTransitionAnimation = true;
                    }
                    long origId = Binder.clearCallingIdentity();
                    wtoken.startingData = ttoken.startingData;
                    wtoken.startingView = ttoken.startingView;
                    wtoken.startingWindow = startingWindow;
                    ttoken.startingData = null;
                    ttoken.startingView = null;
                    ttoken.startingWindow = null;
                    ttoken.startingMoved = true;
                    startingWindow.mToken = wtoken;
                    startingWindow.mRootToken = wtoken;
                    startingWindow.mAppToken = wtoken;
                    this.mWindows.remove(startingWindow);
                    this.mWindowsChanged = true;
                    ttoken.windows.remove(startingWindow);
                    ttoken.allAppWindows.remove(startingWindow);
                    this.addWindowToListInOrderLocked(startingWindow, true);
                    if (ttoken.allDrawn) {
                        wtoken.allDrawn = true;
                    }
                    if (ttoken.firstWindowDrawn) {
                        wtoken.firstWindowDrawn = true;
                    }
                    if (!ttoken.hidden) {
                        wtoken.hidden = false;
                        wtoken.hiddenRequested = false;
                        wtoken.willBeHidden = false;
                    }
                    if (wtoken.clientHidden != ttoken.clientHidden) {
                        wtoken.clientHidden = ttoken.clientHidden;
                        wtoken.sendAppVisibilityToClients();
                    }
                    if (ttoken.animation != null) {
                        wtoken.animation = ttoken.animation;
                        wtoken.animating = ttoken.animating;
                        wtoken.animLayerAdjustment = ttoken.animLayerAdjustment;
                        ttoken.animation = null;
                        ttoken.animLayerAdjustment = 0;
                        wtoken.updateLayers();
                        ttoken.updateLayers();
                    }
                    this.updateFocusedWindowLocked(3, true);
                    this.mLayoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                    Binder.restoreCallingIdentity((long)origId);
                    return;
                }
                if (ttoken.startingData != null) {
                    wtoken.startingData = ttoken.startingData;
                    ttoken.startingData = null;
                    ttoken.startingMoved = true;
                    Message m = this.mH.obtainMessage(5, wtoken);
                    this.mH.sendMessageAtFrontOfQueue(m);
                    return;
                }
            }
            if (!createIfNeeded) {
                return;
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window);
                if (ent.array.getBoolean(5, false)) {
                    return;
                }
                if (ent.array.getBoolean(4, false)) {
                    return;
                }
                if (ent.array.getBoolean(14, false)) {
                    if (this.mWallpaperTarget == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return;
                    }
                }
            }
            this.mStartingIconInTransition = true;
            wtoken.startingData = new StartingData(pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, windowFlags);
            Message m = this.mH.obtainMessage(5, wtoken);
            this.mH.sendMessageAtFrontOfQueue(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppWillBeHidden(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppWillBeHidden()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w((String)TAG, (String)("Attempted to set will be hidden of non-existing app token: " + token));
                return;
            }
            wtoken.willBeHidden = true;
        }
    }

    boolean setTokenVisibilityLocked(AppWindowToken wtoken, WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout) {
        boolean delayed = false;
        if (wtoken.clientHidden == visible) {
            wtoken.clientHidden = !visible;
            wtoken.sendAppVisibilityToClients();
        }
        wtoken.willBeHidden = false;
        if (wtoken.hidden == visible) {
            int N = wtoken.allAppWindows.size();
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                if (wtoken.animation == sDummyAnimation) {
                    wtoken.animation = null;
                }
                this.applyAnimationLocked(wtoken, lp, transit, visible);
                changed = true;
                if (wtoken.animation != null) {
                    runningAppAnimation = true;
                    delayed = true;
                }
            }
            for (int i = 0; i < N; ++i) {
                WindowState win = wtoken.allAppWindows.get(i);
                if (win == wtoken.startingWindow) continue;
                if (win.isAnimating()) {
                    delayed = true;
                }
                if (visible) {
                    if (win.isVisibleNow()) continue;
                    if (!runningAppAnimation) {
                        this.applyAnimationLocked(win, 4097, true);
                    }
                    changed = true;
                    continue;
                }
                if (!win.isVisibleNow()) continue;
                if (!runningAppAnimation) {
                    this.applyAnimationLocked(win, 8194, false);
                }
                changed = true;
            }
            wtoken.hiddenRequested = !visible;
            wtoken.hidden = wtoken.hiddenRequested;
            if (!visible) {
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
            } else {
                WindowState swin = wtoken.startingWindow;
                if (swin != null && (swin.mDrawPending || swin.mCommitDrawPending)) {
                    swin.mPolicyVisibility = false;
                    swin.mPolicyVisibilityAfterAnim = false;
                }
            }
            if (changed) {
                this.mLayoutNeeded = true;
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.updateFocusedWindowLocked(3, false);
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (wtoken.animation != null) {
            delayed = true;
        }
        return delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppVisibility(IBinder token, boolean visible) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppVisibility()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w((String)TAG, (String)("Attempted to set visibility of non-existing app token: " + token));
                return;
            }
            if (!this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully() && this.mNextAppTransition != -1) {
                if (wtoken.hiddenRequested != visible) {
                    return;
                }
                wtoken.hiddenRequested = !visible;
                wtoken.setDummyAnimation();
                this.mOpeningApps.remove(wtoken);
                this.mClosingApps.remove(wtoken);
                wtoken.waitingToHide = false;
                wtoken.waitingToShow = false;
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mOpeningApps.add(wtoken);
                    wtoken.startingDisplayed = false;
                    wtoken.startingMoved = false;
                    if (wtoken.hidden) {
                        wtoken.allDrawn = false;
                        wtoken.waitingToShow = true;
                        if (wtoken.clientHidden) {
                            wtoken.clientHidden = false;
                            wtoken.sendAppVisibilityToClients();
                        }
                    }
                } else {
                    this.mClosingApps.add(wtoken);
                    if (!wtoken.hidden) {
                        wtoken.waitingToHide = true;
                    }
                }
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.setTokenVisibilityLocked(wtoken, null, visible, -1, true);
            wtoken.updateReportedVisibilityLocked();
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    void unsetAppFreezingScreenLocked(AppWindowToken wtoken, boolean unfreezeSurfaceNow, boolean force) {
        if (wtoken.freezingScreen) {
            int N = wtoken.allAppWindows.size();
            boolean unfrozeWindows = false;
            for (int i = 0; i < N; ++i) {
                WindowState w = wtoken.allAppWindows.get(i);
                if (!w.mAppFreezing) continue;
                w.mAppFreezing = false;
                if (w.mSurface != null && !w.mOrientationChanging) {
                    w.mOrientationChanging = true;
                }
                unfrozeWindows = true;
            }
            if (force || unfrozeWindows) {
                wtoken.freezingScreen = false;
                --this.mAppsFreezingScreen;
            }
            if (unfreezeSurfaceNow) {
                if (unfrozeWindows) {
                    this.mLayoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.stopFreezingDisplayLocked();
            }
        }
    }

    public void startAppFreezingScreenLocked(AppWindowToken wtoken, int configChanges) {
        if (!wtoken.hiddenRequested) {
            if (!wtoken.freezingScreen) {
                wtoken.freezingScreen = true;
                ++this.mAppsFreezingScreen;
                if (this.mAppsFreezingScreen == 1) {
                    this.startFreezingDisplayLocked(false);
                    this.mH.removeMessages(17);
                    this.mH.sendMessageDelayed(this.mH.obtainMessage(17), 5000L);
                }
            }
            int N = wtoken.allAppWindows.size();
            for (int i = 0; i < N; ++i) {
                WindowState w = wtoken.allAppWindows.get(i);
                w.mAppFreezing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAppFreezingScreen(IBinder token, int configChanges) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (configChanges == 0 && !this.mDisplayFrozen && this.mPolicy.isScreenOnFully()) {
                return;
            }
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                Slog.w((String)TAG, (String)("Attempted to freeze screen with non-existing app token: " + wtoken));
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.startAppFreezingScreenLocked(wtoken, configChanges);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAppFreezingScreen(IBinder token, boolean force) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.unsetAppFreezingScreenLocked(wtoken, true, force);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        AppWindowToken wtoken = null;
        AppWindowToken startingToken = null;
        boolean delayed = false;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken basewtoken = this.mTokenMap.remove(token);
            if (basewtoken != null && (wtoken = basewtoken.appWindowToken) != null) {
                delayed = this.setTokenVisibilityLocked(wtoken, null, false, -1, true);
                wtoken.inPendingTransaction = false;
                this.mOpeningApps.remove(wtoken);
                wtoken.waitingToShow = false;
                if (this.mClosingApps.contains(wtoken)) {
                    delayed = true;
                } else if (this.mNextAppTransition != -1) {
                    this.mClosingApps.add(wtoken);
                    wtoken.waitingToHide = true;
                    delayed = true;
                }
                if (delayed) {
                    this.mExitingAppTokens.add(wtoken);
                } else {
                    wtoken.animation = null;
                    wtoken.animating = false;
                }
                this.mAppTokens.remove(wtoken);
                wtoken.removed = true;
                if (wtoken.startingData != null) {
                    startingToken = wtoken;
                }
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
                if (this.mFocusedApp == wtoken) {
                    this.mFocusedApp = null;
                    this.updateFocusedWindowLocked(0, true);
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                Slog.w((String)TAG, (String)("Attempted to remove non-existing app token: " + token));
            }
            if (!delayed && wtoken != null) {
                wtoken.updateReportedVisibilityLocked();
            }
        }
        Binder.restoreCallingIdentity((long)origId);
        if (startingToken != null) {
            Message m = this.mH.obtainMessage(6, startingToken);
            this.mH.sendMessage(m);
        }
    }

    private boolean tmpRemoveAppWindowsLocked(WindowToken token) {
        int NW = token.windows.size();
        for (int i = 0; i < NW; ++i) {
            WindowState win = token.windows.get(i);
            this.mWindows.remove(win);
            this.mWindowsChanged = true;
            int j = win.mChildWindows.size();
            while (j > 0) {
                WindowState cwin = win.mChildWindows.get(--j);
                this.mWindows.remove(cwin);
            }
        }
        return NW > 0;
    }

    void dumpAppTokensLocked() {
        for (int i = this.mAppTokens.size() - 1; i >= 0; --i) {
            Slog.v((String)TAG, (String)("  #" + i + ": " + this.mAppTokens.get((int)i).token));
        }
    }

    void dumpWindowsLocked() {
        for (int i = this.mWindows.size() - 1; i >= 0; --i) {
            Slog.v((String)TAG, (String)("  #" + i + ": " + this.mWindows.get(i)));
        }
    }

    private int findWindowOffsetLocked(int tokenPos) {
        int NW = this.mWindows.size();
        if (tokenPos >= this.mAppTokens.size()) {
            int i = NW;
            while (i > 0) {
                WindowState win;
                if ((win = this.mWindows.get(--i)).getAppToken() == null) continue;
                return i + 1;
            }
        }
        while (tokenPos > 0) {
            AppWindowToken wtoken = this.mAppTokens.get(tokenPos - 1);
            if (wtoken.sendingToBottom) {
                --tokenPos;
                continue;
            }
            int i = wtoken.windows.size();
            while (i > 0) {
                WindowState win = (WindowState)wtoken.windows.get(--i);
                int j = win.mChildWindows.size();
                while (j > 0) {
                    WindowState cwin = win.mChildWindows.get(--j);
                    if (cwin.mSubLayer < 0) continue;
                    for (int pos = NW - 1; pos >= 0; --pos) {
                        if (this.mWindows.get(pos) != cwin) continue;
                        return pos + 1;
                    }
                }
                for (int pos = NW - 1; pos >= 0; --pos) {
                    if (this.mWindows.get(pos) != win) continue;
                    return pos + 1;
                }
            }
            --tokenPos;
        }
        return 0;
    }

    private final int reAddWindowLocked(int index, WindowState win) {
        int NCW = win.mChildWindows.size();
        boolean added = false;
        for (int j = 0; j < NCW; ++j) {
            WindowState cwin = win.mChildWindows.get(j);
            if (!added && cwin.mSubLayer >= 0) {
                win.mRebuilding = false;
                this.mWindows.add(index, win);
                ++index;
                added = true;
            }
            cwin.mRebuilding = false;
            this.mWindows.add(index, cwin);
            ++index;
        }
        if (!added) {
            win.mRebuilding = false;
            this.mWindows.add(index, win);
            ++index;
        }
        this.mWindowsChanged = true;
        return index;
    }

    private final int reAddAppWindowsLocked(int index, WindowToken token) {
        int NW = token.windows.size();
        for (int i = 0; i < NW; ++i) {
            index = this.reAddWindowLocked(index, token.windows.get(i));
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAppToken(int index, IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "moveAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || !this.mAppTokens.remove(wtoken)) {
                Slog.w((String)TAG, (String)("Attempting to reorder token that doesn't exist: " + token + " (" + wtoken + ")"));
                return;
            }
            this.mAppTokens.add(index, wtoken);
            long origId = Binder.clearCallingIdentity();
            if (this.tmpRemoveAppWindowsLocked(wtoken)) {
                this.reAddAppWindowsLocked(this.findWindowOffsetLocked(index), wtoken);
                this.updateFocusedWindowLocked(3, false);
                this.mLayoutNeeded = true;
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                this.performLayoutAndPlaceSurfacesLocked();
                this.mInputMonitor.updateInputWindowsLw(false);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    private void removeAppTokensLocked(List<IBinder> tokens) {
        int N = tokens.size();
        for (int i = 0; i < N; ++i) {
            IBinder token = tokens.get(i);
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (this.mAppTokens.remove(wtoken)) continue;
            Slog.w((String)TAG, (String)("Attempting to reorder token that doesn't exist: " + token + " (" + wtoken + ")"));
            --i;
            --N;
        }
    }

    private void moveAppWindowsLocked(AppWindowToken wtoken, int tokenPos, boolean updateFocusAndLayout) {
        this.tmpRemoveAppWindowsLocked(wtoken);
        int pos = this.findWindowOffsetLocked(tokenPos);
        pos = this.reAddAppWindowsLocked(pos, wtoken);
        if (updateFocusAndLayout) {
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            if (!this.updateFocusedWindowLocked(3, false)) {
                this.assignLayersLocked();
            }
            this.mLayoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
            this.mInputMonitor.updateInputWindowsLw(false);
        }
    }

    private void moveAppWindowsLocked(List<IBinder> tokens, int tokenPos) {
        int i;
        int N = tokens.size();
        for (i = 0; i < N; ++i) {
            WindowToken token = this.mTokenMap.get(tokens.get(i));
            if (token == null) continue;
            this.tmpRemoveAppWindowsLocked(token);
        }
        int pos = this.findWindowOffsetLocked(tokenPos);
        for (i = 0; i < N; ++i) {
            WindowToken token = this.mTokenMap.get(tokens.get(i));
            if (token == null) continue;
            pos = this.reAddAppWindowsLocked(pos, token);
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (!this.updateFocusedWindowLocked(3, false)) {
            this.assignLayersLocked();
        }
        this.mLayoutNeeded = true;
        this.performLayoutAndPlaceSurfacesLocked();
        this.mInputMonitor.updateInputWindowsLw(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAppTokensToTop(List<IBinder> tokens) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "moveAppTokensToTop()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.removeAppTokensLocked(tokens);
            int N = tokens.size();
            for (int i = 0; i < N; ++i) {
                AppWindowToken wt = this.findAppWindowToken(tokens.get(i));
                if (wt == null) continue;
                this.mAppTokens.add(wt);
                if (this.mNextAppTransition == -1) continue;
                this.mToTopApps.remove(wt);
                this.mToBottomApps.remove(wt);
                this.mToTopApps.add(wt);
                wt.sendingToBottom = false;
                wt.sendingToTop = true;
            }
            if (this.mNextAppTransition == -1) {
                this.moveAppWindowsLocked(tokens, this.mAppTokens.size());
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAppTokensToBottom(List<IBinder> tokens) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "moveAppTokensToBottom()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.removeAppTokensLocked(tokens);
            int N = tokens.size();
            int pos = 0;
            for (int i = 0; i < N; ++i) {
                AppWindowToken wt = this.findAppWindowToken(tokens.get(i));
                if (wt == null) continue;
                this.mAppTokens.add(pos, wt);
                if (this.mNextAppTransition != -1) {
                    this.mToTopApps.remove(wt);
                    this.mToBottomApps.remove(wt);
                    this.mToBottomApps.add(i, wt);
                    wt.sendingToTop = false;
                    wt.sendingToBottom = true;
                }
                ++pos;
            }
            if (this.mNextAppTransition == -1) {
                this.moveAppWindowsLocked(tokens, 0);
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    private boolean shouldAllowDisableKeyguard() {
        DevicePolicyManager dpm;
        if (this.mAllowDisableKeyguard == -1 && (dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy")) != null) {
            this.mAllowDisableKeyguard = dpm.getPasswordQuality(null) == 0 ? 1 : 0;
        }
        return this.mAllowDisableKeyguard == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        TokenWatcher tokenWatcher = this.mKeyguardTokenWatcher;
        synchronized (tokenWatcher) {
            this.mKeyguardTokenWatcher.acquire(token, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        TokenWatcher tokenWatcher = this.mKeyguardTokenWatcher;
        synchronized (tokenWatcher) {
            this.mKeyguardTokenWatcher.release(token);
            if (!this.mKeyguardTokenWatcher.isAcquired()) {
                while (this.mKeyguardDisabled) {
                    try {
                        this.mKeyguardTokenWatcher.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean inKeyguardRestrictedInputMode() {
        return this.mPolicy.inKeyguardRestrictedKeyInputMode();
    }

    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    public boolean isKeyguardSecure() {
        return this.mPolicy.isKeyguardSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissKeyguard() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.dismissKeyguardLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSystemDialogs(String reason) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = this.mWindows.size() - 1; i >= 0; --i) {
                WindowState w = this.mWindows.get(i);
                if (w.mSurface == null) continue;
                try {
                    w.mClient.closeSystemDialogs(reason);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        scale = Math.abs(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScale = WindowManagerService.fixScale(scale);
                break;
            }
            case 1: {
                this.mTransitionAnimationScale = WindowManagerService.fixScale(scale);
            }
        }
        this.mH.obtainMessage(14).sendToTarget();
    }

    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScale = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScale = WindowManagerService.fixScale(scales[1]);
            }
        }
        this.mH.obtainMessage(14).sendToTarget();
    }

    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScale;
            }
            case 1: {
                return this.mTransitionAnimationScale;
            }
        }
        return 0.0f;
    }

    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScale, this.mTransitionAnimationScale};
    }

    public int getSwitchState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getSwitchState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getSwitchState(-1, -256, sw);
    }

    public int getSwitchStateForDevice(int devid, int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getSwitchStateForDevice()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getSwitchState(devid, -256, sw);
    }

    public int getScancodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getScancodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getScanCodeState(-1, -256, sw);
    }

    public int getScancodeStateForDevice(int devid, int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getScancodeStateForDevice()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getScanCodeState(devid, -256, sw);
    }

    public int getTrackballScancodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getTrackballScancodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getScanCodeState(-1, 65540, sw);
    }

    public int getDPadScancodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getDPadScancodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getScanCodeState(-1, 513, sw);
    }

    public int getKeycodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getKeycodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getKeyCodeState(-1, -256, sw);
    }

    public int getKeycodeStateForDevice(int devid, int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getKeycodeStateForDevice()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getKeyCodeState(devid, -256, sw);
    }

    public int getTrackballKeycodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getTrackballKeycodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getKeyCodeState(-1, 65540, sw);
    }

    public int getDPadKeycodeState(int sw) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "getDPadKeycodeState()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.getKeyCodeState(-1, 513, sw);
    }

    public boolean hasKeys(int[] keycodes, boolean[] keyExists) {
        return this.mInputManager.hasKeys(-1, -256, keycodes, keyExists);
    }

    public InputChannel monitorInput(String inputChannelName) {
        if (!this.checkCallingPermission("android.permission.READ_INPUT_STATE", "monitorInput()")) {
            throw new SecurityException("Requires READ_INPUT_STATE permission");
        }
        return this.mInputManager.monitorInput(inputChannelName);
    }

    public void setInputFilter(InputFilter filter) {
        this.mInputManager.setInputFilter(filter);
    }

    public InputDevice getInputDevice(int deviceId) {
        return this.mInputManager.getInputDevice(deviceId);
    }

    public int[] getInputDeviceIds() {
        return this.mInputManager.getInputDeviceIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScreenAfterBoot() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mSystemBooted) {
                return;
            }
            this.mSystemBooted = true;
            this.hideBootMessagesLocked();
            Message msg = this.mH.obtainMessage(23);
            this.mH.sendMessageDelayed(msg, 30000L);
        }
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendMessage(this.mH.obtainMessage(16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootTimeout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            Slog.w((String)TAG, (String)"***** BOOT TIMEOUT: forcing display enabled");
            this.mForceDisplayEnabled = true;
        }
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performEnableScreen() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            if (!this.mSystemBooted && !this.mShowingBootMessages) {
                return;
            }
            if (!this.mForceDisplayEnabled) {
                boolean haveBootMsg = false;
                boolean haveApp = false;
                boolean haveWallpaper = false;
                boolean haveKeyguard = true;
                int N = this.mWindows.size();
                for (int i = 0; i < N; ++i) {
                    WindowState w = this.mWindows.get(i);
                    if (w.mAttrs.type == 2004) {
                        boolean vis = w.mViewVisibility == 0 && w.mPolicyVisibility;
                        boolean bl = haveKeyguard = !vis;
                    }
                    if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                        return;
                    }
                    if (!w.isDrawnLw()) continue;
                    if (w.mAttrs.type == 2021) {
                        haveBootMsg = true;
                        continue;
                    }
                    if (w.mAttrs.type == 2) {
                        haveApp = true;
                        continue;
                    }
                    if (w.mAttrs.type == 2013) {
                        haveWallpaper = true;
                        continue;
                    }
                    if (w.mAttrs.type != 2004) continue;
                    haveKeyguard = true;
                }
                if (!this.mSystemBooted && !haveBootMsg) {
                    return;
                }
                if (this.mSystemBooted && (!haveApp && !haveKeyguard || !haveWallpaper)) {
                    return;
                }
            }
            this.mDisplayEnabled = true;
            try {
                IBinder surfaceFlinger = ServiceManager.getService((String)"SurfaceFlinger");
                if (surfaceFlinger != null) {
                    Parcel data = Parcel.obtain();
                    data.writeInterfaceToken("android.ui.ISurfaceComposer");
                    surfaceFlinger.transact(1, data, null, 0);
                    data.recycle();
                }
            }
            catch (RemoteException ex) {
                Slog.e((String)TAG, (String)"Boot completed: SurfaceFlinger is dead!");
            }
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        boolean first = false;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAllowBootMessages) {
                return;
            }
            if (!this.mShowingBootMessages) {
                if (!always) {
                    return;
                }
                first = true;
            }
            if (this.mSystemBooted) {
                return;
            }
            this.mShowingBootMessages = true;
            this.mPolicy.showBootMessage(msg, always);
        }
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showStrictModeViolation(boolean on) {
        int pid = Binder.getCallingPid();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (on) {
                boolean isVisible = false;
                for (WindowState ws : this.mWindows) {
                    if (ws.mSession.mPid != pid || !ws.isVisibleLw()) continue;
                    isVisible = true;
                    break;
                }
                if (!isVisible) {
                    return;
                }
            }
            Surface.openTransaction();
            try {
                if (this.mStrictModeFlash == null) {
                    this.mStrictModeFlash = new StrictModeFlash(this.mDisplay, this.mFxSession);
                }
                this.mStrictModeFlash.setVisibility(on);
            }
            finally {
                Surface.closeTransaction();
            }
        }
    }

    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set((String)"persist.sys.strictmode.visual", (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap screenshotApplications(IBinder appToken, int width, int height) {
        Bitmap rawss;
        float scale;
        int rot;
        int dh;
        int dw;
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotApplications()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        int maxLayer = 0;
        Rect frame = new Rect();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            dw = this.mAppDisplayWidth;
            dh = this.mAppDisplayHeight;
            int aboveAppLayer = this.mPolicy.windowTypeToLayerLw(2) * 10000 + 1000;
            aboveAppLayer += 10000;
            boolean isImeTarget = this.mInputMethodTarget != null && this.mInputMethodTarget.mAppToken != null && this.mInputMethodTarget.mAppToken.appToken != null && this.mInputMethodTarget.mAppToken.appToken.asBinder() == appToken;
            boolean including = false;
            for (int i = this.mWindows.size() - 1; i >= 0; --i) {
                WindowState ws = this.mWindows.get(i);
                if (ws.mSurface == null || ws.mLayer >= aboveAppLayer || !including && appToken != null && (!ws.mIsImWindow || !isImeTarget) && (ws.mAppToken == null || ws.mAppToken.token != appToken)) continue;
                boolean bl = including = !ws.mIsImWindow && !ws.isFullscreen(dw, dh);
                if (maxLayer < ws.mAnimLayer) {
                    maxLayer = ws.mAnimLayer;
                }
                if (ws.mIsWallpaper) continue;
                Rect wf = ws.mFrame;
                Rect cr = ws.mContentInsets;
                int left = wf.left + cr.left;
                int top = wf.top + cr.top;
                int right = wf.right - cr.right;
                int bottom = wf.bottom - cr.bottom;
                frame.union(left, top, right, bottom);
            }
            Binder.restoreCallingIdentity((long)ident);
            frame.intersect(0, 0, dw, dh);
            if (frame.isEmpty() || maxLayer == 0) {
                return null;
            }
            rot = this.mDisplay.getRotation();
            int fw = frame.width();
            int fh = frame.height();
            float targetWidthScale = (float)width / (float)fw;
            float targetHeightScale = (float)height / (float)fh;
            if (dw <= dh) {
                scale = targetWidthScale;
                if (targetHeightScale > scale && (int)(targetHeightScale * (float)fw) == width) {
                    scale = targetHeightScale;
                }
            } else {
                scale = targetHeightScale;
                if (targetWidthScale > scale && (int)(targetWidthScale * (float)fh) == height) {
                    scale = targetWidthScale;
                }
            }
            dw = (int)((float)dw * scale);
            dh = (int)((float)dh * scale);
            if (rot == 1 || rot == 3) {
                int tmp = dw;
                dw = dh;
                dh = tmp;
                rot = rot == 1 ? 3 : 1;
            }
            rawss = Surface.screenshot((int)dw, (int)dh, (int)0, (int)maxLayer);
        }
        if (rawss == null) {
            Slog.w((String)TAG, (String)("Failure taking screenshot for (" + dw + "x" + dh + ") to layer " + maxLayer));
            return null;
        }
        Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)rawss.getConfig());
        Matrix matrix = new Matrix();
        ScreenRotationAnimation.createRotationMatrix(rot, dw, dh, matrix);
        matrix.postTranslate((float)(-((int)((float)frame.left * scale))), (float)(-((int)((float)frame.top * scale))));
        Canvas canvas = new Canvas(bm);
        canvas.drawBitmap(rawss, matrix, null);
        canvas.setBitmap(null);
        rawss.recycle();
        return bm;
    }

    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        this.mPolicy.setUserRotationMode(1, rotation == -1 ? this.mRotation : rotation);
        this.updateRotationUnchecked(false);
    }

    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        this.mPolicy.setUserRotationMode(0, 777);
        this.updateRotationUnchecked(false);
    }

    public void updateRotation(boolean alwaysSendConfiguration) {
        this.updateRotationUnchecked(alwaysSendConfiguration);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            boolean changed;
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0 && (changed = this.updateRotationUncheckedLocked(false))) {
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRotationUnchecked(boolean alwaysSendConfiguration) {
        boolean changed;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            changed = this.updateRotationUncheckedLocked(false);
        }
        if (changed || alwaysSendConfiguration) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRotationUncheckedLocked(boolean inTransaction) {
        int i;
        boolean altOrientation;
        if (this.mDeferredRotationPauseCount > 0) {
            return false;
        }
        if (this.mScreenRotationAnimation != null && this.mScreenRotationAnimation.isAnimating()) {
            return false;
        }
        if (!this.mDisplayEnabled) {
            return false;
        }
        int rotation = this.mPolicy.rotationForOrientationLw(this.mForcedAppOrientation, this.mRotation);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mForcedAppOrientation, rotation);
        if (this.mRotation == rotation && this.mAltOrientation == altOrientation) {
            return false;
        }
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        this.mPolicy.setRotationLw(this.mRotation);
        this.mWindowsFreezingScreen = true;
        this.mH.removeMessages(11);
        this.mH.sendMessageDelayed(this.mH.obtainMessage(11), 2000L);
        this.mWaitingForConfig = true;
        this.mLayoutNeeded = true;
        this.startFreezingDisplayLocked(inTransaction);
        this.mInputManager.setDisplayOrientation(0, rotation);
        if (!inTransaction) {
            Surface.openTransaction();
        }
        try {
            if (this.mScreenRotationAnimation != null && this.mScreenRotationAnimation.hasScreenshot()) {
                this.mScreenRotationAnimation.setRotation(rotation);
            }
            Surface.setOrientation((int)0, (int)rotation);
        }
        finally {
            if (!inTransaction) {
                Surface.closeTransaction();
            }
        }
        this.rebuildBlackFrame(inTransaction);
        for (i = this.mWindows.size() - 1; i >= 0; --i) {
            WindowState w = this.mWindows.get(i);
            if (w.mSurface == null) continue;
            w.mOrientationChanging = true;
        }
        for (i = this.mRotationWatchers.size() - 1; i >= 0; --i) {
            try {
                this.mRotationWatchers.get(i).onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return true;
    }

    public int getRotation() {
        return this.mRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int watchRotation(IRotationWatcher watcher) {
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void binderDied() {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                        if (watcherBinder != WindowManagerService.this.mRotationWatchers.get(i).asBinder()) continue;
                        IRotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                        if (removed != null) {
                            removed.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
                        }
                        --i;
                    }
                }
            }
        };
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            try {
                watcher.asBinder().linkToDeath(dr, 0);
                this.mRotationWatchers.add(watcher);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return this.mRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredOptionsPanelGravity() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int rotation = this.getRotation();
            if (this.mInitialDisplayWidth < this.mInitialDisplayHeight) {
                switch (rotation) {
                    default: {
                        return 81;
                    }
                    case 1: {
                        return 85;
                    }
                    case 2: {
                        return 81;
                    }
                    case 3: 
                }
                return 83;
            }
            switch (rotation) {
                default: {
                    return 85;
                }
                case 1: {
                    return 81;
                }
                case 2: {
                    return 83;
                }
                case 3: 
            }
            return 81;
        }
    }

    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w((String)TAG, (String)"View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)"View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get((String)SYSTEM_SECURE, (String)"1")) && "0".equals(SystemProperties.get((String)SYSTEM_DEBUGGABLE, (String)"0"));
    }

    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        WindowState[] windows;
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            windows = this.mWindows.toArray(new WindowState[this.mWindows.size()]);
        }
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            for (WindowState w : windows) {
                out.write(Integer.toHexString(System.identityHashCode(w)));
                out.write(32);
                out.append(w.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket((Socket)client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w((String)TAG, (String)("Could not send command " + command + " with parameters " + parameters), (Throwable)e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWindowsChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].windowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocusChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].focusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState findWindow(int hashCode) {
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            ArrayList<WindowState> windows = this.mWindows;
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = windows.get(i);
                if (System.identityHashCode(w) != hashCode) continue;
                return w;
            }
        }
        return null;
    }

    void sendNewConfiguration() {
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration computeNewConfiguration() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Configuration config = this.computeNewConfigurationLocked();
            if (config == null && this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.performLayoutAndPlaceSurfacesLocked();
            }
            return config;
        }
    }

    Configuration computeNewConfigurationLocked() {
        Configuration config = new Configuration();
        config.fontScale = 0.0f;
        if (!this.computeNewConfigurationLocked(config)) {
            return null;
        }
        return config;
    }

    private int reduceConfigWidthSize(int curSize, int rotation, float density, int dw, int dh) {
        int size = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, rotation) / density);
        if (size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh) {
        int curSize;
        boolean screenLayoutCompatNeeded;
        boolean screenLayoutLong;
        int screenLayoutSize;
        int h;
        int shortSize;
        int w = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        if (longSize < 470) {
            screenLayoutSize = 1;
            screenLayoutLong = false;
            screenLayoutCompatNeeded = false;
        } else {
            screenLayoutSize = longSize >= 960 && shortSize >= 720 ? 4 : (longSize >= 640 && shortSize >= 480 ? 3 : 2);
            screenLayoutCompatNeeded = shortSize > 321 || longSize > 570;
            screenLayoutLong = longSize * 3 / 5 >= shortSize - 1;
        }
        if (!screenLayoutLong) {
            curLayout = curLayout & 0xFFFFFFCF | 0x10;
        }
        if (screenLayoutCompatNeeded) {
            curLayout |= 0x10000000;
        }
        if (screenLayoutSize < (curSize = curLayout & 0xF)) {
            curLayout = curLayout & 0xFFFFFFF0 | screenLayoutSize;
        }
        return curLayout;
    }

    private void computeSmallestWidthAndScreenLayout(boolean rotated, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceConfigWidthSize(unrotDw, 0, density, unrotDw, unrotDh);
        sw = this.reduceConfigWidthSize(sw, 1, density, unrotDh, unrotDw);
        sw = this.reduceConfigWidthSize(sw, 2, density, unrotDw, unrotDh);
        sw = this.reduceConfigWidthSize(sw, 3, density, unrotDh, unrotDw);
        int sl = 36;
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw);
        outConfig.smallestScreenWidthDp = sw;
        outConfig.screenLayout = sl;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, DisplayMetrics dm, int dw, int dh) {
        dm.noncompatWidthPixels = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        dm.noncompatHeightPixels = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation);
        float scale = CompatibilityInfo.computeCompatibleScaling((DisplayMetrics)dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int computeCompatSmallestWidth(boolean rotated, DisplayMetrics dm, int dw, int dh) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(dm);
        dm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, dm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 1, dm, unrotDh, unrotDw);
        sw = this.reduceCompatConfigWidthSize(sw, 2, dm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 3, dm, unrotDh, unrotDw);
        return sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean computeNewConfigurationLocked(Configuration config) {
        boolean hardKeyboardAvailable;
        if (this.mDisplay == null) {
            return false;
        }
        this.mInputManager.getInputConfiguration(config);
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int realdh = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            if (this.mAltOrientation) {
                this.mCurDisplayWidth = realdw;
                this.mCurDisplayHeight = realdh;
                if (realdw > realdh) {
                    int maxw = (int)((float)realdh / 1.3f);
                    if (maxw < realdw) {
                        this.mCurDisplayWidth = maxw;
                    }
                } else {
                    int maxh = (int)((float)realdw / 1.3f);
                    if (maxh < realdh) {
                        this.mCurDisplayHeight = maxh;
                    }
                }
            } else {
                this.mCurDisplayWidth = realdw;
                this.mCurDisplayHeight = realdh;
            }
        }
        int dw = this.mCurDisplayWidth;
        int dh = this.mCurDisplayHeight;
        int orientation = 3;
        if (dw < dh) {
            orientation = 1;
        } else if (dw > dh) {
            orientation = 2;
        }
        config.orientation = orientation;
        this.mDisplay.getMetricsWithSize(this.mRealDisplayMetrics, this.mCurDisplayWidth, this.mCurDisplayHeight);
        DisplayMetrics dm = this.mDisplayMetrics;
        int appWidth = this.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation);
        int appHeight = this.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation);
        Object object2 = this.mDisplaySizeLock;
        synchronized (object2) {
            this.mAppDisplayWidth = appWidth;
            this.mAppDisplayHeight = appHeight;
        }
        this.mDisplay.getMetricsWithSize(dm, this.mAppDisplayWidth, this.mAppDisplayHeight);
        this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling((DisplayMetrics)dm, (DisplayMetrics)this.mCompatDisplayMetrics);
        config.screenWidthDp = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, this.mRotation) / dm.density);
        config.screenHeightDp = (int)((float)this.mPolicy.getConfigDisplayHeight(dw, dh, this.mRotation) / dm.density);
        this.computeSmallestWidthAndScreenLayout(rotated, dw, dh, dm.density, config);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, dm, dw, dh);
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mHardKeyboardAvailable) {
            this.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mHardKeyboardEnabled = hardKeyboardAvailable;
            this.mH.removeMessages(22);
            this.mH.sendEmptyMessage(22);
        }
        if (!this.mHardKeyboardEnabled) {
            config.keyboard = 1;
        }
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mPolicy.adjustConfigurationLw(config);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardKeyboardAvailable() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mHardKeyboardAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardKeyboardEnabled() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mHardKeyboardEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardKeyboardEnabled(boolean enabled) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mHardKeyboardEnabled != enabled) {
                this.mHardKeyboardEnabled = enabled;
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnHardKeyboardStatusChangeListener(OnHardKeyboardStatusChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mHardKeyboardStatusChangeListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean enabled;
        boolean available;
        OnHardKeyboardStatusChangeListener listener;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            listener = this.mHardKeyboardStatusChangeListener;
            available = this.mHardKeyboardAvailable;
            enabled = this.mHardKeyboardEnabled;
        }
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder prepareDragSurface(IWindow window, SurfaceSession session, int flags, int width, int height, Surface outSurface) {
        int callerPid = Binder.getCallingPid();
        long origId = Binder.clearCallingIdentity();
        Binder token = null;
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                block10: {
                    try {
                        if (this.mDragState == null) {
                            Surface surface = new Surface(session, callerPid, "drag surface", 0, width, height, -3, 4);
                            outSurface.copyFrom(surface);
                            IBinder winBinder = window.asBinder();
                            token = new Binder();
                            this.mDragState = new DragState(this, (IBinder)token, surface, 0, winBinder);
                            this.mDragState.mSurface = surface;
                            this.mDragState.mToken = new Binder();
                            token = this.mDragState.mToken;
                            this.mH.removeMessages(20, winBinder);
                            Message msg = this.mH.obtainMessage(20, winBinder);
                            this.mH.sendMessageDelayed(msg, 5000L);
                        } else {
                            Slog.w((String)TAG, (String)"Drag already in progress");
                        }
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Slog.e((String)TAG, (String)("Can't allocate drag surface w=" + width + " h=" + height), (Throwable)e);
                        if (this.mDragState == null) break block10;
                        this.mDragState.reset();
                        this.mDragState = null;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)origId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "pauseKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.pauseDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "resumeKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.resumeDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "resumeKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInputMonitor.setEventDispatchingLw(enabled);
        }
    }

    public boolean injectKeyEvent(KeyEvent ev, boolean sync) {
        long downTime = ev.getDownTime();
        long eventTime = ev.getEventTime();
        int action = ev.getAction();
        int code = ev.getKeyCode();
        int repeatCount = ev.getRepeatCount();
        int metaState = ev.getMetaState();
        int deviceId = ev.getDeviceId();
        int scancode = ev.getScanCode();
        int source = ev.getSource();
        int flags = ev.getFlags();
        if (source == 0) {
            source = 257;
        }
        if (eventTime == 0L) {
            eventTime = SystemClock.uptimeMillis();
        }
        if (downTime == 0L) {
            downTime = eventTime;
        }
        KeyEvent newEvent = new KeyEvent(downTime, eventTime, action, code, repeatCount, metaState, deviceId, scancode, flags | 8, source);
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        int result = this.mInputManager.injectInputEvent((InputEvent)newEvent, pid, uid, sync ? 2 : 1, 30000);
        Binder.restoreCallingIdentity((long)ident);
        return this.reportInjectionResult(result);
    }

    public boolean injectPointerEvent(MotionEvent ev, boolean sync) {
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        MotionEvent newEvent = MotionEvent.obtain((MotionEvent)ev);
        if ((newEvent.getSource() & 2) == 0) {
            newEvent.setSource(4098);
        }
        int result = this.mInputManager.injectInputEvent((InputEvent)newEvent, pid, uid, sync ? 2 : 1, 30000);
        Binder.restoreCallingIdentity((long)ident);
        return this.reportInjectionResult(result);
    }

    public boolean injectTrackballEvent(MotionEvent ev, boolean sync) {
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        MotionEvent newEvent = MotionEvent.obtain((MotionEvent)ev);
        if ((newEvent.getSource() & 4) == 0) {
            newEvent.setSource(65540);
        }
        int result = this.mInputManager.injectInputEvent((InputEvent)newEvent, pid, uid, sync ? 2 : 1, 30000);
        Binder.restoreCallingIdentity((long)ident);
        return this.reportInjectionResult(result);
    }

    public boolean injectInputEventNoWait(InputEvent ev) {
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        int result = this.mInputManager.injectInputEvent(ev, pid, uid, 0, 30000);
        Binder.restoreCallingIdentity((long)ident);
        return this.reportInjectionResult(result);
    }

    private boolean reportInjectionResult(int result) {
        switch (result) {
            case 1: {
                Slog.w((String)TAG, (String)"Input event injection permission denied.");
                throw new SecurityException("Injecting to another application requires INJECT_EVENTS permission");
            }
            case 0: {
                return true;
            }
            case 3: {
                Slog.w((String)TAG, (String)"Input event injection timed out.");
                return false;
            }
        }
        Slog.w((String)TAG, (String)"Input event injection failed.");
        return false;
    }

    public void setPointerSpeed(int speed) {
        if (!this.checkCallingPermission("android.permission.SET_POINTER_SPEED", "setPointerSpeed()")) {
            throw new SecurityException("Requires SET_POINTER_SPEED permission");
        }
        this.mInputManager.setPointerSpeed(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState getFocusedWindow() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getFocusedWindowLocked();
        }
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w((String)TAG, (String)"Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        this.mSafeMode = this.mPolicy.detectSafeMode();
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplay != null) {
                throw new IllegalStateException("Display already initialized");
            }
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            this.mDisplay = wm.getDefaultDisplay();
            Object object = this.mDisplaySizeLock;
            synchronized (object) {
                this.mInitialDisplayWidth = this.mDisplay.getRawWidth();
                this.mInitialDisplayHeight = this.mDisplay.getRawHeight();
                int rot = this.mDisplay.getRotation();
                if (rot == 1 || rot == 3) {
                    int tmp = this.mInitialDisplayWidth;
                    this.mInitialDisplayWidth = this.mInitialDisplayHeight;
                    this.mInitialDisplayHeight = tmp;
                }
                this.mCurDisplayWidth = this.mAppDisplayWidth = this.mInitialDisplayWidth;
                this.mBaseDisplayWidth = this.mAppDisplayWidth;
                this.mCurDisplayHeight = this.mAppDisplayHeight = this.mInitialDisplayHeight;
                this.mBaseDisplayHeight = this.mAppDisplayHeight;
            }
            this.mInputManager.setDisplaySize(0, this.mDisplay.getRawWidth(), this.mDisplay.getRawHeight(), this.mDisplay.getRawExternalWidth(), this.mDisplay.getRawExternalHeight());
            this.mPolicy.setInitialDisplaySize(this.mInitialDisplayWidth, this.mInitialDisplayHeight);
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.readForcedDisplaySizeLocked();
        }
    }

    public void systemReady() {
        this.mPolicy.systemReady();
    }

    public IWindowSession openSession(IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState imFocus;
            int idx = this.findDesiredInputMethodWindowIndexLocked(false);
            if (idx > 0 && (imFocus = this.mWindows.get(idx - 1)) != null) {
                if (imFocus.mAttrs.type == 3 && imFocus.mAppToken != null) {
                    for (int i = 0; i < imFocus.mAppToken.windows.size(); ++i) {
                        WindowState w = (WindowState)imFocus.mAppToken.windows.get(i);
                        if (w == imFocus) continue;
                        imFocus = w;
                        break;
                    }
                }
                if (imFocus.mSession.mClient != null && imFocus.mSession.mClient.asBinder() == client.asBinder()) {
                    return true;
                }
                if (this.mCurrentFocus != null && this.mCurrentFocus.mSession.mClient != null && this.mCurrentFocus.mSession.mClient.asBinder() == client.asBinder()) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDisplaySize(Point size) {
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            size.x = this.mAppDisplayWidth;
            size.y = this.mAppDisplayHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRealDisplaySize(Point size) {
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            size.x = this.mCurDisplayWidth;
            size.y = this.mCurDisplayHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInitialDisplaySize(Point size) {
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            size.x = this.mInitialDisplayWidth;
            size.y = this.mInitialDisplayHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumSizeDimension() {
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            return this.mBaseDisplayWidth > this.mBaseDisplayHeight ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForcedDisplaySize(int longDimen, int shortDimen) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int height;
            int width;
            if (this.mInitialDisplayWidth < this.mInitialDisplayHeight) {
                width = shortDimen < this.mInitialDisplayWidth ? shortDimen : this.mInitialDisplayWidth;
                height = longDimen < this.mInitialDisplayHeight ? longDimen : this.mInitialDisplayHeight;
            } else {
                width = longDimen < this.mInitialDisplayWidth ? longDimen : this.mInitialDisplayWidth;
                height = shortDimen < this.mInitialDisplayHeight ? shortDimen : this.mInitialDisplayHeight;
            }
            this.setForcedDisplaySizeLocked(width, height);
            Settings.Secure.putString((ContentResolver)this.mContext.getContentResolver(), (String)"display_size_forced", (String)(width + "," + height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildBlackFrame(boolean inTransaction) {
        if (!inTransaction) {
            Surface.openTransaction();
        }
        try {
            if (this.mBlackFrame != null) {
                this.mBlackFrame.kill();
                this.mBlackFrame = null;
            }
            if (this.mBaseDisplayWidth < this.mInitialDisplayWidth || this.mBaseDisplayHeight < this.mInitialDisplayHeight) {
                int baseH;
                int baseW;
                int initH;
                int initW;
                boolean rotated;
                boolean bl = rotated = this.mRotation == 1 || this.mRotation == 3;
                if (rotated) {
                    initW = this.mInitialDisplayHeight;
                    initH = this.mInitialDisplayWidth;
                    baseW = this.mBaseDisplayHeight;
                    baseH = this.mBaseDisplayWidth;
                } else {
                    initW = this.mInitialDisplayWidth;
                    initH = this.mInitialDisplayHeight;
                    baseW = this.mBaseDisplayWidth;
                    baseH = this.mBaseDisplayHeight;
                }
                Rect outer = new Rect(0, 0, initW, initH);
                Rect inner = new Rect(0, 0, baseW, baseH);
                try {
                    this.mBlackFrame = new BlackFrame(this.mFxSession, outer, inner, 2000000);
                }
                catch (Surface.OutOfResourcesException e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (!inTransaction) {
                Surface.closeTransaction();
            }
        }
    }

    private void readForcedDisplaySizeLocked() {
        int height;
        int width;
        String str = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"display_size_forced");
        if (str == null || str.length() == 0) {
            return;
        }
        int pos = str.indexOf(44);
        if (pos <= 0 || str.lastIndexOf(44) != pos) {
            return;
        }
        try {
            width = Integer.parseInt(str.substring(0, pos));
            height = Integer.parseInt(str.substring(pos + 1));
        }
        catch (NumberFormatException ex) {
            return;
        }
        this.setForcedDisplaySizeLocked(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplaySizeLocked(int width, int height) {
        Slog.i((String)TAG, (String)("Using new display size: " + width + "x" + height));
        Object object = this.mDisplaySizeLock;
        synchronized (object) {
            this.mBaseDisplayWidth = width;
            this.mBaseDisplayHeight = height;
        }
        this.mPolicy.setInitialDisplaySize(this.mBaseDisplayWidth, this.mBaseDisplayHeight);
        this.mLayoutNeeded = true;
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mTempConfiguration.setToDefaults();
        this.mTempConfiguration.fontScale = this.mCurConfiguration.fontScale;
        if (this.computeNewConfigurationLocked(this.mTempConfiguration) && this.mCurConfiguration.diff(this.mTempConfiguration) != 0) {
            configChanged = true;
        }
        if (configChanged) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(false);
            this.mH.sendEmptyMessage(18);
        }
        this.rebuildBlackFrame(false);
        this.performLayoutAndPlaceSurfacesLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearForcedDisplaySize() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setForcedDisplaySizeLocked(this.mInitialDisplayWidth, this.mInitialDisplayHeight);
            Settings.Secure.putString((ContentResolver)this.mContext.getContentResolver(), (String)"display_size_forced", (String)"");
        }
    }

    public boolean canStatusBarHide() {
        return this.mPolicy.canStatusBarHide();
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = this.mWindowMap.get(client);
        if (win == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " does not exist");
            if (throwOnError) {
                throw ex;
            }
            Slog.w((String)TAG, (String)"Failed looking up window", (Throwable)ex);
            return null;
        }
        if (session != null && win.mSession != session) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " is in session " + (Object)((Object)win.mSession) + ", not " + (Object)((Object)session));
            if (throwOnError) {
                throw ex;
            }
            Slog.w((String)TAG, (String)"Failed looking up window", (Throwable)ex);
            return null;
        }
        return win;
    }

    final void rebuildAppWindowListLocked() {
        int j;
        int NW = this.mWindows.size();
        int lastWallpaper = -1;
        int numRemoved = 0;
        if (this.mRebuildTmp.length < NW) {
            this.mRebuildTmp = new WindowState[NW + 10];
        }
        int i = 0;
        while (i < NW) {
            WindowState w = this.mWindows.get(i);
            if (w.mAppToken != null) {
                WindowState win = this.mWindows.remove(i);
                win.mRebuilding = true;
                this.mRebuildTmp[numRemoved] = win;
                this.mWindowsChanged = true;
                --NW;
                ++numRemoved;
                continue;
            }
            if (w.mAttrs.type == 2013 && lastWallpaper == i - 1) {
                lastWallpaper = i;
            }
            ++i;
        }
        i = ++lastWallpaper;
        int NT = this.mExitingAppTokens.size();
        for (j = 0; j < NT; ++j) {
            i = this.reAddAppWindowsLocked(i, this.mExitingAppTokens.get(j));
        }
        NT = this.mAppTokens.size();
        for (j = 0; j < NT; ++j) {
            i = this.reAddAppWindowsLocked(i, this.mAppTokens.get(j));
        }
        if ((i -= lastWallpaper) != numRemoved) {
            Slog.w((String)TAG, (String)("Rebuild removed " + numRemoved + " windows but added " + i));
            for (i = 0; i < numRemoved; ++i) {
                WindowState ws = this.mRebuildTmp[i];
                if (!ws.mRebuilding) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ws.dump(pw, "", true);
                pw.flush();
                Slog.w((String)TAG, (String)("This window was lost: " + ws));
                Slog.w((String)TAG, (String)sw.toString());
            }
            Slog.w((String)TAG, (String)"Current app token list:");
            this.dumpAppTokensLocked();
            Slog.w((String)TAG, (String)"Final window list:");
            this.dumpWindowsLocked();
        }
    }

    private final void assignLayersLocked() {
        int N = this.mWindows.size();
        int curBaseLayer = 0;
        int curLayer = 0;
        for (int i = 0; i < N; ++i) {
            WindowState w = this.mWindows.get(i);
            if (w.mBaseLayer == curBaseLayer || w.mIsImWindow || i > 0 && w.mIsWallpaper) {
                w.mLayer = curLayer += 5;
            } else {
                curBaseLayer = curLayer = w.mBaseLayer;
                w.mLayer = curLayer;
            }
            w.mAnimLayer = w.mTargetAppToken != null ? w.mLayer + w.mTargetAppToken.animLayerAdjustment : (w.mAppToken != null ? w.mLayer + w.mAppToken.animLayerAdjustment : w.mLayer);
            if (w.mIsImWindow) {
                w.mAnimLayer += this.mInputMethodAnimLayerAdjustment;
                continue;
            }
            if (!w.mIsWallpaper) continue;
            w.mAnimLayer += this.mWallpaperAnimLayerAdjustment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performLayoutAndPlaceSurfacesLocked() {
        boolean recoveringMemory;
        block19: {
            if (this.mInLayout) {
                Slog.w((String)TAG, (String)"performLayoutAndPlaceSurfacesLocked called while in layout");
                return;
            }
            if (this.mWaitingForConfig) {
                return;
            }
            if (this.mDisplay == null) {
                return;
            }
            this.mInLayout = true;
            recoveringMemory = false;
            try {
                Object tmp;
                Object ws;
                if (this.mForceRemoves == null) break block19;
                recoveringMemory = true;
                for (int i = 0; i < this.mForceRemoves.size(); ++i) {
                    ws = this.mForceRemoves.get(i);
                    Slog.i((String)TAG, (String)("Force removing: " + ws));
                    this.removeWindowInnerLocked(((WindowState)ws).mSession, (WindowState)ws);
                }
                this.mForceRemoves = null;
                Slog.w((String)TAG, (String)"Due to memory failure, waiting a bit for next layout");
                ws = tmp = new Object();
                synchronized (ws) {
                    try {
                        tmp.wait(250L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException e) {
                Log.wtf((String)TAG, (String)"Unhandled exception while force removing for memory", (Throwable)e);
            }
        }
        try {
            this.performLayoutAndPlaceSurfacesLockedInner(recoveringMemory);
            int N = this.mPendingRemove.size();
            if (N > 0) {
                if (this.mPendingRemoveTmp.length < N) {
                    this.mPendingRemoveTmp = new WindowState[N + 10];
                }
                this.mPendingRemove.toArray(this.mPendingRemoveTmp);
                this.mPendingRemove.clear();
                for (int i = 0; i < N; ++i) {
                    WindowState w = this.mPendingRemoveTmp[i];
                    this.removeWindowInnerLocked(w.mSession, w);
                }
                this.mInLayout = false;
                this.assignLayersLocked();
                this.mLayoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            } else {
                this.mInLayout = false;
                if (this.mLayoutNeeded) {
                    this.requestAnimationLocked(0L);
                }
            }
            if (this.mWindowsChanged && !this.mWindowChangeListeners.isEmpty()) {
                this.mH.removeMessages(19);
                this.mH.sendMessage(this.mH.obtainMessage(19));
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Log.wtf((String)TAG, (String)"Unhandled exception while laying out windows", (Throwable)e);
        }
    }

    private final int performLayoutLockedInner(boolean initial, boolean updateInputWindows) {
        WindowState win;
        int i;
        if (!this.mLayoutNeeded) {
            return 0;
        }
        this.mLayoutNeeded = false;
        int dw = this.mCurDisplayWidth;
        int dh = this.mCurDisplayHeight;
        int NFW = this.mFakeWindows.size();
        for (int i2 = 0; i2 < NFW; ++i2) {
            this.mFakeWindows.get(i2).layout(dw, dh);
        }
        int N = this.mWindows.size();
        this.mPolicy.beginLayoutLw(dw, dh, this.mRotation);
        int seq = this.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mLayoutSeq = seq;
        int topAttached = -1;
        for (i = N - 1; i >= 0; --i) {
            boolean gone;
            win = this.mWindows.get(i);
            AppWindowToken atoken = win.mAppToken;
            boolean bl = gone = win.mViewVisibility == 8 || !win.mRelayoutCalled || atoken == null && win.mRootToken.hidden || atoken != null && atoken.hiddenRequested || win.mAttachedHidden || win.mExiting || win.mDestroying;
            if (gone && win.mHaveFrame) continue;
            if (!win.mLayoutAttached) {
                if (initial) {
                    win.mContentChanged = false;
                }
                win.prelayout();
                this.mPolicy.layoutWindowLw((WindowManagerPolicy.WindowState)win, win.mAttrs, null);
                win.mLayoutSeq = seq;
                continue;
            }
            if (topAttached >= 0) continue;
            topAttached = i;
        }
        for (i = topAttached; i >= 0; --i) {
            win = this.mWindows.get(i);
            if (!win.mLayoutAttached || (win.mViewVisibility == 8 || !win.mRelayoutCalled) && win.mHaveFrame) continue;
            if (initial) {
                win.mContentChanged = false;
            }
            win.prelayout();
            this.mPolicy.layoutWindowLw((WindowManagerPolicy.WindowState)win, win.mAttrs, (WindowManagerPolicy.WindowState)win.mAttachedWindow);
            win.mLayoutSeq = seq;
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
        return this.mPolicy.finishLayoutLw();
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (this.mDisplayFrozen || !this.mPolicy.isScreenOnFully()) {
            w.mOrientationChanging = true;
            if (!this.mWindowsFreezingScreen) {
                this.mWindowsFreezingScreen = true;
                this.mH.removeMessages(11);
                this.mH.sendMessageDelayed(this.mH.obtainMessage(11), 2000L);
            }
        }
    }

    private final void performLayoutAndPlaceSurfacesLockedInner(boolean recoveringMemory) {
        int i;
        if (this.mDisplay == null) {
            Slog.i((String)TAG, (String)"skipping performLayoutAndPlaceSurfacesLockedInner with no mDisplay");
            return;
        }
        long currentTime = SystemClock.uptimeMillis();
        int dw = this.mCurDisplayWidth;
        int dh = this.mCurDisplayHeight;
        int innerDw = this.mAppDisplayWidth;
        int innerDh = this.mAppDisplayHeight;
        if (this.mFocusMayChange) {
            this.mFocusMayChange = false;
            this.updateFocusedWindowLocked(3, false);
        }
        for (i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            this.mExitingTokens.get((int)i).hasVisible = false;
        }
        for (i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
            this.mExitingAppTokens.get((int)i).hasVisible = false;
        }
        boolean orientationChangeComplete = true;
        Session holdScreen = null;
        float screenBrightness = -1.0f;
        float buttonBrightness = -1.0f;
        boolean focusDisplayed = false;
        boolean animating = false;
        boolean createWatermark = false;
        boolean updateRotation = false;
        boolean screenRotationFinished = false;
        if (this.mFxSession == null) {
            this.mFxSession = new SurfaceSession();
            createWatermark = true;
        }
        Surface.openTransaction();
        if (createWatermark) {
            this.createWatermark();
        }
        if (this.mWatermark != null) {
            this.mWatermark.positionSurface(dw, dh);
        }
        if (this.mStrictModeFlash != null) {
            this.mStrictModeFlash.positionSurface(dw, dh);
        }
        try {
            boolean wallpaperForceHidingChanged = false;
            int repeats = 0;
            int changes = 0;
            do {
                if (++repeats > 6) {
                    Slog.w((String)TAG, (String)"Animation repeat aborted after too many iterations");
                    this.mLayoutNeeded = false;
                    break;
                }
                if ((changes & 7) != 0) {
                    if ((changes & 4) != 0 && (this.adjustWallpaperWindowsLocked() & 2) != 0) {
                        this.assignLayersLocked();
                        this.mLayoutNeeded = true;
                    }
                    if ((changes & 2) != 0 && this.updateOrientationFromAppTokensLocked(true)) {
                        this.mLayoutNeeded = true;
                        this.mH.sendEmptyMessage(18);
                    }
                    if ((changes & 1) != 0) {
                        this.mLayoutNeeded = true;
                    }
                }
                if (repeats < 4) {
                    changes = this.performLayoutLockedInner(repeats == 0, false);
                    if (changes != 0) {
                        continue;
                    }
                } else {
                    Slog.w((String)TAG, (String)"Layout repeat skipped after too many iterations");
                    changes = 0;
                }
                int transactionSequence = ++this.mTransactionSequence;
                boolean tokensAnimating = false;
                int NAT = this.mAppTokens.size();
                for (i = 0; i < NAT; ++i) {
                    if (!this.mAppTokens.get(i).stepAnimationLocked(currentTime, innerDw, innerDh)) continue;
                    tokensAnimating = true;
                }
                int NEAT = this.mExitingAppTokens.size();
                for (i = 0; i < NEAT; ++i) {
                    if (!this.mExitingAppTokens.get(i).stepAnimationLocked(currentTime, innerDw, innerDh)) continue;
                    tokensAnimating = true;
                }
                animating = tokensAnimating;
                if (this.mScreenRotationAnimation != null && this.mScreenRotationAnimation.isAnimating()) {
                    if (this.mScreenRotationAnimation.stepAnimation(currentTime)) {
                        animating = true;
                    } else {
                        screenRotationFinished = true;
                        updateRotation = true;
                    }
                }
                boolean tokenMayBeDrawn = false;
                boolean wallpaperMayChange = false;
                boolean forceHiding = false;
                WindowState windowDetachedWallpaper = null;
                WindowState windowAnimationBackground = null;
                int windowAnimationBackgroundColor = 0;
                this.mPolicy.beginAnimationLw(dw, dh);
                int N = this.mWindows.size();
                for (i = N - 1; i >= 0; --i) {
                    AppWindowToken atoken;
                    WindowState w = this.mWindows.get(i);
                    WindowManager.LayoutParams attrs = w.mAttrs;
                    if (w.mSurface != null) {
                        boolean nowAnimating;
                        if (w.commitFinishDrawingLocked(currentTime) && (w.mAttrs.flags & 0x100000) != 0) {
                            wallpaperMayChange = true;
                        }
                        boolean wasAnimating = w.mAnimating;
                        int animDw = innerDw;
                        int animDh = innerDh;
                        if (w.shouldAnimateMove()) {
                            Animation a = AnimationUtils.loadAnimation((Context)this.mContext, (int)17432658);
                            w.setAnimation(a);
                            animDw = w.mLastFrame.left - w.mFrame.left;
                            animDh = w.mLastFrame.top - w.mFrame.top;
                        }
                        if (nowAnimating = w.stepAnimationLocked(currentTime, animDw, animDh)) {
                            if (w.mAnimation != null) {
                                if ((w.mAttrs.flags & 0x100000) != 0 && w.mAnimation.getDetachWallpaper()) {
                                    windowDetachedWallpaper = w;
                                }
                                if (w.mAnimation.getBackgroundColor() != 0 && (windowAnimationBackground == null || w.mAnimLayer < windowAnimationBackground.mAnimLayer)) {
                                    windowAnimationBackground = w;
                                    windowAnimationBackgroundColor = w.mAnimation.getBackgroundColor();
                                }
                            }
                            animating = true;
                        }
                        if (w.mAppToken != null && w.mAppToken.animation != null && w.mAppToken.animating) {
                            if ((w.mAttrs.flags & 0x100000) != 0 && w.mAppToken.animation.getDetachWallpaper()) {
                                windowDetachedWallpaper = w;
                            }
                            if (w.mAppToken.animation.getBackgroundColor() != 0 && (windowAnimationBackground == null || w.mAnimLayer < windowAnimationBackground.mAnimLayer)) {
                                windowAnimationBackground = w;
                                windowAnimationBackgroundColor = w.mAppToken.animation.getBackgroundColor();
                            }
                        }
                        if (wasAnimating && !w.mAnimating && this.mWallpaperTarget == w) {
                            wallpaperMayChange = true;
                        }
                        if (this.mPolicy.doesForceHide((WindowManagerPolicy.WindowState)w, attrs)) {
                            if (!wasAnimating && nowAnimating) {
                                wallpaperForceHidingChanged = true;
                                this.mFocusMayChange = true;
                            } else if (w.isReadyForDisplay() && w.mAnimation == null) {
                                forceHiding = true;
                            }
                        } else if (this.mPolicy.canBeForceHidden((WindowManagerPolicy.WindowState)w, attrs)) {
                            boolean changed;
                            if (forceHiding) {
                                changed = w.hideLw(false, false);
                            } else {
                                changed = w.showLw(false, false);
                                if (changed) {
                                    Animation a;
                                    if (wallpaperForceHidingChanged && w.isVisibleNow() && (a = this.mPolicy.createForceHideEnterAnimation()) != null) {
                                        w.setAnimation(a);
                                    }
                                    if (this.mCurrentFocus == null || this.mCurrentFocus.mLayer < w.mLayer) {
                                        this.mFocusMayChange = true;
                                    }
                                }
                            }
                            if (changed && (attrs.flags & 0x100000) != 0) {
                                wallpaperMayChange = true;
                            }
                        }
                        this.mPolicy.animatingWindowLw((WindowManagerPolicy.WindowState)w, attrs);
                    }
                    if ((atoken = w.mAppToken) != null && (!atoken.allDrawn || atoken.freezingScreen)) {
                        if (atoken.lastTransactionSequence != transactionSequence) {
                            atoken.lastTransactionSequence = transactionSequence;
                            atoken.numDrawnWindows = 0;
                            atoken.numInterestingWindows = 0;
                            atoken.startingDisplayed = false;
                        }
                        if (!w.isOnScreen() && w.mAttrs.type != 1 || w.mExiting || w.mDestroying) continue;
                        if (w != atoken.startingWindow) {
                            if (atoken.freezingScreen && w.mAppFreezing) continue;
                            ++atoken.numInterestingWindows;
                            if (!w.isDrawnLw()) continue;
                            ++atoken.numDrawnWindows;
                            tokenMayBeDrawn = true;
                            continue;
                        }
                        if (!w.isDrawnLw()) continue;
                        atoken.startingDisplayed = true;
                        continue;
                    }
                    if (!w.mReadyToShow) continue;
                    w.performShowLocked();
                }
                changes |= this.mPolicy.finishAnimationLw();
                if (tokenMayBeDrawn) {
                    int NT = this.mAppTokens.size();
                    for (i = 0; i < NT; ++i) {
                        int numInteresting;
                        AppWindowToken wtoken = this.mAppTokens.get(i);
                        if (wtoken.freezingScreen) {
                            numInteresting = wtoken.numInterestingWindows;
                            if (numInteresting <= 0 || wtoken.numDrawnWindows < numInteresting) continue;
                            wtoken.showAllWindowsLocked();
                            this.unsetAppFreezingScreenLocked(wtoken, false, true);
                            orientationChangeComplete = true;
                            continue;
                        }
                        if (wtoken.allDrawn || (numInteresting = wtoken.numInterestingWindows) <= 0 || wtoken.numDrawnWindows < numInteresting) continue;
                        wtoken.allDrawn = true;
                        changes |= 8;
                        if (this.mOpeningApps.contains(wtoken)) continue;
                        wtoken.showAllWindowsLocked();
                    }
                }
                if (this.mAppTransitionReady) {
                    int NN = this.mOpeningApps.size();
                    boolean goodToGo = true;
                    if (!this.mDisplayFrozen && !this.mAppTransitionTimeout) {
                        for (i = 0; i < NN && goodToGo; ++i) {
                            AppWindowToken wtoken = this.mOpeningApps.get(i);
                            if (wtoken.allDrawn || wtoken.startingDisplayed || wtoken.startingMoved) continue;
                            goodToGo = false;
                        }
                    }
                    if (goodToGo) {
                        AppWindowToken wtoken;
                        int transit = this.mNextAppTransition;
                        if (this.mSkipAppTransitionAnimation) {
                            transit = -1;
                        }
                        this.mNextAppTransition = -1;
                        this.mAppTransitionReady = false;
                        this.mAppTransitionRunning = true;
                        this.mAppTransitionTimeout = false;
                        this.mStartingIconInTransition = false;
                        this.mSkipAppTransitionAnimation = false;
                        this.mH.removeMessages(13);
                        if (this.mToTopApps.size() > 0) {
                            NN = this.mAppTokens.size();
                            for (i = 0; i < NN; ++i) {
                                AppWindowToken wtoken2 = this.mAppTokens.get(i);
                                if (!wtoken2.sendingToTop) continue;
                                wtoken2.sendingToTop = false;
                                this.moveAppWindowsLocked(wtoken2, NN, false);
                            }
                            this.mToTopApps.clear();
                        }
                        WindowState oldWallpaper = this.mWallpaperTarget;
                        this.adjustWallpaperWindowsLocked();
                        wallpaperMayChange = false;
                        WindowManager.LayoutParams animLp = null;
                        int bestAnimLayer = -1;
                        boolean fullscreenAnim = false;
                        int foundWallpapers = 0;
                        int NC = this.mClosingApps.size();
                        NN = NC + this.mOpeningApps.size();
                        for (i = 0; i < NN; ++i) {
                            WindowState ws;
                            int mode;
                            if (i < NC) {
                                wtoken = this.mClosingApps.get(i);
                                mode = 1;
                            } else {
                                wtoken = this.mOpeningApps.get(i - NC);
                                mode = 2;
                            }
                            if (this.mLowerWallpaperTarget != null && (this.mLowerWallpaperTarget.mAppToken == wtoken || this.mUpperWallpaperTarget.mAppToken == wtoken)) {
                                foundWallpapers |= mode;
                            }
                            if (wtoken.appFullscreen) {
                                ws = wtoken.findMainWindow();
                                if (ws == null) continue;
                                animLp = ws.mAttrs;
                                bestAnimLayer = ws.mLayer;
                                fullscreenAnim = true;
                                continue;
                            }
                            if (fullscreenAnim || (ws = wtoken.findMainWindow()) == null || ws.mLayer <= bestAnimLayer) continue;
                            animLp = ws.mAttrs;
                            bestAnimLayer = ws.mLayer;
                        }
                        if (foundWallpapers == 3) {
                            switch (transit) {
                                case 4102: 
                                case 4104: 
                                case 4106: {
                                    transit = 4110;
                                    break;
                                }
                                case 8199: 
                                case 8201: 
                                case 8203: {
                                    transit = 8207;
                                }
                            }
                        } else if (oldWallpaper != null) {
                            transit = 8204;
                        } else if (this.mWallpaperTarget != null) {
                            transit = 4109;
                        }
                        if (!this.mPolicy.allowAppAnimationsLw()) {
                            animLp = null;
                        }
                        NN = this.mOpeningApps.size();
                        for (i = 0; i < NN; ++i) {
                            wtoken = this.mOpeningApps.get(i);
                            wtoken.reportedVisible = false;
                            wtoken.inPendingTransaction = false;
                            wtoken.animation = null;
                            this.setTokenVisibilityLocked(wtoken, animLp, true, transit, false);
                            wtoken.updateReportedVisibilityLocked();
                            wtoken.waitingToShow = false;
                            wtoken.showAllWindowsLocked();
                        }
                        NN = this.mClosingApps.size();
                        for (i = 0; i < NN; ++i) {
                            wtoken = this.mClosingApps.get(i);
                            wtoken.inPendingTransaction = false;
                            wtoken.animation = null;
                            this.setTokenVisibilityLocked(wtoken, animLp, false, transit, false);
                            wtoken.updateReportedVisibilityLocked();
                            wtoken.waitingToHide = false;
                            wtoken.allDrawn = true;
                        }
                        this.mNextAppTransitionPackage = null;
                        this.mOpeningApps.clear();
                        this.mClosingApps.clear();
                        changes |= 3;
                        this.mLayoutNeeded = true;
                        if (!this.moveInputMethodWindowsIfNeededLocked(true)) {
                            this.assignLayersLocked();
                        }
                        this.updateFocusedWindowLocked(2, false);
                        this.mFocusMayChange = false;
                    }
                }
                int adjResult = 0;
                if (!animating && this.mAppTransitionRunning) {
                    this.mAppTransitionRunning = false;
                    this.mToBottomApps.clear();
                    this.rebuildAppWindowListLocked();
                    changes |= 1;
                    adjResult |= 2;
                    this.moveInputMethodWindowsIfNeededLocked(false);
                    wallpaperMayChange = true;
                    this.mFocusMayChange = true;
                }
                if (wallpaperForceHidingChanged && changes == 0 && !this.mAppTransitionReady) {
                    WindowState oldWallpaper = this.mWallpaperTarget;
                    if (this.mLowerWallpaperTarget != null && this.mLowerWallpaperTarget.mAppToken != null && this.mLowerWallpaperTarget.mAppToken.hidden) {
                        this.mUpperWallpaperTarget = null;
                        this.mLowerWallpaperTarget = null;
                        changes |= 8;
                    }
                    adjResult |= this.adjustWallpaperWindowsLocked();
                    wallpaperMayChange = false;
                    wallpaperForceHidingChanged = false;
                    if (this.mLowerWallpaperTarget == null) {
                        forceHiding = false;
                        for (i = N - 1; i >= 0; --i) {
                            WindowState w = this.mWindows.get(i);
                            if (w.mSurface == null) continue;
                            WindowManager.LayoutParams attrs = w.mAttrs;
                            if (this.mPolicy.doesForceHide((WindowManagerPolicy.WindowState)w, attrs) && w.isVisibleLw()) {
                                forceHiding = true;
                                continue;
                            }
                            if (!this.mPolicy.canBeForceHidden((WindowManagerPolicy.WindowState)w, attrs) || w.mAnimating) continue;
                            w.clearAnimation();
                        }
                    }
                }
                if (this.mWindowDetachedWallpaper != windowDetachedWallpaper) {
                    this.mWindowDetachedWallpaper = windowDetachedWallpaper;
                    wallpaperMayChange = true;
                }
                if (windowAnimationBackgroundColor != 0) {
                    WindowState target = windowAnimationBackground;
                    if (this.mWallpaperTarget == windowAnimationBackground || this.mLowerWallpaperTarget == windowAnimationBackground || this.mUpperWallpaperTarget == windowAnimationBackground) {
                        for (i = 0; i < this.mWindows.size(); ++i) {
                            WindowState w = this.mWindows.get(i);
                            if (!w.mIsWallpaper) continue;
                            target = w;
                            break;
                        }
                    }
                    if (this.mWindowAnimationBackgroundSurface == null) {
                        this.mWindowAnimationBackgroundSurface = new DimSurface(this.mFxSession);
                    }
                    this.mWindowAnimationBackgroundSurface.show(dw, dh, target.mAnimLayer - 1, windowAnimationBackgroundColor);
                } else if (this.mWindowAnimationBackgroundSurface != null) {
                    this.mWindowAnimationBackgroundSurface.hide();
                }
                if (wallpaperMayChange) {
                    adjResult |= this.adjustWallpaperWindowsLocked();
                }
                if ((adjResult & 2) != 0) {
                    changes |= 1;
                    this.assignLayersLocked();
                } else if ((adjResult & 4) != 0) {
                    changes |= 1;
                }
                if (this.mFocusMayChange) {
                    this.mFocusMayChange = false;
                    if (this.updateFocusedWindowLocked(2, false)) {
                        changes |= 8;
                        adjResult = 0;
                    }
                }
                if (!this.mLayoutNeeded) continue;
                changes |= 1;
            } while (changes != 0);
            boolean someoneLosingFocus = this.mLosingFocus.size() != 0;
            boolean obscured = false;
            boolean blurring = false;
            boolean dimming = false;
            boolean covered = false;
            boolean syswin = false;
            int N = this.mWindows.size();
            for (i = N - 1; i >= 0; --i) {
                WindowState w = this.mWindows.get(i);
                boolean displayed = false;
                WindowManager.LayoutParams attrs = w.mAttrs;
                int attrFlags = attrs.flags;
                if (w.mSurface != null) {
                    block202: {
                        w.computeShownFrameLocked();
                        if (w.mSurface != null) {
                            boolean surfaceResized;
                            int height;
                            int width;
                            block201: {
                                WindowManager.LayoutParams cfr_ignored_0 = w.mAttrs;
                                if ((w.mAttrs.flags & 0x4000) != 0) {
                                    width = w.mRequestedWidth;
                                    height = w.mRequestedHeight;
                                } else {
                                    width = w.mCompatFrame.width();
                                    height = w.mCompatFrame.height();
                                }
                                if (width < 1) {
                                    width = 1;
                                }
                                if (height < 1) {
                                    height = 1;
                                }
                                boolean bl = surfaceResized = w.mSurfaceW != (float)width || w.mSurfaceH != (float)height;
                                if (surfaceResized) {
                                    w.mSurfaceW = width;
                                    w.mSurfaceH = height;
                                }
                                if (w.mSurfaceX != w.mShownFrame.left || w.mSurfaceY != w.mShownFrame.top) {
                                    try {
                                        w.mSurfaceX = w.mShownFrame.left;
                                        w.mSurfaceY = w.mShownFrame.top;
                                        w.mSurface.setPosition(w.mShownFrame.left, w.mShownFrame.top);
                                    }
                                    catch (RuntimeException e) {
                                        Slog.w((String)TAG, (String)("Error positioning surface of " + w + " pos=(" + w.mShownFrame.left + "," + w.mShownFrame.top + ")"), (Throwable)e);
                                        if (recoveringMemory) break block201;
                                        this.reclaimSomeSurfaceMemoryLocked(w, "position", true);
                                    }
                                }
                            }
                            if (surfaceResized) {
                                try {
                                    w.mSurfaceResized = true;
                                    w.mSurface.setSize(width, height);
                                }
                                catch (RuntimeException e) {
                                    Slog.e((String)TAG, (String)("Error resizing surface of " + w + " size=(" + width + "x" + height + ")"), (Throwable)e);
                                    if (recoveringMemory) break block202;
                                    this.reclaimSomeSurfaceMemoryLocked(w, "size", true);
                                }
                            }
                        }
                    }
                    if (!w.mAppFreezing && w.mLayoutSeq == this.mLayoutSeq) {
                        w.mContentInsetsChanged = w.mContentInsetsChanged | !w.mLastContentInsets.equals((Object)w.mContentInsets);
                        w.mVisibleInsetsChanged = w.mVisibleInsetsChanged | !w.mLastVisibleInsets.equals((Object)w.mVisibleInsets);
                        boolean configChanged = w.mConfiguration != this.mCurConfiguration && (w.mConfiguration == null || this.mCurConfiguration.diff(w.mConfiguration) != 0);
                        w.mLastFrame.set(w.mFrame);
                        if (w.mContentInsetsChanged || w.mVisibleInsetsChanged || w.mSurfaceResized || configChanged) {
                            w.mLastContentInsets.set(w.mContentInsets);
                            w.mLastVisibleInsets.set(w.mVisibleInsets);
                            this.makeWindowFreezingScreenIfNeededLocked(w);
                            if (w.mOrientationChanging) {
                                w.mDrawPending = true;
                                w.mCommitDrawPending = false;
                                w.mReadyToShow = false;
                                if (w.mAppToken != null) {
                                    w.mAppToken.allDrawn = false;
                                }
                            }
                            if (!this.mResizingWindows.contains(w)) {
                                this.mResizingWindows.add(w);
                            }
                        } else if (w.mOrientationChanging && !w.mDrawPending && !w.mCommitDrawPending) {
                            w.mOrientationChanging = false;
                        }
                    }
                    if (w.mAttachedHidden || !w.isReadyForDisplay()) {
                        if (!w.mLastHidden) {
                            w.mLastHidden = true;
                            if (w.mSurface != null) {
                                w.mSurfaceShown = false;
                                try {
                                    w.mSurface.hide();
                                }
                                catch (RuntimeException e) {
                                    Slog.w((String)TAG, (String)("Exception hiding surface in " + w));
                                }
                            }
                        }
                        if (w.mOrientationChanging) {
                            w.mOrientationChanging = false;
                        }
                    } else if (w.mLastLayer != w.mAnimLayer || w.mLastAlpha != w.mShownAlpha || w.mLastDsDx != w.mDsDx || w.mLastDtDx != w.mDtDx || w.mLastDsDy != w.mDsDy || w.mLastDtDy != w.mDtDy || w.mLastHScale != w.mHScale || w.mLastVScale != w.mVScale || w.mLastHidden) {
                        block203: {
                            displayed = true;
                            w.mLastAlpha = w.mShownAlpha;
                            w.mLastLayer = w.mAnimLayer;
                            w.mLastDsDx = w.mDsDx;
                            w.mLastDtDx = w.mDtDx;
                            w.mLastDsDy = w.mDsDy;
                            w.mLastDtDy = w.mDtDy;
                            w.mLastHScale = w.mHScale;
                            w.mLastVScale = w.mVScale;
                            if (w.mSurface != null) {
                                try {
                                    w.mSurfaceAlpha = w.mShownAlpha;
                                    w.mSurface.setAlpha(w.mShownAlpha);
                                    w.mSurfaceLayer = w.mAnimLayer;
                                    w.mSurface.setLayer(w.mAnimLayer);
                                    w.mSurface.setMatrix(w.mDsDx * w.mHScale, w.mDtDx * w.mVScale, w.mDsDy * w.mHScale, w.mDtDy * w.mVScale);
                                }
                                catch (RuntimeException e) {
                                    Slog.w((String)TAG, (String)("Error updating surface in " + w), (Throwable)e);
                                    if (recoveringMemory) break block203;
                                    this.reclaimSomeSurfaceMemoryLocked(w, "update", true);
                                }
                            }
                        }
                        if (w.mLastHidden && !w.mDrawPending && !w.mCommitDrawPending && !w.mReadyToShow) {
                            if (this.showSurfaceRobustlyLocked(w)) {
                                w.mHasDrawn = true;
                                w.mLastHidden = false;
                            } else {
                                w.mOrientationChanging = false;
                            }
                        }
                        if (w.mSurface != null) {
                            w.mToken.hasVisible = true;
                        }
                    } else {
                        displayed = true;
                    }
                    if (displayed) {
                        if (!covered && attrs.width == -1 && attrs.height == -1) {
                            covered = true;
                        }
                        if (w.mOrientationChanging) {
                            if (w.mDrawPending || w.mCommitDrawPending) {
                                orientationChangeComplete = false;
                            } else {
                                w.mOrientationChanging = false;
                            }
                        }
                        w.mToken.hasVisible = true;
                    }
                } else if (w.mOrientationChanging) {
                    w.mOrientationChanging = false;
                }
                if (w.mContentChanged) {
                    w.mContentChanged = false;
                }
                boolean canBeSeen = w.isDisplayedLw();
                if (someoneLosingFocus && w == this.mCurrentFocus && canBeSeen) {
                    focusDisplayed = true;
                }
                boolean obscuredChanged = w.mObscured != obscured;
                w.mObscured = obscured;
                if (!w.mObscured) {
                    boolean opaqueDrawn;
                    if (w.mSurface != null) {
                        if ((attrFlags & 0x80) != 0) {
                            holdScreen = w.mSession;
                        }
                        if (!syswin && w.mAttrs.screenBrightness >= 0.0f && screenBrightness < 0.0f) {
                            screenBrightness = w.mAttrs.screenBrightness;
                        }
                        if (!syswin && w.mAttrs.buttonBrightness >= 0.0f && buttonBrightness < 0.0f) {
                            buttonBrightness = w.mAttrs.buttonBrightness;
                        }
                        if (canBeSeen && (attrs.type == 2008 || attrs.type == 2004 || attrs.type == 2010)) {
                            syswin = true;
                        }
                    }
                    boolean bl = opaqueDrawn = canBeSeen && w.isOpaqueDrawn();
                    if (opaqueDrawn && w.isFullscreen(innerDw, innerDh)) {
                        obscured = true;
                    } else if (canBeSeen && !obscured && (attrFlags & 4 | 2) != 0) {
                        if ((attrFlags & 2) != 0 && !dimming) {
                            dimming = true;
                            if (this.mDimAnimator == null) {
                                this.mDimAnimator = new DimAnimator(this.mFxSession);
                            }
                            this.mDimAnimator.show(innerDw, innerDh);
                            this.mDimAnimator.updateParameters(this.mContext.getResources(), w, currentTime);
                        }
                        if ((attrFlags & 4) != 0 && !blurring) {
                            blurring = true;
                            if (this.mBlurSurface == null) {
                                try {
                                    this.mBlurSurface = new Surface(this.mFxSession, 0, "BlurSurface", -1, 16, 16, -1, 65536);
                                }
                                catch (Exception e) {
                                    Slog.e((String)TAG, (String)"Exception creating Blur surface", (Throwable)e);
                                }
                            }
                            if (this.mBlurSurface != null) {
                                this.mBlurSurface.setPosition(0, 0);
                                this.mBlurSurface.setSize(dw, dh);
                                this.mBlurSurface.setLayer(w.mAnimLayer - 2);
                                if (!this.mBlurShown) {
                                    try {
                                        this.mBlurSurface.show();
                                    }
                                    catch (RuntimeException e) {
                                        Slog.w((String)TAG, (String)"Failure showing blur surface", (Throwable)e);
                                    }
                                    this.mBlurShown = true;
                                }
                            }
                        }
                    }
                }
                if (!obscuredChanged || this.mWallpaperTarget != w) continue;
                this.updateWallpaperVisibilityLocked();
            }
            if (this.mDimAnimator != null && this.mDimAnimator.mDimShown) {
                animating |= this.mDimAnimator.updateSurface(dimming, currentTime, this.mDisplayFrozen || !this.mDisplayEnabled || !this.mPolicy.isScreenOnFully());
            }
            if (!blurring && this.mBlurShown) {
                try {
                    this.mBlurSurface.hide();
                }
                catch (IllegalArgumentException e) {
                    Slog.w((String)TAG, (String)"Illegal argument exception hiding blur surface");
                }
                this.mBlurShown = false;
            }
            if (this.mBlackFrame != null) {
                if (this.mScreenRotationAnimation != null) {
                    this.mBlackFrame.setMatrix(this.mScreenRotationAnimation.getEnterTransformation().getMatrix());
                } else {
                    this.mBlackFrame.clearMatrix();
                }
            }
        }
        catch (RuntimeException e) {
            Log.wtf((String)TAG, (String)"Unhandled exception in Window Manager", (Throwable)e);
        }
        Surface.closeTransaction();
        if (this.mWatermark != null) {
            this.mWatermark.drawIfNeeded();
        }
        if (orientationChangeComplete) {
            if (this.mWindowsFreezingScreen) {
                this.mWindowsFreezingScreen = false;
                this.mH.removeMessages(11);
            }
            this.stopFreezingDisplayLocked();
        }
        if ((i = this.mResizingWindows.size()) > 0) {
            do {
                WindowState win = this.mResizingWindows.get(--i);
                try {
                    int diff = 0;
                    boolean configChanged = win.mConfiguration != this.mCurConfiguration && (win.mConfiguration == null || (diff = this.mCurConfiguration.diff(win.mConfiguration)) != 0);
                    win.mConfiguration = this.mCurConfiguration;
                    win.mClient.resized((int)win.mSurfaceW, (int)win.mSurfaceH, win.mLastContentInsets, win.mLastVisibleInsets, win.mDrawPending, configChanged ? win.mConfiguration : null);
                    win.mContentInsetsChanged = false;
                    win.mVisibleInsetsChanged = false;
                    win.mSurfaceResized = false;
                }
                catch (RemoteException e) {
                    win.mOrientationChanging = false;
                }
            } while (i > 0);
            this.mResizingWindows.clear();
        }
        boolean wallpaperDestroyed = false;
        i = this.mDestroySurface.size();
        if (i > 0) {
            do {
                WindowState win = this.mDestroySurface.get(--i);
                win.mDestroying = false;
                if (this.mInputMethodWindow == win) {
                    this.mInputMethodWindow = null;
                }
                if (win == this.mWallpaperTarget) {
                    wallpaperDestroyed = true;
                }
                win.destroySurfaceLocked();
            } while (i > 0);
            this.mDestroySurface.clear();
        }
        for (i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            WindowToken token = this.mExitingTokens.get(i);
            if (token.hasVisible) continue;
            this.mExitingTokens.remove(i);
            if (token.windowType != 2013) continue;
            this.mWallpaperTokens.remove(token);
        }
        for (i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
            AppWindowToken token = this.mExitingAppTokens.get(i);
            if (token.hasVisible || this.mClosingApps.contains(token)) continue;
            token.animation = null;
            token.animating = false;
            this.mAppTokens.remove(token);
            this.mExitingAppTokens.remove(i);
        }
        boolean needRelayout = false;
        if (!animating && this.mAppTransitionRunning) {
            this.mAppTransitionRunning = false;
            needRelayout = true;
            this.rebuildAppWindowListLocked();
            this.assignLayersLocked();
            this.mToBottomApps.clear();
        }
        if (focusDisplayed) {
            this.mH.sendEmptyMessage(3);
        }
        if (wallpaperDestroyed) {
            boolean bl = needRelayout = this.adjustWallpaperWindowsLocked() != 0;
        }
        if (needRelayout) {
            this.requestAnimationLocked(0L);
        } else if (animating) {
            int refreshTimeUs = (int)(1000.0f / this.mDisplay.getRefreshRate());
            this.requestAnimationLocked(currentTime + (long)refreshTimeUs - SystemClock.uptimeMillis());
        }
        this.mInputMonitor.updateInputWindowsLw(true);
        this.setHoldScreenLocked(holdScreen != null);
        if (!this.mDisplayFrozen) {
            if (screenBrightness < 0.0f || screenBrightness > 1.0f) {
                this.mPowerManager.setScreenBrightnessOverride(-1);
            } else {
                this.mPowerManager.setScreenBrightnessOverride((int)(screenBrightness * 255.0f));
            }
            if (buttonBrightness < 0.0f || buttonBrightness > 1.0f) {
                this.mPowerManager.setButtonBrightnessOverride(-1);
            } else {
                this.mPowerManager.setButtonBrightnessOverride((int)(buttonBrightness * 255.0f));
            }
        }
        if (holdScreen != this.mHoldingScreenOn) {
            this.mHoldingScreenOn = holdScreen;
            Message m = this.mH.obtainMessage(12, (Object)holdScreen);
            this.mH.sendMessage(m);
        }
        if (this.mTurnOnScreen) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false, 1, true);
            this.mTurnOnScreen = false;
        }
        if (screenRotationFinished && this.mScreenRotationAnimation != null) {
            this.mScreenRotationAnimation.kill();
            this.mScreenRotationAnimation = null;
        }
        if (updateRotation) {
            boolean changed = this.updateRotationUncheckedLocked(false);
            if (changed) {
                this.mH.sendEmptyMessage(18);
            } else {
                updateRotation = false;
            }
        }
        if (orientationChangeComplete && !needRelayout && !updateRotation) {
            this.checkDrawnWindowsLocked();
        }
        this.enableScreenIfNeededLocked();
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.size() > 0) {
            for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
                Pair<WindowState, IRemoteCallback> pair = this.mWaitingForDrawn.get(j);
                WindowState win = (WindowState)pair.first;
                if (win.mRemoved || !win.isVisibleLw()) {
                    Slog.w((String)TAG, (String)("Aborted waiting for drawn: " + pair.first));
                    try {
                        ((IRemoteCallback)pair.second).sendResult(null);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    this.mWaitingForDrawn.remove(pair);
                    this.mH.removeMessages(24, pair);
                    continue;
                }
                if (!win.mSurfaceShown) continue;
                try {
                    ((IRemoteCallback)pair.second).sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.mWaitingForDrawn.remove(pair);
                this.mH.removeMessages(24, pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForWindowDrawn(IBinder token, IRemoteCallback callback) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(null, token, true);
            if (win != null) {
                Pair pair = new Pair((Object)win, (Object)callback);
                Message m = this.mH.obtainMessage(24, pair);
                this.mH.sendMessageDelayed(m, 2000L);
                this.mWaitingForDrawn.add((Pair<WindowState, IRemoteCallback>)pair);
                this.checkDrawnWindowsLocked();
            }
        }
    }

    void setHoldScreenLocked(boolean holding) {
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (holding != state) {
            if (holding) {
                this.mPolicy.screenOnStartedLw();
                this.mHoldingScreenWakeLock.acquire();
            } else {
                this.mPolicy.screenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    void requestAnimationLocked(long delay) {
        if (!this.mAnimationPending) {
            this.mAnimationPending = true;
            this.mH.sendMessageDelayed(this.mH.obtainMessage(4), delay);
        }
    }

    boolean showSurfaceRobustlyLocked(WindowState win) {
        try {
            if (win.mSurface != null) {
                win.mSurfaceShown = true;
                win.mSurface.show();
                if (win.mTurnOnScreen) {
                    win.mTurnOnScreen = false;
                    this.mTurnOnScreen = true;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            Slog.w((String)TAG, (String)("Failure showing surface " + win.mSurface + " in " + win), (Throwable)e);
            this.reclaimSomeSurfaceMemoryLocked(win, "show", true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemoryLocked(WindowState win, String operation, boolean secure) {
        Surface surface = win.mSurface;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent((int)31000, (Object[])new Object[]{win.toString(), win.mSession.mPid, operation});
        if (this.mForceRemoves == null) {
            this.mForceRemoves = new ArrayList();
        }
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            int N = this.mWindows.size();
            Slog.i((String)TAG, (String)"Out of memory for surface!  Looking for leaks...");
            for (int i = 0; i < N; ++i) {
                WindowState ws = this.mWindows.get(i);
                if (ws.mSurface == null) continue;
                if (!this.mSessions.contains((Object)ws.mSession)) {
                    Slog.w((String)TAG, (String)("LEAKED SURFACE (session doesn't exist): " + ws + " surface=" + ws.mSurface + " token=" + win.mToken + " pid=" + ws.mSession.mPid + " uid=" + ws.mSession.mUid));
                    ws.mSurface.destroy();
                    ws.mSurfaceShown = false;
                    ws.mSurface = null;
                    this.mForceRemoves.add(ws);
                    --i;
                    --N;
                    leakedSurface = true;
                    continue;
                }
                if (ws.mAppToken == null || !ws.mAppToken.clientHidden) continue;
                Slog.w((String)TAG, (String)("LEAKED SURFACE (app token hidden): " + ws + " surface=" + ws.mSurface + " token=" + win.mAppToken));
                ws.mSurface.destroy();
                ws.mSurfaceShown = false;
                ws.mSurface = null;
                leakedSurface = true;
            }
            if (!leakedSurface) {
                Slog.w((String)TAG, (String)"No leaked surfaces; killing applicatons!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int i = 0; i < N; ++i) {
                    WindowState ws = this.mWindows.get(i);
                    if (ws.mSurface == null) continue;
                    pidCandidates.append(ws.mSession.mPid, ws.mSession.mPid);
                }
                if (pidCandidates.size() > 0) {
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (this.mActivityManager.killPids(pids, "Free memory", secure)) {
                            killedApps = true;
                        }
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w((String)TAG, (String)"Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surface != null) {
                    surface.destroy();
                    win.mSurfaceShown = false;
                    win.mSurface = null;
                }
                try {
                    win.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    private boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.computeFocusedWindowLocked();
        if (this.mCurrentFocus != newFocus) {
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            int focusChanged = this.mPolicy.focusChangedLw((WindowManagerPolicy.WindowState)oldFocus, (WindowManagerPolicy.WindowState)newFocus);
            WindowState imWindow = this.mInputMethodWindow;
            if (newFocus != imWindow && oldFocus != imWindow) {
                if (this.moveInputMethodWindowsIfNeededLocked(mode != 1 && mode != 3)) {
                    this.mLayoutNeeded = true;
                }
                if (mode == 2) {
                    this.performLayoutLockedInner(true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    this.assignLayersLocked();
                }
            }
            if ((focusChanged & 1) != 0) {
                this.mLayoutNeeded = true;
                if (mode == 2) {
                    this.performLayoutLockedInner(true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.finishUpdateFocusedWindowAfterAssignLayersLocked(updateInputWindows);
            }
            return true;
        }
        return false;
    }

    private void finishUpdateFocusedWindowAfterAssignLayersLocked(boolean updateInputWindows) {
        this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
    }

    private WindowState computeFocusedWindowLocked() {
        WindowToken nextApp;
        WindowState result = null;
        int i = this.mWindows.size() - 1;
        int nextAppIndex = this.mAppTokens.size() - 1;
        AppWindowToken appWindowToken = nextApp = nextAppIndex >= 0 ? this.mAppTokens.get(nextAppIndex) : null;
        while (i >= 0) {
            WindowState win = this.mWindows.get(i);
            AppWindowToken thisApp = win.mAppToken;
            if (thisApp != null && thisApp.removed) {
                --i;
                continue;
            }
            if (thisApp != null && nextApp != null && thisApp != nextApp && win.mAttrs.type != 3) {
                int origAppIndex = nextAppIndex;
                while (nextAppIndex > 0) {
                    if (nextApp == this.mFocusedApp) {
                        return null;
                    }
                    if ((nextApp = (WindowToken)this.mAppTokens.get(--nextAppIndex)) != thisApp) continue;
                }
                if (thisApp != nextApp) {
                    nextAppIndex = origAppIndex;
                    nextApp = this.mAppTokens.get(nextAppIndex);
                }
            }
            if (win.canReceiveKeys()) {
                result = win;
                break;
            }
            --i;
        }
        return result;
    }

    private void startFreezingDisplayLocked(boolean inTransaction) {
        if (this.mDisplayFrozen) {
            return;
        }
        if (this.mDisplay == null || !this.mPolicy.isScreenOnFully()) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mInputMonitor.freezeInputDispatchingLw();
        if (this.mNextAppTransition != -1) {
            this.mNextAppTransition = -1;
            this.mNextAppTransitionPackage = null;
            this.mAppTransitionReady = true;
        }
        if (this.mScreenRotationAnimation != null && this.mScreenRotationAnimation.isAnimating()) {
            this.mScreenRotationAnimation.kill();
            this.mScreenRotationAnimation = null;
        }
        if (this.mScreenRotationAnimation == null) {
            this.mScreenRotationAnimation = new ScreenRotationAnimation(this.mContext, this.mFxSession, inTransaction, this.mCurDisplayWidth, this.mCurDisplayHeight, this.mDisplay.getRotation());
        }
        if (!this.mScreenRotationAnimation.hasScreenshot()) {
            Surface.freezeDisplay((int)0);
        }
    }

    private void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen) {
            return;
        }
        this.mDisplayFrozen = false;
        this.mH.removeMessages(17);
        boolean updateRotation = false;
        if (this.mScreenRotationAnimation != null && this.mScreenRotationAnimation.hasScreenshot()) {
            if (this.mScreenRotationAnimation.dismiss(this.mFxSession, 10000L, this.mTransitionAnimationScale, this.mCurDisplayWidth, this.mCurDisplayHeight)) {
                this.requestAnimationLocked(0L);
            } else {
                this.mScreenRotationAnimation = null;
                updateRotation = true;
            }
        } else {
            if (this.mScreenRotationAnimation != null) {
                this.mScreenRotationAnimation.kill();
                this.mScreenRotationAnimation = null;
            }
            updateRotation = true;
        }
        Surface.unfreezeDisplay((int)0);
        this.mInputMonitor.thawInputDispatchingLw();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mH.removeMessages(15);
        this.mH.sendMessageDelayed(this.mH.obtainMessage(15), 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= this.updateRotationUncheckedLocked(false);
        }
        if (configChanged) {
            this.mH.sendEmptyMessage(18);
        }
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension((int)defUnits, (float)defDps, (DisplayMetrics)dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermark() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            DataInputStream ind = new DataInputStream(in);
            String line = ind.readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                this.mWatermark = new Watermark(this.mRealDisplayMetrics, this.mFxSession, toks);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mLastStatusBarVisibility = visibility;
            visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
            this.updateStatusBarVisibilityLocked(visibility);
        }
    }

    void updateStatusBarVisibilityLocked(int visibility) {
        this.mInputManager.setSystemUiVisibility(visibility);
        int N = this.mWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = this.mWindows.get(i);
            try {
                int curValue = ws.mSystemUiVisibility;
                int diff = curValue ^ visibility;
                diff &= 3;
                int newValue = curValue & ~(diff &= ~visibility) | visibility & diff;
                if (newValue != curValue) {
                    ++ws.mSeq;
                    ws.mSystemUiVisibility = newValue;
                }
                if (newValue == curValue && !ws.mAttrs.hasSystemUiListeners) continue;
                ws.mClient.dispatchSystemUiVisibilityChanged(ws.mSeq, visibility, newValue, diff);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reevaluateStatusBarVisibility() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
            this.updateStatusBarVisibilityLocked(visibility);
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerPolicy.FakeWindow addFakeWindow(Looper looper, InputHandler inputHandler, String name, int windowType, int layoutParamsFlags, boolean canReceiveKeys, boolean hasFocus, boolean touchFullscreen) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            FakeWindowImpl fw = new FakeWindowImpl(this, looper, inputHandler, name, windowType, layoutParamsFlags, canReceiveKeys, hasFocus, touchFullscreen);
            int i = 0;
            while (i < this.mFakeWindows.size() && this.mFakeWindows.get((int)i).mWindowLayer > fw.mWindowLayer) {
            }
            this.mFakeWindows.add(i, fw);
            this.mInputMonitor.updateInputWindowsLw(true);
            return fw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFakeWindowLocked(WindowManagerPolicy.FakeWindow window) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mFakeWindows.remove(window)) {
                this.mInputMonitor.updateInputWindowsLw(true);
                return true;
            }
            return false;
        }
    }

    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    void dumpInput(FileDescriptor fd, PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER INPUT (dumpsys window input)");
        this.mInputManager.dump(pw);
    }

    void dumpPolicyLocked(FileDescriptor fd, PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", fd, pw, args);
    }

    void dumpTokensLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll) {
        WindowToken token2;
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        if (this.mTokenMap.size() > 0) {
            pw.println("  All tokens:");
            for (WindowToken token2 : this.mTokenMap.values()) {
                pw.print("  Token ");
                pw.print(token2.token);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWallpaperTokens.size() > 0) {
            pw.println();
            pw.println("  Wallpaper tokens:");
            for (int i = this.mWallpaperTokens.size() - 1; i >= 0; --i) {
                token2 = this.mWallpaperTokens.get(i);
                pw.print("  Wallpaper #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mAppTokens.size() > 0) {
            pw.println();
            pw.println("  Application tokens in Z order:");
            for (int i = this.mAppTokens.size() - 1; i >= 0; --i) {
                pw.print("  App #");
                pw.print(i);
                pw.print(": ");
                pw.println(this.mAppTokens.get(i));
            }
        }
        if (this.mFinishedStarting.size() > 0) {
            pw.println();
            pw.println("  Finishing start of application tokens:");
            for (int i = this.mFinishedStarting.size() - 1; i >= 0; --i) {
                token2 = this.mFinishedStarting.get(i);
                pw.print("  Finished Starting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mExitingTokens.size() > 0) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                token2 = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mExitingAppTokens.size() > 0) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                token2 = this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        pw.println();
        if (this.mOpeningApps.size() > 0) {
            pw.print("  mOpeningApps=");
            pw.println(this.mOpeningApps);
        }
        if (this.mClosingApps.size() > 0) {
            pw.print("  mClosingApps=");
            pw.println(this.mClosingApps);
        }
        if (this.mToTopApps.size() > 0) {
            pw.print("  mToTopApps=");
            pw.println(this.mToTopApps);
        }
        if (this.mToBottomApps.size() > 0) {
            pw.print("  mToBottomApps=");
            pw.println(this.mToBottomApps);
        }
    }

    void dumpSessionsLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        if (this.mSessions.size() > 0) {
            for (Session s : this.mSessions) {
                pw.print("  Session ");
                pw.print((Object)s);
                pw.println(':');
                s.dump(pw, "    ");
            }
        }
    }

    void dumpWindowsLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        for (i = this.mWindows.size() - 1; i >= 0; --i) {
            w = this.mWindows.get(i);
            if (windows != null && !windows.contains(w)) continue;
            pw.print("  Window #");
            pw.print(i);
            pw.print(' ');
            pw.print(w);
            pw.println(":");
            w.dump(pw, "    ", dumpAll || windows != null);
        }
        if (this.mInputMethodDialogs.size() > 0) {
            pw.println();
            pw.println("  Input method dialogs:");
            for (i = this.mInputMethodDialogs.size() - 1; i >= 0; --i) {
                w = this.mInputMethodDialogs.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  IM Dialog #");
                pw.print(i);
                pw.print(": ");
                pw.println(w);
            }
        }
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                Pair<WindowState, IRemoteCallback> pair = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(pair.first);
                pw.print(": ");
                pw.println(pair.second);
            }
        }
        pw.println();
        if (this.mDisplay != null) {
            pw.print("  Display: init=");
            pw.print(this.mInitialDisplayWidth);
            pw.print("x");
            pw.print(this.mInitialDisplayHeight);
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" cur=");
            pw.print(this.mCurDisplayWidth);
            pw.print("x");
            pw.print(this.mCurDisplayHeight);
            pw.print(" app=");
            pw.print(this.mAppDisplayWidth);
            pw.print("x");
            pw.print(this.mAppDisplayHeight);
            pw.print(" raw=");
            pw.print(this.mDisplay.getRawWidth());
            pw.print("x");
            pw.println(this.mDisplay.getRawHeight());
        } else {
            pw.println("  NO DISPLAY");
        }
        pw.print("  mCurConfiguration=");
        pw.println(this.mCurConfiguration);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.print(this.mInTouchMode);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        if (dumpAll) {
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            pw.print("  mWallpaperTarget=");
            pw.println(this.mWallpaperTarget);
            if (this.mLowerWallpaperTarget != null && this.mUpperWallpaperTarget != null) {
                pw.print("  mLowerWallpaperTarget=");
                pw.println(this.mLowerWallpaperTarget);
                pw.print("  mUpperWallpaperTarget=");
                pw.println(this.mUpperWallpaperTarget);
            }
            if (this.mWindowDetachedWallpaper != null) {
                pw.print("  mWindowDetachedWallpaper=");
                pw.println(this.mWindowDetachedWallpaper);
            }
            pw.print("  mLastWallpaperX=");
            pw.print(this.mLastWallpaperX);
            pw.print(" mLastWallpaperY=");
            pw.println(this.mLastWallpaperY);
            if (this.mInputMethodAnimLayerAdjustment != 0 || this.mWallpaperAnimLayerAdjustment != 0) {
                pw.print("  mInputMethodAnimLayerAdjustment=");
                pw.print(this.mInputMethodAnimLayerAdjustment);
                pw.print("  mWallpaperAnimLayerAdjustment=");
                pw.println(this.mWallpaperAnimLayerAdjustment);
            }
            if (this.mWindowAnimationBackgroundSurface != null) {
                pw.println("  mWindowAnimationBackgroundSurface:");
                this.mWindowAnimationBackgroundSurface.printTo("    ", pw);
            }
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            pw.print("  mLayoutNeeded=");
            pw.print(this.mLayoutNeeded);
            pw.print(" mBlurShown=");
            pw.println(this.mBlurShown);
            if (this.mDimAnimator != null) {
                pw.println("  mDimAnimator:");
                this.mDimAnimator.printTo("    ", pw);
            } else {
                pw.println("  no DimAnimator ");
            }
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" mWindowsFreezingScreen=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" mAppsFreezingScreen=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" mWaitingForConfig=");
            pw.println(this.mWaitingForConfig);
            pw.print("  mRotation=");
            pw.print(this.mRotation);
            pw.print(" mAltOrientation=");
            pw.println(this.mAltOrientation);
            pw.print("  mLastWindowForcedOrientation");
            pw.print(this.mLastWindowForcedOrientation);
            pw.print(" mForcedAppOrientation=");
            pw.println(this.mForcedAppOrientation);
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  mAnimationPending=");
            pw.print(this.mAnimationPending);
            pw.print(" mWindowAnimationScale=");
            pw.print(this.mWindowAnimationScale);
            pw.print(" mTransitionWindowAnimationScale=");
            pw.println(this.mTransitionAnimationScale);
            pw.print("  mNextAppTransition=0x");
            pw.print(Integer.toHexString(this.mNextAppTransition));
            pw.print(" mAppTransitionReady=");
            pw.println(this.mAppTransitionReady);
            pw.print("  mAppTransitionRunning=");
            pw.print(this.mAppTransitionRunning);
            pw.print(" mAppTransitionTimeout=");
            pw.println(this.mAppTransitionTimeout);
            if (this.mNextAppTransitionPackage != null) {
                pw.print("  mNextAppTransitionPackage=");
                pw.print(this.mNextAppTransitionPackage);
                pw.print(" mNextAppTransitionEnter=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionEnter));
                pw.print(" mNextAppTransitionExit=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionExit));
            }
            pw.print("  mStartingIconInTransition=");
            pw.print(this.mStartingIconInTransition);
            pw.print(", mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpWindows(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        HashMap<IBinder, WindowState> hashMap;
        ArrayList<WindowState> windows = new ArrayList<WindowState>();
        if ("visible".equals(name)) {
            hashMap = this.mWindowMap;
            synchronized (hashMap) {
                for (int i = this.mWindows.size() - 1; i >= 0; --i) {
                    WindowState w = this.mWindows.get(i);
                    if (!w.mSurfaceShown) continue;
                    windows.add(w);
                }
            }
        }
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            for (int i = this.mWindows.size() - 1; i >= 0; --i) {
                WindowState w = this.mWindows.get(i);
                if (name != null) {
                    if (!((Object)w.mAttrs.getTitle()).toString().contains(name)) continue;
                    windows.add(w);
                    continue;
                }
                if (System.identityHashCode(w) != objectId) continue;
                windows.add(w);
            }
        }
        if (windows.size() <= 0) {
            return false;
        }
        hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.dumpWindowsLocked(fd, pw, dumpAll, windows);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WindowManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        boolean dumpAll = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Window manager dump options:");
                pw.println("  [-a] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    i[input]: input subsystem state");
                pw.println("    p[policy]: policy state");
                pw.println("    s[essions]: active sessions");
                pw.println("    t[okens]: token list");
                pw.println("    w[indows]: window list");
                pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                pw.println("    be a partial substring in a window name, a");
                pw.println("    Window hex object identifier, or");
                pw.println("    \"all\" for all windows, or");
                pw.println("    \"visible\" for the visible windows.");
                pw.println("  -a: include all available server state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("input".equals(cmd) || "i".equals(cmd)) {
                this.dumpInput(fd, pw, true);
                return;
            }
            if ("policy".equals(cmd) || "p".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpPolicyLocked(fd, pw, args, true);
                }
                return;
            }
            if ("sessions".equals(cmd) || "s".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpSessionsLocked(fd, pw, true);
                }
                return;
            }
            if ("tokens".equals(cmd) || "t".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpTokensLocked(fd, pw, true);
                }
                return;
            }
            if ("windows".equals(cmd) || "w".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(fd, pw, true, null);
                }
                return;
            }
            if ("all".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(fd, pw, true, null);
                }
                return;
            }
            if (!this.dumpWindows(fd, pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        this.dumpInput(fd, pw, dumpAll);
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPolicyLocked(fd, pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpSessionsLocked(fd, pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpTokensLocked(fd, pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpWindowsLocked(fd, pw, dumpAll, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        TokenWatcher tokenWatcher = this.mWindowMap;
        synchronized (tokenWatcher) {
        }
        tokenWatcher = this.mKeyguardTokenWatcher;
        synchronized (tokenWatcher) {
        }
    }

    public static interface OnHardKeyboardStatusChangeListener {
        public void onHardKeyboardStatusChange(boolean var1, boolean var2);
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int ANIMATE = 4;
        public static final int ADD_STARTING = 5;
        public static final int REMOVE_STARTING = 6;
        public static final int FINISHED_STARTING = 7;
        public static final int REPORT_APPLICATION_TOKEN_WINDOWS = 8;
        public static final int REPORT_APPLICATION_TOKEN_DRAWN = 9;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int HOLD_SCREEN_CHANGED = 12;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int DRAG_START_TIMEOUT = 20;
        public static final int DRAG_END_TIMEOUT = 21;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        private Session mLastReportedHold;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            block41 : switch (msg.what) {
                case 2: {
                    WindowState newFocus;
                    WindowState lastFocus;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        lastFocus = WindowManagerService.this.mLastFocus;
                        newFocus = WindowManagerService.this.mCurrentFocus;
                        if (lastFocus == newFocus) {
                            return;
                        }
                        WindowManagerService.this.mLastFocus = newFocus;
                        if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                            WindowManagerService.this.mLosingFocus.add(lastFocus);
                            lastFocus = null;
                        }
                    }
                    if (lastFocus == newFocus) break;
                    if (newFocus != null) {
                        try {
                            newFocus.mClient.windowFocusChanged(true, WindowManagerService.this.mInTouchMode);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        WindowManagerService.this.notifyFocusChanged();
                    }
                    if (lastFocus == null) break;
                    try {
                        lastFocus.mClient.windowFocusChanged(false, WindowManagerService.this.mInTouchMode);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 3: {
                    ArrayList<WindowState> losers;
                    HashMap<IBinder, WindowState> newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        losers = WindowManagerService.this.mLosingFocus;
                        WindowManagerService.this.mLosingFocus = new ArrayList();
                    }
                    int N = losers.size();
                    for (int i = 0; i < N; ++i) {
                        try {
                            losers.get((int)i).mClient.windowFocusChanged(false, WindowManagerService.this.mInTouchMode);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 4: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.mAnimationPending = false;
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 5: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    StartingData sd = wtoken.startingData;
                    if (sd == null) {
                        return;
                    }
                    View view = null;
                    try {
                        view = WindowManagerService.this.mPolicy.addStartingWindow(wtoken.token, sd.pkg, sd.theme, sd.compatInfo, sd.nonLocalizedLabel, sd.labelRes, sd.icon, sd.windowFlags);
                    }
                    catch (Exception e) {
                        Slog.w((String)WindowManagerService.TAG, (String)"Exception when adding starting window", (Throwable)e);
                    }
                    if (view == null) break;
                    boolean abort = false;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (wtoken.removed || wtoken.startingData == null) {
                            if (wtoken.startingWindow != null) {
                                wtoken.startingWindow = null;
                                wtoken.startingData = null;
                                abort = true;
                            }
                        } else {
                            wtoken.startingView = view;
                        }
                    }
                    if (!abort) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(wtoken.token, view);
                    }
                    catch (Exception e) {
                        Slog.w((String)WindowManagerService.TAG, (String)"Exception when removing starting window", (Throwable)e);
                    }
                    break;
                }
                case 6: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    IBinder token = null;
                    View view2 = null;
                    HashMap<IBinder, WindowState> abort = WindowManagerService.this.mWindowMap;
                    synchronized (abort) {
                        if (wtoken.startingWindow != null) {
                            view2 = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                        }
                    }
                    if (view2 == null) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(token, view2);
                    }
                    catch (Exception e) {
                        Slog.w((String)WindowManagerService.TAG, (String)"Exception when removing starting window", (Throwable)e);
                    }
                    break;
                }
                case 7: {
                    IBinder token = null;
                    View view = null;
                    while (true) {
                        HashMap<IBinder, WindowState> view2 = WindowManagerService.this.mWindowMap;
                        synchronized (view2) {
                            int N = WindowManagerService.this.mFinishedStarting.size();
                            if (N <= 0) {
                                break block41;
                            }
                            AppWindowToken wtoken = WindowManagerService.this.mFinishedStarting.remove(N - 1);
                            if (wtoken.startingWindow == null) {
                                continue;
                            }
                            view = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                        }
                        try {
                            WindowManagerService.this.mPolicy.removeStartingWindow(token, view);
                        }
                        catch (Exception e) {
                            Slog.w((String)WindowManagerService.TAG, (String)"Exception when removing starting window", (Throwable)e);
                        }
                    }
                }
                case 9: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    try {
                        wtoken.appToken.windowsDrawn();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 8: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    boolean nowVisible = msg.arg1 != 0;
                    boolean nowGone = msg.arg2 != 0;
                    try {
                        if (nowVisible) {
                            wtoken.appToken.windowsVisible();
                            break;
                        }
                        wtoken.appToken.windowsGone();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 11: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w((String)WindowManagerService.TAG, (String)"Window freeze timeout expired.");
                        int i = WindowManagerService.this.mWindows.size();
                        while (i > 0) {
                            WindowState w = WindowManagerService.this.mWindows.get(--i);
                            if (!w.mOrientationChanging) continue;
                            w.mOrientationChanging = false;
                            Slog.w((String)WindowManagerService.TAG, (String)("Force clearing orientation change: " + w));
                        }
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 12: {
                    Session newHold;
                    Session oldHold;
                    HashMap<IBinder, WindowState> w = WindowManagerService.this.mWindowMap;
                    synchronized (w) {
                        oldHold = this.mLastReportedHold;
                        this.mLastReportedHold = newHold = (Session)((Object)msg.obj);
                    }
                    if (oldHold == newHold) break;
                    try {
                        if (oldHold != null) {
                            WindowManagerService.this.mBatteryStats.noteStopWakelock(oldHold.mUid, -1, "window", 2);
                        }
                        if (newHold == null) break;
                        WindowManagerService.this.mBatteryStats.noteStartWakelock(newHold.mUid, -1, "window", 2);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 13: {
                    HashMap<IBinder, WindowState> oldHold = WindowManagerService.this.mWindowMap;
                    synchronized (oldHold) {
                        if (WindowManagerService.this.mNextAppTransition != -1) {
                            WindowManagerService.this.mAppTransitionReady = true;
                            WindowManagerService.this.mAppTransitionTimeout = true;
                            WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        }
                        break;
                    }
                }
                case 14: {
                    Settings.System.putFloat((ContentResolver)WindowManagerService.this.mContext.getContentResolver(), (String)"window_animation_scale", (float)WindowManagerService.this.mWindowAnimationScale);
                    Settings.System.putFloat((ContentResolver)WindowManagerService.this.mContext.getContentResolver(), (String)"transition_animation_scale", (float)WindowManagerService.this.mTransitionAnimationScale);
                    break;
                }
                case 15: {
                    HashMap<IBinder, WindowState> oldHold = WindowManagerService.this.mWindowMap;
                    synchronized (oldHold) {
                        if (WindowManagerService.this.mAnimationPending) {
                            WindowManagerService.this.mH.sendMessageDelayed(WindowManagerService.this.mH.obtainMessage(15), 2000L);
                            return;
                        }
                        if (WindowManagerService.this.mDisplayFrozen) {
                            return;
                        }
                    }
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 17: {
                    HashMap<IBinder, WindowState> oldHold = WindowManagerService.this.mWindowMap;
                    synchronized (oldHold) {
                        Slog.w((String)WindowManagerService.TAG, (String)"App freeze timeout expired.");
                        int i = WindowManagerService.this.mAppTokens.size();
                        while (i > 0) {
                            AppWindowToken tok = WindowManagerService.this.mAppTokens.get(--i);
                            if (!tok.freezingScreen) continue;
                            Slog.w((String)WindowManagerService.TAG, (String)("Force clearing freeze: " + tok));
                            WindowManagerService.this.unsetAppFreezingScreenLocked(tok, true, true);
                        }
                        break;
                    }
                }
                case 18: {
                    this.removeMessages(18);
                    WindowManagerService.this.sendNewConfiguration();
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    HashMap<IBinder, WindowState> oldHold = WindowManagerService.this.mWindowMap;
                    synchronized (oldHold) {
                        WindowManagerService.this.mWindowsChanged = false;
                    }
                    WindowManagerService.this.notifyWindowsChanged();
                    break;
                }
                case 20: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.unregister();
                            WindowManagerService.this.mInputMonitor.updateInputWindowsLw(true);
                            WindowManagerService.this.mDragState.reset();
                            WindowManagerService.this.mDragState = null;
                        }
                        break;
                    }
                }
                case 21: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.mDragResult = false;
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        break;
                    }
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    Pair pair;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        pair = (Pair)msg.obj;
                        Slog.w((String)WindowManagerService.TAG, (String)("Timeout waiting for drawn: " + pair.first));
                        if (!WindowManagerService.this.mWaitingForDrawn.remove(pair)) {
                            return;
                        }
                    }
                    try {
                        ((IRemoteCallback)pair.second).sendResult(null);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
            }
        }
    }

    static final class DummyAnimation
    extends Animation {
        DummyAnimation() {
        }

        public boolean getTransformation(long currentTime, Transformation outTransformation) {
            return false;
        }
    }

    static class PolicyThread
    extends Thread {
        private final WindowManagerPolicy mPolicy;
        private final WindowManagerService mService;
        private final Context mContext;
        private final PowerManagerService mPM;
        boolean mRunning = false;

        public PolicyThread(WindowManagerPolicy policy, WindowManagerService service, Context context, PowerManagerService pm) {
            super("WindowManagerPolicy");
            this.mPolicy = policy;
            this.mService = service;
            this.mContext = context;
            this.mPM = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            WindowManagerPolicyThread.set((Thread)this, (Looper)Looper.myLooper());
            Process.setThreadPriority((int)-2);
            Process.setCanSelfBackground((boolean)false);
            this.mPolicy.init(this.mContext, (IWindowManager)this.mService, (WindowManagerPolicy.WindowManagerFuncs)this.mService, (LocalPowerManager)this.mPM);
            PolicyThread policyThread = this;
            synchronized (policyThread) {
                this.mRunning = true;
                this.notifyAll();
            }
            if (StrictMode.conditionallyEnableDebugLogging()) {
                Slog.i((String)WindowManagerService.TAG, (String)"Enabled StrictMode for PolicyThread's Looper");
            }
            Looper.loop();
        }
    }

    static class WMThread
    extends Thread {
        WindowManagerService mService;
        private final Context mContext;
        private final PowerManagerService mPM;
        private final boolean mHaveInputMethods;
        private final boolean mAllowBootMessages;

        public WMThread(Context context, PowerManagerService pm, boolean haveInputMethods, boolean allowBootMsgs) {
            super(WindowManagerService.TAG);
            this.mContext = context;
            this.mPM = pm;
            this.mHaveInputMethods = haveInputMethods;
            this.mAllowBootMessages = allowBootMsgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            WindowManagerService s = new WindowManagerService(this.mContext, this.mPM, this.mHaveInputMethods, this.mAllowBootMessages);
            Process.setThreadPriority((int)-4);
            Process.setCanSelfBackground((boolean)false);
            WMThread wMThread = this;
            synchronized (wMThread) {
                this.mService = s;
                this.notifyAll();
            }
            if (StrictMode.conditionallyEnableDebugLogging()) {
                Slog.i((String)WindowManagerService.TAG, (String)"Enabled StrictMode logging for WMThread's Looper");
            }
            Looper.loop();
        }
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }
}

