/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.Gravity;
import android.view.IApplicationToken;
import android.view.IWindow;
import android.view.InputChannel;
import android.view.Surface;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.InputWindowHandle;
import com.android.server.wm.Session;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

final class WindowState
implements WindowManagerPolicy.WindowState {
    static final boolean DEBUG_VISIBILITY = false;
    static final boolean SHOW_TRANSACTIONS = false;
    static final boolean SHOW_LIGHT_TRANSACTIONS = false;
    static final boolean SHOW_SURFACE_ALLOC = false;
    final WindowManagerService mService;
    final Session mSession;
    final IWindow mClient;
    WindowToken mToken;
    WindowToken mRootToken;
    AppWindowToken mAppToken;
    AppWindowToken mTargetAppToken;
    final WindowManager.LayoutParams mAttrs = new WindowManager.LayoutParams();
    final DeathRecipient mDeathRecipient;
    final WindowState mAttachedWindow;
    final ArrayList<WindowState> mChildWindows = new ArrayList();
    final int mBaseLayer;
    final int mSubLayer;
    final boolean mLayoutAttached;
    final boolean mIsImWindow;
    final boolean mIsWallpaper;
    final boolean mIsFloatingLayer;
    int mSeq;
    boolean mEnforceSizeCompat;
    int mViewVisibility;
    int mSystemUiVisibility;
    boolean mPolicyVisibility = true;
    boolean mPolicyVisibilityAfterAnim = true;
    boolean mAppFreezing;
    Surface mSurface;
    Surface mPendingDestroySurface;
    boolean mReportDestroySurface;
    boolean mSurfacePendingDestroy;
    boolean mAttachedHidden;
    boolean mLastHidden;
    boolean mWallpaperVisible;
    int mRequestedWidth;
    int mRequestedHeight;
    int mLayer;
    int mAnimLayer;
    int mLastLayer;
    boolean mHaveFrame;
    boolean mObscured;
    boolean mTurnOnScreen;
    int mLayoutSeq = -1;
    Configuration mConfiguration = null;
    final RectF mShownFrame = new RectF();
    boolean mSurfaceResized;
    boolean mSurfaceDestroyDeferred;
    final Rect mVisibleInsets = new Rect();
    final Rect mLastVisibleInsets = new Rect();
    boolean mVisibleInsetsChanged;
    final Rect mContentInsets = new Rect();
    final Rect mLastContentInsets = new Rect();
    boolean mContentInsetsChanged;
    boolean mGivenInsetsPending;
    final Rect mGivenContentInsets = new Rect();
    final Rect mGivenVisibleInsets = new Rect();
    final Region mGivenTouchableRegion = new Region();
    int mTouchableInsets = 0;
    boolean mHaveMatrix;
    float mGlobalScale = 1.0f;
    float mInvGlobalScale = 1.0f;
    float mDsDx = 1.0f;
    float mDtDx = 0.0f;
    float mDsDy = 0.0f;
    float mDtDy = 1.0f;
    float mLastDsDx = 1.0f;
    float mLastDtDx = 0.0f;
    float mLastDsDy = 0.0f;
    float mLastDtDy = 1.0f;
    float mHScale = 1.0f;
    float mVScale = 1.0f;
    float mLastHScale = 1.0f;
    float mLastVScale = 1.0f;
    final Matrix mTmpMatrix = new Matrix();
    final Rect mFrame = new Rect();
    final Rect mLastFrame = new Rect();
    final Rect mCompatFrame = new Rect();
    final Rect mContainingFrame = new Rect();
    final Rect mDisplayFrame = new Rect();
    final Rect mContentFrame = new Rect();
    final Rect mParentFrame = new Rect();
    final Rect mVisibleFrame = new Rect();
    boolean mContentChanged;
    float mShownAlpha = 1.0f;
    float mAlpha = 1.0f;
    float mLastAlpha = 1.0f;
    boolean mEnterAnimationPending;
    boolean mAnimating;
    boolean mLocalAnimating;
    Animation mAnimation;
    boolean mAnimationIsEntrance;
    boolean mHasTransformation;
    boolean mHasLocalTransformation;
    final Transformation mTransformation = new Transformation();
    float mWallpaperX = -1.0f;
    float mWallpaperY = -1.0f;
    float mWallpaperXStep = -1.0f;
    float mWallpaperYStep = -1.0f;
    int mXOffset;
    int mYOffset;
    boolean mRelayoutCalled;
    boolean mDrawPending;
    boolean mCommitDrawPending;
    boolean mReadyToShow;
    boolean mHasDrawn;
    boolean mExiting;
    boolean mDestroying;
    boolean mRemoveOnExit;
    boolean mOrientationChanging;
    boolean mRemoved;
    boolean mRebuilding;
    boolean mSurfaceShown;
    float mSurfaceX;
    float mSurfaceY;
    float mSurfaceW;
    float mSurfaceH;
    int mSurfaceLayer;
    float mSurfaceAlpha;
    final InputWindowHandle mInputWindowHandle;
    InputChannel mInputChannel;
    String mStringNameCache;
    CharSequence mLastTitle;
    boolean mWasPaused;

    WindowState(WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState attachedWindow, int seq, WindowManager.LayoutParams a, int viewVisibility) {
        WindowToken parent;
        this.mService = service;
        this.mSession = s;
        this.mClient = c;
        this.mToken = token;
        this.mAttrs.copyFrom(a);
        this.mViewVisibility = viewVisibility;
        DeathRecipient deathRecipient = new DeathRecipient();
        this.mAlpha = a.alpha;
        this.mSeq = seq;
        this.mEnforceSizeCompat = (this.mAttrs.flags & 0x20000000) != 0;
        try {
            c.asBinder().linkToDeath((IBinder.DeathRecipient)deathRecipient, 0);
        }
        catch (RemoteException e) {
            this.mDeathRecipient = null;
            this.mAttachedWindow = null;
            this.mLayoutAttached = false;
            this.mIsImWindow = false;
            this.mIsWallpaper = false;
            this.mIsFloatingLayer = false;
            this.mBaseLayer = 0;
            this.mSubLayer = 0;
            this.mInputWindowHandle = null;
            return;
        }
        this.mDeathRecipient = deathRecipient;
        if (this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999) {
            this.mBaseLayer = this.mService.mPolicy.windowTypeToLayerLw(attachedWindow.mAttrs.type) * 10000 + 1000;
            this.mSubLayer = this.mService.mPolicy.subWindowTypeToLayerLw(a.type);
            this.mAttachedWindow = attachedWindow;
            this.mAttachedWindow.mChildWindows.add(this);
            this.mLayoutAttached = this.mAttrs.type != 1003;
            this.mIsImWindow = attachedWindow.mAttrs.type == 2011 || attachedWindow.mAttrs.type == 2012;
            this.mIsWallpaper = attachedWindow.mAttrs.type == 2013;
            this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        } else {
            this.mBaseLayer = this.mService.mPolicy.windowTypeToLayerLw(a.type) * 10000 + 1000;
            this.mSubLayer = 0;
            this.mAttachedWindow = null;
            this.mLayoutAttached = false;
            this.mIsImWindow = this.mAttrs.type == 2011 || this.mAttrs.type == 2012;
            this.mIsWallpaper = this.mAttrs.type == 2013;
            this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        }
        WindowState appWin = this;
        while (appWin.mAttachedWindow != null) {
            appWin = this.mAttachedWindow;
        }
        WindowToken appToken = appWin.mToken;
        while (appToken.appWindowToken == null && (parent = this.mService.mTokenMap.get(appToken.token)) != null && appToken != parent) {
            appToken = parent;
        }
        this.mRootToken = appToken;
        this.mAppToken = appToken.appWindowToken;
        this.mSurface = null;
        this.mRequestedWidth = 0;
        this.mRequestedHeight = 0;
        this.mXOffset = 0;
        this.mYOffset = 0;
        this.mLayer = 0;
        this.mAnimLayer = 0;
        this.mLastLayer = 0;
        this.mInputWindowHandle = new InputWindowHandle(this.mAppToken != null ? this.mAppToken.mInputApplicationHandle : null, this);
    }

    void attach() {
        this.mSession.windowAddedLocked();
    }

    public void computeFrameLw(Rect pf, Rect df, Rect cf, Rect vf) {
        float y;
        float x;
        int h;
        int w;
        this.mHaveFrame = true;
        Rect container = this.mContainingFrame;
        container.set(pf);
        Rect display = this.mDisplayFrame;
        display.set(df);
        int pw = container.right - container.left;
        int ph = container.bottom - container.top;
        if ((this.mAttrs.flags & 0x4000) != 0) {
            w = this.mAttrs.width < 0 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.width * this.mGlobalScale + 0.5f) : this.mAttrs.width);
            h = this.mAttrs.height < 0 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.height * this.mGlobalScale + 0.5f) : this.mAttrs.height);
        } else {
            w = this.mAttrs.width == -1 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedWidth * this.mGlobalScale + 0.5f) : this.mRequestedWidth);
            h = this.mAttrs.height == -1 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedHeight * this.mGlobalScale + 0.5f) : this.mRequestedHeight);
        }
        if (!this.mParentFrame.equals((Object)pf)) {
            this.mParentFrame.set(pf);
            this.mContentChanged = true;
        }
        Rect content = this.mContentFrame;
        content.set(cf);
        Rect visible = this.mVisibleFrame;
        visible.set(vf);
        Rect frame = this.mFrame;
        int fw = frame.width();
        int fh = frame.height();
        if (this.mEnforceSizeCompat) {
            x = (float)this.mAttrs.x * this.mGlobalScale;
            y = (float)this.mAttrs.y * this.mGlobalScale;
        } else {
            x = this.mAttrs.x;
            y = this.mAttrs.y;
        }
        Gravity.apply((int)this.mAttrs.gravity, (int)w, (int)h, (Rect)container, (int)((int)(x + this.mAttrs.horizontalMargin * (float)pw)), (int)((int)(y + this.mAttrs.verticalMargin * (float)ph)), (Rect)frame);
        Gravity.applyDisplay((int)this.mAttrs.gravity, (Rect)df, (Rect)frame);
        if (content.left < frame.left) {
            content.left = frame.left;
        }
        if (content.top < frame.top) {
            content.top = frame.top;
        }
        if (content.right > frame.right) {
            content.right = frame.right;
        }
        if (content.bottom > frame.bottom) {
            content.bottom = frame.bottom;
        }
        if (visible.left < frame.left) {
            visible.left = frame.left;
        }
        if (visible.top < frame.top) {
            visible.top = frame.top;
        }
        if (visible.right > frame.right) {
            visible.right = frame.right;
        }
        if (visible.bottom > frame.bottom) {
            visible.bottom = frame.bottom;
        }
        Rect contentInsets = this.mContentInsets;
        contentInsets.left = content.left - frame.left;
        contentInsets.top = content.top - frame.top;
        contentInsets.right = frame.right - content.right;
        contentInsets.bottom = frame.bottom - content.bottom;
        Rect visibleInsets = this.mVisibleInsets;
        visibleInsets.left = visible.left - frame.left;
        visibleInsets.top = visible.top - frame.top;
        visibleInsets.right = frame.right - visible.right;
        visibleInsets.bottom = frame.bottom - visible.bottom;
        this.mCompatFrame.set(frame);
        if (this.mEnforceSizeCompat) {
            contentInsets.scale(this.mInvGlobalScale);
            visibleInsets.scale(this.mInvGlobalScale);
            this.mCompatFrame.scale(this.mInvGlobalScale);
        }
        if (this.mIsWallpaper && (fw != frame.width() || fh != frame.height())) {
            this.mService.updateWallpaperOffsetLocked(this, this.mService.mAppDisplayWidth, this.mService.mAppDisplayHeight, false);
        }
    }

    public Rect getFrameLw() {
        return this.mFrame;
    }

    public RectF getShownFrameLw() {
        return this.mShownFrame;
    }

    public Rect getDisplayFrameLw() {
        return this.mDisplayFrame;
    }

    public Rect getContentFrameLw() {
        return this.mContentFrame;
    }

    public Rect getVisibleFrameLw() {
        return this.mVisibleFrame;
    }

    public boolean getGivenInsetsPendingLw() {
        return this.mGivenInsetsPending;
    }

    public Rect getGivenContentInsetsLw() {
        return this.mGivenContentInsets;
    }

    public Rect getGivenVisibleInsetsLw() {
        return this.mGivenVisibleInsets;
    }

    public WindowManager.LayoutParams getAttrs() {
        return this.mAttrs;
    }

    public boolean getNeedsMenuLw(WindowManagerPolicy.WindowState bottom) {
        int index = -1;
        WindowState ws = this;
        while ((ws.mAttrs.privateFlags & 8) == 0) {
            if (ws == bottom) {
                return false;
            }
            if (index < 0) {
                index = this.mService.mWindows.indexOf(ws);
            }
            if (--index < 0) {
                return false;
            }
            ws = this.mService.mWindows.get(index);
        }
        return (ws.mAttrs.flags & 0x8000000) != 0;
    }

    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    public int getSurfaceLayer() {
        return this.mLayer;
    }

    public IApplicationToken getAppToken() {
        return this.mAppToken != null ? this.mAppToken.appToken : null;
    }

    public long getInputDispatchingTimeoutNanos() {
        return this.mAppToken != null ? this.mAppToken.inputDispatchingTimeoutNanos : 5000000000L;
    }

    public boolean hasAppShownWindows() {
        return this.mAppToken != null ? this.mAppToken.firstWindowDrawn : false;
    }

    public void setAnimation(Animation anim) {
        this.mAnimating = false;
        this.mLocalAnimating = false;
        this.mAnimation = anim;
        this.mAnimation.restrictDuration(10000L);
        this.mAnimation.scaleCurrentDuration(this.mService.mWindowAnimationScale);
    }

    public void clearAnimation() {
        if (this.mAnimation != null) {
            this.mAnimating = true;
            this.mLocalAnimating = false;
            this.mAnimation.cancel();
            this.mAnimation = null;
        }
    }

    void cancelExitAnimationForNextAnimationLocked() {
        if (!this.mExiting) {
            return;
        }
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
            this.mAnimation = null;
            this.destroySurfaceLocked();
        }
        this.mExiting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Surface createSurfaceLocked() {
        if (this.mSurface == null) {
            this.mReportDestroySurface = false;
            this.mSurfacePendingDestroy = false;
            this.mDrawPending = true;
            this.mCommitDrawPending = false;
            this.mReadyToShow = false;
            if (this.mAppToken != null) {
                this.mAppToken.allDrawn = false;
            }
            this.mService.makeWindowFreezingScreenIfNeededLocked(this);
            int flags = 0;
            if ((this.mAttrs.flags & 0x2000) != 0) {
                flags |= 0x80;
            }
            int w = this.mCompatFrame.width();
            int h = this.mCompatFrame.height();
            if ((this.mAttrs.flags & 0x4000) != 0) {
                w = this.mRequestedWidth;
                h = this.mRequestedHeight;
            }
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            this.mSurfaceShown = false;
            this.mSurfaceLayer = 0;
            this.mSurfaceAlpha = 1.0f;
            this.mSurfaceX = 0.0f;
            this.mSurfaceY = 0.0f;
            this.mSurfaceW = w;
            this.mSurfaceH = h;
            try {
                int format;
                boolean isHwAccelerated = (this.mAttrs.flags & 0x1000000) != 0;
                int n = format = isHwAccelerated ? -3 : this.mAttrs.format;
                if (!PixelFormat.formatHasAlpha((int)this.mAttrs.format)) {
                    flags |= 0x400;
                }
                this.mSurface = new Surface(this.mSession.mSurfaceSession, this.mSession.mPid, ((Object)this.mAttrs.getTitle()).toString(), 0, w, h, format, flags);
            }
            catch (Surface.OutOfResourcesException e) {
                Slog.w((String)"WindowManager", (String)"OutOfResourcesException creating surface");
                this.mService.reclaimSomeSurfaceMemoryLocked(this, "create", true);
                return null;
            }
            catch (Exception e) {
                Slog.e((String)"WindowManager", (String)"Exception creating surface", (Throwable)e);
                return null;
            }
            Surface.openTransaction();
            try {
                try {
                    this.mSurfaceX = this.mFrame.left + this.mXOffset;
                    this.mSurfaceY = this.mFrame.top + this.mYOffset;
                    this.mSurface.setPosition(this.mSurfaceX, this.mSurfaceY);
                    this.mSurfaceLayer = this.mAnimLayer;
                    this.mSurface.setLayer(this.mAnimLayer);
                    this.mSurfaceShown = false;
                    this.mSurface.hide();
                    if ((this.mAttrs.flags & 0x1000) != 0) {
                        this.mSurface.setFlags(4, 4);
                    }
                }
                catch (RuntimeException e) {
                    Slog.w((String)"WindowManager", (String)("Error creating surface in " + w), (Throwable)e);
                    this.mService.reclaimSomeSurfaceMemoryLocked(this, "create-init", true);
                }
                this.mLastHidden = true;
            }
            finally {
                Surface.closeTransaction();
            }
        }
        return this.mSurface;
    }

    void destroySurfaceLocked() {
        if (this.mAppToken != null && this == this.mAppToken.startingWindow) {
            this.mAppToken.startingDisplayed = false;
        }
        if (this.mSurface != null) {
            this.mDrawPending = false;
            this.mCommitDrawPending = false;
            this.mReadyToShow = false;
            int i = this.mChildWindows.size();
            while (i > 0) {
                WindowState c = this.mChildWindows.get(--i);
                c.mAttachedHidden = true;
            }
            if (this.mReportDestroySurface) {
                this.mReportDestroySurface = false;
                this.mSurfacePendingDestroy = true;
                try {
                    this.mClient.dispatchGetNewSurface();
                    return;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            try {
                if (this.mSurfaceDestroyDeferred) {
                    if (this.mSurface != null && this.mPendingDestroySurface != this.mSurface) {
                        if (this.mPendingDestroySurface != null) {
                            this.mPendingDestroySurface.destroy();
                        }
                        this.mPendingDestroySurface = this.mSurface;
                    }
                } else {
                    this.mSurface.destroy();
                }
            }
            catch (RuntimeException e) {
                Slog.w((String)"WindowManager", (String)("Exception thrown when destroying Window " + this + " surface " + this.mSurface + " session " + (Object)((Object)this.mSession) + ": " + e.toString()));
            }
            this.mSurfaceShown = false;
            this.mSurface = null;
        }
    }

    void destroyDeferredSurfaceLocked() {
        try {
            if (this.mPendingDestroySurface != null) {
                this.mPendingDestroySurface.destroy();
            }
        }
        catch (RuntimeException e) {
            Slog.w((String)"WindowManager", (String)("Exception thrown when destroying Window " + this + " surface " + this.mPendingDestroySurface + " session " + (Object)((Object)this.mSession) + ": " + e.toString()));
        }
        this.mSurfaceDestroyDeferred = false;
        this.mPendingDestroySurface = null;
    }

    boolean finishDrawingLocked() {
        if (this.mDrawPending) {
            this.mCommitDrawPending = true;
            this.mDrawPending = false;
            return true;
        }
        return false;
    }

    boolean commitFinishDrawingLocked(long currentTime) {
        if (!this.mCommitDrawPending) {
            return false;
        }
        this.mCommitDrawPending = false;
        this.mReadyToShow = true;
        boolean starting = this.mAttrs.type == 3;
        AppWindowToken atoken = this.mAppToken;
        if (atoken == null || atoken.allDrawn || starting) {
            this.performShowLocked();
        }
        return true;
    }

    boolean performShowLocked() {
        if (this.mReadyToShow && this.isReadyForDisplay()) {
            if (!this.mService.showSurfaceRobustlyLocked(this)) {
                return false;
            }
            this.mLastAlpha = -1.0f;
            this.mHasDrawn = true;
            this.mLastHidden = false;
            this.mReadyToShow = false;
            this.mService.enableScreenIfNeededLocked();
            this.mService.applyEnterAnimationLocked(this);
            int i = this.mChildWindows.size();
            while (i > 0) {
                WindowState c = this.mChildWindows.get(--i);
                if (!c.mAttachedHidden) continue;
                c.mAttachedHidden = false;
                if (c.mSurface == null) continue;
                c.performShowLocked();
                this.mService.mLayoutNeeded = true;
            }
            if (this.mAttrs.type != 3 && this.mAppToken != null) {
                this.mAppToken.firstWindowDrawn = true;
                if (this.mAppToken.startingData != null) {
                    if (this.mAnimation != null) {
                        this.mAnimation.cancel();
                        this.mAnimation = null;
                        this.mAnimating = true;
                    }
                    this.mService.mFinishedStarting.add(this.mAppToken);
                    this.mService.mH.sendEmptyMessage(7);
                }
                this.mAppToken.updateReportedVisibilityLocked();
            }
        }
        return true;
    }

    boolean stepAnimationLocked(long currentTime, int dw, int dh) {
        if (!this.mService.mDisplayFrozen && this.mService.mPolicy.isScreenOnFully()) {
            if (!this.mDrawPending && !this.mCommitDrawPending && this.mAnimation != null) {
                this.mHasTransformation = true;
                this.mHasLocalTransformation = true;
                if (!this.mLocalAnimating) {
                    this.mAnimation.initialize(this.mFrame.width(), this.mFrame.height(), dw, dh);
                    this.mAnimation.setStartTime(currentTime);
                    this.mLocalAnimating = true;
                    this.mAnimating = true;
                }
                this.mTransformation.clear();
                boolean more = this.mAnimation.getTransformation(currentTime, this.mTransformation);
                if (more) {
                    return true;
                }
                if (this.mAnimation != null) {
                    this.mAnimation.cancel();
                    this.mAnimation = null;
                }
            }
            this.mHasLocalTransformation = false;
            if ((!this.mLocalAnimating || this.mAnimationIsEntrance) && this.mAppToken != null && this.mAppToken.animation != null) {
                this.mAnimating = true;
                this.mHasTransformation = true;
                this.mTransformation.clear();
                return false;
            }
            if (this.mHasTransformation) {
                this.mAnimating = true;
            } else if (this.isAnimating()) {
                this.mAnimating = true;
            }
        } else if (this.mAnimation != null) {
            this.mAnimating = true;
            this.mLocalAnimating = true;
            this.mAnimation.cancel();
            this.mAnimation = null;
        }
        if (!this.mAnimating && !this.mLocalAnimating) {
            return false;
        }
        this.mAnimating = false;
        this.mLocalAnimating = false;
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
            this.mAnimation = null;
        }
        if (this.mService.mWindowDetachedWallpaper == this) {
            this.mService.mWindowDetachedWallpaper = null;
        }
        this.mAnimLayer = this.mLayer;
        if (this.mIsImWindow) {
            this.mAnimLayer += this.mService.mInputMethodAnimLayerAdjustment;
        } else if (this.mIsWallpaper) {
            this.mAnimLayer += this.mService.mWallpaperAnimLayerAdjustment;
        }
        this.mHasTransformation = false;
        this.mHasLocalTransformation = false;
        if (this.mPolicyVisibility != this.mPolicyVisibilityAfterAnim) {
            this.mPolicyVisibility = this.mPolicyVisibilityAfterAnim;
            this.mService.mLayoutNeeded = true;
            if (!this.mPolicyVisibility) {
                if (this.mService.mCurrentFocus == this) {
                    this.mService.mFocusMayChange = true;
                }
                this.mService.enableScreenIfNeededLocked();
            }
        }
        this.mTransformation.clear();
        if (this.mHasDrawn && this.mAttrs.type == 3 && this.mAppToken != null && this.mAppToken.firstWindowDrawn && this.mAppToken.startingData != null) {
            this.mService.mFinishedStarting.add(this.mAppToken);
            this.mService.mH.sendEmptyMessage(7);
        }
        this.finishExit();
        if (this.mAppToken != null) {
            this.mAppToken.updateReportedVisibilityLocked();
        }
        return false;
    }

    void finishExit() {
        int N = this.mChildWindows.size();
        for (int i = 0; i < N; ++i) {
            this.mChildWindows.get(i).finishExit();
        }
        if (!this.mExiting) {
            return;
        }
        if (this.isWindowAnimating()) {
            return;
        }
        if (this.mSurface != null) {
            this.mService.mDestroySurface.add(this);
            this.mDestroying = true;
            this.mSurfaceShown = false;
            try {
                this.mSurface.hide();
            }
            catch (RuntimeException e) {
                Slog.w((String)"WindowManager", (String)("Error hiding surface in " + this), (Throwable)e);
            }
            this.mLastHidden = true;
        }
        this.mExiting = false;
        if (this.mRemoveOnExit) {
            this.mService.mPendingRemove.add(this);
            this.mRemoveOnExit = false;
        }
    }

    boolean isIdentityMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        if (dsdx < 0.99999f || dsdx > 1.00001f) {
            return false;
        }
        if (dtdy < 0.99999f || dtdy > 1.00001f) {
            return false;
        }
        if (dtdx < -1.0E-6f || dtdx > 1.0E-6f) {
            return false;
        }
        return !(dsdy < -1.0E-6f) && !(dsdy > 1.0E-6f);
    }

    void prelayout() {
        if (this.mEnforceSizeCompat) {
            this.mGlobalScale = this.mService.mCompatibleScreenScale;
            this.mInvGlobalScale = 1.0f / this.mGlobalScale;
        } else {
            this.mInvGlobalScale = 1.0f;
            this.mGlobalScale = 1.0f;
        }
    }

    void computeShownFrameLocked() {
        boolean screenAnimation;
        Transformation appTransformation;
        boolean selfTransformation = this.mHasLocalTransformation;
        Transformation attachedTransformation = this.mAttachedWindow != null && this.mAttachedWindow.mHasLocalTransformation ? this.mAttachedWindow.mTransformation : null;
        Transformation transformation = appTransformation = this.mAppToken != null && this.mAppToken.hasTransformation ? this.mAppToken.transformation : null;
        if (this.mAttrs.type == 2013 && this.mService.mLowerWallpaperTarget == null && this.mService.mWallpaperTarget != null) {
            if (this.mService.mWallpaperTarget.mHasLocalTransformation && this.mService.mWallpaperTarget.mAnimation != null && !this.mService.mWallpaperTarget.mAnimation.getDetachWallpaper()) {
                attachedTransformation = this.mService.mWallpaperTarget.mTransformation;
            }
            if (this.mService.mWallpaperTarget.mAppToken != null && this.mService.mWallpaperTarget.mAppToken.hasTransformation && this.mService.mWallpaperTarget.mAppToken.animation != null && !this.mService.mWallpaperTarget.mAppToken.animation.getDetachWallpaper()) {
                appTransformation = this.mService.mWallpaperTarget.mAppToken.transformation;
            }
        }
        boolean bl = screenAnimation = this.mService.mScreenRotationAnimation != null && this.mService.mScreenRotationAnimation.isAnimating();
        if (selfTransformation || attachedTransformation != null || appTransformation != null || screenAnimation) {
            Rect frame = this.mFrame;
            float[] tmpFloats = this.mService.mTmpFloats;
            Matrix tmpMatrix = this.mTmpMatrix;
            if (screenAnimation) {
                float w = frame.width();
                float h = frame.height();
                if (w >= 1.0f && h >= 1.0f) {
                    tmpMatrix.setScale(1.0f + 2.0f / w, 1.0f + 2.0f / h, w / 2.0f, h / 2.0f);
                } else {
                    tmpMatrix.reset();
                }
            } else {
                tmpMatrix.reset();
            }
            tmpMatrix.postScale(this.mGlobalScale, this.mGlobalScale);
            if (selfTransformation) {
                tmpMatrix.postConcat(this.mTransformation.getMatrix());
            }
            tmpMatrix.postTranslate((float)(frame.left + this.mXOffset), (float)(frame.top + this.mYOffset));
            if (attachedTransformation != null) {
                tmpMatrix.postConcat(attachedTransformation.getMatrix());
            }
            if (appTransformation != null) {
                tmpMatrix.postConcat(appTransformation.getMatrix());
            }
            if (screenAnimation) {
                tmpMatrix.postConcat(this.mService.mScreenRotationAnimation.getEnterTransformation().getMatrix());
            }
            this.mHaveMatrix = true;
            tmpMatrix.getValues(tmpFloats);
            this.mDsDx = tmpFloats[0];
            this.mDtDx = tmpFloats[3];
            this.mDsDy = tmpFloats[1];
            this.mDtDy = tmpFloats[4];
            float x = tmpFloats[2];
            float y = tmpFloats[5];
            int w = frame.width();
            int h = frame.height();
            this.mShownFrame.set(x, y, x + (float)w, y + (float)h);
            this.mShownAlpha = this.mAlpha;
            if (!this.mService.mLimitedAlphaCompositing || !PixelFormat.formatHasAlpha((int)this.mAttrs.format) || this.isIdentityMatrix(this.mDsDx, this.mDtDx, this.mDsDy, this.mDtDy) && x == (float)frame.left && y == (float)frame.top) {
                if (selfTransformation) {
                    this.mShownAlpha *= this.mTransformation.getAlpha();
                }
                if (attachedTransformation != null) {
                    this.mShownAlpha *= attachedTransformation.getAlpha();
                }
                if (appTransformation != null) {
                    this.mShownAlpha *= appTransformation.getAlpha();
                }
                if (screenAnimation) {
                    this.mShownAlpha *= this.mService.mScreenRotationAnimation.getEnterTransformation().getAlpha();
                }
            }
            return;
        }
        this.mShownFrame.set(this.mFrame);
        if (this.mXOffset != 0 || this.mYOffset != 0) {
            this.mShownFrame.offset((float)this.mXOffset, (float)this.mYOffset);
        }
        this.mShownAlpha = this.mAlpha;
        this.mHaveMatrix = false;
        this.mDsDx = this.mGlobalScale;
        this.mDtDx = 0.0f;
        this.mDsDy = 0.0f;
        this.mDtDy = this.mGlobalScale;
    }

    public boolean isVisibleLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mSurface != null && this.mPolicyVisibility && !this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested) && !this.mExiting && !this.mDestroying;
    }

    public boolean isVisibleOrBehindKeyguardLw() {
        boolean animating;
        if (this.mRootToken.waitingToShow && this.mService.mNextAppTransition != -1) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        boolean bl = atoken != null ? atoken.animation != null : (animating = false);
        return this.mSurface != null && !this.mDestroying && !this.mExiting && (atoken == null ? this.mPolicyVisibility : !atoken.hiddenRequested) && (!this.mAttachedHidden && this.mViewVisibility == 0 && !this.mRootToken.hidden || this.mAnimation != null || animating);
    }

    public boolean isWinVisibleLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mSurface != null && this.mPolicyVisibility && !this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested || atoken.animating) && !this.mExiting && !this.mDestroying;
    }

    boolean isVisibleNow() {
        return this.mSurface != null && this.mPolicyVisibility && !this.mAttachedHidden && !this.mRootToken.hidden && !this.mExiting && !this.mDestroying;
    }

    boolean isPotentialDragTarget() {
        return this.isVisibleNow() && !this.mRemoved && this.mInputChannel != null && this.mInputWindowHandle != null;
    }

    boolean isVisibleOrAdding() {
        AppWindowToken atoken = this.mAppToken;
        return (this.mSurface != null && !this.mReportDestroySurface || !this.mRelayoutCalled && this.mViewVisibility == 0) && this.mPolicyVisibility && !this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested) && !this.mExiting && !this.mDestroying;
    }

    boolean isOnScreen() {
        AppWindowToken atoken = this.mAppToken;
        if (atoken != null) {
            return this.mSurface != null && this.mPolicyVisibility && !this.mDestroying && (!this.mAttachedHidden && !atoken.hiddenRequested || this.mAnimation != null || atoken.animation != null);
        }
        return this.mSurface != null && this.mPolicyVisibility && !this.mDestroying && (!this.mAttachedHidden || this.mAnimation != null);
    }

    boolean isReadyForDisplay() {
        if (this.mRootToken.waitingToShow && this.mService.mNextAppTransition != -1) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        boolean animating = atoken != null ? atoken.animation != null : false;
        return this.mSurface != null && this.mPolicyVisibility && !this.mDestroying && (!this.mAttachedHidden && this.mViewVisibility == 0 && !this.mRootToken.hidden || this.mAnimation != null || animating);
    }

    boolean isAnimating() {
        WindowState attached = this.mAttachedWindow;
        AppWindowToken atoken = this.mAppToken;
        return this.mAnimation != null || attached != null && attached.mAnimation != null || atoken != null && (atoken.animation != null || atoken.inPendingTransaction);
    }

    boolean isWindowAnimating() {
        return this.mAnimation != null;
    }

    public boolean isDisplayedLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mSurface != null && this.mPolicyVisibility && !this.mDestroying && !this.mDrawPending && !this.mCommitDrawPending && (!this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested) || this.mAnimating);
    }

    public boolean isDrawnLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mSurface != null && !this.mDestroying && !this.mDrawPending && !this.mCommitDrawPending;
    }

    boolean isOpaqueDrawn() {
        return !(this.mAttrs.format != -1 && this.mAttrs.type != 2013 || this.mSurface == null || this.mAnimation != null || this.mAppToken != null && this.mAppToken.animation != null || this.mDrawPending || this.mCommitDrawPending);
    }

    boolean shouldAnimateMove() {
        return !(!this.mContentChanged || this.mExiting || this.mLastHidden || this.mService.mDisplayFrozen || this.mFrame.top == this.mLastFrame.top && this.mFrame.left == this.mLastFrame.left || this.mAttachedWindow != null && this.mAttachedWindow.shouldAnimateMove() || !this.mService.mPolicy.isScreenOnFully());
    }

    boolean isFullscreen(int screenWidth, int screenHeight) {
        return this.mFrame.left <= 0 && this.mFrame.top <= 0 && this.mFrame.right >= screenWidth && this.mFrame.bottom >= screenHeight;
    }

    void removeLocked() {
        this.disposeInputChannel();
        if (this.mAttachedWindow != null) {
            this.mAttachedWindow.mChildWindows.remove(this);
        }
        this.destroyDeferredSurfaceLocked();
        this.destroySurfaceLocked();
        this.mSession.windowRemovedLocked();
        try {
            this.mClient.asBinder().unlinkToDeath((IBinder.DeathRecipient)this.mDeathRecipient, 0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void setInputChannel(InputChannel inputChannel) {
        if (this.mInputChannel != null) {
            throw new IllegalStateException("Window already has an input channel.");
        }
        this.mInputChannel = inputChannel;
        this.mInputWindowHandle.inputChannel = inputChannel;
    }

    void disposeInputChannel() {
        if (this.mInputChannel != null) {
            this.mService.mInputManager.unregisterInputChannel(this.mInputChannel);
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        this.mInputWindowHandle.inputChannel = null;
    }

    public final boolean canReceiveKeys() {
        return this.isVisibleOrAdding() && this.mViewVisibility == 0 && (this.mAttrs.flags & 8) == 0;
    }

    public boolean hasDrawnLw() {
        return this.mHasDrawn;
    }

    public boolean showLw(boolean doAnimation) {
        return this.showLw(doAnimation, true);
    }

    boolean showLw(boolean doAnimation, boolean requestAnim) {
        if (this.mPolicyVisibility && this.mPolicyVisibilityAfterAnim) {
            return false;
        }
        if (doAnimation) {
            if (this.mService.mDisplayFrozen || !this.mService.mPolicy.isScreenOnFully()) {
                doAnimation = false;
            } else if (this.mPolicyVisibility && this.mAnimation == null) {
                doAnimation = false;
            }
        }
        this.mPolicyVisibility = true;
        this.mPolicyVisibilityAfterAnim = true;
        if (doAnimation) {
            this.mService.applyAnimationLocked(this, 4097, true);
        }
        if (requestAnim) {
            this.mService.requestAnimationLocked(0L);
        }
        return true;
    }

    public boolean hideLw(boolean doAnimation) {
        return this.hideLw(doAnimation, true);
    }

    boolean hideLw(boolean doAnimation, boolean requestAnim) {
        boolean current;
        if (doAnimation && (this.mService.mDisplayFrozen || !this.mService.mPolicy.isScreenOnFully())) {
            doAnimation = false;
        }
        boolean bl = current = doAnimation ? this.mPolicyVisibilityAfterAnim : this.mPolicyVisibility;
        if (!current) {
            return false;
        }
        if (doAnimation) {
            this.mService.applyAnimationLocked(this, 8194, false);
            if (this.mAnimation == null) {
                doAnimation = false;
            }
        }
        if (doAnimation) {
            this.mPolicyVisibilityAfterAnim = false;
        } else {
            this.mPolicyVisibilityAfterAnim = false;
            this.mPolicyVisibility = false;
            this.mService.enableScreenIfNeededLocked();
            if (this.mService.mCurrentFocus == this) {
                this.mService.mFocusMayChange = true;
            }
        }
        if (requestAnim) {
            this.mService.requestAnimationLocked(0L);
        }
        return true;
    }

    private static void applyInsets(Region outRegion, Rect frame, Rect inset) {
        outRegion.set(frame.left + inset.left, frame.top + inset.top, frame.right - inset.right, frame.bottom - inset.bottom);
    }

    public void getTouchableRegion(Region outRegion) {
        Rect frame = this.mFrame;
        switch (this.mTouchableInsets) {
            default: {
                outRegion.set(frame);
                break;
            }
            case 1: {
                WindowState.applyInsets(outRegion, frame, this.mGivenContentInsets);
                break;
            }
            case 2: {
                WindowState.applyInsets(outRegion, frame, this.mGivenVisibleInsets);
                break;
            }
            case 3: {
                Region givenTouchableRegion = this.mGivenTouchableRegion;
                outRegion.set(givenTouchableRegion);
                outRegion.translate(frame.left, frame.top);
                break;
            }
        }
    }

    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        pw.print(prefix);
        pw.print("mSession=");
        pw.print((Object)this.mSession);
        pw.print(" mClient=");
        pw.println(this.mClient.asBinder());
        pw.print(prefix);
        pw.print("mAttrs=");
        pw.println(this.mAttrs);
        pw.print(prefix);
        pw.print("Requested w=");
        pw.print(this.mRequestedWidth);
        pw.print(" h=");
        pw.print(this.mRequestedHeight);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        if (this.mAttachedWindow != null || this.mLayoutAttached) {
            pw.print(prefix);
            pw.print("mAttachedWindow=");
            pw.print(this.mAttachedWindow);
            pw.print(" mLayoutAttached=");
            pw.println(this.mLayoutAttached);
        }
        if (this.mIsImWindow || this.mIsWallpaper || this.mIsFloatingLayer) {
            pw.print(prefix);
            pw.print("mIsImWindow=");
            pw.print(this.mIsImWindow);
            pw.print(" mIsWallpaper=");
            pw.print(this.mIsWallpaper);
            pw.print(" mIsFloatingLayer=");
            pw.print(this.mIsFloatingLayer);
            pw.print(" mWallpaperVisible=");
            pw.println(this.mWallpaperVisible);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mBaseLayer=");
            pw.print(this.mBaseLayer);
            pw.print(" mSubLayer=");
            pw.print(this.mSubLayer);
            pw.print(" mAnimLayer=");
            pw.print(this.mLayer);
            pw.print("+");
            pw.print(this.mTargetAppToken != null ? this.mTargetAppToken.animLayerAdjustment : (this.mAppToken != null ? this.mAppToken.animLayerAdjustment : 0));
            pw.print("=");
            pw.print(this.mAnimLayer);
            pw.print(" mLastLayer=");
            pw.println(this.mLastLayer);
        }
        if (this.mSurface != null) {
            if (dumpAll) {
                pw.print(prefix);
                pw.print("mSurface=");
                pw.println(this.mSurface);
            }
            pw.print(prefix);
            pw.print("Surface: shown=");
            pw.print(this.mSurfaceShown);
            pw.print(" layer=");
            pw.print(this.mSurfaceLayer);
            pw.print(" alpha=");
            pw.print(this.mSurfaceAlpha);
            pw.print(" rect=(");
            pw.print(this.mSurfaceX);
            pw.print(",");
            pw.print(this.mSurfaceY);
            pw.print(") ");
            pw.print(this.mSurfaceW);
            pw.print(" x ");
            pw.println(this.mSurfaceH);
        }
        if (this.mPendingDestroySurface != null) {
            pw.print(prefix);
            pw.print("mPendingDestroySurface=");
            pw.println(this.mPendingDestroySurface);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mToken=");
            pw.println(this.mToken);
            pw.print(prefix);
            pw.print("mRootToken=");
            pw.println(this.mRootToken);
            if (this.mAppToken != null) {
                pw.print(prefix);
                pw.print("mAppToken=");
                pw.println(this.mAppToken);
            }
            if (this.mTargetAppToken != null) {
                pw.print(prefix);
                pw.print("mTargetAppToken=");
                pw.println(this.mTargetAppToken);
            }
            pw.print(prefix);
            pw.print("mViewVisibility=0x");
            pw.print(Integer.toHexString(this.mViewVisibility));
            pw.print(" mLastHidden=");
            pw.print(this.mLastHidden);
            pw.print(" mHaveFrame=");
            pw.print(this.mHaveFrame);
            pw.print(" mObscured=");
            pw.println(this.mObscured);
            pw.print(prefix);
            pw.print("mSeq=");
            pw.print(this.mSeq);
            pw.print(" mSystemUiVisibility=0x");
            pw.println(Integer.toHexString(this.mSystemUiVisibility));
        }
        if (!this.mPolicyVisibility || !this.mPolicyVisibilityAfterAnim || this.mAttachedHidden) {
            pw.print(prefix);
            pw.print("mPolicyVisibility=");
            pw.print(this.mPolicyVisibility);
            pw.print(" mPolicyVisibilityAfterAnim=");
            pw.print(this.mPolicyVisibilityAfterAnim);
            pw.print(" mAttachedHidden=");
            pw.println(this.mAttachedHidden);
        }
        if (!this.mRelayoutCalled) {
            pw.print(prefix);
            pw.print("mRelayoutCalled=");
            pw.println(this.mRelayoutCalled);
        }
        if (this.mSurfaceResized || this.mSurfaceDestroyDeferred) {
            pw.print(prefix);
            pw.print("mSurfaceResized=");
            pw.print(this.mSurfaceResized);
            pw.print(" mSurfaceDestroyDeferred=");
            pw.println(this.mSurfaceDestroyDeferred);
        }
        if (this.mXOffset != 0 || this.mYOffset != 0) {
            pw.print(prefix);
            pw.print("Offsets x=");
            pw.print(this.mXOffset);
            pw.print(" y=");
            pw.println(this.mYOffset);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mGivenContentInsets=");
            this.mGivenContentInsets.printShortString(pw);
            pw.print(" mGivenVisibleInsets=");
            this.mGivenVisibleInsets.printShortString(pw);
            pw.println();
            if (this.mTouchableInsets != 0 || this.mGivenInsetsPending) {
                pw.print(prefix);
                pw.print("mTouchableInsets=");
                pw.print(this.mTouchableInsets);
                pw.print(" mGivenInsetsPending=");
                pw.println(this.mGivenInsetsPending);
            }
            pw.print(prefix);
            pw.print("mConfiguration=");
            pw.println(this.mConfiguration);
        }
        pw.print(prefix);
        pw.print("mShownFrame=");
        this.mShownFrame.printShortString(pw);
        pw.println();
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mFrame=");
            this.mFrame.printShortString(pw);
            pw.print(" last=");
            this.mLastFrame.printShortString(pw);
            pw.println();
        }
        if (this.mEnforceSizeCompat) {
            pw.print(prefix);
            pw.print("mCompatFrame=");
            this.mCompatFrame.printShortString(pw);
            pw.println();
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mContainingFrame=");
            this.mContainingFrame.printShortString(pw);
            pw.print(" mParentFrame=");
            this.mParentFrame.printShortString(pw);
            pw.print(" mDisplayFrame=");
            this.mDisplayFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("mContentFrame=");
            this.mContentFrame.printShortString(pw);
            pw.print(" mVisibleFrame=");
            this.mVisibleFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("mContentInsets=");
            this.mContentInsets.printShortString(pw);
            pw.print(" last=");
            this.mLastContentInsets.printShortString(pw);
            pw.print(" mVisibleInsets=");
            this.mVisibleInsets.printShortString(pw);
            pw.print(" last=");
            this.mLastVisibleInsets.printShortString(pw);
            pw.println();
        }
        if (this.mAnimating || this.mLocalAnimating || this.mAnimationIsEntrance || this.mAnimation != null) {
            pw.print(prefix);
            pw.print("mAnimating=");
            pw.print(this.mAnimating);
            pw.print(" mLocalAnimating=");
            pw.print(this.mLocalAnimating);
            pw.print(" mAnimationIsEntrance=");
            pw.print(this.mAnimationIsEntrance);
            pw.print(" mAnimation=");
            pw.println(this.mAnimation);
        }
        if (this.mHasTransformation || this.mHasLocalTransformation) {
            pw.print(prefix);
            pw.print("XForm: has=");
            pw.print(this.mHasTransformation);
            pw.print(" hasLocal=");
            pw.print(this.mHasLocalTransformation);
            pw.print(" ");
            this.mTransformation.printShortString(pw);
            pw.println();
        }
        if (this.mShownAlpha != 1.0f || this.mAlpha != 1.0f || this.mLastAlpha != 1.0f) {
            pw.print(prefix);
            pw.print("mShownAlpha=");
            pw.print(this.mShownAlpha);
            pw.print(" mAlpha=");
            pw.print(this.mAlpha);
            pw.print(" mLastAlpha=");
            pw.println(this.mLastAlpha);
        }
        if (this.mHaveMatrix || this.mGlobalScale != 1.0f) {
            pw.print(prefix);
            pw.print("mGlobalScale=");
            pw.print(this.mGlobalScale);
            pw.print(" mDsDx=");
            pw.print(this.mDsDx);
            pw.print(" mDtDx=");
            pw.print(this.mDtDx);
            pw.print(" mDsDy=");
            pw.print(this.mDsDy);
            pw.print(" mDtDy=");
            pw.println(this.mDtDy);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mDrawPending=");
            pw.print(this.mDrawPending);
            pw.print(" mCommitDrawPending=");
            pw.print(this.mCommitDrawPending);
            pw.print(" mReadyToShow=");
            pw.print(this.mReadyToShow);
            pw.print(" mHasDrawn=");
            pw.println(this.mHasDrawn);
        }
        if (this.mExiting || this.mRemoveOnExit || this.mDestroying || this.mRemoved) {
            pw.print(prefix);
            pw.print("mExiting=");
            pw.print(this.mExiting);
            pw.print(" mRemoveOnExit=");
            pw.print(this.mRemoveOnExit);
            pw.print(" mDestroying=");
            pw.print(this.mDestroying);
            pw.print(" mRemoved=");
            pw.println(this.mRemoved);
        }
        if (this.mOrientationChanging || this.mAppFreezing || this.mTurnOnScreen) {
            pw.print(prefix);
            pw.print("mOrientationChanging=");
            pw.print(this.mOrientationChanging);
            pw.print(" mAppFreezing=");
            pw.print(this.mAppFreezing);
            pw.print(" mTurnOnScreen=");
            pw.println(this.mTurnOnScreen);
        }
        if (this.mHScale != 1.0f || this.mVScale != 1.0f) {
            pw.print(prefix);
            pw.print("mHScale=");
            pw.print(this.mHScale);
            pw.print(" mVScale=");
            pw.println(this.mVScale);
        }
        if (this.mWallpaperX != -1.0f || this.mWallpaperY != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperX=");
            pw.print(this.mWallpaperX);
            pw.print(" mWallpaperY=");
            pw.println(this.mWallpaperY);
        }
        if (this.mWallpaperXStep != -1.0f || this.mWallpaperYStep != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperXStep=");
            pw.print(this.mWallpaperXStep);
            pw.print(" mWallpaperYStep=");
            pw.println(this.mWallpaperYStep);
        }
    }

    String makeInputChannelName() {
        return Integer.toHexString(System.identityHashCode(this)) + " " + this.mAttrs.getTitle();
    }

    public String toString() {
        if (this.mStringNameCache == null || this.mLastTitle != this.mAttrs.getTitle() || this.mWasPaused != this.mToken.paused) {
            this.mLastTitle = this.mAttrs.getTitle();
            this.mWasPaused = this.mToken.paused;
            this.mStringNameCache = "Window{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mLastTitle + " paused=" + this.mWasPaused + "}";
        }
        return this.mStringNameCache;
    }

    private class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            try {
                HashMap<IBinder, WindowState> hashMap = WindowState.this.mService.mWindowMap;
                synchronized (hashMap) {
                    WindowState win = WindowState.this.mService.windowForClientLocked(WindowState.this.mSession, WindowState.this.mClient, false);
                    Slog.i((String)"WindowManager", (String)("WIN DEATH: " + win));
                    if (win != null) {
                        WindowState.this.mService.removeWindowLocked(WindowState.this.mSession, win);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

