/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.AsYouTypeFormatter;
import com.android.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberMatch;
import com.android.i18n.phonenumbers.PhoneNumberMatcher;
import com.android.i18n.phonenumbers.Phonemetadata;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.RegexCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneNumberUtil {
    static final int REGEX_FLAGS = 66;
    private static final int MIN_LENGTH_FOR_NSN = 3;
    static final int MAX_LENGTH_FOR_NSN = 15;
    static final int MAX_LENGTH_COUNTRY_CODE = 3;
    static final String META_DATA_FILE_PREFIX = "/com/android/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private String currentFilePrefix = "/com/android/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberUtil.class.getName());
    private Map<Integer, List<String>> countryCallingCodeToRegionCodeMap = null;
    private final Set<String> supportedRegions = new HashSet<String>(300);
    private static final String UNKNOWN_REGION = "ZZ";
    private final Set<String> nanpaRegions = new HashSet<String>(35);
    private static final int NANPA_COUNTRY_CODE = 1;
    static final char PLUS_SIGN = '+';
    private static final String RFC3966_EXTN_PREFIX = ";ext=";
    private static final Map<Character, Character> ALPHA_MAPPINGS;
    private static final Map<Character, Character> ALPHA_PHONE_MAPPINGS;
    private static final Map<Character, Character> ALL_PLUS_NUMBER_GROUPING_SYMBOLS;
    private static final Pattern UNIQUE_INTERNATIONAL_PREFIX;
    static final String VALID_PUNCTUATION = "-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e";
    private static final String DIGITS = "\\p{Nd}";
    private static final String VALID_ALPHA;
    static final String PLUS_CHARS = "+\uff0b";
    static final Pattern PLUS_CHARS_PATTERN;
    private static final Pattern SEPARATOR_PATTERN;
    private static final Pattern CAPTURING_DIGIT_PATTERN;
    private static final String VALID_START_CHAR = "[+\uff0b\\p{Nd}]";
    private static final Pattern VALID_START_CHAR_PATTERN;
    private static final String SECOND_NUMBER_START = "[\\\\/] *x";
    static final Pattern SECOND_NUMBER_START_PATTERN;
    private static final String UNWANTED_END_CHARS = "[[\\P{N}&&\\P{L}]&&[^#]]+$";
    static final Pattern UNWANTED_END_CHAR_PATTERN;
    private static final Pattern VALID_ALPHA_PHONE_PATTERN;
    private static final String VALID_PHONE_NUMBER;
    private static final String DEFAULT_EXTN_PREFIX = " ext. ";
    private static final String CAPTURING_EXTN_DIGITS = "(\\p{Nd}{1,7})";
    private static final String EXTN_PATTERNS_FOR_PARSING;
    static final String EXTN_PATTERNS_FOR_MATCHING;
    private static final Pattern EXTN_PATTERN;
    private static final Pattern VALID_PHONE_NUMBER_PATTERN;
    private static final Pattern NON_DIGITS_PATTERN;
    private static final Pattern FIRST_GROUP_PATTERN;
    private static final Pattern NP_PATTERN;
    private static final Pattern FG_PATTERN;
    private static final Pattern CC_PATTERN;
    private static PhoneNumberUtil instance;
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private RegexCache regexCache = new RegexCache(100);

    private static String createExtnPattern(String singleExtnSymbols) {
        return ";ext=(\\p{Nd}{1,7})|[ \u00a0\\t,]*(?:ext(?:ensi(?:o\u0301?|\u00f3))?n?|\uff45\uff58\uff54\uff4e?|[" + singleExtnSymbols + "]|int|anexo|\uff49\uff4e\uff54)" + "[:\\.\uff0e]?[ \u00a0\\t,-]*" + CAPTURING_EXTN_DIGITS + "#?|" + "[- ]+(" + DIGITS + "{1,5})#";
    }

    private PhoneNumberUtil() {
    }

    private void init(String filePrefix) {
        this.currentFilePrefix = filePrefix;
        for (List<String> regionCodes : this.countryCallingCodeToRegionCodeMap.values()) {
            this.supportedRegions.addAll(regionCodes);
        }
        this.nanpaRegions.addAll((Collection<String>)this.countryCallingCodeToRegionCodeMap.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadataForRegionFromFile(String filePrefix, String regionCode) {
        InputStream source = PhoneNumberUtil.class.getResourceAsStream(filePrefix + "_" + regionCode);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
            metadataCollection.readExternal(in);
            for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
        finally {
            this.close(in);
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    static String extractPossibleNumber(String number) {
        Matcher m = VALID_START_CHAR_PATTERN.matcher(number);
        if (m.find()) {
            Matcher secondNumber;
            Matcher trailingCharsMatcher = UNWANTED_END_CHAR_PATTERN.matcher(number = number.substring(m.start()));
            if (trailingCharsMatcher.find()) {
                number = number.substring(0, trailingCharsMatcher.start());
                LOGGER.log(Level.FINER, "Stripped trailing characters: " + number);
            }
            if ((secondNumber = SECOND_NUMBER_START_PATTERN.matcher(number)).find()) {
                number = number.substring(0, secondNumber.start());
            }
            return number;
        }
        return "";
    }

    static boolean isViablePhoneNumber(String number) {
        if (number.length() < 3) {
            return false;
        }
        Matcher m = VALID_PHONE_NUMBER_PATTERN.matcher(number);
        return m.matches();
    }

    static String normalize(String number) {
        Matcher m = VALID_ALPHA_PHONE_PATTERN.matcher(number);
        if (m.matches()) {
            return PhoneNumberUtil.normalizeHelper(number, ALPHA_PHONE_MAPPINGS, true);
        }
        return PhoneNumberUtil.normalizeDigitsOnly(number);
    }

    static void normalize(StringBuilder number) {
        String normalizedNumber = PhoneNumberUtil.normalize(number.toString());
        number.replace(0, number.length(), normalizedNumber);
    }

    public static String normalizeDigitsOnly(String number) {
        return PhoneNumberUtil.normalizeDigits(number, false).toString();
    }

    private static StringBuilder normalizeDigits(String number, boolean keepNonDigits) {
        StringBuilder normalizedDigits = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                normalizedDigits.append(digit);
                continue;
            }
            if (!keepNonDigits) continue;
            normalizedDigits.append(c);
        }
        return normalizedDigits;
    }

    public static String convertAlphaCharactersInNumber(String number) {
        return PhoneNumberUtil.normalizeHelper(number, ALPHA_PHONE_MAPPINGS, false);
    }

    public int getLengthOfGeographicalAreaCode(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        if (!this.isValidRegionCode(regionCode)) {
            return 0;
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        if (!metadata.hasNationalPrefix()) {
            return 0;
        }
        PhoneNumberType type = this.getNumberTypeHelper(this.getNationalSignificantNumber(number), metadata);
        if (type != PhoneNumberType.FIXED_LINE && type != PhoneNumberType.FIXED_LINE_OR_MOBILE) {
            return 0;
        }
        return this.getLengthOfNationalDestinationCode(number);
    }

    public int getLengthOfNationalDestinationCode(Phonenumber.PhoneNumber number) {
        Phonenumber.PhoneNumber copiedProto;
        if (number.hasExtension()) {
            copiedProto = new Phonenumber.PhoneNumber();
            copiedProto.mergeFrom(number);
            copiedProto.clearExtension();
        } else {
            copiedProto = number;
        }
        String nationalSignificantNumber = this.format(copiedProto, PhoneNumberFormat.INTERNATIONAL);
        String[] numberGroups = NON_DIGITS_PATTERN.split(nationalSignificantNumber);
        if (numberGroups.length <= 3) {
            return 0;
        }
        if (this.getRegionCodeForNumber(number).equals("AR") && this.getNumberType(number) == PhoneNumberType.MOBILE) {
            return numberGroups[3].length() + 1;
        }
        return numberGroups[2].length();
    }

    private static String normalizeHelper(String number, Map<Character, Character> normalizationReplacements, boolean removeNonMatches) {
        char[] numberAsCharArray;
        StringBuilder normalizedNumber = new StringBuilder(number.length());
        for (char character : numberAsCharArray = number.toCharArray()) {
            Character newDigit = normalizationReplacements.get(Character.valueOf(Character.toUpperCase(character)));
            if (newDigit != null) {
                normalizedNumber.append(newDigit);
                continue;
            }
            if (removeNonMatches) continue;
            normalizedNumber.append(character);
        }
        return normalizedNumber.toString();
    }

    static synchronized PhoneNumberUtil getInstance(String baseFileLocation, Map<Integer, List<String>> countryCallingCodeToRegionCodeMap) {
        if (instance == null) {
            instance = new PhoneNumberUtil();
            PhoneNumberUtil.instance.countryCallingCodeToRegionCodeMap = countryCallingCodeToRegionCodeMap;
            instance.init(baseFileLocation);
        }
        return instance;
    }

    static synchronized void resetInstance() {
        instance = null;
    }

    public Set<String> getSupportedRegions() {
        return this.supportedRegions;
    }

    public static synchronized PhoneNumberUtil getInstance() {
        if (instance == null) {
            return PhoneNumberUtil.getInstance(META_DATA_FILE_PREFIX, CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap());
        }
        return instance;
    }

    private boolean isValidRegionCode(String regionCode) {
        return regionCode != null && this.supportedRegions.contains(regionCode);
    }

    private boolean hasValidRegionCode(String regionCode, int countryCallingCode, String number) {
        if (!this.isValidRegionCode(regionCode)) {
            LOGGER.log(Level.WARNING, "Number " + number + " has invalid or missing country calling code (" + countryCallingCode + ")");
            return false;
        }
        return true;
    }

    public String format(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat) {
        String rawInput;
        if (number.getNationalNumber() == 0L && number.hasRawInput() && (rawInput = number.getRawInput()).length() > 0) {
            return rawInput;
        }
        StringBuilder formattedNumber = new StringBuilder(20);
        this.format(number, numberFormat, formattedNumber);
        return formattedNumber.toString();
    }

    public void format(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        formattedNumber.setLength(0);
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (numberFormat == PhoneNumberFormat.E164) {
            formattedNumber.append(nationalSignificantNumber);
            this.formatNumberByFormat(countryCallingCode, PhoneNumberFormat.E164, formattedNumber);
            return;
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        if (!this.isValidRegionCode(regionCode)) {
            formattedNumber.append(nationalSignificantNumber);
            return;
        }
        formattedNumber.append(this.formatNationalNumber(nationalSignificantNumber, regionCode, numberFormat));
        this.maybeGetFormattedExtension(number, regionCode, numberFormat, formattedNumber);
        this.formatNumberByFormat(countryCallingCode, numberFormat, formattedNumber);
    }

    public String formatByPattern(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat, List<Phonemetadata.NumberFormat> userDefinedFormats) {
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        if (!this.hasValidRegionCode(regionCode, countryCallingCode, nationalSignificantNumber)) {
            return nationalSignificantNumber;
        }
        ArrayList<Phonemetadata.NumberFormat> userDefinedFormatsCopy = new ArrayList<Phonemetadata.NumberFormat>(userDefinedFormats.size());
        for (Phonemetadata.NumberFormat numFormat : userDefinedFormats) {
            String nationalPrefixFormattingRule = numFormat.getNationalPrefixFormattingRule();
            if (nationalPrefixFormattingRule.length() > 0) {
                Phonemetadata.NumberFormat numFormatCopy = new Phonemetadata.NumberFormat();
                numFormatCopy.mergeFrom(numFormat);
                String nationalPrefix = this.getMetadataForRegion(regionCode).getNationalPrefix();
                if (nationalPrefix.length() > 0) {
                    nationalPrefixFormattingRule = NP_PATTERN.matcher(nationalPrefixFormattingRule).replaceFirst(nationalPrefix);
                    nationalPrefixFormattingRule = FG_PATTERN.matcher(nationalPrefixFormattingRule).replaceFirst("\\$1");
                    numFormatCopy.setNationalPrefixFormattingRule(nationalPrefixFormattingRule);
                } else {
                    numFormatCopy.clearNationalPrefixFormattingRule();
                }
                userDefinedFormatsCopy.add(numFormatCopy);
                continue;
            }
            userDefinedFormatsCopy.add(numFormat);
        }
        StringBuilder formattedNumber = new StringBuilder(this.formatAccordingToFormats(nationalSignificantNumber, userDefinedFormatsCopy, numberFormat));
        this.maybeGetFormattedExtension(number, regionCode, numberFormat, formattedNumber);
        this.formatNumberByFormat(countryCallingCode, numberFormat, formattedNumber);
        return formattedNumber.toString();
    }

    public String formatNationalNumberWithCarrierCode(Phonenumber.PhoneNumber number, String carrierCode) {
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        if (!this.hasValidRegionCode(regionCode, countryCallingCode, nationalSignificantNumber)) {
            return nationalSignificantNumber;
        }
        StringBuilder formattedNumber = new StringBuilder(20);
        formattedNumber.append(this.formatNationalNumber(nationalSignificantNumber, regionCode, PhoneNumberFormat.NATIONAL, carrierCode));
        this.maybeGetFormattedExtension(number, regionCode, PhoneNumberFormat.NATIONAL, formattedNumber);
        this.formatNumberByFormat(countryCallingCode, PhoneNumberFormat.NATIONAL, formattedNumber);
        return formattedNumber.toString();
    }

    public String formatNationalNumberWithPreferredCarrierCode(Phonenumber.PhoneNumber number, String fallbackCarrierCode) {
        return this.formatNationalNumberWithCarrierCode(number, number.hasPreferredDomesticCarrierCode() ? number.getPreferredDomesticCarrierCode() : fallbackCarrierCode);
    }

    public String formatOutOfCountryCallingNumber(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        String nationalSignificantNumber;
        if (!this.isValidRegionCode(regionCallingFrom)) {
            return this.format(number, PhoneNumberFormat.INTERNATIONAL);
        }
        int countryCallingCode = number.getCountryCode();
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        if (!this.hasValidRegionCode(regionCode, countryCallingCode, nationalSignificantNumber = this.getNationalSignificantNumber(number))) {
            return nationalSignificantNumber;
        }
        if (countryCallingCode == 1) {
            if (this.isNANPACountry(regionCallingFrom)) {
                return countryCallingCode + " " + this.format(number, PhoneNumberFormat.NATIONAL);
            }
        } else if (countryCallingCode == this.getCountryCodeForRegion(regionCallingFrom)) {
            return this.format(number, PhoneNumberFormat.NATIONAL);
        }
        String formattedNationalNumber = this.formatNationalNumber(nationalSignificantNumber, regionCode, PhoneNumberFormat.INTERNATIONAL);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCallingFrom);
        String internationalPrefix = metadata.getInternationalPrefix();
        String internationalPrefixForFormatting = "";
        if (UNIQUE_INTERNATIONAL_PREFIX.matcher(internationalPrefix).matches()) {
            internationalPrefixForFormatting = internationalPrefix;
        } else if (metadata.hasPreferredInternationalPrefix()) {
            internationalPrefixForFormatting = metadata.getPreferredInternationalPrefix();
        }
        StringBuilder formattedNumber = new StringBuilder(formattedNationalNumber);
        this.maybeGetFormattedExtension(number, regionCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        if (internationalPrefixForFormatting.length() > 0) {
            formattedNumber.insert(0, " ").insert(0, countryCallingCode).insert(0, " ").insert(0, internationalPrefixForFormatting);
        } else {
            this.formatNumberByFormat(countryCallingCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        }
        return formattedNumber.toString();
    }

    public String formatInOriginalFormat(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        String formattedNumber;
        if (!(!number.hasRawInput() || this.hasFormattingPatternForNumber(number) && this.isValidNumber(number))) {
            return number.getRawInput();
        }
        if (!number.hasCountryCodeSource()) {
            return this.format(number, PhoneNumberFormat.NATIONAL);
        }
        switch (number.getCountryCodeSource()) {
            case FROM_NUMBER_WITH_PLUS_SIGN: {
                formattedNumber = this.format(number, PhoneNumberFormat.INTERNATIONAL);
                break;
            }
            case FROM_NUMBER_WITH_IDD: {
                formattedNumber = this.formatOutOfCountryCallingNumber(number, regionCallingFrom);
                break;
            }
            case FROM_NUMBER_WITHOUT_PLUS_SIGN: {
                formattedNumber = this.format(number, PhoneNumberFormat.INTERNATIONAL).substring(1);
                break;
            }
            default: {
                formattedNumber = this.format(number, PhoneNumberFormat.NATIONAL);
            }
        }
        String rawInput = number.getRawInput();
        return formattedNumber != null && PhoneNumberUtil.normalizeDigitsOnly(formattedNumber).equals(PhoneNumberUtil.normalizeDigitsOnly(rawInput)) ? formattedNumber : rawInput;
    }

    private boolean hasFormattingPatternForNumber(Phonenumber.PhoneNumber number) {
        String phoneNumberRegion = this.getRegionCodeForCountryCode(number.getCountryCode());
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(phoneNumberRegion);
        if (metadata == null) {
            return false;
        }
        String nationalNumber = this.getNationalSignificantNumber(number);
        Phonemetadata.NumberFormat formatRule = this.chooseFormattingPatternForNumber(metadata.numberFormats(), nationalNumber);
        return formatRule != null;
    }

    public String formatOutOfCountryKeepingAlphaChars(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        String internationalPrefix;
        int firstNationalNumberDigit;
        String rawInput = number.getRawInput();
        if (rawInput.length() == 0) {
            return this.formatOutOfCountryCallingNumber(number, regionCallingFrom);
        }
        int countryCode = number.getCountryCode();
        String regionCode = this.getRegionCodeForCountryCode(countryCode);
        if (!this.hasValidRegionCode(regionCode, countryCode, rawInput)) {
            return rawInput;
        }
        rawInput = PhoneNumberUtil.normalizeHelper(rawInput, ALL_PLUS_NUMBER_GROUPING_SYMBOLS, true);
        String nationalNumber = this.getNationalSignificantNumber(number);
        if (nationalNumber.length() > 3 && (firstNationalNumberDigit = rawInput.indexOf(nationalNumber.substring(0, 3))) != -1) {
            rawInput = rawInput.substring(firstNationalNumberDigit);
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCallingFrom);
        if (countryCode == 1) {
            if (this.isNANPACountry(regionCallingFrom)) {
                return countryCode + " " + rawInput;
            }
        } else if (countryCode == this.getCountryCodeForRegion(regionCallingFrom)) {
            ArrayList<Phonemetadata.NumberFormat> availableFormats = new ArrayList<Phonemetadata.NumberFormat>(metadata.numberFormatSize());
            for (Phonemetadata.NumberFormat format : metadata.numberFormats()) {
                Phonemetadata.NumberFormat newFormat = new Phonemetadata.NumberFormat();
                newFormat.mergeFrom(format);
                newFormat.setPattern("(\\d+)(.*)");
                newFormat.setFormat("$1$2");
                availableFormats.add(newFormat);
            }
            return this.formatAccordingToFormats(rawInput, availableFormats, PhoneNumberFormat.NATIONAL);
        }
        String internationalPrefixForFormatting = UNIQUE_INTERNATIONAL_PREFIX.matcher(internationalPrefix = metadata.getInternationalPrefix()).matches() ? internationalPrefix : metadata.getPreferredInternationalPrefix();
        StringBuilder formattedNumber = new StringBuilder(rawInput);
        this.maybeGetFormattedExtension(number, regionCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        if (internationalPrefixForFormatting.length() > 0) {
            formattedNumber.insert(0, " ").insert(0, countryCode).insert(0, " ").insert(0, internationalPrefixForFormatting);
        } else {
            this.formatNumberByFormat(countryCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        }
        return formattedNumber.toString();
    }

    public String getNationalSignificantNumber(Phonenumber.PhoneNumber number) {
        StringBuilder nationalNumber = new StringBuilder(number.isItalianLeadingZero() ? "0" : "");
        nationalNumber.append(number.getNationalNumber());
        return nationalNumber.toString();
    }

    private void formatNumberByFormat(int countryCallingCode, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        switch (numberFormat) {
            case E164: {
                formattedNumber.insert(0, countryCallingCode).insert(0, '+');
                return;
            }
            case INTERNATIONAL: {
                formattedNumber.insert(0, " ").insert(0, countryCallingCode).insert(0, '+');
                return;
            }
            case RFC3966: {
                formattedNumber.insert(0, "-").insert(0, countryCallingCode).insert(0, '+');
                return;
            }
        }
    }

    private String formatNationalNumber(String number, String regionCode, PhoneNumberFormat numberFormat) {
        return this.formatNationalNumber(number, regionCode, numberFormat, null);
    }

    private String formatNationalNumber(String number, String regionCode, PhoneNumberFormat numberFormat, String carrierCode) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        List<Phonemetadata.NumberFormat> intlNumberFormats = metadata.intlNumberFormats();
        List<Phonemetadata.NumberFormat> availableFormats = intlNumberFormats.size() == 0 || numberFormat == PhoneNumberFormat.NATIONAL ? metadata.numberFormats() : metadata.intlNumberFormats();
        String formattedNationalNumber = this.formatAccordingToFormats(number, availableFormats, numberFormat, carrierCode);
        if (numberFormat == PhoneNumberFormat.RFC3966) {
            formattedNationalNumber = SEPARATOR_PATTERN.matcher(formattedNationalNumber).replaceAll("-");
        }
        return formattedNationalNumber;
    }

    private Phonemetadata.NumberFormat chooseFormattingPatternForNumber(List<Phonemetadata.NumberFormat> availableFormats, String nationalNumber) {
        for (Phonemetadata.NumberFormat numFormat : availableFormats) {
            Matcher m;
            int size = numFormat.leadingDigitsPatternSize();
            if (size != 0 && !this.regexCache.getPatternForRegex(numFormat.getLeadingDigitsPattern(size - 1)).matcher(nationalNumber).lookingAt() || !(m = this.regexCache.getPatternForRegex(numFormat.getPattern()).matcher(nationalNumber)).matches()) continue;
            return numFormat;
        }
        return null;
    }

    private String formatAccordingToFormats(String nationalNumber, List<Phonemetadata.NumberFormat> availableFormats, PhoneNumberFormat numberFormat) {
        return this.formatAccordingToFormats(nationalNumber, availableFormats, numberFormat, null);
    }

    private String formatAccordingToFormats(String nationalNumber, List<Phonemetadata.NumberFormat> availableFormats, PhoneNumberFormat numberFormat, String carrierCode) {
        for (Phonemetadata.NumberFormat numFormat : availableFormats) {
            Matcher m;
            int size = numFormat.leadingDigitsPatternSize();
            if (size != 0 && !this.regexCache.getPatternForRegex(numFormat.getLeadingDigitsPattern(size - 1)).matcher(nationalNumber).lookingAt() || !(m = this.regexCache.getPatternForRegex(numFormat.getPattern()).matcher(nationalNumber)).matches()) continue;
            String numberFormatRule = numFormat.getFormat();
            if (numberFormat == PhoneNumberFormat.NATIONAL && carrierCode != null && carrierCode.length() > 0 && numFormat.getDomesticCarrierCodeFormattingRule().length() > 0) {
                String carrierCodeFormattingRule = numFormat.getDomesticCarrierCodeFormattingRule();
                carrierCodeFormattingRule = CC_PATTERN.matcher(carrierCodeFormattingRule).replaceFirst(carrierCode);
                numberFormatRule = FIRST_GROUP_PATTERN.matcher(numberFormatRule).replaceFirst(carrierCodeFormattingRule);
                return m.replaceAll(numberFormatRule);
            }
            String nationalPrefixFormattingRule = numFormat.getNationalPrefixFormattingRule();
            if (numberFormat == PhoneNumberFormat.NATIONAL && nationalPrefixFormattingRule != null && nationalPrefixFormattingRule.length() > 0) {
                Matcher firstGroupMatcher = FIRST_GROUP_PATTERN.matcher(numberFormatRule);
                return m.replaceAll(firstGroupMatcher.replaceFirst(nationalPrefixFormattingRule));
            }
            return m.replaceAll(numberFormatRule);
        }
        return nationalNumber;
    }

    public Phonenumber.PhoneNumber getExampleNumber(String regionCode) {
        return this.getExampleNumberForType(regionCode, PhoneNumberType.FIXED_LINE);
    }

    public Phonenumber.PhoneNumber getExampleNumberForType(String regionCode, PhoneNumberType type) {
        if (!this.isValidRegionCode(regionCode)) {
            LOGGER.log(Level.WARNING, "Invalid or unknown region code provided.");
            return null;
        }
        Phonemetadata.PhoneNumberDesc desc = this.getNumberDescByType(this.getMetadataForRegion(regionCode), type);
        try {
            if (desc.hasExampleNumber()) {
                return this.parse(desc.getExampleNumber(), regionCode);
            }
        }
        catch (NumberParseException e) {
            LOGGER.log(Level.SEVERE, e.toString());
        }
        return null;
    }

    private void maybeGetFormattedExtension(Phonenumber.PhoneNumber number, String regionCode, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        if (number.hasExtension() && number.getExtension().length() > 0) {
            if (numberFormat == PhoneNumberFormat.RFC3966) {
                formattedNumber.append(RFC3966_EXTN_PREFIX).append(number.getExtension());
            } else {
                this.formatExtension(number.getExtension(), regionCode, formattedNumber);
            }
        }
    }

    private void formatExtension(String extensionDigits, String regionCode, StringBuilder extension) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        if (metadata.hasPreferredExtnPrefix()) {
            extension.append(metadata.getPreferredExtnPrefix()).append(extensionDigits);
        } else {
            extension.append(DEFAULT_EXTN_PREFIX).append(extensionDigits);
        }
    }

    Phonemetadata.PhoneNumberDesc getNumberDescByType(Phonemetadata.PhoneMetadata metadata, PhoneNumberType type) {
        switch (type) {
            case PREMIUM_RATE: {
                return metadata.getPremiumRate();
            }
            case TOLL_FREE: {
                return metadata.getTollFree();
            }
            case MOBILE: {
                return metadata.getMobile();
            }
            case FIXED_LINE: 
            case FIXED_LINE_OR_MOBILE: {
                return metadata.getFixedLine();
            }
            case SHARED_COST: {
                return metadata.getSharedCost();
            }
            case VOIP: {
                return metadata.getVoip();
            }
            case PERSONAL_NUMBER: {
                return metadata.getPersonalNumber();
            }
            case PAGER: {
                return metadata.getPager();
            }
            case UAN: {
                return metadata.getUan();
            }
        }
        return metadata.getGeneralDesc();
    }

    public PhoneNumberType getNumberType(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        if (!this.isValidRegionCode(regionCode)) {
            return PhoneNumberType.UNKNOWN;
        }
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        return this.getNumberTypeHelper(nationalSignificantNumber, this.getMetadataForRegion(regionCode));
    }

    private PhoneNumberType getNumberTypeHelper(String nationalNumber, Phonemetadata.PhoneMetadata metadata) {
        Phonemetadata.PhoneNumberDesc generalNumberDesc = metadata.getGeneralDesc();
        if (!generalNumberDesc.hasNationalNumberPattern() || !this.isNumberMatchingDesc(nationalNumber, generalNumberDesc)) {
            return PhoneNumberType.UNKNOWN;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPremiumRate())) {
            return PhoneNumberType.PREMIUM_RATE;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getTollFree())) {
            return PhoneNumberType.TOLL_FREE;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getSharedCost())) {
            return PhoneNumberType.SHARED_COST;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getVoip())) {
            return PhoneNumberType.VOIP;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPersonalNumber())) {
            return PhoneNumberType.PERSONAL_NUMBER;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPager())) {
            return PhoneNumberType.PAGER;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getUan())) {
            return PhoneNumberType.UAN;
        }
        boolean isFixedLine = this.isNumberMatchingDesc(nationalNumber, metadata.getFixedLine());
        if (isFixedLine) {
            if (metadata.isSameMobileAndFixedLinePattern()) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            if (this.isNumberMatchingDesc(nationalNumber, metadata.getMobile())) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            return PhoneNumberType.FIXED_LINE;
        }
        if (!metadata.isSameMobileAndFixedLinePattern() && this.isNumberMatchingDesc(nationalNumber, metadata.getMobile())) {
            return PhoneNumberType.MOBILE;
        }
        return PhoneNumberType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!this.isValidRegionCode(regionCode)) {
            return null;
        }
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataForRegionFromFile(this.currentFilePrefix, regionCode);
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    private boolean isNumberMatchingDesc(String nationalNumber, Phonemetadata.PhoneNumberDesc numberDesc) {
        Matcher possibleNumberPatternMatcher = this.regexCache.getPatternForRegex(numberDesc.getPossibleNumberPattern()).matcher(nationalNumber);
        Matcher nationalNumberPatternMatcher = this.regexCache.getPatternForRegex(numberDesc.getNationalNumberPattern()).matcher(nationalNumber);
        return possibleNumberPatternMatcher.matches() && nationalNumberPatternMatcher.matches();
    }

    public boolean isValidNumber(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        return this.isValidRegionCode(regionCode) && this.isValidNumberForRegion(number, regionCode);
    }

    public boolean isValidNumberForRegion(Phonenumber.PhoneNumber number, String regionCode) {
        if (number.getCountryCode() != this.getCountryCodeForRegion(regionCode)) {
            return false;
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        Phonemetadata.PhoneNumberDesc generalNumDesc = metadata.getGeneralDesc();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!generalNumDesc.hasNationalNumberPattern()) {
            int numberLength = nationalSignificantNumber.length();
            return numberLength > 3 && numberLength <= 15;
        }
        return this.getNumberTypeHelper(nationalSignificantNumber, metadata) != PhoneNumberType.UNKNOWN;
    }

    public String getRegionCodeForNumber(Phonenumber.PhoneNumber number) {
        int countryCode = number.getCountryCode();
        List<String> regions = this.countryCallingCodeToRegionCodeMap.get(countryCode);
        if (regions == null) {
            return null;
        }
        if (regions.size() == 1) {
            return regions.get(0);
        }
        return this.getRegionCodeForNumberFromRegionList(number, regions);
    }

    private String getRegionCodeForNumberFromRegionList(Phonenumber.PhoneNumber number, List<String> regionCodes) {
        String nationalNumber = this.getNationalSignificantNumber(number);
        for (String regionCode : regionCodes) {
            Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
            if (!(metadata.hasLeadingDigits() ? this.regexCache.getPatternForRegex(metadata.getLeadingDigits()).matcher(nationalNumber).lookingAt() : this.getNumberTypeHelper(nationalNumber, metadata) != PhoneNumberType.UNKNOWN)) continue;
            return regionCode;
        }
        return null;
    }

    public String getRegionCodeForCountryCode(int countryCallingCode) {
        List<String> regionCodes = this.countryCallingCodeToRegionCodeMap.get(countryCallingCode);
        return regionCodes == null ? UNKNOWN_REGION : regionCodes.get(0);
    }

    public int getCountryCodeForRegion(String regionCode) {
        if (!this.isValidRegionCode(regionCode)) {
            return 0;
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        return metadata.getCountryCode();
    }

    public String getNddPrefixForRegion(String regionCode, boolean stripNonDigits) {
        if (!this.isValidRegionCode(regionCode)) {
            LOGGER.log(Level.SEVERE, "Invalid or missing region code provided.");
            return null;
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        String nationalPrefix = metadata.getNationalPrefix();
        if (nationalPrefix.length() == 0) {
            return null;
        }
        if (stripNonDigits) {
            nationalPrefix = nationalPrefix.replace("~", "");
        }
        return nationalPrefix;
    }

    public boolean isNANPACountry(String regionCode) {
        return this.nanpaRegions.contains(regionCode);
    }

    boolean isLeadingZeroPossible(int countryCallingCode) {
        Phonemetadata.PhoneMetadata mainMetadataForCallingCode = this.getMetadataForRegion(this.getRegionCodeForCountryCode(countryCallingCode));
        if (mainMetadataForCallingCode == null) {
            return false;
        }
        return mainMetadataForCallingCode.isLeadingZeroPossible();
    }

    public boolean isAlphaNumber(String number) {
        if (!PhoneNumberUtil.isViablePhoneNumber(number)) {
            return false;
        }
        StringBuilder strippedNumber = new StringBuilder(number);
        this.maybeStripExtension(strippedNumber);
        return VALID_ALPHA_PHONE_PATTERN.matcher(strippedNumber).matches();
    }

    public boolean isPossibleNumber(Phonenumber.PhoneNumber number) {
        return this.isPossibleNumberWithReason(number) == ValidationResult.IS_POSSIBLE;
    }

    private ValidationResult testNumberLengthAgainstPattern(Pattern numberPattern, String number) {
        Matcher numberMatcher = numberPattern.matcher(number);
        if (numberMatcher.matches()) {
            return ValidationResult.IS_POSSIBLE;
        }
        if (numberMatcher.lookingAt()) {
            return ValidationResult.TOO_LONG;
        }
        return ValidationResult.TOO_SHORT;
    }

    public ValidationResult isPossibleNumberWithReason(Phonenumber.PhoneNumber number) {
        String nationalNumber = this.getNationalSignificantNumber(number);
        int countryCode = number.getCountryCode();
        String regionCode = this.getRegionCodeForCountryCode(countryCode);
        if (!this.isValidRegionCode(regionCode)) {
            return ValidationResult.INVALID_COUNTRY_CODE;
        }
        Phonemetadata.PhoneNumberDesc generalNumDesc = this.getMetadataForRegion(regionCode).getGeneralDesc();
        if (!generalNumDesc.hasNationalNumberPattern()) {
            LOGGER.log(Level.FINER, "Checking if number is possible with incomplete metadata.");
            int numberLength = nationalNumber.length();
            if (numberLength < 3) {
                return ValidationResult.TOO_SHORT;
            }
            if (numberLength > 15) {
                return ValidationResult.TOO_LONG;
            }
            return ValidationResult.IS_POSSIBLE;
        }
        Pattern possibleNumberPattern = this.regexCache.getPatternForRegex(generalNumDesc.getPossibleNumberPattern());
        return this.testNumberLengthAgainstPattern(possibleNumberPattern, nationalNumber);
    }

    public boolean isPossibleNumber(String number, String regionDialingFrom) {
        try {
            return this.isPossibleNumber(this.parse(number, regionDialingFrom));
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    public boolean truncateTooLongNumber(Phonenumber.PhoneNumber number) {
        if (this.isValidNumber(number)) {
            return true;
        }
        Phonenumber.PhoneNumber numberCopy = new Phonenumber.PhoneNumber();
        numberCopy.mergeFrom(number);
        long nationalNumber = number.getNationalNumber();
        do {
            numberCopy.setNationalNumber(nationalNumber /= 10L);
            if (this.isPossibleNumberWithReason(numberCopy) != ValidationResult.TOO_SHORT && nationalNumber != 0L) continue;
            return false;
        } while (!this.isValidNumber(numberCopy));
        number.setNationalNumber(nationalNumber);
        return true;
    }

    public AsYouTypeFormatter getAsYouTypeFormatter(String regionCode) {
        return new AsYouTypeFormatter(regionCode);
    }

    int extractCountryCode(StringBuilder fullNumber, StringBuilder nationalNumber) {
        int numberLength = fullNumber.length();
        for (int i = 1; i <= 3 && i <= numberLength; ++i) {
            int potentialCountryCode = Integer.parseInt(fullNumber.substring(0, i));
            if (!this.countryCallingCodeToRegionCodeMap.containsKey(potentialCountryCode)) continue;
            nationalNumber.append(fullNumber.substring(i));
            return potentialCountryCode;
        }
        return 0;
    }

    int maybeExtractCountryCode(String number, Phonemetadata.PhoneMetadata defaultRegionMetadata, StringBuilder nationalNumber, boolean keepRawInput, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        if (number.length() == 0) {
            return 0;
        }
        StringBuilder fullNumber = new StringBuilder(number);
        String possibleCountryIddPrefix = "NonMatch";
        if (defaultRegionMetadata != null) {
            possibleCountryIddPrefix = defaultRegionMetadata.getInternationalPrefix();
        }
        Phonenumber.PhoneNumber.CountryCodeSource countryCodeSource = this.maybeStripInternationalPrefixAndNormalize(fullNumber, possibleCountryIddPrefix);
        if (keepRawInput) {
            phoneNumber.setCountryCodeSource(countryCodeSource);
        }
        if (countryCodeSource != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            if (fullNumber.length() < 3) {
                throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_AFTER_IDD, "Phone number had an IDD, but after this was not long enough to be a viable phone number.");
            }
            int potentialCountryCode = this.extractCountryCode(fullNumber, nationalNumber);
            if (potentialCountryCode != 0) {
                phoneNumber.setCountryCode(potentialCountryCode);
                return potentialCountryCode;
            }
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Country calling code supplied was not recognised.");
        }
        if (defaultRegionMetadata != null) {
            int defaultCountryCode = defaultRegionMetadata.getCountryCode();
            String defaultCountryCodeString = String.valueOf(defaultCountryCode);
            String normalizedNumber = fullNumber.toString();
            if (normalizedNumber.startsWith(defaultCountryCodeString)) {
                StringBuilder potentialNationalNumber = new StringBuilder(normalizedNumber.substring(defaultCountryCodeString.length()));
                Phonemetadata.PhoneNumberDesc generalDesc = defaultRegionMetadata.getGeneralDesc();
                Pattern validNumberPattern = this.regexCache.getPatternForRegex(generalDesc.getNationalNumberPattern());
                this.maybeStripNationalPrefixAndCarrierCode(potentialNationalNumber, defaultRegionMetadata);
                Pattern possibleNumberPattern = this.regexCache.getPatternForRegex(generalDesc.getPossibleNumberPattern());
                if (!validNumberPattern.matcher(fullNumber).matches() && validNumberPattern.matcher(potentialNationalNumber).matches() || this.testNumberLengthAgainstPattern(possibleNumberPattern, fullNumber.toString()) == ValidationResult.TOO_LONG) {
                    nationalNumber.append((CharSequence)potentialNationalNumber);
                    if (keepRawInput) {
                        phoneNumber.setCountryCodeSource(Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITHOUT_PLUS_SIGN);
                    }
                    phoneNumber.setCountryCode(defaultCountryCode);
                    return defaultCountryCode;
                }
            }
        }
        phoneNumber.setCountryCode(0);
        return 0;
    }

    private boolean parsePrefixAsIdd(Pattern iddPattern, StringBuilder number) {
        Matcher m = iddPattern.matcher(number);
        if (m.lookingAt()) {
            String normalizedGroup;
            int matchEnd = m.end();
            Matcher digitMatcher = CAPTURING_DIGIT_PATTERN.matcher(number.substring(matchEnd));
            if (digitMatcher.find() && (normalizedGroup = PhoneNumberUtil.normalizeDigitsOnly(digitMatcher.group(1))).equals("0")) {
                return false;
            }
            number.delete(0, matchEnd);
            return true;
        }
        return false;
    }

    Phonenumber.PhoneNumber.CountryCodeSource maybeStripInternationalPrefixAndNormalize(StringBuilder number, String possibleIddPrefix) {
        if (number.length() == 0) {
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
        }
        Matcher m = PLUS_CHARS_PATTERN.matcher(number);
        if (m.lookingAt()) {
            number.delete(0, m.end());
            PhoneNumberUtil.normalize(number);
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN;
        }
        Pattern iddPattern = this.regexCache.getPatternForRegex(possibleIddPrefix);
        if (this.parsePrefixAsIdd(iddPattern, number)) {
            PhoneNumberUtil.normalize(number);
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_IDD;
        }
        PhoneNumberUtil.normalize(number);
        return this.parsePrefixAsIdd(iddPattern, number) ? Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_IDD : Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
    }

    String maybeStripNationalPrefixAndCarrierCode(StringBuilder number, Phonemetadata.PhoneMetadata metadata) {
        String carrierCode = "";
        int numberLength = number.length();
        String possibleNationalPrefix = metadata.getNationalPrefixForParsing();
        if (numberLength == 0 || possibleNationalPrefix.length() == 0) {
            return "";
        }
        Matcher prefixMatcher = this.regexCache.getPatternForRegex(possibleNationalPrefix).matcher(number);
        if (prefixMatcher.lookingAt()) {
            Pattern nationalNumberRule = this.regexCache.getPatternForRegex(metadata.getGeneralDesc().getNationalNumberPattern());
            boolean isViableOriginalNumber = nationalNumberRule.matcher(number).matches();
            int numOfGroups = prefixMatcher.groupCount();
            String transformRule = metadata.getNationalPrefixTransformRule();
            if (transformRule == null || transformRule.length() == 0 || prefixMatcher.group(numOfGroups) == null) {
                if (isViableOriginalNumber && !nationalNumberRule.matcher(number.substring(prefixMatcher.end())).matches()) {
                    return "";
                }
                if (numOfGroups > 0 && prefixMatcher.group(numOfGroups) != null) {
                    carrierCode = prefixMatcher.group(1);
                }
                number.delete(0, prefixMatcher.end());
            } else {
                StringBuilder transformedNumber = new StringBuilder(number);
                transformedNumber.replace(0, numberLength, prefixMatcher.replaceFirst(transformRule));
                if (isViableOriginalNumber && !nationalNumberRule.matcher(transformedNumber.toString()).matches()) {
                    return "";
                }
                if (numOfGroups > 1) {
                    carrierCode = prefixMatcher.group(1);
                }
                number.replace(0, number.length(), transformedNumber.toString());
            }
        }
        return carrierCode;
    }

    String maybeStripExtension(StringBuilder number) {
        Matcher m = EXTN_PATTERN.matcher(number);
        if (m.find() && PhoneNumberUtil.isViablePhoneNumber(number.substring(0, m.start()))) {
            int length = m.groupCount();
            for (int i = 1; i <= length; ++i) {
                if (m.group(i) == null) continue;
                String extension = m.group(i);
                number.delete(m.start(), number.length());
                return extension;
            }
        }
        return "";
    }

    private boolean checkRegionForParsing(String numberToParse, String defaultRegion) {
        return this.isValidRegionCode(defaultRegion) || numberToParse != null && numberToParse.length() != 0 && PLUS_CHARS_PATTERN.matcher(numberToParse).lookingAt();
    }

    public Phonenumber.PhoneNumber parse(String numberToParse, String defaultRegion) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parse(numberToParse, defaultRegion, phoneNumber);
        return phoneNumber;
    }

    public void parse(String numberToParse, String defaultRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(numberToParse, defaultRegion, false, true, phoneNumber);
    }

    public Phonenumber.PhoneNumber parseAndKeepRawInput(String numberToParse, String defaultRegion) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parseAndKeepRawInput(numberToParse, defaultRegion, phoneNumber);
        return phoneNumber;
    }

    public void parseAndKeepRawInput(String numberToParse, String defaultRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(numberToParse, defaultRegion, true, true, phoneNumber);
    }

    public Iterable<PhoneNumberMatch> findNumbers(CharSequence text, String defaultRegion) {
        return this.findNumbers(text, defaultRegion, Leniency.VALID, Long.MAX_VALUE);
    }

    public Iterable<PhoneNumberMatch> findNumbers(final CharSequence text, final String defaultRegion, final Leniency leniency, final long maxTries) {
        return new Iterable<PhoneNumberMatch>(){

            @Override
            public Iterator<PhoneNumberMatch> iterator() {
                return new PhoneNumberMatcher(PhoneNumberUtil.this, text, defaultRegion, leniency, maxTries);
            }
        };
    }

    private void parseHelper(String numberToParse, String defaultRegion, boolean keepRawInput, boolean checkRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        int lengthOfNationalNumber;
        StringBuilder nationalNumber;
        String extension;
        if (numberToParse == null) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The phone number supplied was null.");
        }
        String number = PhoneNumberUtil.extractPossibleNumber(numberToParse);
        if (!PhoneNumberUtil.isViablePhoneNumber(number)) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The string supplied did not seem to be a phone number.");
        }
        if (checkRegion && !this.checkRegionForParsing(number, defaultRegion)) {
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Missing or invalid default region.");
        }
        if (keepRawInput) {
            phoneNumber.setRawInput(numberToParse);
        }
        if ((extension = this.maybeStripExtension(nationalNumber = new StringBuilder(number))).length() > 0) {
            phoneNumber.setExtension(extension);
        }
        Phonemetadata.PhoneMetadata regionMetadata = this.getMetadataForRegion(defaultRegion);
        StringBuilder normalizedNationalNumber = new StringBuilder();
        int countryCode = this.maybeExtractCountryCode(nationalNumber.toString(), regionMetadata, normalizedNationalNumber, keepRawInput, phoneNumber);
        if (countryCode != 0) {
            String phoneNumberRegion = this.getRegionCodeForCountryCode(countryCode);
            if (!phoneNumberRegion.equals(defaultRegion)) {
                regionMetadata = this.getMetadataForRegion(phoneNumberRegion);
            }
        } else {
            PhoneNumberUtil.normalize(nationalNumber);
            normalizedNationalNumber.append((CharSequence)nationalNumber);
            if (defaultRegion != null) {
                countryCode = regionMetadata.getCountryCode();
                phoneNumber.setCountryCode(countryCode);
            } else if (keepRawInput) {
                phoneNumber.clearCountryCodeSource();
            }
        }
        if (normalizedNationalNumber.length() < 3) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (regionMetadata != null) {
            String carrierCode = this.maybeStripNationalPrefixAndCarrierCode(normalizedNationalNumber, regionMetadata);
            if (keepRawInput) {
                phoneNumber.setPreferredDomesticCarrierCode(carrierCode);
            }
        }
        if ((lengthOfNationalNumber = normalizedNationalNumber.length()) < 3) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (lengthOfNationalNumber > 15) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_LONG, "The string supplied is too long to be a phone number.");
        }
        if (normalizedNationalNumber.charAt(0) == '0') {
            phoneNumber.setItalianLeadingZero(true);
        }
        phoneNumber.setNationalNumber(Long.parseLong(normalizedNationalNumber.toString()));
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber firstNumberIn, Phonenumber.PhoneNumber secondNumberIn) {
        Phonenumber.PhoneNumber firstNumber = new Phonenumber.PhoneNumber();
        firstNumber.mergeFrom(firstNumberIn);
        Phonenumber.PhoneNumber secondNumber = new Phonenumber.PhoneNumber();
        secondNumber.mergeFrom(secondNumberIn);
        firstNumber.clearRawInput();
        firstNumber.clearCountryCodeSource();
        firstNumber.clearPreferredDomesticCarrierCode();
        secondNumber.clearRawInput();
        secondNumber.clearCountryCodeSource();
        secondNumber.clearPreferredDomesticCarrierCode();
        if (firstNumber.hasExtension() && firstNumber.getExtension().length() == 0) {
            firstNumber.clearExtension();
        }
        if (secondNumber.hasExtension() && secondNumber.getExtension().length() == 0) {
            secondNumber.clearExtension();
        }
        if (firstNumber.hasExtension() && secondNumber.hasExtension() && !firstNumber.getExtension().equals(secondNumber.getExtension())) {
            return MatchType.NO_MATCH;
        }
        int firstNumberCountryCode = firstNumber.getCountryCode();
        int secondNumberCountryCode = secondNumber.getCountryCode();
        if (firstNumberCountryCode != 0 && secondNumberCountryCode != 0) {
            if (firstNumber.exactlySameAs(secondNumber)) {
                return MatchType.EXACT_MATCH;
            }
            if (firstNumberCountryCode == secondNumberCountryCode && this.isNationalNumberSuffixOfTheOther(firstNumber, secondNumber)) {
                return MatchType.SHORT_NSN_MATCH;
            }
            return MatchType.NO_MATCH;
        }
        firstNumber.setCountryCode(secondNumberCountryCode);
        if (firstNumber.exactlySameAs(secondNumber)) {
            return MatchType.NSN_MATCH;
        }
        if (this.isNationalNumberSuffixOfTheOther(firstNumber, secondNumber)) {
            return MatchType.SHORT_NSN_MATCH;
        }
        return MatchType.NO_MATCH;
    }

    private boolean isNationalNumberSuffixOfTheOther(Phonenumber.PhoneNumber firstNumber, Phonenumber.PhoneNumber secondNumber) {
        String secondNumberNationalNumber;
        String firstNumberNationalNumber = String.valueOf(firstNumber.getNationalNumber());
        return firstNumberNationalNumber.endsWith(secondNumberNationalNumber = String.valueOf(secondNumber.getNationalNumber())) || secondNumberNationalNumber.endsWith(firstNumberNationalNumber);
    }

    public MatchType isNumberMatch(String firstNumber, String secondNumber) {
        try {
            Phonenumber.PhoneNumber firstNumberAsProto = this.parse(firstNumber, UNKNOWN_REGION);
            return this.isNumberMatch(firstNumberAsProto, secondNumber);
        }
        catch (NumberParseException e) {
            block7: {
                if (e.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                    try {
                        Phonenumber.PhoneNumber secondNumberAsProto = this.parse(secondNumber, UNKNOWN_REGION);
                        return this.isNumberMatch(secondNumberAsProto, firstNumber);
                    }
                    catch (NumberParseException e2) {
                        if (e2.getErrorType() != NumberParseException.ErrorType.INVALID_COUNTRY_CODE) break block7;
                        try {
                            Phonenumber.PhoneNumber firstNumberProto = new Phonenumber.PhoneNumber();
                            Phonenumber.PhoneNumber secondNumberProto = new Phonenumber.PhoneNumber();
                            this.parseHelper(firstNumber, null, false, false, firstNumberProto);
                            this.parseHelper(secondNumber, null, false, false, secondNumberProto);
                            return this.isNumberMatch(firstNumberProto, secondNumberProto);
                        }
                        catch (NumberParseException e3) {
                            // empty catch block
                        }
                    }
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber firstNumber, String secondNumber) {
        try {
            Phonenumber.PhoneNumber secondNumberAsProto = this.parse(secondNumber, UNKNOWN_REGION);
            return this.isNumberMatch(firstNumber, secondNumberAsProto);
        }
        catch (NumberParseException e) {
            if (e.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                String firstNumberRegion = this.getRegionCodeForCountryCode(firstNumber.getCountryCode());
                try {
                    if (!firstNumberRegion.equals(UNKNOWN_REGION)) {
                        Phonenumber.PhoneNumber secondNumberWithFirstNumberRegion = this.parse(secondNumber, firstNumberRegion);
                        MatchType match = this.isNumberMatch(firstNumber, secondNumberWithFirstNumberRegion);
                        if (match == MatchType.EXACT_MATCH) {
                            return MatchType.NSN_MATCH;
                        }
                        return match;
                    }
                    Phonenumber.PhoneNumber secondNumberProto = new Phonenumber.PhoneNumber();
                    this.parseHelper(secondNumber, null, false, false, secondNumberProto);
                    return this.isNumberMatch(firstNumber, secondNumberProto);
                }
                catch (NumberParseException e2) {
                    // empty catch block
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    boolean canBeInternationallyDialled(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!this.hasValidRegionCode(regionCode, number.getCountryCode(), nationalSignificantNumber)) {
            return true;
        }
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        return !this.isNumberMatchingDesc(nationalSignificantNumber, metadata.getNoInternationalDialling());
    }

    static {
        HashMap<Character, Character> asciiDigitMappings = new HashMap<Character, Character>();
        asciiDigitMappings.put(Character.valueOf('0'), Character.valueOf('0'));
        asciiDigitMappings.put(Character.valueOf('1'), Character.valueOf('1'));
        asciiDigitMappings.put(Character.valueOf('2'), Character.valueOf('2'));
        asciiDigitMappings.put(Character.valueOf('3'), Character.valueOf('3'));
        asciiDigitMappings.put(Character.valueOf('4'), Character.valueOf('4'));
        asciiDigitMappings.put(Character.valueOf('5'), Character.valueOf('5'));
        asciiDigitMappings.put(Character.valueOf('6'), Character.valueOf('6'));
        asciiDigitMappings.put(Character.valueOf('7'), Character.valueOf('7'));
        asciiDigitMappings.put(Character.valueOf('8'), Character.valueOf('8'));
        asciiDigitMappings.put(Character.valueOf('9'), Character.valueOf('9'));
        HashMap<Character, Character> alphaMap = new HashMap<Character, Character>(40);
        alphaMap.put(Character.valueOf('A'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('B'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('C'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('D'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('E'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('F'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('G'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('H'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('I'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('J'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('K'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('L'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('M'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('N'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('O'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('P'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('Q'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('R'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('S'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('T'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('U'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('V'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('W'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('X'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('Y'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('Z'), Character.valueOf('9'));
        ALPHA_MAPPINGS = Collections.unmodifiableMap(alphaMap);
        HashMap<Character, Character> combinedMap = new HashMap<Character, Character>(100);
        combinedMap.putAll(ALPHA_MAPPINGS);
        combinedMap.putAll(asciiDigitMappings);
        ALPHA_PHONE_MAPPINGS = Collections.unmodifiableMap(combinedMap);
        HashMap<Character, Character> allPlusNumberGroupings = new HashMap<Character, Character>();
        for (char c : ALPHA_MAPPINGS.keySet()) {
            allPlusNumberGroupings.put(Character.valueOf(Character.toLowerCase(c)), Character.valueOf(c));
            allPlusNumberGroupings.put(Character.valueOf(c), Character.valueOf(c));
        }
        allPlusNumberGroupings.putAll(asciiDigitMappings);
        allPlusNumberGroupings.put(Character.valueOf('-'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2010'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2011'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2012'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2013'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2014'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2015'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2212'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('/'), Character.valueOf('/'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        allPlusNumberGroupings.put(Character.valueOf(' '), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('\u2060'), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('.'), Character.valueOf('.'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        ALL_PLUS_NUMBER_GROUPING_SYMBOLS = Collections.unmodifiableMap(allPlusNumberGroupings);
        UNIQUE_INTERNATIONAL_PREFIX = Pattern.compile("[\\d]+(?:[~\u2053\u223c\uff5e][\\d]+)?");
        VALID_ALPHA = Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).replaceAll("[, \\[\\]]", "") + Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).toLowerCase().replaceAll("[, \\[\\]]", "");
        PLUS_CHARS_PATTERN = Pattern.compile("[+\uff0b]+");
        SEPARATOR_PATTERN = Pattern.compile("[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]+");
        CAPTURING_DIGIT_PATTERN = Pattern.compile("(\\p{Nd})");
        VALID_START_CHAR_PATTERN = Pattern.compile(VALID_START_CHAR);
        SECOND_NUMBER_START_PATTERN = Pattern.compile(SECOND_NUMBER_START);
        UNWANTED_END_CHAR_PATTERN = Pattern.compile(UNWANTED_END_CHARS);
        VALID_ALPHA_PHONE_PATTERN = Pattern.compile("(?:.*?[A-Za-z]){3}.*");
        VALID_PHONE_NUMBER = "[+\uff0b]*(?:[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]*\\p{Nd}){3,}[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e" + VALID_ALPHA + DIGITS + "]*";
        String singleExtnSymbolsForMatching = "x\uff58#\uff03~\uff5e";
        String singleExtnSymbolsForParsing = "," + singleExtnSymbolsForMatching;
        EXTN_PATTERNS_FOR_PARSING = PhoneNumberUtil.createExtnPattern(singleExtnSymbolsForParsing);
        EXTN_PATTERNS_FOR_MATCHING = PhoneNumberUtil.createExtnPattern(singleExtnSymbolsForMatching);
        EXTN_PATTERN = Pattern.compile("(?:" + EXTN_PATTERNS_FOR_PARSING + ")$", 66);
        VALID_PHONE_NUMBER_PATTERN = Pattern.compile(VALID_PHONE_NUMBER + "(?:" + EXTN_PATTERNS_FOR_PARSING + ")?", 66);
        NON_DIGITS_PATTERN = Pattern.compile("(\\D+)");
        FIRST_GROUP_PATTERN = Pattern.compile("(\\$\\d)");
        NP_PATTERN = Pattern.compile("\\$NP");
        FG_PATTERN = Pattern.compile("\\$FG");
        CC_PATTERN = Pattern.compile("\\$CC");
        instance = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Leniency {
        POSSIBLE{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                return util.isPossibleNumber(number);
            }
        }
        ,
        VALID{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                if (!util.isValidNumber(number)) {
                    return false;
                }
                return Leniency.containsOnlyValidXChars(number, candidate, util);
            }
        }
        ,
        STRICT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                if (!util.isValidNumber(number) || !Leniency.containsOnlyValidXChars(number, candidate, util) || Leniency.containsMoreThanOneSlash(candidate)) {
                    return false;
                }
                String[] formattedNumberGroups = Leniency.getNationalNumberGroups(util, number);
                StringBuilder normalizedCandidate = PhoneNumberUtil.normalizeDigits(candidate, true);
                int fromIndex = 0;
                for (int i = 0; i < formattedNumberGroups.length; ++i) {
                    if ((fromIndex = normalizedCandidate.indexOf(formattedNumberGroups[i], fromIndex)) < 0) {
                        return false;
                    }
                    if (i != 0 || (fromIndex += formattedNumberGroups[i].length()) >= normalizedCandidate.length() || !Character.isDigit(normalizedCandidate.charAt(fromIndex))) continue;
                    String nationalSignificantNumber = util.getNationalSignificantNumber(number);
                    return normalizedCandidate.substring(fromIndex - formattedNumberGroups[i].length()).startsWith(nationalSignificantNumber);
                }
                return normalizedCandidate.substring(fromIndex).contains(number.getExtension());
            }
        }
        ,
        EXACT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                int candidateNumberGroupIndex;
                if (!util.isValidNumber(number) || !Leniency.containsOnlyValidXChars(number, candidate, util) || Leniency.containsMoreThanOneSlash(candidate)) {
                    return false;
                }
                StringBuilder normalizedCandidate = PhoneNumberUtil.normalizeDigits(candidate, true);
                String[] candidateGroups = NON_DIGITS_PATTERN.split(normalizedCandidate.toString());
                int n = candidateNumberGroupIndex = number.hasExtension() ? candidateGroups.length - 2 : candidateGroups.length - 1;
                if (candidateGroups.length == 1 || candidateGroups[candidateNumberGroupIndex].contains(util.getNationalSignificantNumber(number))) {
                    return true;
                }
                String[] formattedNumberGroups = Leniency.getNationalNumberGroups(util, number);
                for (int formattedNumberGroupIndex = formattedNumberGroups.length - 1; formattedNumberGroupIndex > 0 && candidateNumberGroupIndex >= 0; --formattedNumberGroupIndex, --candidateNumberGroupIndex) {
                    if (candidateGroups[candidateNumberGroupIndex].equals(formattedNumberGroups[formattedNumberGroupIndex])) continue;
                    return false;
                }
                return candidateNumberGroupIndex >= 0 && candidateGroups[candidateNumberGroupIndex].endsWith(formattedNumberGroups[0]);
            }
        };


        private static String[] getNationalNumberGroups(PhoneNumberUtil util, Phonenumber.PhoneNumber number) {
            String rfc3966Format = util.format(number, PhoneNumberFormat.RFC3966);
            int endIndex = rfc3966Format.indexOf(59);
            if (endIndex < 0) {
                endIndex = rfc3966Format.length();
            }
            int startIndex = rfc3966Format.indexOf(45) + 1;
            return rfc3966Format.substring(startIndex, endIndex).split("-");
        }

        private static boolean containsMoreThanOneSlash(String candidate) {
            int firstSlashIndex = candidate.indexOf(47);
            return firstSlashIndex > 0 && candidate.substring(firstSlashIndex + 1).contains("/");
        }

        private static boolean containsOnlyValidXChars(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
            for (int index = 0; index < candidate.length() - 1; ++index) {
                char charAtNextIndex;
                char charAtIndex = candidate.charAt(index);
                if (charAtIndex != 'x' && charAtIndex != 'X' || !((charAtNextIndex = candidate.charAt(index + 1)) == 'x' || charAtNextIndex == 'X' ? util.isNumberMatch(number, candidate.substring(++index)) != MatchType.NSN_MATCH : !PhoneNumberUtil.normalizeDigitsOnly(candidate.substring(index)).equals(number.getExtension()))) continue;
                return false;
            }
            return true;
        }

        abstract boolean verify(Phonenumber.PhoneNumber var1, String var2, PhoneNumberUtil var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationResult {
        IS_POSSIBLE,
        INVALID_COUNTRY_CODE,
        TOO_SHORT,
        TOO_LONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        NOT_A_NUMBER,
        NO_MATCH,
        SHORT_NSN_MATCH,
        NSN_MATCH,
        EXACT_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberType {
        FIXED_LINE,
        MOBILE,
        FIXED_LINE_OR_MOBILE,
        TOLL_FREE,
        PREMIUM_RATE,
        SHARED_COST,
        VOIP,
        PERSONAL_NUMBER,
        PAGER,
        UAN,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberFormat {
        E164,
        INTERNATIONAL,
        NATIONAL,
        RFC3966;

    }
}

