/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.geocoding;

import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import com.android.i18n.phonenumbers.geocoding.DefaultMapStorage;
import com.android.i18n.phonenumbers.geocoding.FlyweightMapStorage;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaCodeMap
implements Externalizable {
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private static final Logger LOGGER = Logger.getLogger(AreaCodeMap.class.getName());
    private AreaCodeMapStorageStrategy areaCodeMapStorage;

    AreaCodeMapStorageStrategy getAreaCodeMapStorage() {
        return this.areaCodeMapStorage;
    }

    private static int getSizeOfAreaCodeMapStorage(AreaCodeMapStorageStrategy mapStorage, SortedMap<Integer, String> areaCodeMap) throws IOException {
        mapStorage.readFromSortedMap(areaCodeMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        mapStorage.writeExternal(objectOutputStream);
        objectOutputStream.flush();
        int sizeOfStorage = byteArrayOutputStream.size();
        objectOutputStream.close();
        return sizeOfStorage;
    }

    private AreaCodeMapStorageStrategy createDefaultMapStorage() {
        return new DefaultMapStorage();
    }

    private AreaCodeMapStorageStrategy createFlyweightMapStorage() {
        return new FlyweightMapStorage();
    }

    AreaCodeMapStorageStrategy getSmallerMapStorage(SortedMap<Integer, String> areaCodeMap) {
        try {
            AreaCodeMapStorageStrategy flyweightMapStorage = this.createFlyweightMapStorage();
            int sizeOfFlyweightMapStorage = AreaCodeMap.getSizeOfAreaCodeMapStorage(flyweightMapStorage, areaCodeMap);
            AreaCodeMapStorageStrategy defaultMapStorage = this.createDefaultMapStorage();
            int sizeOfDefaultMapStorage = AreaCodeMap.getSizeOfAreaCodeMapStorage(defaultMapStorage, areaCodeMap);
            return sizeOfFlyweightMapStorage < sizeOfDefaultMapStorage ? flyweightMapStorage : defaultMapStorage;
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
            return this.createFlyweightMapStorage();
        }
    }

    public void readAreaCodeMap(SortedMap<Integer, String> sortedAreaCodeMap) {
        this.areaCodeMapStorage = this.getSmallerMapStorage(sortedAreaCodeMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        boolean useFlyweightMapStorage = objectInput.readBoolean();
        this.areaCodeMapStorage = useFlyweightMapStorage ? new FlyweightMapStorage() : new DefaultMapStorage();
        this.areaCodeMapStorage.readExternal(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.areaCodeMapStorage.isFlyweight());
        this.areaCodeMapStorage.writeExternal(objectOutput);
    }

    String lookup(Phonenumber.PhoneNumber number) {
        int numOfEntries = this.areaCodeMapStorage.getNumOfEntries();
        if (numOfEntries == 0) {
            return "";
        }
        long phonePrefix = Long.parseLong(number.getCountryCode() + this.phoneUtil.getNationalSignificantNumber(number));
        int currentIndex = numOfEntries - 1;
        SortedSet<Integer> currentSetOfLengths = this.areaCodeMapStorage.getPossibleLengths();
        while (currentSetOfLengths.size() > 0) {
            Integer possibleLength = (Integer)currentSetOfLengths.last();
            String phonePrefixStr = String.valueOf(phonePrefix);
            if (phonePrefixStr.length() > possibleLength) {
                phonePrefix = Long.parseLong(phonePrefixStr.substring(0, possibleLength));
            }
            if ((currentIndex = this.binarySearch(0, currentIndex, phonePrefix)) < 0) {
                return "";
            }
            int currentPrefix = this.areaCodeMapStorage.getPrefix(currentIndex);
            if (phonePrefix == (long)currentPrefix) {
                return this.areaCodeMapStorage.getDescription(currentIndex);
            }
            currentSetOfLengths = currentSetOfLengths.headSet(possibleLength);
        }
        return "";
    }

    private int binarySearch(int start, int end, long value) {
        int current = 0;
        while (start <= end) {
            current = start + end >>> 1;
            int currentValue = this.areaCodeMapStorage.getPrefix(current);
            if ((long)currentValue == value) {
                return current;
            }
            if ((long)currentValue > value) {
                end = --current;
                continue;
            }
            start = current + 1;
        }
        return current;
    }

    public String toString() {
        return this.areaCodeMapStorage.toString();
    }
}

