/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.geocoding;

import com.android.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlyweightMapStorage
extends AreaCodeMapStorageStrategy {
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private int prefixSizeInBytes;
    private int descIndexSizeInBytes;
    private ByteBuffer phoneNumberPrefixes;
    private ByteBuffer descriptionIndexes;
    private String[] descriptionPool;

    @Override
    public boolean isFlyweight() {
        return true;
    }

    private static int getOptimalNumberOfBytesForValue(int value) {
        return value <= Short.MAX_VALUE ? 2 : 4;
    }

    private static void storeWordInBuffer(ByteBuffer buffer, int wordSize, int index, int value) {
        index *= wordSize;
        if (wordSize == 2) {
            buffer.putShort(index, (short)value);
        } else {
            buffer.putInt(index, value);
        }
    }

    private static int readWordFromBuffer(ByteBuffer buffer, int wordSize, int index) {
        return wordSize == 2 ? buffer.getShort(index) : buffer.getInt(index *= wordSize);
    }

    @Override
    public int getPrefix(int index) {
        return FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, index);
    }

    @Override
    public String getDescription(int index) {
        return this.descriptionPool[FlyweightMapStorage.readWordFromBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, index)];
    }

    @Override
    public void readFromSortedMap(SortedMap<Integer, String> sortedAreaCodeMap) {
        TreeSet<String> descriptionsSet = new TreeSet<String>();
        this.numOfEntries = sortedAreaCodeMap.size();
        this.prefixSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(sortedAreaCodeMap.lastKey());
        this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        int index = 0;
        for (Map.Entry<Integer, String> entry : sortedAreaCodeMap.entrySet()) {
            int prefix = entry.getKey();
            FlyweightMapStorage.storeWordInBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, index++, prefix);
            this.possibleLengths.add((int)Math.log10(prefix) + 1);
            descriptionsSet.add(entry.getValue());
        }
        this.descIndexSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(descriptionsSet.size() - 1);
        this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        this.descriptionPool = new String[descriptionsSet.size()];
        descriptionsSet.toArray(this.descriptionPool);
        index = 0;
        for (int i = 0; i < this.numOfEntries; ++i) {
            int prefix = FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, i);
            String description = (String)sortedAreaCodeMap.get(prefix);
            int positionInDescriptionPool = Arrays.binarySearch(this.descriptionPool, description, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            FlyweightMapStorage.storeWordInBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, index++, positionInDescriptionPool);
        }
    }

    private static void readExternalWord(ObjectInput objectInput, int wordSize, ByteBuffer outputBuffer, int index) throws IOException {
        index *= wordSize;
        if (wordSize == 2) {
            outputBuffer.putShort(index, objectInput.readShort());
        } else {
            outputBuffer.putInt(index, objectInput.readInt());
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int i;
        this.prefixSizeInBytes = objectInput.readInt();
        this.descIndexSizeInBytes = objectInput.readInt();
        int sizeOfLengths = objectInput.readInt();
        this.possibleLengths.clear();
        for (int i2 = 0; i2 < sizeOfLengths; ++i2) {
            this.possibleLengths.add(objectInput.readInt());
        }
        int descriptionPoolSize = objectInput.readInt();
        if (this.descriptionPool == null || this.descriptionPool.length < descriptionPoolSize) {
            this.descriptionPool = new String[descriptionPoolSize];
        }
        for (i = 0; i < descriptionPoolSize; ++i) {
            String description;
            this.descriptionPool[i] = description = objectInput.readUTF();
        }
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.capacity() < this.numOfEntries) {
            this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        }
        if (this.descriptionIndexes == null || this.descriptionIndexes.capacity() < this.numOfEntries) {
            this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        }
        for (i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.readExternalWord(objectInput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.readExternalWord(objectInput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }

    private static void writeExternalWord(ObjectOutput objectOutput, int wordSize, ByteBuffer inputBuffer, int index) throws IOException {
        index *= wordSize;
        if (wordSize == 2) {
            objectOutput.writeShort(inputBuffer.getShort(index));
        } else {
            objectOutput.writeInt(inputBuffer.getInt(index));
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.prefixSizeInBytes);
        objectOutput.writeInt(this.descIndexSizeInBytes);
        int sizeOfLengths = this.possibleLengths.size();
        objectOutput.writeInt(sizeOfLengths);
        for (Integer length : this.possibleLengths) {
            objectOutput.writeInt(length);
        }
        objectOutput.writeInt(this.descriptionPool.length);
        for (String description : this.descriptionPool) {
            objectOutput.writeUTF(description);
        }
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.writeExternalWord(objectOutput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.writeExternalWord(objectOutput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }
}

