/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.geocoding;

import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.AreaCodeMap;
import com.android.i18n.phonenumbers.geocoding.MappingFileProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberOfflineGeocoder {
    private static PhoneNumberOfflineGeocoder instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/android/i18n/phonenumbers/geocoding/data/";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberOfflineGeocoder.class.getName());
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private final String phonePrefixDataDirectory;
    private MappingFileProvider mappingFileProvider = new MappingFileProvider();
    private Map<String, AreaCodeMap> availablePhonePrefixMaps = new HashMap<String, AreaCodeMap>();

    PhoneNumberOfflineGeocoder(String phonePrefixDataDirectory) {
        this.phonePrefixDataDirectory = phonePrefixDataDirectory;
        this.loadMappingFileProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappingFileProvider() {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + "config");
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            this.mappingFileProvider.readExternal(in);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
        finally {
            this.close(in);
        }
    }

    private AreaCodeMap getPhonePrefixDescriptions(int countryCallingCode, String language, String script, String region) {
        String fileName = this.mappingFileProvider.getFileName(countryCallingCode, language, script, region);
        if (fileName.length() == 0) {
            return null;
        }
        if (!this.availablePhonePrefixMaps.containsKey(fileName)) {
            this.loadAreaCodeMapFromFile(fileName);
        }
        return this.availablePhonePrefixMaps.get(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAreaCodeMapFromFile(String fileName) {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + fileName);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            AreaCodeMap map = new AreaCodeMap();
            map.readExternal(in);
            this.availablePhonePrefixMaps.put(fileName, map);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
        finally {
            this.close(in);
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    public static synchronized PhoneNumberOfflineGeocoder getInstance() {
        if (instance == null) {
            instance = new PhoneNumberOfflineGeocoder(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    private String getCountryNameForNumber(Phonenumber.PhoneNumber number, Locale language) {
        String regionCode = this.phoneUtil.getRegionCodeForNumber(number);
        return regionCode == null || regionCode.equals("ZZ") ? "" : new Locale("", regionCode).getDisplayCountry(language);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String regionStr;
        String scriptStr;
        String langStr = languageCode.getLanguage();
        String areaDescription = this.getAreaDescriptionForNumber(number, langStr, scriptStr = "", regionStr = languageCode.getCountry());
        return areaDescription.length() > 0 ? areaDescription : this.getCountryNameForNumber(number, languageCode);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        if (!this.phoneUtil.isValidNumber(number)) {
            return "";
        }
        return this.getDescriptionForValidNumber(number, languageCode);
    }

    private String getAreaDescriptionForNumber(Phonenumber.PhoneNumber number, String lang, String script, String region) {
        int countryCallingCode = number.getCountryCode();
        int phonePrefix = countryCallingCode != 1 ? countryCallingCode : 1000 + (int)(number.getNationalNumber() / 10000000L);
        AreaCodeMap phonePrefixDescriptions = this.getPhonePrefixDescriptions(phonePrefix, lang, script, region);
        return phonePrefixDescriptions != null ? phonePrefixDescriptions.lookup(number) : "";
    }
}

