/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.LoginFilter;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.widget.LockPatternUtils;

public class AccountUnlockScreen
extends RelativeLayout
implements KeyguardScreen,
View.OnClickListener,
TextWatcher {
    private static final String LOCK_PATTERN_PACKAGE = "com.android.settings";
    private static final String LOCK_PATTERN_CLASS = "com.android.settings.ChooseLockGeneric";
    private static final int AWAKE_POKE_MILLIS = 30000;
    private KeyguardScreenCallback mCallback;
    private LockPatternUtils mLockPatternUtils;
    private KeyguardUpdateMonitor mUpdateMonitor;
    private TextView mTopHeader;
    private TextView mInstructions;
    private EditText mLogin;
    private EditText mPassword;
    private Button mOk;
    private ProgressDialog mCheckingDialog;
    private KeyguardStatusViewManager mKeyguardStatusViewManager;

    public AccountUnlockScreen(Context context, Configuration configuration, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback, LockPatternUtils lockPatternUtils) {
        super(context);
        this.mCallback = callback;
        this.mLockPatternUtils = lockPatternUtils;
        LayoutInflater.from((Context)context).inflate(17367116, (ViewGroup)this, true);
        this.mTopHeader = (TextView)this.findViewById(16908929);
        this.mTopHeader.setText(this.mLockPatternUtils.isPermanentlyLocked() ? 17040129 : 17040128);
        this.mInstructions = (TextView)this.findViewById(16908931);
        this.mLogin = (EditText)this.findViewById(16908932);
        this.mLogin.setFilters(new InputFilter[]{new LoginFilter.UsernameFilterGeneric()});
        this.mLogin.addTextChangedListener((TextWatcher)this);
        this.mPassword = (EditText)this.findViewById(16908933);
        this.mPassword.addTextChangedListener((TextWatcher)this);
        this.mOk = (Button)this.findViewById(16908934);
        this.mOk.setOnClickListener((View.OnClickListener)this);
        this.mUpdateMonitor = updateMonitor;
        this.mKeyguardStatusViewManager = new KeyguardStatusViewManager((View)this, updateMonitor, lockPatternUtils, callback, true);
    }

    public void afterTextChanged(Editable s) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.mCallback.pokeWakelock(30000);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        return this.mLogin.requestFocus(direction, previouslyFocusedRect);
    }

    public boolean needsInput() {
        return true;
    }

    public void onPause() {
        this.mKeyguardStatusViewManager.onPause();
    }

    public void onResume() {
        this.mLogin.setText((CharSequence)"");
        this.mPassword.setText((CharSequence)"");
        this.mLogin.requestFocus();
        this.mKeyguardStatusViewManager.onResume();
    }

    public void cleanUp() {
        if (this.mCheckingDialog != null) {
            this.mCheckingDialog.hide();
        }
        this.mUpdateMonitor.removeCallback(this);
        this.mCallback = null;
        this.mLockPatternUtils = null;
        this.mUpdateMonitor = null;
    }

    public void onClick(View v) {
        this.mCallback.pokeWakelock();
        if (v == this.mOk) {
            this.asyncCheckPassword();
        }
    }

    private void postOnCheckPasswordResult(final boolean success) {
        this.mLogin.post(new Runnable(){

            public void run() {
                if (success) {
                    AccountUnlockScreen.this.mLockPatternUtils.setPermanentlyLocked(false);
                    AccountUnlockScreen.this.mLockPatternUtils.setLockPatternEnabled(false);
                    AccountUnlockScreen.this.mLockPatternUtils.saveLockPattern(null);
                    Intent intent = new Intent();
                    intent.setClassName(AccountUnlockScreen.LOCK_PATTERN_PACKAGE, AccountUnlockScreen.LOCK_PATTERN_CLASS);
                    intent.setFlags(0x10000000);
                    AccountUnlockScreen.this.mContext.startActivity(intent);
                    AccountUnlockScreen.this.mCallback.reportSuccessfulUnlockAttempt();
                    AccountUnlockScreen.this.mCallback.keyguardDone(true);
                } else {
                    AccountUnlockScreen.this.mInstructions.setText(17040134);
                    AccountUnlockScreen.this.mPassword.setText((CharSequence)"");
                    AccountUnlockScreen.this.mCallback.reportFailedUnlockAttempt();
                }
            }
        });
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 0 && event.getKeyCode() == 4) {
            if (this.mLockPatternUtils.isPermanentlyLocked()) {
                this.mCallback.goToLockScreen();
            } else {
                this.mCallback.forgotPattern(false);
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    private Account findIntendedAccount(String username) {
        Account[] accounts = AccountManager.get((Context)this.mContext).getAccountsByType("com.google");
        Account bestAccount = null;
        int bestScore = 0;
        for (Account a : accounts) {
            int i;
            int score = 0;
            if (username.equals(a.name)) {
                score = 4;
            } else if (username.equalsIgnoreCase(a.name)) {
                score = 3;
            } else if (username.indexOf(64) < 0 && (i = a.name.indexOf(64)) >= 0) {
                String aUsername = a.name.substring(0, i);
                if (username.equals(aUsername)) {
                    score = 2;
                } else if (username.equalsIgnoreCase(aUsername)) {
                    score = 1;
                }
            }
            if (score > bestScore) {
                bestAccount = a;
                bestScore = score;
                continue;
            }
            if (score != bestScore) continue;
            bestAccount = null;
        }
        return bestAccount;
    }

    private void asyncCheckPassword() {
        this.mCallback.pokeWakelock(30000);
        String login = this.mLogin.getText().toString();
        String password = this.mPassword.getText().toString();
        Account account = this.findIntendedAccount(login);
        if (account == null) {
            this.postOnCheckPasswordResult(false);
            return;
        }
        this.getProgressDialog().show();
        Bundle options = new Bundle();
        options.putString("password", password);
        AccountManager.get((Context)this.mContext).confirmCredentials(account, options, null, (AccountManagerCallback)new AccountManagerCallback<Bundle>(){

            /*
             * Exception decompiling
             */
            public void run(AccountManagerFuture<Bundle> future) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, null);
    }

    private Dialog getProgressDialog() {
        if (this.mCheckingDialog == null) {
            this.mCheckingDialog = new ProgressDialog(this.mContext);
            this.mCheckingDialog.setMessage((CharSequence)this.mContext.getString(17040136));
            this.mCheckingDialog.setIndeterminate(true);
            this.mCheckingDialog.setCancelable(false);
            this.mCheckingDialog.getWindow().setType(2009);
        }
        return this.mCheckingDialog;
    }

    static /* synthetic */ void access$500(AccountUnlockScreen x0, boolean x1) {
        x0.postOnCheckPasswordResult(x1);
    }

    static /* synthetic */ EditText access$700(AccountUnlockScreen x0) {
        return x0.mLogin;
    }
}

