/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.android.internal.app.ShutdownThread;
import java.util.ArrayList;

class GlobalActions
implements DialogInterface.OnDismissListener,
DialogInterface.OnClickListener {
    private static final String TAG = "GlobalActions";
    private static final boolean SHOW_SILENT_TOGGLE = true;
    private final Context mContext;
    private final AudioManager mAudioManager;
    private ArrayList<Action> mItems;
    private AlertDialog mDialog;
    private SilentModeAction mSilentModeAction;
    private ToggleAction mAirplaneModeOn;
    private MyAdapter mAdapter;
    private boolean mKeyguardShowing = false;
    private boolean mDeviceProvisioned = false;
    private ToggleAction.State mAirplaneState = ToggleAction.State.Off;
    private boolean mIsWaitingForEcmExit = false;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "android.intent.action.SCREEN_OFF".equals(action)) {
                String reason = intent.getStringExtra("reason");
                if (!"globalactions".equals(reason)) {
                    GlobalActions.this.mHandler.sendEmptyMessage(0);
                }
            } else if ("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED".equals(action) && !intent.getBooleanExtra("PHONE_IN_ECM_STATE", false) && GlobalActions.this.mIsWaitingForEcmExit) {
                GlobalActions.this.mIsWaitingForEcmExit = false;
                GlobalActions.this.changeAirplaneModeSystemSetting(true);
            }
        }
    };
    PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onServiceStateChanged(ServiceState serviceState) {
            boolean inAirplaneMode = serviceState.getState() == 3;
            GlobalActions.this.mAirplaneState = inAirplaneMode ? ToggleAction.State.On : ToggleAction.State.Off;
            GlobalActions.this.mAirplaneModeOn.updateState(GlobalActions.this.mAirplaneState);
            GlobalActions.this.mAdapter.notifyDataSetChanged();
        }
    };
    private BroadcastReceiver mRingerModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                GlobalActions.this.mHandler.sendEmptyMessage(1);
            }
        }
    };
    private static final int MESSAGE_DISMISS = 0;
    private static final int MESSAGE_REFRESH = 1;
    private static final int DIALOG_DISMISS_DELAY = 300;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                if (GlobalActions.this.mDialog != null) {
                    GlobalActions.this.mDialog.dismiss();
                }
            } else if (msg.what == 1) {
                GlobalActions.this.mAdapter.notifyDataSetChanged();
            }
        }
    };

    public GlobalActions(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        telephonyManager.listen(this.mPhoneStateListener, 1);
    }

    public void showDialog(boolean keyguardShowing, boolean isDeviceProvisioned) {
        this.mKeyguardShowing = keyguardShowing;
        this.mDeviceProvisioned = isDeviceProvisioned;
        if (this.mDialog == null) {
            this.mDialog = this.createDialog();
        }
        this.prepareDialog();
        this.mDialog.show();
        this.mDialog.getWindow().getDecorView().setSystemUiVisibility(65536);
    }

    private AlertDialog createDialog() {
        this.mSilentModeAction = new SilentModeAction(this.mAudioManager, this.mHandler);
        this.mAirplaneModeOn = new ToggleAction(17302222, 17302223, 17039667, 17039668, 17039669){

            void onToggle(boolean on) {
                if (Boolean.parseBoolean(SystemProperties.get((String)"ril.cdma.inecmmode"))) {
                    GlobalActions.this.mIsWaitingForEcmExit = true;
                    Intent ecmDialogIntent = new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null);
                    ecmDialogIntent.addFlags(0x10000000);
                    GlobalActions.this.mContext.startActivity(ecmDialogIntent);
                } else {
                    GlobalActions.this.changeAirplaneModeSystemSetting(on);
                }
            }

            protected void changeStateFromPress(boolean buttonOn) {
                if (!Boolean.parseBoolean(SystemProperties.get((String)"ril.cdma.inecmmode"))) {
                    this.mState = buttonOn ? ToggleAction.State.TurningOn : ToggleAction.State.TurningOff;
                    GlobalActions.this.mAirplaneState = this.mState;
                }
            }

            public boolean showDuringKeyguard() {
                return true;
            }

            public boolean showBeforeProvisioning() {
                return false;
            }
        };
        this.mItems = new ArrayList();
        this.mItems.add(new SinglePressAction(17301552, 17039663){

            public void onPress() {
                ShutdownThread.shutdown((Context)GlobalActions.this.mContext, (boolean)true);
            }

            public boolean showDuringKeyguard() {
                return true;
            }

            public boolean showBeforeProvisioning() {
                return true;
            }
        });
        this.mItems.add(this.mAirplaneModeOn);
        this.mItems.add(this.mSilentModeAction);
        this.mAdapter = new MyAdapter();
        AlertDialog.Builder ab = new AlertDialog.Builder(this.mContext);
        ab.setAdapter((ListAdapter)this.mAdapter, (DialogInterface.OnClickListener)this).setInverseBackgroundForced(true);
        AlertDialog dialog = ab.create();
        dialog.getListView().setItemsCanFocus(true);
        dialog.getWindow().setType(2008);
        dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        return dialog;
    }

    private void prepareDialog() {
        boolean silentModeOn = this.mAudioManager.getRingerMode() != 2;
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
        this.mAdapter.notifyDataSetChanged();
        if (this.mKeyguardShowing) {
            this.mDialog.getWindow().setType(2009);
        } else {
            this.mDialog.getWindow().setType(2008);
        }
        IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
        this.mContext.registerReceiver(this.mRingerModeReceiver, filter);
    }

    public void onDismiss(DialogInterface dialog) {
        this.mContext.unregisterReceiver(this.mRingerModeReceiver);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (!(this.mAdapter.getItem(which) instanceof SilentModeAction)) {
            dialog.dismiss();
        }
        this.mAdapter.getItem(which).onPress();
    }

    private void changeAirplaneModeSystemSetting(boolean on) {
        Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)(on ? 1 : 0));
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.addFlags(0x20000000);
        intent.putExtra("state", on);
        this.mContext.sendBroadcast(intent);
    }

    private static class SilentModeAction
    implements Action,
    View.OnClickListener {
        private final int[] ITEM_IDS = new int[]{16908900, 16908901, 16908902};
        private final AudioManager mAudioManager;
        private final Handler mHandler;

        SilentModeAction(AudioManager audioManager, Handler handler) {
            this.mAudioManager = audioManager;
            this.mHandler = handler;
        }

        private int ringerModeToIndex(int ringerMode) {
            return ringerMode;
        }

        private int indexToRingerMode(int index) {
            return index;
        }

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367105, parent, false);
            int selectedIndex = this.ringerModeToIndex(this.mAudioManager.getRingerMode());
            for (int i = 0; i < 3; ++i) {
                View itemView = v.findViewById(this.ITEM_IDS[i]);
                itemView.setSelected(selectedIndex == i);
                itemView.setTag((Object)i);
                itemView.setOnClickListener((View.OnClickListener)this);
            }
            return v;
        }

        public void onPress() {
        }

        public boolean showDuringKeyguard() {
            return true;
        }

        public boolean showBeforeProvisioning() {
            return false;
        }

        public boolean isEnabled() {
            return true;
        }

        void willCreate() {
        }

        public void onClick(View v) {
            if (!(v.getTag() instanceof Integer)) {
                return;
            }
            int index = (Integer)v.getTag();
            this.mAudioManager.setRingerMode(this.indexToRingerMode(index));
            this.mHandler.sendEmptyMessageDelayed(0, 300L);
        }
    }

    private static abstract class ToggleAction
    implements Action {
        protected State mState = State.Off;
        protected int mEnabledIconResId;
        protected int mDisabledIconResid;
        protected int mMessageResId;
        protected int mEnabledStatusMessageResId;
        protected int mDisabledStatusMessageResId;

        public ToggleAction(int enabledIconResId, int disabledIconResid, int essage, int enabledStatusMessageResId, int disabledStatusMessageResId) {
            this.mEnabledIconResId = enabledIconResId;
            this.mDisabledIconResid = disabledIconResid;
            this.mMessageResId = essage;
            this.mEnabledStatusMessageResId = enabledStatusMessageResId;
            this.mDisabledStatusMessageResId = disabledStatusMessageResId;
        }

        void willCreate() {
        }

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            boolean on;
            this.willCreate();
            View v = inflater.inflate(17367104, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16908899);
            boolean enabled = this.isEnabled();
            if (messageView != null) {
                messageView.setText(this.mMessageResId);
                messageView.setEnabled(enabled);
            }
            boolean bl = on = this.mState == State.On || this.mState == State.TurningOn;
            if (icon != null) {
                icon.setImageDrawable(context.getResources().getDrawable(on ? this.mEnabledIconResId : this.mDisabledIconResid));
                icon.setEnabled(enabled);
            }
            if (statusView != null) {
                statusView.setText(on ? this.mEnabledStatusMessageResId : this.mDisabledStatusMessageResId);
                statusView.setVisibility(0);
                statusView.setEnabled(enabled);
            }
            v.setEnabled(enabled);
            return v;
        }

        public final void onPress() {
            if (this.mState.inTransition()) {
                Log.w((String)GlobalActions.TAG, (String)"shouldn't be able to toggle when in transition");
                return;
            }
            boolean nowOn = this.mState != State.On;
            this.onToggle(nowOn);
            this.changeStateFromPress(nowOn);
        }

        public boolean isEnabled() {
            return !this.mState.inTransition();
        }

        protected void changeStateFromPress(boolean buttonOn) {
            this.mState = buttonOn ? State.On : State.Off;
        }

        abstract void onToggle(boolean var1);

        public void updateState(State state) {
            this.mState = state;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            Off(false),
            TurningOn(true),
            TurningOff(true),
            On(false);

            private final boolean inTransition;

            private State(boolean intermediate) {
                this.inTransition = intermediate;
            }

            public boolean inTransition() {
                return this.inTransition;
            }
        }
    }

    private static abstract class SinglePressAction
    implements Action {
        private final int mIconResId;
        private final int mMessageResId;

        protected SinglePressAction(int iconResId, int messageResId) {
            this.mIconResId = iconResId;
            this.mMessageResId = messageResId;
        }

        public boolean isEnabled() {
            return true;
        }

        public abstract void onPress();

        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367104, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            v.findViewById(16908899).setVisibility(8);
            icon.setImageDrawable(context.getResources().getDrawable(this.mIconResId));
            messageView.setText(this.mMessageResId);
            return v;
        }
    }

    private static interface Action {
        public View create(Context var1, View var2, ViewGroup var3, LayoutInflater var4);

        public void onPress();

        public boolean showDuringKeyguard();

        public boolean showBeforeProvisioning();

        public boolean isEnabled();
    }

    private class MyAdapter
    extends BaseAdapter {
        private MyAdapter() {
        }

        public int getCount() {
            int count = 0;
            for (int i = 0; i < GlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)GlobalActions.this.mItems.get(i);
                if (GlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !GlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                ++count;
            }
            return count;
        }

        public boolean isEnabled(int position) {
            return this.getItem(position).isEnabled();
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public Action getItem(int position) {
            int filteredPos = 0;
            for (int i = 0; i < GlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)GlobalActions.this.mItems.get(i);
                if (GlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !GlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                if (filteredPos == position) {
                    return action;
                }
                ++filteredPos;
            }
            throw new IllegalArgumentException("position " + position + " out of range of showable actions" + ", filtered count=" + this.getCount() + ", keyguardshowing=" + GlobalActions.this.mKeyguardShowing + ", provisioned=" + GlobalActions.this.mDeviceProvisioned);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Action action = this.getItem(position);
            return action.create(GlobalActions.this.mContext, convertView, parent, LayoutInflater.from((Context)GlobalActions.this.mContext));
        }
    }
}

