/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.telephony.IccCard;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.TransportControlView;
import java.util.ArrayList;
import java.util.Date;
import libcore.util.MutableInt;

class KeyguardStatusViewManager
implements View.OnClickListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "KeyguardStatusView";
    public static final int LOCK_ICON = 0;
    public static final int ALARM_ICON = 17301550;
    public static final int CHARGING_ICON = 0;
    public static final int BATTERY_LOW_ICON = 0;
    private static final long INSTRUCTION_RESET_DELAY = 2000L;
    private static final int INSTRUCTION_TEXT = 10;
    private static final int CARRIER_TEXT = 11;
    private static final int CARRIER_HELP_TEXT = 12;
    private static final int HELP_MESSAGE_TEXT = 13;
    private static final int OWNER_INFO = 14;
    private static final int BATTERY_INFO = 15;
    private StatusMode mStatus;
    private String mDateFormatString;
    private TransientTextManager mTransientTextManager;
    private TextView mCarrierView;
    private TextView mDateView;
    private TextView mStatus1View;
    private TextView mOwnerInfoView;
    private TextView mAlarmStatusView;
    private TransportControlView mTransportView;
    private View mContainer;
    private boolean mShowingBatteryInfo = false;
    private boolean mPluggedIn = false;
    private int mBatteryLevel = 100;
    protected IccCard.State mSimState;
    private LockPatternUtils mLockPatternUtils;
    private KeyguardUpdateMonitor mUpdateMonitor;
    private Button mEmergencyCallButton;
    private boolean mEmergencyButtonEnabledBecauseSimLocked;
    private CharSequence mCarrierText;
    private CharSequence mCarrierHelpText;
    private String mHelpMessageText;
    private String mInstructionText;
    private CharSequence mOwnerInfoText;
    private boolean mShowingStatus;
    private KeyguardScreenCallback mCallback;
    private final boolean mEmergencyCallButtonEnabledInScreen;
    private CharSequence mPlmn;
    private CharSequence mSpn;
    protected int mPhoneState;
    private KeyguardUpdateMonitor.InfoCallback mInfoCallback = new KeyguardUpdateMonitor.InfoCallback(){

        public void onRefreshBatteryInfo(boolean showBatteryInfo, boolean pluggedIn, int batteryLevel) {
            KeyguardStatusViewManager.this.mShowingBatteryInfo = showBatteryInfo;
            KeyguardStatusViewManager.this.mPluggedIn = pluggedIn;
            KeyguardStatusViewManager.this.mBatteryLevel = batteryLevel;
            MutableInt tmpIcon = new MutableInt(0);
            KeyguardStatusViewManager.this.update(15, KeyguardStatusViewManager.this.getAltTextMessage(tmpIcon));
        }

        public void onTimeChanged() {
            KeyguardStatusViewManager.this.refreshDate();
        }

        public void onRefreshCarrierInfo(CharSequence plmn, CharSequence spn) {
            KeyguardStatusViewManager.this.mPlmn = plmn;
            KeyguardStatusViewManager.this.mSpn = spn;
            KeyguardStatusViewManager.this.updateCarrierStateWithSimStatus(KeyguardStatusViewManager.this.mSimState);
        }

        public void onRingerModeChanged(int state) {
        }

        public void onPhoneStateChanged(int phoneState) {
            KeyguardStatusViewManager.this.mPhoneState = phoneState;
            KeyguardStatusViewManager.this.updateEmergencyCallButtonState(phoneState);
        }

        public void onClockVisibilityChanged() {
        }

        public void onDeviceProvisioned() {
        }
    };
    private KeyguardUpdateMonitor.SimStateCallback mSimStateCallback = new KeyguardUpdateMonitor.SimStateCallback(){

        public void onSimStateChanged(IccCard.State simState) {
            KeyguardStatusViewManager.this.updateCarrierStateWithSimStatus(simState);
        }
    };

    public KeyguardStatusViewManager(View view, KeyguardUpdateMonitor updateMonitor, LockPatternUtils lockPatternUtils, KeyguardScreenCallback callback, boolean emergencyButtonEnabledInScreen) {
        View[] scrollableViews;
        this.mContainer = view;
        this.mDateFormatString = this.getContext().getString(17039536);
        this.mLockPatternUtils = lockPatternUtils;
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mCarrierView = (TextView)this.findViewById(16908953);
        this.mDateView = (TextView)this.findViewById(16908387);
        this.mStatus1View = (TextView)this.findViewById(16908952);
        this.mAlarmStatusView = (TextView)this.findViewById(16908951);
        this.mOwnerInfoView = (TextView)this.findViewById(16908971);
        this.mTransportView = (TransportControlView)this.findViewById(16908957);
        this.mEmergencyCallButton = (Button)this.findViewById(16908928);
        this.mEmergencyCallButtonEnabledInScreen = emergencyButtonEnabledInScreen;
        if (this.mTransportView != null) {
            this.mTransportView.setVisibility(8);
        }
        if (this.mEmergencyCallButton != null) {
            this.mEmergencyCallButton.setText(17040095);
            this.mEmergencyCallButton.setOnClickListener((View.OnClickListener)this);
            this.mEmergencyCallButton.setFocusable(false);
        }
        this.mTransientTextManager = new TransientTextManager(this.mCarrierView);
        this.mUpdateMonitor.registerInfoCallback(this.mInfoCallback);
        this.mUpdateMonitor.registerSimStateCallback(this.mSimStateCallback);
        this.resetStatusInfo();
        this.refreshDate();
        this.updateOwnerInfo();
        for (View v : scrollableViews = new View[]{this.mCarrierView, this.mDateView, this.mStatus1View, this.mOwnerInfoView, this.mAlarmStatusView}) {
            if (v == null) continue;
            v.setSelected(true);
        }
    }

    private boolean inWidgetMode() {
        return this.mTransportView != null && this.mTransportView.getVisibility() == 0;
    }

    void setInstructionText(String string) {
        this.mInstructionText = string;
        this.update(10, string);
    }

    void setCarrierText(CharSequence string) {
        this.mCarrierText = string;
        this.update(11, string);
    }

    void setOwnerInfo(CharSequence string) {
        this.mOwnerInfoText = string;
        this.update(14, string);
    }

    public void setCarrierHelpText(int resId) {
        this.mCarrierHelpText = this.getText(resId);
        this.update(12, this.mCarrierHelpText);
    }

    private CharSequence getText(int resId) {
        return resId == 0 ? null : this.getContext().getText(resId);
    }

    public void setHelpMessage(int textResId, int lockIcon) {
        CharSequence tmp = this.getText(textResId);
        this.mHelpMessageText = tmp == null ? null : ((Object)tmp).toString();
        this.update(13, this.mHelpMessageText);
    }

    private void update(int what, CharSequence string) {
        if (this.inWidgetMode()) {
            switch (what) {
                case 10: 
                case 12: 
                case 13: 
                case 15: {
                    this.mTransientTextManager.post(string, 0, 2000L);
                    break;
                }
            }
        } else {
            this.updateStatusLines(this.mShowingStatus);
        }
    }

    public void onPause() {
        this.mUpdateMonitor.removeCallback(this.mInfoCallback);
        this.mUpdateMonitor.removeCallback(this.mSimStateCallback);
    }

    public void onResume() {
        this.mUpdateMonitor.registerInfoCallback(this.mInfoCallback);
        this.mUpdateMonitor.registerSimStateCallback(this.mSimStateCallback);
        this.resetStatusInfo();
    }

    void resetStatusInfo() {
        this.mInstructionText = null;
        this.mShowingBatteryInfo = this.mUpdateMonitor.shouldShowBatteryInfo();
        this.mPluggedIn = this.mUpdateMonitor.isDevicePluggedIn();
        this.mBatteryLevel = this.mUpdateMonitor.getBatteryLevel();
        this.updateStatusLines(true);
    }

    void updateStatusLines(boolean showStatusLines) {
        this.mShowingStatus = showStatusLines;
        this.updateAlarmInfo();
        this.updateOwnerInfo();
        this.updateStatus1();
        this.updateCarrierText();
    }

    private void updateAlarmInfo() {
        if (this.mAlarmStatusView != null) {
            String nextAlarm = this.mLockPatternUtils.getNextAlarm();
            boolean showAlarm = this.mShowingStatus && !TextUtils.isEmpty((CharSequence)nextAlarm);
            this.mAlarmStatusView.setText((CharSequence)nextAlarm);
            this.mAlarmStatusView.setCompoundDrawablesWithIntrinsicBounds(17301550, 0, 0, 0);
            this.mAlarmStatusView.setVisibility(showAlarm ? 0 : 8);
        }
    }

    private void updateOwnerInfo() {
        ContentResolver res = this.getContext().getContentResolver();
        boolean ownerInfoEnabled = Settings.Secure.getInt((ContentResolver)res, (String)"lock_screen_owner_info_enabled", (int)1) != 0;
        CharSequence charSequence = this.mOwnerInfoText = ownerInfoEnabled ? Settings.Secure.getString((ContentResolver)res, (String)"lock_screen_owner_info") : null;
        if (this.mOwnerInfoView != null) {
            this.mOwnerInfoView.setText(this.mOwnerInfoText);
            this.mOwnerInfoView.setVisibility(TextUtils.isEmpty((CharSequence)this.mOwnerInfoText) ? 8 : 0);
        }
    }

    private void updateStatus1() {
        if (this.mStatus1View != null) {
            MutableInt icon = new MutableInt(0);
            CharSequence string = this.getPriorityTextMessage(icon);
            this.mStatus1View.setText(string);
            this.mStatus1View.setCompoundDrawablesWithIntrinsicBounds(icon.value, 0, 0, 0);
            this.mStatus1View.setVisibility(this.mShowingStatus ? 0 : 4);
        }
    }

    private void updateCarrierText() {
        if (!this.inWidgetMode() && this.mCarrierView != null) {
            this.mCarrierView.setText(this.mCarrierText);
        }
    }

    private CharSequence getAltTextMessage(MutableInt icon) {
        CharSequence string = null;
        if (this.mShowingBatteryInfo) {
            if (this.mPluggedIn) {
                string = this.mUpdateMonitor.isDeviceCharged() ? this.getContext().getString(17040101) : this.getContext().getString(17040100, new Object[]{this.mBatteryLevel});
                icon.value = 0;
            } else if (this.mBatteryLevel < 20) {
                string = this.getContext().getString(17040103);
                icon.value = 0;
            }
        } else {
            string = this.mCarrierText;
        }
        return string;
    }

    private CharSequence getPriorityTextMessage(MutableInt icon) {
        CharSequence string = null;
        if (!TextUtils.isEmpty((CharSequence)this.mInstructionText)) {
            string = this.mInstructionText;
            icon.value = 0;
        } else if (this.mShowingBatteryInfo) {
            if (this.mPluggedIn) {
                string = this.mUpdateMonitor.isDeviceCharged() ? this.getContext().getString(17040101) : this.getContext().getString(17040100, new Object[]{this.mBatteryLevel});
                icon.value = 0;
            } else if (this.mBatteryLevel < 20) {
                string = this.getContext().getString(17040103);
                icon.value = 0;
            }
        } else if (!this.inWidgetMode() && this.mOwnerInfoView == null && this.mOwnerInfoText != null) {
            string = this.mOwnerInfoText;
        }
        return string;
    }

    void refreshDate() {
        if (this.mDateView != null) {
            this.mDateView.setText(DateFormat.format((CharSequence)this.mDateFormatString, (Date)new Date()));
        }
    }

    public StatusMode getStatusForIccState(IccCard.State simState) {
        if (simState == null) {
            return StatusMode.Normal;
        }
        boolean missingAndNotProvisioned = !this.mUpdateMonitor.isDeviceProvisioned() && (simState == IccCard.State.ABSENT || simState == IccCard.State.PERM_DISABLED);
        simState = missingAndNotProvisioned ? IccCard.State.NETWORK_LOCKED : simState;
        switch (simState) {
            case ABSENT: {
                return StatusMode.SimMissing;
            }
            case NETWORK_LOCKED: {
                return StatusMode.SimMissingLocked;
            }
            case NOT_READY: {
                return StatusMode.SimMissing;
            }
            case PIN_REQUIRED: {
                return StatusMode.SimLocked;
            }
            case PUK_REQUIRED: {
                return StatusMode.SimPukLocked;
            }
            case READY: {
                return StatusMode.Normal;
            }
            case PERM_DISABLED: {
                return StatusMode.SimPermDisabled;
            }
            case UNKNOWN: {
                return StatusMode.SimMissing;
            }
        }
        return StatusMode.SimMissing;
    }

    private Context getContext() {
        return this.mContainer.getContext();
    }

    private void updateCarrierStateWithSimStatus(IccCard.State simState) {
        CharSequence carrierText = null;
        int carrierHelpTextId = 0;
        this.mEmergencyButtonEnabledBecauseSimLocked = false;
        this.mStatus = this.getStatusForIccState(simState);
        this.mSimState = simState;
        switch (this.mStatus) {
            case Normal: {
                carrierText = KeyguardStatusViewManager.makeCarierString(this.mPlmn, this.mSpn);
                break;
            }
            case NetworkLocked: {
                carrierText = KeyguardStatusViewManager.makeCarierString(this.mPlmn, this.getContext().getText(17040115));
                carrierHelpTextId = 17040093;
                break;
            }
            case SimMissing: {
                carrierText = this.getContext().getText(17040104);
                if (this.mLockPatternUtils.isEmergencyCallCapable()) {
                    carrierText = KeyguardStatusViewManager.makeCarierString(carrierText, this.mPlmn);
                }
                carrierHelpTextId = 17040107;
                break;
            }
            case SimPermDisabled: {
                carrierText = this.getContext().getText(17040104);
                carrierHelpTextId = 17040108;
                this.mEmergencyButtonEnabledBecauseSimLocked = true;
                break;
            }
            case SimMissingLocked: {
                carrierText = KeyguardStatusViewManager.makeCarierString(this.mPlmn, this.getContext().getText(17040104));
                carrierHelpTextId = 17040106;
                this.mEmergencyButtonEnabledBecauseSimLocked = true;
                break;
            }
            case SimLocked: {
                carrierText = KeyguardStatusViewManager.makeCarierString(this.mPlmn, this.getContext().getText(17040118));
                this.mEmergencyButtonEnabledBecauseSimLocked = true;
                break;
            }
            case SimPukLocked: {
                carrierText = KeyguardStatusViewManager.makeCarierString(this.mPlmn, this.getContext().getText(17040116));
                if (this.mLockPatternUtils.isPukUnlockScreenEnable()) break;
                this.mEmergencyButtonEnabledBecauseSimLocked = true;
            }
        }
        this.setCarrierText(carrierText);
        this.setCarrierHelpText(carrierHelpTextId);
        this.updateEmergencyCallButtonState(this.mPhoneState);
    }

    private View findViewById(int id) {
        return this.mContainer.findViewById(id);
    }

    private void updateEmergencyCallButtonState(int phoneState) {
        if (this.mEmergencyCallButton != null) {
            boolean enabledBecauseSimLocked = this.mLockPatternUtils.isEmergencyCallEnabledWhileSimLocked() && this.mEmergencyButtonEnabledBecauseSimLocked;
            boolean shown = this.mEmergencyCallButtonEnabledInScreen || enabledBecauseSimLocked;
            this.mLockPatternUtils.updateEmergencyCallButtonState(this.mEmergencyCallButton, phoneState, shown);
        }
    }

    public void onClick(View v) {
        if (v == this.mEmergencyCallButton) {
            this.mCallback.takeEmergencyCallAction();
        }
    }

    private static CharSequence makeCarierString(CharSequence plmn, CharSequence spn) {
        boolean spnValid;
        boolean plmnValid = !TextUtils.isEmpty((CharSequence)plmn);
        boolean bl = spnValid = !TextUtils.isEmpty((CharSequence)spn);
        if (plmnValid && spnValid) {
            return plmn + "|" + spn;
        }
        if (plmnValid) {
            return plmn;
        }
        if (spnValid) {
            return spn;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusMode {
        Normal(true),
        NetworkLocked(true),
        SimMissing(false),
        SimMissingLocked(false),
        SimPukLocked(false),
        SimLocked(true),
        SimPermDisabled(false);

        private final boolean mShowStatusLines;

        private StatusMode(boolean mShowStatusLines) {
            this.mShowStatusLines = mShowStatusLines;
        }

        public boolean shouldShowStatusLines() {
            return this.mShowStatusLines;
        }
    }

    private class TransientTextManager {
        private TextView mTextView;
        private ArrayList<Data> mMessages = new ArrayList(5);

        TransientTextManager(TextView textView) {
            this.mTextView = textView;
        }

        void post(CharSequence message, int icon, long duration) {
            if (this.mTextView == null) {
                return;
            }
            this.mTextView.setText(message);
            this.mTextView.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
            final Data data = new Data(message, icon);
            KeyguardStatusViewManager.this.mContainer.postDelayed(new Runnable(){

                public void run() {
                    int lastIcon;
                    CharSequence lastText;
                    TransientTextManager.this.mMessages.remove(data);
                    int last = TransientTextManager.this.mMessages.size() - 1;
                    if (last > 0) {
                        Data oldData = (Data)TransientTextManager.this.mMessages.get(last);
                        lastText = oldData.text;
                        lastIcon = oldData.icon;
                    } else {
                        MutableInt tmpIcon = new MutableInt(0);
                        lastText = KeyguardStatusViewManager.this.getAltTextMessage(tmpIcon);
                        lastIcon = tmpIcon.value;
                    }
                    TransientTextManager.this.mTextView.setText(lastText);
                    TransientTextManager.this.mTextView.setCompoundDrawablesWithIntrinsicBounds(lastIcon, 0, 0, 0);
                }
            }, duration);
        }

        private class Data {
            final int icon;
            final CharSequence text;

            Data(CharSequence t, int i) {
                this.text = t;
                this.icon = i;
            }
        }
    }
}

