/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.IccCard;
import com.google.android.collect.Lists;
import java.util.ArrayList;

public class KeyguardUpdateMonitor {
    private static final String TAG = "KeyguardUpdateMonitor";
    private static final boolean DEBUG = false;
    static final int LOW_BATTERY_THRESHOLD = 20;
    private final Context mContext;
    private IccCard.State mSimState = IccCard.State.READY;
    private boolean mKeyguardBypassEnabled;
    private boolean mDeviceProvisioned;
    private BatteryStatus mBatteryStatus;
    private CharSequence mTelephonyPlmn;
    private CharSequence mTelephonySpn;
    private int mFailedAttempts = 0;
    private boolean mClockVisible;
    private Handler mHandler;
    private ArrayList<InfoCallback> mInfoCallbacks = Lists.newArrayList();
    private ArrayList<SimStateCallback> mSimStateCallbacks = Lists.newArrayList();
    private ContentObserver mContentObserver;
    private int mRingMode;
    private int mPhoneState;
    private static final int MSG_TIME_UPDATE = 301;
    private static final int MSG_BATTERY_UPDATE = 302;
    private static final int MSG_CARRIER_INFO_UPDATE = 303;
    private static final int MSG_SIM_STATE_CHANGE = 304;
    private static final int MSG_RINGER_MODE_CHANGED = 305;
    private static final int MSG_PHONE_STATE_CHANGED = 306;
    private static final int MSG_CLOCK_VISIBILITY_CHANGED = 307;
    private static final int MSG_DEVICE_PROVISIONED = 308;

    public KeyguardUpdateMonitor(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 301: {
                        KeyguardUpdateMonitor.this.handleTimeUpdate();
                        break;
                    }
                    case 302: {
                        KeyguardUpdateMonitor.this.handleBatteryUpdate((BatteryStatus)msg.obj);
                        break;
                    }
                    case 303: {
                        KeyguardUpdateMonitor.this.handleCarrierInfoUpdate();
                        break;
                    }
                    case 304: {
                        KeyguardUpdateMonitor.this.handleSimStateChange((SimArgs)msg.obj);
                        break;
                    }
                    case 305: {
                        KeyguardUpdateMonitor.this.handleRingerModeChange(msg.arg1);
                        break;
                    }
                    case 306: {
                        KeyguardUpdateMonitor.this.handlePhoneStateChanged((String)msg.obj);
                        break;
                    }
                    case 307: {
                        KeyguardUpdateMonitor.this.handleClockVisibilityChanged();
                        break;
                    }
                    case 308: {
                        KeyguardUpdateMonitor.this.handleDeviceProvisioned();
                    }
                }
            }
        };
        this.mKeyguardBypassEnabled = context.getResources().getBoolean(0x111000E);
        boolean bl = this.mDeviceProvisioned = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
        if (!this.mDeviceProvisioned) {
            boolean provisioned;
            this.mContentObserver = new ContentObserver(this.mHandler){

                public void onChange(boolean selfChange) {
                    super.onChange(selfChange);
                    KeyguardUpdateMonitor.this.mDeviceProvisioned = Settings.Secure.getInt((ContentResolver)KeyguardUpdateMonitor.this.mContext.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
                    if (KeyguardUpdateMonitor.this.mDeviceProvisioned) {
                        KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(308));
                    }
                }
            };
            this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor((String)"device_provisioned"), false, this.mContentObserver);
            boolean bl2 = provisioned = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
            if (provisioned != this.mDeviceProvisioned) {
                this.mDeviceProvisioned = provisioned;
                if (this.mDeviceProvisioned) {
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(308));
                }
            }
        }
        this.mSimState = IccCard.State.READY;
        this.mBatteryStatus = new BatteryStatus(1, 100, 0, 0);
        this.mTelephonyPlmn = this.getDefaultPlmn();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.provider.Telephony.SPN_STRINGS_UPDATED");
        filter.addAction("android.media.RINGER_MODE_CHANGED");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.TIME_TICK".equals(action) || "android.intent.action.TIME_SET".equals(action) || "android.intent.action.TIMEZONE_CHANGED".equals(action)) {
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(301));
                } else if ("android.provider.Telephony.SPN_STRINGS_UPDATED".equals(action)) {
                    KeyguardUpdateMonitor.this.mTelephonyPlmn = KeyguardUpdateMonitor.this.getTelephonyPlmnFrom(intent);
                    KeyguardUpdateMonitor.this.mTelephonySpn = KeyguardUpdateMonitor.this.getTelephonySpnFrom(intent);
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(303));
                } else if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                    int status = intent.getIntExtra("status", 1);
                    int plugged = intent.getIntExtra("plugged", 0);
                    int level = intent.getIntExtra("level", 0);
                    int health = intent.getIntExtra("health", 1);
                    Message msg = KeyguardUpdateMonitor.this.mHandler.obtainMessage(302, (Object)new BatteryStatus(status, level, plugged, health));
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(msg);
                } else if ("android.intent.action.SIM_STATE_CHANGED".equals(action)) {
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(304, (Object)SimArgs.fromIntent(intent)));
                } else if ("android.media.RINGER_MODE_CHANGED".equals(action)) {
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(305, intent.getIntExtra("android.media.EXTRA_RINGER_MODE", -1), 0));
                } else if ("android.intent.action.PHONE_STATE".equals(action)) {
                    String state = intent.getStringExtra("state");
                    KeyguardUpdateMonitor.this.mHandler.sendMessage(KeyguardUpdateMonitor.this.mHandler.obtainMessage(306, (Object)state));
                }
            }
        }, filter);
    }

    protected void handleDeviceProvisioned() {
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onDeviceProvisioned();
        }
        if (this.mContentObserver != null) {
            this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            this.mContentObserver = null;
        }
    }

    protected void handlePhoneStateChanged(String newState) {
        if (TelephonyManager.EXTRA_STATE_IDLE.equals(newState)) {
            this.mPhoneState = 0;
        } else if (TelephonyManager.EXTRA_STATE_OFFHOOK.equals(newState)) {
            this.mPhoneState = 2;
        } else if (TelephonyManager.EXTRA_STATE_RINGING.equals(newState)) {
            this.mPhoneState = 1;
        }
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onPhoneStateChanged(this.mPhoneState);
        }
    }

    protected void handleRingerModeChange(int mode) {
        this.mRingMode = mode;
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onRingerModeChanged(mode);
        }
    }

    private void handleTimeUpdate() {
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onTimeChanged();
        }
    }

    private void handleBatteryUpdate(BatteryStatus batteryStatus) {
        boolean batteryUpdateInteresting = KeyguardUpdateMonitor.isBatteryUpdateInteresting(this.mBatteryStatus, batteryStatus);
        this.mBatteryStatus = batteryStatus;
        if (batteryUpdateInteresting) {
            for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
                this.mInfoCallbacks.get(i).onRefreshBatteryInfo(this.shouldShowBatteryInfo(), KeyguardUpdateMonitor.isPluggedIn(batteryStatus), batteryStatus.level);
            }
        }
    }

    private void handleCarrierInfoUpdate() {
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onRefreshCarrierInfo(this.mTelephonyPlmn, this.mTelephonySpn);
        }
    }

    private void handleSimStateChange(SimArgs simArgs) {
        IccCard.State state = simArgs.simState;
        if (state != IccCard.State.UNKNOWN && state != this.mSimState) {
            this.mSimState = state;
            for (int i = 0; i < this.mSimStateCallbacks.size(); ++i) {
                this.mSimStateCallbacks.get(i).onSimStateChanged(state);
            }
        }
    }

    private void handleClockVisibilityChanged() {
        for (int i = 0; i < this.mInfoCallbacks.size(); ++i) {
            this.mInfoCallbacks.get(i).onClockVisibilityChanged();
        }
    }

    private static boolean isPluggedIn(BatteryStatus status) {
        return status.plugged == 1 || status.plugged == 2;
    }

    private static boolean isBatteryUpdateInteresting(BatteryStatus old, BatteryStatus current) {
        boolean stateChangedWhilePluggedIn;
        boolean nowPluggedIn = KeyguardUpdateMonitor.isPluggedIn(current);
        boolean wasPluggedIn = KeyguardUpdateMonitor.isPluggedIn(old);
        boolean bl = stateChangedWhilePluggedIn = wasPluggedIn && nowPluggedIn && old.status != current.status;
        if (wasPluggedIn != nowPluggedIn || stateChangedWhilePluggedIn) {
            return true;
        }
        if (nowPluggedIn && old.level != current.level) {
            return true;
        }
        return !nowPluggedIn && KeyguardUpdateMonitor.isBatteryLow(current) && current.level != old.level;
    }

    private static boolean isBatteryLow(BatteryStatus status) {
        return status.level < 20;
    }

    private CharSequence getTelephonyPlmnFrom(Intent intent) {
        if (intent.getBooleanExtra("showPlmn", false)) {
            String plmn = intent.getStringExtra("plmn");
            if (plmn != null) {
                return plmn;
            }
            return this.getDefaultPlmn();
        }
        return null;
    }

    private CharSequence getDefaultPlmn() {
        return this.mContext.getResources().getText(17040090);
    }

    private CharSequence getTelephonySpnFrom(Intent intent) {
        String spn;
        if (intent.getBooleanExtra("showSpn", false) && (spn = intent.getStringExtra("spn")) != null) {
            return spn;
        }
        return null;
    }

    public void removeCallback(Object observer) {
        this.mInfoCallbacks.remove(observer);
        this.mSimStateCallbacks.remove(observer);
    }

    public void registerInfoCallback(InfoCallback callback) {
        if (!this.mInfoCallbacks.contains(callback)) {
            this.mInfoCallbacks.add(callback);
            callback.onRefreshBatteryInfo(this.shouldShowBatteryInfo(), KeyguardUpdateMonitor.isPluggedIn(this.mBatteryStatus), this.mBatteryStatus.level);
            callback.onTimeChanged();
            callback.onRingerModeChanged(this.mRingMode);
            callback.onPhoneStateChanged(this.mPhoneState);
            callback.onRefreshCarrierInfo(this.mTelephonyPlmn, this.mTelephonySpn);
            callback.onClockVisibilityChanged();
        }
    }

    public void registerSimStateCallback(SimStateCallback callback) {
        if (!this.mSimStateCallbacks.contains(callback)) {
            this.mSimStateCallbacks.add(callback);
            callback.onSimStateChanged(this.mSimState);
        }
    }

    public void reportClockVisible(boolean visible) {
        this.mClockVisible = visible;
        this.mHandler.obtainMessage(307).sendToTarget();
    }

    public IccCard.State getSimState() {
        return this.mSimState;
    }

    public void reportSimUnlocked() {
        this.mSimState = IccCard.State.READY;
        this.handleSimStateChange(new SimArgs(this.mSimState));
    }

    public boolean isKeyguardBypassEnabled() {
        return this.mKeyguardBypassEnabled;
    }

    public boolean isDevicePluggedIn() {
        return KeyguardUpdateMonitor.isPluggedIn(this.mBatteryStatus);
    }

    public boolean isDeviceCharged() {
        return this.mBatteryStatus.status == 5 || this.mBatteryStatus.level >= 100;
    }

    public int getBatteryLevel() {
        return this.mBatteryStatus.level;
    }

    public boolean shouldShowBatteryInfo() {
        return KeyguardUpdateMonitor.isPluggedIn(this.mBatteryStatus) || KeyguardUpdateMonitor.isBatteryLow(this.mBatteryStatus);
    }

    public CharSequence getTelephonyPlmn() {
        return this.mTelephonyPlmn;
    }

    public CharSequence getTelephonySpn() {
        return this.mTelephonySpn;
    }

    public boolean isDeviceProvisioned() {
        return this.mDeviceProvisioned;
    }

    public int getFailedAttempts() {
        return this.mFailedAttempts;
    }

    public void clearFailedAttempts() {
        this.mFailedAttempts = 0;
    }

    public void reportFailedAttempt() {
        ++this.mFailedAttempts;
    }

    public boolean isClockVisible() {
        return this.mClockVisible;
    }

    public int getPhoneState() {
        return this.mPhoneState;
    }

    static interface SimStateCallback {
        public void onSimStateChanged(IccCard.State var1);
    }

    static interface InfoCallback {
        public void onRefreshBatteryInfo(boolean var1, boolean var2, int var3);

        public void onTimeChanged();

        public void onRefreshCarrierInfo(CharSequence var1, CharSequence var2);

        public void onRingerModeChanged(int var1);

        public void onPhoneStateChanged(int var1);

        public void onClockVisibilityChanged();

        public void onDeviceProvisioned();
    }

    private static class BatteryStatus {
        public final int status;
        public final int level;
        public final int plugged;
        public final int health;

        public BatteryStatus(int status, int level, int plugged, int health) {
            this.status = status;
            this.level = level;
            this.plugged = plugged;
            this.health = health;
        }
    }

    private static class SimArgs {
        public final IccCard.State simState;

        SimArgs(IccCard.State state) {
            this.simState = state;
        }

        static SimArgs fromIntent(Intent intent) {
            String lockedReason;
            String absentReason;
            if (!"android.intent.action.SIM_STATE_CHANGED".equals(intent.getAction())) {
                throw new IllegalArgumentException("only handles intent ACTION_SIM_STATE_CHANGED");
            }
            String stateExtra = intent.getStringExtra("ss");
            IccCard.State state = "ABSENT".equals(stateExtra) ? ("PERM_DISABLED".equals(absentReason = intent.getStringExtra("reason")) ? IccCard.State.PERM_DISABLED : IccCard.State.ABSENT) : ("READY".equals(stateExtra) ? IccCard.State.READY : ("LOCKED".equals(stateExtra) ? ("PIN".equals(lockedReason = intent.getStringExtra("reason")) ? IccCard.State.PIN_REQUIRED : ("PUK".equals(lockedReason) ? IccCard.State.PUK_REQUIRED : IccCard.State.UNKNOWN)) : ("NETWORK".equals(stateExtra) ? IccCard.State.NETWORK_LOCKED : IccCard.State.UNKNOWN)));
            return new SimArgs(state);
        }

        public String toString() {
            return this.simState.toString();
        }
    }
}

