/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.view.KeyEvent;
import android.widget.FrameLayout;
import com.android.internal.policy.impl.KeyguardViewCallback;

public abstract class KeyguardViewBase
extends FrameLayout {
    private static final int BACKGROUND_COLOR = 0x70000000;
    private KeyguardViewCallback mCallback;
    private AudioManager mAudioManager;
    private TelephonyManager mTelephonyManager = null;
    private static final boolean KEYGUARD_MANAGES_VOLUME = true;
    Drawable mBackgroundDrawable = new Drawable(){

        public void draw(Canvas canvas) {
            canvas.drawColor(0x70000000, PorterDuff.Mode.SRC);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -3;
        }
    };

    public KeyguardViewBase(Context context) {
        super(context);
        this.resetBackground();
    }

    public void resetBackground() {
        this.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    void setCallback(KeyguardViewCallback callback) {
        this.mCallback = callback;
    }

    public KeyguardViewCallback getCallback() {
        return this.mCallback;
    }

    public abstract void reset();

    public abstract void onScreenTurnedOff();

    public abstract void onScreenTurnedOn();

    public abstract void show();

    public abstract void wakeWhenReadyTq(int var1);

    public abstract void verifyUnlock();

    public abstract void cleanUp();

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.shouldEventKeepScreenOnWhileKeyguardShowing(event)) {
            this.mCallback.pokeWakelock();
        }
        if (this.interceptMediaKey(event)) {
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    private boolean shouldEventKeepScreenOnWhileKeyguardShowing(KeyEvent event) {
        if (event.getAction() != 0) {
            return false;
        }
        switch (event.getKeyCode()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interceptMediaKey(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getAction() == 0) {
            switch (keyCode) {
                case 85: 
                case 126: 
                case 127: {
                    if (this.mTelephonyManager == null) {
                        this.mTelephonyManager = (TelephonyManager)this.getContext().getSystemService("phone");
                    }
                    if (this.mTelephonyManager != null && this.mTelephonyManager.getCallState() != 0) {
                        return true;
                    }
                }
                case 79: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 130: {
                    Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                    intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)event);
                    this.getContext().sendOrderedBroadcast(intent, null);
                    return true;
                }
                case 24: 
                case 25: 
                case 164: {
                    KeyguardViewBase intent = this;
                    synchronized (intent) {
                        if (this.mAudioManager == null) {
                            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
                        }
                    }
                    if (this.mAudioManager.isMusicActive()) {
                        this.mAudioManager.adjustStreamVolume(3, keyCode == 24 ? 1 : -1, 0);
                    }
                    return true;
                }
            }
        } else if (event.getAction() == 1) {
            switch (keyCode) {
                case 79: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 126: 
                case 127: 
                case 130: {
                    Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                    intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)event);
                    this.getContext().sendOrderedBroadcast(intent, null);
                    return true;
                }
            }
        }
        return false;
    }

    public void dispatchSystemUiVisibilityChanged(int visibility) {
        super.dispatchSystemUiVisibilityChanged(visibility);
        this.setSystemUiVisibility(0x400000);
    }
}

