/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.os.IBinder;
import android.os.SystemProperties;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.policy.impl.KeyguardViewBase;
import com.android.internal.policy.impl.KeyguardViewCallback;
import com.android.internal.policy.impl.KeyguardViewProperties;
import com.android.internal.policy.impl.KeyguardWindowController;

public class KeyguardViewManager
implements KeyguardWindowController {
    private static final boolean DEBUG = false;
    private static String TAG = "KeyguardViewManager";
    private final Context mContext;
    private final ViewManager mViewManager;
    private final KeyguardViewCallback mCallback;
    private final KeyguardViewProperties mKeyguardViewProperties;
    private final KeyguardUpdateMonitor mUpdateMonitor;
    private WindowManager.LayoutParams mWindowLayoutParams;
    private boolean mNeedsInput = false;
    private FrameLayout mKeyguardHost;
    private KeyguardViewBase mKeyguardView;
    private boolean mScreenOn = false;

    public KeyguardViewManager(Context context, ViewManager viewManager, KeyguardViewCallback callback, KeyguardViewProperties keyguardViewProperties, KeyguardUpdateMonitor updateMonitor) {
        this.mContext = context;
        this.mViewManager = viewManager;
        this.mCallback = callback;
        this.mKeyguardViewProperties = keyguardViewProperties;
        this.mUpdateMonitor = updateMonitor;
    }

    public synchronized void show() {
        boolean enableScreenRotation;
        Resources res = this.mContext.getResources();
        boolean bl = enableScreenRotation = SystemProperties.getBoolean((String)"lockscreen.rot_override", (boolean)false) || res.getBoolean(0x111001C);
        if (this.mKeyguardHost == null) {
            this.mKeyguardHost = new KeyguardViewHost(this.mContext, this.mCallback);
            int stretch = -1;
            int flags = 0x10100800;
            if (!this.mNeedsInput) {
                flags |= 0x20000;
            }
            if (ActivityManager.isHighEndGfx((Display)((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay())) {
                flags |= 0x1000000;
            }
            WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2004, flags, -3);
            lp.softInputMode = 16;
            lp.windowAnimations = 16974298;
            if (ActivityManager.isHighEndGfx((Display)((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay())) {
                lp.flags |= 0x1000000;
                lp.privateFlags |= 2;
            }
            lp.privateFlags |= 8;
            lp.setTitle((CharSequence)"Keyguard");
            this.mWindowLayoutParams = lp;
            this.mViewManager.addView((View)this.mKeyguardHost, (ViewGroup.LayoutParams)lp);
        }
        this.mWindowLayoutParams.screenOrientation = enableScreenRotation ? 4 : 5;
        this.mViewManager.updateViewLayout((View)this.mKeyguardHost, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
        if (this.mKeyguardView == null) {
            this.mKeyguardView = this.mKeyguardViewProperties.createKeyguardView(this.mContext, this.mUpdateMonitor, this);
            this.mKeyguardView.setId(0x1020221);
            this.mKeyguardView.setCallback(this.mCallback);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.mKeyguardHost.addView((View)this.mKeyguardView, (ViewGroup.LayoutParams)lp);
            if (this.mScreenOn) {
                this.mKeyguardView.show();
            }
        }
        int visFlags = 0x600000;
        this.mKeyguardHost.setSystemUiVisibility(visFlags);
        this.mViewManager.updateViewLayout((View)this.mKeyguardHost, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
        this.mKeyguardHost.setVisibility(0);
        this.mKeyguardView.requestFocus();
    }

    public void setNeedsInput(boolean needsInput) {
        this.mNeedsInput = needsInput;
        if (this.mWindowLayoutParams != null) {
            this.mWindowLayoutParams.flags = needsInput ? (this.mWindowLayoutParams.flags &= 0xFFFDFFFF) : (this.mWindowLayoutParams.flags |= 0x20000);
            this.mViewManager.updateViewLayout((View)this.mKeyguardHost, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
        }
    }

    public synchronized void reset() {
        if (this.mKeyguardView != null) {
            this.mKeyguardView.reset();
        }
    }

    public synchronized void onScreenTurnedOff() {
        this.mScreenOn = false;
        if (this.mKeyguardView != null) {
            this.mKeyguardView.onScreenTurnedOff();
        }
    }

    public synchronized void onScreenTurnedOn(final ShowListener showListener) {
        this.mScreenOn = true;
        if (this.mKeyguardView != null) {
            this.mKeyguardView.onScreenTurnedOn();
            if (this.mKeyguardHost.getVisibility() == 0) {
                this.mKeyguardHost.post(new Runnable(){

                    public void run() {
                        if (KeyguardViewManager.this.mKeyguardHost.getVisibility() == 0) {
                            showListener.onShown(KeyguardViewManager.this.mKeyguardHost.getWindowToken());
                        } else {
                            showListener.onShown(null);
                        }
                    }
                });
            } else {
                showListener.onShown(null);
            }
        } else {
            showListener.onShown(null);
        }
    }

    public synchronized void verifyUnlock() {
        this.show();
        this.mKeyguardView.verifyUnlock();
    }

    public boolean wakeWhenReadyTq(int keyCode) {
        if (this.mKeyguardView != null) {
            this.mKeyguardView.wakeWhenReadyTq(keyCode);
            return true;
        }
        Log.w((String)TAG, (String)"mKeyguardView is null in wakeWhenReadyTq");
        return false;
    }

    public synchronized void hide() {
        if (this.mKeyguardHost != null) {
            this.mKeyguardHost.setVisibility(8);
            if (this.mKeyguardView != null) {
                final KeyguardViewBase lastView = this.mKeyguardView;
                this.mKeyguardView = null;
                this.mKeyguardHost.postDelayed(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        KeyguardViewManager keyguardViewManager = KeyguardViewManager.this;
                        synchronized (keyguardViewManager) {
                            lastView.cleanUp();
                            KeyguardViewManager.this.mKeyguardHost.removeView((View)lastView);
                        }
                    }
                }, 500L);
            }
        }
    }

    public synchronized boolean isShowing() {
        return this.mKeyguardHost != null && this.mKeyguardHost.getVisibility() == 0;
    }

    private static class KeyguardViewHost
    extends FrameLayout {
        private final KeyguardViewCallback mCallback;

        private KeyguardViewHost(Context context, KeyguardViewCallback callback) {
            super(context);
            this.mCallback = callback;
        }

        protected void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            this.mCallback.keyguardDoneDrawing();
        }
    }

    public static interface ShowListener {
        public void onShown(IBinder var1);
    }
}

