/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Handler;
import android.os.LocalPowerManager;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.EventLog;
import android.util.Log;
import android.view.ViewManager;
import android.view.WindowManagerImpl;
import android.view.WindowManagerPolicy;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.policy.impl.KeyguardViewCallback;
import com.android.internal.policy.impl.KeyguardViewManager;
import com.android.internal.policy.impl.KeyguardViewProperties;
import com.android.internal.policy.impl.LockPatternKeyguardViewProperties;
import com.android.internal.policy.impl.PhoneWindowManager;
import com.android.internal.telephony.IccCard;
import com.android.internal.widget.LockPatternUtils;

public class KeyguardViewMediator
implements KeyguardViewCallback,
KeyguardUpdateMonitor.InfoCallback,
KeyguardUpdateMonitor.SimStateCallback {
    private static final int KEYGUARD_DISPLAY_TIMEOUT_DELAY_DEFAULT = 30000;
    private static final boolean DEBUG = false;
    private static final boolean DBG_WAKE = false;
    private static final String TAG = "KeyguardViewMediator";
    private static final String DELAYED_KEYGUARD_ACTION = "com.android.internal.policy.impl.PhoneWindowManager.DELAYED_KEYGUARD";
    private static final int TIMEOUT = 1;
    private static final int SHOW = 2;
    private static final int HIDE = 3;
    private static final int RESET = 4;
    private static final int VERIFY_UNLOCK = 5;
    private static final int NOTIFY_SCREEN_OFF = 6;
    private static final int NOTIFY_SCREEN_ON = 7;
    private static final int WAKE_WHEN_READY = 8;
    private static final int KEYGUARD_DONE = 9;
    private static final int KEYGUARD_DONE_DRAWING = 10;
    private static final int KEYGUARD_DONE_AUTHENTICATING = 11;
    private static final int SET_HIDDEN = 12;
    private static final int KEYGUARD_TIMEOUT = 13;
    protected static final int AWAKE_INTERVAL_DEFAULT_MS = 10000;
    protected static final int AWAKE_INTERVAL_DEFAULT_KEYBOARD_OPEN_MS = 10000;
    private static final int KEYGUARD_LOCK_AFTER_DELAY_DEFAULT = 5000;
    private static final int KEYGUARD_DONE_DRAWING_TIMEOUT_MS = 2000;
    private static final boolean ENABLE_INSECURE_STATUS_BAR_EXPAND = true;
    private static final int MASTER_STREAM_TYPE = 2;
    final float MIN_LOCK_VOLUME = 0.05f;
    final float MAX_LOCK_VOLUME = 0.4f;
    private Context mContext;
    private AlarmManager mAlarmManager;
    private AudioManager mAudioManager;
    private StatusBarManager mStatusBarManager;
    private boolean mShowLockIcon;
    private boolean mShowingLockIcon;
    private boolean mSystemReady;
    private boolean mSuppressNextLockSound = true;
    LocalPowerManager mRealPowerManager;
    private PowerManager mPM;
    private PowerManager.WakeLock mWakeLock;
    private PowerManager.WakeLock mShowKeyguardWakeLock;
    private PowerManager.WakeLock mWakeAndHandOff;
    private KeyguardViewManager mKeyguardViewManager;
    private boolean mExternallyEnabled = true;
    private boolean mNeedToReshowWhenReenabled = false;
    private boolean mShowing = false;
    private boolean mHidden = false;
    private int mDelayedShowingSequence;
    private int mWakelockSequence;
    private PhoneWindowManager mCallback;
    private WindowManagerPolicy.OnKeyguardExitResult mExitSecureCallback;
    private KeyguardViewProperties mKeyguardViewProperties;
    private KeyguardUpdateMonitor mUpdateMonitor;
    private boolean mKeyboardOpen = false;
    private boolean mScreenOn = false;
    private String mPhoneState = TelephonyManager.EXTRA_STATE_IDLE;
    private Intent mUserPresentIntent;
    private boolean mWaitingUntilKeyguardVisible = false;
    private LockPatternUtils mLockPatternUtils;
    private SoundPool mLockSounds;
    private int mLockSoundId;
    private int mUnlockSoundId;
    private int mLockSoundStreamId;
    private int mMasterStreamMaxVolume;
    private BroadcastReceiver mBroadCastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(KeyguardViewMediator.DELAYED_KEYGUARD_ACTION)) {
                int sequence = intent.getIntExtra("seq", 0);
                KeyguardViewMediator keyguardViewMediator = KeyguardViewMediator.this;
                synchronized (keyguardViewMediator) {
                    if (KeyguardViewMediator.this.mDelayedShowingSequence == sequence) {
                        KeyguardViewMediator.this.mSuppressNextLockSound = true;
                        KeyguardViewMediator.this.doKeyguardLocked();
                    }
                }
            }
            if ("android.intent.action.PHONE_STATE".equals(action)) {
                KeyguardViewMediator.this.mPhoneState = intent.getStringExtra("state");
                KeyguardViewMediator keyguardViewMediator = KeyguardViewMediator.this;
                synchronized (keyguardViewMediator) {
                    if (TelephonyManager.EXTRA_STATE_IDLE.equals(KeyguardViewMediator.this.mPhoneState) && !KeyguardViewMediator.this.mScreenOn && KeyguardViewMediator.this.mExternallyEnabled) {
                        KeyguardViewMediator.this.doKeyguardLocked();
                    }
                }
            }
        }
    };
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    KeyguardViewMediator.this.handleTimeout(msg.arg1);
                    return;
                }
                case 2: {
                    KeyguardViewMediator.this.handleShow();
                    return;
                }
                case 3: {
                    KeyguardViewMediator.this.handleHide();
                    return;
                }
                case 4: {
                    KeyguardViewMediator.this.handleReset();
                    return;
                }
                case 5: {
                    KeyguardViewMediator.this.handleVerifyUnlock();
                    return;
                }
                case 6: {
                    KeyguardViewMediator.this.handleNotifyScreenOff();
                    return;
                }
                case 7: {
                    KeyguardViewMediator.this.handleNotifyScreenOn((KeyguardViewManager.ShowListener)msg.obj);
                    return;
                }
                case 8: {
                    KeyguardViewMediator.this.handleWakeWhenReady(msg.arg1);
                    return;
                }
                case 9: {
                    KeyguardViewMediator.this.handleKeyguardDone(msg.arg1 != 0);
                    return;
                }
                case 10: {
                    KeyguardViewMediator.this.handleKeyguardDoneDrawing();
                    return;
                }
                case 11: {
                    KeyguardViewMediator.this.keyguardDone(true);
                    return;
                }
                case 12: {
                    KeyguardViewMediator.this.handleSetHidden(msg.arg1 != 0);
                    break;
                }
                case 13: {
                    KeyguardViewMediator keyguardViewMediator = KeyguardViewMediator.this;
                    synchronized (keyguardViewMediator) {
                        KeyguardViewMediator.this.doKeyguardLocked();
                        break;
                    }
                }
            }
        }
    };

    public KeyguardViewMediator(Context context, PhoneWindowManager callback, LocalPowerManager powerManager) {
        this.mContext = context;
        this.mRealPowerManager = powerManager;
        this.mPM = (PowerManager)context.getSystemService("power");
        this.mWakeLock = this.mPM.newWakeLock(0x1000001A, "keyguard");
        this.mWakeLock.setReferenceCounted(false);
        this.mShowKeyguardWakeLock = this.mPM.newWakeLock(1, "show keyguard");
        this.mShowKeyguardWakeLock.setReferenceCounted(false);
        this.mWakeAndHandOff = this.mPM.newWakeLock(1, "keyguardWakeAndHandOff");
        this.mWakeAndHandOff.setReferenceCounted(false);
        IntentFilter filter = new IntentFilter();
        filter.addAction(DELAYED_KEYGUARD_ACTION);
        filter.addAction("android.intent.action.PHONE_STATE");
        context.registerReceiver(this.mBroadCastReceiver, filter);
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.mCallback = callback;
        this.mUpdateMonitor = new KeyguardUpdateMonitor(context);
        this.mUpdateMonitor.registerInfoCallback(this);
        this.mUpdateMonitor.registerSimStateCallback(this);
        this.mLockPatternUtils = new LockPatternUtils(this.mContext);
        this.mKeyguardViewProperties = new LockPatternKeyguardViewProperties(this.mLockPatternUtils, this.mUpdateMonitor);
        this.mKeyguardViewManager = new KeyguardViewManager(context, (ViewManager)WindowManagerImpl.getDefault(), this, this.mKeyguardViewProperties, this.mUpdateMonitor);
        this.mUserPresentIntent = new Intent("android.intent.action.USER_PRESENT");
        this.mUserPresentIntent.addFlags(0x30000000);
        ContentResolver cr = this.mContext.getContentResolver();
        this.mShowLockIcon = Settings.System.getInt((ContentResolver)cr, (String)"show_status_bar_lock", (int)0) == 1;
        this.mLockSounds = new SoundPool(1, 1, 0);
        String soundPath = Settings.System.getString((ContentResolver)cr, (String)"lock_sound");
        if (soundPath != null) {
            this.mLockSoundId = this.mLockSounds.load(soundPath, 1);
        }
        if (soundPath == null || this.mLockSoundId == 0) {
            // empty if block
        }
        if ((soundPath = Settings.System.getString((ContentResolver)cr, (String)"unlock_sound")) != null) {
            this.mUnlockSoundId = this.mLockSounds.load(soundPath, 1);
        }
        if (soundPath == null || this.mUnlockSoundId == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSystemReady() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mSystemReady = true;
            this.doKeyguardLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScreenTurnedOff(int why) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mScreenOn = false;
            if (this.mExitSecureCallback != null) {
                this.mExitSecureCallback.onKeyguardExitResult(false);
                this.mExitSecureCallback = null;
                if (!this.mExternallyEnabled) {
                    this.hideLocked();
                }
            } else if (this.mShowing) {
                this.notifyScreenOffLocked();
                this.resetStateLocked();
            } else if (why == 3) {
                long timeout;
                ContentResolver cr = this.mContext.getContentResolver();
                long displayTimeout = Settings.System.getInt((ContentResolver)cr, (String)"screen_off_timeout", (int)30000);
                long lockAfterTimeout = Settings.Secure.getInt((ContentResolver)cr, (String)"lock_screen_lock_after_timeout", (int)5000);
                long policyTimeout = this.mLockPatternUtils.getDevicePolicyManager().getMaximumTimeToLock(null);
                if (policyTimeout > 0L) {
                    displayTimeout = Math.max(displayTimeout, 0L);
                    timeout = Math.min(policyTimeout - displayTimeout, lockAfterTimeout);
                } else {
                    timeout = lockAfterTimeout;
                }
                if (timeout <= 0L) {
                    this.mSuppressNextLockSound = true;
                    this.doKeyguardLocked();
                } else {
                    long when = SystemClock.elapsedRealtime() + timeout;
                    Intent intent = new Intent(DELAYED_KEYGUARD_ACTION);
                    intent.putExtra("seq", this.mDelayedShowingSequence);
                    PendingIntent sender = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x10000000);
                    this.mAlarmManager.set(2, when, sender);
                }
            } else if (why != 4) {
                this.doKeyguardLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScreenTurnedOn(KeyguardViewManager.ShowListener showListener) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mScreenOn = true;
            ++this.mDelayedShowingSequence;
            this.notifyScreenOnLocked(showListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyguardEnabled(boolean enabled) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mExternallyEnabled = enabled;
            if (!enabled && this.mShowing) {
                if (this.mExitSecureCallback != null) {
                    return;
                }
                this.mNeedToReshowWhenReenabled = true;
                this.hideLocked();
            } else if (enabled && this.mNeedToReshowWhenReenabled) {
                this.mNeedToReshowWhenReenabled = false;
                if (this.mExitSecureCallback != null) {
                    this.mExitSecureCallback.onKeyguardExitResult(false);
                    this.mExitSecureCallback = null;
                    this.resetStateLocked();
                } else {
                    this.showLocked();
                    this.mWaitingUntilKeyguardVisible = true;
                    this.mHandler.sendEmptyMessageDelayed(10, 2000L);
                    while (this.mWaitingUntilKeyguardVisible) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyUnlock(WindowManagerPolicy.OnKeyguardExitResult callback) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (!this.mUpdateMonitor.isDeviceProvisioned()) {
                callback.onKeyguardExitResult(false);
            } else if (this.mExternallyEnabled) {
                Log.w((String)TAG, (String)"verifyUnlock called when not externally disabled");
                callback.onKeyguardExitResult(false);
            } else if (this.mExitSecureCallback != null) {
                callback.onKeyguardExitResult(false);
            } else {
                this.mExitSecureCallback = callback;
                this.verifyUnlockLocked();
            }
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public boolean isShowingAndNotHidden() {
        return this.mShowing && !this.mHidden;
    }

    public void setHidden(boolean isHidden) {
        this.mHandler.removeMessages(12);
        Message msg = this.mHandler.obtainMessage(12, isHidden ? 1 : 0, 0);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetHidden(boolean isHidden) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (this.mHidden != isHidden) {
                this.mHidden = isHidden;
                this.adjustUserActivityLocked();
                this.adjustStatusBarLocked();
            }
        }
    }

    public void doKeyguardTimeout() {
        this.mHandler.removeMessages(13);
        Message msg = this.mHandler.obtainMessage(13);
        this.mHandler.sendMessage(msg);
    }

    public boolean isInputRestricted() {
        return this.mShowing || this.mNeedToReshowWhenReenabled || !this.mUpdateMonitor.isDeviceProvisioned();
    }

    public boolean doLidChangeTq(boolean isLidOpen) {
        this.mKeyboardOpen = isLidOpen;
        if (this.mUpdateMonitor.isKeyguardBypassEnabled() && this.mKeyboardOpen && !this.mKeyguardViewProperties.isSecure() && this.mKeyguardViewManager.isShowing()) {
            this.mHandler.sendEmptyMessage(11);
            return true;
        }
        return false;
    }

    private void doKeyguardLocked() {
        boolean lockedOrMissing;
        if (!this.mExternallyEnabled) {
            return;
        }
        if (this.mKeyguardViewManager.isShowing()) {
            return;
        }
        boolean requireSim = !SystemProperties.getBoolean((String)"keyguard.no_require_sim", (boolean)false);
        boolean provisioned = this.mUpdateMonitor.isDeviceProvisioned();
        IccCard.State state = this.mUpdateMonitor.getSimState();
        boolean bl = lockedOrMissing = state.isPinLocked() || (state == IccCard.State.ABSENT || state == IccCard.State.PERM_DISABLED) && requireSim;
        if (!lockedOrMissing && !provisioned) {
            return;
        }
        if (this.mLockPatternUtils.isLockScreenDisabled() && !lockedOrMissing) {
            return;
        }
        this.showLocked();
    }

    private void resetStateLocked() {
        Message msg = this.mHandler.obtainMessage(4);
        this.mHandler.sendMessage(msg);
    }

    private void verifyUnlockLocked() {
        this.mHandler.sendEmptyMessage(5);
    }

    private void notifyScreenOffLocked() {
        this.mHandler.sendEmptyMessage(6);
    }

    private void notifyScreenOnLocked(KeyguardViewManager.ShowListener showListener) {
        Message msg = this.mHandler.obtainMessage(7, (Object)showListener);
        this.mHandler.sendMessage(msg);
    }

    private void wakeWhenReadyLocked(int keyCode) {
        this.mWakeAndHandOff.acquire();
        Message msg = this.mHandler.obtainMessage(8, keyCode, 0);
        this.mHandler.sendMessage(msg);
    }

    private void showLocked() {
        this.mShowKeyguardWakeLock.acquire();
        Message msg = this.mHandler.obtainMessage(2);
        this.mHandler.sendMessage(msg);
    }

    private void hideLocked() {
        Message msg = this.mHandler.obtainMessage(3);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSimStateChanged(IccCard.State simState) {
        switch (simState) {
            case ABSENT: {
                KeyguardViewMediator keyguardViewMediator = this;
                synchronized (keyguardViewMediator) {
                    if (!this.mUpdateMonitor.isDeviceProvisioned()) {
                        if (!this.isShowing()) {
                            this.doKeyguardLocked();
                        } else {
                            this.resetStateLocked();
                        }
                    }
                    break;
                }
            }
            case PIN_REQUIRED: 
            case PUK_REQUIRED: {
                KeyguardViewMediator keyguardViewMediator = this;
                synchronized (keyguardViewMediator) {
                    if (!this.isShowing()) {
                        this.doKeyguardLocked();
                    } else {
                        this.resetStateLocked();
                    }
                    break;
                }
            }
            case PERM_DISABLED: {
                KeyguardViewMediator keyguardViewMediator = this;
                synchronized (keyguardViewMediator) {
                    if (!this.isShowing()) {
                        this.doKeyguardLocked();
                    } else {
                        this.resetStateLocked();
                    }
                    break;
                }
            }
            case READY: {
                KeyguardViewMediator keyguardViewMediator = this;
                synchronized (keyguardViewMediator) {
                    if (this.isShowing()) {
                        this.resetStateLocked();
                    }
                    break;
                }
            }
        }
    }

    public boolean isSecure() {
        return this.mKeyguardViewProperties.isSecure();
    }

    public boolean onWakeKeyWhenKeyguardShowingTq(int keyCode, boolean isDocked) {
        if (this.isWakeKeyWhenKeyguardShowing(keyCode, isDocked)) {
            this.wakeWhenReadyLocked(keyCode);
            return true;
        }
        return false;
    }

    private boolean isWakeKeyWhenKeyguardShowing(int keyCode, boolean isDocked) {
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                return isDocked;
            }
            case 27: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return false;
            }
        }
        return true;
    }

    public boolean onWakeMotionWhenKeyguardShowingTq() {
        this.wakeWhenReadyLocked(0);
        return true;
    }

    public void pokeWakelock() {
        this.pokeWakelock(this.mKeyboardOpen ? 10000 : 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pokeWakelock(int holdMs) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mWakeLock.acquire();
            this.mHandler.removeMessages(1);
            ++this.mWakelockSequence;
            Message msg = this.mHandler.obtainMessage(1, this.mWakelockSequence, 0);
            this.mHandler.sendMessageDelayed(msg, (long)holdMs);
        }
    }

    public void keyguardDone(boolean authenticated) {
        this.keyguardDone(authenticated, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyguardDone(boolean authenticated, boolean wakeup) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            EventLog.writeEvent((int)70000, (int)2);
            Message msg = this.mHandler.obtainMessage(9);
            msg.arg1 = wakeup ? 1 : 0;
            this.mHandler.sendMessage(msg);
            if (authenticated) {
                this.mUpdateMonitor.clearFailedAttempts();
            }
            if (this.mExitSecureCallback != null) {
                this.mExitSecureCallback.onKeyguardExitResult(authenticated);
                this.mExitSecureCallback = null;
                if (authenticated) {
                    this.mExternallyEnabled = true;
                    this.mNeedToReshowWhenReenabled = false;
                }
            }
        }
    }

    public void keyguardDoneDrawing() {
        this.mHandler.sendEmptyMessage(10);
    }

    private void handleKeyguardDone(boolean wakeup) {
        this.handleHide();
        if (wakeup) {
            this.mPM.userActivity(SystemClock.uptimeMillis(), true);
        }
        this.mWakeLock.release();
        this.mContext.sendBroadcast(this.mUserPresentIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyguardDoneDrawing() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (this.mWaitingUntilKeyguardVisible) {
                this.mWaitingUntilKeyguardVisible = false;
                this.notifyAll();
                this.mHandler.removeMessages(10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(int seq) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (seq == this.mWakelockSequence) {
                this.mWakeLock.release();
            }
        }
    }

    private void playSounds(boolean locked) {
        if (this.mSuppressNextLockSound) {
            this.mSuppressNextLockSound = false;
            return;
        }
        ContentResolver cr = this.mContext.getContentResolver();
        if (Settings.System.getInt((ContentResolver)cr, (String)"lockscreen_sounds_enabled", (int)1) == 1) {
            int whichSound = locked ? this.mLockSoundId : this.mUnlockSoundId;
            this.mLockSounds.stop(this.mLockSoundStreamId);
            if (this.mAudioManager == null) {
                this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
                if (this.mAudioManager == null) {
                    return;
                }
                this.mMasterStreamMaxVolume = this.mAudioManager.getStreamMaxVolume(2);
            }
            if (this.mAudioManager.isStreamMute(2)) {
                return;
            }
            int masterStreamVolume = this.mAudioManager.getStreamVolume(2);
            if (masterStreamVolume == 0) {
                return;
            }
            float lockSoundVolume = 0.05f + 0.35f * ((float)masterStreamVolume / (float)this.mMasterStreamMaxVolume);
            this.mLockSoundStreamId = this.mLockSounds.play(whichSound, lockSoundVolume, lockSoundVolume, 1, 0, 1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShow() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (!this.mSystemReady) {
                return;
            }
            this.mKeyguardViewManager.show();
            this.mShowing = true;
            this.adjustUserActivityLocked();
            this.adjustStatusBarLocked();
            try {
                ActivityManagerNative.getDefault().closeSystemDialogs("lock");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.playSounds(true);
            this.mShowKeyguardWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHide() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (this.mWakeAndHandOff.isHeld()) {
                Log.w((String)TAG, (String)"attempt to hide the keyguard while waking, ignored");
                return;
            }
            if (TelephonyManager.EXTRA_STATE_IDLE.equals(this.mPhoneState)) {
                this.playSounds(false);
            }
            this.mKeyguardViewManager.hide();
            this.mShowing = false;
            this.adjustUserActivityLocked();
            this.adjustStatusBarLocked();
        }
    }

    private void adjustUserActivityLocked() {
        boolean enabled = !this.mShowing || this.mHidden;
        this.mRealPowerManager.enableUserActivity(enabled);
        if (!enabled && this.mScreenOn) {
            this.pokeWakelock();
        }
    }

    private void adjustStatusBarLocked() {
        if (this.mStatusBarManager == null) {
            this.mStatusBarManager = (StatusBarManager)this.mContext.getSystemService("statusbar");
        }
        if (this.mStatusBarManager == null) {
            Log.w((String)TAG, (String)"Could not get status bar manager");
        } else {
            if (this.mShowLockIcon) {
                if (this.mShowing && this.isSecure()) {
                    if (!this.mShowingLockIcon) {
                        String contentDescription = this.mContext.getString(17040582);
                        this.mStatusBarManager.setIcon("secure", 17302824, 0, contentDescription);
                        this.mShowingLockIcon = true;
                    }
                } else if (this.mShowingLockIcon) {
                    this.mStatusBarManager.removeIcon("secure");
                    this.mShowingLockIcon = false;
                }
            }
            int flags = 0;
            if (this.mShowing) {
                flags |= 0x1000000;
                if (this.isSecure()) {
                    flags |= 0x10000;
                }
                if (this.isSecure()) {
                    flags |= 0x80000;
                }
            }
            this.mStatusBarManager.disable(flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWakeWhenReady(int keyCode) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            if (!this.mKeyguardViewManager.wakeWhenReadyTq(keyCode)) {
                Log.w((String)TAG, (String)"mKeyguardViewManager.wakeWhenReadyTq did not poke wake lock, so poke it ourselves");
                this.pokeWakelock();
            }
            this.mWakeAndHandOff.release();
            if (!this.mWakeLock.isHeld()) {
                Log.w((String)TAG, (String)"mWakeLock not held in mKeyguardViewManager.wakeWhenReadyTq");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReset() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mKeyguardViewManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVerifyUnlock() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mKeyguardViewManager.verifyUnlock();
            this.mShowing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyScreenOff() {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mKeyguardViewManager.onScreenTurnedOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyScreenOn(KeyguardViewManager.ShowListener showListener) {
        KeyguardViewMediator keyguardViewMediator = this;
        synchronized (keyguardViewMediator) {
            this.mKeyguardViewManager.onScreenTurnedOn(showListener);
        }
    }

    public void onClockVisibilityChanged() {
        this.adjustStatusBarLocked();
    }

    public void onPhoneStateChanged(int phoneState) {
    }

    public void onRefreshBatteryInfo(boolean showBatteryInfo, boolean pluggedIn, int batteryLevel) {
    }

    public void onRefreshCarrierInfo(CharSequence plmn, CharSequence spn) {
    }

    public void onRingerModeChanged(int state) {
    }

    public void onTimeChanged() {
    }

    public void onDeviceProvisioned() {
        this.mContext.sendBroadcast(this.mUserPresentIntent);
    }
}

