/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.policy.IFaceLockCallback;
import com.android.internal.policy.IFaceLockInterface;
import com.android.internal.policy.impl.AccountUnlockScreen;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.policy.impl.KeyguardViewBase;
import com.android.internal.policy.impl.KeyguardWindowController;
import com.android.internal.policy.impl.LockScreen;
import com.android.internal.policy.impl.PasswordUnlockScreen;
import com.android.internal.policy.impl.PatternUnlockScreen;
import com.android.internal.policy.impl.SimPukUnlockScreen;
import com.android.internal.policy.impl.SimUnlockScreen;
import com.android.internal.telephony.IccCard;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockScreenWidgetCallback;
import com.android.internal.widget.TransportControlView;
import java.io.IOException;

public class LockPatternKeyguardView
extends KeyguardViewBase
implements Handler.Callback,
KeyguardUpdateMonitor.InfoCallback {
    private static final int TRANSPORT_USERACTIVITY_TIMEOUT = 10000;
    static final boolean DEBUG_CONFIGURATION = false;
    private static final int EMERGENCY_CALL_TIMEOUT = 10000;
    static final String ACTION_EMERGENCY_DIAL = "com.android.phone.EmergencyDialer.DIAL";
    private static final boolean DEBUG = false;
    private static final String TAG = "LockPatternKeyguardView";
    private final KeyguardUpdateMonitor mUpdateMonitor;
    private final KeyguardWindowController mWindowController;
    private View mLockScreen;
    private View mUnlockScreen;
    private volatile boolean mScreenOn = false;
    private volatile boolean mWindowFocused = false;
    private boolean mEnableFallback = false;
    private boolean mShowLockBeforeUnlock = false;
    private IFaceLockInterface mFaceLockService;
    private boolean mBoundToFaceLockService = false;
    private View mFaceLockAreaView;
    private boolean mFaceLockServiceRunning = false;
    private final Object mFaceLockServiceRunningLock = new Object();
    private final Object mFaceLockStartupLock = new Object();
    private Handler mHandler;
    private final int MSG_SHOW_FACELOCK_AREA_VIEW = 0;
    private final int MSG_HIDE_FACELOCK_AREA_VIEW = 1;
    private final int FACELOCK_VIEW_AREA_EMERGENCY_DIALER_TIMEOUT = 1000;
    private final int FACELOCK_VIEW_AREA_SERVICE_TIMEOUT = 3000;
    private final int BACKUP_LOCK_TIMEOUT = 5000;
    private int mFailedFaceUnlockAttempts = 0;
    private static final int FAILED_FACE_UNLOCK_ATTEMPTS_BEFORE_BACKUP = 15;
    KeyguardScreenCallback mKeyguardScreenCallback;
    private boolean mRequiresSim;
    private boolean mHasOverlay;
    private Mode mMode = Mode.LockScreen;
    private UnlockMode mUnlockScreenMode = UnlockMode.Unknown;
    private boolean mForgotPattern;
    private boolean mIsVerifyUnlockOnly = false;
    private final LockPatternUtils mLockPatternUtils;
    private Configuration mConfiguration;
    private Runnable mRecreateRunnable = new Runnable(){

        public void run() {
            LockPatternKeyguardView.this.updateScreen(LockPatternKeyguardView.this.mMode, true);
            LockPatternKeyguardView.this.restoreWidgetState();
        }
    };
    private LockScreenWidgetCallback mWidgetCallback = new LockScreenWidgetCallback(){

        public void userActivity(View self) {
            LockPatternKeyguardView.this.mKeyguardScreenCallback.pokeWakelock(10000);
        }

        public void requestShow(View view) {
            view.setVisibility(0);
            LockPatternKeyguardView.this.mUpdateMonitor.reportClockVisible(false);
            if (LockPatternKeyguardView.this.findViewById(16908959) == null) {
                LockPatternKeyguardView.this.setBackgroundColor(-16777216);
            } else {
                LockPatternKeyguardView.this.resetBackground();
            }
        }

        public void requestHide(View view) {
            view.setVisibility(8);
            LockPatternKeyguardView.this.mUpdateMonitor.reportClockVisible(true);
            LockPatternKeyguardView.this.resetBackground();
        }

        public boolean isVisible(View self) {
            return self.getVisibility() == 0;
        }
    };
    private TransportControlView mTransportControlView;
    private Parcelable mSavedState;
    private ServiceConnection mFaceLockConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder iservice) {
            LockPatternKeyguardView.this.mFaceLockService = IFaceLockInterface.Stub.asInterface((IBinder)iservice);
            try {
                LockPatternKeyguardView.this.mFaceLockService.registerCallback(LockPatternKeyguardView.this.mFaceLockCallback);
            }
            catch (RemoteException e) {
                Log.e((String)LockPatternKeyguardView.TAG, (String)("Caught exception connecting to FaceLock: " + e.toString()));
                LockPatternKeyguardView.this.mFaceLockService = null;
                LockPatternKeyguardView.this.mBoundToFaceLockService = false;
                return;
            }
            if (LockPatternKeyguardView.this.mFaceLockAreaView != null) {
                LockPatternKeyguardView.this.startFaceLock(LockPatternKeyguardView.this.mFaceLockAreaView.getWindowToken(), LockPatternKeyguardView.this.mFaceLockAreaView.getLeft(), LockPatternKeyguardView.this.mFaceLockAreaView.getTop(), LockPatternKeyguardView.this.mFaceLockAreaView.getWidth(), LockPatternKeyguardView.this.mFaceLockAreaView.getHeight());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Object object = LockPatternKeyguardView.this.mFaceLockServiceRunningLock;
            synchronized (object) {
                LockPatternKeyguardView.this.mFaceLockService = null;
                LockPatternKeyguardView.this.mFaceLockServiceRunning = false;
            }
            LockPatternKeyguardView.this.mBoundToFaceLockService = false;
            Log.w((String)LockPatternKeyguardView.TAG, (String)"Unexpected disconnect from FaceLock service");
        }
    };
    private final IFaceLockCallback mFaceLockCallback = new IFaceLockCallback.Stub(){

        public void unlock() {
            LockPatternKeyguardView.this.showFaceLockArea();
            LockPatternKeyguardView.this.stopFaceLock();
            LockPatternKeyguardView.this.mKeyguardScreenCallback.keyguardDone(true);
            LockPatternKeyguardView.this.mKeyguardScreenCallback.reportSuccessfulUnlockAttempt();
        }

        public void cancel() {
            LockPatternKeyguardView.this.hideFaceLockArea();
            LockPatternKeyguardView.this.stopFaceLock();
            LockPatternKeyguardView.this.mKeyguardScreenCallback.pokeWakelock(5000);
        }

        public void reportFailedAttempt() {
            LockPatternKeyguardView.this.mFailedFaceUnlockAttempts++;
            LockPatternKeyguardView.this.hideFaceLockArea();
            LockPatternKeyguardView.this.stopFaceLock();
            LockPatternKeyguardView.this.mKeyguardScreenCallback.pokeWakelock(5000);
        }

        public void exposeFallback() {
            LockPatternKeyguardView.this.hideFaceLockArea();
        }

        public void pokeWakelock() {
            LockPatternKeyguardView.this.mKeyguardScreenCallback.pokeWakelock();
        }
    };

    private boolean stuckOnLockScreenBecauseSimMissing() {
        return this.mRequiresSim && !this.mUpdateMonitor.isDeviceProvisioned() && (this.mUpdateMonitor.getSimState() == IccCard.State.ABSENT || this.mUpdateMonitor.getSimState() == IccCard.State.PERM_DISABLED);
    }

    public LockPatternKeyguardView(Context context, KeyguardUpdateMonitor updateMonitor, LockPatternUtils lockPatternUtils, KeyguardWindowController controller) {
        super(context);
        this.mHandler = new Handler((Handler.Callback)this);
        this.mConfiguration = context.getResources().getConfiguration();
        this.mEnableFallback = false;
        this.mRequiresSim = TextUtils.isEmpty((CharSequence)SystemProperties.get((String)"keyguard.no_require_sim"));
        this.mUpdateMonitor = updateMonitor;
        this.mLockPatternUtils = lockPatternUtils;
        this.mWindowController = controller;
        this.mHasOverlay = false;
        this.mUpdateMonitor.registerInfoCallback(this);
        this.mKeyguardScreenCallback = new KeyguardScreenCallback(){

            public void goToLockScreen() {
                LockPatternKeyguardView.this.mForgotPattern = false;
                if (LockPatternKeyguardView.this.mIsVerifyUnlockOnly) {
                    LockPatternKeyguardView.this.mIsVerifyUnlockOnly = false;
                    LockPatternKeyguardView.this.getCallback().keyguardDone(false);
                } else {
                    LockPatternKeyguardView.this.updateScreen(Mode.LockScreen, false);
                }
            }

            public void goToUnlockScreen() {
                IccCard.State simState = LockPatternKeyguardView.this.mUpdateMonitor.getSimState();
                if (LockPatternKeyguardView.this.stuckOnLockScreenBecauseSimMissing() || simState == IccCard.State.PUK_REQUIRED && !LockPatternKeyguardView.this.mLockPatternUtils.isPukUnlockScreenEnable()) {
                    return;
                }
                if (!this.isSecure()) {
                    LockPatternKeyguardView.this.getCallback().keyguardDone(true);
                } else {
                    LockPatternKeyguardView.this.updateScreen(Mode.UnlockScreen, false);
                }
            }

            public void forgotPattern(boolean isForgotten) {
                if (LockPatternKeyguardView.this.mEnableFallback) {
                    LockPatternKeyguardView.this.mForgotPattern = isForgotten;
                    LockPatternKeyguardView.this.updateScreen(Mode.UnlockScreen, false);
                }
            }

            public boolean isSecure() {
                return LockPatternKeyguardView.this.isSecure();
            }

            public boolean isVerifyUnlockOnly() {
                return LockPatternKeyguardView.this.mIsVerifyUnlockOnly;
            }

            public void recreateMe(Configuration config) {
                LockPatternKeyguardView.this.removeCallbacks(LockPatternKeyguardView.this.mRecreateRunnable);
                LockPatternKeyguardView.this.post(LockPatternKeyguardView.this.mRecreateRunnable);
            }

            public void takeEmergencyCallAction() {
                LockPatternKeyguardView.this.mHasOverlay = true;
                if (LockPatternKeyguardView.this.usingFaceLock() && LockPatternKeyguardView.this.mFaceLockServiceRunning) {
                    LockPatternKeyguardView.this.showFaceLockAreaWithTimeout(1000L);
                }
                LockPatternKeyguardView.this.stopAndUnbindFromFaceLock();
                this.pokeWakelock(10000);
                if (TelephonyManager.getDefault().getCallState() == 2) {
                    LockPatternKeyguardView.this.mLockPatternUtils.resumeCall();
                } else {
                    Intent intent = new Intent(LockPatternKeyguardView.ACTION_EMERGENCY_DIAL);
                    intent.setFlags(0x10800000);
                    LockPatternKeyguardView.this.getContext().startActivity(intent);
                }
            }

            public void pokeWakelock() {
                LockPatternKeyguardView.this.getCallback().pokeWakelock();
            }

            public void pokeWakelock(int millis) {
                LockPatternKeyguardView.this.getCallback().pokeWakelock(millis);
            }

            public void keyguardDone(boolean authenticated) {
                LockPatternKeyguardView.this.getCallback().keyguardDone(authenticated);
                LockPatternKeyguardView.this.mSavedState = null;
            }

            public void keyguardDoneDrawing() {
            }

            public void reportFailedUnlockAttempt() {
                int remainingBeforeWipe;
                LockPatternKeyguardView.this.mUpdateMonitor.reportFailedAttempt();
                int failedAttempts = LockPatternKeyguardView.this.mUpdateMonitor.getFailedAttempts();
                boolean usingPattern = LockPatternKeyguardView.this.mLockPatternUtils.getKeyguardStoredPasswordQuality() == 65536;
                int failedAttemptsBeforeWipe = LockPatternKeyguardView.this.mLockPatternUtils.getDevicePolicyManager().getMaximumFailedPasswordsForWipe(null);
                int failedAttemptWarning = 15;
                int n = remainingBeforeWipe = failedAttemptsBeforeWipe > 0 ? failedAttemptsBeforeWipe - failedAttempts : Integer.MAX_VALUE;
                if (remainingBeforeWipe < 5) {
                    if (remainingBeforeWipe > 0) {
                        LockPatternKeyguardView.this.showAlmostAtWipeDialog(failedAttempts, remainingBeforeWipe);
                    } else {
                        Slog.i((String)LockPatternKeyguardView.TAG, (String)"Too many unlock attempts; device will be wiped!");
                        LockPatternKeyguardView.this.showWipeDialog(failedAttempts);
                    }
                } else {
                    boolean showTimeout;
                    boolean bl = showTimeout = failedAttempts % 5 == 0;
                    if (usingPattern && LockPatternKeyguardView.this.mEnableFallback) {
                        if (failedAttempts == 15) {
                            LockPatternKeyguardView.this.showAlmostAtAccountLoginDialog();
                            showTimeout = false;
                        } else if (failedAttempts >= 20) {
                            LockPatternKeyguardView.this.mLockPatternUtils.setPermanentlyLocked(true);
                            LockPatternKeyguardView.this.updateScreen(LockPatternKeyguardView.this.mMode, false);
                            showTimeout = false;
                        }
                    }
                    if (showTimeout) {
                        LockPatternKeyguardView.this.showTimeoutDialog();
                    }
                }
                LockPatternKeyguardView.this.mLockPatternUtils.reportFailedPasswordAttempt();
            }

            public boolean doesFallbackUnlockScreenExist() {
                return LockPatternKeyguardView.this.mEnableFallback;
            }

            public void reportSuccessfulUnlockAttempt() {
                LockPatternKeyguardView.this.mFailedFaceUnlockAttempts = 0;
                LockPatternKeyguardView.this.mLockPatternUtils.reportSuccessfulPasswordAttempt();
            }
        };
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.updateScreen(this.getInitialMode(), false);
        this.maybeEnableFallback(context);
    }

    private void maybeEnableFallback(Context context) {
        AccountAnalyzer accountAnalyzer = new AccountAnalyzer(AccountManager.get((Context)context));
        accountAnalyzer.start();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
    }

    public void reset() {
        this.mIsVerifyUnlockOnly = false;
        this.mForgotPattern = false;
        this.post(this.mRecreateRunnable);
    }

    public void onScreenTurnedOff() {
        this.mScreenOn = false;
        this.mForgotPattern = false;
        boolean bl = this.mHasOverlay = this.mUpdateMonitor.getPhoneState() != 0;
        if (this.mLockScreen != null) {
            ((KeyguardScreen)this.mLockScreen).onPause();
        }
        if (this.mUnlockScreen != null) {
            ((KeyguardScreen)this.mUnlockScreen).onPause();
        }
        this.saveWidgetState();
        this.stopAndUnbindFromFaceLock();
    }

    private void activateFaceLockIfAble() {
        boolean backupIsTimedOut;
        boolean tooManyFaceUnlockTries = this.mFailedFaceUnlockAttempts >= 15;
        int failedBackupAttempts = this.mUpdateMonitor.getFailedAttempts();
        boolean bl = backupIsTimedOut = failedBackupAttempts >= 5;
        if (tooManyFaceUnlockTries) {
            Log.i((String)TAG, (String)("tooManyFaceUnlockTries: " + tooManyFaceUnlockTries));
        }
        if (!(this.mUpdateMonitor.getPhoneState() != 0 || this.mHasOverlay || tooManyFaceUnlockTries || backupIsTimedOut)) {
            this.bindToFaceLock();
            if (this.usingFaceLock()) {
                this.showFaceLockAreaWithTimeout(3000L);
            }
        } else {
            this.hideFaceLockArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScreenTurnedOn() {
        boolean runFaceLock = false;
        Object object = this.mFaceLockStartupLock;
        synchronized (object) {
            this.mScreenOn = true;
            runFaceLock = this.mWindowFocused;
        }
        this.show();
        this.restoreWidgetState();
        if (runFaceLock) {
            this.activateFaceLockIfAble();
        }
    }

    private void saveWidgetState() {
        if (this.mTransportControlView != null) {
            this.mSavedState = this.mTransportControlView.onSaveInstanceState();
        }
    }

    private void restoreWidgetState() {
        if (this.mTransportControlView != null && this.mSavedState != null) {
            this.mTransportControlView.onRestoreInstanceState(this.mSavedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        boolean runFaceLock = false;
        Object object = this.mFaceLockStartupLock;
        synchronized (object) {
            if (this.mScreenOn && !this.mWindowFocused) {
                runFaceLock = hasWindowFocus;
            }
            this.mWindowFocused = hasWindowFocus;
        }
        if (!hasWindowFocus) {
            this.mHasOverlay = true;
            this.stopAndUnbindFromFaceLock();
            this.hideFaceLockArea();
        } else if (runFaceLock) {
            this.activateFaceLockIfAble();
        }
    }

    public void show() {
        if (this.mLockScreen != null) {
            ((KeyguardScreen)this.mLockScreen).onResume();
        }
        if (this.mUnlockScreen != null) {
            ((KeyguardScreen)this.mUnlockScreen).onResume();
        }
        if (this.usingFaceLock() && !this.mHasOverlay) {
            this.showFaceLockArea();
        } else {
            this.hideFaceLockArea();
        }
    }

    private void recreateLockScreen() {
        if (this.mLockScreen != null) {
            ((KeyguardScreen)this.mLockScreen).onPause();
            ((KeyguardScreen)this.mLockScreen).cleanUp();
            this.removeView(this.mLockScreen);
        }
        this.mLockScreen = this.createLockScreen();
        this.mLockScreen.setVisibility(4);
        this.addView(this.mLockScreen);
    }

    private void recreateUnlockScreen(UnlockMode unlockMode) {
        if (this.mUnlockScreen != null) {
            ((KeyguardScreen)this.mUnlockScreen).onPause();
            ((KeyguardScreen)this.mUnlockScreen).cleanUp();
            this.removeView(this.mUnlockScreen);
        }
        this.mUnlockScreen = this.createUnlockScreenFor(unlockMode);
        this.mUnlockScreen.setVisibility(4);
        this.addView(this.mUnlockScreen);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mRecreateRunnable);
        this.stopAndUnbindFromFaceLock();
        super.onDetachedFromWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        Resources resources = this.getResources();
        this.mShowLockBeforeUnlock = resources.getBoolean(0x111001B);
        this.mConfiguration = newConfig;
        this.saveWidgetState();
        this.removeCallbacks(this.mRecreateRunnable);
        this.post(this.mRecreateRunnable);
    }

    public void onRefreshBatteryInfo(boolean showBatteryInfo, boolean pluggedIn, int batteryLevel) {
    }

    public void onTimeChanged() {
    }

    public void onRefreshCarrierInfo(CharSequence plmn, CharSequence spn) {
    }

    public void onRingerModeChanged(int state) {
    }

    public void onClockVisibilityChanged() {
        int visFlags = this.getSystemUiVisibility() & 0xFF7FFFFF;
        this.setSystemUiVisibility(visFlags | (this.mUpdateMonitor.isClockVisible() ? 0x800000 : 0));
    }

    public void onDeviceProvisioned() {
    }

    public void onPhoneStateChanged(int phoneState) {
        if (phoneState == 1) {
            this.mHasOverlay = true;
            this.stopAndUnbindFromFaceLock();
            this.hideFaceLockArea();
        }
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance((Context)this.mContext);
        if (accessibilityManager.isEnabled() && accessibilityManager.isTouchExplorationEnabled()) {
            this.getCallback().pokeWakelock();
        }
        return super.dispatchHoverEvent(event);
    }

    public void wakeWhenReadyTq(int keyCode) {
        if (keyCode == 82 && this.isSecure() && this.mMode == Mode.LockScreen && this.mUpdateMonitor.getSimState() != IccCard.State.PUK_REQUIRED) {
            this.updateScreen(Mode.UnlockScreen, false);
            this.getCallback().pokeWakelock();
        } else {
            this.getCallback().pokeWakelock();
        }
    }

    public void verifyUnlock() {
        if (!this.isSecure()) {
            this.getCallback().keyguardDone(true);
        } else if (this.mUnlockScreenMode != UnlockMode.Pattern && this.mUnlockScreenMode != UnlockMode.Password) {
            this.getCallback().keyguardDone(false);
        } else {
            this.mIsVerifyUnlockOnly = true;
            this.updateScreen(Mode.UnlockScreen, false);
        }
    }

    public void cleanUp() {
        if (this.mLockScreen != null) {
            ((KeyguardScreen)this.mLockScreen).onPause();
            ((KeyguardScreen)this.mLockScreen).cleanUp();
            this.removeView(this.mLockScreen);
            this.mLockScreen = null;
        }
        if (this.mUnlockScreen != null) {
            ((KeyguardScreen)this.mUnlockScreen).onPause();
            ((KeyguardScreen)this.mUnlockScreen).cleanUp();
            this.removeView(this.mUnlockScreen);
            this.mUnlockScreen = null;
        }
        this.mUpdateMonitor.removeCallback(this);
        if (this.mFaceLockService != null) {
            try {
                this.mFaceLockService.unregisterCallback(this.mFaceLockCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.stopFaceLock();
            this.mFaceLockService = null;
        }
    }

    private boolean isSecure() {
        UnlockMode unlockMode = this.getUnlockMode();
        boolean secure = false;
        switch (unlockMode) {
            case Pattern: {
                secure = this.mLockPatternUtils.isLockPatternEnabled();
                break;
            }
            case SimPin: {
                secure = this.mUpdateMonitor.getSimState() == IccCard.State.PIN_REQUIRED;
                break;
            }
            case SimPuk: {
                secure = this.mUpdateMonitor.getSimState() == IccCard.State.PUK_REQUIRED;
                break;
            }
            case Account: {
                secure = true;
                break;
            }
            case Password: {
                secure = this.mLockPatternUtils.isLockPasswordEnabled();
                break;
            }
            default: {
                throw new IllegalStateException("unknown unlock mode " + (Object)((Object)unlockMode));
            }
        }
        return secure;
    }

    private void updateScreen(Mode mode, boolean force) {
        this.mMode = mode;
        if ((mode == Mode.LockScreen || this.mShowLockBeforeUnlock) && (force || this.mLockScreen == null)) {
            this.recreateLockScreen();
        }
        if (mode == Mode.UnlockScreen) {
            UnlockMode unlockMode = this.getUnlockMode();
            if (force || this.mUnlockScreen == null || unlockMode != this.mUnlockScreenMode) {
                boolean restartFaceLock = this.stopFaceLockIfRunning();
                this.recreateUnlockScreen(unlockMode);
                if (restartFaceLock) {
                    this.activateFaceLockIfAble();
                }
            }
        }
        View goneScreen = mode == Mode.LockScreen ? this.mUnlockScreen : this.mLockScreen;
        View visibleScreen = mode == Mode.LockScreen ? this.mLockScreen : this.mUnlockScreen;
        this.mWindowController.setNeedsInput(((KeyguardScreen)visibleScreen).needsInput());
        if (this.mScreenOn) {
            if (goneScreen != null && goneScreen.getVisibility() == 0) {
                ((KeyguardScreen)goneScreen).onPause();
            }
            if (visibleScreen.getVisibility() != 0) {
                ((KeyguardScreen)visibleScreen).onResume();
            }
        }
        if (goneScreen != null) {
            goneScreen.setVisibility(8);
        }
        visibleScreen.setVisibility(0);
        this.requestLayout();
        if (!visibleScreen.requestFocus()) {
            throw new IllegalStateException("keyguard screen must be able to take focus when shown " + visibleScreen.getClass().getCanonicalName());
        }
    }

    View createLockScreen() {
        LockScreen lockView = new LockScreen(this.mContext, this.mConfiguration, this.mLockPatternUtils, this.mUpdateMonitor, this.mKeyguardScreenCallback);
        this.initializeTransportControlView((View)lockView);
        return lockView;
    }

    View createUnlockScreenFor(UnlockMode unlockMode) {
        KeyguardScreen unlockView = null;
        if (unlockMode == UnlockMode.Pattern) {
            PatternUnlockScreen view = new PatternUnlockScreen(this.mContext, this.mConfiguration, this.mLockPatternUtils, this.mUpdateMonitor, this.mKeyguardScreenCallback, this.mUpdateMonitor.getFailedAttempts());
            view.setEnableFallback(this.mEnableFallback);
            unlockView = view;
        } else if (unlockMode == UnlockMode.SimPuk) {
            unlockView = new SimPukUnlockScreen(this.mContext, this.mConfiguration, this.mUpdateMonitor, this.mKeyguardScreenCallback, this.mLockPatternUtils);
        } else if (unlockMode == UnlockMode.SimPin) {
            unlockView = new SimUnlockScreen(this.mContext, this.mConfiguration, this.mUpdateMonitor, this.mKeyguardScreenCallback, this.mLockPatternUtils);
        } else if (unlockMode == UnlockMode.Account) {
            try {
                unlockView = new AccountUnlockScreen(this.mContext, this.mConfiguration, this.mUpdateMonitor, this.mKeyguardScreenCallback, this.mLockPatternUtils);
            }
            catch (IllegalStateException e) {
                Log.i((String)TAG, (String)"Couldn't instantiate AccountUnlockScreen (IAccountsService isn't available)");
                return this.createUnlockScreenFor(UnlockMode.Pattern);
            }
        } else if (unlockMode == UnlockMode.Password) {
            unlockView = new PasswordUnlockScreen(this.mContext, this.mConfiguration, this.mLockPatternUtils, this.mUpdateMonitor, this.mKeyguardScreenCallback);
        } else {
            throw new IllegalArgumentException("unknown unlock mode " + (Object)((Object)unlockMode));
        }
        this.initializeTransportControlView((View)unlockView);
        this.initializeFaceLockAreaView((View)unlockView);
        this.mUnlockScreenMode = unlockMode;
        return unlockView;
    }

    private void initializeTransportControlView(View view) {
        this.mTransportControlView = (TransportControlView)view.findViewById(16908957);
        if (this.mTransportControlView != null) {
            this.mUpdateMonitor.reportClockVisible(true);
            this.mTransportControlView.setVisibility(8);
            this.mTransportControlView.setCallback(this.mWidgetCallback);
        }
    }

    private Mode getInitialMode() {
        IccCard.State simState = this.mUpdateMonitor.getSimState();
        if (this.stuckOnLockScreenBecauseSimMissing() || simState == IccCard.State.PUK_REQUIRED && !this.mLockPatternUtils.isPukUnlockScreenEnable()) {
            return Mode.LockScreen;
        }
        if (!this.isSecure() || this.mShowLockBeforeUnlock) {
            return Mode.LockScreen;
        }
        return Mode.UnlockScreen;
    }

    private UnlockMode getUnlockMode() {
        UnlockMode currentMode;
        IccCard.State simState = this.mUpdateMonitor.getSimState();
        if (simState == IccCard.State.PIN_REQUIRED) {
            currentMode = UnlockMode.SimPin;
        } else if (simState == IccCard.State.PUK_REQUIRED) {
            currentMode = UnlockMode.SimPuk;
        } else {
            int mode = this.mLockPatternUtils.getKeyguardStoredPasswordQuality();
            switch (mode) {
                case 131072: 
                case 262144: 
                case 327680: 
                case 393216: {
                    currentMode = UnlockMode.Password;
                    break;
                }
                case 0: 
                case 65536: {
                    if (this.mForgotPattern || this.mLockPatternUtils.isPermanentlyLocked()) {
                        currentMode = UnlockMode.Account;
                        break;
                    }
                    currentMode = UnlockMode.Pattern;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown unlock mode:" + mode);
                }
            }
        }
        return currentMode;
    }

    private void showDialog(String title, String message) {
        AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)title).setMessage((CharSequence)message).setNeutralButton(17039370, null).create();
        dialog.getWindow().setType(2009);
        dialog.show();
    }

    private void showTimeoutDialog() {
        int timeoutInSeconds = 30;
        int messageId = 17040120;
        if (this.getUnlockMode() == UnlockMode.Password) {
            messageId = this.mLockPatternUtils.getKeyguardStoredPasswordQuality() == 131072 ? 17040122 : 17040121;
        }
        String message = this.mContext.getString(messageId, new Object[]{this.mUpdateMonitor.getFailedAttempts(), timeoutInSeconds});
        this.showDialog(null, message);
    }

    private void showAlmostAtAccountLoginDialog() {
        int timeoutInSeconds = 30;
        int count = 15;
        String message = this.mContext.getString(17040123, new Object[]{15, 5, 30});
        this.showDialog(null, message);
    }

    private void showAlmostAtWipeDialog(int attempts, int remaining) {
        int timeoutInSeconds = 30;
        String message = this.mContext.getString(17040124, new Object[]{attempts, remaining});
        this.showDialog(null, message);
    }

    private void showWipeDialog(int attempts) {
        String message = this.mContext.getString(17040125, new Object[]{attempts});
        this.showDialog(null, message);
    }

    private boolean usingFaceLock() {
        return this.mLockPatternUtils.usingBiometricWeak() && this.mLockPatternUtils.isBiometricWeakInstalled();
    }

    private void initializeFaceLockAreaView(View view) {
        if (this.usingFaceLock()) {
            this.mFaceLockAreaView = view.findViewById(16908958);
            if (this.mFaceLockAreaView == null) {
                Log.e((String)TAG, (String)"Layout does not have faceLockAreaView and FaceLock is enabled");
            }
        } else {
            this.mFaceLockAreaView = null;
        }
    }

    private boolean stopFaceLockIfRunning() {
        if (this.usingFaceLock() && this.mBoundToFaceLockService) {
            this.stopAndUnbindFromFaceLock();
            return true;
        }
        return false;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.mFaceLockAreaView == null) break;
                this.mFaceLockAreaView.setVisibility(0);
                break;
            }
            case 1: {
                if (this.mFaceLockAreaView == null) break;
                this.mFaceLockAreaView.setVisibility(4);
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unhandled message");
                return false;
            }
        }
        return true;
    }

    private void removeFaceLockAreaDisplayMessages() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
    }

    private void showFaceLockArea() {
        this.removeFaceLockAreaDisplayMessages();
        this.mHandler.sendEmptyMessage(0);
    }

    private void hideFaceLockArea() {
        this.removeFaceLockAreaDisplayMessages();
        this.mHandler.sendEmptyMessage(1);
    }

    private void showFaceLockAreaWithTimeout(long timeoutMillis) {
        this.showFaceLockArea();
        this.mHandler.sendEmptyMessageDelayed(1, timeoutMillis);
    }

    public void bindToFaceLock() {
        if (this.usingFaceLock()) {
            if (!this.mBoundToFaceLockService) {
                this.mContext.bindService(new Intent(IFaceLockInterface.class.getName()), this.mFaceLockConnection, 1);
                this.mBoundToFaceLockService = true;
            } else {
                Log.w((String)TAG, (String)"Attempt to bind to FaceLock when already bound");
            }
        }
    }

    public void stopAndUnbindFromFaceLock() {
        if (this.usingFaceLock()) {
            this.stopFaceLock();
            if (this.mBoundToFaceLockService) {
                if (this.mFaceLockService != null) {
                    try {
                        this.mFaceLockService.unregisterCallback(this.mFaceLockCallback);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mContext.unbindService(this.mFaceLockConnection);
                this.mBoundToFaceLockService = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFaceLock(IBinder windowToken, int x, int y, int h, int w) {
        if (this.usingFaceLock()) {
            Object object = this.mFaceLockServiceRunningLock;
            synchronized (object) {
                if (!this.mFaceLockServiceRunning) {
                    try {
                        this.mFaceLockService.startUi(windowToken, x, y, h, w);
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)("Caught exception starting FaceLock: " + e.toString()));
                        return;
                    }
                    this.mFaceLockServiceRunning = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFaceLock() {
        if (this.usingFaceLock()) {
            Object object = this.mFaceLockServiceRunningLock;
            synchronized (object) {
                if (this.mFaceLockServiceRunning) {
                    try {
                        this.mFaceLockService.stopUi();
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)("Caught exception stopping FaceLock: " + e.toString()));
                    }
                    this.mFaceLockServiceRunning = false;
                }
            }
        }
    }

    private static class FastBitmapDrawable
    extends Drawable {
        private Bitmap mBitmap;
        private int mOpacity;

        private FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mOpacity = this.mBitmap.hasAlpha() ? -3 : -1;
        }

        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, (float)((this.getBounds().width() - this.mBitmap.getWidth()) / 2), (float)(this.getBounds().height() - this.mBitmap.getHeight()), null);
        }

        public int getOpacity() {
            return this.mOpacity;
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getIntrinsicWidth() {
            return this.mBitmap.getWidth();
        }

        public int getIntrinsicHeight() {
            return this.mBitmap.getHeight();
        }

        public int getMinimumWidth() {
            return this.mBitmap.getWidth();
        }

        public int getMinimumHeight() {
            return this.mBitmap.getHeight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccountAnalyzer
    implements AccountManagerCallback<Bundle> {
        private final AccountManager mAccountManager;
        private final Account[] mAccounts;
        private int mAccountIndex;

        private AccountAnalyzer(AccountManager accountManager) {
            this.mAccountManager = accountManager;
            this.mAccounts = accountManager.getAccountsByType("com.google");
        }

        private void next() {
            if (LockPatternKeyguardView.this.mEnableFallback || this.mAccountIndex >= this.mAccounts.length) {
                if (LockPatternKeyguardView.this.mUnlockScreen != null && LockPatternKeyguardView.this.mUnlockScreen instanceof PatternUnlockScreen) {
                    ((PatternUnlockScreen)LockPatternKeyguardView.this.mUnlockScreen).setEnableFallback(LockPatternKeyguardView.this.mEnableFallback);
                }
                return;
            }
            this.mAccountManager.confirmCredentials(this.mAccounts[this.mAccountIndex], null, null, (AccountManagerCallback)this, null);
        }

        public void start() {
            LockPatternKeyguardView.this.mEnableFallback = false;
            this.mAccountIndex = 0;
            this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(AccountManagerFuture<Bundle> future) {
            try {
                Bundle result = (Bundle)future.getResult();
                if (result.getParcelable("intent") != null) {
                    LockPatternKeyguardView.this.mEnableFallback = true;
                }
            }
            catch (OperationCanceledException e) {
            }
            catch (IOException e) {
            }
            catch (AuthenticatorException authenticatorException) {
            }
            finally {
                ++this.mAccountIndex;
                this.next();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UnlockMode {
        Pattern,
        SimPin,
        SimPuk,
        Account,
        Password,
        Unknown;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        LockScreen,
        UnlockScreen;

    }
}

