/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.media.AudioManager;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.SlidingTab;
import com.android.internal.widget.WaveView;
import com.android.internal.widget.multiwaveview.MultiWaveView;
import java.io.File;

class LockScreen
extends LinearLayout
implements KeyguardScreen {
    private static final int ON_RESUME_PING_DELAY = 500;
    private static final boolean DBG = false;
    private static final String TAG = "LockScreen";
    private static final String ENABLE_MENU_KEY_FILE = "/data/local/enable_menu_key";
    private static final int WAIT_FOR_ANIMATION_TIMEOUT = 0;
    private static final int STAY_ON_WHILE_GRABBED_TIMEOUT = 30000;
    private LockPatternUtils mLockPatternUtils;
    private KeyguardUpdateMonitor mUpdateMonitor;
    private KeyguardScreenCallback mCallback;
    private int mKeyboardHidden;
    private int mCreationOrientation;
    private boolean mSilentMode;
    private AudioManager mAudioManager;
    private boolean mEnableMenuKeyInLockScreen;
    private KeyguardStatusViewManager mStatusViewManager;
    private UnlockWidgetCommonMethods mUnlockWidgetMethods;
    private View mUnlockWidget;
    private final Runnable mOnResumePing = new Runnable(){

        public void run() {
            LockScreen.this.mUnlockWidgetMethods.ping();
        }
    };

    private void requestUnlockScreen() {
        this.postDelayed(new Runnable(){

            public void run() {
                LockScreen.this.mCallback.goToUnlockScreen();
            }
        }, 0L);
    }

    private void toggleRingMode() {
        boolean bl = this.mSilentMode = !this.mSilentMode;
        if (this.mSilentMode) {
            boolean vibe = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"vibrate_in_silent", (int)1) == 1;
            this.mAudioManager.setRingerMode(vibe ? 1 : 0);
        } else {
            this.mAudioManager.setRingerMode(2);
        }
    }

    private boolean shouldEnableMenuKey() {
        Resources res = this.getResources();
        boolean configDisabled = res.getBoolean(0x111001A);
        boolean isTestHarness = ActivityManager.isRunningInTestHarness();
        boolean fileOverride = new File(ENABLE_MENU_KEY_FILE).exists();
        return !configDisabled || isTestHarness || fileOverride;
    }

    LockScreen(Context context, Configuration configuration, LockPatternUtils lockPatternUtils, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback) {
        super(context);
        this.mLockPatternUtils = lockPatternUtils;
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mEnableMenuKeyInLockScreen = this.shouldEnableMenuKey();
        this.mCreationOrientation = configuration.orientation;
        this.mKeyboardHidden = configuration.hardKeyboardHidden;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (this.mCreationOrientation != 2) {
            inflater.inflate(17367126, (ViewGroup)this, true);
        } else {
            inflater.inflate(17367127, (ViewGroup)this, true);
        }
        this.mStatusViewManager = new KeyguardStatusViewManager((View)this, this.mUpdateMonitor, this.mLockPatternUtils, this.mCallback, false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(393216);
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mSilentMode = this.isSilentMode();
        this.mUnlockWidget = this.findViewById(16908972);
        if (this.mUnlockWidget instanceof SlidingTab) {
            SlidingTab slidingTabView = (SlidingTab)this.mUnlockWidget;
            slidingTabView.setHoldAfterTrigger(true, false);
            slidingTabView.setLeftHintText(17040137);
            slidingTabView.setLeftTabResources(17302219, 17302422, 17302391, 17302410);
            SlidingTabMethods slidingTabMethods = new SlidingTabMethods(slidingTabView);
            slidingTabView.setOnTriggerListener((SlidingTab.OnTriggerListener)slidingTabMethods);
            this.mUnlockWidgetMethods = slidingTabMethods;
        } else if (this.mUnlockWidget instanceof WaveView) {
            WaveView waveView = (WaveView)this.mUnlockWidget;
            WaveViewMethods waveViewMethods = new WaveViewMethods(waveView);
            waveView.setOnTriggerListener((WaveView.OnTriggerListener)waveViewMethods);
            this.mUnlockWidgetMethods = waveViewMethods;
        } else if (this.mUnlockWidget instanceof MultiWaveView) {
            MultiWaveView multiWaveView = (MultiWaveView)this.mUnlockWidget;
            MultiWaveViewMethods multiWaveViewMethods = new MultiWaveViewMethods(multiWaveView);
            multiWaveView.setOnTriggerListener((MultiWaveView.OnTriggerListener)multiWaveViewMethods);
            this.mUnlockWidgetMethods = multiWaveViewMethods;
        } else {
            throw new IllegalStateException("Unrecognized unlock widget: " + this.mUnlockWidget);
        }
        this.mUnlockWidgetMethods.updateResources();
    }

    private boolean isSilentMode() {
        return this.mAudioManager.getRingerMode() != 2;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 82 && this.mEnableMenuKeyInLockScreen) {
            this.mCallback.goToUnlockScreen();
        }
        return false;
    }

    void updateConfiguration() {
        Configuration newConfig = this.getResources().getConfiguration();
        if (newConfig.orientation != this.mCreationOrientation) {
            this.mCallback.recreateMe(newConfig);
        } else if (newConfig.hardKeyboardHidden != this.mKeyboardHidden) {
            boolean isKeyboardOpen;
            this.mKeyboardHidden = newConfig.hardKeyboardHidden;
            boolean bl = isKeyboardOpen = this.mKeyboardHidden == 1;
            if (this.mUpdateMonitor.isKeyguardBypassEnabled() && isKeyboardOpen) {
                this.mCallback.goToUnlockScreen();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateConfiguration();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateConfiguration();
    }

    public boolean needsInput() {
        return false;
    }

    public void onPause() {
        this.mStatusViewManager.onPause();
        this.mUnlockWidgetMethods.reset(false);
    }

    public void onResume() {
        this.mStatusViewManager.onResume();
        this.postDelayed(this.mOnResumePing, 500L);
    }

    public void cleanUp() {
        this.mUpdateMonitor.removeCallback(this);
        this.mLockPatternUtils = null;
        this.mUpdateMonitor = null;
        this.mCallback = null;
    }

    public void onRingerModeChanged(int state) {
        boolean silent;
        boolean bl = silent = 2 != state;
        if (silent != this.mSilentMode) {
            this.mSilentMode = silent;
            this.mUnlockWidgetMethods.updateResources();
        }
    }

    public void onPhoneStateChanged(String newState) {
    }

    class MultiWaveViewMethods
    implements MultiWaveView.OnTriggerListener,
    UnlockWidgetCommonMethods {
        private final MultiWaveView mMultiWaveView;
        private boolean mCameraDisabled;

        MultiWaveViewMethods(MultiWaveView multiWaveView) {
            this.mMultiWaveView = multiWaveView;
            boolean cameraDisabled = LockScreen.this.mLockPatternUtils.getDevicePolicyManager().getCameraDisabled(null);
            if (cameraDisabled) {
                Log.v((String)LockScreen.TAG, (String)"Camera disabled by Device Policy");
                this.mCameraDisabled = true;
            } else {
                this.mCameraDisabled = this.mMultiWaveView.getTargetResourceId() != 0x1070010;
            }
        }

        public void updateResources() {
            int resId = this.mCameraDisabled ? (LockScreen.this.mSilentMode ? 17235979 : 17235982) : 0x1070010;
            this.mMultiWaveView.setTargetResources(resId);
        }

        public void onGrabbed(View v, int handle) {
        }

        public void onReleased(View v, int handle) {
        }

        public void onTrigger(View v, int target) {
            if (target == 0 || target == 1) {
                LockScreen.this.mCallback.goToUnlockScreen();
            } else if (target == 2 || target == 3) {
                if (!this.mCameraDisabled) {
                    Intent intent = new Intent("android.media.action.STILL_IMAGE_CAMERA");
                    intent.setFlags(0x10000000);
                    LockScreen.this.mContext.startActivity(intent);
                    LockScreen.this.mCallback.goToUnlockScreen();
                } else {
                    LockScreen.this.toggleRingMode();
                    LockScreen.this.mUnlockWidgetMethods.updateResources();
                    LockScreen.this.mCallback.pokeWakelock();
                }
            }
        }

        public void onGrabbedStateChange(View v, int handle) {
            if (handle != 0) {
                LockScreen.this.mCallback.pokeWakelock();
            }
        }

        public View getView() {
            return this.mMultiWaveView;
        }

        public void reset(boolean animate) {
            this.mMultiWaveView.reset(animate);
        }

        public void ping() {
            this.mMultiWaveView.ping();
        }
    }

    class WaveViewMethods
    implements WaveView.OnTriggerListener,
    UnlockWidgetCommonMethods {
        private final WaveView mWaveView;

        WaveViewMethods(WaveView waveView) {
            this.mWaveView = waveView;
        }

        public void onTrigger(View v, int whichHandle) {
            if (whichHandle == 10) {
                LockScreen.this.requestUnlockScreen();
            }
        }

        public void onGrabbedStateChange(View v, int grabbedState) {
            if (grabbedState == 10) {
                LockScreen.this.mCallback.pokeWakelock(30000);
            }
        }

        public void updateResources() {
        }

        public View getView() {
            return this.mWaveView;
        }

        public void reset(boolean animate) {
            this.mWaveView.reset();
        }

        public void ping() {
        }
    }

    class SlidingTabMethods
    implements SlidingTab.OnTriggerListener,
    UnlockWidgetCommonMethods {
        private final SlidingTab mSlidingTab;

        SlidingTabMethods(SlidingTab slidingTab) {
            this.mSlidingTab = slidingTab;
        }

        public void updateResources() {
            boolean vibe;
            boolean bl = vibe = LockScreen.this.mSilentMode && LockScreen.this.mAudioManager.getRingerMode() == 1;
            this.mSlidingTab.setRightTabResources(LockScreen.this.mSilentMode ? (vibe ? 17302220 : 17302217) : 17302218, LockScreen.this.mSilentMode ? 17302424 : 17302421, LockScreen.this.mSilentMode ? 17302401 : 17302400, LockScreen.this.mSilentMode ? 17302420 : 17302419);
        }

        public void onTrigger(View v, int whichHandle) {
            if (whichHandle == 1) {
                LockScreen.this.mCallback.goToUnlockScreen();
            } else if (whichHandle == 2) {
                LockScreen.this.toggleRingMode();
                LockScreen.this.mCallback.pokeWakelock();
            }
        }

        public void onGrabbedStateChange(View v, int grabbedState) {
            if (grabbedState == 2) {
                LockScreen.this.mSilentMode = LockScreen.this.isSilentMode();
                this.mSlidingTab.setRightHintText(LockScreen.this.mSilentMode ? 17040138 : 17040139);
            }
            if (grabbedState != 0) {
                LockScreen.this.mCallback.pokeWakelock();
            }
        }

        public View getView() {
            return this.mSlidingTab;
        }

        public void reset(boolean animate) {
            this.mSlidingTab.reset(animate);
        }

        public void ping() {
        }
    }

    private static interface UnlockWidgetCommonMethods {
        public void updateResources();

        public View getView();

        public void reset(boolean var1);

        public void ping();
    }
}

