/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.inputmethodservice.KeyboardView;
import android.os.CountDownTimer;
import android.os.SystemClock;
import android.provider.Settings;
import android.security.KeyStore;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.PasswordEntryKeyboardHelper;
import com.android.internal.widget.PasswordEntryKeyboardView;
import java.util.List;

public class PasswordUnlockScreen
extends LinearLayout
implements KeyguardScreen,
TextView.OnEditorActionListener {
    private static final String TAG = "PasswordUnlockScreen";
    private final KeyguardUpdateMonitor mUpdateMonitor;
    private final KeyguardScreenCallback mCallback;
    private final boolean mIsAlpha;
    private final EditText mPasswordEntry;
    private final LockPatternUtils mLockPatternUtils;
    private final PasswordEntryKeyboardView mKeyboardView;
    private final PasswordEntryKeyboardHelper mKeyboardHelper;
    private final int mCreationOrientation;
    private final int mCreationHardKeyboardHidden;
    private final KeyguardStatusViewManager mStatusViewManager;
    private final boolean mUseSystemIME = true;
    private boolean mResuming;
    private static final int MINIMUM_PASSWORD_LENGTH_BEFORE_REPORT = 3;

    public PasswordUnlockScreen(Context context, Configuration configuration, LockPatternUtils lockPatternUtils, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback) {
        super(context);
        ViewGroup.LayoutParams params;
        this.mCreationHardKeyboardHidden = configuration.hardKeyboardHidden;
        this.mCreationOrientation = configuration.orientation;
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mLockPatternUtils = lockPatternUtils;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        if (this.mCreationOrientation != 2) {
            layoutInflater.inflate(17367119, (ViewGroup)this, true);
        } else {
            layoutInflater.inflate(17367118, (ViewGroup)this, true);
        }
        this.mStatusViewManager = new KeyguardStatusViewManager((View)this, this.mUpdateMonitor, this.mLockPatternUtils, this.mCallback, true);
        int quality = lockPatternUtils.getKeyguardStoredPasswordQuality();
        this.mIsAlpha = 262144 == quality || 327680 == quality || 393216 == quality;
        this.mKeyboardView = (PasswordEntryKeyboardView)this.findViewById(16908799);
        this.mPasswordEntry = (EditText)this.findViewById(16908954);
        this.mPasswordEntry.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mKeyboardHelper = new PasswordEntryKeyboardHelper(context, (KeyboardView)this.mKeyboardView, (View)this, false);
        this.mKeyboardHelper.setEnableHaptics(Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"lock_pattern_tactile_feedback_enabled", (int)0) != 0);
        boolean imeOrDeleteButtonVisible = false;
        if (this.mIsAlpha) {
            this.mKeyboardHelper.setKeyboardMode(0);
            this.mKeyboardView.setVisibility(8);
        } else {
            this.mKeyboardHelper.setKeyboardMode(1);
            this.mKeyboardView.setVisibility(this.mCreationHardKeyboardHidden == 1 ? 4 : 0);
            View pinDelete = this.findViewById(16908955);
            if (pinDelete != null) {
                pinDelete.setVisibility(0);
                imeOrDeleteButtonVisible = true;
                pinDelete.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PasswordUnlockScreen.this.mKeyboardHelper.handleBackspace();
                    }
                });
            }
        }
        this.mPasswordEntry.requestFocus();
        if (this.mIsAlpha) {
            this.mPasswordEntry.setKeyListener((KeyListener)TextKeyListener.getInstance());
            this.mPasswordEntry.setInputType(129);
        } else {
            this.mPasswordEntry.setKeyListener((KeyListener)DigitsKeyListener.getInstance());
            this.mPasswordEntry.setInputType(18);
        }
        this.mPasswordEntry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PasswordUnlockScreen.this.mCallback.pokeWakelock();
            }
        });
        this.mPasswordEntry.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                if (!PasswordUnlockScreen.this.mResuming) {
                    PasswordUnlockScreen.this.mCallback.pokeWakelock();
                }
            }
        });
        View switchImeButton = this.findViewById(16908956);
        final InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (this.mIsAlpha && switchImeButton != null && this.hasMultipleEnabledIMEsOrSubtypes(imm, false)) {
            switchImeButton.setVisibility(0);
            imeOrDeleteButtonVisible = true;
            switchImeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PasswordUnlockScreen.this.mCallback.pokeWakelock();
                    imm.showInputMethodPicker();
                }
            });
        }
        if (!imeOrDeleteButtonVisible && (params = this.mPasswordEntry.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)params).leftMargin = 0;
            this.mPasswordEntry.setLayoutParams(params);
        }
    }

    private boolean hasMultipleEnabledIMEsOrSubtypes(InputMethodManager imm, boolean shouldIncludeAuxiliarySubtypes) {
        List enabledImis = imm.getEnabledInputMethodList();
        int filteredImisCount = 0;
        for (InputMethodInfo imi : enabledImis) {
            if (filteredImisCount > 1) {
                return true;
            }
            List subtypes = imm.getEnabledInputMethodSubtypeList(imi, true);
            if (subtypes.isEmpty()) {
                ++filteredImisCount;
                continue;
            }
            int auxCount = 0;
            for (InputMethodSubtype subtype : subtypes) {
                if (!subtype.isAuxiliary()) continue;
                ++auxCount;
            }
            int nonAuxCount = subtypes.size() - auxCount;
            if (nonAuxCount <= 0 && (!shouldIncludeAuxiliarySubtypes || auxCount <= 1)) continue;
            ++filteredImisCount;
        }
        return filteredImisCount > 1 || imm.getEnabledInputMethodSubtypeList(null, false).size() > 1;
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        return this.mPasswordEntry.requestFocus(direction, previouslyFocusedRect);
    }

    public boolean needsInput() {
        return this.mIsAlpha;
    }

    public void onPause() {
        this.mStatusViewManager.onPause();
    }

    public void onResume() {
        this.mResuming = true;
        this.mStatusViewManager.onResume();
        this.mPasswordEntry.setText((CharSequence)"");
        this.mPasswordEntry.requestFocus();
        long deadline = this.mLockPatternUtils.getLockoutAttemptDeadline();
        if (deadline != 0L) {
            this.handleAttemptLockout(deadline);
        }
        this.mResuming = false;
    }

    public void cleanUp() {
        this.mUpdateMonitor.removeCallback(this);
    }

    private void verifyPasswordAndUnlock() {
        String entry = this.mPasswordEntry.getText().toString();
        if (this.mLockPatternUtils.checkPassword(entry)) {
            this.mCallback.keyguardDone(true);
            this.mCallback.reportSuccessfulUnlockAttempt();
            this.mStatusViewManager.setInstructionText(null);
            KeyStore.getInstance().password(entry);
        } else if (entry.length() > 3) {
            this.mCallback.reportFailedUnlockAttempt();
            if (0 == this.mUpdateMonitor.getFailedAttempts() % 5) {
                long deadline = this.mLockPatternUtils.setLockoutAttemptDeadline();
                this.handleAttemptLockout(deadline);
            }
            this.mStatusViewManager.setInstructionText(this.mContext.getString(17040099));
        } else if (entry.length() > 0) {
            this.mStatusViewManager.setInstructionText(this.mContext.getString(17040099));
        }
        this.mPasswordEntry.setText((CharSequence)"");
    }

    private void handleAttemptLockout(long elapsedRealtimeDeadline) {
        this.mPasswordEntry.setEnabled(false);
        this.mKeyboardView.setEnabled(false);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        new CountDownTimer(elapsedRealtimeDeadline - elapsedRealtime, 1000L){

            public void onTick(long millisUntilFinished) {
                int secondsRemaining = (int)(millisUntilFinished / 1000L);
                String instructions = PasswordUnlockScreen.this.getContext().getString(17040126, new Object[]{secondsRemaining});
                PasswordUnlockScreen.this.mStatusViewManager.setInstructionText(instructions);
            }

            public void onFinish() {
                PasswordUnlockScreen.this.mPasswordEntry.setEnabled(true);
                PasswordUnlockScreen.this.mKeyboardView.setEnabled(true);
                PasswordUnlockScreen.this.mStatusViewManager.resetStatusInfo();
            }
        }.start();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.mCallback.pokeWakelock();
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation != this.mCreationOrientation || config.hardKeyboardHidden != this.mCreationHardKeyboardHidden) {
            this.mCallback.recreateMe(config);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.mCreationOrientation || newConfig.hardKeyboardHidden != this.mCreationHardKeyboardHidden) {
            this.mCallback.recreateMe(newConfig);
        }
    }

    public void onKeyboardChange(boolean isKeyboardOpen) {
        this.mKeyboardView.setVisibility(isKeyboardOpen ? 4 : 0);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 0 || actionId == 6 || actionId == 5) {
            this.verifyPasswordAndUnlock();
            return true;
        }
        return false;
    }
}

