/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.content.res.Configuration;
import android.os.CountDownTimer;
import android.os.SystemClock;
import android.security.KeyStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.widget.LinearLayoutWithDefaultTouchRecepient;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import java.util.List;

class PatternUnlockScreen
extends LinearLayoutWithDefaultTouchRecepient
implements KeyguardScreen {
    private static final boolean DEBUG = false;
    private static final String TAG = "UnlockScreen";
    private static final int PATTERN_CLEAR_TIMEOUT_MS = 2000;
    private static final int UNLOCK_PATTERN_WAKE_INTERVAL_MS = 7000;
    private static final int UNLOCK_PATTERN_WAKE_INTERVAL_FIRST_DOTS_MS = 2000;
    private static final int MIN_PATTERN_BEFORE_POKE_WAKELOCK = 2;
    private int mFailedPatternAttemptsSinceLastTimeout = 0;
    private int mTotalFailedPatternAttempts = 0;
    private CountDownTimer mCountdownTimer = null;
    private LockPatternUtils mLockPatternUtils;
    private KeyguardUpdateMonitor mUpdateMonitor;
    private KeyguardScreenCallback mCallback;
    private boolean mEnableFallback;
    private KeyguardStatusViewManager mKeyguardStatusViewManager;
    private LockPatternView mLockPatternView;
    private long mLastPokeTime = -7000L;
    private Runnable mCancelPatternRunnable = new Runnable(){

        public void run() {
            PatternUnlockScreen.this.mLockPatternView.clearPattern();
        }
    };
    private final View.OnClickListener mForgotPatternClick = new View.OnClickListener(){

        public void onClick(View v) {
            PatternUnlockScreen.this.mCallback.forgotPattern(true);
        }
    };
    private Button mForgotPatternButton;
    private int mCreationOrientation;

    private void hideForgotPatternButton() {
        this.mForgotPatternButton.setVisibility(8);
    }

    private void showForgotPatternButton() {
        this.mForgotPatternButton.setVisibility(0);
    }

    private void updateFooter(FooterMode mode) {
        switch (mode) {
            case Normal: {
                this.hideForgotPatternButton();
                break;
            }
            case ForgotLockPattern: {
                this.showForgotPatternButton();
                break;
            }
            case VerifyUnlocked: {
                this.hideForgotPatternButton();
            }
        }
    }

    PatternUnlockScreen(Context context, Configuration configuration, LockPatternUtils lockPatternUtils, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback, int totalFailedAttempts) {
        super(context);
        this.mLockPatternUtils = lockPatternUtils;
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mTotalFailedPatternAttempts = totalFailedAttempts;
        this.mFailedPatternAttemptsSinceLastTimeout = totalFailedAttempts % 5;
        this.mCreationOrientation = configuration.orientation;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (this.mCreationOrientation != 2) {
            Log.d((String)TAG, (String)"portrait mode");
            inflater.inflate(17367129, (ViewGroup)this, true);
        } else {
            Log.d((String)TAG, (String)"landscape mode");
            inflater.inflate(17367128, (ViewGroup)this, true);
        }
        this.mKeyguardStatusViewManager = new KeyguardStatusViewManager((View)this, this.mUpdateMonitor, this.mLockPatternUtils, this.mCallback, true);
        this.mLockPatternView = (LockPatternView)this.findViewById(16908975);
        this.mForgotPatternButton = (Button)this.findViewById(16908974);
        this.mForgotPatternButton.setText(17040127);
        this.mForgotPatternButton.setOnClickListener(this.mForgotPatternClick);
        this.setDefaultTouchRecepient((View)this.mLockPatternView);
        this.mLockPatternView.setSaveEnabled(false);
        this.mLockPatternView.setFocusable(false);
        this.mLockPatternView.setOnPatternListener((LockPatternView.OnPatternListener)new UnlockPatternListener());
        this.mLockPatternView.setInStealthMode(!this.mLockPatternUtils.isVisiblePatternEnabled());
        this.mLockPatternView.setTactileFeedbackEnabled(this.mLockPatternUtils.isTactileFeedbackEnabled());
        this.updateFooter(FooterMode.Normal);
        this.setFocusableInTouchMode(true);
    }

    public void setEnableFallback(boolean state) {
        this.mEnableFallback = state;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean result = super.dispatchTouchEvent(ev);
        if (result && SystemClock.elapsedRealtime() - this.mLastPokeTime > 6900L) {
            this.mLastPokeTime = SystemClock.elapsedRealtime();
        }
        return result;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getResources().getConfiguration().orientation != this.mCreationOrientation) {
            this.mCallback.recreateMe(this.getResources().getConfiguration());
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.mCreationOrientation) {
            this.mCallback.recreateMe(newConfig);
        }
    }

    public void onKeyboardChange(boolean isKeyboardOpen) {
    }

    public boolean needsInput() {
        return false;
    }

    public void onPause() {
        if (this.mCountdownTimer != null) {
            this.mCountdownTimer.cancel();
            this.mCountdownTimer = null;
        }
        this.mKeyguardStatusViewManager.onPause();
    }

    public void onResume() {
        this.mKeyguardStatusViewManager.onResume();
        this.mLockPatternView.enableInput();
        this.mLockPatternView.setEnabled(true);
        this.mLockPatternView.clearPattern();
        if (this.mCallback.doesFallbackUnlockScreenExist()) {
            this.showForgotPatternButton();
        } else {
            this.hideForgotPatternButton();
        }
        long deadline = this.mLockPatternUtils.getLockoutAttemptDeadline();
        if (deadline != 0L) {
            this.handleAttemptLockout(deadline);
        }
        if (this.mCallback.isVerifyUnlockOnly()) {
            this.updateFooter(FooterMode.VerifyUnlocked);
        } else if (this.mEnableFallback && this.mTotalFailedPatternAttempts >= 5) {
            this.updateFooter(FooterMode.ForgotLockPattern);
        } else {
            this.updateFooter(FooterMode.Normal);
        }
    }

    public void cleanUp() {
        this.mUpdateMonitor.removeCallback(this);
        this.mLockPatternUtils = null;
        this.mUpdateMonitor = null;
        this.mCallback = null;
        this.mLockPatternView.setOnPatternListener(null);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.onResume();
        }
    }

    private void handleAttemptLockout(long elapsedRealtimeDeadline) {
        this.mLockPatternView.clearPattern();
        this.mLockPatternView.setEnabled(false);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.mCountdownTimer = new CountDownTimer(elapsedRealtimeDeadline - elapsedRealtime, 1000L){

            public void onTick(long millisUntilFinished) {
                int secondsRemaining = (int)(millisUntilFinished / 1000L);
                PatternUnlockScreen.this.mKeyguardStatusViewManager.setInstructionText(PatternUnlockScreen.this.getContext().getString(17040126, new Object[]{secondsRemaining}));
                PatternUnlockScreen.this.mKeyguardStatusViewManager.updateStatusLines(true);
            }

            public void onFinish() {
                PatternUnlockScreen.this.mLockPatternView.setEnabled(true);
                PatternUnlockScreen.this.mKeyguardStatusViewManager.setInstructionText(PatternUnlockScreen.this.getContext().getString(17040094));
                PatternUnlockScreen.this.mKeyguardStatusViewManager.updateStatusLines(true);
                PatternUnlockScreen.this.mFailedPatternAttemptsSinceLastTimeout = 0;
                if (PatternUnlockScreen.this.mEnableFallback) {
                    PatternUnlockScreen.this.updateFooter(FooterMode.ForgotLockPattern);
                } else {
                    PatternUnlockScreen.this.updateFooter(FooterMode.Normal);
                }
            }
        }.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnlockPatternListener
    implements LockPatternView.OnPatternListener {
        private UnlockPatternListener() {
        }

        public void onPatternStart() {
            PatternUnlockScreen.this.mLockPatternView.removeCallbacks(PatternUnlockScreen.this.mCancelPatternRunnable);
        }

        public void onPatternCleared() {
        }

        public void onPatternCellAdded(List<LockPatternView.Cell> pattern) {
            if (pattern.size() > 2) {
                PatternUnlockScreen.this.mCallback.pokeWakelock(7000);
            } else {
                PatternUnlockScreen.this.mCallback.pokeWakelock(2000);
            }
        }

        public void onPatternDetected(List<LockPatternView.Cell> pattern) {
            if (PatternUnlockScreen.this.mLockPatternUtils.checkPattern(pattern)) {
                PatternUnlockScreen.this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Correct);
                PatternUnlockScreen.this.mKeyguardStatusViewManager.setInstructionText("");
                PatternUnlockScreen.this.mKeyguardStatusViewManager.updateStatusLines(true);
                PatternUnlockScreen.this.mCallback.keyguardDone(true);
                PatternUnlockScreen.this.mCallback.reportSuccessfulUnlockAttempt();
                KeyStore.getInstance().password(LockPatternUtils.patternToString(pattern));
            } else {
                boolean reportFailedAttempt = false;
                if (pattern.size() > 2) {
                    PatternUnlockScreen.this.mCallback.pokeWakelock(7000);
                }
                PatternUnlockScreen.this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Wrong);
                if (pattern.size() >= 4) {
                    PatternUnlockScreen.this.mTotalFailedPatternAttempts++;
                    PatternUnlockScreen.this.mFailedPatternAttemptsSinceLastTimeout++;
                    reportFailedAttempt = true;
                }
                if (PatternUnlockScreen.this.mFailedPatternAttemptsSinceLastTimeout >= 5) {
                    long deadline = PatternUnlockScreen.this.mLockPatternUtils.setLockoutAttemptDeadline();
                    PatternUnlockScreen.this.handleAttemptLockout(deadline);
                } else {
                    PatternUnlockScreen.this.mKeyguardStatusViewManager.setInstructionText(PatternUnlockScreen.this.getContext().getString(17040098));
                    PatternUnlockScreen.this.mKeyguardStatusViewManager.updateStatusLines(true);
                    PatternUnlockScreen.this.mLockPatternView.postDelayed(PatternUnlockScreen.this.mCancelPatternRunnable, 2000L);
                }
                if (reportFailedAttempt) {
                    PatternUnlockScreen.this.mCallback.reportFailedUnlockAttempt();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FooterMode {
        Normal,
        ForgotLockPattern,
        VerifyUnlocked;

    }
}

