/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.util.Slog;
import android.view.FallbackEventHandler;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.policy.impl.PhoneWindowManager;

public class PhoneFallbackEventHandler
implements FallbackEventHandler {
    private static String TAG = "PhoneFallbackEventHandler";
    private static final boolean DEBUG = false;
    Context mContext;
    View mView;
    AudioManager mAudioManager;
    KeyguardManager mKeyguardManager;
    SearchManager mSearchManager;
    TelephonyManager mTelephonyManager;

    public PhoneFallbackEventHandler(Context context) {
        this.mContext = context;
    }

    public void setView(View v) {
        this.mView = v;
    }

    public void preDispatchKeyEvent(KeyEvent event) {
        this.getAudioManager().preDispatchKeyEvent(event.getKeyCode(), Integer.MIN_VALUE);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keyCode = event.getKeyCode();
        if (action == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return this.onKeyUp(keyCode, event);
    }

    boolean onKeyDown(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                this.getAudioManager().handleKeyDown(keyCode, Integer.MIN_VALUE);
                return true;
            }
            case 85: 
            case 126: 
            case 127: {
                if (this.getTelephonyManager().getCallState() != 0) {
                    return true;
                }
            }
            case 79: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 130: {
                Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)event);
                this.mContext.sendOrderedBroadcast(intent, null);
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, (Object)this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    this.mView.performHapticFeedback(0);
                    Intent intent = new Intent("android.intent.action.VOICE_COMMAND");
                    intent.setFlags(0x10000000);
                    try {
                        this.sendCloseSystemWindows();
                        this.mContext.startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        this.startCallActivity();
                    }
                }
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, (Object)this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    this.mView.performHapticFeedback(0);
                    this.sendCloseSystemWindows();
                    Intent intent = new Intent("android.intent.action.CAMERA_BUTTON", null);
                    intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)event);
                    this.mContext.sendOrderedBroadcast(intent, null);
                }
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, (Object)this);
                    break;
                }
                if (!event.isLongPress() || !dispatcher.isTracking(event)) break;
                Configuration config = this.mContext.getResources().getConfiguration();
                if (config.keyboard != 1 && config.hardKeyboardHidden != 2) break;
                Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
                intent.setFlags(0x10000000);
                try {
                    this.mView.performHapticFeedback(0);
                    this.sendCloseSystemWindows();
                    this.getSearchManager().stopSearch();
                    this.mContext.startActivity(intent);
                    dispatcher.performedLongPress(event);
                    return true;
                }
                catch (ActivityNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    boolean onKeyUp(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                AudioManager audioManager;
                if (!event.isCanceled() && (audioManager = (AudioManager)this.mContext.getSystemService("audio")) != null) {
                    this.getAudioManager().handleKeyUp(keyCode, Integer.MIN_VALUE);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)event);
                this.mContext.sendOrderedBroadcast(intent, null);
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (!event.isTracking() || !event.isCanceled()) {
                    // empty if block
                }
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.startCallActivity();
                }
                return true;
            }
        }
        return false;
    }

    void startCallActivity() {
        this.sendCloseSystemWindows();
        Intent intent = new Intent("android.intent.action.CALL_BUTTON");
        intent.setFlags(0x10000000);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Slog.w((String)TAG, (String)"No activity found for android.intent.action.CALL_BUTTON.");
        }
    }

    SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    TelephonyManager getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        return this.mAudioManager;
    }

    void sendCloseSystemWindows() {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, null);
    }
}

