/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.policy.impl.PhoneWindowManager;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.StandaloneActionMode;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.IconMenuPresenter;
import com.android.internal.view.menu.ListMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.ActionBarView;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneWindow
extends Window
implements MenuBuilder.Callback {
    private static final String TAG = "PhoneWindow";
    private static final boolean SWEEP_OPEN_MENU = false;
    final DialogMenuCallback mContextMenuCallback = new DialogMenuCallback(6);
    final TypedValue mMinWidthMajor = new TypedValue();
    final TypedValue mMinWidthMinor = new TypedValue();
    private DecorView mDecor;
    private ViewGroup mContentParent;
    SurfaceHolder.Callback2 mTakeSurfaceCallback;
    InputQueue.Callback mTakeInputQueueCallback;
    private boolean mIsFloating;
    private LayoutInflater mLayoutInflater;
    private TextView mTitleView;
    private ActionBarView mActionBar;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    private DrawableFeatureState[] mDrawables;
    private PanelFeatureState[] mPanels;
    private PanelFeatureState mPreparedPanel;
    private int mPanelChordingKey;
    private ImageView mLeftIconView;
    private ImageView mRightIconView;
    private ProgressBar mCircularProgressBar;
    private ProgressBar mHorizontalProgressBar;
    private int mBackgroundResource = 0;
    private Drawable mBackgroundDrawable;
    private int mFrameResource = 0;
    private int mTextColor = 0;
    private CharSequence mTitle = null;
    private int mTitleColor = 0;
    private boolean mAlwaysReadCloseOnTouchAttr = false;
    private ContextMenuBuilder mContextMenu;
    private MenuDialogHelper mContextMenuHelper;
    private boolean mClosingActionMenu;
    private int mVolumeControlStreamType = Integer.MIN_VALUE;
    private AudioManager mAudioManager;
    private KeyguardManager mKeyguardManager;
    private int mUiOptions = 0;
    static final RotationWatcher sRotationWatcher = new RotationWatcher();
    private static final String FOCUSED_ID_TAG = "android:focusedViewId";
    private static final String VIEWS_TAG = "android:views";
    private static final String PANELS_TAG = "android:Panels";
    private static final String ACTION_BAR_TAG = "android:ActionBar";

    public PhoneWindow(Context context) {
        super(context);
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    public final void setContainer(Window container) {
        super.setContainer(container);
    }

    public boolean requestFeature(int featureId) {
        if (this.mContentParent != null) {
            throw new AndroidRuntimeException("requestFeature() must be called before adding content");
        }
        int features = this.getFeatures();
        if (features != 65 && featureId == 7) {
            throw new AndroidRuntimeException("You cannot combine custom titles with other title features");
        }
        if ((features & 0x80) != 0 && featureId != 7 && featureId != 10) {
            throw new AndroidRuntimeException("You cannot combine custom titles with other title features");
        }
        if ((features & 2) != 0 && featureId == 8) {
            return false;
        }
        if ((features & 0x100) != 0 && featureId == 1) {
            this.removeFeature(8);
        }
        return super.requestFeature(featureId);
    }

    public void setUiOptions(int uiOptions) {
        this.mUiOptions = uiOptions;
    }

    public void setUiOptions(int uiOptions, int mask) {
        this.mUiOptions = this.mUiOptions & ~mask | uiOptions & mask;
    }

    public void setContentView(int layoutResID) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.mLayoutInflater.inflate(layoutResID, this.mContentParent);
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.mContentParent.addView(view, params);
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mContentParent.addView(view, params);
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    public View getCurrentFocus() {
        return this.mDecor != null ? this.mDecor.findFocus() : null;
    }

    public void takeSurface(SurfaceHolder.Callback2 callback) {
        this.mTakeSurfaceCallback = callback;
    }

    public void takeInputQueue(InputQueue.Callback callback) {
        this.mTakeInputQueueCallback = callback;
    }

    public boolean isFloating() {
        return this.mIsFloating;
    }

    public LayoutInflater getLayoutInflater() {
        return this.mLayoutInflater;
    }

    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        } else if (this.mActionBar != null) {
            this.mActionBar.setWindowTitle(title);
        }
        this.mTitle = title;
    }

    public void setTitleColor(int textColor) {
        if (this.mTitleView != null) {
            this.mTitleView.setTextColor(textColor);
        }
        this.mTitleColor = textColor;
    }

    public final boolean preparePanel(PanelFeatureState st, KeyEvent event) {
        Window.Callback cb;
        if (this.isDestroyed()) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        if ((cb = this.getCallback()) != null) {
            st.createdPanelView = cb.onCreatePanelView(st.featureId);
        }
        if (st.createdPanelView == null) {
            if (st.menu == null || st.refreshMenuContent) {
                if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                    return false;
                }
                if (this.mActionBar != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                    }
                    this.mActionBar.setMenu((Menu)st.menu, (MenuPresenter.Callback)this.mActionMenuPresenterCallback);
                }
                st.menu.stopDispatchingItemsChanged();
                if (cb == null || !cb.onCreatePanelMenu(st.featureId, (Menu)st.menu)) {
                    st.setMenu(null);
                    if (this.mActionBar != null) {
                        this.mActionBar.setMenu(null, (MenuPresenter.Callback)this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                st.refreshMenuContent = false;
            }
            st.menu.stopDispatchingItemsChanged();
            if (st.frozenActionViewState != null) {
                st.menu.restoreActionViewStates(st.frozenActionViewState);
                st.frozenActionViewState = null;
            }
            if (!cb.onPreparePanel(st.featureId, st.createdPanelView, (Menu)st.menu)) {
                if (this.mActionBar != null) {
                    this.mActionBar.setMenu(null, (MenuPresenter.Callback)this.mActionMenuPresenterCallback);
                }
                st.menu.startDispatchingItemsChanged();
                return false;
            }
            KeyCharacterMap kmap = KeyCharacterMap.load((int)(event != null ? event.getDeviceId() : -1));
            st.qwertyMode = kmap.getKeyboardType() != 1;
            st.menu.setQwertyMode(st.qwertyMode);
            st.menu.startDispatchingItemsChanged();
        }
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        PanelFeatureState st;
        if (this.mActionBar == null && (st = this.getPanelState(0, false)) != null && st.menu != null) {
            if (st.isOpen) {
                Bundle state = new Bundle();
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.saveHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.saveHierarchyState(state);
                }
                PhoneWindow.clearMenuViews(st);
                this.reopenMenu(false);
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.restoreHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.restoreHierarchyState(state);
                }
            } else {
                PhoneWindow.clearMenuViews(st);
            }
        }
    }

    private static void clearMenuViews(PanelFeatureState st) {
        st.createdPanelView = null;
        st.refreshDecorView = true;
        st.clearMenuPresenters();
    }

    public final void openPanel(int featureId, KeyEvent event) {
        if (featureId == 0 && this.mActionBar != null && this.mActionBar.isOverflowReserved()) {
            if (this.mActionBar.getVisibility() == 0) {
                this.mActionBar.showOverflowMenu();
            }
        } else {
            this.openPanel(this.getPanelState(featureId, true), event);
        }
    }

    private void openPanel(PanelFeatureState st, KeyEvent event) {
        ViewGroup.LayoutParams lp;
        Window.Callback cb;
        if (st.isOpen || this.isDestroyed()) {
            return;
        }
        if (st.featureId == 0) {
            boolean isHoneycombApp;
            Context context = this.getContext();
            Configuration config = context.getResources().getConfiguration();
            boolean isXLarge = (config.screenLayout & 0xF) == 4;
            boolean bl = isHoneycombApp = context.getApplicationInfo().targetSdkVersion >= 11;
            if (isXLarge && isHoneycombApp) {
                return;
            }
        }
        if ((cb = this.getCallback()) != null && !cb.onMenuOpened(st.featureId, (Menu)st.menu)) {
            this.closePanel(st, true);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        int width = -2;
        if (st.decorView == null || st.refreshDecorView) {
            int backgroundResId;
            if (st.decorView == null) {
                if (!this.initializePanelDecor(st) || st.decorView == null) {
                    return;
                }
            } else if (st.refreshDecorView && st.decorView.getChildCount() > 0) {
                st.decorView.removeAllViews();
            }
            if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
                return;
            }
            ViewGroup.LayoutParams lp2 = st.shownPanelView.getLayoutParams();
            if (lp2 == null) {
                lp2 = new ViewGroup.LayoutParams(-2, -2);
            }
            if (lp2.width == -1) {
                backgroundResId = st.fullBackground;
                width = -1;
            } else {
                backgroundResId = st.background;
            }
            st.decorView.setWindowBackground(this.getContext().getResources().getDrawable(backgroundResId));
            st.decorView.addView(st.shownPanelView, lp2);
            if (!st.shownPanelView.hasFocus()) {
                st.shownPanelView.requestFocus();
            }
        } else if (!st.isInListMode()) {
            width = -1;
        } else if (st.createdPanelView != null && (lp = st.createdPanelView.getLayoutParams()) != null && lp.width == -1) {
            width = -1;
        }
        st.isOpen = true;
        st.isHandled = false;
        WindowManager.LayoutParams lp2 = new WindowManager.LayoutParams(width, -2, st.x, st.y, 1003, 8523776, st.decorView.mDefaultOpacity);
        if (st.isCompact) {
            lp2.gravity = this.getOptionsPanelGravity();
            sRotationWatcher.addWindow(this);
        } else {
            lp2.gravity = st.gravity;
        }
        lp2.windowAnimations = st.windowAnimations;
        wm.addView((View)st.decorView, (ViewGroup.LayoutParams)lp2);
    }

    public final void closePanel(int featureId) {
        if (featureId == 0 && this.mActionBar != null && this.mActionBar.isOverflowReserved()) {
            this.mActionBar.hideOverflowMenu();
        } else if (featureId == 6) {
            this.closeContextMenu();
        } else {
            this.closePanel(this.getPanelState(featureId, true), true);
        }
    }

    public final void closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mActionBar != null && this.mActionBar.isOverflowMenuShowing()) {
            this.checkCloseActionMenu((Menu)st.menu);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm != null && st.isOpen) {
            if (st.decorView != null) {
                wm.removeView((View)st.decorView);
                if (st.isCompact) {
                    sRotationWatcher.removeWindow(this);
                }
            }
            if (doCallback) {
                this.callOnPanelClosed(st.featureId, st, null);
            }
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        if (st.isInExpandedMode) {
            st.refreshDecorView = true;
            st.isInExpandedMode = false;
        }
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
            this.mPanelChordingKey = 0;
        }
    }

    void checkCloseActionMenu(Menu menu) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mActionBar.dismissPopupMenus();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onPanelClosed(8, menu);
        }
        this.mClosingActionMenu = false;
    }

    public final void togglePanel(int featureId, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (st.isOpen) {
            this.closePanel(st, true);
        } else {
            this.openPanel(st, event);
        }
    }

    public void invalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 8 || featureId == 0) && this.mActionBar != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    public final boolean onKeyDownPanel(int featureId, KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getRepeatCount() == 0) {
            this.mPanelChordingKey = keyCode;
            PanelFeatureState st = this.getPanelState(featureId, true);
            if (!st.isOpen) {
                return this.preparePanel(st, event);
            }
        }
        return false;
    }

    public final void onKeyUpPanel(int featureId, KeyEvent event) {
        if (this.mPanelChordingKey != 0) {
            this.mPanelChordingKey = 0;
            if (event.isCanceled() || this.mDecor != null && this.mDecor.mActionMode != null) {
                return;
            }
            boolean playSoundEffect = false;
            PanelFeatureState st = this.getPanelState(featureId, true);
            if (featureId == 0 && this.mActionBar != null && this.mActionBar.isOverflowReserved()) {
                if (this.mActionBar.getVisibility() == 0) {
                    if (!this.mActionBar.isOverflowMenuShowing()) {
                        if (!this.isDestroyed() && this.preparePanel(st, event)) {
                            playSoundEffect = this.mActionBar.showOverflowMenu();
                        }
                    } else {
                        playSoundEffect = this.mActionBar.hideOverflowMenu();
                    }
                }
            } else if (st.isOpen || st.isHandled) {
                playSoundEffect = st.isOpen;
                this.closePanel(st, true);
            } else if (st.isPrepared) {
                boolean show = true;
                if (st.refreshMenuContent) {
                    st.isPrepared = false;
                    show = this.preparePanel(st, event);
                }
                if (show) {
                    EventLog.writeEvent((int)50001, (int)0);
                    this.openPanel(st, event);
                    playSoundEffect = true;
                }
            }
            if (playSoundEffect) {
                AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
                if (audioManager != null) {
                    audioManager.playSoundEffect(0);
                } else {
                    Log.w((String)TAG, (String)"Couldn't get audio manager");
                }
            }
        }
    }

    public final void closeAllPanels() {
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null) continue;
            this.closePanel(panel, true);
        }
        this.closeContextMenu();
    }

    private synchronized void closeContextMenu() {
        if (this.mContextMenu != null) {
            this.mContextMenu.close();
            this.dismissContextMenu();
        }
    }

    private synchronized void dismissContextMenu() {
        this.mContextMenu = null;
        if (this.mContextMenuHelper != null) {
            this.mContextMenuHelper.dismiss();
            this.mContextMenuHelper = null;
        }
    }

    public boolean performPanelShortcut(int featureId, int keyCode, KeyEvent event, int flags) {
        return this.performPanelShortcut(this.getPanelState(featureId, true), keyCode, event, flags);
    }

    private boolean performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem() || st == null) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled) {
            st.isHandled = true;
            if ((flags & 1) == 0 && this.mActionBar == null) {
                this.closePanel(st, true);
            }
        }
        return handled;
    }

    public boolean performPanelIdentifierAction(int featureId, int id, int flags) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (!this.preparePanel(st, new KeyEvent(0, 82))) {
            return false;
        }
        if (st.menu == null) {
            return false;
        }
        boolean res = st.menu.performIdentifierAction(id, flags);
        if (this.mActionBar == null) {
            this.closePanel(st, true);
        }
        return res;
    }

    public PanelFeatureState findMenuPanel(Menu menu) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu) continue;
            return panel;
        }
        return null;
    }

    public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
        PanelFeatureState panel;
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed() && (panel = this.findMenuPanel((Menu)menu.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    public void onMenuModeChange(MenuBuilder menu) {
        this.reopenMenu(true);
    }

    private void reopenMenu(boolean toggleMenuMode) {
        if (this.mActionBar != null && this.mActionBar.isOverflowReserved()) {
            Window.Callback cb = this.getCallback();
            if (!this.mActionBar.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.isDestroyed() && this.mActionBar.getVisibility() == 0) {
                    PanelFeatureState st = this.getPanelState(0, true);
                    if (cb.onPreparePanel(0, st.createdPanelView, (Menu)st.menu)) {
                        cb.onMenuOpened(8, (Menu)st.menu);
                        this.mActionBar.showOverflowMenu();
                    }
                }
            } else {
                this.mActionBar.hideOverflowMenu();
                if (cb != null && !this.isDestroyed()) {
                    PanelFeatureState st = this.getPanelState(0, true);
                    cb.onPanelClosed(8, (Menu)st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, true);
        boolean newExpandedMode = toggleMenuMode ? !st.isInExpandedMode : st.isInExpandedMode;
        st.refreshDecorView = true;
        this.closePanel(st, false);
        st.isInExpandedMode = newExpandedMode;
        this.openPanel(st, null);
    }

    protected boolean initializePanelMenu(PanelFeatureState st) {
        Context context = this.getContext();
        if ((st.featureId == 0 || st.featureId == 8) && this.mActionBar != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme currentTheme = context.getTheme();
            currentTheme.resolveAttribute(16843671, outValue, true);
            int targetThemeRes = outValue.resourceId;
            if (targetThemeRes != 0 && context.getThemeResId() != targetThemeRes) {
                context = new ContextThemeWrapper(context, targetThemeRes);
            }
        }
        MenuBuilder menu = new MenuBuilder(context);
        menu.setCallback((MenuBuilder.Callback)this);
        st.setMenu(menu);
        return true;
    }

    protected boolean initializePanelDecor(PanelFeatureState st) {
        st.decorView = new DecorView(this.getContext(), st.featureId);
        st.gravity = 81;
        st.setStyle(this.getContext());
        return true;
    }

    private int getOptionsPanelGravity() {
        try {
            return WindowManagerHolder.sWindowManager.getPreferredOptionsPanelGravity();
        }
        catch (RemoteException ex) {
            Log.e((String)TAG, (String)"Couldn't getOptionsPanelGravity; using default", (Throwable)ex);
            return 81;
        }
    }

    void onOptionsPanelRotationChanged() {
        WindowManager.LayoutParams lp;
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = lp = st.decorView != null ? (WindowManager.LayoutParams)st.decorView.getLayoutParams() : null;
        if (lp != null) {
            lp.gravity = this.getOptionsPanelGravity();
            WindowManager wm = this.getWindowManager();
            if (wm != null) {
                wm.updateViewLayout((View)st.decorView, (ViewGroup.LayoutParams)lp);
            }
        }
    }

    protected boolean initializePanelContent(PanelFeatureState st) {
        if (st.createdPanelView != null) {
            st.shownPanelView = st.createdPanelView;
            return true;
        }
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        MenuView menuView = st.isInListMode() ? st.getListMenuView(this.getContext(), this.mPanelMenuPresenterCallback) : st.getIconMenuView(this.getContext(), this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)menuView;
        if (st.shownPanelView != null) {
            int defaultAnimations = menuView.getWindowAnimations();
            if (defaultAnimations != 0) {
                st.windowAnimations = defaultAnimations;
            }
            return true;
        }
        return false;
    }

    public boolean performContextMenuIdentifierAction(int id, int flags) {
        return this.mContextMenu != null ? this.mContextMenu.performIdentifierAction(id, flags) : false;
    }

    public final void setBackgroundDrawable(Drawable drawable) {
        if (drawable != this.mBackgroundDrawable || this.mBackgroundResource != 0) {
            this.mBackgroundResource = 0;
            this.mBackgroundDrawable = drawable;
            if (this.mDecor != null) {
                this.mDecor.setWindowBackground(drawable);
            }
        }
    }

    public final void setFeatureDrawableResource(int featureId, int resId) {
        if (resId != 0) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.resid != resId) {
                st.resid = resId;
                st.uri = null;
                st.local = this.getContext().getResources().getDrawable(resId);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    public final void setFeatureDrawableUri(int featureId, Uri uri) {
        if (uri != null) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.uri == null || !st.uri.equals((Object)uri)) {
                st.resid = 0;
                st.uri = uri;
                st.local = this.loadImageURI(uri);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    public final void setFeatureDrawable(int featureId, Drawable drawable) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.resid = 0;
        st.uri = null;
        if (st.local != drawable) {
            st.local = drawable;
            this.updateDrawable(featureId, st, false);
        }
    }

    public void setFeatureDrawableAlpha(int featureId, int alpha) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.alpha != alpha) {
            st.alpha = alpha;
            this.updateDrawable(featureId, st, false);
        }
    }

    protected final void setFeatureDefaultDrawable(int featureId, Drawable drawable) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.def != drawable) {
            st.def = drawable;
            this.updateDrawable(featureId, st, false);
        }
    }

    public final void setFeatureInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    protected final void updateDrawable(int featureId, boolean fromActive) {
        DrawableFeatureState st = this.getDrawableState(featureId, false);
        if (st != null) {
            this.updateDrawable(featureId, st, fromActive);
        }
    }

    protected void onDrawableChanged(int featureId, Drawable drawable, int alpha) {
        ImageView view;
        if (featureId == 3) {
            view = this.getLeftIconView();
        } else if (featureId == 4) {
            view = this.getRightIconView();
        } else {
            return;
        }
        if (drawable != null) {
            drawable.setAlpha(alpha);
            view.setImageDrawable(drawable);
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    protected void onIntChanged(int featureId, int value) {
        FrameLayout titleContainer;
        if (featureId == 2 || featureId == 5) {
            this.updateProgressBars(value);
        } else if (featureId == 7 && (titleContainer = (FrameLayout)this.findViewById(0x1020220)) != null) {
            this.mLayoutInflater.inflate(value, (ViewGroup)titleContainer);
        }
    }

    private void updateProgressBars(int value) {
        ProgressBar circularProgressBar = this.getCircularProgressBar(true);
        ProgressBar horizontalProgressBar = this.getHorizontalProgressBar(true);
        int features = this.getLocalFeatures();
        if (value == -1) {
            if ((features & 4) != 0) {
                int level = horizontalProgressBar.getProgress();
                int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                horizontalProgressBar.setVisibility(visibility);
            }
            if ((features & 0x20) != 0) {
                circularProgressBar.setVisibility(0);
            }
        } else if (value == -2) {
            if ((features & 4) != 0) {
                horizontalProgressBar.setVisibility(8);
            }
            if ((features & 0x20) != 0) {
                circularProgressBar.setVisibility(8);
            }
        } else if (value == -3) {
            horizontalProgressBar.setIndeterminate(true);
        } else if (value == -4) {
            horizontalProgressBar.setIndeterminate(false);
        } else if (0 <= value && value <= 10000) {
            horizontalProgressBar.setProgress(value - 0);
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        } else if (20000 <= value && value <= 30000) {
            horizontalProgressBar.setSecondaryProgress(value - 20000);
            this.showProgressBars(horizontalProgressBar, circularProgressBar);
        }
    }

    private void showProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        if ((features & 0x20) != 0 && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if ((features & 4) != 0 && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private void hideProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        Animation anim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001);
        anim.setDuration(1000L);
        if ((features & 0x20) != 0 && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.startAnimation(anim);
            spinnyProgressBar.setVisibility(4);
        }
        if ((features & 4) != 0 && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.startAnimation(anim);
            horizontalProgressBar.setVisibility(4);
        }
    }

    public void takeKeyEvents(boolean get) {
        this.mDecor.setFocusable(get);
    }

    public boolean superDispatchKeyEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyEvent(event);
    }

    public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyShortcutEvent(event);
    }

    public boolean superDispatchTouchEvent(MotionEvent event) {
        return this.mDecor.superDispatchTouchEvent(event);
    }

    public boolean superDispatchTrackballEvent(MotionEvent event) {
        return this.mDecor.superDispatchTrackballEvent(event);
    }

    public boolean superDispatchGenericMotionEvent(MotionEvent event) {
        return this.mDecor.superDispatchGenericMotionEvent(event);
    }

    protected boolean onKeyDown(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                this.getAudioManager().handleKeyDown(keyCode, this.mVolumeControlStreamType);
                return true;
            }
            case 82: {
                this.onKeyDownPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                if (event.getRepeatCount() > 0 || featureId < 0) break;
                if (dispatcher != null) {
                    dispatcher.startTracking(event, (Object)this);
                }
                return true;
            }
        }
        return false;
    }

    private KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    protected boolean onKeyUp(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher;
        KeyEvent.DispatcherState dispatcherState = dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                this.getAudioManager().handleKeyUp(keyCode, this.mVolumeControlStreamType);
                return true;
            }
            case 82: {
                this.onKeyUpPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                PanelFeatureState st;
                if (featureId < 0 || !event.isTracking() || event.isCanceled()) break;
                if (featureId == 0 && (st = this.getPanelState(featureId, false)) != null && st.isInExpandedMode) {
                    this.reopenMenu(true);
                    return true;
                }
                this.closePanel(featureId);
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.launchDefaultSearch();
                }
                return true;
            }
        }
        return false;
    }

    protected void onActive() {
    }

    public final View getDecorView() {
        if (this.mDecor == null) {
            this.installDecor();
        }
        return this.mDecor;
    }

    public final View peekDecorView() {
        return this.mDecor;
    }

    public Bundle saveHierarchyState() {
        Bundle outState = new Bundle();
        if (this.mContentParent == null) {
            return outState;
        }
        SparseArray states = new SparseArray();
        this.mContentParent.saveHierarchyState(states);
        outState.putSparseParcelableArray(VIEWS_TAG, states);
        View focusedView = this.mContentParent.findFocus();
        if (focusedView != null && focusedView.getId() != -1) {
            outState.putInt(FOCUSED_ID_TAG, focusedView.getId());
        }
        SparseArray panelStates = new SparseArray();
        this.savePanelState((SparseArray<Parcelable>)panelStates);
        if (panelStates.size() > 0) {
            outState.putSparseParcelableArray(PANELS_TAG, panelStates);
        }
        if (this.mActionBar != null) {
            SparseArray actionBarStates = new SparseArray();
            this.mActionBar.saveHierarchyState(actionBarStates);
            outState.putSparseParcelableArray(ACTION_BAR_TAG, actionBarStates);
        }
        return outState;
    }

    public void restoreHierarchyState(Bundle savedInstanceState) {
        SparseArray panelStates;
        int focusedViewId;
        if (this.mContentParent == null) {
            return;
        }
        SparseArray savedStates = savedInstanceState.getSparseParcelableArray(VIEWS_TAG);
        if (savedStates != null) {
            this.mContentParent.restoreHierarchyState(savedStates);
        }
        if ((focusedViewId = savedInstanceState.getInt(FOCUSED_ID_TAG, -1)) != -1) {
            View needsFocus = this.mContentParent.findViewById(focusedViewId);
            if (needsFocus != null) {
                needsFocus.requestFocus();
            } else {
                Log.w((String)TAG, (String)("Previously focused view reported id " + focusedViewId + " during save, but can't be found during restore."));
            }
        }
        if ((panelStates = savedInstanceState.getSparseParcelableArray(PANELS_TAG)) != null) {
            this.restorePanelState((SparseArray<Parcelable>)panelStates);
        }
        if (this.mActionBar != null) {
            SparseArray actionBarStates = savedInstanceState.getSparseParcelableArray(ACTION_BAR_TAG);
            this.mActionBar.restoreHierarchyState(actionBarStates);
        }
    }

    private void savePanelState(SparseArray<Parcelable> icicles) {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int curFeatureId = panels.length - 1; curFeatureId >= 0; --curFeatureId) {
            if (panels[curFeatureId] == null) continue;
            icicles.put(curFeatureId, (Object)panels[curFeatureId].onSaveInstanceState());
        }
    }

    private void restorePanelState(SparseArray<Parcelable> icicles) {
        for (int curFeatureId = icicles.size() - 1; curFeatureId >= 0; --curFeatureId) {
            PanelFeatureState st = this.getPanelState(curFeatureId, false);
            if (st == null) continue;
            st.onRestoreInstanceState((Parcelable)icicles.get(curFeatureId));
            this.invalidatePanelMenu(curFeatureId);
        }
    }

    private void openPanelsAfterRestore() {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int i = panels.length - 1; i >= 0; --i) {
            PanelFeatureState st = panels[i];
            if (st == null) continue;
            st.applyFrozenState();
            if (st.isOpen || !st.wasLastOpen) continue;
            st.isInExpandedMode = st.wasLastExpanded;
            this.openPanel(st, null);
        }
    }

    protected DecorView generateDecor() {
        return new DecorView(this.getContext(), -1);
    }

    protected void setFeatureFromAttrs(int featureId, TypedArray attrs, int drawableAttr, int alphaAttr) {
        int alpha;
        Drawable d = attrs.getDrawable(drawableAttr);
        if (d != null) {
            this.requestFeature(featureId);
            this.setFeatureDefaultDrawable(featureId, d);
        }
        if ((this.getFeatures() & 1 << featureId) != 0 && (alpha = attrs.getInt(alphaAttr, -1)) >= 0) {
            this.setFeatureDrawableAlpha(featureId, alpha);
        }
    }

    protected ViewGroup generateLayout(DecorView decor) {
        ProgressBar progress;
        int layoutResource;
        TypedValue res;
        int features;
        boolean noActionBar;
        TypedArray a = this.getWindowStyle();
        this.mIsFloating = a.getBoolean(4, false);
        int flagsToUpdate = 0x10100 & ~this.getForcedWindowFlags();
        if (this.mIsFloating) {
            this.setLayout(-2, -2);
            this.setFlags(0, flagsToUpdate);
        } else {
            this.setFlags(65792, flagsToUpdate);
        }
        if (a.getBoolean(3, false)) {
            this.requestFeature(1);
        } else if (a.getBoolean(15, false)) {
            this.requestFeature(8);
        }
        if (a.getBoolean(17, false)) {
            this.requestFeature(9);
        }
        if (a.getBoolean(16, false)) {
            this.requestFeature(10);
        }
        if (a.getBoolean(9, false)) {
            this.setFlags(1024, 0x400 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(14, false)) {
            this.setFlags(0x100000, 0x100000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(18, this.getContext().getApplicationInfo().targetSdkVersion >= 11)) {
            this.setFlags(0x800000, 0x800000 & ~this.getForcedWindowFlags());
        }
        a.getValue(19, this.mMinWidthMajor);
        a.getValue(20, this.mMinWidthMinor);
        Context context = this.getContext();
        int targetSdk = context.getApplicationInfo().targetSdkVersion;
        boolean targetPreHoneycomb = targetSdk < 11;
        boolean targetPreIcs = targetSdk < 14;
        boolean targetHcNeedsOptions = context.getResources().getBoolean(0x1110005);
        boolean bl = noActionBar = !this.hasFeature(8) || this.hasFeature(1);
        if (targetPreHoneycomb || targetPreIcs && targetHcNeedsOptions && noActionBar) {
            this.addFlags(0x8000000);
        } else {
            this.clearFlags(0x8000000);
        }
        if ((this.mAlwaysReadCloseOnTouchAttr || this.getContext().getApplicationInfo().targetSdkVersion >= 11) && a.getBoolean(21, false)) {
            this.setCloseOnTouchOutsideIfNotSet(true);
        }
        WindowManager.LayoutParams params = this.getAttributes();
        if (!this.hasSoftInputMode()) {
            params.softInputMode = a.getInt(13, params.softInputMode);
        }
        if (a.getBoolean(11, this.mIsFloating)) {
            if ((this.getForcedWindowFlags() & 2) == 0) {
                params.flags |= 2;
            }
            if (!this.haveDimAmount()) {
                params.dimAmount = a.getFloat(0, 0.5f);
            }
        }
        if (params.windowAnimations == 0) {
            params.windowAnimations = a.getResourceId(8, 0);
        }
        if (this.getContainer() == null) {
            if (this.mBackgroundDrawable == null) {
                if (this.mBackgroundResource == 0) {
                    this.mBackgroundResource = a.getResourceId(1, 0);
                }
                if (this.mFrameResource == 0) {
                    this.mFrameResource = a.getResourceId(2, 0);
                }
            }
            this.mTextColor = a.getColor(7, -16777216);
        }
        if (((features = this.getLocalFeatures()) & 0x18) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(16843718, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367177;
            }
            this.removeFeature(8);
        } else if ((features & 0x24) != 0 && (features & 0x100) == 0) {
            layoutResource = 17367173;
        } else if ((features & 0x80) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(16843719, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367172;
            }
            this.removeFeature(8);
        } else if ((features & 2) == 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(16843720, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = (features & 0x100) != 0 ? ((features & 0x200) != 0 ? 17367171 : 17367170) : 17367176;
            }
        } else {
            layoutResource = (features & 0x400) != 0 ? 17367175 : 17367174;
        }
        this.mDecor.startChanging();
        View in = this.mLayoutInflater.inflate(layoutResource, null);
        decor.addView(in, new ViewGroup.LayoutParams(-1, -1));
        ViewGroup contentParent = (ViewGroup)this.findViewById(0x1020002);
        if (contentParent == null) {
            throw new RuntimeException("Window couldn't find content container view");
        }
        if ((features & 0x20) != 0 && (progress = this.getCircularProgressBar(false)) != null) {
            progress.setIndeterminate(true);
        }
        if (this.getContainer() == null) {
            Drawable drawable = this.mBackgroundDrawable;
            if (this.mBackgroundResource != 0) {
                drawable = this.getContext().getResources().getDrawable(this.mBackgroundResource);
            }
            this.mDecor.setWindowBackground(drawable);
            drawable = null;
            if (this.mFrameResource != 0) {
                drawable = this.getContext().getResources().getDrawable(this.mFrameResource);
            }
            this.mDecor.setWindowFrame(drawable);
            if (this.mTitleColor == 0) {
                this.mTitleColor = this.mTextColor;
            }
            if (this.mTitle != null) {
                this.setTitle(this.mTitle);
            }
            this.setTitleColor(this.mTitleColor);
        }
        this.mDecor.finishChanging();
        return contentParent;
    }

    public void alwaysReadCloseOnTouchAttr() {
        this.mAlwaysReadCloseOnTouchAttr = true;
    }

    private void installDecor() {
        if (this.mDecor == null) {
            this.mDecor = this.generateDecor();
            this.mDecor.setDescendantFocusability(262144);
            this.mDecor.setIsRootNamespace(true);
        }
        if (this.mContentParent == null) {
            this.mContentParent = this.generateLayout(this.mDecor);
            this.mTitleView = (TextView)this.findViewById(16908310);
            if (this.mTitleView != null) {
                if ((this.getLocalFeatures() & 2) != 0) {
                    View titleContainer = this.findViewById(0x1020220);
                    if (titleContainer != null) {
                        titleContainer.setVisibility(8);
                    } else {
                        this.mTitleView.setVisibility(8);
                    }
                    if (this.mContentParent instanceof FrameLayout) {
                        ((FrameLayout)this.mContentParent).setForeground(null);
                    }
                } else {
                    this.mTitleView.setText(this.mTitle);
                }
            } else {
                this.mActionBar = (ActionBarView)this.findViewById(16909033);
                if (this.mActionBar != null) {
                    int localFeatures;
                    this.mActionBar.setWindowCallback(this.getCallback());
                    if (this.mActionBar.getTitle() == null) {
                        this.mActionBar.setWindowTitle(this.mTitle);
                    }
                    if (((localFeatures = this.getLocalFeatures()) & 4) != 0) {
                        this.mActionBar.initProgress();
                    }
                    if ((localFeatures & 0x20) != 0) {
                        this.mActionBar.initIndeterminateProgress();
                    }
                    boolean splitActionBar = false;
                    boolean splitWhenNarrow = (this.mUiOptions & 1) != 0;
                    splitActionBar = splitWhenNarrow ? this.getContext().getResources().getBoolean(0x1110001) : this.getWindowStyle().getBoolean(22, false);
                    ActionBarContainer splitView = (ActionBarContainer)this.findViewById(16909035);
                    if (splitView != null) {
                        this.mActionBar.setSplitView(splitView);
                        this.mActionBar.setSplitActionBar(splitActionBar);
                        this.mActionBar.setSplitWhenNarrow(splitWhenNarrow);
                        ActionBarContextView cab = (ActionBarContextView)this.findViewById(16909034);
                        cab.setSplitView(splitView);
                        cab.setSplitActionBar(splitActionBar);
                        cab.setSplitWhenNarrow(splitWhenNarrow);
                    } else if (splitActionBar) {
                        Log.e((String)TAG, (String)"Requested split action bar with incompatible window decor! Ignoring request.");
                    }
                    this.mDecor.post(new Runnable(){

                        public void run() {
                            PanelFeatureState st = PhoneWindow.this.getPanelState(0, false);
                            if (!(PhoneWindow.this.isDestroyed() || st != null && st.menu != null)) {
                                PhoneWindow.this.invalidatePanelMenu(8);
                            }
                        }
                    });
                }
            }
        }
    }

    private Drawable loadImageURI(Uri uri) {
        try {
            return Drawable.createFromStream((InputStream)this.getContext().getContentResolver().openInputStream(uri), null);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Unable to open content: " + uri));
            return null;
        }
    }

    private DrawableFeatureState getDrawableState(int featureId, boolean required) {
        DrawableFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        DrawableFeatureState[] ar = this.mDrawables;
        if (this.mDrawables == null || ar.length <= featureId) {
            DrawableFeatureState[] nar = new DrawableFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mDrawables = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new DrawableFeatureState(featureId);
        }
        return st;
    }

    private PanelFeatureState getPanelState(int featureId, boolean required) {
        return this.getPanelState(featureId, required, null);
    }

    private PanelFeatureState getPanelState(int featureId, boolean required, PanelFeatureState convertPanelState) {
        PanelFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            st = convertPanelState != null ? convertPanelState : new PanelFeatureState(featureId);
            ar[featureId] = st;
        }
        return st;
    }

    public final void setChildDrawable(int featureId, Drawable drawable) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.child = drawable;
        this.updateDrawable(featureId, st, false);
    }

    public final void setChildInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(0, true);
        return st.menu != null && st.menu.isShortcutKey(keyCode, event);
    }

    private void updateDrawable(int featureId, DrawableFeatureState st, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        Drawable drawable = null;
        if (st != null) {
            drawable = st.child;
            if (drawable == null) {
                drawable = st.local;
            }
            if (drawable == null) {
                drawable = st.def;
            }
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null && (this.isActive() || fromResume)) {
                this.getContainer().setChildDrawable(featureId, drawable);
            }
        } else if (st != null && (st.cur != drawable || st.curAlpha != st.alpha)) {
            st.cur = drawable;
            st.curAlpha = st.alpha;
            this.onDrawableChanged(featureId, drawable, st.alpha);
        }
    }

    private void updateInt(int featureId, int value, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null) {
                this.getContainer().setChildInt(featureId, value);
            }
        } else {
            this.onIntChanged(featureId, value);
        }
    }

    private ImageView getLeftIconView() {
        if (this.mLeftIconView != null) {
            return this.mLeftIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mLeftIconView = (ImageView)this.findViewById(16908829);
        return this.mLeftIconView;
    }

    private ProgressBar getCircularProgressBar(boolean shouldInstallDecor) {
        if (this.mCircularProgressBar != null) {
            return this.mCircularProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mCircularProgressBar = (ProgressBar)this.findViewById(16909030);
        if (this.mCircularProgressBar != null) {
            this.mCircularProgressBar.setVisibility(4);
        }
        return this.mCircularProgressBar;
    }

    private ProgressBar getHorizontalProgressBar(boolean shouldInstallDecor) {
        if (this.mHorizontalProgressBar != null) {
            return this.mHorizontalProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mHorizontalProgressBar = (ProgressBar)this.findViewById(16909031);
        if (this.mHorizontalProgressBar != null) {
            this.mHorizontalProgressBar.setVisibility(4);
        }
        return this.mHorizontalProgressBar;
    }

    private ImageView getRightIconView() {
        if (this.mRightIconView != null) {
            return this.mRightIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mRightIconView = (ImageView)this.findViewById(16908831);
        return this.mRightIconView;
    }

    private void callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu) {
        Window.Callback cb = this.getCallback();
        if (cb == null) {
            return;
        }
        if (menu == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        if (!this.isDestroyed()) {
            cb.onPanelClosed(featureId, menu);
        }
    }

    private boolean launchDefaultSearch() {
        Window.Callback cb = this.getCallback();
        if (cb == null || this.isDestroyed()) {
            return false;
        }
        this.sendCloseSystemWindows("search");
        return cb.onSearchRequested();
    }

    public void setVolumeControlStream(int streamType) {
        this.mVolumeControlStreamType = streamType;
    }

    public int getVolumeControlStream() {
        return this.mVolumeControlStreamType;
    }

    void sendCloseSystemWindows() {
        PhoneWindowManager.sendCloseSystemWindows(this.getContext(), null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindowManager.sendCloseSystemWindows(this.getContext(), reason);
    }

    private final class DialogMenuCallback
    implements MenuBuilder.Callback,
    MenuPresenter.Callback {
        private int mFeatureId;
        private MenuDialogHelper mSubMenuHelper;

        public DialogMenuCallback(int featureId) {
            this.mFeatureId = featureId;
        }

        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            if (menu.getRootMenu() != menu) {
                this.onCloseSubMenu(menu);
            }
            if (allMenusAreClosing) {
                Window.Callback callback = PhoneWindow.this.getCallback();
                if (callback != null && !PhoneWindow.this.isDestroyed()) {
                    callback.onPanelClosed(this.mFeatureId, (Menu)menu);
                }
                if (menu == PhoneWindow.this.mContextMenu) {
                    PhoneWindow.this.dismissContextMenu();
                }
                if (this.mSubMenuHelper != null) {
                    this.mSubMenuHelper.dismiss();
                    this.mSubMenuHelper = null;
                }
            }
        }

        public void onCloseSubMenu(MenuBuilder menu) {
            Window.Callback callback = PhoneWindow.this.getCallback();
            if (callback != null && !PhoneWindow.this.isDestroyed()) {
                callback.onPanelClosed(this.mFeatureId, (Menu)menu.getRootMenu());
            }
        }

        public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
            Window.Callback callback = PhoneWindow.this.getCallback();
            return callback != null && !PhoneWindow.this.isDestroyed() && callback.onMenuItemSelected(this.mFeatureId, item);
        }

        public void onMenuModeChange(MenuBuilder menu) {
        }

        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            subMenu.setCallback((MenuBuilder.Callback)this);
            this.mSubMenuHelper = new MenuDialogHelper(subMenu);
            this.mSubMenuHelper.show(null);
            return true;
        }
    }

    static class RotationWatcher
    extends IRotationWatcher.Stub {
        private Handler mHandler;
        private final Runnable mRotationChanged = new Runnable(){

            public void run() {
                RotationWatcher.this.dispatchRotationChanged();
            }
        };
        private final ArrayList<WeakReference<PhoneWindow>> mWindows = new ArrayList();
        private boolean mIsWatching;

        RotationWatcher() {
        }

        public void onRotationChanged(int rotation) throws RemoteException {
            this.mHandler.post(this.mRotationChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                if (!this.mIsWatching) {
                    try {
                        WindowManagerHolder.sWindowManager.watchRotation((IRotationWatcher)this);
                        this.mHandler = new Handler();
                        this.mIsWatching = true;
                    }
                    catch (RemoteException ex) {
                        Log.e((String)PhoneWindow.TAG, (String)"Couldn't start watching for device rotation", (Throwable)ex);
                    }
                }
                this.mWindows.add(new WeakReference<PhoneWindow>(phoneWindow));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)((Object)ref.get());
                    if (win == null || win == phoneWindow) {
                        this.mWindows.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchRotationChanged() {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)((Object)ref.get());
                    if (win != null) {
                        win.onOptionsPanelRotationChanged();
                        ++i;
                        continue;
                    }
                    this.mWindows.remove(i);
                }
            }
        }
    }

    private static final class PanelFeatureState {
        int featureId;
        int background;
        int fullBackground;
        int gravity;
        int x;
        int y;
        int windowAnimations;
        DecorView decorView;
        View createdPanelView;
        View shownPanelView;
        MenuBuilder menu;
        IconMenuPresenter iconMenuPresenter;
        ListMenuPresenter listMenuPresenter;
        boolean isCompact;
        int listPresenterTheme;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        boolean isInExpandedMode;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        boolean wasLastExpanded;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        PanelFeatureState(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        public boolean isInListMode() {
            return this.isInExpandedMode || this.isCompact;
        }

        public boolean hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            if (this.isCompact || this.isInExpandedMode) {
                return this.listMenuPresenter.getAdapter().getCount() > 0;
            }
            return ((ViewGroup)this.shownPanelView).getChildCount() > 0;
        }

        public void clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter((MenuPresenter)this.iconMenuPresenter);
                this.menu.removeMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            this.iconMenuPresenter = null;
            this.listMenuPresenter = null;
        }

        void setStyle(Context context) {
            TypedArray a = context.obtainStyledAttributes(R.styleable.Theme);
            this.background = a.getResourceId(46, 0);
            this.fullBackground = a.getResourceId(47, 0);
            this.windowAnimations = a.getResourceId(93, 0);
            this.isCompact = a.getBoolean(224, false);
            this.listPresenterTheme = a.getResourceId(226, 16974580);
            a.recycle();
        }

        void setMenu(MenuBuilder menu) {
            if (menu == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter((MenuPresenter)this.iconMenuPresenter);
                this.menu.removeMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            this.menu = menu;
            if (menu != null) {
                if (this.iconMenuPresenter != null) {
                    menu.addMenuPresenter((MenuPresenter)this.iconMenuPresenter);
                }
                if (this.listMenuPresenter != null) {
                    menu.addMenuPresenter((MenuPresenter)this.listMenuPresenter);
                }
            }
        }

        MenuView getListMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (!this.isCompact) {
                this.getIconMenuView(context, cb);
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(17367136, this.listPresenterTheme);
                this.listMenuPresenter.setCallback(cb);
                this.listMenuPresenter.setId(16908841);
                this.menu.addMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            if (this.iconMenuPresenter != null) {
                this.listMenuPresenter.setItemIndexOffset(this.iconMenuPresenter.getNumActualItemsShown());
            }
            MenuView result = this.listMenuPresenter.getMenuView((ViewGroup)this.decorView);
            return result;
        }

        MenuView getIconMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.iconMenuPresenter == null) {
                this.iconMenuPresenter = new IconMenuPresenter(context);
                this.iconMenuPresenter.setCallback(cb);
                this.iconMenuPresenter.setId(16908840);
                this.menu.addMenuPresenter((MenuPresenter)this.iconMenuPresenter);
            }
            MenuView result = this.iconMenuPresenter.getMenuView((ViewGroup)this.decorView);
            return result;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            savedState.isInExpandedMode = this.isInExpandedMode;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.wasLastExpanded = savedState.isInExpandedMode;
            this.frozenMenuState = savedState.menuState;
            this.createdPanelView = null;
            this.shownPanelView = null;
            this.decorView = null;
        }

        void applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        private static class SavedState
        implements Parcelable {
            int featureId;
            boolean isOpen;
            boolean isInExpandedMode;
            Bundle menuState;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                public SavedState createFromParcel(Parcel in) {
                    return SavedState.readFromParcel(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            private SavedState() {
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                dest.writeInt(this.isInExpandedMode ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            private static SavedState readFromParcel(Parcel source) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                savedState.isOpen = source.readInt() == 1;
                boolean bl = savedState.isInExpandedMode = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle();
                }
                return savedState;
            }
        }
    }

    private static final class DrawableFeatureState {
        final int featureId;
        int resid;
        Uri uri;
        Drawable local;
        Drawable child;
        Drawable def;
        Drawable cur;
        int alpha = 255;
        int curAlpha = 255;

        DrawableFeatureState(int _featureId) {
            this.featureId = _featureId;
        }
    }

    private final class DecorView
    extends FrameLayout
    implements RootViewSurfaceTaker {
        int mDefaultOpacity;
        private final int mFeatureId;
        private final Rect mDrawingBounds;
        private final Rect mBackgroundPadding;
        private final Rect mFramePadding;
        private final Rect mFrameOffsets;
        private boolean mChanging;
        private Drawable mMenuBackground;
        private boolean mWatchingForMenu;
        private int mDownY;
        private ActionMode mActionMode;
        private ActionBarContextView mActionModeView;
        private PopupWindow mActionModePopup;
        private Runnable mShowActionModePopup;

        public DecorView(Context context, int featureId) {
            super(context);
            this.mDefaultOpacity = -1;
            this.mDrawingBounds = new Rect();
            this.mBackgroundPadding = new Rect();
            this.mFramePadding = new Rect();
            this.mFrameOffsets = new Rect();
            this.mFeatureId = featureId;
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            boolean isDown;
            int keyCode = event.getKeyCode();
            int action = event.getAction();
            boolean bl = isDown = action == 0;
            if (isDown && event.getRepeatCount() == 0) {
                boolean handled;
                if (PhoneWindow.this.mPanelChordingKey > 0 && PhoneWindow.this.mPanelChordingKey != keyCode && (handled = this.dispatchKeyShortcutEvent(event))) {
                    return true;
                }
                if (PhoneWindow.this.mPreparedPanel != null && ((PhoneWindow)PhoneWindow.this).mPreparedPanel.isOpen && PhoneWindow.this.performPanelShortcut(PhoneWindow.this.mPreparedPanel, keyCode, event, 0)) {
                    return true;
                }
            }
            if (!PhoneWindow.this.isDestroyed()) {
                boolean handled;
                Window.Callback cb = PhoneWindow.this.getCallback();
                boolean bl2 = handled = cb != null && this.mFeatureId < 0 ? cb.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
                if (handled) {
                    return true;
                }
            }
            return isDown ? PhoneWindow.this.onKeyDown(this.mFeatureId, event.getKeyCode(), event) : PhoneWindow.this.onKeyUp(this.mFeatureId, event.getKeyCode(), event);
        }

        public boolean dispatchKeyShortcutEvent(KeyEvent ev) {
            boolean handled;
            if (PhoneWindow.this.mPreparedPanel != null && (handled = PhoneWindow.this.performPanelShortcut(PhoneWindow.this.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
                if (PhoneWindow.this.mPreparedPanel != null) {
                    ((PhoneWindow)PhoneWindow.this).mPreparedPanel.isHandled = true;
                }
                return true;
            }
            Window.Callback cb = PhoneWindow.this.getCallback();
            boolean bl = handled = cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchKeyShortcutEvent(ev) : super.dispatchKeyShortcutEvent(ev);
            if (handled) {
                return true;
            }
            if (PhoneWindow.this.mPreparedPanel == null) {
                PanelFeatureState st = PhoneWindow.this.getPanelState(0, true);
                PhoneWindow.this.preparePanel(st, ev);
                handled = PhoneWindow.this.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
                st.isPrepared = false;
                if (handled) {
                    return true;
                }
            }
            return false;
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTouchEvent(ev) : super.dispatchTouchEvent(ev);
        }

        public boolean dispatchTrackballEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTrackballEvent(ev) : super.dispatchTrackballEvent(ev);
        }

        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchGenericMotionEvent(ev) : super.dispatchGenericMotionEvent(ev);
        }

        public boolean superDispatchKeyEvent(KeyEvent event) {
            if (super.dispatchKeyEvent(event)) {
                return true;
            }
            if (event.getKeyCode() == 4) {
                int action = event.getAction();
                if (this.mActionMode != null) {
                    if (action == 1) {
                        this.mActionMode.finish();
                    }
                    return true;
                }
                if (PhoneWindow.this.mActionBar != null && PhoneWindow.this.mActionBar.hasExpandedActionView()) {
                    if (action == 1) {
                        PhoneWindow.this.mActionBar.collapseActionView();
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
            return super.dispatchKeyShortcutEvent(event);
        }

        public boolean superDispatchTouchEvent(MotionEvent event) {
            return super.dispatchTouchEvent(event);
        }

        public boolean superDispatchTrackballEvent(MotionEvent event) {
            return super.dispatchTrackballEvent(event);
        }

        public boolean superDispatchGenericMotionEvent(MotionEvent event) {
            return super.dispatchGenericMotionEvent(event);
        }

        public boolean onTouchEvent(MotionEvent event) {
            return this.onInterceptTouchEvent(event);
        }

        private boolean isOutOfBounds(int x, int y) {
            return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            int y;
            int x;
            int action = event.getAction();
            if (this.mFeatureId >= 0 && action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
                PhoneWindow.this.closePanel(this.mFeatureId);
                return true;
            }
            return false;
        }

        public void sendAccessibilityEvent(int eventType) {
            if (!AccessibilityManager.getInstance((Context)this.mContext).isEnabled()) {
                return;
            }
            if ((this.mFeatureId == 0 || this.mFeatureId == 6 || this.mFeatureId == 2 || this.mFeatureId == 5) && this.getChildCount() == 1) {
                this.getChildAt(0).sendAccessibilityEvent(eventType);
            } else {
                super.sendAccessibilityEvent(eventType);
            }
        }

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && !PhoneWindow.this.isDestroyed() && cb.dispatchPopulateAccessibilityEvent(event)) {
                return true;
            }
            return super.dispatchPopulateAccessibilityEvent(event);
        }

        protected boolean setFrame(int l, int t, int r, int b) {
            boolean changed = super.setFrame(l, t, r, b);
            if (changed) {
                Drawable bg;
                Rect drawingBounds = this.mDrawingBounds;
                this.getDrawingRect(drawingBounds);
                Drawable fg = this.getForeground();
                if (fg != null) {
                    Rect frameOffsets = this.mFrameOffsets;
                    drawingBounds.left += frameOffsets.left;
                    drawingBounds.top += frameOffsets.top;
                    drawingBounds.right -= frameOffsets.right;
                    drawingBounds.bottom -= frameOffsets.bottom;
                    fg.setBounds(drawingBounds);
                    Rect framePadding = this.mFramePadding;
                    drawingBounds.left += framePadding.left - frameOffsets.left;
                    drawingBounds.top += framePadding.top - frameOffsets.top;
                    drawingBounds.right -= framePadding.right - frameOffsets.right;
                    drawingBounds.bottom -= framePadding.bottom - frameOffsets.bottom;
                }
                if ((bg = this.getBackground()) != null) {
                    bg.setBounds(drawingBounds);
                }
            }
            return changed;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int min;
            TypedValue tv;
            DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
            boolean isPortrait = metrics.widthPixels < metrics.heightPixels;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int width = this.getMeasuredWidth();
            boolean measure = false;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            TypedValue typedValue = tv = isPortrait ? PhoneWindow.this.mMinWidthMinor : PhoneWindow.this.mMinWidthMajor;
            if (widthMode == Integer.MIN_VALUE && tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels) : 0))) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)min, (int)0x40000000);
                measure = true;
            }
            if (measure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mMenuBackground != null) {
                this.mMenuBackground.draw(canvas);
            }
        }

        public boolean showContextMenuForChild(View originalView) {
            if (PhoneWindow.this.mContextMenu == null) {
                PhoneWindow.this.mContextMenu = new ContextMenuBuilder(this.getContext());
                PhoneWindow.this.mContextMenu.setCallback((MenuBuilder.Callback)PhoneWindow.this.mContextMenuCallback);
            } else {
                PhoneWindow.this.mContextMenu.clearAll();
            }
            MenuDialogHelper helper = PhoneWindow.this.mContextMenu.show(originalView, originalView.getWindowToken());
            if (helper != null) {
                helper.setPresenterCallback((MenuPresenter.Callback)PhoneWindow.this.mContextMenuCallback);
            }
            PhoneWindow.this.mContextMenuHelper = helper;
            return helper != null;
        }

        public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
            return this.startActionMode(callback);
        }

        public ActionMode startActionMode(ActionMode.Callback callback) {
            if (this.mActionMode != null) {
                this.mActionMode.finish();
            }
            ActionModeCallbackWrapper wrappedCallback = new ActionModeCallbackWrapper(callback);
            ActionMode mode = null;
            if (PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                try {
                    mode = PhoneWindow.this.getCallback().onWindowStartingActionMode((ActionMode.Callback)wrappedCallback);
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
            }
            if (mode != null) {
                this.mActionMode = mode;
            } else {
                if (this.mActionModeView == null) {
                    if (PhoneWindow.this.isFloating()) {
                        this.mActionModeView = new ActionBarContextView(this.mContext);
                        this.mActionModePopup = new PopupWindow(this.mContext, null, 16843715);
                        this.mActionModePopup.setLayoutInScreenEnabled(true);
                        this.mActionModePopup.setLayoutInsetDecor(true);
                        this.mActionModePopup.setWindowLayoutType(2);
                        this.mActionModePopup.setContentView((View)this.mActionModeView);
                        this.mActionModePopup.setWidth(-1);
                        TypedValue heightValue = new TypedValue();
                        this.mContext.getTheme().resolveAttribute(16843499, heightValue, true);
                        int height = TypedValue.complexToDimensionPixelSize((int)heightValue.data, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
                        this.mActionModeView.setContentHeight(height);
                        this.mActionModePopup.setHeight(-2);
                        this.mShowActionModePopup = new Runnable(){

                            public void run() {
                                DecorView.this.mActionModePopup.showAtLocation(DecorView.this.mActionModeView.getApplicationWindowToken(), 55, 0, 0);
                            }
                        };
                    } else {
                        ViewStub stub = (ViewStub)this.findViewById(16909027);
                        if (stub != null) {
                            this.mActionModeView = (ActionBarContextView)stub.inflate();
                        }
                    }
                }
                if (this.mActionModeView != null) {
                    this.mActionModeView.killMode();
                    mode = new StandaloneActionMode(this.getContext(), this.mActionModeView, (ActionMode.Callback)wrappedCallback, this.mActionModePopup == null);
                    if (callback.onCreateActionMode(mode, mode.getMenu())) {
                        mode.invalidate();
                        this.mActionModeView.initForMode(mode);
                        this.mActionModeView.setVisibility(0);
                        this.mActionMode = mode;
                        if (this.mActionModePopup != null) {
                            this.post(this.mShowActionModePopup);
                        }
                        this.mActionModeView.sendAccessibilityEvent(32);
                    } else {
                        this.mActionMode = null;
                    }
                }
            }
            if (this.mActionMode != null && PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                try {
                    PhoneWindow.this.getCallback().onActionModeStarted(this.mActionMode);
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
            }
            return this.mActionMode;
        }

        public void startChanging() {
            this.mChanging = true;
        }

        public void finishChanging() {
            this.mChanging = false;
            this.drawableChanged();
        }

        public void setWindowBackground(Drawable drawable) {
            if (this.getBackground() != drawable) {
                this.setBackgroundDrawable(drawable);
                if (drawable != null) {
                    drawable.getPadding(this.mBackgroundPadding);
                } else {
                    this.mBackgroundPadding.setEmpty();
                }
                this.drawableChanged();
            }
        }

        public void setBackgroundDrawable(Drawable d) {
            super.setBackgroundDrawable(d);
            if (this.getWindowToken() != null) {
                this.updateWindowResizeState();
            }
        }

        public void setWindowFrame(Drawable drawable) {
            if (this.getForeground() != drawable) {
                this.setForeground(drawable);
                if (drawable != null) {
                    drawable.getPadding(this.mFramePadding);
                } else {
                    this.mFramePadding.setEmpty();
                }
                this.drawableChanged();
            }
        }

        protected boolean fitSystemWindows(Rect insets) {
            this.mFrameOffsets.set(insets);
            if (this.getForeground() != null) {
                this.drawableChanged();
            }
            return super.fitSystemWindows(insets);
        }

        private void drawableChanged() {
            if (this.mChanging) {
                return;
            }
            this.setPadding(this.mFramePadding.left + this.mBackgroundPadding.left, this.mFramePadding.top + this.mBackgroundPadding.top, this.mFramePadding.right + this.mBackgroundPadding.right, this.mFramePadding.bottom + this.mBackgroundPadding.bottom);
            this.requestLayout();
            this.invalidate();
            int opacity = -1;
            Drawable bg = this.getBackground();
            Drawable fg = this.getForeground();
            if (bg != null) {
                if (fg == null) {
                    opacity = bg.getOpacity();
                } else if (this.mFramePadding.left <= 0 && this.mFramePadding.top <= 0 && this.mFramePadding.right <= 0 && this.mFramePadding.bottom <= 0) {
                    int fop = fg.getOpacity();
                    int bop = bg.getOpacity();
                    opacity = fop == -1 || bop == -1 ? -1 : (fop == 0 ? bop : (bop == 0 ? fop : Drawable.resolveOpacity((int)fop, (int)bop)));
                } else {
                    opacity = -3;
                }
            }
            this.mDefaultOpacity = opacity;
            if (this.mFeatureId < 0) {
                PhoneWindow.this.setDefaultWindowFormat(opacity);
            }
        }

        public void onWindowFocusChanged(boolean hasWindowFocus) {
            Window.Callback cb;
            super.onWindowFocusChanged(hasWindowFocus);
            if (!hasWindowFocus && PhoneWindow.this.mPanelChordingKey != 0) {
                PhoneWindow.this.closePanel(0);
            }
            if ((cb = PhoneWindow.this.getCallback()) != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0) {
                cb.onWindowFocusChanged(hasWindowFocus);
            }
        }

        void updateWindowResizeState() {
            Drawable bg = this.getBackground();
            this.hackTurnOffWindowResizeAnim(bg == null || bg.getOpacity() != -1);
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.updateWindowResizeState();
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0) {
                cb.onAttachedToWindow();
            }
            if (this.mFeatureId == -1) {
                PhoneWindow.this.openPanelsAfterRestore();
            }
        }

        protected void onDetachedFromWindow() {
            PanelFeatureState st;
            super.onDetachedFromWindow();
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && this.mFeatureId < 0) {
                cb.onDetachedFromWindow();
            }
            if (PhoneWindow.this.mActionBar != null) {
                PhoneWindow.this.mActionBar.dismissPopupMenus();
            }
            if (this.mActionModePopup != null) {
                this.removeCallbacks(this.mShowActionModePopup);
                if (this.mActionModePopup.isShowing()) {
                    this.mActionModePopup.dismiss();
                }
                this.mActionModePopup = null;
            }
            if ((st = PhoneWindow.this.getPanelState(0, false)) != null && st.menu != null && this.mFeatureId < 0) {
                st.menu.close();
            }
        }

        public void onCloseSystemDialogs(String reason) {
            if (this.mFeatureId >= 0) {
                PhoneWindow.this.closeAllPanels();
            }
        }

        public SurfaceHolder.Callback2 willYouTakeTheSurface() {
            return this.mFeatureId < 0 ? PhoneWindow.this.mTakeSurfaceCallback : null;
        }

        public InputQueue.Callback willYouTakeTheInputQueue() {
            return this.mFeatureId < 0 ? PhoneWindow.this.mTakeInputQueueCallback : null;
        }

        public void setSurfaceType(int type) {
            PhoneWindow.this.setType(type);
        }

        public void setSurfaceFormat(int format) {
            PhoneWindow.this.setFormat(format);
        }

        public void setSurfaceKeepScreenOn(boolean keepOn) {
            if (keepOn) {
                PhoneWindow.this.addFlags(128);
            } else {
                PhoneWindow.this.clearFlags(128);
            }
        }

        private class ActionModeCallbackWrapper
        implements ActionMode.Callback {
            private ActionMode.Callback mWrapped;

            public ActionModeCallbackWrapper(ActionMode.Callback wrapped) {
                this.mWrapped = wrapped;
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                return this.mWrapped.onCreateActionMode(mode, menu);
            }

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return this.mWrapped.onPrepareActionMode(mode, menu);
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return this.mWrapped.onActionItemClicked(mode, item);
            }

            public void onDestroyActionMode(ActionMode mode) {
                this.mWrapped.onDestroyActionMode(mode);
                if (DecorView.this.mActionModePopup != null) {
                    DecorView.this.removeCallbacks(DecorView.this.mShowActionModePopup);
                    DecorView.this.mActionModePopup.dismiss();
                } else if (DecorView.this.mActionModeView != null) {
                    DecorView.this.mActionModeView.setVisibility(8);
                }
                if (DecorView.this.mActionModeView != null) {
                    DecorView.this.mActionModeView.removeAllViews();
                }
                if (PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                    try {
                        PhoneWindow.this.getCallback().onActionModeFinished(DecorView.this.mActionMode);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
                DecorView.this.mActionMode = null;
            }
        }
    }

    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        private ActionMenuPresenterCallback() {
        }

        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null) {
                cb.onMenuOpened(8, (Menu)subMenu);
                return true;
            }
            return false;
        }

        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            PhoneWindow.this.checkCloseActionMenu((Menu)menu);
        }
    }

    private class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        private PanelMenuPresenterCallback() {
        }

        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu.getRootMenu();
            boolean isSubMenu = parentMenu != menu;
            PanelFeatureState panel = PhoneWindow.this.findMenuPanel((Menu)(isSubMenu ? parentMenu : menu));
            if (panel != null) {
                if (isSubMenu) {
                    PhoneWindow.this.callOnPanelClosed(panel.featureId, panel, (Menu)parentMenu);
                    PhoneWindow.this.closePanel(panel, true);
                } else {
                    PhoneWindow.this.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb;
            if (subMenu == null && PhoneWindow.this.hasFeature(8) && (cb = PhoneWindow.this.getCallback()) != null && !PhoneWindow.this.isDestroyed()) {
                cb.onMenuOpened(8, (Menu)subMenu);
            }
            return true;
        }
    }

    static class WindowManagerHolder {
        static final IWindowManager sWindowManager = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));

        WindowManagerHolder() {
        }
    }
}

